DROP TABLE IF EXISTS `xp_article`;
CREATE TABLE `xp_article` (
  `aid` int(5) NOT NULL auto_increment COMMENT '文章ID',
  `atype` int(5) NOT NULL COMMENT '文章类型',
  `atitle` varchar(25) NOT NULL COMMENT '文章标题',
  `aimg` varchar(100) NOT NULL COMMENT '文章图片',
  `adate` datetime NOT NULL COMMENT '发表时间',
  `apv` int(10) NOT NULL COMMENT '浏览量',
  `ainfo` varchar(50) NOT NULL COMMENT '文章简介',
  `akey` varchar(50) NOT NULL COMMENT '关键字',
  `atop` int(10) NOT NULL COMMENT '置顶值',
  `acontent` mediumtext NOT NULL COMMENT '文章内容',
  PRIMARY KEY  (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_block`;
CREATE TABLE `xp_block` (
  `bid` int(5) NOT NULL auto_increment COMMENT '区块ID',
  `bcode` text NOT NULL COMMENT '代码块',
  `binfo` varchar(50) NOT NULL COMMENT '注释',
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_comment`;
CREATE TABLE `xp_comment` (
  `cid` int(5) NOT NULL auto_increment COMMENT '评论ID',
  `ctarget` int(5) NOT NULL COMMENT '评论目标',
  `cname` varchar(20) NOT NULL COMMENT '评论人',
  `cdate` datetime NOT NULL COMMENT '发表时间',
  `ccontent` text NOT NULL COMMENT '评论内容',
  `cverify` int(1) NOT NULL COMMENT '状态',
  `creply` varchar(100) NOT NULL,
  `cip` varchar(15) NOT NULL COMMENT '来源IP',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_diary`;
CREATE TABLE `xp_diary` (
  `did` int(5) NOT NULL auto_increment COMMENT '日记ID',
  `dcontent` text character set utf8 collate utf8_unicode_ci NOT NULL COMMENT '日记内容',
  `dtime` datetime NOT NULL COMMENT '发表时间',
  `dweather` varchar(10) NOT NULL COMMENT '天气',
  PRIMARY KEY  (`did`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_link`;
CREATE TABLE `xp_link` (
  `lid` int(5) NOT NULL auto_increment COMMENT '链接ID',
  `lsort` int(3) NOT NULL default '999' COMMENT '排序值',
  `lname` varchar(10) NOT NULL COMMENT '链接名称',
  `lsite` varchar(100) NOT NULL COMMENT '链接网站',
  `linfo` varchar(25) NOT NULL COMMENT '链接信息',
  `ldate` datetime NOT NULL COMMENT '添加时间',
  `lverify` int(1) NOT NULL COMMENT '链接状态',
  PRIMARY KEY  (`lid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_message`;
CREATE TABLE `xp_message` (
  `mid` int(5) NOT NULL auto_increment COMMENT '留言ID',
  `mname` varchar(10) NOT NULL COMMENT '留言人',
  `mhead` varchar(2) NOT NULL COMMENT '头像图标',
  `mcontact` varchar(15) NOT NULL COMMENT '联系方式',
  `murl` varchar(50) NOT NULL COMMENT '主页链接',
  `mdate` datetime NOT NULL COMMENT '留言时间',
  `mcontent` text NOT NULL COMMENT '留言内容',
  `mip` varchar(15) NOT NULL COMMENT '来源IP',
  `mre` text NOT NULL COMMENT '我的回复',
  `mverify` int(1) NOT NULL COMMENT '留言状态',
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_music`;
CREATE TABLE `xp_music` (
  `mid` int(5) NOT NULL auto_increment COMMENT '音乐ID',
  `mtype` varchar(5) NOT NULL COMMENT '音乐分类',
  `msign` int(1) NOT NULL COMMENT '音乐类型',
  `msinger` varchar(20) NOT NULL COMMENT '歌手名',
  `mname` varchar(50) NOT NULL COMMENT '歌名',
  `madder` varchar(10) NOT NULL COMMENT '添加者',
  `murl` text NOT NULL COMMENT '音乐地址',
  `mtop` int(10) NOT NULL COMMENT '排序值',
  `mdate` date NOT NULL COMMENT '添加时间',
  `mverify` int(1) NOT NULL COMMENT '音乐状态',
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_photo`;
CREATE TABLE `xp_photo` (
  `pid` int(5) NOT NULL auto_increment COMMENT '图片ID',
  `ptype` int(5) NOT NULL COMMENT '图片分类',
  `purl` varchar(100) NOT NULL COMMENT '图片地址',
  `pname` varchar(10) NOT NULL COMMENT '图片名称',
  `pinfo` varchar(25) NOT NULL COMMENT '图片说明',
  `pdate` date NOT NULL COMMENT '添加时间',
  `plink` varchar(200) NOT NULL COMMENT '指向链接',
  `ptop` int(10) NOT NULL COMMENT '排序值',
  PRIMARY KEY  (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_slide`;
CREATE TABLE `xp_slide` (
  `sid` int(5) NOT NULL auto_increment COMMENT '幻灯片ID',
  `simg` varchar(150) NOT NULL COMMENT '幻灯片图片',
  `surl` varchar(150) NOT NULL COMMENT '链接地址',
  `sinfo` varchar(50) NOT NULL COMMENT '幻灯说明',
  `sstate` varchar(1) NOT NULL COMMENT '状态',
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_system`;
CREATE TABLE `xp_system` (
  `id` int(2) NOT NULL COMMENT 'ID',
  `webname` varchar(50) NOT NULL COMMENT '网站名',
  `weburl` varchar(50) NOT NULL COMMENT '网站地址',
  `webinfo` varchar(200) NOT NULL COMMENT '网站简介',
  `webkey` varchar(200) NOT NULL COMMENT '网站关键字',
  `adminacc` varchar(12) NOT NULL COMMENT '管理员账号',
  `adminpass` varchar(80) NOT NULL COMMENT '管理员密码',
  `adminmail` varchar(50) NOT NULL COMMENT '管理员邮箱',
  `webicp` varchar(30) NOT NULL COMMENT 'ICP备案号',
  `logourl` varchar(150) NOT NULL COMMENT 'Logo地址',
  `downurl` varchar(255) NOT NULL COMMENT '下载地址',
  `downnum` int(8) NOT NULL COMMENT '下载次数',
  `version` varchar(10) NOT NULL COMMENT '版本号',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `adminacc` (`adminacc`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_theme`;
CREATE TABLE `xp_theme` (
  `tid` int(2) NOT NULL auto_increment COMMENT '主题ID',
  `tname` varchar(20) NOT NULL COMMENT '主题名',
  `timg` varchar(150) NOT NULL COMMENT '主题图片',
  `tdir` varchar(50) NOT NULL COMMENT '主题目录',
  `tstate` int(1) NOT NULL COMMENT '主题状态',
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_type`;
CREATE TABLE `xp_type` (
  `tid` int(2) NOT NULL auto_increment COMMENT '分类ID',
  `ttype` int(2) NOT NULL COMMENT '分类类型',
  `tname` varchar(20) NOT NULL COMMENT '分类名称',
  `tkey` varchar(50) NOT NULL COMMENT '分类关键字',
  `tinfo` varchar(50) NOT NULL COMMENT '分类描述',
  `tsort` int(2) NOT NULL COMMENT '显示顺序',
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `xp_video`;
CREATE TABLE `xp_video` (
  `vid` int(5) NOT NULL auto_increment COMMENT '视频ID',
  `vtype` int(2) NOT NULL COMMENT '视频分类',
  `vadder` varchar(16) NOT NULL COMMENT '视频添加者',
  `vsign` varchar(1) NOT NULL default '0' COMMENT '视频类型',
  `vimg` varchar(255) NOT NULL COMMENT '视频图片',
  `vname` varchar(50) NOT NULL COMMENT '视频标题',
  `vinfo` varchar(150) NOT NULL COMMENT '视频简介',
  `vurl` varchar(255) NOT NULL COMMENT '视频URL',
  `vtop` varchar(10) NOT NULL default '0' COMMENT '置顶值',
  `vverify` int(1) NOT NULL COMMENT '视频状态',
  PRIMARY KEY  (`vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `xp_block` VALUES ('1','<a href=\"#\">XPCMS 1.5正式发布，欢迎下载使用！</a>','位置代码');
INSERT INTO `xp_block` VALUES ('4','<a target=\"_blank\" href=\"#\"><img src=\"/xpcms/Public/Images/admin_head.png\" /></a>\r\n<div class=\"line\"><a href=\"#\" class=\"more\">查看更多</a>站长日记 </div>\r\n<div class=\"line\">站长QQ：378417067 | 交流群：22528248</div>\r\n<div class=\"line\">我的博客：<a target=\"_blank\" href=\"http://blog.csdn.net/xp_zhu\">CSDN博客</a> | <a target=\"_blank\" href=\"#\">新浪微博</a></div>\r\n','站长日记');
INSERT INTO `xp_block` VALUES ('2','广告块','右侧广告');
INSERT INTO `xp_block` VALUES ('3','<script src=\"http://s15.cnzz.com/stat.php?id=2323615&web_id=2323615\" language=\"JavaScript\"></script>','底部统计');
INSERT INTO `xp_block` VALUES ('5','XPCMS 1.5下载','首页广告');
