<?php
class FileManager {
	var $dirs = null;
	var $files = null;

	function FileManager() {
	}

	/**
	 * 得到目录或文件的详细信息
	 */
	function getFileInf($file) {
		$file_inf['modify'] = date('Y-m-d H:i:s', filemtime($file));
		if (is_dir($file)) { // 针对windows系统上获取目录的大小
			//			if (stripos(PHP_OS, 'win') !== false) {
			//				$obj = new COM('scripting.filesystemobject');
			//				if (is_object($obj)) {
			//					$ref = $obj->getfolder($file);
			//					$file_size = $ref->size;
			//					unset ($obj);
			//				}
			//			} else { // 针对linix系统上获取目录的大小
			//				$io = popen('usr/bin/du -sk ' . $file, 'r');
			//				$size = fgets($io, 4096);
			//				$file_size = substr($size, 0, strpos($size, ' '));
			//				pclose($io);
			//			}
			$file_inf['size'] = '&nbsp;';
			return $file_inf;
		} else {
			$file_size = filesize($file);
		}

		if ($file_size < 1024) {
			$file_size .= 'Byte';
		}
		elseif ($file_size < 1048576) {
			$file_size = round($file_size / (1024), 1) . 'KB';
		}
		elseif ($file_size < 1073741824) {
			$file_size = round($file_size / 1048576, 1) . 'MB';
		} else {
			$file_size = round($file_size / 1073741824, 1) . 'GB';
		}
		$file_inf['size'] = $file_size;
		return $file_inf;
	}

	/**
	 * 判断文件的格式,匹配响应的文件图片,组成链接
	 * 
	 * @param datatype $dir 目录
	 * @param datatype $file 文件
	 * @param datatype $activePath 上一级目录
	 * @param datatype $target 文件类型(目录或文件)
	 * @return string
	 */
	function getFileIco($dir, $file, $activePath, $target, & $getActionPath) {
		$action_names = array (
			'edit' => '编辑',
			'rename' => '改名',
			'del' => '删除',
			'move' => '移动'
		);
		$file_text = '<a href="' . $activePath . '/' . $file . '"';
		$a_target = ' target="_blank" ';
		if ($target == 'dirs') {
			$file_text = '<a href="index.php?activepath=' . urlencode($activePath . '/' . $file) . '"';
			$a_target = '';
			$img = 'dir';
			unset ($action_names['edit'], $action_names['move']);
		}
		elseif (eregi('\.(gif|png)', $file)) {
			$img = 'gif';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(jpg)', $file)) {
			$img = 'jpg';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(swf|fla|fly)', $file)) {
			$img = 'flash';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(zip|rar|tar.gz)', $file)) {
			$img = 'zip';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(exe)', $file)) {
			$img = 'exe';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(mp3|wma)', $file)) {
			$img = 'mp3';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(wmv|api)', $file)) {
			$img = 'wmv';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(rm|rmvb)', $file)) {
			$img = 'rm';
			unset ($action_names['edit']);
		}
		elseif (eregi('\.(txt|inc|pl|cgi|asp|xml|xsl|aspx|cfm|sql|ini)', $file)) {
			$img = 'txt';
		}
		elseif (eregi('\.(htm|html)', $file)) {
			$img = 'htm';
		}
		elseif (eregi('\.(php)', $file)) {
			$img = 'php';
		}
		elseif (eregi('\.(js)', $file)) {
			$img = 'js';
		}
		elseif (eregi('\.(css)', $file)) {
			$img = 'css';
		} else {
			$img = '';
			unset ($action_names['edit']);
		}
		$img_text = empty ($img) ? '' : '<img src="img/' . $img . '.gif" border=0 width=16 height=16 align=absmiddle>';
		$file_text .= $a_target . '>' . $img_text . $file . '</a>';

		$action_text = '<a href="action/?filename=' . urlencode($file) . '&activepath=' . urlencode($activePath) . '&action=';
		foreach ($action_names as $key => $val) {
			$getActionPath .= $action_text . urlencode($key) . '">[' . $val . ']</a>&nbsp;';
		}

		return $file_text;
	}

	/**
	 * 获取指定文件夹下的所有文件
	 * 
	 * @param string $dir 指定的目录
	 * @return string 返回由目录和文件组成字符串
	 */
	function getDirFiles($active_path) {
		$dir = CFG_BASEDIR . '/' . $active_path;
		$dir_handle = opendir($dir);
		while ($file = readdir($dir_handle)) {
			if ($file == '.') {
				continue;
			}
			elseif ($file == '..') {
				if ($active_path == '')
					continue;
				$this->dirs .= '<tr><td class="linerow"><a href=index.php?activepath=' . urlencode(eregi_replace('[/][^/]*$', '', $active_path)) . '><img src="img/dir2.gif" border=0 width=16 height=16 align=absmiddle>上级目录</a></td>
										        <td colspan="3" class="linerow">当前目录:' . $active_path . ' &nbsp;</td></tr>';//<a href="file_pic_view.php?activepath=' . urlencode($active_path) . '" style="color:red">[图片浏览器]</a>
				continue;
			}
			elseif (is_dir($dir . '/' . $file)) {
				if (eregi('^_(.*)$', $file) || eregi('^\.(.*)$', $file))
					continue;
				$target = 'dirs';
			} else {
				$target = 'files';
			}
			$getActionPath = '';
			$file_info = $this->getFileInf($dir . '/' . $file);
			$this-> {
				$target }
			.= '<tr bgcolor="#FFFFFF" onMouseMove="this.bgColor=\'#95B3D7\';" onMouseOut="this.bgColor=\'#FFFFFF\';">
								               <td class="linerow">' . $this->getFileIco($dir, $file, $active_path, $target, $getActionPath) . '</td>
			                                   <td class="linerow">' . $file_info['size'] . '</td>
			   							       <td class="linerow" align="center">' . $file_info['modify'] . '</td>
			                                   <td class="linerow">' . $getActionPath . '</td>
			                                 </tr>
			                                 ';
		}
		closedir($dir_handle);
		return $this->dirs . $this->files;
	}

	/**
	 * 文件重命名
	 */
	function fileRename($oldfilename, $newfilename) {
		if ($oldfilename != $newfilename && is_writable($oldfilename)) {
			$is_writer = rename($oldfilename, $newfilename);
		}
		return $is_writer;
	}

	/**
	 * 删除目录
	 */
	function dirDelete($dir) {
		if (!is_dir($dir)) {
			return null;
		}
		$dir_obj = dir($dir);
		while ($file = $dir_obj->read()) {
			if ($file == '.' || $file == '..') {
				continue;
			}
			elseif (is_file($dir . '/' . $file)) {
				unlink($dir . '/' . $file);
			} else {
				$this->dirDelete($dir . '/' . $file);
			}
		}
		$dir_obj->close();
		rmdir($dir);
	}

	/**
	 * 文件删除
	 */
	function fileDelete($filename) {
		if (is_file($filename)) {
			unlink($filename);
			$t = '文件';
		} else {
			$this->dirDelete($filename);
			$t = '目录';
		}
		return $t;
	}

	/**
	 * 文件编辑
	 */
	function fileEdit($filename, $content) {
		$content = stripslashes($content);
		$fo = fopen($filename, 'w');
		fwrite($fo, $content);
		fclose($fo);
		return true;
	}

	/**
	 * 文件移动
	 */
	function fileMove($filename, $activepath, $newpath) {
		if ($newpath != '' && !ereg('\.\.', $newpath)) {
			$oldfile = CFG_BASEDIR . $activepath . '/' . $filename;
			if (!ereg('^/', $newpath)) {
				$newpath = $activepath . '/' . $newpath;
			}
			$newpath = CFG_BASEDIR . $newpath.'/';
			if (is_readable($oldfile) && is_readable($newpath) && is_writable($newpath)) {
				if (copy($oldfile, $newpath . '/' . $filename)) {
					return unlink($oldfile);
				}
			} else {
				return '2';
			}
		} else {
			return '3';
		}
	}
	
	/**
	 * 创建一个新目录
	 */
	function makeDir($activepath, $newpath){
		$path = CFG_BASEDIR.$activepath;
		if(is_writable($path)){
			$path .= '/'.$newpath;
			$m = mkdir($path, 0777);
			chmod($path, 0777);
			return $m;
		}
		return false;
	}
	
	/**
	 * 上传多个文件
	 */
	function uploadFiles($patram_name, $content_path){
		$count = 0;
		for($i=1; $i<=20; $i++){
			$input_name = $patram_name.$i;
			if(!isset($input_name)){
				continue;
			}
			$tmp_name = $_FILES[$input_name]['tmp_name'];
			$file_name = $_FILES[$input_name]['name'];
			// 检查文件是否通过HTTP POST上传
			if(is_uploaded_file($tmp_name)){
				if(!file_exists($content_path.$file_name)){
					move_uploaded_file($tmp_name, $content_path.$file_name);
					$count ++;
				}
			}			
		}
		return $count;
	}
	
	/**
	 * 检测一个目录有多少个字节
	 */
	function checkDirSize($dir, &$total_size) {
		$handle_dir = opendir($dir);
		while($file=readdir($handle_dir)) {
			$file_name = $dir.'/'.$file;
			if(ereg('^\.', $file)) {
				continue;
			} elseif(is_dir($file_name)) {
				$this->checkDirSize($file_name, $total_size);
			} else {
				$total_size = $total_size + filesize($file_name); 
			}
		}
	}
	
	/**
	 * 计算单位为kb大小的文件
	 */
	function setKb($size) {
		return round($size/1024,1);
	}
	
	/**
	 * 计算单位为mb大小的文件
	 */
	function setMb($size) {
		return round($size/1024/1024, 2);
	}
}
?>