<?php
function is_utf8($string) {
	// From http://w3.org/International/questions/qa-forms-utf-8.html
	return preg_match('%^(?:
	[\x09\x0A\x0D\x20-\x7E] # ASCII
	| [\xC2-\xDF][\x80-\xBF] # non-overlong 2-byte
	| \xE0[\xA0-\xBF][\x80-\xBF] # excluding overlongs
	| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2} # straight 3-byte
	| \xED[\x80-\x9F][\x80-\xBF] # excluding surrogates
	| \xF0[\x90-\xBF][\x80-\xBF]{2} # planes 1-3
	| [\xF1-\xF3][\x80-\xBF]{3} # planes 4-15
	| \xF4[\x80-\x8F][\x80-\xBF]{2} # plane 16
	)*$%xs', $string);
}

/**
 * 获取当前脚本文件名称
 */
function getCurUrl() {
	if (!empty ($_SERVER['REQUEST_URI'])) {
		$script_url = $_SERVER['REQUEST_URI'];
	} else {
		$script_url = $_SERVER['PHP_SELF'];
		if (!empty ($_SERVER['REQUEST_STRING'])) {
			$script_url .= '?' . $_SERVER['REQUEST_STRING'];
		}
	}
	return $script_url;
}

/**
 * 为特殊字符进行转义
 */
function runMagicQuote(& $vars) {
	if (!get_magic_quotes_gpc()) {
		if (is_array($vars)) {
			foreach ($vars as $k => $v)
				$vars[$k] = runMagicQuote($v);
		} else {
			$vars = addslashes($vars);
		}
	}
	return $vars;
}

function showMsg($msg, $gourl, $onlymsg = 0, $limittime = 0) {
	if (empty ($GLOBALS['cfg_phpurl'])) {
		$GLOBALS['cfg_phpurl'] = '..';
	}
	$htmlhead = "<html>\r\n<head>\r\n<title>提示信息</title>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=gb2312\" />\r\n";
	$htmlhead .= "<base target='_self'/>\r\n<style>div{line-height:160%;}</style></head>\r\n<body leftmargin='0' topmargin='0'>\r\n<center>\r\n<script>\r\n";
	$htmlfoot = "</script>\r\n</center>\r\n</body>\r\n</html>\r\n";

	if ($limittime == 0) {
		$litime = 1000;
	} else {
		$litime = $limittime;
	}

	if ($gourl == "-1") {
		if ($limittime == 0) {
			$litime = 5000;
		}
		$gourl = "javascript:history.go(-1);";
	}

	if ($gourl == '' || $onlymsg == 1) {
		$msg = "<script>alert(\"" . str_replace("\"", "“", $msg) . "\");</script>";
	} else {
		$func = "      var pgo=0;
						      function JumpUrl(){
						        if(pgo==0){ location='$gourl'; pgo=1; }
						      }\r\n";
		$rmsg = $func;
		$rmsg .= "document.write(\"<br /><div style='width:450px;padding:0px;border:1px solid #B0D4FB;'>";
		$rmsg .= "<div style='padding:6px;font-size:12px;border-bottom:1px solid #D1DDAA;background:#DBEEBD url({$GLOBALS['cfg_phpurl']}/img/wbg.gif)';'><b> 提示信息！</b></div>\");\r\n";
		$rmsg .= "document.write(\"<div style='height:130px;font-size:10pt;background:#ffffff'><br />\");\r\n";
		$rmsg .= "document.write(\"" . str_replace("\"", "“", $msg) . "\");\r\n";
		$rmsg .= "document.write(\"";
		if ($onlymsg == 0) {
			if ($gourl != "javascript:;" && $gourl != "") {
				$rmsg .= "<br /><a href='{$gourl}'>如果你的浏览器没反应，请点击这里...</a>";
			}
			$rmsg .= "<br/></div>\");\r\n";
			if ($gourl != "javascript:;" && $gourl != '') {
				$rmsg .= "setTimeout('JumpUrl()',$litime);";
			}
		} else {
			$rmsg .= "<br/><br/></div>\");\r\n";
		}
		$msg = $htmlhead . $rmsg . $htmlfoot;
	}
	echo $msg;
}
?>