<?php
include dirname(__FILE__) . '/include/config.inc.php';
$fm = new FileManager();
$content_path = empty ($activepath) ? CFG_BASEDIR : CFG_BASEDIR . $activepath;
$content_path .= '/';
if (!empty ($action)) {
	$cfg_plus_dir = '..';
	$php_self = $_SERVER['PHP_SELF'];
	switch ($action) {
		case 'rename' :
			$fm->fileRename($content_path . $oldfilename, $content_path . $newfilename);
			showMsg('成功更改一个文件名!', $php_self . '?activepath=' . $activepath);
			break;

		case 'del' :
			if(empty($filename)){
				showMsg('文件名不能为空!', $php_self . '?activepath=' . $activepath);
			}else{
				$t = $fm->fileDelete($content_path . $filename);
				showMsg("成功删除一个$t!", $php_self . '?activepath=' . $activepath);
			}
			break;

		case 'edit' :
			$fm->fileEdit($content_path . $filename, $content);
			showMsg('成功保存一个文件!', $php_self . '?activepath=' . $activepath);
			break;

		case 'move' :
			$s = $fm->fileMove($filename, $activepath, $newpath);
			if ($s === '3') {
				showMsg('对不起,您移动的路径不合法!', '-1');
			}
			elseif ($s === '2') {
				showMsg("移动文件 $filename -&gt; $newpath 失败,可能是某个位置权限不足!", $php_self . '?activepath=' . $activepath, 0, 1000);
			} else {
				showMsg('成功移动文件!', $php_self . '?activepath=' . $activepath, 0, 3000);
			}
			break;
		
		case 'newdir':
			 $bool = $fm->makeDir($activepath, $newpath);
			 if($bool) {
			 	showMsg('成功创建一个新目录!', $php_self . '?activepath=' . $activepath.'/'.$newpath);
			 } else {
			 	showMsg('创建新目录失败，因为这个位置不允许写入!', $php_self . '?activepath=' . $activepath);
			 }
			 break;
			 
		case 'upload':
			 $upload_num = $fm->uploadFiles('upfile', $content_path);
			 ShowMsg("成功上传 $upload_num 个文件到: $activepath","$php_self?activepath=$activepath");
			 break;
	}
	exit;
}

$files = $fm->getDirFiles($activepath);
$activepath = urlencode($activepath);
?>
<html>
<head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
<title>文件管理器</title>
<link href='img/base.css' rel='stylesheet' type='text/css'>
<style>
.linerow{border-bottom: 1px solid #B0D4FB;height:24px}
</style>
</head>
<body>
<table width='100%' border='0' align='center' cellpadding='2' cellspacing='0'>
<tr bgcolor="#ccc" height="28" align="center">
  <td width="28%" background="img/wbg.gif" class='linerow'><strong>文件名</strong></td>
  <td width="16%" class='linerow' background="img/newlinebg3.gif"><strong>文件大小</strong></td>
  <td width="22%" background="img/wbg.gif" class='linerow'><strong>最后修改时间</strong></td>
  <td width="34%" class='linerow' background="img/newlinebg3.gif"><strong>操作</strong></td>
</tr>
<?php echo $files; ?>
<tr>
  <td colspan="4" height='26' bgcolor='#B0D4FB'>
  	<a href='<?php echo $_SERVER['PHP_SELF']; ?>'>[根目录]</a>
  	&nbsp;
  	<a href='action/?action=newfile&activepath=<?php echo $activepath; ?>'>[新建文件]</a>
  	&nbsp;
  	<a href='action/?action=newdir&activepath=<?php echo $activepath; ?>'>[新建目录]</a>
  	&nbsp;
  	<a href='action/?action=upload&activepath=<?php echo $activepath; ?>'>[文件上传]</a>
  	&nbsp;
  	<a href='action/?action=space&activepath=<?php echo $activepath; ?>'>[空间检查]</a>
  	&nbsp;&nbsp;</td>
</tr>
</table>

</body>
</html>
</body>
</html>