<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		common.inc.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * services@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev: 772 $
 */
 
/* $Id: common.inc.php 772 2010-03-08 13:36:54Z hukuizhi $ */ 

/**
 * 我的账户commom
 */

// Load EXCMS common.inc.php
require_once ('../configuration/inc/common.inc.php');

// load account config
loadModuleConfig('account',true);

// is enabled account
if(!$EXCMS_MODULE['account']['enabled']){
	EXCMS::page404('系统尚未开启帐户功能');exit;
}
// define EXCMS Account Path
define('EXCMS_ACCOUNT', str_replace('\\', '/', dirname(__FILE__)) . '/');

// 使用反斜线引用字符串
if (!get_magic_quotes_gpc()){
    $_POST = addslashes_deep($_POST);
    $_GET = addslashes_deep($_GET);
}


// cross domain clallback
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}

// is ajax request
$ajax = $_POST['ajax'] || $_GET['ajax'];

// ajax 编码处理
if($ajax && CHARSET != JSON_CHARSET){
	$_POST = EXCMS::iconv_all(JSON_CHARSET, CHARSET, $_POST);
}

// ajax login
if($ajax && isset($_GET['ajaxlogin']) && $_GET['ajaxlogin'] == 100){
	if($crossDomainCallback){
		ob_start();
		EXCMS::display('account/ajaxlogin.html');
		$contents = ob_get_contents();
		ob_clean();
		echo $crossDomainCallback . "(\"" . addslashes(str_replace(array(chr(13), chr(10)), '', $contents)) . "\")";
	}else{
		EXCMS::display('account/ajaxlogin.html');
	}
	exit;
}

$action = $_POST['action'] ? $_POST['action'] : $_GET['action'];

if($action == 'verifycode'){
	session_start();
	include_once LIB_PATH . 'util/CheckCode.class.php';
	$cc = new CheckCode();
	$cc->show();
	exit;
}

// load User class and creat user object
include_once LIB_MODULES_PATH . 'account/User.class.php';
$userObj = new User();

// check user logined
if(!$userObj->isLogin()){
	if($ajax){
		$json = EXCMS::jsonencode(array('success' => -1, 'message' => 'Login time out'));
		if($crossDomainCallback){
			echo $crossDomainCallback . "({$json});";
		}else{
			echo $json;
		}
	}else{
		$forward = $action == 'logout' ? '' : urlencode("http://".$_SERVER['SERVER_NAME'].($_SERVER['SERVER_PORT']==80 ? '' : (':'.$_SERVER['SERVER_PORT'])).$_SERVER['REQUEST_URI']);
		header('location:' . EXCMS::url(array('name' => 'account.login','forward'=>$forward)));	
	}
	exit;
}

// set $_PAGE_USER
$_PAGE_USER = $userObj->getSession();

// set session user id
define('EXCMS_ACCOUNT_UID', $_PAGE_USER['uid']);
define('EXCMS_ACCOUNT_UNUMBER', $_PAGE_USER['unumber']);

$_PAGE['name'] = basename($_SERVER['SCRIPT_NAME']);
$_PAGE['name'] = substr($_PAGE['name'], 0, strrpos($_PAGE['name'], '.'));
$_PAGE['sessionid'] = $userObj->getSessionId();


// set current userid
$uid = $_PAGE_USER['uid'];

// end excms file