<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		profile.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * services@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev: 772 $
 */
/* $Id: profile.php 772 2010-03-08 13:36:54Z hukuizhi $ */
/**
 * 我的帐户信息
 */
// load account common
require_once ('common.inc.php');
// Get action
$action = $_POST['action'] ? $_POST['action'] : $_GET['action'];
// url params
$_PAGE['model'] = $_GET['model'];
$_PAGE['channelid'] = $_GET['channelid'];
$_PAGE['crossid'] = $_GET['crossid'];
$_PAGE['check'] = $_GET['check'];
$_PAGE['keywords'] = urldecode($_GET['k']);
$_PAGE['pageon'] = $_GET['page'];
switch($action){
	case 'delete' :
		$_PAGE['forwordurl'] = EXCMS::url(array('name' => 'account.content'));
		$_PAGE['success'] = 1;
		$_PAGE['actiontitle'] = "删除稿件";
		$_PAGE['actioncontent'] = "删除稿件成功";
		$contentid = $_POST['contentid'] ? $_POST['contentid'] : $_GET['contentid'];
		$rs = $userObj->delContent($uid, $contentid);
		if($rs === false){
			$_PAGE['actionsuccess'] = 0;
			$_PAGE['actioncontent'] = "删除稿件失败:" . getLangByName($userObj->getMessage());
		}elseif($rs === null){
			$_PAGE['actioncontent'] = "找不到要删除的内容";
		}else{
			$actioncontent = array();
			if(is_array($rs['otheruser']) && count($rs['otheruser'])){
				$actioncontent[] = "您无权限删除其他用户的稿件（ID:" . implode(',', $rs['otheruser']) . "）";
			}
			if(is_array($rs['checked']) && count($rs['checked'])){
				$actioncontent[] = "您无权限删除已审核的稿件（ID:" . implode(',', $rs['checked']) . "）";
			}
			if(is_array($rs['todelete']) && count($rs['todelete'])){
				$actioncontent[] .= "成功删除" . count($rs['todelete']) . "篇稿件（ID:" . implode(',', $rs['todelete']) . "）";
			}
			if(count($actioncontent) > 0){
				$_PAGE['actioncontent'] = implode('<br/>', $actioncontent);
				unset($actioncontent);
			}
			unset($actioncontent, $rs);
		}
		break;
	case 'preview' :
		$userObj->browseContent($_GET['contentid'], $uid);
		break;
	// get model editor
	case 'geteditor' :
		break;
	// get model addon fields(or user's fields in system model)
	case 'getaddonfields' :
		break;
	// get user channels
	case 'getchannel' :
		$json = array('success' => 0);
		$json['data'] = $userObj->getChannelTree($uid);
		if($json['data'] === false){
			$json['message'] = getLangByName($userObj->getMessage());
		}else{
			$json['success'] = 1;
		}
		EXCMS::json_print($json);
		exit();
		break;
	// show edit form
	case 'edit' :
		$contentid = (int)$_GET['contentid'];
		if($contentid > 0){
			$_PAGE['content']['edit'] = 2;
			$_PAGE['contentinfo'] = $userObj->getContentById($uid, $contentid);
			$_PAGE['model'] = $_PAGE['contentinfo']['modelid'];
		}else{
			$_PAGE['content']['edit'] = 1;
			$_PAGE['contentinfo'] = "";
			$_PAGE['model'] = $_PAGE['model'];
		}
		if(!$userObj->checkModels($_PAGE['model'])){
			$_PAGE['model'] = 1;
		}
		break;
	// edit content
	case 'doedit' :
		$contentid = $_POST['contentid'];
		if($contentid > 0){
			$_PAGE['content']['edit'] = 2;
			$_PAGE['model'] = $_POST['modelid'];
			$_PAGE['actiontitle'] = "编辑稿件";
			$_PAGE['actioncontent'] = "您编辑的内容信息已更新";
		}else{
			$_PAGE['content']['edit'] = 1;
			$_PAGE['actiontitle'] = "新建稿件";
			$_PAGE['actioncontent'] = "投稿成功";
		}
		if($userObj->checkChannel($_POST['channelid'], $_PAGE['model']) === false){
			$_PAGE['contentinfo'] = $_POST;
			$_PAGE['content']['error'] = getLangByName($userObj->getMessage());
		}else{
			if($EXCMS_MODULE['account']['contribute_verifycode']){
				$_POST['verifycode'] = trim($_POST['verifycode']);
				if($_POST['verifycode'] == ''){
					$_PAGE['content']['error'] = getLangByName('EMPTY_VERIFYCODE');
				}else{
					include_once LIB_PATH . 'util/CheckCode.class.php';
					$checkcode = new CheckCode();
					if(!$checkcode->check($_POST['verifycode'])){
						$_PAGE['content']['error'] = getLangByName('VERIFYCODE_FAILED');
					}
				}
			}
			if(!$_PAGE['content']['error']){
				if($userObj->editContent($uid, $_POST, $contentid)){
					$_PAGE['forwordurl'] = EXCMS::url(array('name' => 'account.content'));
					$_PAGE['success'] = 1;
				}else{
					$_PAGE['content']['error'] = getLangByName($userObj->getMessage());
					$_PAGE['contentinfo'] = $_POST;
				}
			}else{
				$_PAGE['contentinfo'] = $_POST;
			}
		}
		if($_PAGE['content']['error']){
			if(!$userObj->checkModels($_PAGE['model'])){
				$_PAGE['model'] = 1;
			}
			$_PAGE['editor'] = 'account/' . $userObj->getContentEditor($_PAGE['model']);
			if(isset($_PAGE['contentinfo']['images']) && is_string($_PAGE['contentinfo']['images'])){ // 多图模式需执行此
				$_PAGE['contentinfo']['images'] = stripslashes($_PAGE['contentinfo']['images']);
			}
		}
		break;
	// upload image
	case 'uploadimage' :
		$image = isset($_FILES['IMAGE']) ? $_FILES['IMAGE'] : NULL;
		if(is_array($image) && count($image) > 0){
			if($image['size'] > 0){
				try{
					$rs = $userObj->uploadImages('IMAGE', $_PAGE_USER['unumber']);
				}catch(Exception $e){
					$rs = array('success' => 0, 'message' => '系统异常，请联系管理员');
				}
				EXCMS::json_print($rs);
			}else{
				echo 'file size is 0';
			}
		}else{
			echo 'no upload image';
		}
		exit();
		break;
	case 'cateTree' : 
		include_once LIB_PATH . 'category/Category.class.php';
		$category = new Category();
		$rs = $category->getParentTree($_POST['categoryid'],$_POST['node'],true);
		EXCMS::json_print($rs);
		exit();
		break;
	case 'Preview' :
		$resource_str = isset($_GET['resource']) ? $_GET['resource'] : false;
		if($resource_str){
			include_once LIB_PATH . 'update/ContentFunction.class.php';
			$url = ContentFunction::getThumb($resource_str,true,'m');
			if($url != ''){
				header('Location: ' . $url);
			}
		}
		exit();
		break;
	// display home page
	default :
		// urlrule for list paging
		$_PAGE['urlrule'] = array('name' => 'account.content', 'k' => $_PAGE['keywords']);
		$paging = $_PAGE;
		$paging['pagesize'] = 10;
		$_PAGE['content']['contentlist'] = $userObj->getContentList($uid, $paging);
		break;
}
$_PAGE['content']['modelinfo'] = $userObj->getContentModel($uid);
EXCMS::display($_PAGE['success'] == 1 ? 'account/success.html' : 'account/content.html');
// excms file's end