Profile = function(){
	
};
Profile.prototype = {
	submitNick : function(f){
		var nickname = f.nickname.value.trim();
		if(nickname == ''){
			FormPanel.inputSideError(f.nickname, '昵称不能为空');
		}else{
			FormPanel.inputSideError(f.nickname);
			var tthis = this;
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						FormPanel.message(f, v.message, 'successbar', true);
						$('account-header-nickname').innerHTML = nickname;
					}else if(v.success == -1){
						Account.login({callback:function(){tthis.submitNick(f)}});
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, ajax.serializeForm(f));
		}
		return false;
	},
	// submit profile
	submitInfo : function(f){
		var tthis = this;
		ajax.request('post',window.location.href,{
			success:function(r){
				var v=ajax.jsondecode(r.responseText);
				if(v.success == 1){
					FormPanel.message(f, v.message, 'successbar', true);
				}else if(v.success == -1){
					Account.login({callback:function(){tthis.submitInfo(f)}});
				}else{
					var msg = v && v.message ? v.message : '请求服务失败，请重试！';
					FormPanel.message(f, msg, 'errorbar');
				}
			}
		}, ajax.serializeForm(f));
		return false;
	},
	// submit contact info
	submitContact : function(f){
		var tthis = this;
		ajax.request('post',window.location.href,{
			success:function(r){
				var v=ajax.jsondecode(r.responseText);
				if(v.success == 1){
					FormPanel.message(f, v.message, 'successbar', true);
				}else if(v.success == -1){
					Account.login({callback:function(){tthis.submitContact(f)}});
				}else{
					var msg = v && v.message ? v.message : '请求服务失败，请重试！';
					FormPanel.message(f, msg, 'errorbar');
				}
			}
		}, ajax.serializeForm(f));
		return false;
	},
	
	// initial change password form
	initChangePassword : function(f){
		if(typeof f == 'string') f = $(f);
		var tthis = this;
		f.pwd.onblur = function(){tthis.checkPassoword(this)};
		f.newpwd.onblur = function(){tthis.checkNewPassword(this)};
		f.repwd.onblur = function(){tthis.checkRepassword(this)};
	},
	// submit password
	submitPwd : function(f){
		var flag = this.checkPassoword(f.pwd);
		var flag1 = this.checkNewPassword(f.newpwd);
		var flag2 = this.checkRepassword(f.repwd);
		if(flag) f.pwd.focus();
		if(!(flag || flag1 || flag2)){
			var tthis = this;
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						f.reset();
						FormPanel.message(f, v.message, 'successbar', true);
					}else if(v.success == -1){
						Account.login({callback:function(){tthis.submitPwd(f)}});
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, ajax.serializeForm(f));
		}
		return false;
	},
	// check password
	checkPassoword : function(o){
		setCls(o,'focus',true);
		var msg;
		if(o.value.trim() == ''){
			msg = '请输入您当前的帐户密码';
		}else if(bytes(o) > 14 || bytes(o) < 6) {
			msg = '密码应该是6-14个字符之间';
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	// check new password
	checkNewPassword : function(o){
		setCls(o,'focus',true);
		var msg;
		var v = o.value;
		if(v == ''){
			msg = '请填写新密码';
		}else if(bytes(v) > 14 || bytes(v) < 6) {
			msg = '密码长度应该为6-14个字符';
		}else{
			if(o.form.repwd.value == ''){
				msg = true;
				FormPanel.inputSideError(o.form.repwd, '请再次填写密码', 'tipmsg');
			}else if(o.form.repwd.value != v){
				msg = '两次密码不一致';
			}
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	// check repassword
	checkRepassword : function(o){
		var msg;
		if(o.form.newpwd.value != ''){
			var v = o.value;
			if(v == ''){
				msg = '请再次填写新密码';
			}else if(o.form.newpwd.value != v){
				msg = '两次密码不一致';
			}else{
				this.checkNewPassword(o.form.newpwd);
			}
			FormPanel.inputSideError(o, msg);
		}
		return msg ? true : false;
	},
	
	setMyQuestion : function(o,v){
		var t = o.parentNode.target;
		if(v == '自定义我的安全提示问题'){
			t.value = '';
			t.readOnly = false;
			t.focus();
		}else{
			t.readOnly = true;
		}
	},
	
	// initial protect form
	initProtect : function(f){
		if(typeof f == 'string') f = $(f);
		if(f){
			var tthis = this;
			f.backupemail.onblur = function(){tthis.checkBackupEmail(this)};
		}
	},
	
	checkBackupEmail:function(o){
		var v = o.value.trim();
		var msg;
		if(v != '' && !isEmail(v)){
			msg = '邮箱格式不正确';
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	
	// submit protect info
	submitProtect : function(f){
		var q = f.question.value.trim();
		var n = '没安全提示问题';
		if(q != '' && q != n && f.answer.value.trim() == ''){
			FormPanel.inputSideError(f.answer, '请填写问题答案');
		}else{
			FormPanel.inputSideError(f.answer);
			if(this.checkBackupEmail(f.backupemail)) return false;
			var tthis = this;
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						FormPanel.message(f, v.message, 'successbar', true);
					}else if(v.success == -1){
						Account.login({callback:function(){tthis.submitProtect(f)}});
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, ajax.serializeForm(f));
		}
		return false;
	},
	
	/*
	 * 头像设置
	 */
	avatar : function(A,B){
		if(this.isEditing){
			this.view.show();
			this.editor.hide();
			this.isEditing = false;
		}else{
			this.view = $(A);
			this.editor = $(B);
			this.view.show = this.editor.show = show;
			this.view.hide = this.editor.hide = hide;
			this.view.hide();
			this.editor.show();
			this.isEditing = true;
			if(!this.avatarEditor){
				 a = new AvatarEditor();
				a.editorDom = 'account-avatar-image-ct';
				a.previewer = 'account-avatar-previewer';
				a.zoombarButton = 'account-avatar-zoom-button';
				a.selectorInfo = 'iCanFaceSelectorInfo';
				a.maskLoadEl = 'account-avatar-loading';
				a.commitBtn = 'iCanFaceCommitBtn';
				a.commitUrl = 'face.do?method=faceCommit';
				a.uploadButton = 'account-avatar-upload-button';
				a.maskEl = 'account-avatar-loading';
				a.loading = 'account-avatar-loading';
				a.init();
				this.avatarEditor = a;
			}
		}
	},
	// commit avatar
	avatarCommit : function(){
		this.avatarEditor.commit()
	},
	
	// select system avatar
	selectAvatar : function(avatar){
		var tthis = this;
		if(this.sysavatar_conn) ajax.abort(this.sysavatar_conn);
		this.sysavatar_conn = ajax.request('post',window.location.href,{
			success:function(r){
				var v=ajax.jsondecode(r.responseText);
				if(v.success == 1){
					tthis.setAvatar(avatar);
				}else if(v.success == -1){
					Account.login({callback:function(){tthis.selectAvatar(avatar)}});
				}else{
					var msg = v && v.message ? v.message : '请求服务失败，请重试！';
					FormPanel.message($('sys-avatar-list'), msg, 'errorbar');
				}
			}
		}, {action:'sysavatar', avatar:avatar});
	},
	// set avatar
	setAvatar : function(avatar){
		$('avatar-current-img').src = avatar + '?'+(new Date().getTime());
		avatar = avatar.split('.');
		var ext = avatar[avatar.length - 1];
		avatar.pop();
		$('hd-avatar-small').src = avatar.join('.')+ '_small.' + ext + '?'+(new Date().getTime());
	}
};
Profile = new Profile();