Recover = function(){
	this.isEmailAccount = false;
	this.count = 0;
};
Recover.prototype = {
	init : function(){
		this.accountForm = $('recover-account-form');
		if(this.accountForm){
			this.accountForm.show = show;
			this.accountForm.hide = hide;
		}
		this.questionForm = $('recover-question-form');
		if(this.questionForm){
			this.questionForm.show = show;
			this.questionForm.hide = hide;
		}
		this.passwordForm = $('recover-password-form');
		if(this.passwordForm){
			this.passwordForm.show = show;
			this.passwordForm.hide = hide;
			var tthis = this;
			this.passwordForm.init = function(){
				this.username.onblur = function(){tthis.checkUsername(this)};
				this.password.onblur = function(){tthis.checkPassword(this)}
				this.newpwd.onblur = function(){tthis.checkNewPassword(this)};
				this.repwd.onblur = function(){tthis.checkRepassword(this)};
				if(this.verifycode) this.verifycode.onblur = function(){tthis.checkVerifycode(this)};
			}
			this.passwordForm.init();
		}
		
	},
	checkAccountForm : function(f){
		var msg, isFocus, flag;
		if(f.username.value.trim() == ''){
			msg = '请填写帐号';
			flag = isFocus = true;
		}
		FormPanel.inputSideError(f.username, msg);
		flag = this.checkVerifycode(f.verifycode);
		if(isFocus) f.username.focus();
		if(!flag){
			var tthis = this;
			this.username = f.username.value;
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						tthis.accountForm.hide();
						$('recover-question-form-username').innerHTML = tthis.username;
						$('recover-question-ct').innerHTML = v.userinfo.question;
						tthis.questionForm.code = v.userinfo.code;
						tthis.questionForm.show();
						if(tthis.type==2)tthis.questionForm.answer.focus();
					}else if(v.success == 2){
						// 如果系统只允许通过email找回密码且没有设置备用邮箱
					}else if(v.success == -1){
						FormPanel.inputSideError(f.username, '不存在的帐号');
					}else if(v.success == -2){
						f.verifycode.value = '';
						FormPanel.inputSideError(f.verifycode, '您填写的验证码有误');
						tthis.refreshVcode('recover_verifycode_img');
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, {action:'account', username:f.username.value, verifycode:f.verifycode.value});
		}
		return false;
	},
	
	// back to account form
	back : function(){
		this.accountForm.username.focus();
		this.accountForm.verifycode.value = '';
		this.accountForm.show();
		this.questionForm.hide();
		this.refreshVcode();
	},
	
	showType : function(t){
		if(this.type && this.type == t) return ;
		this.type = t;
		var dd_email = $('dd_email');
		var dd_question = $('dd_question');
		var dd_answer = $('dd_answer');
		if(t == 1){
			dd_email.style.display = 'block';
			dd_question.style.display = 'none';
			dd_answer.style.display = 'none';
		}else{
			dd_email.style.display = 'none';
			dd_question.style.display = 'block';
			dd_answer.style.display = 'block';
			this.questionForm.answer.focus();
		}
	},
	
	checkQuestionForm : function(f){
		var msg, flag, isFocus;
		if(!this.type) this.type = 1;
		if(this.type == 2 && f.answer.value.trim() == ''){
			flag = true;
			msg = '请填写您的安全问题答案';
			isFocus = true;
		}
		FormPanel.inputSideError(f.answer, msg);
		if(this.showVerifycode) flag = this.checkVerifycode(f.verifycode);
		if(isFocus) f.answer.focus();
		
		if(!flag){
			var tthis = this;
			var data = {action:'answer', type:this.type, username:tthis.username,code:tthis.questionForm.code};
			if(this.type == 2){
				data.answer = f.answer.value;
			}else{
				data.email = f.email.checked ? 1 : 0;
			}
			if(this.showVerifycode) data.verifycode = f.verifycode.value;
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						tthis.questionForm.hide();
						$('recover-password-form-username').innerHTML = tthis.username;
						tthis.passwordForm.username.value = tthis.username;
						tthis.passwordForm.code.value =tthis.questionForm.code;
						tthis.passwordForm.show();
					}else if(v.success == 2){
						// 发送EMAIL
						var tip = $('recover-sendmail-tip');
						var strong = tip.getElementsByTagName('strong');
						strong[0].innerHTML = tthis.username;
						strong[1].innerHTML = v.email;
						tthis.questionForm.hide();
						$('recover-page-title').innerHTML = '重置密码邮件发送成功';
						tip.style.display = 'block';
					}else if(v.success == -1){
						tthis.count++;
						FormPanel.inputSideError(f.answer, '您填写的答案有误');
						if(tthis.count >= 3){
							tthis.showVerifycode = true;
							$('show_verifycode_dd').style.display = 'block';
							var vcode = $('recover_verifycode_img1');
							if(!vcode.oldsrc){
								vcode.oldsrc = vcode.attributes['oldsrc'].value;
							}
							f.verifycode.value = '';
							tthis.refreshVcode('recover_verifycode_img1');
						}
					}else if(v.success == -2){
						f.verifycode.value = '';
						FormPanel.inputSideError(f.verifycode, '您填写的验证码有误');
						tthis.refreshVcode('recover_verifycode_img1');
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, data);
		}
		return false;
	},
	
	// check password form
	checkPasswordForm : function(f){
		var flag, flag1, flag2;
		if(this.doLogin){
			flag = this.checkUsername(f.username);
			flag1 = this.checkPassword(f.password);
			flag2 = f.verifycode ? this.checkVerifycode(f.verifycode) : false;
			if(flag){
				f.username.focus();
			}else if(flag1){
				f.password.focus();
			}else if(flag2){
				f.verifycode.focus();
			}
			return !(flag || flag1 || flag2);
		}
		flag = this.checkNewPassword(f.newpwd);
		flag1 = this.checkRepassword(f.repwd);
		flag2 = f.verifycode ? this.checkVerifycode(f.verifycode) : false;
		if(flag){
			f.newpwd.focus();
		}else if(flag1){
			f.repwd.focus();
		}else if(flag2){
			f.verifycode.focus();
		}
		if(!(flag || flag1 || flag2)){
			var tthis = this;
			var data = {
				code : f.code.value,
				username : f.username.value,
				action : 'resetpassword',
				newpwd : f.newpwd.value,
				repwd : f.repwd.value
			};
			ajax.request('post',window.location.href,{
				success:function(r){
					var v=ajax.jsondecode(r.responseText);
					if(v.success == 1){
						FormPanel.message(f, '您的新密码已经设置成功，现在您可以使用新密码登录您的帐号。', 'successbar');
						$('recover-page-title').innerHTML = '登录我的帐号';
						$('recover-password-form-username').style.display = 'none';
						$('recover-password-form-newpwd').style.display = 'none';
						$('recover-password-form-input-username').style.display = 'block';
						$('recover-password-form-input-password').style.display = 'block';
						tthis.doLogin = true;
						if(f.username.value.trim() == '') f.username.value = tthis.username;
						f.password.focus();
						$('recover-submit-button').value = '登录';
					}else if(v.success == -1){
						// 密码不匹配等错误
					}else if(v.success == -2){
						f.verifycode.value = '';
						FormPanel.inputSideError(f.verifycode, '您填写的验证码有误');
						tthis.refreshVcode('recover_verifycode_img');
					}else{
						var msg = v && v.message ? v.message : '请求服务失败，请重试！';
						FormPanel.message(f, msg, 'errorbar');
					}
				}
			}, data);
		}
		return false;
	},
	// check username
	checkUsername : function(o){
		setCls(o,'focus',true);
		var msg;
		if(o.value.trim() == ''){
			msg = '请输入您的帐号';
		}else if(this.isEmailAccount &&　!isEmail(o.value)){
			msg = '您输入的帐号格式不正确';
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	// check password
	checkPassword : function(o){
		setCls(o,'focus',true);
		var msg;
		if(o.value.trim() == ''){
			msg = '请输入您的帐户密码';
		}else if(bytes(o) > 14 || bytes(o) < 6) {
			msg = '密码应该是6-14个字符之间';
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	// check new password
	checkNewPassword : function(o){
		setCls(o,'focus',true);
		var msg;
		var v = o.value;
		if(v == ''){
			msg = '请填写新密码';
		}else if(bytes(v) > 14 || bytes(v) < 6) {
			msg = '密码长度应为6-14个字符';
		}else{
			if(o.form.repwd.value == ''){
				msg = true;
				FormPanel.inputSideError(o.form.repwd, '请再次填写密码', 'tipmsg');
			}else if(o.form.repwd.value != v){
				msg = '两次密码不一致';
			}
		}
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	// check repassword
	checkRepassword : function(o){
		setCls(o,'focus',true);
		var msg;
		if(o.form.newpwd.value != ''){
			var v = o.value;
			if(v == ''){
				msg = '请再次填写新密码';
			}else if(o.form.newpwd.value != v){
				msg = '两次密码不一致';
			}else{
				this.checkNewPassword(o.form.newpwd);
			}
			FormPanel.inputSideError(o, msg);
		}
		return msg ? true : false;
	},
	// check verifycode
	checkVerifycode : function(o){
		setCls(o,'focus',true);
		var msg, flag;
		if(o.value.trim() == ''){
			msg = '请填写验证码'
		}else if(bytes(o) != 4){
			msg = '您填写的验证码有误'
		}
		if(msg) o.focus();
		FormPanel.inputSideError(o, msg);
		return msg ? true : false;
	},
	refreshVcode: function(o){o=$(o);if(o){if(!o.oldsrc){o.oldsrc=o.src}o.src=o.oldsrc+(o.oldsrc.indexOf('?')>=0?'&':'?')+(new Date().getTime())}}
};