<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		profile.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * services@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@excms.cn
 * @version $Rev: 772 $
 */
 
/* $Id: profile.php 772 2010-03-08 13:36:54Z hukuizhi $ */ 
 
/**
* 我的帐户信息
*/

// load account common
require_once('common.inc.php');

// set profile type
$_PAGE['profile']['type'] = isset($_GET['type']) ? $_GET['type'] : NULL;

// is submit success
$success = false;

// set $_PAGE_USER's value
$_PAGE_USER = $userObj->getUser(EXCMS_ACCOUNT_UID, 2);
if($_PAGE_USER === false){
	getLangByName($userObj->getMessage());
}

// get login position
include_once LIB_PATH . 'plugins/ipquery/IpLocation.class.php';
$local = new IpLocation();
$iparea = $local->getlocation($_PAGE_USER['lastloginip']);
$_PAGE_USER['position'] = $iparea['country'];

// json return
if($action == 'submit'){
	$json = array('success' => 0, 'message' => '');
}

// switch type
switch ($_PAGE['profile']['type']){
	// edit info
	case 'info':
		if($action == 'submit'){
			$data = array(
				'realname'	=> $_POST['realname'],
				'gender'	=> $_POST['gender'],
				//'birthday'	=> strtotime($_POST['birthday']),
				'msn'		=> $_POST['msn'],
				'qq'		=> $_POST['qq'],
				'phone'		=> $_POST['phone'],
				'mobile'	=> $_POST['mobile'],
				'area'		=> $_POST['area'],
				'job'		=> $_POST['job']
			);
			if($userObj->editUserinfo(EXCMS_ACCOUNT_UID, $data)){
				$json['success'] = 1;
				$json['message'] = '个人资料保存成功';
			}else{
				$json['message'] = getLangByName($userObj->getMessage());
			}
			EXCMS::json_print($json);
			exit;
		}
		break;
		
	// edit contact
	case 'contact':
		if($action == 'submit'){
			$data = array(
				'realname'	=> $_POST['realname'],
				'mobile'	=> $_POST['mobile'],
				'phone'	=> $_POST['phone'],
				'address'	=> $_POST['address'],
				'zipcode'	=> $_POST['zipcode'],
			);
			if($userObj->editUserinfo(EXCMS_ACCOUNT_UID, $data)){
				$json['success'] = 1;
				$json['message'] = '联系信息保存成功';
			}else{
				$json['message'] = getLangByName($userObj->getMessage());
			}
			EXCMS::json_print($json);
			exit;
		}
		break;
		
	// edit avatar
	case 'avatar':
		if($action == 'uploadavatar'){ // upload avatar
			$u_avatar = isset($_FILES['AVATAR']) ? $_FILES['AVATAR'] : NULL;
			if(is_array($u_avatar) && count($u_avatar) > 0){
				if($u_avatar['size'] > 0){
					include_once LIB_MODULES_PATH . 'account/Avatar.class.php';
					$avatar = new Avatar();
					EXCMS::json_print($avatar->upload(EXCMS_ACCOUNT_UID, 'AVATAR'));
				}else{
					echo 'file size is 0';
				}
			}else{
				echo 'no upload avatar';
			}
			exit;
		}elseif($action == 'commit'){
			include_once LIB_MODULES_PATH . 'account/Avatar.class.php';
			$avatar = new Avatar();
			$avatar->add($_POST['owidth'], $_POST['oheight']);
			$avatar->add(48, 48, 'small');
			$attributes = array(
				'cwidth' => $_POST['width'],
				'cheight'=> $_POST['height'],
				'x'     => $_POST['x'],
				'y'     => $_POST['y'],
				'scale' => $_POST['scale'],
			);
			$success = $avatar->create($_PAGE_USER, $_POST['avatar'], $attributes);
			if($success){
				$avatar = $avatar->get();
				$userObj->setAvatar(EXCMS_ACCOUNT_UID, $avatar[0]);
				EXCMS::json_print(array('success' => $success, 'message' => '保存头像成功','avatar' => $avatar[0], 'avatar_small' => $avatar[1]));
				// Todo 
				//给当前用户设置头像值
				//$userObj->setValue('avatar', $avatar[0]);
				// 或者通过数组 $userObj->setValue(array('avatar' => $avatar[0], 'avatar_small' => $avatar[1]));
			}else{
				EXCMS::json_print(array('success' => 0, 'message' => '保存头像失败,失败原因：'));	
			}
			exit;
		}else if($action == 'sysavatar'){
			$userObj->setAvatar(EXCMS_ACCOUNT_UID, $_POST['avatar']);
			EXCMS::json_print(array('success' => 1));
			exit;
		}
		break;
		
	// edit password
	case 'changepwd':
		if($action == 'submit'){
			$pwd = trim($_POST['pwd']);
			$newpwd = $_POST['newpwd'];
			$repwd = $_POST['repwd'];
			if(empty($pwd)){
				$json['message'] = '请填写您当前的帐号密码';
			}else if($newpwd !== $repwd){
				$json['message'] = getLangByName('USER_PASSWORD_NOT_MATCH');
			}else{
				if($userObj->setPassword(EXCMS_ACCOUNT_UID, $newpwd, true, $_POST['pwd'])){
					$json['success'] = 1;
					$json['message'] = '密码修改成功';
				}else{
					$json['message'] = getLangByName($userObj->getMessage());
				}
			}
			EXCMS::json_print($json);
			exit;
		}
		break;
		
	// edit protect
	case 'protect':
		if($action == 'submit'){
			$data = array(
				'question'		=> $_POST['question'],
				'answer'		=> $_POST['answer'],
				'backupemail'	=> $_POST['backupemail'],
			);
			if($userObj->editProtect(EXCMS_ACCOUNT_UID, $data, false)){
				$json['success'] = 1;
				$json['message'] = '安全设置更新成功';
			}else{
				$json['message'] = getLangByName($userObj->getMessage());
			}
			EXCMS::json_print($json);
			exit;
		}
		break;
	
	// edit nickname
	default : 
		if($action == 'submit'){
			if($userObj->editNickname(EXCMS_ACCOUNT_UID, $_POST['nickname'])){
				$_PAGE_USER['nickname'] = $_POST['nickname'];
				$userObj->setSession(array('nickname'=>$_POST['nickname']),true,false);
				$json['success'] = 1;
				$json['message'] = '昵称设置成功';
			}else{
				$json['message']= getLangByName($userObj->getMessage());
			}
			EXCMS::json_print($json);
			exit;
		}
		break;
}

EXCMS::display($success ? 'account/success.html' : 'account/profile.html');
// excms file's end