EXCMS.Init = {
    init: function(){
        Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
            expires: new Date(new Date().getTime() + (1000 * 60 * 60 * 24 * 365))
        }));
        this.menubar = Ext.getDom('menubar');
        this.view();
        this.renderMenu()
    },
    view: function(){
        var h = 93;
        if (Ext.state.Manager.getProvider()) {
            this.ishideTop = Ext.state.Manager.get('hidetop', 0) == 1 ? true : false;
            if (this.ishideTop) {
                h = 31;
                this.setTopVisiable(true, true);
            }
        }
        this.viewport = new Ext.Viewport({
            layout: 'border',
            hideBorders: true,
            items: [new Ext.BoxComponent({
                region: 'north',
                el: 'pt_north',
                height: h
            }), {
                region: 'center',
                layout: 'card',
                activeItem: 0,
                items: {
                    border: false,
                    html: '<iframe id="mainiframe" name="mainiframe" src="index.php?M=Desktop" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
                }
            }]
        });
        this.viewport.on('resize', this.setIframeHeight, this);
        this.center = this.viewport.layout.center.panel;
        this.iframe = Ext.get('mainiframe')
    },
    setIframeHeight: function(){
        this.iframe.setHeight(this.viewport.items.items[1].body.getHeight())
    },
    renderMenu: function(){
        var modules = [{
            text: '模块管理',
            icon: ico,
            iconCls: 'ico module',
            handler: this.g,
            url: 'index.php?M=Modules',
            scope: this
        }, '-'];
        if (modulesConfig != '') {
            try {
                modulesConfig = eval("[" + modulesConfig + "]");
                for (var i = 0; i < modulesConfig.length; i++) {
                    modules.push(modulesConfig[i]);
                }
            } 
            catch (e) {
            }
        }
        var plugins = [{
            text: '插件管理',
            icon: ico,
            iconCls: 'ico plugin',
            handler: this.g,
            url: 'index.php?M=Plugins',
            scope: this
        }, '-'];
        if (pluginsConfig != '') {
            try {
                pluginsConfig = eval("[" + pluginsConfig + "]");
                for (var i = 0; i < pluginsConfig.length; i++) {
                    plugins.push(pluginsConfig[i])
                }
            } 
            catch (e) {
            }
        }
        var quick = [];
        if (modelConfig != '') {
            try {
                modelConfig = eval("[" + modelConfig + "]");
                for (var i = 0; i < modelConfig.length; i++) {
                    quick.push(modelConfig[i]);
                }
            } 
            catch (e) {
            }
        }
        quick = quick.concat(['-', {
            text: '栏目',
            icon: ico,
            iconCls: 'ico add_channel',
            handler: EXCMS.util.QuickCreate,
            scope: this,
            model: 'Channel.Editor'
        }, {
            text: '模型',
            icon: ico,
            iconCls: 'ico add_model',
            handler: EXCMS.util.QuickCreate,
            scope: this,
            model: 'Model.Editor'
        }]);
         this.Menu = {
            Quick: new Ext.menu.Menu({
                items: quick
            }),
            Desktop: new Ext.menu.Menu({
                items: [{
                    text: '我的桌面',
                    icon: ico,
                    iconCls: 'ico desktop',
                    url: 'index.php?M=Desktop',
                    handler: this.g,
                    scope: this
                }, {
                    text: '网站首页',
                    icon: ico,
                    iconCls: 'ico homepage',
                    href: '/',
                    hrefTarget: '_blank'
                }, {
                    text: '桌面工具',
                    icon: ico,
                    iconCls: 'ico desktop_tools',
                    menu: {
                        items: [{
                            text: '时间',
                            icon: ico,
                            iconCls: 'ico time',
                            handler: EXCMS.util.QuickDialog,
                            scope: this,
                            model: 'Time'
                        }, {
                            text: '日历',
                            icon: ico,
                            iconCls: 'ico cale',
                            handler: EXCMS.util.QuickDialog,
                            scope: this,
                            model: 'Calr'
                        }, {
                            text: '计算器',
                            icon: ico,
                            iconCls: 'ico calc',
                            handler: EXCMS.util.QuickDialog,
                            scope: this,
                            model: 'Calc'
                        }]
                    }
                }, '-', {
                    text: '个人设置',
                    icon: ico,
                    iconCls: 'ico profile',
                    menu: {
                        items: [{
                            text: '个人信息',
                            url: 'index.php?M=System&A=AdminProfile',
                            handler: this.g,
                            scope: this
                        }, {
                            text: '修改密码',
                            icon: ico,
                            iconCls: 'ico password',
                            handler: EXCMS.util.QuickCreate,
                            model: 'Admin.SetPassword',
                            scope: this
                        }]
                    }
                }, {
                    text: '桌面设置',
                    icon: ico,
                    iconCls: '',
                    handler: EXCMS.util.QuickCreate,
                    scope: this,
                    model: 'DesktopSetting.Editor'
                }, '-', {
                    text: '注销',
                    icon: ico,
                    iconCls: 'ico logout',
                    href: 'index.php?M=Auth&A=Logout'
                }, {
                    text: '退出',
                    icon: ico,
                    iconCls: 'ico exit',
                    href: 'index.php?M=Auth&A=Logout&method=exit'
                }]
            }),
            Template: new Ext.menu.Menu({
                items: [{
                    text: '模板管理',
                    icon: ico,
                    iconCls: 'ico template',
                    handler: this.g,
                    url: 'index.php?M=Template',
                    scope: this
                }, '-', {
                    text: '清除模板缓存',
                    icon: ico,
                    iconCls: 'ico cleartplcache',
                    handler: this.updateCache,
                    scope: this,
                    url: 'index.php?M=Template&A=Index&method=clearcache'
                }]
            }),
            Module: new Ext.menu.Menu({
                items: modules
            }),
            Channel: new Ext.menu.Menu({items:[
				{text:'栏目管理',icon:ico,iconCls:'ico channels',handler:this.g,url:'index.php?M=Channel',scope:this},'-',
				{text:'内容模型',icon:ico,iconCls:'ico models',handler:this.g,url:'index.php?M=Model',scope:this},
				{text:'模型字段',handler:this.g,url:'index.php?M=Model&A=ModelField',scope:this},'-',
				{text:'分类数据',icon:ico,iconCls:'ico category',handler:this.g,url:'index.php?M=Category',scope:this}
			]}),
            Content: new Ext.menu.Menu({
                items: [{
                    text: '新建内容',
                    icon: ico,
                    iconCls: 'ico add_article',
                    menu: {
                        items: modelConfig
                    }
                }, '-', {
                    text: '内容管理',
                    icon: ico,
                    iconCls: 'ico contents',
                    handler: this.g,
                    url: 'index.php?M=Content',
                    scope: this
                }, {
                    text: '自定义页面',
                    icon: ico,
                    iconCls: 'ico custompages',
                    handler: this.g,
                    url: 'index.php?M=Content&A=CustomPage',
                    scope: this
                }, '-', {
                    text: '关联标题',
                    icon: ico,
                    handler: this.g,
                    url: 'index.php?M=Content&A=RelatedTitle',
                    scope: this
                }, {
                    text: '关键字链接',
                    icon: ico,
                    iconCls: 'ico keywordslink',
                    handler: this.g,
                    url: 'index.php?M=Content&A=Keywords',
                    scope: this
                }, {
                    text: 'Tag 标签',
                    icon: ico,
                    iconCls: 'ico tags',
                    scope: this,
                    handler: this.g,
                    url: 'index.php?M=Content&A=Tag'
                }, {
                    text: '相关关键字',
                    icon: ico,
                    iconCls: '',
                    scope: this,
                    handler: this.g,
                    url: 'index.php?M=Content&A=Likekeyword'
                }, {
                    text: '作者',
                    icon: ico,
                    iconCls: 'ico authors',
                    scope: this,
                    handler: this.g,
                    url: 'index.php?M=Content&A=Author'
                }, {
                    text: '来源',
                    icon: ico,
                    iconCls: 'ico sources',
                    scope: this,
                    handler: this.g,
                    url: 'index.php?M=Content&A=Source'
                }, '-', {
                    text: '内容工具',
                    icon: ico,
                    iconCls: 'ico desktop_tools',
                    menu: {
                        items: [{
                            text: '内容批量维护',
                            scope: this,
                            handler: this.g,
                            url: 'index.php?M=Content&A=ContentBatch'
                        }, {
                            text: '描述及分页',
                            scope: this,
                            handler: this.g,
                            url: 'index.php?M=Content&A=AutoAbstract'
                        }]
                    }
                }, {
                    text: '内容统计',
                    icon: ico,
                    iconCls: 'ico chart',
                    scope: this,
                    handler: this.g,
                    url: 'index.php?M=Content&A=Stat'
                }]
            }),
            Update: new Ext.menu.Menu({
                items: [{
                    text: '更新首页',
                    icon: ico,
                    iconCls: 'ico update_home',
                    handler: this.g,
                    url: 'index.php?M=Update&method=index',
                    scope: this
                }, {
                    text: '更新栏目',
                    icon: ico,
                    iconCls: 'ico update_channel',
                    handler: this.g,
                    url: 'index.php?M=Update&method=channel',
                    scope: this
                }, {
                    text: '更新内容',
                    icon: ico,
                    iconCls: 'ico update_archive',
                    handler: this.g,
                    url: 'index.php?M=Update&method=content',
                    scope: this
                }, {
                    text: '更新自定义页面',
                    icon: ico,
                    iconCls: 'ico update_custompage',
                    handler: this.g,
                    url: 'index.php?M=Update&method=custompage',
                    scope: this
                }, '-', {
                    text: '更新网站地图',
                    icon: ico,
                    iconCls: 'ico update_map',
                    handler: this.g,
                    url: 'index.php?M=Update&method=map',
                    scope: this
                }, {
                    text: '更新RSS文件',
                    icon: ico,
                    iconCls: 'ico update_rss',
                    handler: this.g,
                    url: 'index.php?M=Update&method=rss',
                    scope: this
                }, {
                    text: '更新Sitemap',
                    icon: ico,
                    iconCls: 'ico update_sitemap',
                    handler: this.g,
                    url: 'index.php?M=Update&method=sitemap',
                    scope: this
                }, {
                    text: '更新友情链接',
                    icon: ico,
                    iconCls: 'ico update_link',
                    handler: this.g,
                    url: 'index.php?M=Update&method=link',
                    scope: this
                }, '-', {
                    text: '更新缓存',
                    icon: ico,
                    iconCls: 'ico cache',
                    handler: this.updateCache,
                    url: 'index.php?M=System&A=Index&method=allcache',
                    scope: this,
                    menu: {
                        items: [{
                            text: '更新系统缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=System&A=Index&method=cache',
                            scope: this
                        }, {
                            text: '更新URL缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=System&A=Url&method=cache',
                            scope: this
                        }, {
                            text: '更新栏目缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=Channel&A=Index&method=cache',
                            scope: this
                        }, {
                            text: '更新模型缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=Model&A=Index&method=cachemodel',
                            scope: this
                        }, {
                            text: '更新主表字段缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=Model&A=Index&method=cachemainfield',
                            scope: this
                        }, '-', {
                            text: '更新全部缓存',
                            handler: this.updateCache,
                            url: 'index.php?M=System&A=Index&method=allcache',
                            scope: this
                        }]
                    }
                }]
            }),
            Plugin: new Ext.menu.Menu({
                items: plugins
            }),
            Account: new Ext.menu.Menu({
                items: [{
                    text: '用户管理',
                    icon: ico,
                    iconCls: 'ico user',
                    handler: this.g,
                    url: 'index.php?M=Modules&EM=account',
                    scope: this
                }, '-', {
                    text: '帐户配置',
                    handler: this.g,
                    url: 'index.php?M=Modules&EM=account&A=AccountConfig&type=config',
                    scope: this
                }]
            }),
            System: new Ext.menu.Menu({items: [
				{text:'系统设置',icon:ico,iconCls:'ico system',handler:this.g,url:'index.php?M=System',scope:this},
				{text:'计划任务',icon:ico,iconCls:'ico time',handler:this.g,url:'index.php?M=cron',scope:this},
				{text:'URL规则及重写',icon:ico,iconCls:'ico url',handler:this.g,url:'index.php?M=System&A=Url',scope:this}, '-',
				{text:'管理员和组',icon:ico,iconCls:'ico admin',handler:this.g,url:'index.php?M=System&A=Admin',scope:this},
				{text:'权限管理',handler:this.g,url:'index.php?M=System&A=Permissions',scope:this},'-',
				{text:'数据库',icon:ico,iconCls:'ico database',scope:this,handler:this.g,url:'index.php?M=System&A=Database'},'-',
				{text: '菜单管理',handler: this.g,url: 'index.php?M=System&A=Menu', scope: this},
				{text:'桌面管理',handler:this.g,url:'index.php?M=System&A=DesktopManage',scope:this}
				//,{text:'统计字段管理',handler:this.g,url:'index.php?M=System&A=SystemFields',scope:this}
			]}),
            Help: new Ext.menu.Menu({
                items: [{
                    text: '帮助中心',
                    icon: ico,
                    iconCls: 'ico help',
                    handler: function(){
                        EXCMS.util.RequestUrl('http://www.excms.cn/help')
                    },
                    scope: this
                }, {
                    text: '技术支持',
                    icon: ico,
                    iconCls: 'ico support',
                    handler: function(){
                        EXCMS.util.RequestUrl('http://www.excms.cn/support')
                    },
                    scope: this
                }, '-', {
                    text: '检查更新',
                    icon: ico,
                    iconCls: 'ico updatecms',
                    handler: this.checkupdate,
                    scope: this
                }, '-', {
                    text: '关于EXCMS 卓越内容管理系统',
                    icon: ico,
                    iconCls: 'ico aboutEXCMS',
                    handler: this.about,
                    scope: this
                }]
            })
        }
        if (this.menubar) {
            this.menubar.items = this.menubar.getElementsByTagName('ul')[0].getElementsByTagName('span');
            var tthis = this;
            for (var i = 0, len = this.menubar.items.length; i < len; i++) {
                this.menubar.items[i].bar = this.menubar;
                this.menubar.items[i].Li = this.menubar.items[i].parentNode.parentNode;
                var m = getTagAttribute(this.menubar.items[i].Li, 'menu');
                if (m && this.Menu[m]) {
                    this.menubar.items[i].menu = this.Menu[m]
                }
                if (this.menubar.items[i].menu) {
                    this.menubar.items[i].menu.bar = this.menubar;
                    this.menubar.items[i].menu.Li = this.menubar.items[i].Li;
                    this.menubar.items[i].menu.on('hide', function(){
                        this.bar.isShowMenu = false;
                        tthis.removeCls(this.Li, 'hover')
                    });
                }
                this.menubar.items[i].onmousedown = function(){
                    tthis.setCls(this.Li, 'click')
                };
                this.menubar.items[i].onmouseup = function(){
                    tthis.removeCls(this.Li, 'click')
                };
                this.menubar.items[i].onmouseover = function(){
                    if (this.menu && this.bar.isShowMenu) {
                        this.menu.show(this.Li);
                        this.bar.isShowMenu = true;
                        this.bar.showMenu = this.menu;
                    }
                    tthis.setCls(this.Li, 'hover')
                };
                this.menubar.items[i].onmouseout = function(){
                    tthis.removeCls(this.Li, 'click');
                    if ((this.menu && !this.menu.isVisible()) || !this.menu) 
                        tthis.removeCls(this.Li, 'hover')
                };
                this.menubar.items[i].onclick = function(){
                    tthis.removeCls(this.Li, 'hover');
                    tthis.setCls(this.Li, 'hover');
                    if (!this.menu) {
                        var url = getTagAttribute(this.Li, 'url');
                        if (url) {
                            tthis.g({
                                url: url
                            });
                        }
                    }
                    else 
                        if (this.menu && !this.menu.isVisible()) {
                            tthis.removeCls(this.Li, 'click');
                            this.menu.show(this.Li);
                            this.bar.isShowMenu = true;
                            this.bar.showMenu = this.menu
                        }
                }
            }
        }
    },
    hideTop: function(){
        var f = !this.ishideTop;
        Ext.state.Manager.set('hidetop', f ? 1 : 0);
        this.setTopVisiable(f)
    },
    initHideTop: function(){
        if (Ext.state.Manager.getProvider()) {
            this.ishideTop = Ext.state.Manager.get('hidetop', 0) == 1 ? true : false;
            if (this.ishideTop) {
                this.setTopVisiable(true)
            }
        }
    },
    setTopVisiable: function(v, flag){
        Ext.getDom('pt_top').style.display = v ? 'none' : 'block';
        Ext.getDom('mbShadow').style.top = v ? '31px' : '93px';
        if (!flag) {
            this.viewport.getComponent(0).setHeight(v ? 31 : 93);
            this.viewport.syncSize();
        }
        this.menubar.getElementsByTagName('ul')[0].className = v ? 'withLogo' : '';
        var o = Ext.getDom('excms-hidetop-operate');
        o.className = v ? 'hidetop unhidetop' : 'hidetop';
        o.title = v ? '显示顶部' : '隐藏顶部';
        o.blur();
        this.ishideTop = v
    },
    g: function(item){
        if (!(item && item.url)) 
            return;
        this.center.layout.setActiveItem(0);
        this.iframe.dom.src = item.url;
        return;
        if (!this.um) 
            this.um = this.mainComponent.getUpdater();
        this.um.update({
            url: item.url,
            nocache: true,
            text: '<div class=pageloading>加载中...</div>',
            timeout: 60,
            callback: this.unload,
            scripts: true
        })
    },
    unload: function(){
    },
    updateCache: function(item){
        Ext.Ajax.request({
            url: item.url,
            method: 'get',
            scope: this,
            success: function(r, o){
                var rs = jsonReturn(r);
                if (rs.success) 
                    alert(item.text + '成功');
            }
        })
    },
    about: function(){
        if (!this.aboutwin) {
            this.aboutwin = new Ext.Window({
                id: 'EXCMSWin',
                title: '关于 EXCMS 卓越内容管理系统',
                autoLoad: {
                    url: 'index.php?M=Help&A=About'
                },
                width: 490,
                height: 262,
                autoScroll: false,
                closeAction: 'hide',
                modal: true,
                resizable: false
            });
        }
        this.aboutwin.show();
        this.aboutwin.center();
    },
    checkupdate: function(){
        this.checkupdate = new Ext.data.JsonStore({
            root: 'data',
            idProperty: 'version',
            fields: ['message', 'isupdate'],
            proxy: new Ext.data.ScriptTagProxy({
                url: checkUpdateUrl + '&method=check'
            })
        });
        if (!this.checkupdatewin) {
            this.checkupdatewin = new Ext.Window({
                title: 'EXCMS 更新',
                width: 450,
                height: 350,
                modal: true,
                resizable: false,
                closeAction: 'hide',
                bodySytle: 'backgournd:#F0F0F0',
                html: '',
                buttons: [{
                    text: '更新',
                    handler: this.updateVersion,
                    scope: this
                }, {
                    text: '取消',
                    handler: function(){
                        this.checkupdatewin.hide();
                    },
                    scope: this
                }]
            });
            this.checkupdatewin.on('hide', function(){
                if (this.checkupdatewin.barloop) 
                    window.clearInterval(this.checkupdatewin.barloop);
            }, this);
        }
        this.checkupdatewin.show();
        this.checkupdatewin.body.dom.innerHTML = '<div id="excms-checkupdate-hd">正在检查更新</div><div id="excms-checkupdate-bd"><div class="excms-checkupdate-msg">EXCMS 正在检查更新...</div><div class="i-statusbar"><div></div><p><span id="excms-checkupdate-bar"><em></em></span></p></div></div>';
        this.checkupdate.load();
        var startTime = new Date();
        this.isupdate = true;
        function EXCMSCheckUpdateBarLoop(){
            var endTime = new Date();
            if ((endTime.getTime() - startTime.getTime()) / 1000 > 30) {
                window.clearInterval(tthis.checkupdatewin.barloop);
                Ext.getDom('excms-checkupdate-hd').innerHTML = '检查更新失败';
                Ext.getDom('excms-checkupdate-bd').innerHTML = 'EXCMS 检查更新超时，请稍候重试.';
                return;
            }
            var l = bar.offsetLeft + 3;
            if (l >= w) 
                l = -120;
            bar.style.left = l + 'px';
        }
        var bar = Ext.getDom('excms-checkupdate-bar');
        if (bar) {
            var w = bar.parentNode.offsetWidth + 120;
            if (this.checkupdatewin.barloop) 
                window.clearInterval(this.checkupdatewin.barloop);
            this.checkupdatewin.barloop = window.setInterval(EXCMSCheckUpdateBarLoop, 1);
        }
        this.checkupdate.on('load', function(store, o){
            window.clearInterval(this.checkupdatewin.barloop);
            if (o[0].data.isupdate) {
                Ext.getDom('excms-checkupdate-hd').innerHTML = '已经是最新版本';
                Ext.getDom('excms-checkupdate-bd').innerHTML = '您的 EXCMS 卓越内容管理系统是最新版本，无需更新!';
            }
            else {
                this.checkupdatewin.body.dom.innerHTML = '';
                if (!this.updategrid) {
                    this.updatestore = new Ext.data.JsonStore({
                        root: 'data',
                        idProperty: 'version',
                        remoteSort: true,
                        fields: ['title', 'filename', 'url', 'version', 'filesize', 'publishdate', 'sqlurl'],
                        proxy: new Ext.data.ScriptTagProxy({
                            url: checkUpdateUrl + '&method=update'
                        })
                    });
                    this.updategrid = new Ext.grid.GridPanel({
                        title: 'EXCMS版本列表',
                        margins: '0 3 3 0',
                        height: 330,
                        enableColumnMove: false,
                        collapsible: false,
                        animCollapse: false,
                        border: false,
                        sm: new Ext.grid.RowSelectionModel(),
                        loadMask: {
                            msg: '正在获取官方版本...'
                        },
                        store: this.updatestore,
                        columns: [{
                            header: "名称",
                            width: 150,
                            sortable: true,
                            dataIndex: 'title'
                        }, {
                            header: "版本号",
                            width: 60,
                            sortable: true,
                            dataIndex: 'version'
                        }, {
                            header: "文件大小",
                            width: 80,
                            sortable: true,
                            dataIndex: 'filesize'
                        }, {
                            header: "发布日期",
                            width: 120,
                            sortable: true,
                            dataIndex: 'publishdate'
                        }]
                    });
                    this.checkupdatewin.add(this.updategrid);
                }
                this.checkupdatewin.doLayout();
                this.updatestore.load();
            }
        }, this)
    },
    updateVersion: function(){
        if (this.updategrid) {
            var record = this.updategrid.getSelectionModel().getSelections();
            if (!(record.length > 0)) {
                alert('请选择更新版本');
                return;
            }
            var url = [], filename = [], sqlurl = [];
            if (record.length) {
                for (var i = 0, len = record.length; i < len; i++) {
                    url.push(record[i].data.url);
                    filename.push(record[i].data.filename);
                    sqlurl.push(record[i].data.sqlurl);
                }
                Ext.MessageBox.confirm('提示', '请在更新前做好数据库备份，本次更新有可能对数据库进行升级，您是否继续更新？', function(optional){
                    if (optional == 'yes') {
                        this.checkupdatewin.el.mask('正在更新,请稍后...');
                        Ext.Ajax.request({
                            url: 'index.php?M=Help&A=UpdateAction',
                            async: false,
                            timeout: 1800000,
                            method: 'post',
                            params: {
                                url: Ext.util.JSON.encode(url),
                                filename: Ext.util.JSON.encode(filename),
                                sqlurl: Ext.util.JSON.encode(sqlurl)
                            },
                            failure: function(response, options){
                                this.checkupdatewin.el.unmask();
                                this.downfalg = true;
                                r = jsonReturn(response);
                                alert(r.message);
                            },
                            success: function(response, options){
                                r = jsonReturn(response);
                                this.checkupdatewin.el.unmask();
                                this.downfalg = true;
                                alert(r.message);
                                this.updatestore.load();
                            },
                            scope: this
                        });
                    }
                    else 
                        return
                }
.createDelegate(this));
            }
        }
        else {
            alert("您当前的版本已是最新版本了!")
        }
    },
    downloadProgress: function(filename, filesize){
        var dialog = document.createElement('div');
        dialog.id = 'download-dialog';
        dialog.className = 'ext-el-mask-download';
        this.checkupdatewin.add(dialog);
        this.checkupdatewin.doLayout();
        this.ttt = dialog;
        var dialog = Ext.getDom('download-dialog');
        ;
        dialog.innerHTML = '<div class="ext-el-mask-status" id="status"></div><div id="progress" style="width:100%;"></div>';
        Ext.fly('status').update('下载中,请稍后...');
        var downloadProgress = new Ext.ProgressBar({
            text: '开始下载',
            id: 'pbar2',
            cls: 'left-align',
            renderTo: 'progress'
        });
        this.downloadBar(downloadProgress, 100, filename, filesize)
    },
    downloadBar: function(pbar, count, filename, filesize){
        if (this.downfalg) 
            return;
        Ext.Ajax.request({
            url: 'index.php?M=Help&A=UpdateAction&method=download',
            async: false,
            method: 'post',
            params: {
                filename: filename,
                filesize: filesize
            },
            failure: function(response, options){
            },
            success: function(response, options){
                r = jsonReturn(response);
                this.v = r.current ? r.current : 0;
                if (this.v > count) {
                    pbar.reset(true);
                    Ext.fly('status').update('下载完成').show();
                    Ext.getDom('download-dialog').style.display = 'none';
                }
                else {
                    pbar.updateProgress(this.v / count, '下载数 ' + this.v + ' %');
                    this.downloadBar(pbar, count, filename, filesize);
                }
            },
            scope: this
        })
    },
    onDocClick: function(){
        if (this.menubar && this.menubar.showMenu) 
            this.menubar.showMenu.hide();
    },
    setCls: function(o, c){
        o.className = o.className.length > 0 ? (o.className + ' ' + c) : c
    },
    removeCls: function(o, c){
        o.className = o.className.replace(new RegExp('( ?|^)' + c + '\\b'), '')
    }
};
EXCMS.onReady(EXCMS.Init.init, EXCMS.Init);
