Ext.create = Ext.ComponentMgr.create;
Ext.data.Types = new function(){
    var st = Ext.data.SortTypes;
    Ext.apply(this, {
        stripRe: /[\$,%]/g,
        AUTO: {
            convert: function(v){
                return v;
            },
            sortType: st.none,
            type: 'auto'
        },
        STRING: {
            convert: function(v){
                return (v === undefined || v === null) ? '' : String(v);
            },
            sortType: st.asUCString,
            type: 'string'
        },
        INT: {
            convert: function(v){
                return v !== undefined && v !== null && v !== '' ? parseInt(String(v).replace(Ext.data.Types.stripRe, ''), 10) : (this.useNull ? null : 0);
            },
            sortType: st.none,
            type: 'int'
        },
        FLOAT: {
            convert: function(v){
                return v !== undefined && v !== null && v !== '' ? parseFloat(String(v).replace(Ext.data.Types.stripRe, ''), 10) : (this.useNull ? null : 0);
            },
            sortType: st.none,
            type: 'float'
        },
        BOOL: {
            convert: function(v){
                return v === true || v === 'true' || v == 1;
            },
            sortType: st.none,
            type: 'bool'
        },
        DATE: {
            convert: function(v){
                var df = this.dateFormat;
                if (!v) {
                    return null;
                }
                if (Ext.isDate(v)) {
                    return v;
                }
                if (df) {
                    if (df == 'timestamp') {
                        return new Date(v * 1000);
                    }
                    if (df == 'time') {
                        return new Date(parseInt(v, 10));
                    }
                    return Date.parseDate(v, df);
                }
                var parsed = Date.parse(v);
                return parsed ? new Date(parsed) : null;
            },
            sortType: st.asDate,
            type: 'date'
        }
    });
    Ext.apply(this, {
        BOOLEAN: this.BOOL,
        INTEGER: this.INT,
        NUMBER: this.FLOAT
    });
};
EXCMS.namespace('Ext.ux', 'Ext.ux.tree', 'Ext.list');
Ext.list.ListView = Ext.extend(Ext.DataView, {
    itemSelector: 'dl',
    selectedClass: 'x-list-selected',
    overClass: 'x-list-over',
    scrollOffset: undefined,
    columnResize: true,
    columnSort: true,
    maxColumnWidth: Ext.isIE ? 99 : 100,
    initComponent: function(){
        if (this.columnResize) {
            this.colResizer = new Ext.list.ColumnResizer(this.colResizer);
            this.colResizer.init(this);
        }
        if (this.columnSort) {
            this.colSorter = new Ext.list.Sorter(this.columnSort);
            this.colSorter.init(this);
        }
        if (!this.internalTpl) {
            this.internalTpl = new Ext.XTemplate('<div class="x-list-header"><div class="x-list-header-inner">', '<tpl for="columns">', '<div style="width:{[values.width*100]}%;text-align:{align};"><em unselectable="on" id="', this.id, '-xlhd-{#}">', '{header}', '</em></div>', '</tpl>', '<div class="x-clear"></div>', '</div></div>', '<div class="x-list-body"><div class="x-list-body-inner">', '</div></div>');
        }
        if (!this.tpl) {
            this.tpl = new Ext.XTemplate('<tpl for="rows">', '<dl>', '<tpl for="parent.columns">', '<dt style="width:{[values.width*100]}%;text-align:{align};">', '<em unselectable="on"<tpl if="cls"> class="{cls}</tpl>">', '{[values.tpl.apply(parent)]}', '</em></dt>', '</tpl>', '<div class="x-clear"></div>', '</dl>', '</tpl>');
        };
        var cs = this.columns, allocatedWidth = 0, colsWithWidth = 0, len = cs.length, columns = [];
        for (var i = 0; i < len; i++) {
            var c = cs[i];
            if (!c.isColumn) {
                c.xtype = c.xtype ? (/^lv/.test(c.xtype) ? c.xtype : 'lv' + c.xtype) : 'lvcolumn';
                c = Ext.create(c);
            }
            if (c.width) {
                allocatedWidth += c.width * 100;
                if (allocatedWidth > this.maxColumnWidth) {
                    c.width -= (allocatedWidth - this.maxColumnWidth) / 100;
                }
                colsWithWidth++;
            }
            columns.push(c);
        }
        cs = this.columns = columns;
        if (colsWithWidth < len) {
            var remaining = len - colsWithWidth;
            if (allocatedWidth < this.maxColumnWidth) {
                var perCol = ((this.maxColumnWidth - allocatedWidth) / remaining) / 100;
                for (var j = 0; j < len; j++) {
                    var c = cs[j];
                    if (!c.width) {
                        c.width = perCol;
                    }
                }
            }
        }
        Ext.list.ListView.superclass.initComponent.call(this);
    },
    onRender: function(){
        this.autoEl = {
            cls: 'x-list-wrap'
        };
        Ext.list.ListView.superclass.onRender.apply(this, arguments);
        this.internalTpl.overwrite(this.el, {
            columns: this.columns
        });
        this.innerBody = Ext.get(this.el.dom.childNodes[1].firstChild);
        this.innerHd = Ext.get(this.el.dom.firstChild.firstChild);
        if (this.hideHeaders) {
            this.el.dom.firstChild.style.display = 'none';
        }
    },
    getTemplateTarget: function(){
        return this.innerBody;
    },
    collectData: function(){
        var rs = Ext.list.ListView.superclass.collectData.apply(this, arguments);
        return {
            columns: this.columns,
            rows: rs
        };
    },
    verifyInternalSize: function(){
        if (this.lastSize) {
            this.onResize(this.lastSize.width, this.lastSize.height);
        }
    },
    onResize: function(w, h){
        var body = this.innerBody.dom, header = this.innerHd.dom, scrollWidth = w - Ext.num(this.scrollOffset, Ext.getScrollBarWidth()) + 'px', parentNode;
        if (!body) {
            return;
        }
        parentNode = body.parentNode;
        if (Ext.isNumber(w)) {
            if (this.reserveScrollOffset || ((parentNode.offsetWidth - parentNode.clientWidth) > 10)) {
                body.style.width = scrollWidth;
                header.style.width = scrollWidth;
            }
            else {
                body.style.width = w + 'px';
                header.style.width = w + 'px';
                setTimeout(function(){
                    if ((parentNode.offsetWidth - parentNode.clientWidth) > 10) {
                        body.style.width = scrollWidth;
                        header.style.width = scrollWidth;
                    }
                }, 10);
            }
        }
        if (Ext.isNumber(h)) {
            parentNode.style.height = Math.max(0, h - header.parentNode.offsetHeight) + 'px';
        }
    },
    updateIndexes: function(){
        Ext.list.ListView.superclass.updateIndexes.apply(this, arguments);
        this.verifyInternalSize();
    },
    findHeaderIndex: function(header){
        header = header.dom || header;
        var parentNode = header.parentNode, children = parentNode.parentNode.childNodes, i = 0, c;
        for (; c = children[i]; i++) {
            if (c == parentNode) {
                return i;
            }
        }
        return -1;
    },
    setHdWidths: function(){
        var els = this.innerHd.dom.getElementsByTagName('div'), i = 0, columns = this.columns, len = columns.length;
        for (; i < len; i++) {
            els[i].style.width = (columns[i].width * 100) + '%';
        }
    }
});
Ext.reg('listview', Ext.list.ListView);
Ext.ListView = Ext.list.ListView;
Ext.list.Column = Ext.extend(Object, {
    isColumn: true,
    align: 'left',
    header: '',
    width: null,
    cls: '',
    constructor: function(c){
        if (!c.tpl) {
            c.tpl = new Ext.XTemplate('{' + c.dataIndex + '}');
        }
        else 
            if (Ext.isString(c.tpl)) {
                c.tpl = new Ext.XTemplate(c.tpl);
            }
        Ext.apply(this, c);
    }
});
Ext.reg('lvcolumn', Ext.list.Column);
Ext.list.NumberColumn = Ext.extend(Ext.list.Column, {
    format: '0,000.00',
    constructor: function(c){
        c.tpl = c.tpl || new Ext.XTemplate('{' + c.dataIndex + ':number("' + (c.format || this.format) + '")}');
        Ext.list.NumberColumn.superclass.constructor.call(this, c);
    }
});
Ext.reg('lvnumbercolumn', Ext.list.NumberColumn);
Ext.list.DateColumn = Ext.extend(Ext.list.Column, {
    format: 'm/d/Y',
    constructor: function(c){
        c.tpl = c.tpl || new Ext.XTemplate('{' + c.dataIndex + ':date("' + (c.format || this.format) + '")}');
        Ext.list.DateColumn.superclass.constructor.call(this, c);
    }
});
Ext.reg('lvdatecolumn', Ext.list.DateColumn);
Ext.list.CheckboxColumn = Ext.extend(Ext.list.Column, {
    constructor: function(c){
        c.tpl = c.tpl || new Ext.XTemplate('{' + c.dataIndex + ':this.format}');
		c.tpl.positionIndex = c.positionIndex;
		c.tpl.format = function(v,n){
			if(n.type) return '';
			if (v) {
				v = v.split('');
				v = v[this.positionIndex];
			}
			return '<div class="x-grid3-check-col'+(v === undefined || v === '0' || !v || v === 'false'?'':'-on')+' x-grid3-cc">&#160;</div>';
        };
		Ext.list.CheckboxColumn.superclass.constructor.call(this, c);
    }
});
Ext.reg('lvcheckboxcolumn', Ext.list.CheckboxColumn);
Ext.list.BooleanColumn = Ext.extend(Ext.list.Column, {
    trueText: 'true',
    falseText: 'false',
    undefinedText: '&#160;',
    constructor: function(c){
        c.tpl = c.tpl || new Ext.XTemplate('{' + c.dataIndex + ':this.format}');
        var t = this.trueText, f = this.falseText, u = this.undefinedText;
        c.tpl.format = function(v){
            if (v === undefined) {
                return u;
            }
            if (!v || v === 'false') {
                return f;
            }
            return t;
        };
        Ext.list.DateColumn.superclass.constructor.call(this, c);
    }
});
Ext.reg('lvbooleancolumn', Ext.list.BooleanColumn);
Ext.list.ColumnResizer = Ext.extend(Ext.util.Observable, {
    minPct: .05,
    constructor: function(config){
        Ext.apply(this, config);
        Ext.list.ColumnResizer.superclass.constructor.call(this);
    },
    init: function(listView){
        this.view = listView;
        listView.on('render', this.initEvents, this);
    },
    initEvents: function(view){
        view.mon(view.innerHd, 'mousemove', this.handleHdMove, this);
        this.tracker = new Ext.dd.DragTracker({
            onBeforeStart: this.onBeforeStart.createDelegate(this),
            onStart: this.onStart.createDelegate(this),
            onDrag: this.onDrag.createDelegate(this),
            onEnd: this.onEnd.createDelegate(this),
            tolerance: 3,
            autoStart: 300
        });
        this.tracker.initEl(view.innerHd);
        view.on('beforedestroy', this.tracker.destroy, this.tracker);
    },
    handleHdMove: function(e, t){
        var handleWidth = 5, x = e.getPageX(), header = e.getTarget('em', 3, true);
        if (header) {
            var region = header.getRegion(), style = header.dom.style, parentNode = header.dom.parentNode;
            if (x - region.left <= handleWidth && parentNode != parentNode.parentNode.firstChild) {
                this.activeHd = Ext.get(parentNode.previousSibling.firstChild);
                style.cursor = Ext.isWebKit ? 'e-resize' : 'col-resize';
            }
            else 
                if (region.right - x <= handleWidth && parentNode != parentNode.parentNode.lastChild.previousSibling) {
                    this.activeHd = header;
                    style.cursor = Ext.isWebKit ? 'w-resize' : 'col-resize';
                }
                else {
                    delete this.activeHd;
                    style.cursor = '';
                }
        }
    },
    onBeforeStart: function(e){
        this.dragHd = this.activeHd;
        return !!this.dragHd;
    },
    onStart: function(e){
        var me = this, view = me.view, dragHeader = me.dragHd, x = me.tracker.getXY()[0];
        me.proxy = view.el.createChild({
            cls: 'x-list-resizer'
        });
        me.dragX = dragHeader.getX();
        me.headerIndex = view.findHeaderIndex(dragHeader);
        me.headersDisabled = view.disableHeaders;
        view.disableHeaders = true;
        me.proxy.setHeight(view.el.getHeight());
        me.proxy.setX(me.dragX);
        me.proxy.setWidth(x - me.dragX);
        this.setBoundaries();
    },
    setBoundaries: function(relativeX){
        var view = this.view, headerIndex = this.headerIndex, width = view.innerHd.getWidth(), relativeX = view.innerHd.getX(), minWidth = Math.ceil(width * this.minPct), maxWidth = width - minWidth, numColumns = view.columns.length, headers = view.innerHd.select('em', true), minX = minWidth + relativeX, maxX = maxWidth + relativeX, header;
        if (numColumns == 2) {
            this.minX = minX;
            this.maxX = maxX;
        }
        else {
            header = headers.item(headerIndex + 2);
            this.minX = headers.item(headerIndex).getX() + minWidth;
            this.maxX = header ? header.getX() - minWidth : maxX;
            if (headerIndex == 0) {
                this.minX = minX;
            }
            else 
                if (headerIndex == numColumns - 2) {
                    this.maxX = maxX;
                }
        }
    },
    onDrag: function(e){
        var me = this, cursorX = me.tracker.getXY()[0].constrain(me.minX, me.maxX);
        me.proxy.setWidth(cursorX - this.dragX);
    },
    onEnd: function(e){
        var newWidth = this.proxy.getWidth(), index = this.headerIndex, view = this.view, columns = view.columns, width = view.innerHd.getWidth(), newPercent = Math.ceil(newWidth * view.maxColumnWidth / width) / 100, disabled = this.headersDisabled, headerCol = columns[index], otherCol = columns[index + 1], totalPercent = headerCol.width + otherCol.width;
        this.proxy.remove();
        headerCol.width = newPercent;
        otherCol.width = totalPercent - newPercent;
        delete this.dragHd;
        view.setHdWidths();
        view.refresh();
        setTimeout(function(){
            view.disableHeaders = disabled;
        }, 100);
    }
});
Ext.ListView.ColumnResizer = Ext.list.ColumnResizer;
Ext.list.Sorter = Ext.extend(Ext.util.Observable, {
    sortClasses: ["sort-asc", "sort-desc"],
    constructor: function(config){
        Ext.apply(this, config);
        Ext.list.Sorter.superclass.constructor.call(this);
    },
    init: function(listView){
        this.view = listView;
        listView.on('render', this.initEvents, this);
    },
    initEvents: function(view){
        view.mon(view.innerHd, 'click', this.onHdClick, this);
        view.innerHd.setStyle('cursor', 'pointer');
        view.mon(view.store, 'datachanged', this.updateSortState, this);
        this.updateSortState.defer(10, this, [view.store]);
    },
    updateSortState: function(store){
        var state = store.getSortState();
        if (!state) {
            return;
        }
        this.sortState = state;
        var cs = this.view.columns, sortColumn = -1;
        for (var i = 0, len = cs.length; i < len; i++) {
            if (cs[i].dataIndex == state.field) {
                sortColumn = i;
                break;
            }
        }
        if (sortColumn != -1) {
            var sortDir = state.direction;
            this.updateSortIcon(sortColumn, sortDir);
        }
    },
    updateSortIcon: function(col, dir){
        var sc = this.sortClasses;
        var hds = this.view.innerHd.select('em').removeClass(sc);
        hds.item(col).addClass(sc[dir == "DESC" ? 1 : 0]);
    },
    onHdClick: function(e){
        var hd = e.getTarget('em', 3);
        if (hd && !this.view.disableHeaders) {
            var index = this.view.findHeaderIndex(hd);
            this.view.store.sort(this.view.columns[index].dataIndex);
        }
    }
});
Ext.ListView.Sorter = Ext.list.Sorter;
Ext.ux.tree.TreeGrid = Ext.extend(Ext.tree.TreePanel, {
    rootVisible: false,
    useArrows: true,
    lines: false,
    borderWidth: Ext.isBorderBox ? 0 : 2,
    cls: 'x-treegrid',
    columnResize: true,
    enableSort: true,
    reserveScrollOffset: true,
    enableHdMenu: true,
    columnsText: 'Columns',
    checkModel: 'multiple',
    showIcon: true,
    onlyLeafCheckable: false,
    checkTreeGrid: false,
    checkColumn: false,
    initComponent: function(){
        if (!this.root) {
            this.root = new Ext.tree.AsyncTreeNode({
                text: 'Root'
            });
        }
        var l = this.loader;
        if (!l) {
            l = new Ext.ux.tree.TreeGridLoader({
                baseAttrs: {
                    uiProvider: Ext.ux.TreeCheckNodeUI
                },
                dataUrl: this.dataUrl,
                requestMethod: this.requestMethod,
				baseParams:this.baseParams,
                store: this.store
            });
        }
        else 
            if (Ext.isObject(l) && !l.load) {
                l = new Ext.ux.tree.TreeGridLoader(l);
            }
        this.loader = l;
        Ext.ux.tree.TreeGrid.superclass.initComponent.call(this);
        this.initColumns();
        if (this.enableSort) {
            this.treeGridSorter = new Ext.ux.tree.TreeGridSorter(this, this.enableSort);
        }
        if (this.columnResize) {
            this.colResizer = new Ext.tree.ColumnResizer(this.columnResize);
            this.colResizer.init(this);
        }
        var c = this.columns;
        if (!this.internalTpl) {
            this.internalTpl = new Ext.XTemplate(
			'<div class="x-grid3-header">', 
			'<div class="x-treegrid-header-inner">', 
			'<div class="x-grid3-header-offset">', 
			'<table style="table-layout: fixed;" cellspacing="0" cellpadding="0" border="0"><colgroup><tpl for="columns"><col /></tpl></colgroup>', 
			'<thead><tr class="x-grid3-hd-row">', 
			'<tpl for="columns">', 
			'<td class="x-grid3-hd x-grid3-cell x-treegrid-hd" style="text-align: {align};" id="', this.id, '-xlhd-{#}">', 
			'<div class="x-grid3-hd-inner x-treegrid-hd-inner" unselectable="on">', 
			this.enableHdMenu ? '<a class="x-grid3-hd-btn" href="#"></a>' : '', 
			'{header}<img class="x-grid3-sort-icon" src="', Ext.BLANK_IMAGE_URL, '" />', 
			'</div>', 
			'</td></tpl>', 
			'</tr></thead>', 
			'</table>', 
			'</div></div>', 
			'</div>', 
			'<div class="x-treegrid-root-node">', 
			'<table class="x-treegrid-root-table" cellpadding="0" cellspacing="0" style="table-layout: fixed;"></table>', '</div>');
        }
        if (!this.colgroupTpl) {
            this.colgroupTpl = new Ext.XTemplate('<colgroup><tpl for="columns"><col style="width: {width}px"/></tpl></colgroup>');
        }
		this.addEvents('cellclick');
    },
    initColumns: function(){
        var cs = this.columns, len = cs.length, columns = [], i, c;
        for (i = 0; i < len; i++) {
            c = cs[i];
            if (!c.isColumn) {
                c.xtype = c.xtype ? (/^tg/.test(c.xtype) ? c.xtype : 'tg' + c.xtype) : 'tgcolumn';
                c = Ext.create(c);
            }
            c.init(this);
            columns.push(c);
            if (this.enableSort !== false && c.sortable !== false) {
                c.sortable = true;
                this.enableSort = true;
            }
        }
        this.columns = columns;
    },
    onRender: function(){
        Ext.tree.TreePanel.superclass.onRender.apply(this, arguments);
        this.el.addClass('x-treegrid');
        this.outerCt = this.body.createChild({
            cls: 'x-tree-root-ct x-treegrid-ct ' + (this.useArrows ? 'x-tree-arrows' : this.lines ? 'x-tree-lines' : 'x-tree-no-lines')
        });
        this.internalTpl.overwrite(this.outerCt, {
            columns: this.columns
        });
        this.mainHd = Ext.get(this.outerCt.dom.firstChild);
        this.innerHd = Ext.get(this.mainHd.dom.firstChild);
        this.innerBody = Ext.get(this.outerCt.dom.lastChild);
        this.innerCt = Ext.get(this.innerBody.dom.firstChild);
        this.colgroupTpl.insertFirst(this.innerCt, {
            columns: this.columns
        });
        if (this.hideHeaders) {
            this.el.child('.x-grid3-header').setDisplayed('none');
        }
        else 
            if (this.enableHdMenu !== false) {
                this.hmenu = new Ext.menu.Menu({
                    id: this.id + '-hctx'
                });
                if (this.enableColumnHide !== false) {
                    this.colMenu = new Ext.menu.Menu({
                        id: this.id + '-hcols-menu'
                    });
                    this.colMenu.on({
                        scope: this,
                        beforeshow: this.beforeColMenuShow,
                        itemclick: this.handleHdMenuClick
                    });
                    this.hmenu.add({
                        itemId: 'columns',
                        hideOnClick: false,
                        text: this.columnsText,
                        menu: this.colMenu,
                        iconCls: 'x-cols-icon'
                    });
                }
                this.hmenu.on('itemclick', this.handleHdMenuClick, this);
            }
    },
    setRootNode: function(node){
        node.attributes.uiProvider = Ext.ux.tree.TreeGridRootNodeUI;
        node = Ext.ux.tree.TreeGrid.superclass.setRootNode.call(this, node);
        if (this.innerCt) {
            this.colgroupTpl.insertFirst(this.innerCt, {
                columns: this.columns
            });
        }
        return node;
    },
    clearInnerCt: function(){
        if (Ext.isIE) {
            var dom = this.innerCt.dom;
            while (dom.firstChild) {
                dom.removeChild(dom.firstChild);
            }
        }
        else {
            Ext.ux.tree.TreeGrid.superclass.clearInnerCt.call(this);
        }
    },
    initEvents: function(){
        Ext.ux.tree.TreeGrid.superclass.initEvents.apply(this, arguments);
        this.mon(this.innerBody, 'scroll', this.syncScroll, this);
        this.mon(this.innerHd, 'click', this.handleHdDown, this);
        this.mon(this.mainHd, {
            scope: this,
            mouseover: this.handleHdOver,
            mouseout: this.handleHdOut
        });
    },
    onResize: function(w, h){
        Ext.ux.tree.TreeGrid.superclass.onResize.apply(this, arguments);
        var bd = this.innerBody.dom;
        var hd = this.innerHd.dom;
        if (!bd) {
            return;
        }
        if (Ext.isNumber(h)) {
            bd.style.height = this.body.getHeight(true) - hd.offsetHeight + 'px';
        }
        if (Ext.isNumber(w)) {
            var sw = Ext.num(this.scrollOffset, Ext.getScrollBarWidth());
            if (this.reserveScrollOffset || ((bd.offsetWidth - bd.clientWidth) > 10)) {
                this.setScrollOffset(sw);
            }
            else {
                var me = this;
                setTimeout(function(){
                    me.setScrollOffset(bd.offsetWidth - bd.clientWidth > 10 ? sw : 0);
                }, 10);
            }
        }
    },
    updateColumnWidths: function(){
        var cols = this.columns, colCount = cols.length, groups = this.outerCt.query('colgroup'), groupCount = groups.length, c, g, i, j;
        for (i = 0; i < colCount; i++) {
            c = cols[i];
            for (j = 0; j < groupCount; j++) {
                g = groups[j];
                g.childNodes[i].style.width = (c.hidden ? 0 : c.width) + 'px';
            }
        }
        for (i = 0, groups = this.innerHd.query('td'), len = groups.length; i < len; i++) {
            c = Ext.fly(groups[i]);
            if (cols[i] && cols[i].hidden) {
                c.addClass('x-treegrid-hd-hidden');
            }
            else {
                c.removeClass('x-treegrid-hd-hidden');
            }
        }
        var tcw = this.getTotalColumnWidth();
        Ext.fly(this.innerHd.dom.firstChild).setWidth(tcw + (this.scrollOffset || 0));
        this.outerCt.select('table').setWidth(tcw);
        this.syncHeaderScroll();
    },
    getVisibleColumns: function(){
        var columns = [], cs = this.columns, len = cs.length, i;
        for (i = 0; i < len; i++) {
            if (!cs[i].hidden) {
                columns.push(cs[i]);
            }
        }
        return columns;
    },
    getTotalColumnWidth: function(){
        var total = 0;
        for (var i = 0, cs = this.getVisibleColumns(), len = cs.length; i < len; i++) {
            total += cs[i].width;
        }
        return total;
    },
    setScrollOffset: function(scrollOffset){
        this.scrollOffset = scrollOffset;
        this.updateColumnWidths();
    },
    handleHdDown: function(e, t){
        var hd = e.getTarget('.x-treegrid-hd');
        if (hd && Ext.fly(t).hasClass('x-grid3-hd-btn')) {
            var ms = this.hmenu.items, cs = this.columns, index = this.findHeaderIndex(hd), c = cs[index], sort = c.sortable;
            e.stopEvent();
            Ext.fly(hd).addClass('x-grid3-hd-menu-open');
            this.hdCtxIndex = index;
            this.fireEvent('headerbuttonclick', ms, c, hd, index);
            this.hmenu.on('hide', function(){
                Ext.fly(hd).removeClass('x-grid3-hd-menu-open');
            }, this, {
                single: true
            });
            this.hmenu.show(t, 'tl-bl?');
        }
        else 
            if (hd) {
                var index = this.findHeaderIndex(hd);
                this.fireEvent('headerclick', this.columns[index], hd, index);
            }
    },
    handleHdOver: function(e, t){
        var hd = e.getTarget('.x-treegrid-hd');
        if (hd && !this.headersDisabled) {
            index = this.findHeaderIndex(hd);
            this.activeHdRef = t;
            this.activeHdIndex = index;
            var el = Ext.get(hd);
            this.activeHdRegion = el.getRegion();
            el.addClass('x-grid3-hd-over');
            this.activeHdBtn = el.child('.x-grid3-hd-btn');
            if (this.activeHdBtn) {
                this.activeHdBtn.dom.style.height = (hd.firstChild.offsetHeight - 1) + 'px';
            }
        }
    },
    handleHdOut: function(e, t){
        var hd = e.getTarget('.x-treegrid-hd');
        if (hd && (!Ext.isIE || !e.within(hd, true))) {
            this.activeHdRef = null;
            Ext.fly(hd).removeClass('x-grid3-hd-over');
            hd.style.cursor = '';
        }
    },
    findHeaderIndex: function(hd){
        hd = hd.dom || hd;
        var cs = hd.parentNode.childNodes;
        for (var i = 0, c; c = cs[i]; i++) {
            if (c == hd) {
                return i;
            }
        }
        return -1;
    },
    beforeColMenuShow: function(){
        var cols = this.columns, colCount = cols.length, i, c;
        this.colMenu.removeAll();
        for (i = 1; i < colCount; i++) {
            c = cols[i];
            if (c.hideable !== false) {
                this.colMenu.add(new Ext.menu.CheckItem({
                    itemId: 'col-' + i,
                    text: c.header,
                    checked: !c.hidden,
                    hideOnClick: false,
                    disabled: c.hideable === false
                }));
            }
        }
    },
    handleHdMenuClick: function(item){
        var index = this.hdCtxIndex, id = item.getItemId();
        if (this.fireEvent('headermenuclick', this.columns[index], id, index) !== false) {
            index = id.substr(4);
            if (index > 0 && this.columns[index]) {
                this.setColumnVisible(index, !item.checked);
            }
        }
        return true;
    },
    setColumnVisible: function(index, visible){
        this.columns[index].hidden = !visible;
        this.updateColumnWidths();
    },
    scrollToTop: function(){
        this.innerBody.dom.scrollTop = 0;
        this.innerBody.dom.scrollLeft = 0;
    },
    syncScroll: function(){
        this.syncHeaderScroll();
        var mb = this.innerBody.dom;
        this.fireEvent('bodyscroll', mb.scrollLeft, mb.scrollTop);
    },
    syncHeaderScroll: function(){
        var mb = this.innerBody.dom;
        this.innerHd.dom.scrollLeft = mb.scrollLeft;
        this.innerHd.dom.scrollLeft = mb.scrollLeft;
    },
    registerNode: function(n){
        Ext.ux.tree.TreeGrid.superclass.registerNode.call(this, n);
        if (!n.uiProvider && !n.isRoot && !n.ui.isTreeGridNodeUI) {
            n.ui = new Ext.ux.tree.TreeGridNodeUI(n);
        }
    }
});
Ext.reg('treegrid', Ext.ux.tree.TreeGrid);
Ext.tree.ColumnResizer = Ext.extend(Ext.util.Observable, {
    minWidth: 14,
    constructor: function(config){
        Ext.apply(this, config);
        Ext.tree.ColumnResizer.superclass.constructor.call(this);
    },
    init: function(tree){
        this.tree = tree;
        tree.on('render', this.initEvents, this);
    },
    initEvents: function(tree){
        tree.mon(tree.innerHd, 'mousemove', this.handleHdMove, this);
        this.tracker = new Ext.dd.DragTracker({
            onBeforeStart: this.onBeforeStart.createDelegate(this),
            onStart: this.onStart.createDelegate(this),
            onDrag: this.onDrag.createDelegate(this),
            onEnd: this.onEnd.createDelegate(this),
            tolerance: 3,
            autoStart: 300
        });
        this.tracker.initEl(tree.innerHd);
        tree.on('beforedestroy', this.tracker.destroy, this.tracker);
    },
    handleHdMove: function(e, t){
        var hw = 5, x = e.getPageX(), hd = e.getTarget('.x-treegrid-hd', 3, true);
        if (hd) {
            var r = hd.getRegion(), ss = hd.dom.style, pn = hd.dom.parentNode;
            if (x - r.left <= hw && hd.dom !== pn.firstChild) {
                var ps = hd.dom.previousSibling;
                while (ps && Ext.fly(ps).hasClass('x-treegrid-hd-hidden')) {
                    ps = ps.previousSibling;
                }
                if (ps) {
                    this.activeHd = Ext.get(ps);
                    ss.cursor = Ext.isWebKit ? 'e-resize' : 'col-resize';
                }
            }
            else 
                if (r.right - x <= hw) {
                    var ns = hd.dom;
                    while (ns && Ext.fly(ns).hasClass('x-treegrid-hd-hidden')) {
                        ns = ns.previousSibling;
                    }
                    if (ns) {
                        this.activeHd = Ext.get(ns);
                        ss.cursor = Ext.isWebKit ? 'w-resize' : 'col-resize';
                    }
                }
                else {
                    delete this.activeHd;
                    ss.cursor = '';
                }
        }
    },
    onBeforeStart: function(e){
        this.dragHd = this.activeHd;
        return !!this.dragHd;
    },
    onStart: function(e){
        this.dragHeadersDisabled = this.tree.headersDisabled;
        this.tree.headersDisabled = true;
        this.proxy = this.tree.body.createChild({
            cls: 'x-treegrid-resizer'
        });
        this.proxy.setHeight(this.tree.body.getHeight());
        var x = this.tracker.getXY()[0];
        this.hdX = this.dragHd.getX();
        this.hdIndex = this.tree.findHeaderIndex(this.dragHd);
        this.proxy.setX(this.hdX);
        this.proxy.setWidth(x - this.hdX);
        this.maxWidth = this.tree.outerCt.getWidth() - this.tree.innerBody.translatePoints(this.hdX).left;
    },
    onDrag: function(e){
        var cursorX = this.tracker.getXY()[0];
        this.proxy.setWidth((cursorX - this.hdX).constrain(this.minWidth, this.maxWidth));
    },
    onEnd: function(e){
        var nw = this.proxy.getWidth(), tree = this.tree, disabled = this.dragHeadersDisabled;
        this.proxy.remove();
        delete this.dragHd;
        tree.columns[this.hdIndex].width = nw;
        tree.updateColumnWidths();
        setTimeout(function(){
            tree.headersDisabled = disabled;
        }, 100);
    }
});
(function(){
    Ext.override(Ext.list.Column, {
        init: function(){
            var types = Ext.data.Types, st = this.sortType;
            if (this.type) {
                if (Ext.isString(this.type)) {
                    this.type = Ext.data.Types[this.type.toUpperCase()] || types.AUTO;
                }
            }
            else {
                this.type = types.AUTO;
            }
            if (Ext.isString(st)) {
                this.sortType = Ext.data.SortTypes[st];
            }
            else 
                if (Ext.isEmpty(st)) {
                    this.sortType = this.type.sortType;
                }
        }
    });
    Ext.tree.Column = Ext.extend(Ext.list.Column, {});
    Ext.tree.NumberColumn = Ext.extend(Ext.list.NumberColumn, {});
    Ext.tree.DateColumn = Ext.extend(Ext.list.DateColumn, {});
    Ext.tree.BooleanColumn = Ext.extend(Ext.list.BooleanColumn, {});
    Ext.tree.CheckboxColumn = Ext.extend(Ext.list.CheckboxColumn, {});
    Ext.reg('tgcolumn', Ext.tree.Column);
    Ext.reg('tgnumbercolumn', Ext.tree.NumberColumn);
    Ext.reg('tgdatecolumn', Ext.tree.DateColumn);
    Ext.reg('tgbooleancolumn', Ext.tree.BooleanColumn);
    Ext.reg('tgcheckboxcolumn', Ext.tree.CheckboxColumn);
})();
Ext.ux.tree.TreeGridLoader = Ext.extend(Ext.tree.TreeLoader, {
    createNode: function(attr){
        if (!attr.uiProvider) {
            attr.uiProvider = Ext.ux.tree.TreeGridNodeUI;
        }
        return Ext.tree.TreeLoader.prototype.createNode.call(this, attr);
    }
});
Ext.ux.tree.TreeGridNodeUI = Ext.extend(Ext.tree.TreeNodeUI, {
    isTreeGridNodeUI: true,
    checkModel: 'multiple',
    onlyLeafCheckable: false,
    checkTreeGrid: false,
	checkColumn:false,
    renderElements: function(n, a, targetNode, bulkRender){
        var t = n.getOwnerTree(), cols = t.columns, c = cols[0], i, buf, len;
		this.checkColumn = t.checkColumn || this.checkColumn;
        this.checkModel = t.checkModel || this.checkModel;
        this.onlyLeafCheckable = t.onlyLeafCheckable || this.onlyLeafCheckable;
        this.checkTreeGrid = t.checkTreeGrid || this.checkTreeGrid;
        var showIcon = t.showIcon;
        this.indentMarkup = n.parentNode ? n.parentNode.ui.getChildIndent() : '';
        var cb = this.checkTreeGrid ? (!this.onlyLeafCheckable || a.leaf) : false;
        buf = ['<tbody class="x-tree-node">', '<tr ext:tree-node-id="', n.id, '" class="x-tree-node-el x-tree-node-leaf ', a.cls, '">', '<td class="x-treegrid-col">', '<span class="x-tree-node-indent">', this.indentMarkup, "</span>", '<img src="', this.emptyIcon, '" class="x-tree-ec-icon x-tree-elbow" />', '<img src="', a.icon || this.emptyIcon, '" class="', (showIcon ? 'x-tree-node-icon' : ''), (a.icon ? " x-tree-node-inline-icon" : ""), (a.iconCls ? " " + a.iconCls : ""), '" unselectable="on" />', cb ? ('<input class="x-tree-node-cb" type="checkbox" ' + (a.checked ? 'checked="checked" />' : '/>')) : '', '<a hidefocus="on" class="x-tree-node-anchor" href="', a.href ? a.href : '#', '" tabIndex="1" ', a.hrefTarget ? ' target="' + a.hrefTarget + '"' : '', '>', '<span unselectable="on">', (c.tpl ? c.tpl.apply(a) : a[c.dataIndex] || c.text), '</span></a>', '</td>'];
        for (var i = 1, len = cols.length; i < len; i++) {
            c = cols[i];
            buf.push('<td class="x-treegrid-col ', (c.cls ? c.cls : ''), '">', '<div unselectable="on" class="x-treegrid-text"', (c.align ? ' style="text-align: ' + c.align + ';"' : ''), '>', (c.tpl ? c.tpl.apply(a) : a[c.dataIndex]), '</div>', '</td>');
        }
        buf.push('</tr><tr class="x-tree-node-ct"><td colspan="', cols.length, '">', '<table class="x-treegrid-node-ct-table" cellpadding="0" cellspacing="0" style="table-layout: fixed; display: none; width: ', t.innerCt.getWidth(), 'px;"><colgroup>');
        for (var i = 0, len = cols.length; i < len; i++) {
            buf.push('<col style="width: ', (cols[i].hidden ? 0 : cols[i].width), 'px;" />');
        }
        buf.push('</colgroup></table></td></tr></tbody>');
        if (bulkRender !== true && n.nextSibling && n.nextSibling.ui.getEl()) {
            this.wrap = Ext.DomHelper.insertHtml("beforeBegin", n.nextSibling.ui.getEl(), buf.join(''));
        }
        else {
            this.wrap = Ext.DomHelper.insertHtml("beforeEnd", targetNode, buf.join(''));
        }
        this.elNode = this.wrap.childNodes[0];
        this.ctNode = this.wrap.childNodes[1].firstChild.firstChild;
        var cs = this.elNode.firstChild.childNodes;
        this.indentNode = cs[0];
        this.ecNode = cs[1];
        this.iconNode = cs[2];
        var index = 3;
        if (cb) {
            this.checkbox = cs[3];
            Ext.fly(this.checkbox).on('click', this.check.createDelegate(this, [null]));
            index++;
        }
        this.anchor = cs[index];
        this.textNode = cs[index].firstChild;
        this.otherNode = [];
		for (var i = 1, len = this.elNode.childNodes.length; i < len; i++) {
			var td = this.elNode.childNodes[i].firstChild;
			td.columnIndex = i;
			this.otherNode.push(td);
        }
    },
	setACL:function(t){
		if(this.node.attributes['type']) return;
		var acl='',len = this.otherNode.length;
		if(t=='all') for(var i=0;i<len;i++) acl += '1';
		else if(t=='none') for(var i=0;i<len;i++) acl += '0';
		else if(t && Ext.isString(t) && t.length == len) acl = t;
		else acl= this.node.attributes['acl'];
		acl = acl.split('');
		for(var i=0;i<len;i++){
			this.setCls(this.otherNode[i].firstChild,parseInt(acl[this.otherNode[i].columnIndex-1]));
		}
		this.node.attributes['acl'] = acl.join('');
	},
	setCls: function(o, f){
        if (!o) 
            return;
		if(f){
			if(o.className.indexOf('x-grid3-check-col-on')!=-1) return;
			else if(o.className.indexOf('x-grid3-check-col')!=-1) o.className = o.className.replace(new RegExp('( ?|^)x-grid3-check-col\\b'), 'x-grid3-check-col-on');
			else o.className = o.className.length > 0 ? (o.className + ' x-grid3-check-col-on') : 'x-grid3-check-col-on';
		}else{
			if(o.className.indexOf('x-grid3-check-col-on')!=-1) o.className = o.className.replace(new RegExp('( ?|^)x-grid3-check-col-on\\b'), 'x-grid3-check-col');
			else if(o.className.indexOf('x-grid3-check-col')!=-1) return;
			else o.className = o.className.length > 0 ? (o.className + ' x-grid3-check-col') : 'x-grid3-check-col';
		}
    },
    animExpand: function(cb){
        this.ctNode.style.display = "";
        Ext.ux.tree.TreeGridNodeUI.superclass.animExpand.call(this, cb);
    },
    check: function(checked){
        var n = this.node;
        var tree = n.getOwnerTree();
		tree.aclChange = true;
        this.checkModel = tree.checkModel || this.checkModel;
        if (checked === null) {
            checked = this.checkbox.checked;
        }
        else {
            this.checkbox.checked = checked;
        }
        n.attributes.checked = checked;
        tree.fireEvent('check', n, checked);
        if (!this.onlyLeafCheckable) {
            if (this.checkModel == 'cascade' || this.checkModel == 'parentCascade') {
                var parentNode = n.parentNode;
                if (parentNode !== null) {
                    this.parentCheck(parentNode, checked);
                }
            }
            if (this.checkModel == 'cascade' || this.checkModel == 'childCascade') {
                if (!n.expanded && !n.childrenRendered) {
                    n.expand(false, false, this.childCheck);
                }
                else {
                    this.childCheck(n);
                }
            }
        }
        else 
            if (this.checkModel == 'single') {
                var checkedNodes = tree.getChecked();
                for (var i = 0; i < checkedNodes.length; i++) {
                    var node = checkedNodes[i];
                    if (node.id != n.id) {
                        node.getUI().checkbox.checked = false;
                        node.attributes.checked = false;
                        tree.fireEvent('check', node, false);
                    }
                }
            }
		if(this.checkColumn)this.setACL(checked ? 'all' : 'none');
    },
    childCheck: function(node){
        var a = node.attributes;
        if (!a.leaf) {
            var cs = node.childNodes;
            var csui;
            for (var i = 0; i < cs.length; i++) {
                csui = cs[i].getUI();
                if (csui.checkbox.checked ^ a.checked) 
                    csui.check(a.checked);
            }
        }
    },
    parentCheck: function(node, checked){
        var checkbox = node.getUI().checkbox;
        if (typeof checkbox == 'undefined') 
            return;
        if (!(checked ^ checkbox.checked)) 
            return;
        if (!checked && this.childHasChecked(node)) 
            return;
        checkbox.checked = checked;
        node.attributes.checked = checked;
        node.getOwnerTree().fireEvent('check', node, checked);
        var parentNode = node.parentNode;
        if (parentNode !== null) {
            this.parentCheck(parentNode, checked);
        }
    },
    childHasChecked: function(node){
        var childNodes = node.childNodes;
        if (childNodes || childNodes.length > 0) {
            for (var i = 0; i < childNodes.length; i++) {
                if (childNodes[i].getUI().checkbox.checked) 
                    return true;
            }
        }
        return false;
    },
    toggleCheck: function(value){
        var cb = this.checkbox;
        if (cb) {
            var checked = (value === undefined ? !cb.checked : value);
            this.check(checked);
        }
    }
});
Ext.ux.tree.TreeGridRootNodeUI = Ext.extend(Ext.tree.TreeNodeUI, {
    isTreeGridNodeUI: true,
    render: function(){
        if (!this.rendered) {
            this.wrap = this.ctNode = this.node.ownerTree.innerCt.dom;
            this.node.expanded = true;
        }
        if (Ext.isWebKit) {
            var ct = this.ctNode;
            ct.style.tableLayout = null;
            (function(){
                ct.style.tableLayout = 'fixed';
            }).defer(1);
        }
    },
    destroy: function(){
        if (this.elNode) {
            Ext.dd.Registry.unregister(this.elNode.id);
        }
        delete this.node;
    },
    collapse: Ext.emptyFn,
    expand: Ext.emptyFn
});
Ext.ns('Ext.ux.tree');
Ext.ux.tree.TreeGridSorter = Ext.extend(Ext.tree.TreeSorter, {
    sortClasses: ['sort-asc', 'sort-desc'],
    sortAscText: 'Sort Ascending',
    sortDescText: 'Sort Descending',
    constructor: function(tree, config){
        if (!Ext.isObject(config)) {
            config = {
                property: tree.columns[0].dataIndex || 'text',
                folderSort: true
            }
        }
        Ext.ux.tree.TreeGridSorter.superclass.constructor.apply(this, arguments);
        this.tree = tree;
        tree.on('headerclick', this.onHeaderClick, this);
        tree.ddAppendOnly = true;
        var me = this;
        this.defaultSortFn = function(n1, n2){
            var desc = me.dir && me.dir.toLowerCase() == 'desc', prop = me.property || 'text', sortType = me.sortType, caseSensitive = me.caseSensitive === true, leafAttr = me.leafAttr || 'leaf', attr1 = n1.attributes, attr2 = n2.attributes;
            if (me.folderSort) {
                if (attr1[leafAttr] && !attr2[leafAttr]) {
                    return 1;
                }
                if (!attr1[leafAttr] && attr2[leafAttr]) {
                    return -1;
                }
            }
            var prop1 = attr1[prop], prop2 = attr2[prop], v1 = sortType ? sortType(prop1) : (caseSensitive ? prop1 : prop1.toUpperCase());
            v2 = sortType ? sortType(prop2) : (caseSensitive ? prop2 : prop2.toUpperCase());
            if (v1 < v2) {
                return desc ? +1 : -1;
            }
            else 
                if (v1 > v2) {
                    return desc ? -1 : +1;
                }
                else {
                    return 0;
                }
        };
        tree.on('afterrender', this.onAfterTreeRender, this, {
            single: true
        });
        tree.on('headermenuclick', this.onHeaderMenuClick, this);
    },
    onAfterTreeRender: function(){
        if (this.tree.hmenu) {
            this.tree.hmenu.insert(0, {
                itemId: 'asc',
                text: this.sortAscText,
                cls: 'xg-hmenu-sort-asc'
            }, {
                itemId: 'desc',
                text: this.sortDescText,
                cls: 'xg-hmenu-sort-desc'
            });
        }
        this.updateSortIcon(0, 'asc');
    },
    onHeaderMenuClick: function(c, id, index){
        if (id === 'asc' || id === 'desc') {
            this.onHeaderClick(c, null, index);
            return false;
        }
    },
    onHeaderClick: function(c, el, i){
        if (c && !this.tree.headersDisabled) {
            var me = this;
            me.property = c.dataIndex;
            me.dir = c.dir = (c.dir === 'desc' ? 'asc' : 'desc');
            me.sortType = c.sortType;
            me.caseSensitive === Ext.isBoolean(c.caseSensitive) ? c.caseSensitive : this.caseSensitive;
            me.sortFn = c.sortFn || this.defaultSortFn;
            this.tree.root.cascade(function(n){
                if (!n.isLeaf()) {
                    me.updateSort(me.tree, n);
                }
            });
            this.updateSortIcon(i, c.dir);
        }
    },
    updateSortIcon: function(col, dir){
        var sc = this.sortClasses, hds = this.tree.innerHd.select('td').removeClass(sc);
        hds.item(col).addClass(sc[dir == 'desc' ? 1 : 0]);
    }
});
