EXCMS.Category = {
	baseAction : 'index.php?M=Category&A=Index',
	isGroupChange : true,
	init : function(){
	    Ext.QuickTips.init();
		this.groupNode = {};
		this.view();
		btn = this.grid.topToolbar.items.items;
		btt = this.tree.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				if (btn[i].acl == 'edit') {
					this.disableedit = true;
					this.grid.on('beforeedit',function(e){e.cancel = true;},this);
				}
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
		for(var i=0;i<btt.length;i++){
			if(btt[i].acl&&!excmsacl[btt[i].acl]){
				btt[i].hide();
			}
		}
		for(var i=0;i<this.treeMenu.items.items.length;i++){
			if(this.treeMenu.items.items[i].acl&&!excmsacl[this.treeMenu.items.items[i].acl]){
				this.treeMenu.items.items[i].hide();
			}
		}	
	},
	view : function(){
		this.tree = new Ext.tree.TreePanel({title:'分类组',id:'west',region:'west',cls:'channel-tree category-tree',bodyStyle:'padding:8px 1px',style:'border-right:1px solid #99BBE8;',
			border:false,collapseMode:'mini',collapsible:true,split:true,width:200,minSize:35,autoScroll:true,rootVisible:false,useArrows:true,
            root:new Ext.tree.AsyncTreeNode({id:'0',text:'编辑器',expanded:true,leaf:0}),
			loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),
			tbar:[
				{text:'新建',handler:this.editCateGroup,scope:this,mode:0,acl:'addcategory'},
				{text:'编辑',handler:this.editCateGroup,scope:this,mode:1,acl:'editcategory'},
				{text:'删除',handler:this.delCateGroup,scope:this,acl:'delcategory'}
			]
        });
		this.treeMenu = new Ext.menu.Menu({items:[
			{text:'新建组',handler:this.editCateGroup,scope:this,acl:'addcategory'},
			{text:'新建分类',handler:this.edit,scope:this,acl:'add'},'-',
	   	 	{text:'编辑',handler:this.editCateGroup,scope:this,edit:1,acl:'editcategory'},
	   	 	{text:'删除',handler:this.delCateGroup,scope:this,acl:'delcategory'}
	  	]});
		this.tree.on('click',function(n){
			if(this.groupNode&&this.groupNode.id == n.id) return;
			this.groupNode = n;
			if(n.attributes['editable']){
				this.tree.topToolbar.items.items[1].enable();this.tree.topToolbar.items.items[2].enable();
				this.treeMenu.items.items[3].enable();this.treeMenu.items.items[4].enable();
			}else{
				this.tree.topToolbar.items.items[1].disable();this.tree.topToolbar.items.items[2].disable();
				this.treeMenu.items.items[3].disable();this.treeMenu.items.items[4].disable();
			}
			this.D.baseParams.group=n.id;
			this.D.reload();
		},this);
		this.tree.on('contextmenu',function(n,e){
	    	n.select();
			this.treeMenu.showAt(e.getXY());
			if (this.groupNode&&this.groupNode.id == n.id) return;
			if(n.attributes['editable']){
				this.tree.topToolbar.items.items[1].enable();this.tree.topToolbar.items.items[2].enable();
				this.treeMenu.items.items[3].enable();this.treeMenu.items.items[4].enable();
			}else{
				this.tree.topToolbar.items.items[1].disable();this.tree.topToolbar.items.items[2].disable();
				this.treeMenu.items.items[3].disable();this.treeMenu.items.items[4].disable();
			}
			this.groupNode = n;
			this.D.baseParams.group=n.id;
			this.D.reload();
	    },this);
		
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
            reader: new Ext.data.JsonReader({
                root: 'data',totalProperty: 'total',id: 'categoryid',
                fields:["categoryid","group","name","identify","description","table",{name:'ismultilevel',type:'int'},{name:'status',type:'int'},{name:'issystem',type:'int'},"sort"]
            }),remoteSort:false
        });

		this.soField = new Ext.form.TwinTriggerField({emptyText:'请输入名称,标识,描述关键字',width:200,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		
		this.grid = new Ext.grid.EditorGridPanel({region:'center',title:'分类模型管理',store:this.D,border:false,
			minColumnWidth:2,sm:new Ext.grid.RowSelectionModel(),
            columns:[
				{header:"分类ID",width:60,sortable:true,dataIndex:'categoryid'},
				{header:"分类名称",width:100,sortable:true,dataIndex:'name'},
				{header:"分类标识",width:100,sortable:true,dataIndex:'identify'},
				{header:"分类表",width:150,sortable:true,dataIndex:'table'},
				{header:"描述",width:220,sortable:true,dataIndex:'description'},
				{header:"状态",width:48,align:'center',sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
				{header:"多级?",width:48,align:'center',sortable:true,dataIndex:'ismultilevel',renderer:this.renderIsSys,scope:this},
				{header:"系统?",width:48,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
				{header:"排序",width:56,align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
			],
			tbar:[
				{text:'新建',handler:this.edit,scope:this,mode:0,acl:'add'},
				{text:'编辑',handler:this.edit,scope:this,mode:1,acl:'edit'},
				{text:'删除',handler:this.del,scope:this,acl:'delete'},
				{text:'启用',handler:this.setCategoryStatus,scope:this,mode:1,acl:'rewrite'},'-',
				{text:'字段管理',handler:this.categoryField,scope:this,acl:'managefields'},
				{text:'数据管理',handler:this.loadDataGrid,scope:this,acl:'managedata'},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this},
				'->','搜索分类 ',this.soField
			],
			bbar: new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示{0} - {1} 共{2}条',emptyMsg:'暂时没有数据',beforePageText:'第',afterPageText:'页 共{0}页'})
		});   
		this.gridMenu = new Ext.menu.Menu({items:[
            {text:'新建',icon:ico,iconCls:'ico add',handler:this.edit,scope:this,mode:0,acl:'add'},
            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
            {text:'删除',icon:ico,iconCls:'ico del',handler:this.del,scope:this,acl:'delete'},'-',
			{text:'启用',handler:this.setCategoryStatus,scope:this,mode:1,acl:'rewrite'},
            '-',
			{text:'字段管理',handler:this.categoryField,scope:this,acl:'managefields'},
			{text:'数据管理',handler:this.loadDataGrid,scope:this,acl:'managedata'}
        ]}); 
		
		this.grid.on('rowclick',function(g,r,e){this.record=this.D.getAt(r);this.grid.topToolbar.items.items[3].setText(this.D.getAt(r).get('status')=='0'?'启用':'禁用');},this);
		this.grid.on('celldblclick',function(g,r,c,e){
			if(this.disableedit)return;
			if(g.getColumnModel().getDataIndex(c)!='sort'&&g.getColumnModel().getDataIndex(c)!=''){this.record=this.D.getAt(r);this.edit({mode:1});}},this);
		this.grid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.record=this.D.getAt(r);this.grid.topToolbar.items.items[3].setText(this.D.getAt(r).get('status')=='0'?'启用':'禁用');
			this.gridMenu.showAt(e.getXY());if(this.disableedit)return;this.gridMenu.items.items[4].setText(this.D.getAt(r).get('status')=='0'?'启用':'禁用');},this);
		this.grid.on('afteredit',this.saveCategorySort,this);
		this.tabPanel = new Ext.TabPanel({id:'cate-tabPanel',xtype:'tabpanel',region:'center',border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:this.grid});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
		this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});
		this.mainPanel = this.viewport.getComponent(1);
		this.D.baseParams={group:'-1'};
        this.D.load();
		this.tree.getEl().dom.oncontextmenu = function(){return false}
        this.tree.getEl().dom.onselectstart=function(){return false}
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
	},
	
	soOnTrigger1Click:function(){if(this.soField.getValue().trim()==''&&this.D.baseParams.key==''){return}this.soField.reset();this.D.baseParams.group=this.groupNode.id;this.D.baseParams.key='';this.D.reload();},
	soOnTrigger2Click:function(){var key=this.soField.getValue('').trim();if(key != ''){this.D.baseParams={group:'',key:key};this.D.reload();}},	
	
	// category opration
	//分类编辑器
	edit : function(item){
		var title;
		if(item.mode==1){
			if(!this.record){alert('请选择要编辑的分类');return}
			title ='编辑 '+ this.record.get('name') + ' 分类';
		}else{title='新建分类';}
		if(!this.editor){
			this.editor_group = new Ext.form.ComboBox({fieldLabel:'分类组',maxHeight:200,editable:false,hiddenName:'group',valueField:'id',displayField:'name',waitMsgTarget:true,
  				typeAhead:false,triggerAction:'all',selectOnFocus:true,mode:'local',
  			    store:new Ext.data.SimpleStore({fields:['id','name'],data:[]})
			});
			this.formPanel = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:15px 1px 0px 15px;',items:[	
				{name:'categoryid',xtype:'hidden'},
				this.editor_group,
				{fieldLabel:'分类名称',name:'name',allowBlank:false,blankText:'组名称不能为空'},
				{fieldLabel:'分类标识',name:'identify',allowBlank:false,blankText:'分类标识不能为空',vtype:'alphanum',vtypeText:'分类标识只能由大小写英文字母、数字以及下划线组成'},
				{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
				{fieldLabel:'多级分类',xtype:'radiogroup',width:200,columns:2,anchor:'40%',items:[
       				{boxLabel:'开启',name:'ismultilevel',inputValue:1},
      				{boxLabel:'关闭',name:'ismultilevel',inputValue:0,checked:true}
      			]},
				{fieldLabel:'是否启用',xtype:'radiogroup',width:200,columns:2,anchor:'40%',items:[
       				{boxLabel:'启用',name:'status',inputValue:1,checked:true},
      				{boxLabel:'禁用',name:'status',inputValue:0}
      			]},
				{xtype:'numberfield',fieldLabel:'排序',value:50,name:'sort',maxLength:6,anchor:'25%'}
			]});
            this.editor=new Ext.Window({layout:'fit',modal:false,resizable:false,width:500,height:330,closeAction:'hide',plain: true,
                items:this.formPanel,
                buttons:[{text:'确定',handler:this.save,scope:this},{text:'取消',handler:function(){this.editor.hide()},scope:this}]
            });
            this.formPanel.form.on('actioncomplete',function(form,action){
                if(action.result.success){
					this.D.reload();
                	this.editor.hide();
                }
            }, this);
		}
		this.editor.setTitle(title);
		this.editor.show();
		if(this.isGroupChange){
			this.isGroupChange = false;
			this.editor_group.store.removeAll();
			for(var i=1,len=this.tree.root.childNodes.length;i<len;i++){
				var id = this.tree.root.childNodes[i].id;
				this.editor_group.store.add(new Ext.data.Record({id:id, name:this.tree.root.childNodes[i].text}, id))
			}
		}
		if(item.mode==1){
        	this.formPanel.form.setValues(this.record.data);
		}else{
            this.formPanel.form.reset();
		}
	},
	//保存分类
	save:function(){
		var form = this.formPanel.form;
		if(!form.isValid()){alert('请检查红线处的错误提示！');return}
		form.submit({url:this.baseAction+(form.getValues().categoryid ? '&method=update' : '&method=insert')});
	},
	//删除分类
	del:function(){
		var records = this.grid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的分类');
			return ;
		}
       if(flag){alert('系统分类不允许删除！');return;}
       if(confirm('您确实要删除选定的分类吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=delete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.D.reload();}
				}
			});
        }
	},
	//设置分类状态
	setCategoryStatus : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		var txt = this.grid.topToolbar.items.items[3].getText();
		var mode = txt == '启用' ? 1 : 0;
	    if(selected.length==0){alert('请选择要'+txt+'的分类！');return;}
	    var ids =[];
        for (var i=0,len=selected.length;i<len;i++){ids.push(selected[i].id)}
	    
		Ext.Ajax.request({
            url: this.baseAction+'&method=status',
            method: 'POST', 
            params:{ids:ids.join(','),status:mode},
            failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},  
            success:function(r,o){
                r=jsonReturn(r);
                if(r.success){
					for(var i=0;i<ids.length;i++) this.D.getById(ids[i]).set('status',mode?1:0);
					this.grid.topToolbar.items.items[3].setText(mode?'禁用':'启用');
				    this.D.commitChanges();
                }
            },
            scope:this                                 
        });
	},
	//保存分类排序
	saveCategorySort : function(){
		var records = this.D.getModifiedRecords();
		var data = [];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({
	            url: this.baseAction+"&method=savesort",
	            method: 'POST', 
	            params:{data:Ext.util.JSON.encode(data)},
	            failure:function(response,options){alert("保存排序出错，请重试");},
	            success:function(response,options){this.D.commitChanges();},
				scope:this
	       });
		}
	},
	
	// category field opration
	//分类字段管理
	categoryField : function(){
		var params={};
		var selected = this.grid.getSelectionModel().getSelections();
		if(!this.record){Ext.MessageBox.alert('提示','请先选择分类模型！');return;}
		var title = this.record.data.name + '模型字段管理' ;
		if(!this.FGrid){
			this.FD = new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=fieldstore'}),
				reader : new Ext.data.JsonReader({root:'data',id:'fieldid',totalProperty: 'total',fields: ['fieldid',{name: 'categoryid', type: 'int'},'formname','fieldname','description','valuetype','valuefrom','valuefromname','sort',{name: 'issystem', type: 'int'}]}),
				remoteSort : true
			});
			this.FGrid = new Ext.grid.EditorGridPanel({
				title:title,enableColumnMove:false,collapsible:true,animCollapse:false,border:false,closable:true,
				store: this.FD,sm:new Ext.grid.RowSelectionModel(),loadMask:{msg:'分类字段数据加载中...'},
				columns : [new Ext.grid.RowNumberer(),
					{header:"字段名称",width:100,menuDisabled:true,sortable:false,dataIndex:'fieldname'},
					{header:"表单文字",width:100,menuDisabled:true,sortable:false,dataIndex:'formname'},
					{header:"取值类型",width:100,menuDisabled:true,sortable:false,dataIndex:'valuetype',renderer:this.renderFieldType,scope:this},
					{header:"取值来源",width:100,menuDisabled:true,sortable:false,dataIndex:'valuefromname'},
					{header:"描述",width:200,menuDisabled:true,sortable:false,dataIndex:'description'},
					{header:"系统字段?",width:80,menuDisabled:true,sortable:false,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
					{header:"排序",width:60,menuDisabled:true,sortable:false,dataIndex:'sort',editor:new Ext.form.NumberField({decimalPrecision:0})}
				],
				tbar:[
					{text:'新建',handler:this.editField,scope:this,mode:0},
					{text:'修改',handler:this.editField,scope:this,mode:1},
					{text:'删除',handler:this.delField,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.FD.reload()},scope:this}
				]
			});

			this.mainPanel.add(this.FGrid);
			if(this.mainPanel.activate){this.mainPanel.activate(this.FGrid);}
			else if(this.mainPanel.layout.setActiveItem){this.mainPanel.layout.setActiveItem(this.mainPanel.getComponent(1));}
			
			this.FGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.FGrid.getEl().dom.onselectstart = function(){return false;}
			
			this.fieldMenu = new Ext.menu.Menu({items:[
                {text:'新建',handler:this.editField,scope:this,mode:0},
				{text:'修改',handler:this.editField,scope:this,mode:1},
				{text:'删除',handler:this.delField,scope:this}
      		]});
			this.FGrid.on('rowclick',function(g,r,e){this.refrashMenu(g.getStore().getAt(r).get('issystem'));this.fieldrecord = this.FD.getAt(r);},this);
			this.FGrid.on('rowcontextmenu',function(g,r,e){
				this.fieldrecord = this.FD.getAt(r);
				var stm = g.getSelectionModel();
				stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) : stm.selectRow(r);
				this.fieldMenu.showAt(e.getXY());
				this.refrashMenu(g.getStore().getAt(r).get('issystem'));
			},this);
			this.FGrid.on('celldblclick', function(g,r,c,e){if(c!=7){this.fieldrecord = this.FD.getAt(r);this.editField({mode:1});}},this);
			this.FGrid.on('afteredit',this.saveFieldSort,this);
			this.FD.setDefaultSort('sort','asc');
			this.categoryid=this.record.id;
			this.FD.baseParams = {categoryid:this.categoryid};
			this.FD.load();
		}else{
			if(this.fieldcategoryid != this.record.id){this.FD.baseParams.categoryid = this.record.id;this.FD.reload(); this.fieldcategoryid = this.categoryid=this.record.id;}
			this.FGrid.setTitle(title);
			this.tabPanel.unhideTabStripItem(this.FGrid);
			this.tabPanel.activate(this.FGrid);
		}
	},
	//编辑分类字段
	editField : function(item){
		var title;
		if(item.mode==1){
			if(!this.fieldrecord){alert('请选择要编辑的字段');return}
			if(this.fieldrecord.get('issystem'))return;
			title ='修改 '+ this.fieldrecord.get('fieldname');
		}else{title='新建字段';}
		if(!this.fieldEditor){
			this.valuetype = new Ext.form.ComboBox({fieldLabel:'取值类型',hiddenName:'valuetype', value:0,displayField:'name',valueField:'id',editable:false,mode:'local',triggerAction:'all',selectOnFocus:true,store:new Ext.data.SimpleStore({fields:['id','name'],data:[[0,'文本输入'],[1,'数字输入'],[2,'分类数据选择']]})});
			this.valuetype.on('select',function(c,r,i){this.setFieldEditor(i)},this);
			this.valueFrom = new Ext.form.ComboBoxTree({fieldLabel:'取值来源',allowBlank:false,style:"font-family:'宋体'",hiddenName:'valuefrom',dataUrl:this.baseAction+'&method=catetree',baseParams:{categoryid:this.categoryid},rootText:'所有分类',onTreeClick:function(n){if(!n.attributes['iscate'])return;this.setValue(n.id);this.el.dom.value=n.parentNode.text+' > '+n.text;this.collapse()}});
			
			this.fieldForm = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
				{name:'fieldid',xtype:'hidden'},{name:'categoryid',xtype:'hidden'},
				{fieldLabel:'字段名称',name:'fieldname',allowBlank:false,blankText:'字段名称不能为空'},
				{fieldLabel:'表单文字',name:'formname',allowBlank:false,blankText:'表单文字不能为空'},
				this.valuetype,this.valueFrom,
				{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
				{xtype:'numberfield',fieldLabel:'排序',value:50,name:'sort',maxLength:6,anchor:'30%'}
			]});
			
            this.fieldEditor=new Ext.Window({layout:'fit',modal:false,resizable:false,width:450,height:300,closeAction:'hide',plain: true,
                items:this.fieldForm,
                buttons:[{text:'确定',handler:this.saveField,scope:this},{text:'取消',handler:function(){this.fieldEditor.hide()},scope:this}]
            });
            this.fieldForm.form.on('actioncomplete',function(form,action){
                if(action.result.success){
					this.FD.reload();
                	this.fieldEditor.hide();
                }
            }, this);
		}
		this.fieldEditor.setTitle(title);
		this.fieldEditor.show();

		if(item.mode==1){
        	this.fieldForm.form.setValues(this.fieldrecord.data);
			this.valueFrom.el.dom.value = this.fieldrecord.get('valuefromname');
			this.setFieldEditor(this.fieldrecord.data.valuetype);
		}else{
            this.fieldForm.form.reset();
			this.fieldForm.form.items.items[1].setValue(this.record.id);
			this.setFieldEditor(0);
		}
	},
	//保存字段
	saveField : function(){
		if(!this.fieldForm.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.fieldForm.form.submit({url:this.baseAction+'&method=savefield'});
	},
	// 删除字段
	delField : function(){
		var records = this.FGrid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的字段');return ;
		}
       if(flag){alert('您选择的字段中存在系统字段,系统字段不允许删除！');return;}
       if(confirm('您确实要删除选定的字段吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=deletefield',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.FD.reload();}
				}
			});
        }
	},
	//保存字段排序
	saveFieldSort : function(){
		var records = this.FD.getModifiedRecords();
		var data = [];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({
	            url: this.baseAction+"&method=fieldsort",
	            method: 'POST', 
	            params:{data:Ext.util.JSON.encode(data)},
	            failure:function(response,options){alert("保存排序出错，请重试");},
	            success:function(response,options){this.FD.commitChanges();},
				scope:this
	       });
		}
	},
	setFieldEditor : function(i){
		if(i == 2){
			this.valueFrom.el.dom.parentNode.parentNode.parentNode.style.display = "block";
			this.valueFrom.allowBlank = false;
		}else{
			this.valueFrom.el.dom.parentNode.parentNode.parentNode.style.display = 'none';
			this.valueFrom.allowBlank = true;
		}
		
		this.valueFrom
	},
	// 刷新字段菜单
	refrashMenu : function(flag){
		if(flag){
			this.fieldMenu.items.items[1].disable();this.fieldMenu.items.items[2].disable();
			this.FGrid.topToolbar.items.items[1].disable();this.FGrid.topToolbar.items.items[2].disable();
		}else{
			this.fieldMenu.items.items[1].enable();this.fieldMenu.items.items[2].enable();
			this.FGrid.topToolbar.items.items[1].enable();this.FGrid.topToolbar.items.items[2].enable();
		}
	},
	
	// CategoryData opration
	
	loadDataGrid:function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(!this.record){Ext.MessageBox.alert('提示','请先选择分类模型！');return;}
		var title = this.record.data.name + '数据管理' ;
		if (this.datacategoryid != this.record.id || !this.dataGrid) {
			if(this.datacategoryid != this.record.id){
				this.categoryid = this.datacategoryid = this.record.id;
				this.reload = this.reloadEdit = true;
			}
			Ext.Ajax.request({
	            url: this.baseAction+"&method=getgrid",method: 'POST', params:{categoryid:this.categoryid},
	            failure:function(response,options){alert("加载GRID失败，请重试");},
	            success:function(response,options){
					r = Ext.decode(response.responseText);
					if(r.success){
						if(!r.fields){
							r.fields = this.record.get("ismultilevel") ? ["id","pid","pname","name","sort"] : ["id","name","sort"];
						}
						this.DD = new Ext.data.Store({
				            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=datastore'}),
				            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',fields:r.fields}),remoteSort:false
				        });
						this.DD.baseParams = {categoryid:this.categoryid};
						if(!r.cm){
							if(this.record.get("ismultilevel")){
								this.cm = new Ext.grid.ColumnModel([
									new Ext.grid.RowNumberer(),
									{header:"ID",width:100,sortable:true,dataIndex:'id'},
									{header:"名称",width:200,sortable:true,dataIndex:'name'},
									{header:"上级分类",width:200,sortable:true,dataIndex:'pname'}, 
									{header:"排序",width:60,align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
								]);
								this.sortIndex = 4;
							}else{
								this.cm = new Ext.grid.ColumnModel([
									new Ext.grid.RowNumberer(),
									{header:"ID",width:100,sortable:true,dataIndex:'id'},
									{header:"名称",width:200,sortable:true,dataIndex:'name'},
									{header:"排序",width:60,align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
								]);
								this.sortIndex = 3;
							}
						}else{
							this.sortIndex = r.cm.length-1;
							for(var i=0;i<this.sortIndex+1;i++){
								if(r.cm[i].dataIndex=='sort') this.sortIndex = i;
								eval('r.cm['+i+']='+ r.cm[i] + ';');
							}
							this.cm = new Ext.grid.ColumnModel(r.cm);
						}
						if(!this.dataGrid){
							this.dataGrid = new Ext.grid.EditorGridPanel({title:title,enableColumnMove:false,collapsible:true,animCollapse:false,border:false,closable:true,
								store: this.DD,sm:new Ext.grid.RowSelectionModel(),cm:this.cm,
								tbar:[
									{text:'新建',handler:this.dataEdit,scope:this,mode:0},
									{text:'修改',handler:this.dataEdit,scope:this,mode:1},
									{text:'删除',handler:this.delData,scope:this},'-',
									{text:'刷新',handler:function(){this.DD.reload()},scope:this}
								],
								bbar: new Ext.PagingToolbar({pageSize:25,store:this.DD,displayInfo:true,displayMsg:'当前显示{0} - {1} 共{2}条',emptyMsg:'暂时没有数据',beforePageText:'第',afterPageText:'页 共{0}页'})
							});
							this.mainPanel.add(this.dataGrid);
							if(this.mainPanel.activate){this.mainPanel.activate(this.dataGrid);}
							else if(this.mainPanel.layout.setActiveItem){this.mainPanel.layout.setActiveItem(this.mainPanel.getComponent(1));}
							this.dataGrid.getEl().dom.oncontextmenu = function(){return false;}
							this.dataGrid.getEl().dom.onselectstart = function(){return false;}
							this.dataMenu = new Ext.menu.Menu({items:[
				                {text:'新建',handler:this.dataEdit,scope:this,mode:0},
								{text:'修改',handler:this.dataEdit,scope:this,mode:1},
								{text:'删除',handler:this.delData,scope:this}
				      		]});
							this.dataGrid.on('rowclick',function(g,r,e){this.dataRecord = this.DD.getAt(r);},this);
							this.dataGrid.on('rowcontextmenu',function(g,r,e){this.dataRecord = this.DD.getAt(r);var stm = g.getSelectionModel();
								stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) : stm.selectRow(r);this.dataMenu.showAt(e.getXY());
							},this);
							this.dataGrid.on('celldblclick', function(g,r,c,e){if(c!=this.sortIndex){this.dataRecord = this.DD.getAt(r);this.dataEdit({mode:1});}},this);
							this.dataGrid.on('afteredit',this.saveDataSort,this);
							this.DD.setDefaultSort('sort','asc');
							this.DD.load();
						}else{
							this.dataGrid.reconfigure(this.DD, this.cm);
							this.DD.reload();
							this.dataGrid.setTitle(title);
							this.tabPanel.unhideTabStripItem(this.dataGrid);
							this.tabPanel.activate(this.dataGrid);
						}
					}else{
						alert("加载GRID失败，请重试");
					}
				},
				scope:this
	       });
		}else{
			this.tabPanel.unhideTabStripItem(this.dataGrid);
			this.tabPanel.activate(this.dataGrid);
		}
	},
	
	//加载编辑器
	renderEditor : function(item){
		var title;
		if(item.mode==1){if(!this.dataRecord){alert('请选择要编辑的数据');return} title ='修改 '+ this.dataRecord.get('name');}else{title='添加'+this.record.data.name+'数据';}
		if(!this.dataEditor){
			this.pname = new Ext.form.ComboBoxTree({fieldLabel:'上级分类',hiddenName:'pid',dataUrl:this.baseAction+'&method=ptree',baseParams:{categoryid:this.categoryid},rootText:this.record.get('name')});
			
			this.dataForm = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},autoScroll:false,layout:'form',items:[	
				{name:'id',xtype:'hidden'},this.pname,
				{fieldLabel:'名称',name:'name',allowBlank:false,blankText:'名称不能为空'}
			]});
			this.fieldPanel = new Ext.Panel({border:false,layout:'form',items:this.cardPanel});
			this.sortForm = new Ext.FormPanel({border:false,labelWidth:70,defaults:{anchor:'-20'},items:[
				{xtype:'numberfield',fieldLabel:'排序',value:50,name:'sort',maxLength:6,anchor:'40%'}
			]});
            this.dataEditor=new Ext.Window({layout:'form',modal:false,resizable:false,width:400,height:300,closeAction:'hide',plain:false,bodyStyle:'background:#FFF;padding:10px',
                items:[this.dataForm,this.fieldPanel,this.sortForm],
                buttons:[{text:'确定',handler:this.saveData,scope:this},{text:'取消',handler:function(){this.dataEditor.hide()},scope:this}]
            });
            this.dataForm.form.on('actioncomplete',function(form,action){
                if(action.result.success){this.DD.reload();this.dataEditor.hide();}
            }, this);
		}
		this.dataEditor.setTitle(title);
		this.dataEditor.show();
		if(this.record.get('ismultilevel')){
			this.pname.el.dom.parentNode.parentNode.parentNode.style.display = 'block';
			this.pname.disabled = false;
		}else{
			this.pname.el.dom.parentNode.parentNode.parentNode.style.display = 'none';
			this.pname.disabled = true;
		}
		if(item.mode==1){
        	this.dataForm.form.setValues(this.dataRecord.data);
			if(this.cardPanel) this.cardPanel.form.setValues(this.dataRecord.data);
			this.sortForm.form.setValues(this.dataRecord.data);
			if(this.record.get('ismultilevel')){
				this.pname.el.dom.value=this.dataRecord.get('pid_name');
			}
			if(this.needSetText.length>0){
				for(var i=0;i<this.needSetText.length;i++){
					this.cardPanel.items.items[this.needSetText[i][0]].el.dom.value=this.dataRecord.get(this.needSetText[i][1]+'_name');
				}
			}
		}else{
            this.dataForm.form.reset();
			if(this.cardPanel) this.cardPanel.form.reset();
			this.sortForm.form.reset();
		}
	},
	
	dataEdit : function(item){
		if(this.reloadEdit || !this.dataEditor){
			Ext.Ajax.request({
	            url: this.baseAction+"&method=geteditor",method: 'POST', params:{categoryid:this.categoryid},
	            failure:function(response,options){alert("加载编辑器失败，请重试");},
	            success:function(response,options){
					r = Ext.decode(response.responseText);
					if(r.success){
						this.needSetText = [];
						if(r.data){
							for(var i=0;i<r.data.length;i++){
								eval('r.data['+i+']='+r.data[i]+';');
								if(r.data[i].xtype == 'combo' || r.data[i].xtype == 'combotree'){
									this.needSetText.push([i,r.data[i].hiddenName]);
								}
							}
							var newPanel = new Ext.FormPanel({border:false,labelWidth:70,defaultType:'textfield',defaults:{anchor:'-20'},items:r.data});
							if(this.dataEditor){
								if(this.fieldPanel.el.dom.style.display=='none') this.fieldPanel.el.dom.style.display='block';
								if(this.cardPanel) this.fieldPanel.remove(this.cardPanel);
								this.cardPanel = newPanel;
								this.fieldPanel.add(this.cardPanel);
								this.fieldPanel.doLayout();
							}else{
								this.cardPanel = newPanel;
							}
							this.renderEditor(item);
						}else{
							this.renderEditor(item);
							this.fieldPanel.el.dom.style.display='none';
						}
						this.reloadEdit = false;
					}
				},
				scope:this
	       });
		}else{
			this.renderEditor(item);
		}
	},
	
	saveData : function(){
		if(!this.dataForm.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.values = this.fieldPanel.el.dom.style.display=='none' ? {} : this.fieldPanel.items.items[0].form.getValues();
		this.sortvalues =  this.sortForm.form.getValues();
		for(key in this.sortvalues){ 
			this.values[key]= this.sortvalues[key];
		} 
		this.values['categoryid'] = this.categoryid;
		this.dataForm.form.submit({url:this.baseAction+'&method=savedata',params:this.values});
	},
	
	delData : function(){
		var records = this.dataGrid.getSelectionModel().getSelections();
        if(records.length > 0){var ids=[];for(var i=0,len=records.length;i<len; i++){ids.push(records[i].id);}}
		else{alert('请选择要删除的数据');return ;}
		if(confirm('您确实要删除选定的数据吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=deletedata',method:'POST', params:{ids:ids.join(','),categoryid:this.record.id},scope:this,
				success:function(r,o){r=jsonReturn(r);if(r.success){this.DD.reload();}}
			});
		}
	},
	
	saveDataSort : function(){
		var records = this.DD.getModifiedRecords();
		var data = [];
		for(var i=0;i<records.length;i++){data.push({id:records[i].id,sort:records[i].data.sort});}
		if(data.length > 0){
			Ext.Ajax.request({
	            url: this.baseAction+"&method=savedatasort",
	            method: 'POST', 
	            params:{data:Ext.util.JSON.encode(data),categoryid:this.categoryid},
	            failure:function(response,options){alert("保存排序出错，请重试");},
	            success:function(response,options){this.DD.commitChanges();},
				scope:this
	       });
		}
	},
	
	// group opration
	editCateGroup : function(item){
		var title;
		if(item.mode==1){
			if(this.groupNode == null){alert('请选择要编辑的分类组');return}
			title ='修改 '+ this.groupNode.text;
		}else{title='新建分类组';}
		if(!this.groupEditor){
			this.groupForm = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
				{name:'id',xtype:'hidden'},
				{fieldLabel:'组名称',name:'name',allowBlank:false,blankText:'组名称不能为空'},
				{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
				{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'}
			]});
			
            this.groupEditor=new Ext.Window({layout:'fit',modal:false,resizable:false,width:400,height:240,closeAction:'hide',plain: true,
                items:this.groupForm,
                buttons:[{text:'确定',handler:this.saveGroup,scope:this},{text:'取消',handler:function(){this.groupEditor.hide()},scope:this}]
            });
            this.groupForm.form.on('actioncomplete',function(form,action){
                if(action.result.success){
					this.isGroupChange = true;
					var newValues = this.groupForm.getForm().getValues();
					if(action.result.newid){
						var newNode = new Ext.tree.TreeNode({id:'0'+action.result.newid, text:newValues.name, name:newValues.name, leaf:1,cls:"category-group",editable:'1', sort:newValues.sort});
						this.tree.root.appendChild(newNode);
					}else{
						this.groupNode.setText(newValues.name);
						this.groupNode.attributes.text = newValues.name;
						this.groupNode.attributes.sort = newValues.sort;
					}
                	this.groupEditor.hide();
                }
            }, this);
		}
		this.groupEditor.setTitle(title);
		this.groupEditor.show();

		if(item.mode==1){
        	this.groupForm.form.setValues(this.groupNode.attributes);
			this.groupForm.items.items[1].setValue(this.groupNode.text);
		}else{
            this.groupForm.form.reset();
		}
	},
	delCateGroup : function(){
		if(this.groupNode == null){alert('请选择要删除的分类组');return}
		if(confirm('您确实要删除选定的分类组吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=deletegroup',method:'POST', params:{id:this.groupNode.id},scope:this,
				success:function(r,o){r=jsonReturn(r);if(r.success){this.tree.getRootNode().removeChild(this.groupNode);this.groupNode = null;this.isGroupChange = true;}}
			});
        }
	},
	saveGroup : function(){
		if(!this.groupForm.form.isValid()){alert('请填写分类组名称！');return}
		this.groupForm.form.submit({url:this.baseAction+'&method=savegroup'});
	},
	renderFieldType : function(v){return ['文本','数字','分类数据选择'][v];},
	renderIsSys:function(v){return v=='1'?'<font color=green>是</font>':'<font color=red>否</font>'},
	renderStatus:function(v){return v=='1'?'<font color=green>启用</font>':'<font color=red>禁用</font>'}
};
EXCMS.onReady(EXCMS.Category.init,EXCMS.Category);