EXCMS.Channel={
	baseAction : 'index.php?M=Channel&A=Index',
	init : function(){
		this.pid = Ext.getDom('pid').value;
	    Ext.QuickTips.init();
	    this.treemenu = false;
		this.node = new Ext.tree.TreeNode({id:'0',text:"顶级栏目"});
	    this.view();
		btn = this.grid.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				if (btn[i].acl == 'edit') {
					this.disableedit = true;
					this.grid.on('beforeedit',function(e){e.cancel = true;},this);
				}
				btn[i].hide();
			}
		}
		for(var i=0;i<this.contextmenu.items.items.length;i++){
			if(this.contextmenu.items.items[i].acl&&!excmsacl[this.contextmenu.items.items[i].acl]){
				this.contextmenu.items.items[i].hide();
			}
		}
	},

	view : function(){
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store&treetype=crose'}),
            reader: new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'channelid',
                fields: [{name:'channelid'},'modelid','_modelid','name','pid','_pid','path',{name:'total',type:'int'},'type','_type','cross','visible','navigation','checked','comment','contribute',{name:'sort',type:'int'}]
            }),
			remoteSort:true
        });
        //this.D.setDefaultSort('sort','asc');
		this.menu = {
			'new':new Ext.menu.Menu({items:[
				{text:'新建栏目',handler:this.edit,scope:this},
		   	 	{text:'新建下级栏目',handler:this.edit,scope:this,mode:3},'-',
		   	 	{text:'批量新建栏目',handler:this.batchAdd,scope:this},'-',
//		   	 	{text:'Tab新建栏目',handler:this.tabedit,scope:this},'-',
				{text:'新建内容',icon:ico,iconCls:'ico add_article',handler:this.addcontent,scope:this}
		  	]}),
		  	'edit':new Ext.menu.Menu({items:[
				{text:'栏目属性',handler:this.edit,scope:this,mode:2},
		   	 	{text:'单独页内容',handler:this.editBody,disabled:true,scope:this}
		  	]}),
			'setting':new Ext.menu.Menu({items:[
				{text:'栏目交叉',handler:this.setCross,scope:this},'-',
				{text:'栏目类型',handler:this.edit,scope:this,mode:4},
				{text:'导航栏显示',menu:{items:[
  					{text:'顶部显示',handler:this.setting,scope:this,mode:['navigation',1]},
  					{text:'底部显示',handler:this.setting,scope:this,mode:['navigation',2]},
					{text:'顶部和底部',handler:this.setting,scope:this,mode:['navigation',3]},
  					{text:'不显示',handler:this.setting,scope:this,mode:['navigation',0]}
  				]}},
				{text:'显示隐藏',menu:{items:[
					{text:'显示',handler:this.setting,scope:this,mode:['visible',0]},
					{text:'隐藏',handler:this.setting,scope:this,mode:['visible',1]}
				]}},
				{text:'内容审核',menu:{items:[
					{text:'默认已审核',handler:this.setting,scope:this,mode:['checked',1]},
					{text:'默认未审核',handler:this.setting,scope:this,mode:['checked',0]}
				]}},
				{text:'内容评论',menu:{items:[
					{text:'禁止评论',handler:this.setting,scope:this,mode:['comment',0]},
					{text:'允许评论',handler:this.setting,scope:this,mode:['comment',1]},
					{text:'允许会员评论',handler:this.setting,scope:this,mode:['comment',2]}
				]}},
				{text:'投稿',menu:{items:[
					{text:'启用投稿',handler:this.setting,scope:this,mode:['contribute',1]},
					{text:'关闭投稿',handler:this.setting,scope:this,mode:['contribute',0]}
				]}}
		  	]}),
			'update':new Ext.menu.Menu({items:[
				{text:'更新首页',icon:ico,iconCls:'ico update_index',handler:this.updateindex,scope:this,mode:'index'},
				{text:'更新栏目',icon:ico,iconCls:'ico update_channel',handler:this.update,scope:this,mode:'channel'},
				{text:'更新内容',icon:ico,iconCls:'ico update_archive',handler:this.update,scope:this,mode:'content'},'-',
			    {text:'更新栏目缓存',icon:ico,iconCls:'ico update',handler:this.updateCache,scope:this}
		  	]})
		};
		this.menu['edit'].on('beforeshow',function(m){
			var f = true;
			if(this.treemenu){f = this.node.attributes['type'] != '2'}else if(!this.treemenu && this.record){f =  this.record.data.type != '单独页面'}
			m.items.items[1].setDisabled(f)
		},this);
		
        this.soField = new Ext.form.TwinTriggerField({emptyText:'栏目名称,关键字,描述',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);		
        this.grid = new Ext.grid.EditorGridPanel({title:'全部栏目',margins:'0 3 3 0',enableColumnMove:false,collapsible:true,animCollapse:false,minColumnWidth:7,border:false,sm:new Ext.grid.RowSelectionModel(),loadMask:{msg:'数据加载中...'},
            store:this.D,
            columns:[
                {header:"ID",width:60,sortable:true,dataIndex:'channelid'},
                {header:"名称",width:150,sortable:true,dataIndex:'name'},
                {header:"上级栏目",width:150,sortable:true,dataIndex:'pid'},
				{header:"模型",width:60,sortable:true,dataIndex:'modelid'},
                {header:"类型",width:80,sortable:true,dataIndex:'type'},
				{header:"内容数",width:60,align:'right',sortable:true,dataIndex:'total'},
				{header:"导航栏",width:60,sortable:true,dataIndex:'navigation'},
				{header:"是否隐藏",width:60,sortable:true,dataIndex:'visible'},
				{header:"审核",width:70,sortable:true,dataIndex:'checked'},
				{header:"评论",width:60,sortable:true,dataIndex:'comment'},
				{header:"交叉",width:60,dataIndex:'cross'},
				{header:"投稿",width:60,sortable:true,dataIndex:'contribute'},
                {header:"排序",width:48,align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField()}
            ],		
            tbar:[
				{text:'浏览',handler:this.browse,scope:this,mode:1},
				{text:'新建',menu:this.menu['new'],scope:this,acl:'add'},
				{text:'编辑',menu:this.menu['edit'],scope:this,acl:'edit'},
				{text:'删除',handler:this.del,scope:this,acl:'delete'},
				{text:'移动',handler:this.move,scope:this,acl:'move'},
				{text:'内容',handler:this.content,scope:this},'-',
				{text:'复制',handler:this.copy,scope:this,mode:1,acl:'copy'},
                {text:'粘贴',handler:this.paste,scope:this,type:3,disabled:true,acl:'paste'},'-',
				{text:'设置',menu:this.menu['setting'],acl:'setting'},
				{text:'绑定资源',handler:this.Binding,scope:this,acl:'Binding'},
				{text:'更新',menu:this.menu['update']},'-',
                {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this},'->','搜索 ',this.soField
            ],
            bbar: new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示{0} - {1} 共{2}条',emptyMsg:'暂时没有数据',beforePageText:'第',afterPageText:'页 共{0}页'})
        });

        this.tree = new Ext.tree.TreePanel({id:'west',region:'west',title:'网站栏目树',cls:'channel-tree',style:'border-right:1px solid #99BBE8;',bodyStyle:'padding:8px 1px',collapseMode:'mini',collapsible:true,split:true,width:200,minSize:35,maxSize:500,autoScroll:true,rootVisible: true,animate:true,useArrows:true,border:false,
            loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction + '&method=tree&treetype=crose'}),
            root:new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',expanded:true})
        });
        
      	this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:this.grid});
		this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});	
		
        this.rootmenu = new Ext.menu.Menu({items:[{text:'刷新栏目树',handler:this.refreshTree,scope:this,mode:1}]}); 
        this.contextmenu = new Ext.menu.Menu({items: [
		    {text:'浏览',icon:ico,iconCls:'ico preview',handler:this.browse,scope:this},
			{text:'新建',icon:ico,iconCls:'ico add_channel',menu:this.menu['new'],acl:'add'},
		    {text:'编辑',icon:ico,iconCls:'ico edit',menu:this.menu['edit'],acl:'edit'},
			{text:'删除',icon:ico,iconCls:'ico del',handler:this.del,scope:this,mode:1,acl:'delete'},
			{text:'移动',handler:this.move,scope:this,mode:1,acl:'move'},
		    {text:'内容',icon:ico,iconCls:'ico contents',handler:this.content,scope:this,mode:1},'-',
			{text:'复制',handler:this.copy,scope:this,mode:1,acl:'copy'},	
			{text:'粘贴',handler:this.paste,scope:this,disabled:true,acl:'paste'},'-',
			{text:'设置',menu:this.menu['setting'],acl:'setting'},
			{text:'更新',menu:this.menu['update']},'-',
			{text:'刷新栏目结点',icon:ico,iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this}
	    ]});
		
		this.tree.on('click',function(n){
			if(this.D.node == n)return;
			this.node = n;
			this.setToolbar(isNaN(n.id));
			//编辑单独页内容
			if(parseInt(n.attributes['type']) == 2){
				this.treemenu=true;
				this.editBody();
			}else{
				this.tabPanel.activate(this.grid);
				this.grid.setTitle(n.id==0?this.grid.initialConfig.title:n.text);
				this.D.node = n;
				this.loadData();
			}
		},this);
	    this.tree.on('contextmenu',function(n,e){
	    	this.treemenu=true;
	    	n.select();
	    	this.setToolbar(isNaN(n.id));
	    	this.node = n;
			this.selectedNode = n;
			if(n.id==0){this.rootmenu.showAt(e.getXY());return}
			this.setContextMenu();
			this.contextmenu.showAt(e.getXY());
	    },this);
		
		this.grid.getEl().dom.oncontextmenu = function(){return false}
        this.grid.getEl().dom.onselectstart=function(){return false}
		this.tree.getEl().dom.oncontextmenu = function(){return false}
        this.tree.getEl().dom.onselectstart=function(){return false}
        this.grid.topToolbar.items.items[1].on('click',function(){this.treemenu=false},this);
        this.grid.topToolbar.items.items[2].on('click',function(){this.treemenu=false},this);
		this.grid.on('rowclick',function(g,r,e){this.record=this.D.getAt(r);this.grid.topToolbar.items.items[5].setDisabled(this.record.get('_type')=='2');this.setToolbar(isNaN(this.record.get('channelid')));},this);
		this.grid.on('celldblclick',function(g,r,c,e){this.record=this.D.getAt(r);if(c!=12){if(this.disableedit)return;if(!isNaN(this.record.get('channelid')))this.edit({mode:1});} },this);
		this.grid.on('rowcontextmenu',function(g,r,e){this.treemenu=false;g.getSelectionModel().selectRow(r);this.record=this.D.getAt(r);this.setContextMenu();this.contextmenu.showAt(e.getPoint());this.setToolbar(isNaN(this.record.get('channelid')));},this);
		this.grid.on('afteredit',this.save,this);
		
		//Load Grid Data
		this.D.baseParams = {pid:this.pid,key:''};
		this.limit = Math.max(25, Math.floor(this.grid.body.getHeight() / 22) - 1);
		this.D.load({params:{limit:this.limit, start:0}});
		this.grid.bottomToolbar.pageSize = this.limit;
		
		this.menu['new'].on('beforeshow',function(){var t=this.getChannelType();this.menu['new'].items.items[3].setDisabled(parseInt(t)>1)},this);
		this.menu['setting'].on('beforeshow',function(m){
			var t = this.getChannelType();
			var type_01 = t == '0' || t == '1' || t === true;
			m.items.items[0].setVisible(type_01);
			m.items.items[1].setVisible(type_01);
			var type_0 = t == '0';
			m.items.items[5].setVisible(type_0);
			m.items.items[6].setVisible(type_0);
			m.items.items[7].setVisible(type_0);
		},this);
	},	
	
	getChannelType:function(){return this.treemenu ? this.selectedNode.attributes['type'] : (this.record && this.D.getById(this.record.id) ? this.record.get('_type') : false);},
	
	setContextMenu:function(){
		var n = this.treemenu;
		this.contextmenu.items.items[12].setVisible(n);
		this.contextmenu.items.items[13].setVisible(n);
		var t = this.getChannelType();
		this.contextmenu.items.items[5].setVisible(!(t=='2'));
	},
		
	//加载栏目数据
	loadData:function(){
		this.D.baseParams.pid = this.D.node.id;
		this.D.reload();
	},
	//添加/修改栏目树
	addData:function(mode,id,pid,name,url){
		this.D.reload();
		if(mode==1||mode==2){
			this.node = this.tree.getNodeById(id);
			this.leaf = 1;
			if(this.node){
				if(this.node.parentNode.id == pid){
					this.node.setText(name);
					return ;
				}else{
					this.leaf = this.node.leaf;
					this.node.parentNode.removeChild(this.node);
				}
			}
			if(this.leaf){
				this.newNode = new Ext.tree.TreeNode({id:id,text:name,leaf:this.leaf});
			}else{
            	this.newNode = new Ext.tree.AsyncTreeNode({id:id,text:name,leaf:this.leaf});
			}
            this.renderNode(url,pid);
		}else{
			this.newNode = new Ext.tree.TreeNode({id:id,text:name,leaf:1});
  			this.renderNode(url,pid);
		}
	},
	//添加栏目节点
	renderNode : function(url,nodeId){
		if(!(nodeId>0)){
			this.newParentNode = this.tree.root;
		}else{
			this.newParentNode = this.tree.getNodeById(nodeId);
		}
		if(this.newParentNode){
			if(this.newParentNode.isExpanded()){
				this.tree.getLoader().load(this.newParentNode);
			}
			this.newParentNode.expand();
		}else{
			this.tree.expandPath(url);
		}
    },
    
	soOnTrigger1Click:function(){this.soField.reset();this.D.baseParams={key:''};this.D.reload();},
	soOnTrigger2Click:function(){var key=this.soField.getValue('').trim();if(key!=''){this.D.baseParams={key:key};this.D.reload()}},
	//设置工具条
	setToolbar:function(flag){
		if(this.isDisable==flag)return ;
		this.isDisable=flag;
		if(flag){
			for(var i=1;i<9;i++){
				this.contextmenu.items.items[i].disable();
				this.grid.getTopToolbar().items.items[i].disable();
			}
		}else{
			for(var i=1;i<9;i++){
				if(i!=6){
					this.grid.getTopToolbar().items.items[i].enable();
					if(i!=5)this.contextmenu.items.items[i].enable();
				}else if(this.id){
					this.grid.getTopToolbar().items.items[6].enable();
					this.contextmenu.items.items[5].enable();
				}
			}
		}
	},
	//添加/修改栏目
	edit:function(item){
		var params={advanced:false};
		switch(item.mode){
			case 1 : 
				if(this.record && this.D.getById(this.record.id)){
					params.channelid = this.record.id;
					params.name = this.record.data.name;
				}else{alert('请选择要编辑的栏目')	;return;}
				break;
			case 2 : 
				params.channelid = this.treemenu ? this.node.id : this.record.id;
				params.name = this.treemenu ? this.node.text : this.record.data.name;
				break;
			case 3 :
				if(this.treemenu){
					params = {advanced:false,pname:this.node.text,pid:this.node.id,ppath:this.node.attributes['path'],modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname']};
				}else if(this.record){
					params = {advanced:false,pname:this.record.data.name,pid:this.record.id,ppath:this.record.data.path,modelid:this.record.data._modelid,modelname:this.record.data.modelid};
				}else if(this.node){
					params = {advanced:false,pname:this.node.text,pid:this.node.id,ppath:this.node.attributes['path'],modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname']};
				}
				break;
			case 4 :
				if(this.treemenu){
					params = {advanced:true,channelid:this.node.id,name:this.node.text,modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname'],type:this.node.attributes['type']};
					if (this.node.parentNode && this.node.parentNode.id != "0") {params.pid = this.node.parentNode.id;params.pname = this.node.parentNode.text}
				}else{
					params = {advanced:true,channelid:this.record.id,name:this.record.data.name,modelid:this.record.data._modelid,modelname:this.record.data.modelid,type:this.record.data._type,pid:this.record.data._pid,pname:this.record.data.pid};
				}
				break;
			default : break;
		}
		EXCMS.util.QuickCreate({model:'Channel.Editor',mode:item.mode, params:params,channelObj:this, top:true});
	},
	//添加/修改栏目
	tabedit:function(item){
		var params={advanced:false};
		switch(item.mode){
			case 1 : 
				if(this.record && this.D.getById(this.record.id)){
					params.channelid = this.record.id;
					params.name = this.record.data.name;
				}else{alert('请选择要编辑的栏目')	;return;}
				break;
			case 2 : 
				params.channelid = this.treemenu ? this.node.id : this.record.id;
				params.name = this.treemenu ? this.node.text : this.record.data.name;
				break;
			case 3 :
				if(this.treemenu){
					params = {advanced:false,pname:this.node.text,pid:this.node.id,ppath:this.node.attributes['path'],modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname']};
				}else if(this.record){
					params = {advanced:false,pname:this.record.data.name,pid:this.record.id,ppath:this.record.data.path,modelid:this.record.data._modelid,modelname:this.record.data.modelid};
				}else if(this.node){
					params = {advanced:false,pname:this.node.text,pid:this.node.id,ppath:this.node.attributes['path'],modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname']};
				}
				break;
			case 4 :
				if(this.treemenu){
					params = {advanced:true,channelid:this.node.id,name:this.node.text,modelid:this.node.attributes['modelid'],modelname:this.node.attributes['modelname'],type:this.node.attributes['type']};
					if (this.node.parentNode && this.node.parentNode.id != "0") {params.pid = this.node.parentNode.id;params.pname = this.node.parentNode.text}
				}else{
					params = {advanced:true,channelid:this.record.id,name:this.record.data.name,modelid:this.record.data._modelid,modelname:this.record.data.modelid,type:this.record.data._type,pid:this.record.data._pid,pname:this.record.data.pid};
				}
				break;
			default : break;
		}
		params.tabPanel = this.tabPanel;
		EXCMS.util.QuickCreate({model:'Channel.TabEditor',tabPanel:this.tabPanel,mode:item.mode, params:params,channelObj:this, top:true});
	},
	addcontent : function(){
		var channelid = this.treemenu ? this.selectedNode.id : this.record && this.D.getById(this.record.id) ? this.record.id : 0;
		location.href='index.php?M=Content&A=AddContent&channelid=' + channelid;
	},
	//内容管理
	content:function(item){
		var id='';
		if(item&&item.mode){id=this.treemenu?this.node.id:this.record.id}
		else if(this.record && this.D.getById(this.record.id)){id=this.record.id;}
		window.location.href='index.php?M=Content&channelid='+id
	},
	//浏览栏目
	browse:function(item){
		var id=this.treemenu?this.selectedNode.id:(this.record && this.record.id ? this.record.id:0);
		if(item&&item.mode){id=(this.record && this.record.id ? this.record.id:0);}
		if(id)EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'channel',id:id});
		else alert('请选择要浏览的栏目')
	},
	//设置
	setting:function(item){
		var id=[];
		if(this.treemenu){
			id.push(this.node.id);
		}else{
			var selected = this.grid.getSelectionModel().getSelections();
			if(!(selected.length>0)){alert('请选择要操作的文档');return ;}
			for (var i = 0, len = selected.length; i < len; i++) {id.push(selected[i].id);}
		}
		var act = item.mode[0];
		if(act=='')return;
		Ext.Ajax.request({url:this.baseAction+'&method='+act,method:'post',scope:this,
			params:{id:id.join(','),value:item.mode[1]},
			success:function(r,o){r=jsonReturn(r);if(r.success&&!this.truemenu){this.D.reload();}}     
		});
	},
	//栏目交叉
	setCross:function(){
        if(this.treemenu){
			var config = {channelid:this.selectedNode.id, name:this.selectedNode.text};
		}else if(this.record && this.D.getById(this.record.id)){
			var config = {channelid:this.record.id, name:this.record.data.name};
		}else{
			alert('请选择要设置交叉属性的栏目');
            return;
		}
		if (!this.crosswin) {
            this.crosswin = new EXCMS.Channel.Cross();
			this.crosswin.init(this.baseAction);
        }
		this.crosswin.show(config);
	},
	//资源绑定
	Binding : function(){
		if(this.treemenu){
			var config = {itemid:this.selectedNode.id, name:this.selectedNode.text,type:2};
		}else if(this.record && this.D.getById(this.record.id)){
			var config = {itemid:this.record.id, name:this.record.data.name,type:2};
		}else{
			alert('请选择要设置绑定栏目');
            return;
		}
		EXCMS.util.QuickCreate({model:'Resource.ResourceBind',callback:this,config:config});
	},
	//更新
	update:function(item){
		var cid = [];
		if(this.treemenu){
			cid.push(this.node.id);
		}else{
			var r = this.grid.getSelectionModel().getSelections();
			for(var i=0;i<r.length;i++)cid.push(r[i].id);
		}
		EXCMS.util.QuickCreate({container:this.tabPanel,model:'Update.Update',type:item.mode,id:cid});
	},
	//更新首页
	updateindex:function(item){
		Ext.Ajax.request({
			url : 'index.php?M=Update&A=UpdateAction&method=updateindex',method:'post', 
			success:function(response,options){
				var r = jsonReturn(response);
				if(item.mode!=2) EXCMS.msg('提示',r.message);
			},
			scope:this                                 
		});
	},
	//更新栏目缓存
	updateCache:function(item){
		Ext.Ajax.request({
			url: this.baseAction + '&method=cache',method:'post',  
			success:function(response,options){
				var r = jsonReturn(response);
				if(item.mode!=2) EXCMS.msg('提示',r.message);
			},
			scope:this                                 
		});
	},
	//删除栏目
	del:function(item){
        var id, r;
        if (item && item.mode && this.treemenu) {
            id = this.node.id
        }
        else 
            if (r = this.grid.getSelectionModel().getSelections()) {
                var ids = []
                for (var i = 0; i < r.length; i++) 
                    ids.push(r[i].id)
                id = ids.join(',');
            }
        if (!id) {
            alert('请选择要删除的栏目');
            return;
        }
        Ext.MessageBox.confirm('警告', '删除栏目将同时删除栏目下的子栏目，且不可恢复;确实要删除选定的栏目吗？', function(o){
            if (o == 'yes') {
                Ext.Ajax.request({
                    url: this.baseAction + '&method=delete',
                    method: 'post',
                    params: {channelid: id},
                    success: function(response, options){
                        r = jsonReturn(response);
                        if (r.success) {
                            alert("删除栏目成功");
                            if (item.mode && this.treemenu) {
                                this.tree.getRootNode().removeChild(this.tree.getNodeById(this.node.id));
                            }
                            else {
                                for (var i = 0, len = ids.length; i < len; i++) {
                                    var n = this.tree.getNodeById(ids[i]);
                                    if (n != null) 
                                        this.tree.getRootNode().removeChild(n);
                                }
                            }
                            this.D.reload();
                        }
                    },
                    scope: this
                });
            }
        }, this);
	},
	//排序保存
	save : function(){
		var records = this.D.getModifiedRecords();
		var data = [];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({
	            url: this.baseAction+"&method=save",
	            method: 'POST', 
	            params:{data:Ext.util.JSON.encode(data)},
	            failure:function(response,options){alert("保存栏目排序出错，请重试");},
	            success:function(response,options){
	               this.D.commitChanges();
	            }.createDelegate(this)                                    
	       });
		}
	},
	//栏目移动
	move : function(){
		var r;
		var isTreeNode = this.treemenu;
		if(isTreeNode){
			r = this.selectedNode;
		}else{
			r = this.grid.getSelectionModel().getSelections();
		}
		if (!r || r=='') {alert('请选择要移动的栏目');return}
        if(!this.movewin){
			this.movetree = new Ext.tree.TreePanel({bodyStyle:'padding-top:5px',collapseMode:'mini',collapsible:false,split:true,minSize:35,autoScroll:true,rootVisible:true,animate:true,useArrows:true,
	            loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction + '&method=tree'}),
	            root:new Ext.tree.AsyncTreeNode({id:'0',text:'顶级栏目',expanded:true})
	        });
			this.movetree.on('click',function(n){
	        	if(this.movenode== n) return;
	        	this.movenode = n;
	        },this);
			this.movewin = new Ext.Window({title:'移动栏目',layout:'fit',width:500,height:400,closeAction:'hide',plain:true,
				bodyStyle:'padding:6px',items:this.movetree,modal:false,
				buttons:[
					{text:'移动',handler:function(){this.doMove()},scope:this},
					{text:'关闭',handler:function(){this.movewin.hide()},scope: this}
			]});
        }else{
        	this.movetree.getLoader().load(this.movetree.root);this.movetree.root.expand();
        }
		this.movenode = false;
		this.movewin.show();
	},
	doMove:function(){
		var moveChannel;
		var node = this.treemenu;
		if(node){
			moveChannel = this.selectedNode;
		}else{
			moveChannel = this.grid.getSelectionModel().getSelections()
		}
		if (!moveChannel || moveChannel=='') {alert('请选择要移动的栏目');return}
		
		if(moveChannel && this.movenode){
			var id = []
			if(node){
				id.push(moveChannel.id);
			}else{
				for(var i = 0; i < moveChannel.length; i++){id.push(moveChannel[i].id)}
			}
			Ext.Ajax.request({
				url:this.baseAction + '&method=move',method:'post',params:{channelid:id.join(','), pid:this.movenode.id},scope:this,
				success: function(response, options){
					r = jsonReturn(response);
					if(r.success){
						var modetoNode = this.tree.getNodeById(this.movenode.id);
						if(node){
							var moveParent = moveChannel.parentNode;
							if(moveParent.getDepth()<modetoNode.getDepth()){
								if(moveParent.getDepth()==0){this.tree.getLoader().load(this.tree.root);this.tree.root.expand();}
								else this.tree.getLoader().load(moveParent);moveParent.expand();
							}else if (moveParent.getDepth()>modetoNode.getDepth()){
								this.tree.getLoader().load(modetoNode); modetoNode.expand();
							}else{
								if(moveParent.id != modetoNode.id){
									if(moveParent.loaded){this.tree.getLoader().load(moveParent);moveParent.expand();}
									if(modetoNode.loaded){this.tree.getLoader().load(modetoNode); modetoNode.expand();}
								}
							}
						}else{
							if(this.node.id == 0 || this.node.id == '0') this.node = this.tree.root;
							if(this.node.getDepth()<modetoNode.getDepth()){
								this.tree.getLoader().load(this.node);this.node.expand();
							}else if (this.node.getDepth()>modetoNode.getDepth()){
								this.tree.getLoader().load(modetoNode); modetoNode.expand();
							}else{
								if(this.node.id != modetoNode.id){
									if(this.node.loaded){this.tree.getLoader().load(this.node);this.node.expand();}
									if(modetoNode.loaded){this.tree.getLoader().load(modetoNode); modetoNode.expand();}
								}else if(this.node = this.tree.root){
									if(this.node.loaded){this.tree.getLoader().load(this.node);this.node.expand();}
								}
							}
							this.D.reload();
						}
						delete(this.mocenode);
						this.movewin.hide();
					}
				}
			});
		}else{
			alert('请您选择目标栏目');
		}
	},
	//编辑单独页内容
	editBody:function(){
		var channelid = this.treemenu ? this.node.id : this.record.id;
		var name = this.treemenu ? this.node.text : this.record.data.name;
		EXCMS.util.QuickCreate({model:'Channel.BodyEditor',tabPanel:this.tabPanel,channelid:channelid,name:name});
	},
	//刷新树
	refreshTree : function(item){
		if(this.treemenu){
			if(item.mode) {if(this.tree.root.loaded)this.tree.getLoader().load(this.tree.root);this.tree.root.expand();}
			else {if(this.selectedNode.loaded)this.tree.getLoader().load(this.selectedNode);this.selectedNode.expand();}
		}else{
			this.D.reload();
		}
	},
	//复制
	copy : function(){
		if(this.treemenu){this.id=this.selectedNode.id}
		else if(r=this.grid.getSelectionModel().getSelections()){
			var ids=[]
			for(var i=0;i<r.length;i++)ids.push(r[i].id)
			this.id=ids.join(',');
		}
		if(this.id){
			this.grid.getTopToolbar().items.items[8].enable();
			this.contextmenu.items.items[8].enable();
		}else{
			alert("请选择一个或多个栏目");
		}
	},
	//粘贴
	paste : function(item){
		var param;
		if(!item.mode){
			this.curId = this.treemenu ? this.selectedNode.id : this.record.id;
			if(item.type==3){
				var re = /^[0-9]+.?[0-9]*$/;
			    if (!re.test(this.curId)){
			      	this.curId = 0;
		     	}
			}
			param = {curId:this.curId,id:this.id};
			if(!this.id){alert('请先复制栏目后再粘贴');return ;}
			if(!this.curId){alert('请选择目标栏目'); return ;}
		}else{
			param = {curId:this.curId,id:this.id,status:item.mode};
		}
        Ext.Ajax.request({
            url: this.baseAction + '&method=paste',
            method: 'post',
            params: param,
            success: function(response, options){
                r = jsonReturn(response);
                if (r.success==-201) {
                	this.id = r.ids;
                    Ext.MessageBox.confirm("确认栏目替换", "此栏目已包含一个名为\""+r.message+"\"的栏目，是否将现有栏目\""+r.message+"\"替换为\""+r.message+"\"", showResult);
                }else{
                	EXCMS.msg('提示',r.message);
                    this.D.reload();
                    if(this.treemenu) {
                    	var pNode = this.selectedNode.parentNode;
                    	if(this.selectedNode.leaf && pNode){this.tree.getLoader().load(pNode);pNode.expand();}
                    	else if(this.selectedNode.loaded){this.tree.getLoader().load(this.selectedNode);this.selectedNode.expand();}
                    }else{
                    	if(this.node.loaded){{this.tree.getLoader().load(this.node);this.node.expand();}}
                    }
                }
            },
            scope: this
        });
        function showResult(btn){
            if (btn == 'yes') {
                EXCMS.Channel.paste({mode: 1});
                Ext.MessageBox.hide();
            }
            else {
                EXCMS.Channel.paste({mode: 2});
                Ext.MessageBox.hide();
            }
        }
	},
	// 批量新建栏目
	batchAdd : function(){
		var channel = {};
		if(this.treemenu){
			channel = {pid:this.selectedNode.id, channelname:this.selectedNode.text};
		}else if(this.record && this.D.getById(this.record.id)){
			channel = {pid:this.record.id, channelname:this.record.data.name};
		}
		EXCMS.util.QuickCreate({model:'Channel.ChannelBatchAdd',tabPanel:this.tabPanel,channel:channel});
	}
};
EXCMS.onReady(EXCMS.Channel.init, EXCMS.Channel);

EXCMS.Channel.Cross = function(){};
EXCMS.Channel.Cross.prototype = {
	init:function(baseAction){
		this.baseAction = baseAction;
		var checkColumn = new Ext.grid.CheckColumn({header: "相互关联?",dataIndex: 'eachother',width:80});
		this.D = new Ext.data.Store({
            proxy:new Ext.data.HttpProxy({url:this.baseAction + '&method=crossStore'}),
            reader:new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'crossid',
                fields:[{name:'crossid',type:'int'},'name',{name:'eachother',type:'bool'},{name:'sort',type:'int'}]
            })
        });
		var fm = Ext.form;
        this.G = new Ext.grid.EditorGridPanel({
           	enableColumnMove:false,border:false,layout:'fit',anchor:'100% 100%',collapsible:true,animCollapse:false,iconCls:'icon-grid',minColumnWidth:7,autoExpandColumn:1,plugins:checkColumn,selModel:new Ext.grid.RowSelectionModel(),loadMask:true,
            store:this.D,
            columns:[
                {header:'ID',width:60,sortable:true,dataIndex:'crossid'},
                {header:'栏目名称',width:200,sortable:true,dataIndex:'name'},
                checkColumn,
                {header:'排序',width:60,align:'right',sortable:true,dataIndex:'sort',editor:new fm.NumberField({allowBlank:false,allowNegative: false,maxValue:100000})}
            ],
            tbar:[
				{text:'添加',handler:this.add,scope:this},
                {text:'删除',handler:this.del,scope:this},'-',
				{text: '全部相互关联',handler:this.crossJoin,scope:this,mode:1},
				{text: '取消相互关联',handler:this.crossJoin,scope:this,mode:0},'-',
				{text:'选择',menu:{items:[
					{text:'全选',handler:this.recordsSelect,scope:this,mode:1},
	                {text:'反选',handler:this.recordsSelect,scope:this,mode:2},
					{text:'取消选择',handler:this.recordsSelect,scope:this,mode:3}
				]}},
				{text: '刷新',handler:this.refresh,scope:this}
            ]
        });
		this.win=new Ext.Window({id:'excms-win-channel-cross',title:'',layout:'fit',minimizable:true,modal:false,
			resizable:true,width:560,height:400,minWidth:560,minHeight:400,closeAction:'hide',plain:false,
			items:this.G,
			buttons:[
				{text:'确定',handler:this.ok,scope:this},
				{text:'取消',handler:this.cannel,scope:this}
			]
		});
	},
	show:function(config){
		this.win.setTitle(config.name + '栏目交叉属性');
		this.win.show();
		this.win.center();
		this.changeData = {'add':[],'delete':[]};
		if(this.channelid != config.channelid || this.reload){
			this.channelid = config.channelid;
			this.load();	
		}
	},
	load:function(){
		this.D.baseParams = {channelid:this.channelid};
    	this.D.load();
		this.reload = false;
	},
	add:function(){
		EXCMS.util.QuickCreate({model:'Channel.Selector',callback:this.callback.createDelegate(this)});
	},
	callback:function(records){
		var message = '';
		for(var i=0;i<records.length;i++){
			if(records[i].id == this.channelid){
				message = '您选择的栏目中包含栏目本身，栏目不能交叉自身';
				break;
			}else if(records[i].data.type > 0){
				message = "栏目不能交叉'封面','单独页','跳转'类型栏目";
				break;
			}
		}
		if(message != ''){
			alert(message);
		}else{
			var ids = [];
			for(var i=0;i<records.length;i++){
				if (!this.D.getById(records[i].data.channelid)) {
					this.D.add(new Ext.data.Record({crossid:records[i].data.channelid,name:records[i].data.name,cross:false,sort:50},records[i].data.channelid));
					this.setChangeData(records[i].data.channelid, 'add');
				}
			}
		}
	}, 
	del:function(){
        var records = this.G.getSelectionModel().getSelections();
        var len = records.length;
        if (len > 0) {
            for (var i = 0; i < records.length; i++) {
				this.setChangeData(records[i].id, 'delete');
                this.D.remove(records[i]);
            }
        }
	},
	setChangeData:function(id, addOrDel){
        var len = this.changeData[addOrDel].length;
        var flag = true;
        if (len > 0) {
            for (var k = 0; k < len; k++) {
                if (this.changeData[addOrDel][k] == id) {
                    flag = false;
                    break;
                }
            }
        }
        if (flag) {
			var delOrAdd = addOrDel == 'add' ? 'delete' : 'add';
			var len = this.changeData[delOrAdd].length;
	        if (len > 0) {
				var index = 0;
	            for (var k = 0; k < len; k++) {
	                if (this.changeData[delOrAdd][k] == id) {
	                    flag = false;
						this.changeData[delOrAdd].splice(index, 1);
	                    break;
	                }
					index++;
	            }
	        }
			if(flag){
				this.changeData[addOrDel].push(id);	
			}
        }
	},
	getData:function(){
		var data = [];
		for(var i=0;i<this.D.getCount();i++){
			data.push(this.D.data.items[i].data);
		}
		data = {'add':this.changeData['add'].join(','), 'delete':this.changeData['delete'].join(','),'data':data};
		return Ext.util.JSON.encode(data);
	},
	checkChange:function(){
		return this.changeData['add'].length > 0 || this.changeData['delete'].length > 0 || this.D.getModifiedRecords().length > 0; 
	},
	commit:function(){
		Ext.Ajax.request({
			url: this.baseAction + '&method=commitCrossData',method:'post',params:{channelid:this.channelid, crossdata:this.getData()},
			success:function(r,o){
				r=jsonReturn(r);
				if(r.success){
					this.reload = false;
				}
			},
			scope:this
		});
	},
	ok:function(){
		if(this.checkChange()){
			this.commit();
		}
		this.hide();
	},
	cannel:function(){
		if(this.checkChange()){
			if(!confirm("栏目交叉属性数据已经变更，确定不保守栏目交叉属性数据吗？")){
				return;
			}
			this.changeData = {'add':[],'delete':[]};
			this.reload = true;
		}
		this.hide();
	},
	hide:function(){this.D.commitChanges();this.win.hide();},
	recordsSelect:function(item){
		var mode = item && item.mode ? item.mode : 1;
		 switch(item.mode){
			 case 1 : this.G.getSelectionModel().selectAll(); break;
			 case 2:  for (var i = 0; i < this.D.getCount(); i++) this.G.getSelectionModel().isSelected(i) ? this.G.getSelectionModel().deselectRow(i) : this.G.getSelectionModel().selectRow(i, true);break;
			 case 3 : this.G.getSelectionModel().clearSelections(); break;
		 }
	},
	crossJoin:function(item){
		for (var i = 0; i < this.D.getCount(); i++){
			this.D.getAt(i).set('eachother', item.mode);
		}
	},
	refresh:function(){this.D.reload()}
};
