EXCMS.Content.ArticleBodyEditor={
	baseAction:'index.php?M=Content&A=Index',	
	load:function(item){
		this.contentid = item.record.id;
		if(!this.container){
			this.container = item.container;
		}
		var formId = 'art-body-editor-' + this.contentid;
		var editor = this.container.getComponent(formId);
		
		if(!editor){
			var title = item.record.get('title');
			if(title.length > 10){title = title.substr(0,10) + '...';}
			editor = new Ext.FormPanel({title:title,id:formId,closable:true,layout:'fit',waitMsgTarget:true,autoScroll:true,
				items:[
					{xtype:'hidden',name:'contentid',value:this.contentid},
					{name:'body',xtype:'articleeditor',height:'"100%"',border:false,hideLabel:true,enableSourceEdit:true}
				],tbar:[
					{text:'保存',iconCls:'btnico btn_save',handler:this.submit,scope:this},
					{text:'重新加载',handler:this.loadData,scope:this},
					{text:'取消',iconCls:'btnico btn_cancel',handler:this.cancel,scope:this}
				]
			});
			editor = this.container.add(editor);
			editor.on('activate',this.setHeight,this);
			editor.on('resize',this.setHeight,this);
			editor.form.on('actioncomplete',function(f,a){if(a.type=='submit') if(a.result.success){alert('内容保存成功');this.cancel();}}, this);
		}
		this.container.activate(editor);
		this.loadData();
	},
	//加载文章Body数据
	loadData:function(){
		this.form.load({url:this.baseAction + '&method=getBody',
			waitMsg:'数据加载中...',
			params:{contentid:this.contentid},
			failure:function(r,o){
				alert('加载数据失败，请重试');
			}
		});
	},
	//设置编辑器高度
	setHeight:function(o){
		this.form = o.form;
		var h = o.getInnerHeight();
		o.items.items[1].setHeight(h);
	},
	//提交数据
	submit:function(item){
		this.form.submit({url:this.baseAction + '&method=updateBody'});
	},
	cancel:function(){
		this.container.remove(this.container.getActiveTab());this.container.activate(this.container.getComponent(0));
	}
};