EXCMS.Content.autoAbstract = {
	init : function(){
	    Ext.QuickTips.init();
		this.baseUrl = 'index.php?M=Content&A=AutoAbstractAction';
	    this.view();
	},
	view : function(){
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth: 150,border: false,baseCls:'x-plain',
			autoLoad:{url:'index.php?M=Common&A=ActionPanel&T=html',scripts:true}
		});
		
		this.descsize = new Ext.form.NumberField({fieldLabel:'描述长度',name:'pagesize',value:220,width:140,maxValue:300,maxText:'最大值不能超过300',
			listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;},scope:this}}});
		this.desctip = new Ext.form.Label({width:470,text:'从正文(去除Html标签)中取指定长度做为内容描述，建议控制在220字节内（即110个文字以内）。',style:'display:block;padding:0 0 6px 112px;color:#666;'});
		this.pagesize = new Ext.form.NumberField({fieldLabel:'分页大小',name:'pagesize',value:1000,width:140,maxValue:10000,maxText:'最大值不能超过10000',
			listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;el.ct.style.display='none'},scope:this}}});
		this.pagetip = new Ext.form.Label({width:470,text:'指定自动分页大小（不包含Html标签），单位：字符数，一个汉字为两个字符。',style:'display:block;padding:0 0 6px 112px;color:#666;',hidden:true});

		this.mainPanel = new Ext.Panel({title:'内容自动描述、分页',layout:'border',items:[
				new Ext.tree.TreePanel({region:'west',width:180,cls:'channel-tree',border:false,style:'border-right:1px solid #99BBE8;border-bottom:1px solid #99BBE8',
					bodyStyle:'padding:8px 1px;',split:false,width:200,minSize:80,autoScroll:true,useArrows:true,containerScroll:true,rootVisible:true,
					loader:new Ext.tree.TreeLoader({baseAttrs:{uiProvider:Ext.ux.TreeCheckNodeUI},dataUrl:'index.php?M=Channel&A=ChannelTree'}),
					root:new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',checked:false,expanded:true,ToExpend:true,draggable:false})
				}),
				new Ext.Panel({title:"处理状态",region:'south',border:false,autoScroll:true,split:true,
					height:200,style:'border-top:1px solid #99BBE8',cls:'preview',
					html:'<iframe name="contenabstractiframe" src="" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
				}),
				{region:'center',xtype:'form',layout:'form',autoScroll:true,labelWidth:106,border:false,bodyStyle:'padding:10px;',style:'border-bottom:1px solid #99BBE8',items:[
     				{xtype:'hidden',name:'channelid'},
     				{fieldLabel:'每轮处理内容数',xtype:'numberfield',name:'max',value:50,width:140,maxValue:2000,maxText:'最大值不能超过2000'},
     				{fieldLabel:'子栏目选项',boxLabel:'包含子级栏目内容',name:'subchannel',xtype:'checkbox',inputValue:1},
     				{fieldLabel:'内容范围',hiddenName:'option',xtype:'combo',value:1,width:140,editable:false,mode:'local',
     					triggerAction:'all',selectOnFocus:true,
     					store: [[1,'所有内容'],[2,'最新发布内容'],[3,'指定时间区间内容'],[4,'制定内容ID区间内容'],[5,'指定内容ID内容']],
     					listeners:{'select':{fn:function(c,r,i){for(var k=1;k<5;k++){c.ownerCt.items.items[3+k].ct.style.display='none'}if(i>0)c.ownerCt.items.items[3+i].ct.style.display='block'},scope:this}}
     				},
     				{fieldLabel:'最新发布内容数',xtype:'numberfield',name:'latestnum',width:140,minValue:0,listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;el.ct.style.display='none'},scope:this}}},
     				{layout:'form',anchor:'100%',border:false,defaultType:'datefield',defaults:{vtype:'daterange',width:123},items:[
     					{fieldLabel:'起始内容发布时间',name:'startdate',id:'startdate',endDateField:'enddate',selectOnFocus:true,format:'Y-m-d'},
     					{fieldLabel:'结束内容发布时间',name:'enddate',id:'enddate',startDateField:'startdate',selectOnFocus:true,format:'Y-m-d'}
     				],listeners:{'render':{fn:function(el){el.ct=el.el.dom;el.ct.style.display='none'},scope:this}}},
     				{layout:'form',anchor:'100%',border:false,defaultType:'numberfield',defaults:{width:140},items:[
     					{fieldLabel:'起始内容ID',name:'startid',minValue:0},
     					{fieldLabel:'结束内容ID',name:'endid',minValue:0}
     				],listeners:{'render':{fn:function(el){el.ct=el.el.dom;el.ct.style.display='none'},scope:this}}},
     				{fieldLabel:'指定内容ID',name:'contentid',xtype:'textfield',value:'',width:400,height:160,emptyText:"多个内容ID用','(逗号)或' '(空格)隔开",listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;el.ct.style.display='none'},scope:this}}},
     				{fieldLabel:'操作',width:180,xtype:'radiogroup',items:[
     					{boxLabel:'自动描述',name:'operate',checked:true,inputValue:1},
     					{boxLabel:'自动分页',name:'operate',inputValue:2,listeners:{check:function(c,n){
     						this.descsize.ct.style.display = n ? 'none' : 'block';
 							this.desctip.setVisible(!n);
 							this.pagesize.ct.style.display = n ? 'block' : 'none';
 							this.pagetip.setVisible(n);
     					},scope:this}}
     				]},
     				this.descsize, this.desctip, this.pagesize, this.pagetip
     			]}
			],
			tbar:[
				{text:'执行',handler:this.update,scope:this},'-',
				{text:'重置',handler:this.reset,scope:this}
			]
		});
		
		this.tabPanel = new Ext.TabPanel({xtype:'tabpanel',region:'center',margins:'0 5 5 0',border:false,style:'border:1px solid #99BBE8;border-width:0px 1px 1px',activeTab:0,enableTabScroll:true,items:this.mainPanel});
	    new Ext.Viewport({layout:'border',items:[actionPanel,this.tabPanel]});
	    this.form = this.mainPanel.layout.center.panel.form;
	},
	update:function(){
		var f = this.mainPanel.layout.center.panel.form;	
		var wp = this.mainPanel.layout.west;
		if(wp){
			var checkedNodes = wp.panel.getChecked();
			var channelid = [];
			if(checkedNodes.length>0){
				for(var i=0;i<checkedNodes.length;i++){
					if(checkedNodes[i].id)channelid.push(checkedNodes[i].id);
				}
			}else{
				channelid = this.mainPanel.updateIds;
			}
			f.findField('channelid').setValue(channelid&&channelid.length ? channelid.join(',') : '');
		}
		this.form.el.dom.target = this.mainPanel.layout.south.el.dom.getElementsByTagName('iframe')[0].name;
		this.form.el.dom.action = this.baseUrl;
		if(!this.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return }
		this.form.el.dom.submit();
	},
	reset:function(){this.form.el.dom.reset();}
	
};
EXCMS.onReady(EXCMS.Content.autoAbstract.init,EXCMS.Content.autoAbstract);