EXCMS.Content.DocStat={
	baseAction:'index.php?M=Content&A=StatAction',
	init : function(){
		Ext.QuickTips.init();
	    this.view();
	},

	view : function(){
		this.toolbar = [
		    {text:'通用统计',handler:this.simpleStat,scope:this},'-',
			{text:'综合分析',handler:this.multiple,scope:this,mode:''},'-',
			{text:'直方',enableToggle: true,pressed:true,toggleGroup:'btnType',handler:this.updateStat,scope:this,mode:0},
			{text:'饼图',enableToggle: true,toggleGroup:'btnType',handler:this.updateStat,scope:this,mode:1},
			{text:'折线',enableToggle: true,toggleGroup:'btnType',handler:this.updateStat,scope:this,mode:2},
			{text:'散点',enableToggle: true,toggleGroup:'btnType',handler:this.updateStat,scope:this,mode:3},'-',
			{text: '2D',enableToggle: true,pressed:true,toggleGroup:'btnType', handler:this.change3D,scope:this}
		];
		this.panel = new Ext.Panel({title:'文档统计列表',autoScroll:true,layout:'fit',html:'<div id="stat-charts"></div>'});
		
		this.node = new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',expanded:true});
        this.tree = new Ext.tree.TreePanel({id:'west',region:'west',title:'网站栏目树',cls:'channel-tree',bodyStyle:'padding:8px 1px',border:false,style:'borderlright:1px solid #99BBE8;',collapseMode: 'mini',collapsible:true,split:true,width:200,minSize:35,maxSize:500,autoScroll:true,rootVisible: true,animate:true,useArrows:true,loader:new Ext.tree.TreeLoader({dataUrl:'index.php?M=Channel&A=ChannelTree&treetype=crose'}),root:this.node});

		this.tabPanel = new Ext.TabPanel({id:'tabPanel',region:'center',border:false,autoScroll:true,margins:'0 3 3 0',style:'border:1px solid #99BBE8;border-width:0px 1px 1px 1px',activeTab:0,enableTabScroll:true,items:this.panel,tbar:this.toolbar});
	    this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});
        

        this.mainPanel = this.viewport.getComponent(1);
		
	    this.tree.on('click', function(n){
	    	if(this.node==n) return;
			this.node = n;
			this.url = this.baseAction+'&method=channel&node='+n.id;
			this.viewStat();
	    },this);
		this.chart3D = 0;
		this.chartMode=0;
		this.multiple();
	},
	//通用统计
	simpleStat : function(){
		if(!this.statwin){
	        this.channeltree = new Ext.tree.TreePanel({region:'west',title:'内容字段列表',bodyStyle:'padding-top:5px',border:false,style:'border:1px solid #99BBE8;border-width:1px 1px 1px 1px;',collapseMode: 'mini',collapsible:false,split:true,width:170,minSize:35,autoScroll:true,rootVisible: true,animate:true,useArrows:true,loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=fieldlist'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'内容字段树',expanded:true})});
	        this.channeltree.contextmenu = new Ext.menu.Menu({items: [
       		    {text: '添加到数据条件中',icon:ico,iconCls:'btnico btn_add',handler:this.add,scope:this,mode:1},
       		    {text: '添加到统计条件中',icon:ico,iconCls:'btnico btn_add',handler:this.add,scope:this,mode:2}
       	    ]});
       	    this.channeltree.on('click',function(n,e){
	        	this.channeNode=n;
	        	n.expand();
	        	n.select();
        	},this);
	        this.channeltree.on('contextmenu',function(n,e){
	        	this.channeNode=n;
	        	n.select();
	        	this.channeltree.contextmenu.showAt(e.getXY());
        	},this);
        	
	        this.dataplant = Ext.data.Record.create(['id','table','field','logical','from_table','from_field','from_value','name','relations','value']);
			this.data = new Ext.data.Store({
				reader:new Ext.data.JsonReader({root:'data',totalProperty:'total'},this.dataplant),
				remoteSort:true
			});
			this.griddata = new Ext.grid.EditorGridPanel({title:'数据条件',collapsible:false,animCollapse:false,region:'north',border:false,height:180,sm:new Ext.grid.RowSelectionModel(),
				store:this.data,
	            columns:[
	                new Ext.grid.RowNumberer(),
	                {header:"逻辑符",width:60,sortable:true,dataIndex:'logical',editor:new Ext.form.ComboBox({hideLabel:true,
	                hiddenName:'logical',value:'且',store:['且','或','非'],editable:false,triggerAction:'all',selectOnFocus:true})},
	                {header:"查询指标",width:80,sortable:true,dataIndex:'name'},
	                {header:"关系符",width:60,sortable:true,dataIndex:'relations',editor:new Ext.form.ComboBox({hideLabel:true,hiddenName:'relations',value:0,valueField:'id',displayField:'relations',store:['>','<','=','>=','<=','!='],editable:false,triggerAction:'all',selectOnFocus:true})},
	                {header:"查询值",width:150,sortable:true,dataIndex:'value',editor: new Ext.form.TextField()}
	            ],
	            tbar:[
	  				{text:'添加',iconCls:'btnico btn_add',handler:this.add,scope:this,mode:1},
	  				{text:'删除',iconCls:'btnico btn_del',handler:this.del,scope:this,mode:1}
  				]
	        });
			this.statplant = Ext.data.Record.create(['id','name','table','field','from_table','from_field','from_value','relations','value']);
			this.stat = new Ext.data.Store({
				reader:new Ext.data.JsonReader({root:'data',totalProperty:'total'},this.statplant),
				remoteSort:true
			});
			this.gridstat = new Ext.grid.EditorGridPanel({title:'统计条件',header:true,collapsible:false,animCollapse:false,region:'center',border:false,sm:new Ext.grid.RowSelectionModel(),
				store:this.stat,
	            columns:[
	                new Ext.grid.RowNumberer(),
	                {header:"统计指标",width:100,sortable:true,dataIndex:'name'},
	                {header:"关系符",width:60,sortable:true,dataIndex:'relations',editor: new Ext.form.ComboBox({hideLabel:true,hiddenName:'relations',value:0,
	    				store:['>','<','=','>=','<=','!='],editable:false,triggerAction:'all',selectOnFocus:true})},
	                {header:"统计值",width:150,sortable:true,dataIndex:'value',editor: new Ext.form.TextField()}
	            ],
	            tbar:[
	  				{text:'添加',iconCls:'btnico btn_add',handler:this.add,scope:this,mode:2},
	  				{text:'删除',iconCls:'btnico btn_del',handler:this.del,scope:this,mode:2}
  				]
	        });
			var center = new Ext.Panel({region:'center',closable:true,layout:'border',autoScroll:true,items:[this.griddata,this.gridstat]});

	        this.statwin=new Ext.Window({layout:'border',modal:false,border:false,resizable:false,width:600,height:450,closeAction:'hide',plain:false,
	            items:[this.channeltree,center],
	            buttons:[{text:'确定',handler:this.saveStat,scope:this},{text:'取消',handler:function(){this.statwin.hide();},scope:this}]
	        });
		}
		this.statwin.setTitle('通用统计');
		this.statwin.show();
		
	},
	add : function(item){
		
		if(!this.channeNode || !this.channeNode.id){
			alert("请选择统计指标");
			return ;
		}
		if(this.channeNode.attributes['is_table']==1){
			alert('您选择的不是字段');
			return ;
		}
		if(item.mode==1){
			var p = new this.dataplant({id:this.channeNode.id,table:this.channeNode.attributes['table'],field:this.channeNode.attributes['field'],from_table:this.channeNode.attributes['from_table'],from_field:this.channeNode.attributes['from_field'],from_value:this.channeNode.attributes['from_value'],logical:'且',name:this.channeNode.text,relations:'>',value:''});
			this.griddata.stopEditing();
			this.data.insert(0,p);
			this.griddata.startEditing(0,0);
		}else{
			var p = new this.statplant({id:this.channeNode.id,name:this.channeNode.text,table:this.channeNode.attributes['table'],field:this.channeNode.attributes['field'],from_table:this.channeNode.attributes['from_table'],from_field:this.channeNode.attributes['from_field'],from_value:this.channeNode.attributes['from_value'],relations:'>',value:''});
			this.gridstat.stopEditing();
			this.stat.insert(0,p);
			this.gridstat.startEditing(0,0);
		}
	},
	del : function(item){
		if(item.mode==1){
			var selected = this.griddata.getSelectionModel().getSelections();
			for(var i=0;i<selected.length;i++){
				this.data.remove(selected[i]);
			}
		}else{
			var selected = this.gridstat.getSelectionModel().getSelections();
			for(var i=0;i<selected.length;i++){
				this.stat.remove(selected[i]);
			}
		}
	},
	saveStat : function(){
		var statcount = this.stat.getCount();
		if(!statcount){alert('请选择一个统计条件进行数据统计'); return ;}
		var dcond='';
		var datacount = this.data.getCount();
		var dcond=[];
		if(datacount>0){ 
			for(i=0;i<datacount;i++){
				dcond.push(this.data.getAt(i).data);
			}
		}
		var condArray = new Array();
		if (statcount > 1){
			for(i=0;i<statcount;i++){
				condArray[i] =  this.stat.getAt(i).get('id');
			}
			condArray = condArray.distinct();
			if(condArray.length>2){
				alert("不同的'统计指标'最多只能选两个！"); 
				return ;
			}
		}
		var scond=[];
		for(var i=0;i<statcount;i++){
			scond.push(this.stat.getAt(i).data);
		}

		this.url = this.baseAction+'&method=commit&dcond='+encodeURI(Ext.util.JSON.encode(dcond))+"&scond="+encodeURI(Ext.util.JSON.encode(scond));
		
		if(condArray.length==2){
			Ext.get('stat-charts').getUpdater().update({url:this.url,method:'GET',scripts:true});
			for(var i=4;i<10;i++){
				this.tabPanel.getTopToolbar().items.items[i].disable();
			}
		}else{
			Ext.get('stat-charts').dom.innerHTML = '<img src="'+ this.url +'" style="margin:10px;" />';
			for(var i=4;i<10;i++){
				this.tabPanel.getTopToolbar().items.items[i].enable();
			}
		}
		this.statwin.hide();
	},
	change3D : function(){
		this.chart3D = this.chart3D ? 0 : 1;
		this.tabPanel.getTopToolbar().items.items[9].setText(this.chart3D ? '3D' : '2D');
		this.viewStat();
	},
	updateStat : function(item){
		this.chartMode = item.mode;
		this.viewStat();
	},
	multiple : function(){
		this.url = this.baseAction+"&method=multiple";
		this.viewStat();
	},
	viewStat : function(falg){
		for(var i=4;i<10;i++){
			this.tabPanel.getTopToolbar().items.items[i].enable();
		}
		url = this.url+"&chartMode="+this.chartMode+"&is3D="+this.chart3D;
		Ext.get('stat-charts').dom.innerHTML = '<img src="'+ url +'" style="margin:10px;" />';
	}
	
};
EXCMS.onReady(EXCMS.Content.DocStat.init,EXCMS.Content.DocStat);

Array.prototype.distinct=function(){
	var a=[],b=[];
	for(var prop in this){
		var d = this[prop];
		if (d===a[prop]) continue;
		if (b[d]!=1){
			a.push(d);
			b[d]=1;
		}
	}
	return a;
}