EXCMS.Editor=function(config){
	Ext.apply(this,config);
	this.init();
};
EXCMS.ModelFields={};
EXCMS.Editor.prototype = {
	titleMaxLength:80,
	multiEdit:true,
	modelFields:{hidden:true},
	baseAction:'index.php?M=Content&A=Index',
	editorid:'',
	isRendered:false,
	systemField:{},
	init:function(){
		if(!this.multiEdit && this.container){
			this.editorid = 'editor-content-model-' + this.modelid;
			var fp = this.container.getComponent(this.editorid)
			if (fp) {
				this.container.activate(fp);
				this.setValue();
				return ;
			}
		}else if(this.contentid && this.container){
			this.editorid = 'editor-content-' + this.contentid;
			var fp = this.container.getComponent(this.editorid)
			if (fp) {
				this.container.activate(fp);
				return ;
			}
		}
		var title = '';
		if(this.contentid){
			title = this.title || '编辑';
			this.loadData();
		}else{
			title = '新建' + (this.modelname||'内容');
			this.contentid='';
		}
		this.setTitle(title);
		this.loadModel();
		return this;
	},
	loadModel:function(){
		if(!this.modelid && !this.model) return ;
		this.isLoadModel = true;
		if(EXCMS.ModelFields[this.modelid]){
			this.modelFields = EXCMS.ModelFields[this.modelid];
			this.initCompent();
			return ;
		}

		this.mask('正在加载模型...');
		Ext.Ajax.request({
            url:'index.php?M=Model&A=Index&method=geteditor',method:'POST',params:{modelid:this.modelid,model:this.model},scope:this,
			failure:function(){this.unmask()},
            success:function(r,o){
				this.unmask()
				r = Ext.decode(r.responseText);
				if(r.success){
					if(r.data){
						for(var i=0;i<r.data.length;i++){
							eval("r.data["+i+"]="+r.data[i]+";");
						}
						EXCMS.ModelFields[this.modelid] = r.data;
						this.modelFields = r.data;
					}
					if(r.system){
						for (field in r.system){
							eval("this.systemField."+field+"="+r.system[field]+";");
						}
					}
					if(r.mirrorinfo){
						EXCMS.setMirrorInfo(r.mirrorinfo);
					}
					this.initCompent();
				}
            }                           
        });
	},
	initCompent:function(){
		var tthis = this;
		window.top.EXCMS.getChannelId = function(){return tthis.fields.channelid.getValue()}
		window.top.EXCMS.getContentId = function(){return tthis.contentid;}
		this.fields = {
			'title':new Ext.form.TextField({fieldLabel:'标题',anchor:'-244',xtype:'textfield',name:'title',cls:'editor-title',invalidClass:'editor-title-invalid',allowBlank:false,blankText:'内容标题不能为空',maxLength:this.titleMaxLength,maxLengthText:'长度必须小于80个字符(40个汉字)，推荐66个字符以内(33个汉字)',enableKeyEvents:true}),
			'color':new Ext.form.Hidden({name:'color',value:''}),
			'bold':new Ext.form.Hidden({name:'bold'}),
			'italic':new Ext.form.Hidden({name:'italic'}),
			'underline':new Ext.form.Hidden({name:'underline'}),
			'titlesetting':new Ext.form.Label({cls:'title_ico',html:'<a href="javascript:;" class="title_length"></a><a href="javascript:;" class="title_check" title="检查标题是否重复">检查重复</a><a href="javascript:;" class="title_bold" title="粗体"></a><a href="javascript:;" class="title_italic" title="斜体"></a><a href="javascript:;" class="title_underline" title="下划线"></a><a href="javascript:;" class="title_color" title="文字颜色(默认)"></a>',listeners:{'render':this.onRenderTitle,scope:this}}),
			
			'channelid':new Ext.form.Hidden({name:'channelid'}),
			'crossid':new Ext.form.Hidden({name:'crossid'}),
			'channel':new Ext.form.ComboBox({fieldLabel:'栏目',style:'font-family:"宋体"',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode:'local',triggerAction:'all',hiddenName:'channelname',tpl:'<tpl for="."><div style="height:220px"><div></div></div></tpl>',selectedClass:'',onSelect:Ext.emptyFn,allowBlank:false,blankText:'所属栏目不能为空',emptyText:'请选择所属栏目'}),
			
			'author':new Ext.form.ComboBox({fieldLabel:'作者',maxHeight:220,name:'author',valueField:'author',displayField:'author',maxLength:60,maxLengthText:'作者字符长度必须小于60',typeAhead:false,selectOnFocus:true,triggerAction:'all',emptyText:'请选择或输入作者',store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Content&A=Author&method=getComboData'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['author']),remoteSort:true})}),
			'source':new Ext.form.ComboBox({fieldLabel:'来源',maxHeight:220,name:'source',valueField:'source',displayField:'source',maxLength:60, maxLengthText:'来源字符长度必须小于60',waitMsgTarget:true,typeAhead:false,triggerAction:'all',emptyText:'请选择或输入来源',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Content&A=Source&method=getComboData'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','source']),remoteSort:true})}),
			'forward':new Ext.form.TextField({hideLabel:true,xtype:'textfield',name:'forward',emptyText:'请输入转向链接地址(URL)',disabled:true, maxLength:100, maxLengthText:'长度必须为小于100个字符'}),
			'comment':new Ext.form.Checkbox({hideLabel:true,boxLabel:'允许评论',name:'comment',checked:true,inputValue:1,listeners:{render:function(c){c.el.dom.parentNode.parentNode.parentNode.parentNode.style.cssText+=';float:left;margin:-25px 0 0 130px;'},scope:this}}),
			'templet':new Ext.form.ComboBox({fieldLabel:'模板',maxHeight:220,name:'template',value:'',valueField:'id',displayField:'id',waitMsgTarget:true,typeAhead:true,triggerAction:'all',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Common&A=TemplatesList&cate=content'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true}),forceSelection:true})
		};
		this.fields.title.on('keyup',function(t,e){this.ti[0].setValue()},this);
		this.fields.channel.tree = new Ext.tree.TreePanel({useArrows:true,cls:'channel-tree',bodyStyle:'padding:1px;',border:false,loader:new Ext.tree.TreeLoader({dataUrl:'index.php?M=Channel&A=Index&method=tree&treetype=crose',baseParams:{modelid:1}}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',expanded:true}),listeners:{'render':{fn:function(c){var t=c.el.dom.parentNode.parentNode.parentNode.parentNode;t.style.backgroundColor='#FFFFFF';new Ext.Resizable(t,{handles:'s',resizeChild:true})},scope:this}}});
		this.fields.channel.tree.contextmenu = new Ext.menu.Menu({items:[{text:'刷新栏目',icon:ico,iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this,mode:1}]}); 
		this.fields.channel.tree.on('contextmenu',function(n,e){
			this.selectedNode = n;this.channelrefresh = true;
	    	this.fields.channel.tree.contextmenu.showAt(e.getXY());
			this.fields.channel.tree.contextmenu.items.items[0].mode = n.id == '0';
		},this);
		this.fields.channel.on('collapse',function(c){if (this.channelrefresh) {this.channelrefresh = false;c.expand();}},this)
		this.fields.channel.tree.on('click',function(n){
			if(n.attributes['type']==0){
				if (n.attributes['modelid'] == this.modelid) {
					this.currentChannel = {channelid:n.attributes.id,text:n.attributes.text,modelid:n.attributes.modelid};
					if(n.attributes['cross'] == 1){
						var channelname = n.parentNode.text + '[' + n.text + ']';
						if(n.parentNode.parentNode && n.parentNode.parentNode.id != '0') channelname = n.parentNode.parentNode.text + ' > ' + channelname;
					}else{
						var channelname = n.text;
						if(n.parentNode && n.parentNode.id != '0') channelname = n.parentNode.text + ' > ' + channelname;
					}
					this.fields.channel.setValue(channelname.replace(/<[0-9a-zA-Z]{1,} .*<\/[0-9a-zA-Z]{1,}>/gm,""));
					this.fields.channelid.setValue(n.attributes['cross'] == 1 ? n.parentNode.id : n.id);
					if (n.attributes['cross'] == 1) {
						var cross = n.id.split('_');
						this.fields.crossid.setValue(cross[1]);
					}else {
						this.fields.crossid.setValue('');
					}
					this.fields.channel.collapse();
					this.fields.comment.setValue(n.attributes['Arccomment']);
				}
			}else n.expand();
		},this);
		this.fields.channel.on('expand',function(){this.fields.channel.tree.render(this.fields.channel.list.dom.getElementsByTagName('div')[2]);},this);
		
		var eastBdStyle = 'background:#f3f3f7;';
		var tabBodyStyle = 'padding:6px 2px 0 8px;background:#f3f3f7;';
		var labelStyle = 'display:block;padding-left:45px;padding-bottom:6px;color:#666;'
		
		// recommend panel
		/*
		this.recommendPanel = new Ext.Panel({height:220,autoScroll:true,html:'',tbar:[
		        '<b style="color:#15428B">推荐及碎片</b>','->',
			    {text:'选择',handler:this.selectRmd,scope:this},
			    {text:'删除',handler:this.removeRmd,scope:this,type:'selected'},'-',
			    {xtype:'checkbox',inputValue:1,name:'updateblock',boxLabel:'更新碎片'}
		    ],listeners:{'render':{fn:function(p){
			this.rmdList = p.body;
			this.rmdList.dom.className += ' blocks-container';
				p.body.dom.onclick = function(e){
					e = window.event || e;
					e = e.target||e.srcElement;
					var tn = e.tagName.toLowerCase();
					if(tn == 'a'){
						setCls(e, 'current', e.selected);
						e.selected = !e.selected;
					}else if(tn == 'b') this.removeChild(e.parentNode);
				}
				p.body.dom.ondblclick = function(e){
					e = window.event || e;
					e = e.target||e.srcElement;
					var tn = e.tagName.toLowerCase();
					if(tn == 'a') this.removeChild(e);
				}
			},scope:this}}
		});*/
		if(this.modelid==1){
			 var systemItem = [this.systemField.body];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==2){
			var systemItem = [{xtype:'tabpanel',id:'tabpanel_content',style:'margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:false,items:[
				{title:this.systemField.images.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.images},
				{title:this.systemField.body.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.body}
			]}];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==4){
			var systemItem = [{xtype:'tabpanel',id:'tabpanel_content',style:'margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:true,items:[
				{title:this.systemField.videos.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.videos},
				{title:this.systemField.body.fieldLabel,autoWidth:true,autoHeight:true,items:this.systemField.body}
			]}];
			 systemItem = systemItem.concat(this.modelFields);
			 modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px',items:systemItem};
		}else if(this.modelid==3){
			this.systemField.images.title = this.systemField.images.fieldLabel;
			this.systemField.body.height = 200;
			this.systemField.body.disableOnResize = true;
			var systemItem= [{layout:'column',border:false,items:[
					{columnWidth:.5,layout:'form',defaults:{anchor:'-15'},border:false,items:[
						this.systemField.publishtype,
						this.systemField.downcategory,
						this.systemField.downtype,
						this.systemField.platform,
						this.systemField.publisher,
						this.systemField.publisherurl
					]},
					{columnWidth:.5,layout:'form',defaults:{anchor:'100%'},border:false,items:[
						this.systemField.version,
						this.systemField.copyright,
						this.systemField.language,
						this.systemField.level,
						this.systemField.email,
						this.systemField.demo
					]}
				]},
				{layout:'form',border:false,style:'margin-top:5px;border-top:1px dotted #99BBE8;padding-top:10px;',itemCls:'floatitem',collapsible:true,items:[
					this.systemField.downfilename,
					this.systemField.filesize,
					this.systemField.filetype
				]},
				this.systemField.urls,
				{xtype:'tabpanel',id:'tabpanel_content',style:'margin-top:10px;margin-bottom:10px',border:false,activeTab:1,autoHeight:true,cls:'excms-tabpanel excms-tabpanel-collapsible',collapsible:true,items:[
					{title:this.systemField.body.fieldLabel,autoHeight:true,items:this.systemField.body},
					{title:this.systemField.images.fieldLabel,autoHeight:true,items:this.systemField.images}
				]}
			];
			systemItem = systemItem.concat(this.modelFields);
			modelConfig = {region:'center',border:false,autoScroll:true,layout:'form',defaults:{anchor:'-24'},bodyStyle:'padding:10px 0 10px 10px;',labelWidth:60,items:systemItem};
		}else{
			var modelConfig = {region:'center',autoScroll:true,layout:'form',border:false,bodyStyle:'padding:10px 12px'};
			if(this.modelFields && typeof this.modelFields != 'string' && this.modelFields.length) modelConfig.items = this.modelFields;
			else modelConfig.html = '';
		}
		this.modelFieldsPanel = new Ext.Panel(modelConfig);
		this.thumbPanel = new Ext.Panel({layout:'form',border:false,html:'',listeners:{scope:this,'render':this.onRenderThumb}});
		this.recommend=new Ext.form.ComboMultiSelect({fieldLabel:'推荐',hiddenName:'recommend',anchor:'100%',multiSelect:true,valueField:'id',displayField:'name',triggerAction:'all',store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Category&A=Index&method=getdata'}),fields:['id','name'],baseParams:{categoryid:1},reader:new Ext.data.JsonReader({root:'data'},['id','name'])})});
		this.relatedContent=new Ext.form.TextArea({fieldLabel:'相关内容',xtype:'textarea',vtype:'commanum',vtypeText:"相关内容只允许输入数字或者逗号','", name:'likecontentid',height:50,maxLength:100,emptyText:'多个相关内容ID请用“,”隔开',maxLengthText:'长度必须小于100字符'});
		// form panel
		
		this.formPanel =  new Ext.FormPanel({id:this.editorid,layout:'border',title:this.title,border:false,closable:true,items:[
			{xtype:'hidden',name:'contentid'}, this.fields.channelid, this.fields.crossid, {xtype:'hidden',name:'lastchannelid'},
			this.fields.color, this.fields.bold, this.fields.italic, this.fields.underline,
			{xtype:'hidden',name:'thumb'}, {xtype:'hidden',name:'sort',value:'10'},
			{region:'center',layout:'border',border:false,items:[
				{region:'north',layout:'form',border:false,height:48,bodyStyle:'padding:12px 12px 0px;background:#FFF url(Themes/images/editor_top_bg.gif) repeat-x',labelWidth:60,items:[this.fields.title,this.fields.titlesetting]},
				this.modelFieldsPanel
			]},
			{region:'east',id:'formtabpanel',width:300,border:false,style:'border-left:1px solid #99BBE8',itemCls:'panel-body-transparent',xtype:'tabpanel',activeTab:1,items:[
				{title:'基本',autoScroll:true,layout:'form',bodyStyle:tabBodyStyle,labelWidth:44,defaults:{anchor:'-20'},items:[
					this.fields.channel,
					{fieldLabel:'关键字',xtype:'textarea',name:'keywords',height:40,emptyText:'多个关键字请用“,”逗号隔开,推荐5个以内(最好3个),总长度70字符(35个汉字)', maxLength:70, maxLengthText:'关键字长度必须小于70个字符(35个汉字)'},
					{xtype:'textfield',fieldLabel:'标签',name:'tags',emptyText:'多个标签用“,”或“;”分开',value:'',maxLength:70,maxLengthText:'长度必须小于70字符(35个汉字)'},
					{fieldLabel:'摘要',xtype:'textarea',name:'description',height:80, maxLength:255,emptyText:'摘要长度必须小于250个字符(125个汉字)，推荐150个字符(75个汉字)',maxLengthText:'摘要长度必须小于250个字符(125个汉字)'},
					this.thumbPanel,
					this.fields.source,
					this.fields.author,
					{fieldLabel:'编辑',xtype:'textfield',name:'editor',emptyText:'责任编辑',maxLength:20},
					{layout:'form',border:false,bodyStyle:eastBdStyle,items:[
						{fieldLabel:'状态',xtype:'radiogroup',width:150,items:[
							{boxLabel:'发布',name:'status',inputValue:1,checked:true},
							{boxLabel:'送审',name:'status',inputValue:0},
							{boxLabel:'草稿',name:'status',inputValue:-1}
						]},
						{fieldLabel:'发布',xtype:'datetimefield',name:'publishdate',anchor:'100%'},
						this.recommend,
						{fieldLabel:'选项',xtype:'checkbox',boxLabel:'生成HTML',name:'ishtml',checked:true,inputValue:1},
						this.fields.comment,
						{fieldLabel:'更新',xtype:'checkbox',boxLabel:'保存后更新首页、封面、列表页',name:'updatepage',checked:false,inputValue:1}
					]}
				]},
				/*
				{title:'相关及推荐',layout:'form',labelWidth:66,defaults:{anchor:'-18'},bodyStyle:tabBodyStyle,autoScroll:true,items:[
                     {xtype:'trigger',fieldLabel:'相关关键字',name:'likekeywords',triggerClass:'x-form-search-trigger',emptyText:'多个关键字请用“,”或“;”隔开',value:'',maxLength:40,maxLengthText:'长度必须小于40个字符(20wh 汉字)'},
                     {xtype:'tabpanel',style:'margin-bottom:8px',height:220,activeTab:0,items:[
                          {title:'相关文章',html:'',tbar:[{text:'添加',handler:this.contentIdSelect,scope:this},{text:'删除'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]},
                          {title:'相关图片',html:'',tbar:[{text:'添加',handler:this.contentIdSelect,scope:this},{text:'删除'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]},
                          {title:'相关视频',html:'',tbar:[{text:'添加',handler:this.contentIdSelect,scope:this},{text:'删除'},'->',{xtype:'trigger',width:100,triggerClass:'x-form-search-trigger'}]}
                     ]},
                     this.recommendPanel
				]},*/
				{title:'高级',bodyStyle:tabBodyStyle,layout:'form',autoScroll:true,labelWidth:58,defaults:{anchor:'-18'},items:[
					{fieldLabel:'转向链接',xtype:'checkbox',boxLabel:'使用转向链接',name:'isforward',inputValue:1,listeners:{check:function(c,n){this.setForward(n)},scope:this}},	
					this.fields.forward,
					{layout:'form',border:false,bodyStyle:eastBdStyle,labelAlign:'top',defaults:{anchor:'100%'},items:[
						{fieldLabel:'简短标题',xtype:'textfield',name:'shorttitle',cls:'editor-title',emptyText:'简短标题为空时等于标题',maxLength:40,maxLengthText:'长度必须小于40个字符(20个汉字)'},
						{fieldLabel:'Mate标题',xtype:'textfield',name:'metatitle',cls:'editor-title',emptyText:'Mate标题为空时等于标题',maxLength:100,maxLengthText:'长度必须小于100个字符(50个汉字)'},
						{xtype:'textfield',fieldLabel:'相关关键字',name:'likekeywords',emptyText:'多个关键字请用“,”或“;”隔开',value:'',maxLength:40,maxLengthText:'长度必须小于40个字符(20wh 汉字)'},
						this.relatedContent,
						{xtype:'label',layout:'column',border:false,html:'',style:'padding-bottom:6px',listeners:{render: function(c){
							var b = document.createElement('input');
							b.type = 'button';
							b.value = '选择';
							b.onclick = function(){
								this.contentIdSelect();
							}.createDelegate(this);
							c.el.dom.appendChild(b);
						},scope:this}}
					]},
					{xtype:'fieldset',title:'自定义内容模板、文件名',autoHeight:true,labelWidth:45,defaults:{anchor:'100%'},bodyStyle:eastBdStyle,items:[
						this.fields.templet,
						{fieldLabel:'文件名',xtype:'textfield',name:'filename',value:''},
						{xtype:'label',text:'如：myfilename.html',style:labelStyle}
					]}
				]}
			]}],
			tbar:[
				{text:'保存',iconCls:'btnico btn_save',handler:this.submit,scope:this},
				{text:'预览',iconCls:'btnico btn_preview',handler:this.preview,scope:this},
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.reload()},hidden:true,scope:this},
				{text:'取消',iconCls:'btnico btn_cancel',handler:function(){this.cancel()},scope:this}
			],
			listeners:{
				scope:this,
				'actionfailed':function(f,a){this.unmask()},
				'actioncomplete':function(form,action){
					this.unmask();
					if(action.result.success){
						var contentid = action.result.contentid;
						this.updatepage(contentid);	
						var ok='浏览'
						var values = this.formPanel.form.getValues();
							if(values.status == 1){
								ok = '浏览';
							}else{
								ok='预览';
						}
						Ext.MessageBox.show({
							title:'内容保存成功',
							width:360,
							msg: '继续编辑本内容请点击“继续编辑”按钮；<br>新建内容请点击“新建”按钮，否则请取消。<br>'+(action.result.message||'')+'<br>',
							buttons:{'yes':'新建','no':'继续编辑','cancel':'取消','ok':ok},
							fn: function(b){
								if(b == 'cancel'){
									this.cancel();
								}else if(b == 'no'){
								}else if(b == 'yes'){
									var channelid = this.fields.channelid.getValue();
									var channel = this.fields.channel.getValue();
									
									this.formPanel.form.reset();
									this.fields.channelid.setValue(channelid);
									this.fields.channel.setValue(channel);
									this.setThumb();
								}else if(b == 'ok'){
									if(Ext.Msg.buttonText.ok=='浏览'){
										if(this.contentid < contentid) this.contentid = contentid;
										this.browse(this);	
									}else{
										this.preview();
									}
									this.cancel();
								}
							},
							scope:this
						});

					}
				}
			}
		});
		this.formPanel.content = this;
		if(this.container){
			this.container.add(this.formPanel);
			this.container.activate(this.formPanel);
		}else{
			this.formPanel.region = 'center';
			new Ext.Viewport({layout:'border',items:this.formPanel});
		}
		this.ftp = this.formPanel.getComponent('formtabpanel');
		this.ftp.activate(0);
		if (this.channelid) {
			this.fields.channelid.setValue(this.channelid);
			this.fields.channel.setValue(this.channelname);
		}
		if(this.modelid==2 || this.modelid==3 || this.modelid==4){
			var p = this.formPanel.findById('tabpanel_content');
			p.activate(0);
			p.doLayout();
		}
		this.isRendered = true;
		if(this.contentid) {
			this.hideBtn(false);
			this.setValue();
		}
	},
	//保存后更新首页、封面、列表页
	updatepage:function(contentid){
		var values = this.formPanel.form.getValues();
		var contentid = values.contentid != '' ? values.contentid : contentid;
		if(values.updatepage == 1) var info = 1;
			if(values.updatepage || values.ishtml){
				Ext.Ajax.request({
				url:this.baseAction+'&method=updatepage',method:'POST',params:{contentid:contentid,channelid:values.channelid,ishtml:values.ishtml,status:values.status,info:info}, 
				failure:function(){},
				success:function(){
					 this.store.reload();
					 if(values.updatepage == 1) EXCMS.msg('提示','更新首页、封面、列表页成功');  
				},
				scope:this
				});	
			}
	},
	// title setting initial
	onRenderTitle:function(c){
		var tthis=this;
		this.ti = c.el.dom.getElementsByTagName('a');
		this.ti[0].setValue=function(){
			var l = tthis.fields.title.getValue().byteLength();
			var color = l > tthis.titleMaxLength ? 'red' : 'green';
			this.innerHTML = '<font color="'+color+'">'+l+'</font>/<font color="red">'+tthis.titleMaxLength+'</font>';
		}
		this.ti[0].setValue();
		this.ti[1].onclick=function(){tthis.checkTitle()}
		this.ti[2].valueCls='title_bold_click';
		this.ti[2].field = this.fields.bold;
		this.fields.bold.viewEl = this.ti[2];
		this.ti[3].valueCls='title_italic_click';
		this.ti[3].field = this.fields.italic;
		this.fields.italic.viewEl = this.ti[3];
		this.ti[4].valueCls='title_underline_click';
		this.ti[4].field = this.fields.underline;
		this.fields.underline.viewEl = this.ti[4];
		this.ti[2].onclick=this.ti[3].onclick=this.ti[4].onclick=function(){var v=this.field.getValue()=='1'?'':1;this.field.setValue(v);this.setView(v)}
		this.ti[2].setView=this.ti[3].setView=this.ti[4].setView=function(v){setCls(this,this.valueCls,!v)}
		this.colorButton = this.ti[5];
		this.colorButton.onclick = function(){
			if(!tthis.colorMenu){
				tthis.colorMenu = new Ext.menu.ColorMenu();
				tthis.colorMenu.on('select',function(cm,color){tthis.setColorValue('#'+color)});
				tthis.colorMenu.on('show',function(){setCls(tthis.colorButton,'title_color_click')});
				tthis.colorMenu.on('hide',function(){setCls(tthis.colorButton,'title_color_click',1)});
			}
			tthis.colorMenu.show(tthis.colorButton);
		}
	},
	setTitle:function(T){document.title=T;this.title=T.ellipse(10);if(this.formPanel)this.formPanel.setTitle(this.title)},
	refreshTree:function(item){
		if(item.mode) {if(this.fields.channel.tree.root.loaded)this.fields.channel.tree.getLoader().load(this.fields.channel.tree.root);this.fields.channel.tree.root.expand();}
		else{if(this.selectedNode.loaded)this.fields.channel.tree.getLoader().load(this.selectedNode);this.selectedNode.expand();}
	},
	loadData:function(){
		if(this.isLoaded) return ;
		this.reload();
	},
	reload : function(){
		this.isLoaded = true;
		this.mask('正在加载内容数据, 请稍侯…');
		Ext.Ajax.request({
            url:this.baseAction+'&method=getById',method:'POST',params:{contentid:this.contentid},scope:this,
            failure:function(r,p){this.unmask()},  
            success:function(r,o){
                this.unmask();
				r=jsonReturn(r);
				if(r.success) this.setValue(r.data);
            }
        });
	},
	setValue:function(values){
		if(!this.isRendered){
			if (values) {
				this.values = values;
				if (!this.isLoadModel) {
					this.modelid = this.values.modelid;
					this.loadModel();
					//this.onRender();
				}
			}
			return ;
		}else if(!this.values){
			if(values) this.values = values;
			else return ;
		}
		this.setTitle(this.values.title);
		this.fields.channel.disable();
		this.setForward(this.values.j>0);
		this.setColorValue(this.values.color||'');
		if(!this.values.bold) this.values.bold = '';
		this.ti[2].setView(this.values.bold);
		if(!this.values.italic) this.values.italic = '';
		this.ti[3].setView(this.values.italic);
		if(!this.values.underline) this.values.underline = '';
		this.ti[4].setView(this.values.underline);
		this.values.ispagination = 1;
		this.formPanel.form.setValues(this.values);
		if(this.values.thumb) this.setThumb(this.values.__thumb, true);
		this.ti[0].setValue();
	},
	setChannel:function(currentChannel){
		this.currentChannel = currentChannel;
		if(!currentChannel.channelid || currentChannel.channelid == '' || !currentChannel.text || currentChannel.text == ''){return ;}
		channelids = currentChannel.channelid.split('_');
		this.fields.channelid.setValue(channelids[0]);
		this.fields.channel.setValue(currentChannel.text.replace(/<[0-9a-zA-Z]{1,} .*<\/[0-9a-zA-Z]{1,}>/gm,""));
		this.fields.crossid.setValue(channelids[1]);
	},
	setForward:function(f){this.fields.forward.setDisabled(!f)},
	setColorValue:function(c){
		c = c ? c.trim() : '';
		this.fields.color.setValue(c == '#D6D6D6' || c == '' ? '' : c);
		this.colorButton.style.backgroundColor = c;
	},
	onRenderThumb:function(){
		this.thumbPanel.body.dom.innerHTML = '<div class="thumbselector"><em>缩略图：</em><div class="thumbct"></div><div class="uploadtext"><a href="javascript:void(0);" class="thumb-res"  onmouseout="setCls(this,\'thumb-res-click\',1)" onmouseup="setCls(this,\'thumb-res-click\',1)" onmousedown="setCls(this,\'thumb-res-click\')" title="从资源中选择缩略图"></a><a href="javascript:void(0);" class="thumb-up"  onmouseout="setCls(this,\'thumb-up-click\',1)" onmouseup="setCls(this,\'thumb-up-click\',1)" onmousedown="setCls(this,\'thumb-up-click\')" title="上传缩略图"></a><a href="javascript:void(0);" class="thumb-url" onmouseout="setCls(this,\'thumb-url-click\',1)" onmouseup="setCls(this,\'thumb-url-click\',1)" onmousedown="setCls(this,\'thumb-url-click\')" title="指定网上图片做为缩略图"></a><a href="javascript:void(0);" class="thumb-del" onmouseout="setCls(this,\'thumb-del-click\',1)" onmouseup="setCls(this,\'thumb-del-click\',1)" onmousedown="setCls(this,\'thumb-del-click\')" title="清空缩略图"></a></div></div>';
		var a = this.thumbPanel.body.child('div.uploadtext',true).getElementsByTagName('a');
		var tthis = this;
		a[0].onclick = function(){tthis.addResourceImg({imgfor:'thumb'})}
		a[1].onclick = function(){tthis.imageSelect({single:true,local:true,imgfor:'thumb'})}
		a[2].onclick = function(){tthis.imageSelect({single:true,url:true,imgfor:'thumb'})}
		a[3].onclick = function(){tthis.setThumb()}
		this.thumbct = this.thumbPanel.body.child("div.thumbct", true);
	},
	//预览内容
	preview : function(){
		if(!this.formPanel.form.isValid()){alert("表单中有错误，请检查红线处的错误提示");return ;}
		EXCMS.util.RequestUrl(this.baseAction + '&method=preview',{modelid:this.modelid,data:Ext.urlEncode(this.formPanel.form.getValues())},'POST');
	},
	browse:function(item){
		var contentid = item.contentid; 
		if(contentid)EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'content',id:contentid});
	},
	previewThumb:function(){
		if(this.thumbct.childNodes[0]) EXCMS.util.RequestUrl(this.thumbct.childNodes[0].src);
	},
	checkTitle:function(){
		var value = this.fields.title.getValue().trim();
		if(!value){EXCMS.msg('提示', '请输入文章标题');return;}
		Ext.Ajax.request({url:this.baseAction+'&method=checktitle',method:'POST',scope:this,params:{title:value,contentid:this.contentid},
			success:function(r,o){
				r = jsonReturn(r);
				var m = '';
				if(r.success){m= r.url ? "已存在标题为<a href='"+r.url+"' target='_blank'>"+value+"</a>的内容！" : '标题不存在！';}
				else{m = r.message}
				EXCMS.msg('提示', m);
			}
		})
	},
	// add resource img
	addResourceImg:function(item){
		var postfix = 'thumb', single = true;
		var channelid = this.fields.channelid.getValue();
		EXCMS.util.QuickCreate({model:'Resource.Browse', callback:this.resourceCallback.createDelegate(this), top:true, type:'image', single:single, postfix:postfix, channelid:channelid});
	},
	// callback
	resourceCallback : function(r){this.setThumb(r)},
	// image Select
	imageSelect : function(item){
		item.callback = this.resourceCallback.createDelegate(this);
		item.model = 'Resource.ImageSelector';
		item.top = true;
		item.postfix = 'thumb'; 
		item.single = true;
		item.channelid = this.fields.channelid.getValue();
		item.nid = 0;
		EXCMS.util.QuickCreate(item);
	},
	// set content thumb
	setThumb : function(resource, is_loaddata){
		if(!this.thumbct.img){
			this.thumbct.tip = document.createElement('span');
			this.thumbct.img = document.createElement('img');
			this.thumbct.img.title = '双击预览图片';
			this.thumbct.img.ondblclick = function(){EXCMS.Previewer.image(this.src)}
			this.thumbct.img.onload = function(){this.parentNode.tip.style.display='none';this.style.display='block';resizeImage(this, 120, 90);}
			this.thumbct.img.onerror = function(){this.parentNode.tip.innerHTML = '图片无法显示'}
			this.thumbct.appendChild(this.thumbct.tip);
			this.thumbct.appendChild(this.thumbct.img);
		}
		var flag = false, src;
		if(resource){
			if(resource.resource){
				src = resource.src, resource =  resource.resource, flag = true;
			}else if(resource.src){
				src = resource.src, resource = resource.src, flag = true;
			}else if(is_loaddata){
				src = resource, flag = true;
			}
		}else{
			resource = '';
		}
		if(!is_loaddata) this.formPanel.form.findField('thumb').setValue(resource);
		if(flag){
			this.thumbct.tip.innerHTML = '图片加载中...';
			this.thumbct.className = 'thumbct thumbloaded';
			this.thumbct.tip.style.display = 'block';
		}else{
			this.thumbct.className = 'thumbct';
			this.thumbct.tip.style.display = this.thumbct.img.style.display = 'none';
		}
		if(src) this.thumbct.img.src = src;
	},
	submit:function(){
		if(!this.formPanel.form.isValid()){alert("表单中有错误，请检查红线处的错误提示");return ;}
		this.mask('正在保存, 请稍侯...');
	    this.formPanel.form.submit({url:this.baseAction + (this.contentid==''?'&method=insert&ajax=true':'&method=update&ajax=true'),timeout:120000});
	},
	// 推荐及碎片
	addRmd:function(V){
		var eid = 'rmd-' + V.cate + '-' + V.id;
		if(this.rmdList.child('a#'+eid)) return ;
		var A = document.createElement('a');
		A.innerHTML = V.name + '<b title="删除"></b>';
		this.rmdList.dom.appendChild(A);
		A.className = V.cate == 'block' ? 'push2block' : 'push2rmd';
		A.id = eid, A.Value = V, A.href = 'javascript:;'
	},
	removeRmd:function(id,type){
		if(id && id.type && id.type == 'selected'){
			var c = this.rmdList.dom.childNodes, len=c.length, f;
			for(var i=0;i<len;i++){
				if(c[i].selected){
					this.rmdList.dom.removeChild(c[i]), f = true;
				}
			}
			if(len && !f) alert('请选择您要删除的推荐类型');
		}else{
			var eid = 'rmd-' + type + '-' + id;
			eid = this.rmdList.child('a#'+eid);
			if(eid) eid.remove();
		}
	},
	selectRmd:function(){EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.RecommendSelector',callback:this.conCallBack.createDelegate(this)})},
	conCallBack:function(D){if(D) for(var i=0,len=D.length;i<len;i++) this.addRmd(D[i])},
	contentIdSelect : function(item){
		EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.ContentSelect',callback:this.contentIdSelectCallback.createDelegate(this)});
	},
	contentIdSelectCallback:function(data){
		var len = data.length,i,id;
		if(len){
			var ids = this.relatedContent.getValue().split(',');
			if(ids[0] == '') ids = [];
			for(i=0;i<len;i++){
				id = data[i].get('contentid');
				if(ids.indexOf(id) < 0) ids.push(id);
			}
			this.relatedContent.setValue(ids.join(','));
		}
	},
	cancel:function(){
		if(this.container){
			this.container.remove(this.formPanel);
		}else{
			if(confirm('确定要退出内容编辑吗？'))history.go(-1);
		}
	},
	hideBtn:function(F){this.formPanel.topToolbar.items.items[2].setVisible(!F)},
	mask:function(m){
		if(this.container) this.container.body.mask(m);
		else{Ext.getBody().mask(m);}
	},
	unmask:function(){
		if(this.container) this.container.body.unmask();
		else Ext.getBody().unmask();
	}
};
try{
	if(typeof EXCMS_HTML_EDITOR_NAME=='undefined') EXCMS_HTML_EDITOR_NAME = 'kindeditor';
	switch(EXCMS_HTML_EDITOR_NAME){
		case 'fckeditor': EXCMS_HTML_EDITOR = Ext.ux.FCKeditor;break;
		case 'sinaeditor': EXCMS_HTML_EDITOR = Ext.ux.SinaEditor;break;
		case 'kindeditor':
		default: 
			EXCMS_HTML_EDITOR_NAME = 'kindeditor';
			EXCMS_HTML_EDITOR = Ext.ux.KindEditor;
		break;
	}
}catch(e){
	EXCMS_HTML_EDITOR_NAME = 'kindeditor';
	EXCMS_HTML_EDITOR = Ext.ux.KindEditor;
}
Ext.form.ArticleEditor = Ext
		.extend(
				EXCMS_HTML_EDITOR,
				{
					height : 400,
					border : false,
					hideLabel : true,
					deletelink : true,
					remotedownload : true,
					enableSourceEdit : true,
					itemCls : 'nobdhtmleditor',
					editorname : EXCMS_HTML_EDITOR_NAME,
					displaypage : false,
					initComponent : function() {
						this.readOnly = this.readOnly || !this.allowRemote;
						Ext.form.ArticleEditor.superclass.initComponent
								.call(this);
						this.addEvents("setThumb")
					},
					onRender : function(C, A) {
						Ext.form.ArticleEditor.superclass.onRender.call(this,
								C, A);
						this.wrap = Ext.get(this.el.dom.parentNode);
						this.wrap.createChild( {
							id : 'article_addon' + this.name,
							tag : 'div',
							cls : '',
							style : 'margin-bottom:4px'
						});
						this.thumbConfig = new Ext.form.Hidden( {
							name : 'thumbConfig_' + this.name
						});
						this.imgConfig = new Ext.form.Hidden( {
							name : 'imgConfig_' + this.name
						});
						this.deletelink_box = this.remotedownload_box = [{
							hidden : true
						}];
						if (this.deletelink == 'true'
								|| this.deletelink == true) {
							this.deletelink_box.push(new Ext.form.Checkbox( {
								hidden : false,
								width : 115,
								boxLabel : '删除非站内链接',
								name : 'deletelink_' + this.name,
								inputValue : 1
							}));
						}
						if (this.remotedownload == 'true'
								|| this.remotedownload == true) {
							this.remotedownload_box = [{
								hidden : false,
								xtype : 'checkbox',
								width : 135,
								boxLabel : '下载远程图片和资源',
								name : 'remotedownload_' + this.name,
								inputValue : 1
							},{
								xtype : 'checkbox',
								boxLabel : '提取内容第 ',
								name : 'distillphoto_' + this.name,
								inputValue : 1
							},
							{
								xtype : 'numberfield',
								name : 'whichpic_' + this.name,
								value : 1,
								width : 30,
								style : 'margin-left:4px'
							},
							{
								xtype : 'label',
								id : 'thumbsettinglabel' + this.name,
								listeners : {
									'render' : function(
											e) {
										e.el.dom.style.cssText += ';float:left;clear:none;'
									}
								},
								style : 'padding-left:6px;margin-top:-2px;line-height:18px;'
							}];
						}
						var rowdata = this.deletelink_box.concat(this.remotedownload_box);
						var bodyStyle = '';
						if (this.displaypage == 'true'
								|| this.displaypage == true)
							bodyStyle = 'border-bottom:none;';
						this.bodyPanel = new Ext.Panel(
								{
									renderTo : this.wrap.dom.lastChild,
									layout : 'form',
									border : false,
									autoWidth : true,
									items : [
											this.thumbConfig,
											this.imgConfig,
											{
												layout : 'column',
												border : false,
												cls : 'article-body-setting ' + this.editorname + '-addon',
												bodyStyle : bodyStyle + 'padding:4px 10px;',
												items : rowdata
											} ]
								});
						if(this.remotedownload == 'true' || this.remotedownload == true){
							var thumb_image = Ext.getDom('thumbsettinglabel' + this.name);
							thumb_image.innerHTML = '作为缩略图&nbsp;&nbsp;';
							var a = document.createElement('a');
							a.currentObj = this;
							a.href = 'javascript:void(0);';
							a.onclick = function() {
								this.currentObj.bodySetting()
							};
							a.innerHTML = '图片设置';
							thumb_image.appendChild(a);
						}
						if (this.displaypage == 'true'
								|| this.displaypage == true) {
							this.bodyPanel
									.add( {
										layout : 'column',
										border : false,
										cls : 'article-body-setting ' + this.editorname + '-addon',
										style : 'margin-bottom:6px',
										bodyStyle : 'padding:4px 10px;',
										items : [
												{
													xtype : 'label',
													width : 46,
													text : '分页：',
													style : 'margin-top:-3px;line-height:18px;'
												},
												{
													xtype : 'radio',
													width : 65,
													boxLabel : '不分页 ',
													name : 'ispagination_' + this.name,
													inputValue : 0
												},
												{
													xtype : 'radio',
													width : 78,
													boxLabel : '手动分页 ',
													name : 'ispagination_' + this.name,
													inputValue : 1
												},
												{
													xtype : 'radio',
													boxLabel : '自动分页，每页约 ',
													name : 'ispagination_' + this.name,
													inputValue : 2
												},
												{
													xtype : 'numberfield',
													name : 'paginationsize_' + this.name,
													value : 1000,
													width : 50,
													style : 'margin-left:4px'
												},
												{
													xtype : 'label',
													text : '字符(不包含html，一个汉字代表2个字符)',
													listeners : {
														'render' : function(e) {
															e.el.dom.style.cssText += ';float:none;clear:none;'
														}
													},
													style : 'padding-left:6px;margin-top:-2px;line-height:18px;'
												} ]
									});
							this.bodyPanel.doLayout()
						}
						if (this.editorname == 'fckeditor'
								|| this.editorname == 'sinaeditor') {
							var span = document.createElement('span');
							span.className = 'fckeditorheight';
							var augment = document.createElement('a');
							augment.currentObj = this;
							augment.href = 'javascript:void(0);';
							augment.onclick = function() {
								this.currentObj.setFckeditorHeight(1)
							};
							augment.innerHTML = '增大';
							span.appendChild(augment);
							var reduction = document.createElement('a');
							reduction.currentObj = this;
							reduction.href = 'javascript:void(0);';
							reduction.onclick = function() {
								this.currentObj.setFckeditorHeight()
							};
							reduction.innerHTML = '减小';
							span.appendChild(reduction);
							Ext.getDom('thumbsettinglabel' + this.name).parentNode
									.appendChild(span)
						}
					},
					setValue : function(C) {
						if (C == null)
							C = '';
						Ext.form.ArticleEditor.superclass.setValue
								.call(this, C);
						this.thumbConfig.setValue('');
						this.imgConfig.setValue('');
						var length = this.bodyPanel.items.items[2].items.length;
						for ( var i = 0; i < length; i++) {
							if (typeof this.bodyPanel.items.items[2].items.items[i].reset == 'function') {
								this.bodyPanel.items.items[2].items.items[i]
										.reset()
							}
						}
						if (this.bodyPanel.items.items[3]) {
							var length = this.bodyPanel.items.items[3].items.length;
							for ( var i = 0; i < length; i++) {
								if (typeof this.bodyPanel.items.items[3].items.items[i].reset == 'function') {
									this.bodyPanel.items.items[3].items.items[i]
											.reset()
								}
							}
						}
					},
					bodySetting : function() {
						this.content = this.getContentid();
						if (!this.bodySettingWin) {
							this.bodySettingWin = new Ext.Window(
									{
										title : '图片设置',
										modal : true,
										cls : 'imgsettingwin',
										resizable : false,
										width : 560,
										height : 405,
										closeAction : 'hide',
										bodyStyle : 'background:#FFFFFF;padding:15px',
										autoScroll : true,
										buttons : [
												{
													text : '确定',
													handler : function() {
														var values = {};
														if (this.bodyThumbItems.items)
															values.thumbConfig = this.bodyThumbItems.items;
														if (this.bodyImgItems.items)
															values.imgConfig = this.bodyImgItems.items;
														this.thumbConfig
																.setValue(Ext
																		.encode(values.thumbConfig));
														this.imgConfig
																.setValue(Ext
																		.encode(values.imgConfig));
														this
																.fireEvent(
																		"setThumb",
																		this,
																		Ext
																				.encode(values.thumbConfig),
																		Ext
																				.encode(values.imgConfig));
														this.bodySettingWin
																.hide()
													},
													scope : this
												},
												{
													text : '取消',
													handler : function() {
														this.bodySettingWin
																.hide()
													},
													scope : this
												} ]
									});
							this.bodySettingWin.show();
							var thumb_array = new Array('缩略图设置', '图片设置');
							for ( var i = 0; i < 2; i++) {
								var p = document.createElement('p');
								p.className = 'bar';
								p.innerHTML = thumb_array[i];
								var input = document.createElement('input');
								input.type = 'button';
								input.value = '添加设置';
								input.currentObj = this;
								input.indexB = i;
								input.onclick = function() {
									if (this.indexB == 1)
										this.currentObj.bodyImgSetting();
									else
										this.currentObj.bodyImgSetting(1)
								};
								p.appendChild(input);
								this.bodySettingWin.body.appendChild(p);
								var thumb = document.createElement('div');
								thumb.className = "st-thumb-items";
								this.bodySettingWin.body.appendChild(thumb)
							}
							var div = this.bodySettingWin.body.dom
									.getElementsByTagName('div');
							this.bodyThumbItems = div[0];
							this.bodyImgItems = div[1];
							this.bodySettingWin.contenid = this.contentid
						} else {
							this.bodySettingWin.center();
							this.bodySettingWin.show();
							if (this.contentid
									&& this.contentid == this.bodySettingWin.contenid) {
							} else {
								this.bodySettingWin.contenid = this.contentid;
								this.bodyThumbItems.items = null;
								this.bodyThumbItems.innerHTML = '';
								this.bodyImgItems.items = null;
								this.bodyImgItems.innerHTML = ''
							}
						}
						var config = '{"o":{"zoom":"4","wmtype":"0"}}';
						EXCMS.util.QuickCreate( {
							model : 'Resource.image',
							action : 'render',
							thumbItems : this.bodyImgItems,
							disablekey : 'o',
							config : config
						})
					},
					bodyImgSetting : function(w) {
						EXCMS.util.QuickCreate( {
							model : 'Resource.image',
							thumbItems : w ? this.bodyThumbItems
									: this.bodyImgItems
						})
					},
					setFckeditorHeight : function(f) {
						if (this.editorname == 'sinaeditor') {
							this.setSinaEditorHeight(f)
						} else {
							if (!this.fckeditor) {
								this.fckeditor = this.wrap.dom
										.getElementsByTagName('iframe')[0];
								this.fckeditor.oHeight = this.fckeditor.offsetHeight - 200
							}
							var h = this.fckeditor.offsetHeight
									+ (f ? 100 : -100);
							if (h < this.fckeditor.oHeight)
								return;
							this.fckeditor.style.height = h + 'px'
						}
					},
					getContentid : function() {
						var contentid = typeof window.top.EXCMS.getContentId == 'function' ? window.top.EXCMS
								.getContentId()
								: 0;
						if (this.contentid != contentid) {
							this.contentid = contentid
						}
						return this.contentid
					},
					setContentid : function(contentid) {
						this.contentid = contentid
					}
				});
Ext.reg('articleeditor',Ext.form.ArticleEditor);
Ext.form.ImageEditor=Ext.extend(Ext.form.Field,{hidden:true,border:true,channelid:'',height:150,emptyText:null,labelStyle:'padding-top:20px;',emptyClass:"x-form-empty-field",initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.ImageEditor.superclass.initComponent.call(this);this.addEvents("setThumb")},onRender:function(C,A){Ext.form.ImageEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';if(this.width>0)this.width=Math.max(this.width,550);if(this.height>0)this.height=Math.max(this.height,200);this.loadDataView()},loadDataView:function(){this.toolbar=new Ext.Toolbar({items:[{text:'上传',iconCls:'',handler:this.imageSelect,scope:this,local:true,imgfor:'bodyimages'},{text:'添加资源图片',iconCls:'',handler:this.addResourceImg,scope:this,imgfor:'bodyimages'},{text:'添加网上图片',iconCls:'',handler:this.imageSelect,scope:this,url:true,imgfor:'bodyimages'},'-',{text:'设为缩略图',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'编辑图片',iconCls:'',handler:this.editDesc,scope:this},{text:'删除',iconCls:'',handler:this.deleteImage,scope:this}]});var thumbTemplate=new Ext.XTemplate('<tpl for=".">','<div class="rv-wrap" id="{name}" title="{description}"><div class="rv-wrap-ct"><em class="x-infoeditable" title="编辑"></em>','<div class="thumb"><div><p><strong>图片加载中...</strong><img src="{src}" onload="imageOnLoad(this)" onerror="imageOnError(this)" style="display:none"></p></div></div>','<span title="{name}">{name}</span>','</div></div>','</tpl>','<div class="x-clear"></div>');thumbTemplate.compile();this.store=new Ext.data.JsonStore({fields:['name','src','resource','description',{name:'sort',type:'int'}],sortInfo:{field:'sort',direction:'ASC'},listeners:{'load':{fn:function(){this.view.select(0)},scope:this,single:true}}});this.dataview=new Ext.DataView({cls:'rs-view',tpl:thumbTemplate,overClass:'x-view-over',itemSelector:'div.rv-wrap',store:this.store,autoScroll:true,multiSelect:true,autoWidth:true,autoHeight:true,plugins:[new Ext.DataView.DragSelector(),new Ext.DataView.imgEditInfo('图片')],listeners:{scope:this,'dblclick':function(v,i,n,e){this.dataview.plugins[1].onMouseDown(null,Ext.get(n).child('span',true))},'contextmenu':function(o,i,n,e){if(!o.isSelected(i))o.select(i);this.dataview.selectedIndex=i;var f=this.store.getAt(i).get('resource')?false:true;this.viewMenu.items.items[1].setDisabled(f);this.viewMenu.items.items[2].setDisabled(f);this.viewMenu.showAt(e.getXY())},'beforeselect':function(v){return v.store.getRange().length>0}}});this.viewPanel=new Ext.Panel({renderTo:this.wrap.dom.firstChild,border:this.border,layout:'card',autoScroll:true,width:this.width,height:this.height,autoWidth:this.autoHeight,autoHeight:this.autoHeight,anchor:this.anchor,activeItem:0,bodyStyle:'background:#FCFCFC;',items:this.dataview,tbar:this.toolbar});this.viewMenu=new Ext.menu.Menu({items:[{text:'预览',handler:this.previewImage,scope:this},{text:'预览中等图',handler:this.previewImage,scope:this,mode:1},{text:'预览原图',handler:this.previewImage,scope:this,mode:2},'-',{text:'上传图片',handler:function(){this.imageSelect({local:true,imgfor:'bodyimages'})},scope:this},{text:'添加资源图片',handler:function(){this.addResourceImg({imgfor:'bodyimages'})},scope:this,mode:1},{text:'添加网上图片',handler:function(){this.imageSelect({url:true,imgfor:'bodyimages'})},scope:this},'-',{text:'设为缩略图',handler:this.setAsThumb,scope:this},{text:'编辑图片',handler:function(){var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},scope:this},{text:'删除',handler:this.deleteImage,scope:this}]});this.dataview.getEl().dom.oncontextmenu=function(){return false}},previewImage:function(item){var image=this.store.getAt(this.dataview.selectedIndex).data;var src=image.src;if(!src){alert('无法预览');return}var m=item&&item.mode?item.mode:0;switch(m){case 1:m='_m';break;case 2:m='_o';break}if(m!=0&&image.resource){var idx=src.lastIndexOf('.');if(src.substr(idx-2,1)=='_'){src=src.substr(0,idx-2)+m+src.substr(idx)}else{src=src.substr(0,idx)+m+src.substr(idx)}}EXCMS.Previewer.image(src)},imageSelect:function(item){item.callback=this.resourceCallback.createDelegate(this);item.model='Resource.ImageSelector';item.top=true;item.postfix='thumb';item.channelid=this.getChannelid();item.nid=0;EXCMS.util.QuickCreate(item)},addResourceImg:function(item){var postfix='thumb',single=false;var channelid=this.getChannelid();EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.resourceCallback.createDelegate(this),top:true,type:'image',single:single,postfix:postfix,channelid:channelid})},getChannelid:function(){var channelid=typeof window.top.EXCMS.getChannelId=='function'?window.top.EXCMS.getChannelId():0;if(this.channelid!=channelid){this.channelid=channelid}return this.channelid},setChannelid:function(channelid){this.channelid=channelid},setAsThumb:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("请选择一张要设为缩略图的图片");return}var r=this.dataview.getSelectedRecords();if(typeof r[0].data.resource=='undefined'){r[0].data.resource=r[0].data.url}this.fireEvent("setThumb",this,r[0].data)},deleteImage:function(){var r=this.dataview.getSelectedRecords();if(r.length==0){alert('请先选择要删除的图片');return}for(var i=0;i<r.length;i++){this.store.remove(r[i])}this.store.sort('sort','ASC')},editDesc:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("请选择要编辑的图片");return}var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},resourceCallback:function(r){for(var i=0,len=r.length;i<len;i++){if(r[i].rid){if(!this.store.getById(r[i].rid)){this.store.add(new Ext.data.Record({name:r[i].filename,src:r[i].src,resource:r[i].resource,description:r[i].description,sort:100},r[i].rid))}}else if(r[i].src){this.store.add(new Ext.data.Record({name:'',src:r[i].src,description:r[i].description,sort:100}))}}this.store.sort('sort','ASC')},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}if(this.emptyText&&this.el&&C!==undefined&&C!==null&&C!==""){this.el.removeClass(this.emptyClass)}Ext.form.ImageEditor.superclass.setValue.apply(this,C);if(typeof C=='object'||typeof C=='array'){if(this.store)this.store.removeAll();for(var i=0;i<C.length;i++){this.store.add(new Ext.data.Record({description:C[i].description,src:C[i].src,url:C[i].url,name:C[i].name,resource:C[i].resource,sort:C[i].sort}))}}this.setRawValue(Ext.encode(C))},applyEmptyText:function(){if(this.rendered&&this.emptyText&&this.getRawValue().length<1){this.setRawValue(this.emptyText);this.el.addClass(this.emptyClass)}},getRawValue:function(){var A=Ext.encode(this.getValue());this.setRawValue(A);if(A===this.emptyText){A=""}return A},reset:function(){Ext.form.ImageEditor.superclass.reset.call(this);this.applyEmptyText()},getValue:function(){var data=new Array;if(this.store){this.store.sort('sort','ASC');this.store.each(function(r){data.push(r.data)})}return data},getDataVide:function(){return this.dataview},getStore:function(){return this.store}});
Ext.reg('imageeditor',Ext.form.ImageEditor);
EXCMS_Content_DownloadMirror={};
EXCMS.setMirrorInfo=function(data){EXCMS_Content_DownloadMirror=data;};
EXCMS.getMirrorInfo=function(){if(typeof EXCMS_Content_DownloadMirror=='object'||typeof EXCMS_Content_DownloadMirror=='array'){return EXCMS_Content_DownloadMirror;}else{return Ext.decode(EXCMS_Content_DownloadMirror);}};
Ext.form.DownloadEditor=Ext.extend(Ext.form.Field,{border:false,hidden:true,CurrentR:[],DefaultG:[],DefaultR:[],MirrorG:[],fieldLabel:'',anchor:'-10',height:280,systemMirror:false,emptyText:null,emptyClass:"x-form-empty-field",plant:Ext.data.Record.create([{name:'name',type:'int'},'url',{name:'sort',type:'int'},'local']),mirrorAction:'index.php?M=Content&A=MirrorAction',initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.DownloadEditor.superclass.initComponent.call(this)},onRender:function(C,A){Ext.form.DownloadEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';this.MirrorG[this.name]=[];if(!isNaN(this.anchor)){this.width=parseInt(this.wrap.dom.scrollWidth)+parseInt(this.anchor)}if(this.width>0)this.width=this.width<550?550:this.width;if(this.height>0)this.height=this.height>200?this.height:200;this.downloadPanel=new Ext.TabPanel({renderTo:this.wrap.dom.firstChild,border:true,width:this.width,height:this.height,autoScroll:true,style:'margin-top:10px;',activeTab:0,cls:'excms-tabpanel-collapsible',collapsible:true});this.DefaultG=EXCMS.getMirrorInfo();if(typeof this.DefaultG=='object'&&this.systemMirror){this.loadMirrorCate()}else{this.MirrorG[this.name][this.name]=this.createDownloadGrid(this.name,this.fieldLabel);this.downloadPanel.add(this.MirrorG[this.name][this.name])}this.downloadPanel.activate(0)},createDownloadGrid:function(id,name){var D=new Ext.data.Store();var checkColumn=new Ext.grid.CheckColumn({header:'是否外部资源?',dataIndex:'local',width:100});var defaultColumn=new Ext.grid.CheckColumn({header:'默认下载地址?',dataIndex:'defaultdownload',width:100});var G=new Ext.grid.EditorGridPanel({categoryid:id,title:name,store:D,enableColumnMove:false,collapsible:false,animCollapse:false,sm:new Ext.grid.RowSelectionModel(),border:false,autoScroll:true,plugins:[checkColumn,defaultColumn],columns:[new Ext.grid.RowNumberer(),{header:"下载名称",width:150,sortable:false,dataIndex:'name',editor:new Ext.form.TextField({allowBlank:false,blankText:'下载名称不能为空'}),scope:this},{header:"下载地址",width:300,sortable:false,dataIndex:'url',editor:new Ext.form.TextField({validator:this.isUrl,invalidText:'URL格式不正确,请输入正确的URL地址,例http://www.excms.cn'}),scope:this},{header:"排序",width:58,align:'right',sortable:false,dataIndex:'sort',editor:new Ext.form.NumberField({minValue:0,maxValue:10000}),scope:this},checkColumn,defaultColumn],tbar:[{text:'添加',handler:this.urlAdd,scope:this},{text:'从下载地址库中添加',handler:this.MirrorManage,scope:this},{text:'编辑',handler:this.urlEdit,scope:this},{text:'删除',handler:this.urlMove,scope:this},'-',{text:'选择',menu:{items:[{text:'全选',handler:this.select,scope:this,mode:1},{text:'反选',handler:this.select,scope:this,mode:2},{text:'取消选择',handler:this.select,scope:this,mode:3}]}},'-',{text:'重置',iconCls:'btnico btn_fresh',handler:function(){this.loadMirrorDataStatus=false;this.loadMirrorData(id)},scope:this}]});G.on('rowclick',function(g,r){this.record=D.getAt(r);this.setDownloadToobar(this.record.data.id>0)},this);G.on('celldblclick',function(g,r,c,e){var falg=this.record.data.id>0&&c!=3;G.getColumnModel().setEditable(1,!falg);G.getColumnModel().setEditable(2,!falg)},this);return G},setDownloadToobar:function(flag){var g=this.downloadPanel.getActiveTab();flag?g.getTopToolbar().items.items[2].disable():g.getTopToolbar().items.items[2].enable()},urlAdd:function(){var g=this.downloadPanel.getActiveTab();var p=new this.plant({name:'本地下载',url:'',sort:100});g.stopEditing();g.getStore().insert(0,p);g.startEditing(0,1)},urlEdit:function(){var g=this.downloadPanel.getActiveTab();var idx=this.record?g.getStore().indexOf(this.record):-1;if(idx>-1){var falg=(typeof this.record.data.id!='undefined'&&this.record.data.id>0)?false:true;g.getColumnModel().setEditable(1,falg);g.getColumnModel().setEditable(2,falg);if(!falg)return;g.stopEditing();g.startEditing(idx,1)}else{alert('请选择要修改的记录')}},urlMove:function(){var g=this.downloadPanel.getActiveTab();var selected=g.getSelectionModel().getSelections();var length=selected.length;if(!(length>0)){alert('请选择要删除的下载地址');return}for(i=0;i<length;i++){g.getStore().remove(selected[i])}},loadMirrorData:function(cid){if(this.loadMirrorDataStatus){for(var i in this.CurrentR[this.name]){if(i=='remove'||i=='indexOf'){continue}if(!this.MirrorG[this.name][i]){this.MirrorG[this.name][i]=this.createDownloadGrid(i,'其他分类-'+i);this.downloadPanel.add(this.MirrorG[this.name][i])}var D=this.MirrorG[this.name][i].getStore();D.removeAll();D.add(this.CurrentR[this.name][i])}}else{if(cid){if(this.MirrorG[this.name][cid]){var D=this.MirrorG[this.name][cid].getStore();D.removeAll();if(this.CurrentR[this.name]!=''&&typeof this.CurrentR[this.name]=='object')D.add(this.CurrentR[this.name][cid])}}else{for(var i in this.DefaultG){if(i!='remove'&&i!='indexOf'){if(typeof(this.MirrorG[this.name][i])=='object'){var D=this.MirrorG[this.name][i].getStore();D.removeAll();D.add(this.DefaultR[i])}}}}}},MirrorManage:function(){if(!this.MirrorWin){this.tree=new Ext.tree.TreePanel({region:'west',split:true,width:150,minSize:100,border:false,style:'border-right:1px solid #99BBE8',bodyStyle:'padding-top:5px;',collapseMode:'mini',autoScroll:true,rootVisible:false,lines:false,useArrows:true,loader:new Ext.tree.TreeLoader({dataUrl:this.mirrorAction+'&method=tree'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'下载分类',expanded:true}),tbar:[{text:'新建',handler:this.mirroredit,scope:this,mode:0},{text:'编辑',handler:this.mirroredit,scope:this,mode:1},{text:'删除',handler:this.delmirror,scope:this},{text:'刷新',handler:this.refreshTree,scope:this}]});this.tree.on('click',function(n){n.select();this.mirrornode=n;D.reload({params:{cid:n.id}})},this);var D=new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.mirrorAction+'&method=store'}),reader:new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'id',fields:[{name:'id',type:'int'},'name','cid','categoryname','url','enable','default',{name:'sort',type:'int'}]}),remoteSort:false});this.MirrorGrid=new Ext.grid.GridPanel({store:D,enableColumnMove:false,collapsible:false,animCollapse:false,region:'center',style:'border-left:1px solid #99BBE8',sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true,columns:[new Ext.grid.RowNumberer(),{header:"名称",width:120,sortable:false,dataIndex:'name'},{header:"地址",width:180,sortable:false,dataIndex:'url'},{header:"默认使用",width:60,sortable:false,dataIndex:'default',renderer:this.renderDefault,scope:this},{header:"启用",width:40,sortable:false,dataIndex:'enable',renderer:this.renderEnable,scope:this},{header:"排序",width:40,align:'right',sortable:true,dataIndex:'sort'}],tbar:[{text:'添加',handler:this.editMirror,scope:this,mode:1},{text:'编辑',handler:this.editMirror,scope:this},{text:'删除',handler:this.delMirror,scope:this},'-',{text:'启用',handler:this.setting,scope:this,mode:['enable',1]},{text:'设置默认使用',handler:this.setting,scope:this,mode:['default',1]},'-',{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){D.reload()},scope:this}]});this.gridMenu=new Ext.menu.Menu({items:[{text:'添加',handler:this.editMirror,scope:this,mode:1},{text:'编辑',handler:this.editMirror,scope:this},{text:'删除',handler:this.delMirror,scope:this},'-',{text:'启用',handler:this.setting,scope:this,mode:['enable',1]},{text:'设置默认使用',handler:this.setting,scope:this,mode:['default',1]}]});this.MirrorGrid.on('rowcontextmenu',function(g,r,e){var stm=g.getSelectionModel();stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);this.record=g.getStore().getAt(r);this.gridMenu.showAt(e.getXY());this.setMirrorToobar()},this);this.MirrorGrid.on('rowclick',function(g,r){this.record=this.MirrorGrid.getStore().getAt(r);this.setMirrorToobar()},this);this.MirrorGrid.on('celldblclick',function(g,r){this.selecturl()},this);this.MirrorWin=new Ext.Window({title:'下载地址库管理列表',layout:'fit',minimizable:true,modal:false,border:false,resizable:true,width:650,height:400,minWidth:560,minHeight:400,closeAction:'hide',plain:false,items:{layout:'border',items:[this.tree,this.MirrorGrid]},buttons:[{text:'确定',handler:this.selecturl,scope:this},{text:'取消',handler:function(){this.MirrorWin.hide()},scope:this}]})}this.MirrorWin.show();this.MirrorGrid.getStore().load();this.MirrorGrid.getEl().dom.oncontextmenu=function(){return false};this.MirrorGrid.getEl().dom.onselectstart=function(){return false}},setMirrorToobar:function(){this.MirrorGrid.getTopToolbar().items.items[4].setText(this.record.get('enable')=='0'?'启用':'禁用');this.MirrorGrid.getTopToolbar().items.items[5].setText(this.record.get('default')=='0'?'设置默认使用':'取消默认使用');this.gridMenu.items.items[4].setText(this.record.get('enable')=='0'?'启用':'禁用');this.gridMenu.items.items[5].setText(this.record.get('default')=='0'?'设置默认使用':'取消默认使用');this.MirrorGrid.getTopToolbar().items.items[4].mode[1]=this.record.get('enable')==1?0:1;this.MirrorGrid.getTopToolbar().items.items[5].mode[1]=this.record.get('default')==1?0:1;this.gridMenu.items.items[4].mode[1]=this.record.get('enable')==1?0:1;this.gridMenu.items.items[5].mode[1]=this.record.get('default')==1?0:1},mirroredit:function(item){var title='';if(item.mode){title=this.mirrornode.text}else{title='新建下载分类'}if(!this.CategoryWin){this.CategoryEditorForm=new Ext.form.FormPanel({baseCls:'x-plain',bodyStyle:'padding:10px;',url:this.mirrorAction+'&method=editcate',border:true,labelWidth:60,defaultType:'textfield',items:[{fieldLabel:'分类名称',name:'categoryname',anchor:'98%',allowBlank:false,blankText:'下载分类名称不能为空'},{fieldLabel:'排序',name:'sort',anchor:'50%',xtype:'numberfield',value:100},{xtype:'hidden',name:'id'}]});this.CategoryWin=new Ext.Window({id:'excms-win-download-category',title:title,layout:'fit',minimizable:true,modal:false,border:false,resizable:true,width:300,height:150,closeAction:'hide',plain:false,items:this.CategoryEditorForm,buttons:[{text:'确定',handler:this.savecate,scope:this},{text:'取消',handler:function(){this.CategoryWin.hide()},scope:this}]});this.CategoryEditorForm.form.on('actioncomplete',function(f,a){if(a.result.success){var v=this.CategoryEditorForm.form.getValues();if(v.id>0){this.mirrornode.setText(v.categoryname);this.mirrornode.attributes['sort']=v.sort}else{this.tree.root.appendChild({id:a.result.success,text:v.categoryname,leaf:1,sort:v.sort})}this.CategoryWin.hide()}},this)}this.CategoryWin.setTitle(title);this.CategoryWin.show();if(item.mode){this.CategoryEditorForm.form.setValues({id:this.mirrornode.id,categoryname:this.mirrornode.text,sort:this.mirrornode.attributes['sort']})}else{this.CategoryEditorForm.form.reset()}},delmirror:function(){if(this.mirrornode&&this.mirrornode.id>0){this.tree.el.mask('正在删除, 请稍侯...');Ext.Ajax.request({url:this.mirrorAction+'&method=deletecate',method:'POST',params:{id:this.mirrornode.id},failure:function(){this.tree.el.unmask()},success:function(r,o){this.tree.el.unmask();r=jsonReturn(r);if(this.mirrornode.id!='1'){this.tree.getNodeById(this.mirrornode.id).remove()}alert(r.message)},scope:this})}else{alert("请选择您要删除的分类");return}},savecate:function(){if(!this.CategoryEditorForm.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return}this.CategoryEditorForm.form.submit()},selecturl:function(){var selected=this.MirrorGrid.getSelectionModel().getSelections();for(var i=0;i<selected.length;i++){if(this.systemMirror){if(!this.MirrorG[this.name][selected[i].data.cid]){this.MirrorG[this.name][selected[i].data.cid]=this.createDownloadGrid(selected[i].data.cid,selected[i].data.categoryname);this.downloadPanel.add(this.MirrorG[this.name][selected[i].data.cid])}var d=this.MirrorG[this.name][selected[i].data.cid].getStore();if(!d.getById(selected[i].data.name)){d.add(new this.plant(selected[i].data,selected[i].data.name))}this.downloadPanel.setActiveTab(this.MirrorG[this.name][selected[i].data.cid])}else{var d=this.MirrorG[this.name][this.name].getStore();if(!d.getById(selected[i].data.name)){d.add(new this.plant(selected[i].data,selected[i].data.name))}}}this.MirrorWin.hide()},editMirror:function(item){var mode=item&&item.mode?1:0;var title=mode?'添加下载地址':'编辑下载地址';if(!mode)if(!this.record||!this.record.id){alert("请选择您要编辑的下载地址");return}if(!this.mirrorEditor){this.category=new Ext.form.ComboBox({fieldLabel:'分类名称',disabled:false,hiddenName:'cid',anchor:'98%',maxHeight:200,editable:false,valueField:'id',displayField:'categoryname',waitMsgTarget:true,typeAhead:true,triggerAction:'all',emptyText:'请选择下载分类名称',selectOnFocus:true,allowBlank:false,blankText:"请选择下载分类名称",store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.mirrorAction+'&method=getMirrorCate'}),reader:new Ext.data.JsonReader({root:'data',id:'id'},['id','categoryname']),remoteSort:true})});this.category.on('render',function(){this.category.trigger.on('click',function(){this.category.store.load()},this)},this);this.mirrorEditorForm=new Ext.form.FormPanel({baseCls:'x-plain',bodyStyle:'padding:10px;',url:this.mirrorAction+'&method=edit',border:true,labelWidth:60,defaultType:'textfield',items:[this.category,{fieldLabel:'下载名称',name:'name',anchor:'98%',allowBlank:false,blankText:'下载名称不能为空'},{fieldLabel:'地址',name:'url',anchor:'98%'},{fieldLabel:'启用',xtype:'checkbox',boxLabel:'是否启用',name:'enable',checked:true},{fieldLabel:'默认显示',xtype:'checkbox',boxLabel:'是否显示到默认列表',name:'default',checked:true},{fieldLabel:'排序',name:'sort',anchor:'30%',xtype:'numberfield',value:100},{xtype:'hidden',name:'id'}]});this.mirrorEditor=new Ext.Window({id:'dlg-download-mirror-editor',title:title,layout:'fit',minimizable:true,modal:false,resizable:false,width:480,height:250,closeAction:'hide',plain:true,items:this.mirrorEditorForm,buttons:[{text:'确定',handler:this.saveMirror,scope:this,mode:0},{text:'取消',handler:function(){this.mirrorEditor.hide()},scope:this}]});this.mirrorEditorForm.form.on('actioncomplete',function(form,action){if(action.result.success){this.MirrorGrid.getStore().reload();this.mirrorEditor.hide()}},this)}this.mirrorEditor.setTitle(title);this.mirrorEditor.show();if(!mode){this.mirrorEditorForm.form.setValues(this.record.data);this.category.setValue(this.record.data.cid);this.category.getEl().dom.value=this.record.data.categoryname}else{this.mirrorEditorForm.form.reset();if(this.mirrornode){this.category.setValue(this.mirrornode.id);this.category.getEl().dom.value=this.mirrornode.text}}},saveMirror:function(){if(!this.mirrorEditorForm.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return}this.mirrorEditorForm.form.submit()},delMirror:function(){var selected=this.MirrorGrid.getSelectionModel().getSelections();if(!(selected.length>0)){alert('请选择要删除的文档');return}var id=[];if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的记录吗？",function(optional){if(optional=='yes'){Ext.Ajax.request({url:this.mirrorAction+'&method=delete',method:'post',scope:this,params:{ids:id.join(',')},success:function(r,o){r=jsonReturn(r);alert(r.message);this.MirrorGrid.getStore().reload()}})}},this)},setting:function(item){var selected=this.MirrorGrid.getSelectionModel().getSelections();if(!(selected.length>0)){alert('请选择要下载地址');return}var id=[];if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}Ext.Ajax.request({url:this.mirrorAction+'&method='+item.mode[0],method:'post',scope:this,params:{ids:id.join(','),status:item.mode[1]?1:0},success:function(r,o){r=jsonReturn(r);if(r.success){for(var i=0;i<id.length;i++)this.MirrorGrid.getStore().getById(id[i]).set(item.mode[0],item.mode[1]);this.MirrorGrid.getStore().commitChanges();this.setMirrorToobar()}}})},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}Ext.form.DownloadEditor.superclass.setValue.apply(this,C);this.loadMirrorDataStatus=false;if((typeof C=='object'||typeof C=='array')&&C.length>0){this.CurrentR[this.name]=[];for(var i=0;i<C.length;i++){this.CurrentR[this.name][C[i].cid]=[];if(C[i].data.length>0){this.loadMirrorDataStatus=true;for(var j in C[i].data)if(j!='remove'&&j!='indexOf')this.CurrentR[this.name][C[i].cid].push(new this.plant({name:C[i].data[j].name,url:C[i].data[j].url,sort:C[i].data[j].sort,local:C[i].data[j].local,defaultdownload:C[i].data[j].defaultdownload},C[i].data[j].name))}}}else{this.loadMirrorDataStatus=false}this.loadMirrorData(0);this.setRawValue(Ext.encode(C))},getRawValue:function(){var A=Ext.util.JSON.encode(this.getValue());this.setRawValue(A);return A},getValue:function(){var data=[];for(var i in this.MirrorG[this.name]){if(i=='remove'||i=='indexOf')continue;var local=[];var count=this.MirrorG[this.name][i].getStore().getCount();for(var j=0;j<count;j++){var record=this.MirrorG[this.name][i].getStore().getAt(j);local.push({id:record.data.id,name:record.data.name,url:record.data.url,sort:record.data.sort,local:record.data.local,defaultdownload:record.data.defaultdownload})}data.push({cid:this.MirrorG[this.name][i].categoryid,data:local})}return data},loadMirrorCate:function(){for(var g in this.DefaultG){if(g=='remove'||g=='indexOf'){continue}if(!this.MirrorG[this.name][g]){this.MirrorG[this.name][g]=this.createDownloadGrid(this.DefaultG[g].id,this.DefaultG[g].name);this.downloadPanel.add(this.MirrorG[this.name][g])}if(this.DefaultG[g].mirror){this.DefaultR[g]=[];for(var j=0;j<this.DefaultG[g].mirror.length;j++){var r=this.DefaultG[g].mirror[j];this.DefaultR[g].push(new this.plant({name:r.name,url:r.url,sort:r.sort,local:false,defaultdownload:false},r.name));this.MirrorG[this.name][g].getStore().add(this.DefaultR[g])}}}this.downloadPanel.setActiveTab(0)},select:function(item){var mode=item&&item.mode?item.mode:1;var g=this.downloadPanel.getActiveTab();switch(item.mode){case 1:g.getSelectionModel().selectAll();break;case 2:for(var i=0;i<g.getStore().getCount();i++)g.getSelectionModel().isSelected(i)?g.getSelectionModel().deselectRow(i):g.getSelectionModel().selectRow(i,true);break;case 3:g.getSelectionModel().clearSelections();break;default:break}},isUrl:function(str_url){var strRegex="^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\.[a-z]{2,6})(:[0-9]{1,4})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";var re=new RegExp(strRegex,'i');if(re.test(str_url)){return true}else{return false}},renderEnable:function(v){return v==1?'<span style="color:green;">启用</span>':'<span style="color:red;">禁用</span>'},renderDefault:function(v){return v==1?'<span style="color:green;">是</span>':'<span style="color:red;">否</span>'}});Ext.reg('downloadeditor',Ext.form.DownloadEditor);
Ext.form.VideoEditor=Ext.extend(Ext.form.Field,{hidden:true,border:true,channelid:'',height:150,emptyText:null,labelStyle:'padding-top:20px;',emptyClass:"x-form-empty-field",initComponent:function(){this.readOnly=this.readOnly||!this.allowRemote;Ext.form.VideoEditor.superclass.initComponent.call(this);this.addEvents("setThumb")},onRender:function(C,A){Ext.form.VideoEditor.superclass.onRender.call(this,C,A);this.wrap=this.el.wrap({cn:{cls:""}});this.wrap.dom.lastChild.style.display='none';if(this.width>0)this.width=Math.max(this.width,550);if(this.height>0)this.height=Math.max(this.height,200);this.loadDataView()},loadDataView:function(){this.toolbar=new Ext.Toolbar({items:[{text:'上传',handler:this.fileSelect,scope:this},{text:'添加资源视频',iconCls:'',handler:this.addResourceFile,scope:this},{text:'添加网上视频',iconCls:'',handler:this.addUrlFile,scope:this},'-',{text:'设为缩略图',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'编辑视频',iconCls:'',handler:this.editDesc,scope:this},{text:'删除',iconCls:'',handler:this.deletefile,scope:this}]});var thumbTemplate=new Ext.XTemplate('<tpl for=".">','<div class="video-wrap" id="{name}" title="{description}"><em class="x-infoeditable" title="编辑"></em>','<div class="video-thumb"><img src="{thumb}"  onload="this.style.display=\'\'" style="display:none" /></div>','<span title="{description}">{description}</span>','</div>','</tpl>','<div class="x-clear"></div>');thumbTemplate.compile();this.store=new Ext.data.JsonStore({fields:['name','thumb','thumb_resource','src','resource','description',{name:'sort',type:'int'}],sortInfo:{field:'sort',direction:'ASC'},listeners:{'load':{fn:function(){this.view.select(0)},scope:this,single:true}}});this.dataview=new Ext.DataView({cls:'video-view',tpl:thumbTemplate,overClass:'vv-over',selectedClass:'vv-selected',itemSelector:'div.video-wrap',store:this.store,autoScroll:true,multiSelect:true,autoWidth:true,autoHeight:true,plugins:[new Ext.DataView.DragSelector(),new Ext.DataView.imgEditInfo('视频','video')],listeners:{scope:this,'dblclick':function(v,i,n,e){this.dataview.plugins[1].onMouseDown(null,Ext.get(n).child('span',true))},'contextmenu':function(o,i,n,e){if(!o.isSelected(i))o.select(i);this.dataview.selectedIndex=i;var f=this.store.getAt(i).get('resource')?false:true;this.viewMenu.items.items[1].setDisabled(f);this.viewMenu.items.items[2].setDisabled(f);this.viewMenu.showAt(e.getXY())},'beforeselect':function(v){return v.store.getRange().length>0}}});this.viewPanel=new Ext.Panel({renderTo:this.wrap.dom.firstChild,border:this.border,layout:'card',autoScroll:true,width:this.width,height:this.height,autoWidth:!this.width,autoHieght:!this.height,anchor:this.anchor,autoHeight:!this.height,activeItem:0,bodyStyle:'background:#FCFCFC;',items:this.dataview,tbar:this.toolbar});this.viewMenu=new Ext.menu.Menu({items:[{text:'上传视频',handler:this.fileSelect,scope:this},{text:'添加资源视频',handler:this.addResourceFile,scope:this},{text:'添加网上视频',handler:this.addUrlFile,scope:this},'-',{text:'设置视频截图',handler:this.addResourceImg,scope:this},{text:'上传视频截图',handler:this.imageSelect,scope:this},{text:'预览视频截图',handler:this.previewImage,scope:this},'-',{text:'设为缩略图',iconCls:'',handler:this.setAsThumb,scope:this},'-',{text:'编辑视频',handler:function(){var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},scope:this},{text:'删除',handler:this.deletefile,scope:this}]});this.dataview.getEl().dom.oncontextmenu=function(){return false}},imageSelect:function(item){EXCMS.util.QuickCreate({model:'Resource.ImageSelector',callback:this.setResourceImg.createDelegate(this),top:true,single:true,postfix:'thumb',channelid:this.getChannelid()})},addResourceImg:function(item){EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.setResourceImg.createDelegate(this),top:true,type:'image',single:true,postfix:'thumb',channelid:this.getChannelid()})},setResourceImg:function(r){var record=this.dataview.getSelectedRecords();record[0].set('thumb',r.src);record[0].set('thumb_resource',r.resource)},fileSelect:function(){var item={};item.callback=this.resourceCallback.createDelegate(this);item.model='Resource.Upload';item.top=true;item.channelid=this.getChannelid();item.tid=3;EXCMS.util.QuickCreate(item)},addResourceFile:function(){var channelid=this.getChannelid();EXCMS.util.QuickCreate({model:'Resource.Browse',callback:this.resourceCallback.createDelegate(this),top:true,type:'video',single:false,channelid:channelid})},previewImage:function(item){var image=this.store.getAt(this.dataview.selectedIndex).data;var src=image.thumb;if(!src){alert('无法预览');return}EXCMS.Previewer.image(src)},previewVideo:function(){},setAsThumb:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("请选择一张要设为缩略图的图片");return}var r=this.dataview.getSelectedRecords();var data={resource:'',src:''};if(r[0].data.thumb_resource){data.resource=r[0].data.thumb_resource}else if(data.thumb){data.resource=r[0].data.thumb}else{alert("当前无视频裁图,请先设置截图");return}data.src=r[0].data.thumb;this.fireEvent("setThumb",this,data)},addUrlFile:function(){if(!this.urlFileDialog){this.formPanel=new Ext.form.FormPanel({labelWidth:60,baseCls:'x-plain',bodyStyle:'padding:20px 12px',border:false,items:[{xtype:'textfield',fieldLabel:'名称',name:'name',anchor:'99%'},{xtype:'textfield',fieldLabel:'视频地址',name:'src',anchor:'99%',allowBlank:false,blankText:'视频地址不能为空'},{xtype:'textarea',fieldLabel:'描述',name:'description',height:60,anchor:'99%'},{xtype:'numberfield',fieldLabel:'排序',value:50,name:'sort',anchor:'35%'}]});this.urlFileDialog=new Ext.Window({title:'添加远程视频',layout:'fit',modal:false,resizable:false,width:450,height:250,closeAction:'hide',plain:true,items:this.formPanel,buttons:[{text:'确定',handler:this.insert,scope:this},{text:'取消',handler:function(){this.urlFileDialog.hide()},scope:this}]})}this.urlFileDialog.show();this.formPanel.form.reset()},insert:function(){if(!this.formPanel.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return}var values=this.formPanel.form.getValues();this.store.add(new Ext.data.Record(values));this.urlFileDialog.hide();this.store.sort('sort','ASC')},resourceCallback:function(r){for(var i=0,len=r.length;i<len;i++){if(r[i].rid){if(!this.store.getById(r[i].rid)){this.store.add(new Ext.data.Record({name:r[i].filename,src:r[i].src,resource:r[i].resource,description:r[i].description,sort:100},r[i].rid))}}}this.store.sort('sort','ASC')},deletefile:function(){var r=this.dataview.getSelectedRecords();if(r.length==0){alert('请先选择要删除的文件');return}for(var i=0;i<r.length;i++){this.store.remove(r[i])}this.store.sort('sort','ASC')},editDesc:function(){var n=this.dataview.getSelectionCount();if(n!=1){alert("请选择要编辑的文件");return}var target=Ext.get(this.dataview.getSelectedNodes()[0]).child('span',true);this.dataview.plugins[1].onMouseDown(null,target)},getChannelid:function(){var channelid=typeof window.top.EXCMS.getChannelId=='function'?window.top.EXCMS.getChannelId():0;if(this.channelid!=channelid){this.channelid=channelid}return this.channelid},setChannelid:function(channelid){this.channelid=channelid},setValue:function(C){if(C=='')C='[]';if(typeof C=='string'){C=Ext.decode(C)}if(this.emptyText&&this.el&&C!==undefined&&C!==null&&C!==""){this.el.removeClass(this.emptyClass)}Ext.form.VideoEditor.superclass.setValue.apply(this,C);if(typeof C=='object'||typeof C=='array'){if(this.store)this.store.removeAll();for(var i=0;i<C.length;i++){this.store.add(new Ext.data.Record({description:C[i].description,thumb:C[i].thumb,thumb_resource:C[i].thumb_resource,src:C[i].src,name:C[i].name,resource:C[i].resource,sort:C[i].sort}))}}this.setRawValue(Ext.encode(C))},applyEmptyText:function(){if(this.rendered&&this.emptyText&&this.getRawValue().length<1){this.setRawValue(this.emptyText);this.el.addClass(this.emptyClass)}},getRawValue:function(){var A=Ext.encode(this.getValue());this.setRawValue(A);if(A===this.emptyText){A=""}return A},reset:function(){Ext.form.VideoEditor.superclass.reset.call(this);this.applyEmptyText()},getValue:function(){var data=new Array;if(this.store)this.store.sort('sort','ASC');this.store.each(function(r){data.push(r.data)});return data}});Ext.reg('videoeditor',Ext.form.VideoEditor);
EXCMS.HtmlEditorPage = function(config){Ext.MessageBox.prompt('插入分页','请输入分页标题：',function(btn,txt){if(btn=='ok'){config.callback(txt.trim())}},this)}
function imageOnLoad(img){img.parentNode.getElementsByTagName('strong')[0].style.display='none';img.style.display='block';var imgSrc=img.src;var tempImg=new Image();tempImg.src=imgSrc;var scale=1.0;var width=0,height=0;var fitWidth=fitHeight=90;if(document.all){if(tempImg.readyState=='complete'){width=tempImg.width;height=tempImg.height;}}else{width=tempImg.width;height=tempImg.height;}scale=width/height;if(width>fitWidth){width=fitWidth;height=width/scale;if(height>fitHeight){height=fitHeight;width=height*scale;}}if(height>fitHeight){height=fitHeight;width=height*scale;}if(width==0||height==0){width=fitWidth;height=fitHeight;}img.style.width=width+'px';img.style.height=height+'px';var x=parseInt((90-width)/2);img.parentNode.parentNode.style.left=x+'px';};

