Ext.apply(Ext.form.VTypes, {
    daterange : function(val, field) {
        var date = field.parseDate(val);
        if(!date){return;}
        if (field.startDateField && (!this.dateRangeMax || (date.getTime() != this.dateRangeMax.getTime()))) {
            var start = Ext.getCmp(field.startDateField);start.setMaxValue(date);start.validate();this.dateRangeMax = date;
        }
        else if (field.endDateField && (!this.dateRangeMin || (date.getTime() != this.dateRangeMin.getTime()))) {
            var end = Ext.getCmp(field.endDateField);end.setMinValue(date);end.validate();this.dateRangeMin = date;
        }
        return true;
    }
});

EXCMS.Model.FieldEditor={
	validateRule:['/^[\\w\\-\\.]+@[\\w\\-\\.]+(\\.\\w+)+$/','/^http:\\/\\//','/^[0-9.-]+$/','/^[0-9-]+$/','/^[a-z]+$/i','/^[0-9a-z]+$/i','/^(13|15)[0-9]{9}$/','/^[0-9-]{6,13}$/','/^[0-9]{6}$/'],
	baseAction : 'index.php?M=Model&A=Index',	
	render:function(){
		Ext.QuickTips.init();
		this.cardPanel = {};
		this.cardPanel['t0'] = this.renderType(0);
		this.typevalue = 0;
		this.validate = new Ext.form.ComboBox({hideLabel:true,displayField:'name',valueField:'id',editable:false,mode:'local',triggerAction:'all',selectOnFocus:true,emptyText:'自定义正则',listeners:{'select':function(o,r,i){this.optionForm.form.items.items[0].setValue(this.validateRule[i]);},scope:this},store:new Ext.data.SimpleStore({fields:['id','name'],data:[[1,'Email'],[2,'URL地址'],[3,'数字'],[4,'整数'],[5,'字母'],[6,'数字+字母'],[7,'手机号码'],[8,'电话号码'],[9,'邮证编码']]})});
		this.type = new Ext.form.ComboBox({fieldLabel:'数据类型',height:200,value:0,displayField:'name',valueField:'id',editable:false,mode:'local',triggerAction:'all',selectOnFocus:true,store:new Ext.data.SimpleStore({fields:['id','name'],data:[[0,'单行文本'],[1,'多行文本'],[2,'HTML文本'],[3,'整数类型'],[4,'小数类型'],[5,'时间类型'],[6,'图片资源'],[7,'多媒体文件'],[8,'附件类型'],[9,'下拉选择'],[10,'单选框'],[11,'多选框'],[12,'分类选择'],[13,'图片编辑器'],[14,'下载编辑器'],[15,'视频编辑器']]})});
		this.type.on('select',function(c,r,i){this.updateFEP(c);},this);
		this.formpanel = new Ext.FormPanel({border:false,labelWidth:80,defaults:{width:200},items:[
			{name:'fieldid',xtype:'hidden'},
			{name:'modelid',xtype:'hidden'},
			{fieldLabel:'字段名',xtype:'textfield',name:'fieldname',allowBlank:false,blankText:'字段名不能为空',vtype:'alphanum',vtypeText:'字段名称只支持大小写英文字母、数字以及下划线',sideHtml:'支持大小写英文字母、数字以及下划线'},
			{fieldLabel:'表单标签',xtype:'textfield',name:'formname',allowBlank:false,blankText:'表单标签不能为空',sideHtml:'表单中字段前面显示的文字'},
			this.type
		]});
		
		this.fieldForm = new Ext.Panel({border:false,layout:'form',defaults:{anchor:'100%'},items:this.cardPanel['t0']});
		
		this.optionForm = new Ext.FormPanel({border:false,labelWidth:80,defaults:{anchor:'100%'},layout:'form',items:[{layout:'column',border:false,items:[
				{columnWidth:.7,layout:'form',defaults:{anchor:'-10'},border:false,items:{fieldLabel:'正则表达式',name:'validate',xtype:'textfield'}},
				{columnWidth:.3,layout:'form',defaults:{anchor:'100%'},border:false,items:this.validate}]
			},
			{fieldLabel:'未通过提示',name:'regexText',xtype:'textfield'},
			{fieldLabel:'选项',xtype:'checkboxgroup',columns:5,anchor:'80%',items:[
				{boxLabel:'允许为空',name:'fieldoption[]',inputValue:'allownull',checked:true},
				{boxLabel:'允许显示',name:'fieldoption[]',inputValue:'allowshow',checked:true},
				{boxLabel:'列表显示',name:'fieldoption[]',inputValue:'allowlist',checked:true},
				{boxLabel:'允许投稿',name:'fieldoption[]',inputValue:'allowcontribute',checked:false},
				{boxLabel:'允许搜索',name:'fieldoption[]',inputValue:'allowsearch',checked:true}
			]},
			{fieldLabel:'描述',xtype:'textfield',name:'description'},
			{fieldLabel:'显示顺序',name:'sort',xtype:'numberfield',value:50,anchor:'20%'}
		]});
		this.formpanel.form.on('actioncomplete',function(form,action){
			if(action.result.success){
				alert("保存数据成功");
				this.store.reload();
				this.setEditorVisible(this.fieldPanel,false);
			}
		},this);
		this.fieldPanel = new Ext.Panel({title:'新建字段',layout:'form',closable:true,autoScroll:true,border:false,bodyStyle:'padding:10px;',defaults:{width:600},
			items:[this.formpanel,this.fieldForm,this.optionForm],tbar:[{text:'保存',iconCls:'btnico btn_save',handler:this.fieldSave,scope:this},{text: '关闭',iconCls:'btnico btn_cancel',handler: function(){this.setEditorVisible(this.fieldPanel,false);},scope:this}]
		});
		this.mainPanel.add(this.fieldPanel);
		this.mainPanel.activate(this.fieldPanel);
		this.fieldPanel.doLayout();
	},
	//加载数据
	load:function(item){
		this.mainPanel = item.mainPanel;
		if(!this.fieldPanel){
			this.render();
		}else{
			this.setEditorVisible(this.fieldPanel,true);
		}
		this.store = item.store;
		var title = item && item.mode==1 ? '编辑字段' : '新建字段';
		if(item&&item.params&&item.params.id&&item.params.datatype){
			this.fieldPanel.setTitle(title);
			this.updateFEP({value:item.params.datatype});
			if(item.params.id == this.id){
				this.type.setValue(this.values.datatype);
				this.formpanel.form.setValues(this.values);
				this.fieldForm.getComponent('t'+this.typevalue).form.setValues(this.values);
				this.optionForm.form.setValues(this.values);
				this.validate.reset();
			}else{
				this.id = item.params.id;
				this.fieldPanel.el.mask('正在获取字段数据,请稍侯...');
				Ext.Ajax.request({
					url: this.baseAction+'&method=getFieldById',method:'post',params:{id:this.id},
					failure:function(response,options){
						this.fieldPanel.el.unmask();
						Ext.MessageBox.show({title:'错误',msg:'获取字段数据失败！请重试！',ico:Ext.MessageBox.ERROR});
					}, 
					success:function(r,o){
						this.fieldPanel.el.unmask();
						r=jsonReturn(r);
						if(r.success==200 && typeof r=='object'){
							this.values = r.data;
							this.type.setValue(this.values.datatype);
							this.formpanel.form.setValues(this.values);
							this.fieldForm.getComponent('t'+this.typevalue).form.setValues(this.values);
							this.optionForm.form.setValues(this.values);
							this.validate.reset();
						}
						else{Ext.MessageBox.show({title:'提示',msg:'没有找到相关字段数据！',ico:Ext.MessageBox.WARNING});}
					},
					scope:this
				});
			}
		}else{
			this.fieldPanel.setTitle(title);
			this.formpanel.form.reset();
			this.fieldForm.getComponent('t'+this.typevalue).form.reset();
			this.updateFEP({value:0});
			this.optionForm.form.reset();
			this.validate.reset();
			this.formpanel.form.items.items[1].setValue(item.params.modelid);
		}
		if(item.params.issystem){
			this.formpanel.form.items.items[2].disable();
		}else{
			this.formpanel.form.items.items[2].enable();
		}
	},
	setEditorVisible : function(panel,flag){
	    if(flag){
	        this.mainPanel.unhideTabStripItem(panel);
	        panel.setVisible(true);
	    }else{
	        this.mainPanel.activate(0);
	        this.mainPanel.hideTabStripItem(panel);
	    }
	},
	fieldSave : function(){
		if(!this.formpanel.form.isValid() || !this.fieldForm.getComponent('t'+this.typevalue).form.isValid()){
			Ext.MessageBox.show({title:'错误',msg:"请检查红线处的错误提示！",buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});
			return ;
		}
		this.values = this.fieldForm.getComponent('t'+this.typevalue).form.getValues();
		this.optionvalues =  this.optionForm.form.getValues();
		for(key in this.optionvalues){ 
			this.values[key]= this.optionvalues[key];
		} 
		this.values['datatype'] = this.type.getValue();
		this.values.fieldname = this.formpanel.form.items.items[2].getValue();
		if(this.values.fieldname){
			var re=/^[a-zA-Z0-9_]+$/; 
			if(!re.test(this.values.fieldname)){
				alert("字段名称只能为英文、数字、下划线，请输入正确的字段名称");
				return ;
			}
		}
		this.formpanel.form.submit({url:this.baseAction+'&method=fieldadd',params:this.values});
	},
	updateFEP : function(c){
		if(this.typevalue == c.value) {return;}
		this.typevalue = c.value;
		for(var i=0;i<=15;i++){
			if( this.cardPanel['t'+i]){
				this.cardPanel['t'+i].hide();
			}
		}
		if(this.cardPanel['t'+c.value]){
			this.cardPanel['t'+c.value].show();
		}else{
			this.cardPanel['t'+c.value] = this.renderType(c.value);
			this.fieldForm.add(this.cardPanel['t'+c.value]);
			this.fieldForm.doLayout();
		}
		this.cardPanel['t'+c.value].form.reset();
	},
	fieldWidth:{fieldLabel:'显示宽度',name:'width',xtype:'textfield',width:100,value:400,minValue:0,maxValue:1000,sideHtml:'px (空或0表示自动宽度)'},
	fieldHeight:{fieldLabel:'显示高度',name:'height',xtype:'textfield',width:100,value:100,minValue:0,maxValue:1000,sideHtml:'px (空或0表示自动高度)'},
	fieldTip:{fieldLabel:'字段提示',name:'emptytext',width:325,sideHtml:'字段提示文字'}, 
	fieldEmpty:{fieldLabel:'空值提示',name:'blanktext',width:325,sideHtml:'当字段值为空时的提示文字'}, 
	fieldMaxLength:{fieldLabel:'字符数',name:'datalength',xtype:'numberfield',width:100,decimalPrecision:0,value:250,sideHtml:'允许输入字符最大长度(一个汉字等于两个字符)'},
	emptyComment:{xtype:'label',text:'字段提示文字',style:'display:block;padding:0px 0px 6px 85px;color:#666;',cls:'comment-label',width:600},
	renderType : function(t){
		t = parseInt(t);
		var cfg;
		switch(t){
			case 0 : 
				cfg = [
					this.fieldMaxLength,
					{fieldLabel:'默认值',name:'default',width:360,sideHtml:'字段默认值显示的文字'},
					{fieldLabel:'密码字段',name:'password',boxLabel:'是',xtype:'checkbox',inputValue:1},
					this.fieldWidth,
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 1 :
				cfg = [
					this.fieldMaxLength,
					this.fieldWidth,
					this.fieldHeight,
					{fieldLabel:'默认值',name:'default',xtype:'textarea'},
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 2 : 
				cfg = [
					this.fieldMaxLength,
					this.fieldWidth,
					this.fieldHeight,
					{fieldLabel:'附加选项',xtype:'checkboxgroup',items:[
						{boxLabel:'删除非站内链接',name:'addonoption[]',inputValue:'deletelink',checked:true,hideLabel:true},
						{boxLabel:'下载远程图片和资源',name:'addonoption[]',inputValue:'remotedownload',checked:true,hideLabel:true},
						{boxLabel:'启用分页',name:'addonoption[]',inputValue:'displaypage',checked:true,hideLabel:true},
						{boxLabel:'启用内容关键字链接',name:'addonoption[]',inputValue:'contentkeyword',checked:true,hideLabel:true}
					]},
					{fieldLabel:'默认值',name:'default',xtype:'textarea',height:120},
					{fieldLabel:'显示',name:'displayLabel',boxLabel:'是否显示表单标签',xtype:'checkbox',inputValue:1}
				];
				break;
			case 3 : 
				cfg = [
					{fieldLabel:'最大值',name:'maxvalue',xtype:'numberfield',width:100,decimalPrecision:0},
					{fieldLabel:'最小值',name:'minvalue',xtype:'numberfield',width:100,decimalPrecision:0},
					{fieldLabel:'默认值',name:'default',xtype:'numberfield',width:100,decimalPrecision:0},
					this.fieldWidth,
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 4 : 
				cfg = [
					{fieldLabel:'小数位数',name:'decimalprecision',xtype:'numberfield',width:100,decimalPrecision:0,value:2,maxValue:10},
					{fieldLabel:'最大值',name:'maxvalue',xtype:'numberfield',width:100},
					{fieldLabel:'最小值',name:'minvalue',xtype:'numberfield',width:100},
					{fieldLabel:'默认值',name:'default',xtype:'numberfield',width:100},
					this.fieldWidth,
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 5 : 
				cfg = [
					{fieldLabel:'时间格式',hiddenName:'dateformat',width:260,xtype:'combo',editable:false,mode:'local',triggerAction:'all',selectOnFocus:true,store:[['Y-m-d','年-月-日(2010-01-01)'],['Y-m-d H:i:s','年-月-日 时:分:秒(2010-01-01 00:01:01)'],['H:i:s','时:分:秒(00:01:01)']]},
					{fieldLabel:'最小时间',name:'startdt',xtype:'datefield',width:100,vtype:'daterange',id:'startdt',endDateField: 'enddt',format:'Y-m-d'},
					{fieldLabel:'最大时间',name:'enddt',xtype:'datefield',width:100,vtype:'daterange',id:'enddt',startDateField: 'startdt',format:'Y-m-d'},
					{fieldLabel:'默认值',name:'default',width:100,xtype:'datefield',format:'Y-m-d'},
					this.fieldWidth,
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 6 : 
				cfg = [
					{fieldLabel:'允许类型',xtype:'checkboxgroup',width:260,items:[
						{boxLabel:'GIF',name:'allowtype[]',inputValue:'GIF',hideLabel:true},
						{boxLabel:'JPG',name:'allowtype[]',inputValue:'JPG',hideLabel:true},
						{boxLabel:'JPEG',name:'allowtype[]',inputValue:'JPEG',hideLabel:true},
						{boxLabel:'PNG',name:'allowtype[]',inputValue:'PNG',hideLabel:true},
						{boxLabel:'所有类型',name:'allowtype[]',inputValue:'ALL',hideLabel:true}
					]},
					{fieldLabel:'最大图片大小',name:'filesize',xtype:'numberfield',width:100,value:0,decimalPrecision:0,sideHtml:'KB 允许上传图片的大小上限，0不限制'},
					this.fieldWidth,
					this.fieldEmpty,
				];
				break;
			case 7 : 
				cfg = [
					{fieldLabel:'允许类型',name:'filetype',value:'avi,rm,wmp,mpeg,flv',width:325,sideHtml:'允许文件类型，以英文逗号“,”隔开'},
					{fieldLabel:'文件大小',name:'filesize',xtype:'numberfield',width:100,value:0,decimalPrecision:0,sideHtml:'KB 允许上传多媒体的大小上限，0不限制'},
					this.fieldTip,
					this.fieldEmpty
					//{fieldLabel:'空值提示',name:'blanktext'}
				];
				break;
			case 8 : 
				cfg = [
					{fieldLabel:'允许类型',name:'filetype',value:'zip,rar,doc,docs,xls,ppt,pdf,txt',width:325,sideHtml:'允许文件类型，以英文逗号“,”隔开'},
					{fieldLabel:'文件大小',name:'filesize',xtype:'numberfield',width:100,value:0,decimalPrecision:0,sideHtml:'KB 允许上传附件大小上限，0不限制'},	
					this.fieldTip,
					this.fieldEmpty
					//{fieldLabel:'空值提示',name:'blanktext'}
				];
				break;
			case 9 : 
			case 10 : 
			case 11 : 
				cfg = [
					{fieldLabel:'附加值',name:'addonvalue',xtype:'textarea',width:200,height:120,value:'',sideHtml:'一行一个附加值，键与值以冒号(:)分隔<br><b>例如：</b><br>1:北京<br>2:上海<br>3:香港',sideStyle:';position:absolute;top:0'},
					{fieldLabel:'默认值',name:'default',width:100,sideHtml:''},
					this.fieldWidth,
					this.fieldTip
				];
				break;
			case 12 : 
				cfg = [
					{xtype:'combotree',width:325,fieldLabel:'取值来源',hiddenName:'valuefrom',style:"font-family:'宋体'",allowBlank:false,blankText:'取值来源不能为空',value:'',emptyText:'请选择分类取值来源',dataUrl:'index.php?M=Category&A=Index&method=catetree',rootText:'所有分类',onTreeClick:function(n){if(!n.attributes['iscate'])return;this.setValue(n.id);this.el.dom.value=n.parentNode.text+' > '+n.text;this.collapse()}},
					{fieldLabel:'允许多选',name:'multiselect',boxLabel:'是',xtype:'checkbox',inputValue:1},
					this.fieldWidth,
					this.fieldTip,
					this.fieldEmpty
				];
				break;
			case 13 :
				cfg = [
					{fieldLabel:'表单名称',name:'displayLabel',boxLabel:'是否显示表单名称',xtype:'checkbox',inputValue:1},
					{fieldLabel:'启用分页',name:'displaypage',boxLabel:'是',xtype:'checkbox',inputValue:1},
					this.fieldWidth,
					this.fieldHeight
				];
				break;
			case 14 :
				cfg = [
					{fieldLabel:'系统镜像',name:'systemMirror',boxLabel:'是',xtype:'checkbox',inputValue:1},
					{fieldLabel:'表单名称',name:'displayLabel',boxLabel:'是否显示表单名称',xtype:'checkbox',inputValue:1},
					this.fieldWidth,
					this.fieldHeight
				];
				break;
			case 15 :
				cfg = [
					{fieldLabel:'表单名称',name:'displayLabel',boxLabel:'是否显示表单名称',xtype:'checkbox',inputValue:1},
					{fieldLabel:'启用分页',name:'displaypage',boxLabel:'是',xtype:'checkbox',inputValue:1},
					this.fieldWidth,
					this.fieldHeight
				];
				break;
		}
		return new Ext.FormPanel({id:'t'+t,border:false,labelWidth:80,defaultType:'textfield',defaults:{width:'100%'},items:cfg});
	},
	cancel:function(){this.win.hide();}
};