EXCMS.Model.Editor={
	templateListAction : 'index.php?M=Common&A=TemplatesList',
	render:function(){
		this.f={
			'index':new Ext.form.ComboBox({fieldLabel:'封面模板',hiddenName:'templateindex',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
				valueField:'id',displayField:'name',emptyText:'选择封面模板',selectOnFocus:true,value:"channel.html",store:this.store('channel')
			}),
			'list':new Ext.form.ComboBox({fieldLabel:'列表页模板',hiddenName:'templatelist',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
				valueField:'id',displayField:'name',emptyText:'选择列表页模板',selectOnFocus:true,value:"list.html",store:this.store('list')
			}),
			'content':new Ext.form.ComboBox({fieldLabel:'内容页模板',hiddenName:'templatedetail',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
				valueField:'id',displayField:'name',emptyText:'选择内容页模板',selectOnFocus:true,value:"content.html",store:this.store('content')
			})
  		};
		var form = {xtype:'panel',border:false,defaults:{layout:'form',border:false,bodyStyle:'padding:15px;overflow-x:hidden',labelWidth:80},items:[
			{autoScroll:true,cls:'',bodyStyle:'padding:15px 0px 0px 15px;overflow-x:hidden',defaults:{xtype:'textfield',anchor:'-30'},items:[
				{fieldLabel:'模型名称',name:'name',xtype: 'textfield',allowBlank:false,blankText:"模型名称不能为空"},
                {fieldLabel:'名字标识',name:'ename',xtype: 'textfield',allowBlank:false,blankText:"名字标识不能为空",vtype:'alphanum',vtypeText:'名字标识支持大小写英文字母、数字以及下划线，请输入正确的名字标识'},
            	{fieldLabel:'附加表',name:'addontable',xtype: 'textfield',allowBlank:false,blankText:"附加表不能为空",vtype:'alphanum',vtypeText:'附加表名支持大小写英文字母、数字以及下划线，请输入正确的附加表名'},
                {fieldLabel:'模型性质',xtype:'radiogroup',id:'systemmodel',cls:'iradiogroup',items:[
					{boxLabel:'自定义模型',name:'issystem',inputValue:0,checked:true},
					{boxLabel:'系统模型',name:'issystem',inputValue:1}
				]},
				this.f.index,this.f.list,this.f.content,
				{fieldLabel:'序号',name:'sort',xtype:'numberfield',value:50,anchor:'50%',style:'margin-bottom:15px'},
				{name:'id',xtype:'hidden'},{name:'status',xtype:'hidden',value:'1'}       
            ]}
		]};  
		this.win=new Ext.Window({id:'dlg-cms-model-editor',title:'',layout:'fit',maximizable:true,minimizable:true,modal:false,
			resizable:true,width:500,height:300,closeAction:'hide',plain:true,
			items:{xtype:'form',layout:'fit',border:false,items:form},
			buttons:[
				{text:'确定',handler:this.submit,scope:this},
				{text:'取消',handler:this.cancel,scope:this}
			]
		});	
		this.win.show();
		this.formPanel = this.win.getComponent(0);
		//for(var i=3;i>0;i--)this.formPanel.getComponent(0).setActiveTab(i);
	
		this.formPanel.form.on('actioncomplete',function(form,action){
			if(action.result.success){alert(action.result.message);if(this.store) this.store.reload();this.win.hide();}
		}, this);
	},
	
	//加载grid数据
	store:function(type){
		return new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.templateListAction + '&cate='+type}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true});
	},
	
	load:function(item){
		Ext.QuickTips.init();
		if(!this.win){this.render();}
		this.baseAction='index.php?M=Model&A=Index';
		this.store = item.store;
		var title = item && item.mode==1 ? (item.params.name ? '修改'+item.params.name+'模型' : '修改模型') : '新建模型';
		
		if(item&&item.params&&item.params.id){
			this.formPanel.form.items.items[1].disable();
			this.formPanel.form.items.items[3].disable();
			if(item.params.id == this.id){
				this.setValue();
			}else{
				this.id = item.params.id;
				this.formPanel.getEl().mask('正在获取模型数据,请稍侯...');
				Ext.Ajax.request({
					url: this.baseAction+'&method=getById',method: 'POST',params:{id:this.id},
					failure:function(response,options){this.formPanel.getEl().unmask();alert("提示","获取数据失败！请重试！");},  
					success:function(r,o){
						this.formPanel.getEl().unmask();
						r=jsonReturn(r);
						if(r.success == 200){
							this.values = r.Data;
							this.setValue();
						}else{
							alert("提示","没有找到对应记录！请重试！");
						}
					},
					scope:this                                 
				});
			}
		}else{
			this.formPanel.form.reset();
			this.formPanel.form.items.items[1].enable();
			this.formPanel.form.items.items[3].enable();
		}
		
		this.win.setTitle(title);
		this.win.show();
	},
	
	setValue:function(){this.formPanel.form.setValues(this.values);},
	submit:function(){
		
		if(!this.formPanel.form.isValid()){
			Ext.MessageBox.show({title:'错误',msg:'请检查红线处的错误提示！',buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});
			return ;
		}
		this.values = this.formPanel.form.getValues();
		if(this.values.ename){
			var re=/^[a-zA-Z0-9_]+$/; 
			if(!re.test(this.values.ename)){
				alert("名字标识只能为英文、数字、下划线，请输入正确的名字标识");
				return ;
			}
		}
		if(this.values.addontable){
			var re=/^[a-zA-Z0-9_]+$/; 
			if(!re.test(this.values.addontable)){
				alert("附加表名称只能为英文、数字、下划线，请输入正确的附加表名称");
				return ;
			}
		}
		var params ={ename:this.formPanel.form.items.items[1].getValue(),issystem:this.formPanel.form.items.items[3].getValue()};
		this.formPanel.form.submit({url:this.baseAction+'&method=add',params:params});	
	},
	validate : function(value,text){
		if(value){
			var re=/^[a-zA-Z0-9_]+$/; 
			if(!re.test(value)){
				alert(text);
			}
		}
	},
	selectNode :function(newNode,allNode,flag){
		if(!newNode.isExpanded()){
			newNode.expand();newNode.expandChildNodes();
		}else{
		    if(!flag){
		        var nodes = newNode.childNodes;
		        for(var i=0;i<nodes.length;i++){
				    for(var j=0;j<allNode.length;j++){
					    if(nodes[i].id==allNode[j]){
						    newNode.childNodes[i].ui.check(true);
						    allNode.splice(j,1);
					    }
						if(!newNode.childNodes[i].leaf) this.selectNode(newNode.childNodes[i],allNode,flag);
				    }
			    }
			}else{
			    for(var i=0;i<newNode.childNodes.length;i++) {
					newNode.childNodes[i].ui.check(false);
					if(!newNode.childNodes[i].leaf) 
					this.selectNode(newNode.childNodes[i],allNode,flag);}
			}
		}
		newNode.on("expand",function(node){
		    if(!flag){
			    var nodes = node.childNodes;
			    for(var i=0;i<nodes.length;i++){
				    for(var j=0;j<allNode.length;j++){
					    if(nodes[i].id==allNode[j]){
						    newNode.childNodes[i].ui.check(true);
						    allNode.splice(j,1);
					    }
						if(!newNode.childNodes[i].leaf) this.selectNode(newNode.childNodes[i],allNode,flag);
				    }
			    }
			}else{
			    for(var i=0;i<node.childNodes.length;i++) {node.childNodes[i].ui.check(false);if(!node.childNodes[i].leaf) this.selectNode(node.childNodes[i],allNode,flag);}
			}
		},this);
	},
	cancel:function(){this.win.hide();}
};