EXCMS.Model.Field={
	baseAction : 'index.php?M=Model&A=Index',	
	init : function(){
	    Ext.QuickTips.init();
	    this.modelid = EXCMS_MODEL_FIELD.modelid;
	    this.view();
		btn = this.FGrid.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				if (btn[i].acl == 'edit') {
					this.disableedit = true;
					this.FGrid.on('beforeedit',function(e){e.cancel = true;},this);
				}
				btn[i].hide();
			}
		}
		for(var i=0;i<this.fieldMenu.items.items.length;i++){
			if(this.fieldMenu.items.items[i].acl&&!excmsacl[this.fieldMenu.items.items[i].acl]){
				this.fieldMenu.items.items[i].hide();
			}
		}
	},
	//初始化UI
	view : function(){
		 this.tree = new Ext.tree.TreePanel({region:'west',title:'模型树',cls:'channel-tree',style:'border-right:1px solid #99BBE8;',bodyStyle:'padding:8px 1px',collapseMode:'mini',collapsible:true,split:true,width:200,minSize:35,maxSize:500,autoScroll:true,rootVisible: true,animate:true,useArrows:true,border:false,
            loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction + '&method=tree'}),
            root:new Ext.tree.AsyncTreeNode({id:'0',text:'模型',cls:'channel-tree-root',expanded:true})
        });
		this.FD = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=fieldstore'}),
			reader : new Ext.data.JsonReader({root:'data',id:'fieldid',totalProperty: 'total',fields: ['fieldid','modelid','formname','fieldname','description','datatype','sort',{name:'issystem',type:'int'}]}),
			remoteSort : true
		});
		this.FGrid = new Ext.grid.EditorGridPanel({
			title:'模型字段管理',enableColumnMove:false,collapsible:true,animCollapse:false,border:false,
			store: this.FD,sm:new Ext.grid.RowSelectionModel(),
			columns : [new Ext.grid.RowNumberer(),
				{header:"字段名称",width:100,menuDisabled:true,sortable:false,dataIndex:'fieldname'},
				{header:"表单文字",width:100,menuDisabled:true,sortable:false,dataIndex:'formname'},
				{header:"数据类型",width:100,menuDisabled:true,sortable:false,dataIndex:'datatype',renderer:this.renderType,scope:this},
				{header:"描述",width:200,menuDisabled:true,sortable:false,dataIndex:'description'},
				{header:"字段类型",width:100,menuDisabled:true,sortable:false,dataIndex:'issystem',renderer:function(v){return v?'系统字段':'扩展字段'}},
				{header:"显示顺序",width:60,menuDisabled:true,sortable:false,dataIndex:'sort',editor:new Ext.form.NumberField({decimalPrecision:0})}
			],
			tbar:[
				{text:'增加',handler:this.editField,scope:this,mode:0,acl:'add'},
				{text:'修改',handler:this.editField,scope:this,mode:1,acl:'edit'},
				{text:'删除',handler:this.delField,scope:this,acl:'delete'},'-',
//				{text:'保存排序',handler:this.saveSort,scope:this,mode:0},
				{text:'显示主表字段',enableToggle:true,toggleHandler: this.mainField,scope:this,mode:0},
				{text:'更新主表缓存',handler:this.updateMainCache,scope:this,mode:0},'-',
				{text:'刷新',handler:function(){this.FD.reload()},scope:this}
			]
		});
		this.fieldMenu = new Ext.menu.Menu({items:[
//          {text:'保存排序',handler:this.saveSort,scope:this,mode:0},'-',
            {text:'增加',handler:this.editField,scope:this,mode:0,acl:'add'},
			{text:'修改',handler:this.editField,scope:this,mode:1,acl:'edit'},
			{text:'删除',handler:this.delField,scope:this,acl:'delete'}
  		]});
		this.FGrid.on('rowclick',function(g,r,e){this.recordField = g.getStore().getAt(r);this.refrashMenu();},this);
		this.FGrid.on('rowcontextmenu',function(g,r,e){
			this.recordField = g.getStore().getAt(r);
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) : stm.selectRow(r);
			this.fieldMenu.showAt(e.getXY());
			this.refrashMenu();
		},this);
		this.FGrid.on('afteredit',this.saveSort,this);
		this.FGrid.on('celldblclick',function(g,r,c,e){if(this.disableedit)return;if(g.getColumnModel().getDataIndex(c)!='sort'&&g.getColumnModel().getDataIndex(c)!=''){this.editField({mode:1});}},this);
		this.FD.setDefaultSort('id','asc');
		this.FD.baseParams = {modelid:this.modelid};
		this.FD.load();
		
		this.tree.on('click',function(n){
			this.currentModel = n;
			this.modelid = n.id;
			this.FGrid.setTitle(n.id > 0 ? n.text+'字段管理' : '模型字段管理');
			this.FD.baseParams = {modelid:this.modelid,showmain:this.showmain};
			this.FD.load();
		},this);
		 this.treeMenu =new Ext.menu.Menu({
			items: [
				{text: '预览',handler:this.viewEditor,scope:this}	
			]
		});	
		this.tree.on('contextmenu',function(n,e){
	    	n.select();
	    	this.currentModel = n;
			this.modelid = n.id;
			this.FGrid.setTitle(n.id > 0 ? n.text+'字段管理' : '模型字段管理');
			this.treeMenu.showAt(e.getXY());
	    },this);
		this.tabPanel = new Ext.TabPanel({id:'tabPanel',region:'center',split:false,border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:this.FGrid});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
		this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});
		this.FGrid.getEl().dom.oncontextmenu = function(){return false}
        this.FGrid.getEl().dom.onselectstart=function(){return false}
		this.tree.getEl().dom.oncontextmenu = function(){return false}
        this.tree.getEl().dom.onselectstart=function(){return false}
	},
	//刷新菜单
	refrashMenu : function(){
		if(this.recordField.get('issystem')){
			this.fieldMenu.items.items[1].disable();this.fieldMenu.items.items[2].disable();
			if(this.recordField.data.modelid==0) this.FGrid.getTopToolbar().items.items[1].disable();else this.FGrid.getTopToolbar().items.items[1].enable();
			this.FGrid.getTopToolbar().items.items[2].disable();
		}else{
			this.fieldMenu.items.items[1].enable();this.fieldMenu.items.items[2].enable();
			this.FGrid.getTopToolbar().items.items[1].enable();this.FGrid.getTopToolbar().items.items[2].enable();
		}
	},
	//编辑字段
	editField : function(item){
		var params={};
		if(item.mode == 1){
            var selected = this.FGrid.getSelectionModel().getSelections();
			if(selected.length !=1){alert('请选择要编辑的字段！');return;}
			if(selected[0].data.modelid==0){alert('系统主表字段不能编辑！'); return ;}
			params.id=selected[0].id;
			params.name=selected[0].data.name;
			params.datatype=selected[0].data.datatype;
			params.issystem = selected[0].data.issystem;
        }
		if(this.modelid){
        	params.modelid = this.modelid;
        }else{
        	alert('请选择模型后再添加字段');
        	return ;
        }
		EXCMS.util.QuickCreate({model:'Model.FieldEditor',mode:item.mode,mainPanel:this.tabPanel,params:params,store:this.FD});
	},
	//保存排序
	saveSort : function(item){
		var records;
		var data=[];
		records = this.FD.getModifiedRecords();
		for(var i=0;i<records.length;i++){
			data.push({fieldid:records[i].data.fieldid,sort:records[i].data.sort});
		}
		if(data.length > 0){
			this.FGrid.el.mask('排序数据保存中,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=sort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data),mode:0},
				success:function(r,o){
					this.FGrid.el.unmask();
					r=jsonReturn(r);
					if (r.success) {
						this.FD.commitChanges();this.FD.reload();
					}
				}
			});
		}
	},
	//删除字段
	delField : function(){
        var selected = this.FGrid.getSelectionModel().getSelections();
        if(selected.length > 0){
           	var idstr="",flag=false;
            for (var i = 0 ; i < selected.length; i++) {if (selected[i].data.issystem) {flag = true;break;} idstr+=selected[i].id+",";}
			if(flag) {Ext.MessageBox.alert('提示','您选择的字段中有系统字段，系统字段不能删除！');return;}
			idstr = idstr.substring(0,idstr.length-1);
            Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
                if(optional=='yes'){
                    Ext.Ajax.request({
                        url: this.baseAction+'&method=fielddelete',
                        method: 'POST', 
                        params:{ids:idstr},
                        failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},  
                        success:function(r,o){
                            r=jsonReturn(r);
                            switch(r.success){
                            	case  200  : alert("删除字段成功"); this.FD.reload();break;
                           	}
                        },
                        scope:this                                 
                    });
                }
                else return
            },this);
        }else Ext.MessageBox.alert('提示','请至少选择一条记录！');
	},
	
	setEditorVisible : function(panel,flag){
	    if(flag){
	        this.tabPanel.unhideTabStripItem(panel);
	        panel.setVisible(true);
	    }else{
	        this.tabPanel.activate(0);
	        this.tabPanel.hideTabStripItem(panel);
	    }
	},
	//预览编辑器
	viewEditor : function(){
		if(this.currentModel && this.currentModel.id > 0){
			var title = this.currentModel.text + ' 编辑器' ;
			var EditorItems;
			this.mask(true,'数据加载中,请稍候');
			Ext.Ajax.request({
	            url: this.baseAction+'&method=geteditor',
	            method: 'POST', 
	            params:{modelid:this.currentModel.id},
	            failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},  
	            success:function(r,o){
	                r = Ext.decode(r.responseText);
					this.modelFields = [];
	                if(r.success){
						this.mask(false);
						if(r.data){
							for(var i=0;i<r.data.length;i++){
								eval("this.modelFields["+i+"]="+r.data[i]+";");
							}
						}
						if(r.mirrorinfo){
							EXCMS.setMirrorInfo(r.mirrorinfo);
						}
						if (this.viewEditorTab) {
							this.tabPanel.hideTabStripItem(this.viewEditorTab);
							Ext.destroy(this.viewEditorTab);
							this.tabPanel.activate(0);
						}
						if (this.modelFields.length > 0) {
							this.viewEditorTab = new Ext.Panel({title: title,layout: 'form',closable: false,autoScroll: true,border: false,bodyStyle: 'padding:10px;',
								items: this.modelFields,
								tbar: [{text: '关闭',handler: function(){this.setEditorVisible(this.viewEditorTab, false)},scope: this}]
							});
							this.tabPanel.add(this.viewEditorTab);
							if (this.tabPanel.activate) {
								this.tabPanel.activate(this.viewEditorTab);
							}
							else 
								if (this.tabPanel.layout.setActiveItem) {
									this.tabPanel.layout.setActiveItem(this.tabPanel.getComponent(1));
								}
						}else alert('当前模型没有自定义字段');
	               	}
	            },
	            scope:this                                 
	        });
		}else{
			alert('请选择模型后再预览!');
		}
	},
	mask:function(flag,msg){if(flag){this.FGrid.getEl().mask(msg)}else{this.FGrid.getEl().unmask()}},
	// 显示/隐藏主表字段
	mainField : function(item){
		this.showmain = item.pressed;
		this.FD.baseParams = {modelid:this.modelid,showmain:this.showmain};
		this.FD.reload();
	},
	// 更新主表字段缓存
	updateMainCache : function(){
		Ext.Ajax.request({
	        url: this.baseAction+'&method=cachemainfield',method: 'POST', 
	        failure:function(response,options){Ext.MessageBox.alert("警告","更新主表字段缓存失败！请联系管理员！");},  
	        success:function(r,o){
	            r=jsonReturn(r);
	            if(r.success){
					alert(r.message);
	           	}
	        },
	        scope:this                                 
	    });
	},
	// 更新内容模型缓存
	updateModelCache : function(){
		Ext.Ajax.request({
	        url: this.baseAction+'&method=cachemodel',method: 'POST', 
	        failure:function(response,options){Ext.MessageBox.alert("警告","更新内容模型缓存失败！请联系管理员！");},  
	        success:function(r,o){
	            r=jsonReturn(r);
	            if(r.success){
					alert(r.message);
	           	}
	        },
	        scope:this                                 
	    });
	},
	renderType: function(v){
		var re = "";
		switch (v) {
			case '0':re = '单行文本';break;
			case '1':re = '多行文本';break;
			case '2':re = 'Html文本';break;
			case '3':re = '整数类型';break;
			case '4':re = '小数类型';break;
			case '5':re = '时间类型';break;
			case '6':re = '图片类型';break;
			case '7':re = '多媒体文件';break;
			case '8':re = '附件类型';break;
			case '9':re = 'Select下拉框';break;
			case '10':re = 'Radio选项卡';break;
			case '11':re = 'Checkbox多选框';break;
			case '12':re = '分类选择';break;
			case '13':re = '图片编辑器';break;
			case '14':re = '下载编辑器';break;
			case '15':re = '视频编辑器';break;
		}
		return re;
	}
};
EXCMS.onReady(EXCMS.Model.Field.init, EXCMS.Model.Field);

