EXCMS.Modules = {
	baseAction : 'index.php?M=Modules&A=Index',
	init:function(){
		Ext.QuickTips.init();
		this.view();
		btn = this.G.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
	},
	view:function(){
		this.D = new Ext.data.Store({
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
			reader:new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'moduleid',
				fields:['moduleid','name','path','version','author','disabled','isdisplaytop','installdate','sort']
            }),
			remoteSort:true
		});
		
		this.soField = new Ext.form.TwinTriggerField({emptyText:'模块名称(支持模糊查询)',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		var menu = {
			'setting' : new Ext.menu.Menu({items:[
				{text:'启用状态',menu:{items:[
					{text:'启用',iconCls:'btnico btn_check',handler:this.setstatus,scope:this,mode:1,type:'setting'},
					{text:'禁用',handler:this.setstatus,scope:this,mode:0,type:'setting'}
				]}},
				{text:'菜单显示',menu:{items:[
					{text:'在菜单中显示',handler:this.setstatus,scope:this,mode:1,type:'settingview'},
					{text:'不在菜单中显示',handler:this.setstatus,scope:this,mode:0,type:'settingview'}
				]}},
				{text:'权限',handler:this.permission,scope:this}
			]})
		};
		this.G = new Ext.grid.EditorGridPanel({enableTabScroll:true,title:'模块列表',
			enableColumnMove:true,animCollapse:false,loadMask:true,
            store:this.D,sm:new Ext.grid.RowSelectionModel(),
			columns:[
                new Ext.grid.RowNumberer(),
				{header:"名称",width:200,sortable:true,dataIndex:'name'},
				{header:"模块路径",width:100,sortable:true,dataIndex:'path'},
				{header:"启用状态",width:80,sortable:true,dataIndex:'disabled',renderer:this.renderStatus,scope:this},
				{header:"菜单显示",width:80,sortable:true,dataIndex:'isdisplaytop',renderer:this.renderDisplay,scope:this},
				{header:"作者",width:180,sortable:true,dataIndex:'author'},
				{header:"版本",width:100,dataIndex:'version'},
				{header:"安装日期",width:150,sortable:true,dataIndex:'installdate'},
				{header:"排序",width:50,sortable:true,dataIndex:'sort',editor:new Ext.form.NumberField({decimalPrecision:0})}
            ],
			tbar:new Ext.Toolbar({items:[
                {text:'访问',iconCls:'btnico btn_preview',handler:this.access,scope:this},
				{text:'安装',iconCls:'btnico btn_add',handler:this.installModule,scope:this,acl:'installModule'},
				{text:'卸载',iconCls:'btnico btn_del',handler:this.uninstall,scope:this,acl:'uninstall'},
				{text:'保存排序',handler:this.updateSort,scope:this},
				{text:'设置',menu:menu['setting'],acl:'setting'},'-',
				{text:'查看模块帮助文档',handler:this.help,scope:this},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this}
				,'->','搜索 ',this.soField
            ]}),bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
                
        this.gridMenu = new Ext.menu.Menu({items:[
        	{text:'访问',icon:ico,iconCls:'ico preview',handler:this.access,scope:this},'-',
			{text:'安装新模块',icon:ico,iconCls:'ico add',handler:this.installModule,scope:this,acl:'installModule'},
			{text:'卸载',icon:ico,iconCls:'ico del',handler:this.uninstall,scope:this,acl:'uninstall'},'-',
			{text:'设置',menu:menu['setting'],acl:'setting'},'-',
			{text:'查看模块帮助文档',handler:this.help,scope:this}
        ]});
         this.D.load({params:{start:0,limit:25}});
         this.tree = new Ext.tree.TreePanel({
        	region:'west',margins:'0 0 3 5',collapsible:false,split:true,width:200,minSize:35,title:'常用模块',autoScroll:true,rootVisible:false,lines:false,cls:'grouptree',bodyStyle:'padding:6px',
			loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=modulelist'}),
			root:new Ext.tree.AsyncTreeNode({id:'0',expanded:true})
        });
		this.tabPanel = new Ext.TabPanel({xtype:'tabpanel',region:'center',border:false,margins:'0 3 3 0',style:'border:1px solid #99BBE8;border-width:0px 1px 1px 1px',activeTab:0,enableTabScroll:true,items:this.G});
        this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});

		this.G.on('rowclick',function(g,r,e){this.record=this.D.getAt(r)},this);
        this.G.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!= -1?stm.selectRow(r,true):stm.selectRow(r);
			this.gridMenu.showAt(e.getXY());
		},this);
		this.G.getEl().dom.oncontextmenu = function(){return false;}
        this.G.getEl().dom.onselectstart=function(){return false}
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams={key:""};      
		this.D.reload();   
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue('').trim();
	    if(key != ''){
			this.D.baseParams = {key:key};         
	        this.D.reload();
	    }
	},
	installModule : function(){
		this.step1 = new Ext.FormPanel({xtype: 'form',id: 'card-form-step1',title:'第一步:输入模块目录',autoScroll:true,border:false,
			layout:'absolute',bodyStyle:'padding:10px 0px 0px 10px;',
			items:[{x:5,y: 17,width:70,xtype: 'label',text: '模块目录：'},
				{x:75,y:10,width:200,name:'module_dir',xtype:'textfield', allowBlank:false,blankText:'模块目录不能为空'},
				{xtype:'button',text:'下一步', style:'margin-top:10px;margin-left: 275px;',listeners:{click:function(obj,e){this.next()},scope:this}}]
		});

		var name = 'iframe-' + Ext.id();
		this.step2 =  new Ext.Panel({id:'card-form-step2',border:false,autoScroll:true,
			html:'<iframe name="'+name+'" src="" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
		});
		this.contentPanel = new Ext.Panel({
			title:'安装模块',
			id: 'content-panel',
			region: 'center', // this is what makes this panel into a region within the containing layout
			layout: 'card',
			margins: '2 5 5 0',
			activeItem: 0,
			border: false,
			closable:true,
			items: [
				this.step1,this.step2
			]
		});
		this.tabPanel.add(this.contentPanel);
		this.tabPanel.activate(this.contentPanel);

		Ext.getCmp('content-panel').layout.setActiveItem('card-form-step1');
	},
	next : function(){
		if(!this.step1.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return }
		Ext.getCmp('content-panel').layout.setActiveItem('card-form-step2');
		var iframe = this.tabPanel.getActiveTab().el.dom.getElementsByTagName('iframe')[0];
		var module_dir = this.step1.form.getValues().module_dir;
		iframe.src = '../'+module_dir+'/install/index.php';
	},
	uninstall : function(){
		this.record = this.G.getSelectionModel().getSelected();
		if(this.record&&this.record.id){
			Ext.MessageBox.confirm('提示','您确实要卸载该模块吗？', function(optional){
	           if(optional=='yes'){
	           	   this.G.getEl().mask('正在卸载模块,请稍后...');
	               Ext.Ajax.request({
	                    url: this.baseAction+"&method=uninstall",method: 'POST',params:{moduleid:this.record.id},
	                    failure:function(response,options){this.G.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
	                    success:function(response,options){
	                    	this.G.getEl().unmask();
	                    	var r=jsonReturn(response);
	                    	alert(r.message);
	                    	if(r.success) {
	                    		this.D.reload();
	                    		this.tree.root.removeChild(this.tree.getNodeById(this.record.id));
	                    	}
	                    },scope:this
	               },this);
	           }
	           else return
	       },this);
		}else{
			alert('请选择要卸载的模块');
		}
	},
	//设置状态
	setstatus : function(item){
		var url,field;
		if(item.type=='setting'){	//设置模块是否启用状态
			url = this.baseAction+"&method=setting";
			field ='disabled';
		}else if(item.type='settingview'){	//设置是否显示顶级菜单
			url = this.baseAction+"&method=settingview";
			field ='isdisplaytop';
		}
		var selected = this.G.getSelectionModel().getSelections();
	    if(selected.length==0){alert('请选择要设置的模块！');return;}
	    var ids =[];
        for (var i=0,len=selected.length;i<len;i++){ids.push(selected[i].id)}
	 	this.G.getEl().mask('正在设置模块,请稍后...');
		Ext.Ajax.request({
            url: url,method: 'POST',params:{id:ids.join(','),status:item.mode},
            failure:function(response,options){this.G.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
            success:function(response,options){
            	this.G.getEl().unmask();
            	var r=jsonReturn(response);
            	if(r.success) {
            		for(var i=0;i<ids.length;i++) this.D.getById(ids[i]).set(field,item.mode ? 1 : 0);
				    this.D.commitChanges();
            	}
            },scope:this
       },this);
	},
	help : function(){
		this.record = this.G.getSelectionModel().getSelected();
		if(this.record&&this.record.id){
			this.panel =  new Ext.Panel({title:this.record.data.name+'_帮助',border:false,autoScroll:true,closable:true,
				html:'<iframe name="iframe-module-help" src="" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
			});
			this.tabPanel.add(this.panel);
			this.tabPanel.activate(this.panel);
			var iframe = this.tabPanel.getActiveTab().el.dom.getElementsByTagName('iframe')[0];
			iframe.src = "Modules/Modules/"+this.record.data.moduleid+"/"+this.record.data.moduleid+".html";
		}else{
			alert("请选择要查看的模块帮助文档");
		}
	},
	//访问
	access : function(item){
		this.record = this.G.getSelectionModel().getSelected();
		if(this.record&&this.record.id){
			var panel =  new Ext.Panel({title:this.record.data.name,border:false,autoScroll:true,closable:true,mask:'正在加载模块,请稍后...',
				html:'<iframe name="iframe-module-access" src="" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
			});
			this.tabPanel.add(panel);
			this.tabPanel.activate(panel);
			var iframe = this.tabPanel.getActiveTab().el.dom.getElementsByTagName('iframe')[0];
			iframe.src = 'index.php?M=Modules&EM='+this.record.data.moduleid;
		}else{
			alert("请选择要查看的模块");
		}
	},
	updateSort : function(){
		var records = this.D.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			this.G.getEl().mask('正在保存排序,请稍后...');
			Ext.Ajax.request({url:this.baseAction+'&method=updateSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.G.getEl().unmask();},
				success:function(r,o){
					this.G.getEl().unmask();
					r=jsonReturn(r);
					if (r.success) {
						for(var i=0;i<data.length;i++) this.D.getById(data[i].id).set('sort',data[i].sort);
				   		this.D.commitChanges();
					}
				}
			});
		}else{
			alert("已更新到最新数据");
		}
	},
	renderDisplay :function(v){return v == 0 ?'<span style="color:red;">否</span>':'<span style="color:green;">是</span>';},
	renderStatus :function(v){return v == 0 ?'<span style="color:red;">禁用</span>':'<span style="color:green;">启用</span>';}
};
EXCMS.onReady(EXCMS.Modules.init,EXCMS.Modules);