EXCMS.Modules.Comment={
	baseAction : 'index.php?M=Modules&EM=comment&A=Index',
	modulesAction : 'index.php?M=Modules&A=Index&moduleid=comment',
	init:function(){
	    Ext.QuickTips.init();
	    this.render();
		
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
	},
	active:function(o){
		switch(o){
			case 'setting':
				this.settingsTab();
				break;
			case 'stat':
				this.stat();
				break;
			case 'help':
				this.helpTab();
				break;
			case 'main':
				this.tabPanel.activate(this.commentPanel);
				break;
		}
	},
	render:function(){
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
			items:{xtype:'panel',title:'评论管理',contentEl:'comment-action',collapsible:true,style:'margin-bottom:5px'}
		});
		var menu = {
			'check' : new Ext.menu.Menu({items:[
				{text:'通过',icon:ico,iconCls:'ico check',handler:this.check,scope:this,mode:1},
				{text:'不通过',handler:this.check,scope:this,mode:2}
			]}),
			'display' : new Ext.menu.Menu({items:[
				new Ext.menu.CheckItem({text:'所有评论',group:'dispalyMode',checked:true,handler:this.displayMode,scope:this,mode:3}),
				new Ext.menu.CheckItem({text:'未审核',group:'dispalyMode',handler:this.displayMode,scope:this, mode:0}),
				new Ext.menu.CheckItem({text:'未通过',group:'dispalyMode',handler:this.displayMode,scope:this, mode:2}),
				new Ext.menu.CheckItem({text:'已通过',group:'dispalyMode',handler:this.displayMode,scope:this, mode:1})
			]}),
			'select' : new Ext.menu.Menu({items:[
				{text:'全选',handler:this.recordsSelect,scope:this,mode:1},
				{text:'反选',handler:this.recordsSelect,scope:this,mode:2},
				{text:'取消选择',handler:this.recordsSelect,scope:this, mode:3}
			]})
		};
		this.D = new Ext.data.Store({
            reader: new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'commentid',fields:['title','membername','createddate','ip','content','checked','support','against','commentid','itemid','reviewer']}),
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),remoteSort:false
        });
		this.soField = new Ext.form.TwinTriggerField({emptyText:'评论内容',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
	    this.grid = new Ext.grid.GridPanel({
			region:'center',store:this.D,enableColumnMove:false,collapsible:true,animCollapse:false,border:true,
			sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true, autoExpandColumn:1,
	        columns: [
				{header:"ID",width:60,sortable:true,dataIndex:'commentid'},
	            {header:'评论内容',width:200, sortable:true, dataIndex:'content',renderer:this.rendererCmt,scope:this},
	            {header:'内容标题',width:250,sortable:true,dataIndex:'title'},
	            {header:'审核',width:50,sortable:true, dataIndex:'checked',renderer:this.renderStatus,scope:this},
				{header:'评论者',width:70,sortable:true,dataIndex:'reviewer'},
              	{header:'支持',width:60,align:'right',sortable:true,dataIndex:'support'},
              	{header:'反对',width:60,align:'right',sortable:true,dataIndex:'against'},
				{header:'评论时间',width:110,sortable:true,dataIndex:'createddate'}
	        ],
            bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
	    });
        
		this.gridMenu = new Ext.menu.Menu({items:[
 			{text:'浏览原文',icon:ico,iconCls:'ico preview',handler:this.browse,scope:this},
			{text:'查看相关评论',handler:this.view,scope:this},
            {text:'删除',icon:ico,iconCls:'ico delete',handler:this.del,scope:this},
			{text:'审核',menu:menu['check']},
			{text:'推荐',handler:this.setRecommend,scope:this},'-',
			{text:'显示',menu:menu['display']}
        ]});
		
        this.grid.on('rowdblclick', function(g,r,e){this.view();},this);
		this.grid.on('rowclick', function(g,r,e){this.currentId = g.getStore().getAt(r).id;},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			var stm = g.getSelectionModel();
            stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) :stm.selectRow(r);
            this.gridMenu.showAt(e.getXY());
		},this);
		
		this.commentPanel = new Ext.Panel({title:'评论管理',layout:'border',border:false,
			tbar:[
				{text:'浏览原文',iconCls:'btnico btn_preview',handler:this.browse,scope:this},
	            {text:'删除',iconCls:'btnico btn_del',handler:this.del,scope:this},
				{text:'审核',menu:menu['check']},
				{text:'推荐',handler:this.setRecommend,scope:this},
	            {text:'显示',menu:menu['display']},'-',
				{text:'选择',menu:menu['select']},
	            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
				'->','搜索 ',this.soField
			],
			items:this.grid
		});
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.commentPanel});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
        new Ext.Viewport({layout:'border',items:[actionPanel,this.tabPanel]});
		var request={start:0,limit:25};
		this.D.baseParams = {checked:3,contentid:contentid};
        this.D.load({params:request});
	},
	
	recordsSelect :function(item){
		 var mode = item && item.mode ? item.mode :1;
		 switch(item.mode){
			 case 1 :this.grid.getSelectionModel().selectAll(); break;
			 case 2:for (var i = 0; i < this.D.getCount(); i++) this.grid.getSelectionModel().isSelected(i) ? this.grid.getSelectionModel().deselectRow(i) :this.grid.getSelectionModel().selectRow(i, true);break;
			 case 3 :this.grid.getSelectionModel().clearSelections(); break;
		 }
	},
	//显示模式
	displayMode:function(item){
	    this.displayItemMode = item.mode;
	    this.D.baseParams.channelid= (this.currentNode && this.currentNode.id ? this.currentNode.id : 0);
	    this.D.baseParams.checked=item.mode;
		this.D.reload();
	},
	//取消搜索
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams = {channelid:0,contentid:0,checked:3,keywords:''};
		this.D.reload();
	},
	//搜索
	soOnTrigger2Click:function(){
	    var keywords = this.soField.getValue().trim();
	    if(keywords != ''){
	        this.D.baseParams.keywords = keywords;
	        this.D.reload();
	    }
	},
	//浏览原文
	browse : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(selected.length != 1){
			alert('请选择一个评论！');return;
		}
		EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'content',id:selected[0].data.itemid});
	},
	//查看评论
	view : function(){
		return;
		var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length <1){
			alert('请选择一个评论！');return;
        }else{
            title ="查看文章‘"+ this.grid.getSelectionModel().getSelected().get("title") + "’的评论";
		}
	    if(!this.CommentWindow){
            this.CommentForm = new Ext.FormPanel({region:'center',autoScroll:true,border:false,bodyStyle:'padding:10px;',defaults:{anchor:'98%'},labelWidth:70,url:this.baseAction+'&method=update',                
                items: [
					{xtype:'hidden',name:'commentid'},
                    {layout:'form',border:false,defaults:{anchor:'95%'},labelWidth:70,defaultType:'textfield',items:[
                        {fieldLabel:'文章ID',name:'contentid',disabled:true}
                    ]},
                    {layout:'form',border:false,defaults:{anchor:'95%'},labelWidth:70,defaultType:'textfield',items:[
                        {fieldLabel:'文章标题',name:'contenttitle',disabled:true}
                    ]},
                    {layout:'form',border:false,defaults:{anchor:'95%'},labelWidth:70,defaultType:'textfield',items:[
                        {fieldLabel:'评论人',name:'membername',disabled:true}
                    ]},
                    {layout:'form',border:false,defaults:{anchor:'95%'},labelWidth:70,defaultType:'textfield',items:[
                        {fieldLabel:'评论IP',name:'ip',disabled:true}
                    ]},
                    {layout:'form',border:false,defaults:{anchor:'95%'},labelWidth:70,defaultType:'textfield',items:[
                        {fieldLabel:'评论时间',name:'createddate',disabled:true}
                    ]},
					{fieldLabel:'评论内容',name:'content',anchor:'93%',xtype:'textarea',height:80},
					{fieldLabel:'管理员回复',name:'messages',anchor:'93%',xtype:'textarea',height:100}
                 ]
            });
            this.CommentWindow = new Ext.Window({id:'excms-window-comment-editor',layout:'fit',minimizable:true,modal:true,resizable:false,width:500,height:400,closeAction:'hide',plain: true,
                items: this.CommentForm,
                buttons: [{text:'确定',handler: function(){this.CommentForm.form.submit({params:{act:"message"}});},scope:this,mode:0},{text: '取消',handler: function(){this.CommentWindow.hide();},scope:this}]
            });
            this.CommentForm.form.on('actioncomplete',function(form,action){
            	alert(action.result.message);
                if(action.result.success){
                	this.D.reload();
                }
                this.CommentWindow.hide();
            }, this);
            this.CommentForm.form.on('actionfailed',function(f,a){alert('请求服务失败');}, this);
	    }
		this.CommentForm.form.reset();
        this.CommentWindow.setTitle(title);
        this.CommentWindow.show(this);
		this.loadCommentData();
	},
	
	//加载评论信息
	loadCommentData : function(){
		 this.CommentForm.el.mask('评论数据加载中...');
		 Ext.Ajax.request({
            url: this.baseAction+'&method=getById',
            method: 'POST', 
            params:{commentid:this.currentId},
            failure:function(response,options){this.CommentForm.el.unmask();alert("请求服务失败");},  
            success:function(response,options){
            	this.CommentForm.el.unmask();
                var r=jsonReturn(response);
			 	if(r.success){
			 		this.CommentForm.form.setValues(r.Data);
			 	}
            },
			scope:this                                    
        });
	},
	//删除评论
	del : function(){
       var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
           	var idstr="";
            for (var i = 0, len = selected.length; i < len; i++) {idstr+=selected[i].id+",";}
			idstr = idstr.substring(0,idstr.length-1);
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
               if(optional=='yes'){
               	   this.grid.getEl().mask('评论数据加载中...');
                   Ext.Ajax.request({
                        url: this.baseAction+"&method=delete",method: 'POST',params:{commentids:idstr},
                        failure:function(response,options){this.grid.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
                        success:function(response,options){
                        	this.grid.getEl().unmask();var r=jsonReturn(response);if(r.success) this.D.reload();
                        },scope:this
                   });
               }
               else return
           }.createDelegate(this));
         }else alert('请至少选择一条记录！');
	},	
	//审核评论
	check : function(item){
		var selected = this.grid.getSelectionModel().getSelections();
	    if(selected.length == 0){
	    	alert('请至少选择一条记录！');
	    	return;
		}
	    var ids = splitstr = '';
        for (var i = 0, len = selected.length; i < len; i++) {ids += splitstr+selected[i].id;splitstr = ","}
        this.grid.getEl().mask('审核评论中...');
	    Ext.Ajax.request({
            url: this.baseAction+'&method=check',
            method: 'POST', 
            params:{commentids:ids,status:item.mode},
            failure:function(response,options){this.grid.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
            success:function(r,o){
            	this.grid.getEl().unmask();
                r=jsonReturn(r);
                if(r.success){
                	for(var i=0;i<selected.length;i++) this.D.getById(selected[i].id).set('checked',item.mode);
                	this.D.commitChanges();
                }
                else alert(r.message);
            },
            scope:this                                 
        });
	},
	//评论推荐
	setRecommend:function(){
		var  r = this.grid.getSelectionModel().getSelections();
		if(!r.length){
			alert('请选择要推荐的内容');
			return ;
		}else if(r.length>1){
			alert('每次只能推荐一篇评论');
			return ;
		}
		if(!this.recommendDialog){
			this.recommendradiogroup = new Ext.form.RadioGroup({fieldLabel:'推荐类型',cls:'iradiogroup',items:[
				{boxLabel:'头条',name:'recommendid',inputValue:1},
				{boxLabel:'推荐',name:'recommendid',inputValue:2,checked:true}
			]}),
			this.recommendForm = new Ext.form.FormPanel({labelWidth:70,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'commentid',xtype:'hidden'},{name:'itemid',xtype:'hidden'},{name:'type',xtype:'hidden'},
					this.recommendradiogroup,
					{fieldLabel:'标题',name:'rmdtitle',allowBlank:false,blankText:'标题不能为空'},
					{xtype:'textarea',fieldLabel:'描述',name:'rmddescription',height:80}
				]});
			this.recommendDialog=new Ext.Window({layout:'fit',title:'推荐评论',modal:false,resizable:false,width:400,height:240,closeAction:'hide',plain: true,
                items:this.recommendForm,
                buttons:[{text:'取消推荐',handler:this.removeRecommend,scope:this,disabled:true},{text:'推荐',handler:this.saveRecommend,scope:this},{text:'关闭',handler:function(){this.recommendDialog.hide()},scope:this}]
            });
			this.recommendForm.form.on('actioncomplete',function(form,action){if(action.result.success){alert(action.result.message);this.recommendDialog.hide();this.refreshRecommend();}},this);
			this.recommendDialog.show();
		}
		this.recommendForm.form.reset();
		this.recommendForm.getEl().mask('正在获取推荐数据,请稍侯...');
		Ext.Ajax.request({
			url: this.baseAction + '&method=getrmdById',method:'post',params:{commentid:r[0].data.commentid},
			success:function(res,o){
				this.recommendForm.getEl().unmask();res=jsonReturn(res);
				if(res.success){
					if (res.exsits) {
						this.recommendForm.form.setValues(res.data);
						this.recommendForm.items.items[2].setValue(1);
						this.recommendDialog.buttons[0].enable();
					}else {
						this.recommendForm.items.items[0].setValue(r[0].data.commentid);
						this.recommendForm.items.items[1].setValue(r[0].data.itemid);
						this.recommendForm.items.items[2].setValue(0);
						this.recommendDialog.buttons[0].disable();
					}
				}
			},
			failure:function(){this.formPanel.getEl().unmask()},
			scope:this
		});
		this.recommendDialog.show();
	},
	//刷新列表显示推荐
	refreshRecommend : function(){
		
	},
	//删除推荐内容
	removeRecommend : function(){
		var  r = this.grid.getSelectionModel().getSelections();
		Ext.Ajax.request({
			url: this.baseAction + '&method=removermd',method:'post',params:{commentid:r[0].data.commentid},
			success:function(res,o){
				this.recommendForm.getEl().unmask();res=jsonReturn(res);
				alert(res.message);
				this.recommendDialog.hide();
			},
			failure:function(){this.formPanel.getEl().unmask()},
			scope:this
		});
	},
	
	saveRecommend : function(){
		if(!this.recommendForm.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.recommendForm.form.submit({url:this.baseAction+"&method=recommend"});
	},
	//评论设置
	settingsTab : function(){
		if(!this.settingGrid){
			this.settingD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.modulesAction+'&method=settingStore'}),
	            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
	                fields:["id","name","moduleid","_moduleid","value","group","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'}]
	            }),remoteSort:false
	        });
			this.settingGrid = new Ext.grid.EditorGridPanel({title:'评论设置',store:this.settingD,closable:true,closeAction:'hide',
				minColumnWidth:2,autoExpandColumn:3,border:false,sm:new Ext.grid.RowSelectionModel(),
	            columns:[
					new Ext.grid.RowNumberer(),
					{header:"变量名",width:150,sortable:true,dataIndex:'name'},
					{header:"变量值",width:220,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
					{header:"描述",width:150,sortable:true,dataIndex:'description'},
					{header:"数据类型",width:80,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
					{header:"系统变量?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
					{header:'排序',width:60,sortable:true,align:'right',dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
				],
				tbar:[
					{text:'新建',iconCls:'btnico btn_add',handler:this.editSetting,scope:this,mode:0},
					{text:'编辑',iconCls:'btnico btn_edit',handler:this.editSetting,scope:this,mode:1},
					{text:'删除',iconCls:'btnico btn_del',handler:this.delSetting,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.settingD.reload()},scope:this}
				]
			});
			
			this.settingGridMenu = new Ext.menu.Menu({items:[
	            {text:'新建',icon:ico,iconCls:'ico add',handler:this.editSetting,scope:this,mode:0},
	            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editSetting,scope:this,mode:1},
	            {text:'删除',icon:ico,iconCls:'ico del',handler:this.delSetting,scope:this}
	        ]}); 
			
			this.settingGrid.on('celldblclick',function(g,r,c,e){if(c!=6){this.settingRecord=this.settingD.getAt(r);this.editSetting({mode:1});}},this);
			this.settingGrid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.settingRecord=this.settingD.getAt(r);this.settingGridMenu.showAt(e.getXY())},this);
			this.settingGrid.on('afteredit',this.saveSettingSort,this);
			this.tabPanel.add(this.settingGrid);
			this.tabPanel.activate(this.settingGrid);
			this.settingGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.settingGrid.getEl().dom.onselectstart = function(){return false;}
	        this.settingD.load();
		}
		this.tabPanel.unhideTabStripItem(this.settingGrid);
		this.tabPanel.activate(this.settingGrid);
	},
	
	editSetting : function(item){
		var title;
		if(item.mode==1){
			this.settingRecord = this.settingGrid.getSelectionModel().getSelected();
			if(this.settingRecord){title ='修改 '+ this.settingRecord.get('name');}else{alert('请选择要编辑的变量');return ;}
		}else{title='新建变量';}
		if(!this.editSettingWin){
				this.settingformPanel = new Ext.form.FormPanel({labelWidth:60,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
					{fieldLabel:'变量名',name:'name',allowBlank:false,blankText:'变量名不能为空'},
					{fieldLabel:'变量类型',xtype:'radiogroup',items:[
						{boxLabel:'布尔型',name:'type',inputValue:1},
						{boxLabel:'数字',name:'type',inputValue:2},
						{boxLabel:'文本',name:'type',inputValue:3,checked:true},
						{boxLabel:'多行文本',name:'type',inputValue:4}
					]},
					{fieldLabel:'变量值',xtype:'radiogroup',items:[
						{boxLabel:'是',name:'value',inputValue:1,checked:true},
						{boxLabel:'否',name:'value',inputValue:0}
					]},
					{fieldLabel:'变量值',name:'value1',xtype:'numberfield'},
					{fieldLabel:'变量值',name:'value2'},
					{fieldLabel:'变量值',name:'value3',xtype:'textarea'},
					{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
					{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'}
				]});
				
	            this.editSettingWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:330,closeAction:'hide',plain: true,
	                items:this.settingformPanel,
	                buttons:[{text:'确定',handler:this.saveSetting,scope:this},{text:'取消',handler:function(){this.editSettingWin.hide()},scope:this}]
	            });
	            this.settingformPanel.form.on('actioncomplete',function(form,action){
	                if(action.result.success){this.editSettingWin.hide();this.settingD.reload();}
	            }, this);
		}
		this.editSettingWin.setTitle(title);
		this.editSettingWin.show();
		this.settingformPanel.form.items.items[3].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);

		if(item.mode==1){
			var data = this.settingRecord.data;
        	this.settingformPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.settingformPanel.form.reset();
			this.setDisabled();
			this.setVisible(3);
		}
	},
	
	saveSetting : function(){
		if(!this.settingformPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		var act = this.settingformPanel.form.items.items[0].getValue() == '' ? '&method=settingInsert' : '&method=settingUpdate';
		var type = this.settingformPanel.form.items.items[3].getValue();
		var name = this.settingformPanel.form.items.items[2].value;
		this.settingformPanel.form.submit({url:this.modulesAction+act,params: {type: type,name: name}});
	},
	
	saveSettingSort : function(){
		var records = this.settingD.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({url:this.modulesAction+'&method=updateSettingSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){alert("保存排序出错，请重试");},
				success:function(r,o){
					r=jsonReturn(r);
					if (r.success) {
						this.settingD.commitChanges();
					}
				}
			});
		}
	},
	
	//删除系统变量
	delSetting:function(){
        var records = this.settingGrid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的变量');
			return ;
		}
        if(flag){alert('模块系统变量不允许删除！');return;}
       	if(confirm('您确实要删除选定的记录吗？')){
			Ext.Ajax.request({
				url:this.modulesAction + '&method=settingDelete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.settingD.reload();}
				}
			});
        }
	},
	
	setDisabled : function(issystem){
		for(var i=1;i<4;i++){
			this.settingformPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	
	renderType:function(v){var d=['布尔型','数字','文本','多行文本'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red>是</font>':'<font color=green>否</font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'>是</font>":"<font color='red'>否</font>"):v},
	
	//设置显示变量类型
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 3) == i ? '' : 'none';
		}
	},
	
	setValue:function(type, value){
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].setValue((type + 3) == i ? value : '');
		}
	},
	
	//评论帮助
	helpTab : function(){
		if(!this.helpPanel){
			var html = '<iframe src="Modules/Modules/comment/comment.html" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>';
			this.helpPanel = new Ext.Panel({title:'帮助',border:false,autoScroll:true,closable:true,closeAction:'hide',html:html});
			this.tabPanel.add(this.helpPanel);
		}
		this.tabPanel.unhideTabStripItem(this.helpPanel);
		this.tabPanel.activate(this.helpPanel);
	},
	renderStatus:function(v){var r=['<span class="ccheck_u" title="未经审核"></span>','<span class="ccheck" title="已审核"></span>','<span class="ccheck_n" title="审核未通过"></span>'];return r[v>(r.length-1)?0:(v<0?0:v)]},
	rendererCmt:function(v){
		v = v.replace(/<\/?\w+((\s+\w+(\s*=\s*(?:".*?"|\'.*?\'|[^\'">\s]+))?)+\s*|\s*)\/?>/g, '');
		v = v.replace("\n",'');
		v = v.replace("\r",'');
		if(v.length > 50){v = v.substr(0,50) + '...';}
		return v;
	},
	//评论统计
	stat : function(){
		if(!this.statGrid){
			this.statD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=statStore'}),
	            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
	                fields:["itemid","item","type","channelid","topid","modelid","total","actor","checked","lastdate"]
	            }),remoteSort:false
	        });
			this.statGrid = new Ext.grid.EditorGridPanel({title:'评论统计',store:this.statD,closable:true,closeAction:'hide',
				border:false,sm:new Ext.grid.RowSelectionModel(),loadMask:true,
	            columns:[
					new Ext.grid.RowNumberer(),
					{header:"评论主体",width:360,sortable:true,dataIndex:'item',scope:this},
					{header:"评论类型",width:100,sortable:true,dataIndex:'type',scope:this},
					{header:"评论总数",width:80,sortable:true,dataIndex:'total',scope:this},
					{header:"参与总数",width:80,sortable:true,dataIndex:'actor',scope:this},
					{header:"审核总数",width:80,sortable:true,dataIndex:'checked',scope:this},
					{header:'最后评论时间',width:150,sortable:true,dataIndex:'lastdate'}
					//{header:'排序',width:60,sortable:true,align:'right',dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
				],
				
				tbar:[
					{text:'浏览原文',iconCls:'btnico btn_preview',handler:this.browseStat,scope:this},
					{text:'删除',iconCls:'btnico btn_del',handler:this.delStat,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.statD.reload()},scope:this}
				],
				bbar:new Ext.PagingToolbar({pageSize:25,store:this.statD,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
			});
			
			this.statMenu = new Ext.menu.Menu({items:[
	            {text:'浏览原文',iconCls:'btnico btn_preview',handler:this.browseStat,scope:this},
				{text:'删除',iconCls:'btnico btn_del',handler:this.delStat,scope:this}
	        ]}); 
			
			this.statGrid.on('celldblclick',function(g,r,c,e){if(c!=6){this.statRecord=this.statD.getAt(r);}},this);
			this.statGrid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.statRecord=this.statD.getAt(r);this.statMenu.showAt(e.getXY())},this);
			this.statGrid.on('afteredit',this.saveStatSort,this);
			this.tabPanel.add(this.statGrid);
			this.tabPanel.activate(this.statGrid);
			this.statGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.statGrid.getEl().dom.onselectstart = function(){return false;}
			this.statD.load({params:{start:0,limit:25}});
		}
		this.tabPanel.unhideTabStripItem(this.statGrid);
		this.tabPanel.activate(this.statGrid);
	},
	//删除评论
	delStat : function(){
       var selected = this.statGrid.getSelectionModel().getSelections();
	   var data=[];
        if(selected.length > 0){
			for(var i=0,len=selected.length;i<len;i++){
				if(selected[i].get('id')==''){this.D.remove(selected[i]);continue;}
				data.push({"itemid":selected[i].get('itemid'),"type":selected[i].get('type')});
			}
	   		Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？', function(optional){
               if(optional=='yes'){
               	   this.grid.getEl().mask('评论数据加载中...');
                   Ext.Ajax.request({
                        url: this.baseAction+"&method=deleteStat",method: 'POST',params:{data:Ext.encode(data)},
                        failure:function(response,options){this.statGrid.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
                        success:function(response,options){
                        	this.grid.getEl().unmask();var r=jsonReturn(response);if(r.success) this.statD.reload();
                        },scope:this
                   });
               }
               else return
           }.createDelegate(this));
         }else alert('请至少选择一条记录！');
	},	
	//浏览原文
	browseStat : function(){
		var selected = this.statGrid.getSelectionModel().getSelections();
		if(selected.length != 1){
			alert('请选择一个评论！');return;
		}
		EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'content',id:selected[0].data.itemid});
	}
};
EXCMS.onReady(EXCMS.Modules.Comment.init,EXCMS.Modules.Comment);