EXCMS.Modules.Digg={
	baseAction : 'index.php?M=Modules&EM=digg&A=Index',
	init:function(){
	    Ext.QuickTips.init();
	    this.render();
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
		this.tree.getEl().dom.oncontextmenu = function(){return false;}
        this.tree.getEl().dom.onselectstart = function(){return false;}
	},
	render:function(){
		var menu = {
			'display' : new Ext.menu.Menu({items:[
				new Ext.menu.CheckItem({text:'栏目下所有内容',group:'showChannel',checked:true,handler:this.show,scope:this,mode:0}),
				new Ext.menu.CheckItem({text:'当前栏目内容',group:'showChannel',handler:this.show,scope:this, mode:1}),'-',
				new Ext.menu.CheckItem({text:'总关注度排行',group:'show',handler:this.show,scope:this,mode:0,checked:true}),
				new Ext.menu.CheckItem({text:'今日关注度排行',group:'show',handler:this.show,scope:this,mode:1}),
				new Ext.menu.CheckItem({text:'本周关注度排行',group:'show',handler:this.show,scope:this,mode:2}),
				new Ext.menu.CheckItem({text:'本月关注度排行',group:'show',handler:this.show,scope:this,mode:3})
			]}),
			'select' : new Ext.menu.Menu({items:[
				{text:'全选',handler:this.recordsSelect,scope:this,mode:1},
				{text:'反选',handler:this.recordsSelect,scope:this,mode:2},
				{text:'取消选择',handler:this.recordsSelect,scope:this, mode:3}
			]})
		};
		this.D = new Ext.data.GroupingStore({
            reader: new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'contentid',fields:['contentid','title','channelname','username','publishdate','digg','trample','daydigg','daytrample','weekdigg','weektrample','monthdigg','monthtrample']}),
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'})
        });
		this.soField = new Ext.form.TwinTriggerField({emptyText:'ID icanid 标题 关键字',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
	    this.grid = new Ext.grid.GridPanel({title:"Digg管理",region:'center',store:this.D,enableColumnMove:false,collapsible:true,animCollapse:false,
			sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true,autoExpandColumn:1,autoExpandMin:200,
	        tbar:[
				{text:'浏览',iconCls:'btnico btn_preview',handler:this.browse,scope:this},
	            {text:'清空',iconCls:'btnico btn_del',handler:this.del,scope:this},
	            {text:'显示',menu:menu['display']},'-',
				{text:'选择',menu:menu['select']},
	            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},'-',
				{text:'帮助',handler:this.helpTab,scope:this},
				'->','搜索 ',this.soField
			],
			columns: [
				{header:'ID',width:50,sortable:false,dataIndex:'contentid'},
	            {header:'标题',width:150,sortable:false,dataIndex:'title'},
	            {header:'所属栏目',width:100, sortable:false, dataIndex:'channelname',scope:this},
              	{header:'顶',width:50,align:'right',sortable:false,dataIndex:'digg'},
				{header:'踩',width:50,align:'right',sortable:false,dataIndex:'trample'},
				{header:'今日顶',width:50,align:'right',sortable:false,dataIndex:'daydigg'},
				{header:'今日踩',width:50,align:'right',sortable:false,dataIndex:'daytrample'},
				{header:'本周顶',width:50,align:'right',sortable:false,dataIndex:'weekdigg'},
              	{header:'本周踩',width:50,align:'right',sortable:false,dataIndex:'weektrample'},
				{header:'本月顶',width:50,align:'right',sortable:false,dataIndex:'monthdigg'},
              	{header:'本月踩',width:50,align:'right',sortable:false,dataIndex:'monthtrample'},
				{header:'发布日期',width:100,sortable:false,dataIndex:'publishdate'}
	        ],
            bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
	    });
        
		this.gridMenu = new Ext.menu.Menu({items:[
			{text:'浏览',handler:this.browse,scope:this},
            {text:'清空',icon:ico,iconCls:'ico delete',handler:this.del,scope:this},
			{text:'显示',menu:menu['display']}
        ]});
		
        this.grid.on('rowdblclick', function(g,r,e){this.currentId = g.getStore().getAt(r).id;},this);
		this.grid.on('rowclick', function(g,r,e){this.currentId = g.getStore().getAt(r).id;},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			var stm = g.getSelectionModel();
            stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) :stm.selectRow(r);
            this.gridMenu.showAt(e.getXY());
		},this);
	
		this.tree = new Ext.tree.TreePanel({
        	title:'网站栏目树',region:'west',cls:'channel-tree',collapsible:true,split:true,width:180,minSize:35,maxSize:500,border:false,
        	autoScroll:true,rootVisible:true,lines:false,useArrows:true,bodyStyle:'padding:8px 1px;',style:'border-right:1px solid #99BBE8',
            loader:new Ext.tree.TreeLoader({dataUrl:'index.php?M=Channel&A=ChannelTree'}),
			root:new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',expanded:true})
        });
		
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
 			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
 			items:{xtype:'panel',title:'Digg管理',contentEl:'comment-action',collapsible:true,style:'margin-bottom:5px'}
 		});
        this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,
			{xtype:'tabpanel',region:'center',border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:this.grid}
		]});
		this.mainPanel = this.viewport.getComponent(1);
		var request={start:0,limit:25};
		this.D.baseParams = {channelid:0,checked:3};
        this.D.load({params:request});
    	this.tree.on('click',function(n,e){
    		this.D.baseParams = {channelid:n.id,contentid:0,keywords:''};
    		this.soField.reset();
    		this.currentNode = n;
    		this.D.reload();
    	},this);       
	},
	
	recordsSelect :function(item){
		 var mode = item && item.mode ? item.mode :1;
		 switch(item.mode){
			 case 1 :this.grid.getSelectionModel().selectAll(); break;
			 case 2:for (var i = 0; i < this.D.getCount(); i++) this.grid.getSelectionModel().isSelected(i) ? this.grid.getSelectionModel().deselectRow(i) :this.grid.getSelectionModel().selectRow(i, true);break;
			 case 3 :this.grid.getSelectionModel().clearSelections(); break;
		 }
	},
	//显示
	show:function(item){
		var show;
		if(item.group=='showChannel'){this.son = item.mode;}else{show = item.mode;}
		this.soField.reset();
		this.D.baseParams = {channelid:this.currentNode && this.currentNode.id ? this.currentNode.id : 0,son:this.son,show:show};
	    this.D.reload({params:{start:0,TotalCount:-1}});
	},
	//取消搜索
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams = {channelid:0,contentid:0,checked:3,keywords:''};
		this.D.reload();
	},
	//搜索
	soOnTrigger2Click:function(){
	    var keywords = this.soField.getValue().trim();
	    if(keywords != ''){
	        this.D.baseParams.keywords = keywords;
	        this.D.reload();
	    }
	},
	//浏览原文
	browse : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(selected.length != 1){
			alert('请选择一个评论！');return;
		}
		EXCMS.util.RequestUrl('index.php',{M:'Common',A:'Browse',type:'content',id:selected[0].data.contentid});
	},
	//清空关注度数据
	del : function(){
       var selected = this.grid.getSelectionModel().getSelections();
        if(selected.length > 0){
           	var idstr="";
            for (var i = 0, len = selected.length; i < len; i++) {idstr+=selected[i].id+",";}
			idstr = idstr.substring(0,idstr.length-1);
	   		Ext.MessageBox.confirm('提示','您确实要清空选定关注度数据？', function(optional){
               if(optional=='yes'){
               	   this.grid.getEl().mask('数据加载中...');
                   Ext.Ajax.request({
                        url: this.baseAction+"&method=delete",method: 'POST',params:{contentids:idstr},
                        failure:function(response,options){this.grid.getEl().unmask();alert("出现异常错误！请联系管理员！");},  
                        success:function(response,options){
                        	this.grid.getEl().unmask();var r=jsonReturn(response);if(r.success) this.D.reload();
                        },scope:this
                   });
               }
               else return
           }.createDelegate(this));
         }else alert('请至少选择一条记录！');
	},	
	//Digg模块帮助
	helpTab : function(){
		if(!this.helpPanel){
			this.helpPanel = new Ext.Panel({title:'Digg模块帮助',border:false,autoScroll:true,
				html:'<iframe name="iframe-comment-help" src="Modules/Modules/digg/digg.html" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>',
				tbar:[{text:'关闭',handler:function(){this.setHelpTabVisible(false)},scope:this}]
			});
			this.mainPanel.add(this.helpPanel);
			if(this.mainPanel.activate){
				this.mainPanel.activate(this.helpPanel);
            }else if(this.mainPanel.layout.setActiveItem){
            	this.mainPanel.layout.setActiveItem(this.mainPanel.getComponent(1));
            }
		}else{
			this.setHelpTabVisible(true);
		}
	},
	//显示/隐藏Tab
	setHelpTabVisible : function(flag){
	    if(flag){
	        this.mainPanel.unhideTabStripItem(this.helpPanel);
	        this.helpPanel.setVisible(true);
	    }else{
	        this.mainPanel.activate(0);
	        this.mainPanel.hideTabStripItem(this.helpPanel);
	    }
	},
	rendererCmt:function(v){
		v = v.replace(/<\/?\w+((\s+\w+(\s*=\s*(?:".*?"|\'.*?\'|[^\'">\s]+))?)+\s*|\s*)\/?>/g, '');
		v = v.replace("\n",'');
		v = v.replace("\r",'');
		if(v.length > 50){v = v.substr(0,50) + '...';}
		return v;
	}
};
EXCMS.onReady(EXCMS.Modules.Digg.init,EXCMS.Modules.Digg);