EXCMS.namespace('EXCMS.Search');

EXCMS.Search = {
	baseAction : 'index.php?M=Modules&EM=search&A=Index',
	modulesAction : 'index.php?M=Modules&A=Index&moduleid=search',
	templateListAction : 'index.php?M=Common&A=TemplatesList',
	init : function(){
	    Ext.QuickTips.init();
	    this.type ='keywords';
		this.view();
	},
	
	//显示
	view : function(){		
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
				bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
				items:{xtype:'panel',title:'搜索管理',contentEl:'search-action',collapsible:true,style:'margin-bottom:5px'}
			});
        this.plant = Ext.data.Record.create(['id','keywords','splitwords','frequency','count',{name:'hot',type:'int'},'createddate','modifieddate']);
		this.keywordStore = new Ext.data.Store({
			proxy:new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
			reader:new Ext.data.JsonReader({root:'data',totalProperty:'total'},this.plant),
			remoteSort:true
		});
		this.soField = new Ext.form.TwinTriggerField({emptyText:'关键字',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(t,e){if(e.getKey()==13)this.soOnTrigger2Click()},this);
		var checkColumn = new Ext.grid.CheckColumn({header:'热点',dataIndex:'hot',align:'center',width:50});
		this.keywordGrid = new Ext.grid.EditorGridPanel({title:'搜索关键字',collapsible:true,animCollapse:false,border:false,
			store: this.keywordStore,sm:new Ext.grid.RowSelectionModel(),plugins:checkColumn,
			columns:[
				{header:'ID',width:60,sortable:true,dataIndex:'id'},
				{header:'关键字',width:200,sortable:true,dataIndex:'keywords',editor:new Ext.form.TextField({allowBlank:false,blankText:'关键字不能为空'})},
				{header:'分词结果',width:300,sortable:true,dataIndex:'splitwords',editor:new Ext.form.TextField()},
				{header:'搜索频率',width:80,align:'right',sortable:true,dataIndex:'frequency',editor:new Ext.form.NumberField({decimalPrecision:0})},
				{header:'结果',width:72,align:'right',sortable:true,dataIndex:'count'},
				checkColumn,
				{header:'首次搜索时间',width:120,sortable:true,dataIndex:'createddate'},
				{header:'最后搜索时间',width:120,sortable:true,dataIndex:'modifieddate'}
			],
			tbar:[
				{text:'新建',handler:this.editKeyword,scope:this},
				{text:'编辑',handler:this.editKeyword,scope:this,mode:1},
				{text:'删除',handler:this.delKeyword,scope:this},
				{text:'保存',handler:this.saveKeyword,scope:this},'-',
				{text:'选择',menu:{items:[
					 {text:'全选',handler:this.select,scope:this,mode:1,grid:'this.keywordGrid'},
					 {text:'反选',handler:this.select,scope:this,mode:2,grid:'this.keywordGrid'},
					 {text:'取消选择',handler:this.select,scope:this,mode:3,grid:'this.keywordGrid'}
				]}},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.keywordStore.reload()},scope:this},
				'->','搜索 ',this.soField
			],
			 bbar:new Ext.PagingToolbar({pageSize:25,store:this.keywordStore,displayInfo:true,displayMsg: '当前显示{0} - {1} 共{2}条',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
		});
		this.keywordGrid.on('rowclick',function(g,r){this.keywordRecord=g.getStore().getAt(r)},this);
		this.keywordGrid.on('celldblclick',function(g,r,c,e){if(c==1 || c==2 || c==3){this.keywordGrid.topToolbar.items.items[3].setDisabled(false);}},this);
		this.keywordGrid.contextMenu = new Ext.menu.Menu({items:[
			{text:'新建',icon:ico,iconCls:'ico add',handler:this.editKeyword,scope:this},
			{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editKeyword,scope:this,mode:1},
			{text:'删除',icon:ico,iconCls:'ico del',handler:this.delKeyword,scope:this}
		]});
		this.keywordGrid.on('rowcontextmenu',function(g,r,e){
			this.keywordRecord = g.getStore().getAt(r);
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
			g.contextMenu.showAt(e.getXY());
		},this);

		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.keywordGrid});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
		new Ext.Viewport({layout:'border',items:[actionPanel,this.tabPanel]});
		
		this.keywordStore.load({params:{start:0,limit:25}});
		
		this.keywordGrid.getEl().dom.oncontextmenu = function(){return false;}
        this.keywordGrid.getEl().dom.onselectstart = function(){return false;}
	},
	
	//搜索
	soOnTrigger1Click:function(){this.soField.reset();this.keywordStore.baseParams.key='';this.keywordStore.reload()},
	soOnTrigger2Click:function(){var key = this.soField.getValue().trim();if(key!=''){this.keywordStore.baseParams.key=key;this.keywordStore.reload()}},
	
	active:function(o){
		this.type = o;
		switch(o){
			//显示搜索关键字 panel
			case 'keywords' :
				this.tabPanel.activate(0);
				break;
			
			//显示搜索类型 panel
			case 'type' :
				if(!this.categoryGrid){
					this.categoryPlant = Ext.data.Record.create(['id','name','modelid','modelname','channelids','channelname','description','maxrecord','sort','status','pagemaxnumber','template','default']);
					this.categoryStore = new Ext.data.Store({
						proxy:new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
						reader:new Ext.data.JsonReader({root:'data',totalProperty:'total'},this.categoryPlant),
						remoteSort:true
					});
					
					var setMenu = new Ext.menu.Menu({items:[
						{text:'启用',iconCls:'btnico btn_check',handler:this.setting,scope:this,mode:1},
						{text:'禁用',handler:this.setting,scope:this,mode:0},
						'-',
						{text:'设置为默认分类',handler:this.settingdefault,scope:this}
					]});
					this.categoryGrid = new Ext.grid.EditorGridPanel({title:'搜索分类',collapsible:true,animCollapse:false,border:false,closable:true,
						store: this.categoryStore, sm:new Ext.grid.RowSelectionModel(),
						columns:[
							{header:'ID',width:40,sortable:true,dataIndex:'id'},
							{header:'分类名称',width:80,sortable:true,dataIndex:'name'},
							{header:'内容类型',width:80,sortable:false,dataIndex:'modelname'},
							{header:'包涵栏目',width:250,sortable:false,dataIndex:'channelname'},
							{header:'每页显示',width:60,sortable:true,dataIndex:'pagemaxnumber'},
							{header:'描述',width:150,sortable:true,dataIndex:'description'},
							{header:'最大显示',width:60,sortable:true,dataIndex:'maxrecord'},
							{header:"状态",width:60,sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
							{header:"模板",width:150,sortable:true,dataIndex:'template'},
							{header:'默认搜索',width:60,sortable:true,dataIndex:'default',renderer:this.renderDefault,scope:this},
							{header:'排序',width:60,sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
						],
						tbar:[
							{text:'新建',handler:this.editCategory,scope:this},
							{text:'编辑',handler:this.editCategory,scope:this,mode:1},
							{text:'删除',handler:this.delCategory,scope:this},
							{text:'保存排序',handler:this.saveSort,scope:this},
							{text:'设置',menu:setMenu},'-',
							{text:'选择',menu:{items:[
								 {text:'全选',handler:this.select,scope:this,mode:1,grid:'this.categoryGrid'},
								 {text:'反选',handler:this.select,scope:this,mode:2,grid:'this.categoryGrid'},
								 {text:'取消选择',handler:this.select,scope:this,mode:3,grid:'this.categoryGrid'}
							]}},'-',
							{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.categoryStore.reload()},scope:this}
						],
						 bbar:new Ext.PagingToolbar({pageSize:25,store:this.categoryStore,displayInfo:true,displayMsg: '当前显示{0} - {1} 共{2}条',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
					});
					
					this.categoryGrid.on('rowclick',function(g,r){this.categoryRecord=g.getStore().getAt(r)},this);
					this.categoryGrid.on('celldblclick',function(g,r,c,e){if(c!=9){this.categoryRecord=g.getStore().getAt(r);this.editCategory({mode:1})}},this);
					this.categoryGrid.contextMenu = new Ext.menu.Menu({items:[
						{text:'新建',icon:ico,iconCls:'ico add',handler:this.editCategory,scope:this},
						{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editCategory,scope:this,mode:1},
						{text:'删除',icon:ico,iconCls:'ico del',handler:this.delCategory,scope:this},'-',
						{text:'设置',menu:setMenu}
					]});
					this.categoryGrid.on('rowcontextmenu',function(g,r,e){
						this.categoryGrid.record=g.getStore().getAt(r)
						var stm = g.getSelectionModel();
						stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
						g.contextMenu.showAt(e.getXY());
					},this);
		
					this.tabPanel.add(this.categoryGrid);
					this.tabPanel.activate(this.categoryGrid);
					this.categoryGrid.getEl().dom.oncontextmenu = function(){return false;}
       				this.categoryGrid.getEl().dom.onselectstart = function(){return false;}
					this.categoryStore.baseParams.group = 'type';
					this.categoryStore.load({params:{start:0,limit:25}});
				}
				this.tabPanel.unhideTabStripItem(this.categoryGrid);
				this.tabPanel.activate(this.categoryGrid);
				break;
		
			
			//显示搜索设置
			case 'setting' :
				if(!this.settingGrid){
					this.settingD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.modulesAction+'&method=settingStore'}),
			            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
			                fields:["id","name","value","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'},{name:'multisite',type:'int'}]
			            }),remoteSort:false
			        });
					this.settingGrid = new Ext.grid.EditorGridPanel({title:'搜索设置',store:this.settingD,closable:true,closeAction:'hide',
						minColumnWidth:2,autoExpandColumn:3,border:false,sm:new Ext.grid.RowSelectionModel(),
			            columns:[
							new Ext.grid.RowNumberer(),
							{header:"变量名",width:150,sortable:true,dataIndex:'name'},
							{header:"变量值",width:220,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
							{header:"描述",width:150,sortable:true,dataIndex:'description'},
							{header:"数据类型",width:80,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
							{header:"系统变量?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
							{header:'排序',width:60,sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
						],
						tbar:[
							{text:'新建',handler:this.editSetting,scope:this,mode:0},
							{text:'编辑',handler:this.editSetting,scope:this,mode:1},
							{text:'删除',handler:this.delSetting,scope:this},'-',
							{text:'刷新',handler:function(){this.settingD.reload()},scope:this}
						]
					});
					
					this.settingGridMenu = new Ext.menu.Menu({items:[
			            {text:'新建',icon:ico,iconCls:'ico add',handler:this.editSetting,scope:this,mode:0},
			            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editSetting,scope:this,mode:1},
			            {text:'删除',icon:ico,iconCls:'ico del',handler:this.delSetting,scope:this}
			        ]}); 
					
					this.settingGrid.on('celldblclick',function(g,r,c,e){if(c!=6){this.settingRecord=this.settingD.getAt(r);this.editSetting({mode:1});}},this);
					this.settingGrid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.settingRecord=this.settingD.getAt(r);this.settingGridMenu.showAt(e.getXY())},this);
					this.settingGrid.on('afteredit',this.saveSettingSort,this);
					this.tabPanel.add(this.settingGrid);
					this.tabPanel.activate(this.settingGrid);
					this.settingGrid.getEl().dom.oncontextmenu = function(){return false;}
       				this.settingGrid.getEl().dom.onselectstart = function(){return false;}
			        this.settingD.load();
				}
				this.tabPanel.unhideTabStripItem(this.settingGrid);
				this.tabPanel.activate(this.settingGrid);
				break;
			//内容分词
			case 'split':
				if(!this.splitPanel){
					this.splitPanel = new Ext.Panel({title:'内容分词',closable:true,layout:'border',autoScroll:true,
						tbar:[
						      {text:'更新',iconCls:'btnico btn_fresh',handler:this.update,scope:this},
						      {text:'重置',handler:this.reset,scope:this}
						],
						items:[
	    					new Ext.tree.TreePanel({region:'west',cls:'channel-tree',border:false,style:'border-right:1px solid #99BBE8;border-bottom:1px solid #99BBE8;',
								bodyStyle:'padding:8px 1px;',split:false,width:200,minSize:80,maxSize:500,autoScroll:true,useArrows:true,containerScroll:true,rootVisible:true,
								loader:new Ext.tree.TreeLoader({baseAttrs:{uiProvider:Ext.ux.TreeCheckNodeUI},dataUrl:'index.php?M=Channel&A=ChannelTree'}),
								root:new Ext.tree.AsyncTreeNode({id:'0',text:'网站栏目',cls:'channel-tree-root',checked:false,expanded:true,ToExpend:true,draggable:false})
	    					}),
	    					new Ext.Panel({title:"分词进度",region:'south',border:false,autoScroll:true,split:true,
	    						height:200,style:'border-top:1px solid #99BBE8',cls:'preview',
	    						html:'<iframe name="splitstatusiframe" src="" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>'
	    					}),
	    					{region:'center',xtype:'form',layout:'form',autoScroll:true,labelWidth:106,border:false,bodyStyle:'padding:10px;',style:'border-bottom:1px solid #99BBE8',items:[
                                {xtype:'hidden',name:'channelid'},
	    						{fieldLabel:'每轮分词内容数',xtype:'numberfield',name:'max',value:50,width:140,maxValue:1000,maxText:'最大值不能超过1000'},
	    						{fieldLabel:'分词字符数',xtype:'numberfield',name:'splitchars',value:1000,width:140,maxValue:10000,maxText:'最大值不能超过10000'},
	    						{xtype:'label',width:470,text:'只对标题+内容前指定的分词字符数进行分词，数值愈大分词速度越慢，搜索结果越准确。分词字符数为0时对全部内容进行分词。',style:'display:block;padding:0 0 6px 112px;color:#666;'},
	    						{fieldLabel:'子栏目选项',boxLabel:'包含子级栏目内容',name:'subchannel',xtype:'checkbox',inputValue:1},
								{fieldLabel:'内容范围',hiddenName:'option',xtype:'combo',value:1,width:140,editable:false,mode:'local',
									triggerAction:'all',selectOnFocus:true,
									store: [[1,'所有内容'],[2,'最新发布内容'],[3,'指定时间区间内容'],[4,'制定内容ID区间内容'],[5,'指定内容ID内容']],
									listeners:{'select':{fn:function(c,r,i){for(var k=1;k<5;k++){c.ownerCt.items.items[5+k].ct.style.display='none'}if(i>0)c.ownerCt.items.items[5+i].ct.style.display='block'},scope:this}}
								},
								{fieldLabel:'最新发布内容数',xtype:'numberfield',name:'latestnum',width:140,minValue:0,listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;el.ct.style.display='none'},scope:this}}},
								{layout:'form',anchor:'100%',border:false,defaultType:'datefield',defaults:{vtype:'daterange',width:123},items:[
									{fieldLabel:'起始内容发布时间',name:'startdate',id:'startdate',endDateField:'enddate',selectOnFocus:true,format:'Y-m-d'},
									{fieldLabel:'结束内容发布时间',name:'enddate',id:'enddate',startDateField:'startdate',selectOnFocus:true,format:'Y-m-d'}
								],listeners:{'render':{fn:function(el){el.ct=el.el.dom;el.ct.style.display='none'},scope:this}}},
								{layout:'form',anchor:'100%',border:false,defaultType:'numberfield',defaults:{width:140},items:[
									{fieldLabel:'起始内容ID',name:'startid',minValue:0},
									{fieldLabel:'结束内容ID',name:'endid',minValue:0}
								],listeners:{'render':{fn:function(el){el.ct=el.el.dom;el.ct.style.display='none'},scope:this}}},
								{fieldLabel:'指定内容ID',name:'contentid',xtype:'textfield',value:'',width:400,height:160,emptyText:"多个内容ID用','(逗号)或' '(空格)隔开",listeners:{'render':{fn:function(el){el.ct=el.container.dom.parentNode;el.ct.style.display='none'},scope:this}}}
			    			]}
	    				]
    				});
					
					this.tabPanel.add(this.splitPanel);
					this.tabPanel.activate(this.splitPanel);
				}
				this.tabPanel.unhideTabStripItem(this.splitPanel);
				this.tabPanel.activate(this.splitPanel);
				break;
			case 'field' :
				this.initSearchField();
				break;
			//显示搜索帮助
			case 'help' :
				if(!this.helpPanel){
					var html = '<iframe src="Modules/Modules/search/search.html" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>';
					this.helpPanel = new Ext.Panel({title:'搜索帮助',border:false,autoScroll:true,closable:true,closeAction:'hide',html:html});
					this.tabPanel.add(this.helpPanel);
				}
				this.tabPanel.unhideTabStripItem(this.helpPanel);
				this.tabPanel.activate(this.helpPanel);
				break;
		}
	},
	initSearchField : function(){
		if(!this.fieldGrid){
			this.fieldD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=fieldStore'}),
	            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
	                fields:["id",'name',"search_table","search_field","search_key",'join_table','join_key','enable','cidname','value','sort','category','cid','type']
	            }),remoteSort:false
	        });
			
			this.fieldGrid = new Ext.grid.GridPanel({title:'搜索字段',collapsible:true,animCollapse:false,border:false,closable:true,
				store: this.fieldD, sm:new Ext.grid.RowSelectionModel(),
				columns:[
					{header:'搜索名称',width:150,sortable:true,dataIndex:'name'},
					{header:'搜索表名',width:150,sortable:true,dataIndex:'search_table'},
					{header:'搜索字段',width:100,sortable:false,dataIndex:'search_field'},
					{header:'搜索主键',width:100,sortable:false,dataIndex:'search_key'},
					{header:'关联表',width:150,sortable:true,dataIndex:'join_table'},
					{header:'关联主键',width:100,sortable:true,dataIndex:'join_key'},
					{header:'是否启用',width:60,sortable:true,dataIndex:'enable',renderer:this.renderStatus,scope:this},
					{header:"搜索分类",width:100,sortable:true,dataIndex:'cidname'},
					{header:"搜索值",width:100,sortable:true,dataIndex:'category'},
					{header:'排序',width:60,sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
				],
				tbar:[
					{text:'新建',handler:this.editField,scope:this},
					{text:'编辑',handler:this.editField,scope:this,mode:1},
					{text:'删除',handler:this.delField,scope:this},
					{text:'启用',handler:this.enable,scope:this,mode:1},
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.fieldD.reload()},scope:this}
				]
			});
			
			this.fieldGrid.on('rowclick',function(g,r){this.fieldRecord=g.getStore().getAt(r);this.setFieldToolbar(this.fieldRecord.data.enable);},this);
			this.fieldGrid.on('celldblclick',function(g,r,c,e){if(c!=9){this.fieldRecord=g.getStore().getAt(r);this.editField({mode:1})}},this);
			this.fieldGrid.contextMenu = new Ext.menu.Menu({items:[
				{text:'新建',icon:ico,iconCls:'ico add',handler:this.editField,scope:this},
				{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editField,scope:this,mode:1},
				{text:'删除',icon:ico,iconCls:'ico del',handler:this.delField,scope:this},
				{text:'启用',handler:this.enable,scope:this,mode:1}
			]});
			this.fieldGrid.on('rowcontextmenu',function(g,r,e){
				this.fieldRecord=g.getStore().getAt(r)
				var stm = g.getSelectionModel();
				stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
				g.contextMenu.showAt(e.getXY());
				this.setFieldToolbar(this.fieldRecord.data.enable);
			},this);

			this.tabPanel.add(this.fieldGrid);
			this.tabPanel.activate(this.fieldGrid);
			this.fieldGrid.getEl().dom.oncontextmenu = function(){return false;}
				this.fieldGrid.getEl().dom.onselectstart = function(){return false;}
			this.fieldD.load({params:{start:0,limit:25}});
		}
		this.tabPanel.unhideTabStripItem(this.fieldGrid);
		this.tabPanel.activate(this.fieldGrid);
	},
	createSystemFieldList : function(fieldLabel,hidename,isValid){
		isValid = isValid ? false :true;
		var field = new Ext.form.ComboBox({fieldLabel:fieldLabel,disabled:true,name:hidename,
			maxHeight:200,editable:true,valueField:'fieldname',displayField:'fielddesc',waitMsgTarget:true,value:'', 
			typeAhead:true,triggerAction:'all',emptyText:'请选择'+fieldLabel,selectOnFocus:true,allowBlank:isValid,blankText:"请选择"+fieldLabel,
			store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.baseAction+'&method=fieldList'}),reader: new Ext.data.JsonReader({root:'data',id:'fieldname'}, ['fieldname','fielddesc']),remoteSort:true})
         });
		
        return field;
	},
	createSystemTableList : function(fieldLabel,hidename,isValid){
		isValid = isValid ? false :true;
		var dataList = new Ext.form.ComboBox({fieldLabel:fieldLabel,name:hidename,
			maxHeight:200,editable:true,valueField:'tablename',displayField:'tablename',waitMsgTarget:true,
			typeAhead:true,triggerAction:'all',emptyText:'选择'+fieldLabel,selectOnFocus:true,allowBlank:isValid,blankText:"选择"+fieldLabel,
			store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.baseAction+'&method=fieldList'}),reader: new Ext.data.JsonReader({root:'data',id:'tablename'}, ['tablename']),remoteSort:true})
         });
		return dataList;
	},
	editField : function(item){
		var title;
		if(!item.mode){
			title = '新建搜索字段';
		}else{
			if(this.fieldRecord){title ='修改 '+ this.fieldRecord.data.name;}else{alert('请选择要编辑的搜索字段');return ;}
		}
		if(!this.fieldWin){
			this.cid = new Ext.form.Hidden({name:'cid'});
			this.searchCategory = new Ext.form.ComboBox({fieldLabel:'搜索分类',
				maxHeight:200,valueField:'id',displayField:'name',waitMsgTarget:true,typeAhead:true,triggerAction:'all',selectOnFocus:true,
				store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.baseAction + '&method=category'}),reader: new Ext.data.JsonReader({root:'data',id:'id'}, ['id','name']),remoteSort:true})
			 });
			this.searchCategory.on('change',function(c,v,o){this.cid.setValue(v);},this);
			this.search_table = this.createSystemTableList('搜索表名','search_table',true);
			this.search_field = this.createSystemFieldList('搜索字段','search_field',true);
			this.search_key = this.createSystemFieldList('搜索主键','search_key',false);
			this.join_table = this.createSystemTableList('关联表名','join_table',false);
			this.join_key = this.createSystemFieldList('关联表主键','join_key',false);
			
			this.search_table.on('select',function(c,r,i){
				this.search_field.store.baseParams={table:r.data.tablename};this.search_field.enable();
				this.search_key.store.baseParams={table:r.data.tablename};this.search_key.enable();
			},this);
			this.join_table.on('select',function(c,r,i){
				this.join_key.store.baseParams={table:r.data.tablename};this.join_key.enable();
			},this);
			this.search_field.onTriggerClick = function(){this.store.load({params:{table:EXCMS.Search.search_table.getValue()}});}
			this.search_key.onTriggerClick = function(){this.store.load({params:{table:EXCMS.Search.search_table.getValue()}});}
			this.join_key.onTriggerClick = function(){this.store.load({params:{table:EXCMS.Search.join_table.getValue()}});}
			this.search_field.disable();
			this.search_key.disable();
			this.join_key.disable();
			this.fieldFormPanel = new Ext.FormPanel({border:false,autoScroll:false,bodyStyle:'padding:15px',defaults:{border:false},items:[
				{layout:'form',defaults:{xtype:'textfield',border:false,anchor:'95%'},items:[
					{xtype:'hidden',name:'id'},this.cid,
					{fieldLabel:'搜索名称',xtype:'textfield',name:'name',allowBlank:false,blankText:'搜索名称不能为空'},
					this.searchCategory,
					this.search_table,
					this.search_field,
					this.search_key,
					this.join_table,
					this.join_key,
					new Ext.form.ComboBox({fieldLabel:'类型',hiddenName:'type',value:0,editable:false,
						store:[[0,'文本'],[1,'分类数据'],[2,'日期']],triggerAction:'all',selectOnFocus:true}),
    				{xtype:'combotree',fieldLabel:'取值来源',hiddenName:'value',style:"font-family:'宋体'",emptyText:'请选择分类取值来源',dataUrl:'index.php?M=Category&A=Index&method=catetree',rootText:'所有分类',onTreeClick:function(n){if(!n.attributes['iscate'])return;this.setValue(n.id);this.el.dom.value=n.parentNode.text+' > '+n.text;this.collapse()}},
					{fieldLabel:'排序',xtype:'numberfield',name:'sort',anchor:'40%'}
				]}
			]});
			this.fieldWin = new Ext.Window({id:'excms-win-search-fields',title:'',layout:'fit',
				resizable:false,width:450,height:360,closeAction:'hide',plain:false,modal:false,
				items:this.fieldFormPanel,
				buttons:[
					{text:'确定',handler:this.saveField,scope:this},
					{text:'取消',handler:function(){this.fieldWin.hide();},scope:this}
				]
			});	
			this.fieldFormPanel.form.on('actioncomplete',function(form,action){
				alert(action.result.message);
				this.fieldWin.hide();
				if(action.result.success){
					this.fieldD.reload();
				}
			}, this);
		}
		this.fieldWin.setTitle(title);
		this.fieldWin.show();
		if(!item.mode){
			this.fieldFormPanel.form.reset();
			this.search_field.disable();
			this.search_key.disable();
			this.join_key.disable();
		}else{
			this.search_field.enable();
			this.search_key.enable();
			this.join_key.enable();
			this.fieldFormPanel.form.setValues(this.fieldRecord.data);
			this.searchCategory.setValue(this.fieldRecord.data.cidname);
		}
	},
	saveField : function(){
		if(!this.fieldFormPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.fieldFormPanel.form.submit({url:this.baseAction+'&method=fieldCommit'});
	},
	delField : function(){
		var selected = this.fieldGrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
        Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的记录吗？。",function(optional){if(optional=='yes'){
		  Ext.Ajax.request({url:this.baseAction + '&method=deleteField',method:'post',scope:this,
			  params:{id:id.join(',')},
			  success:function(r,o){r = jsonReturn(r);alert(r.message);this.fieldD.reload();}
		  })}
        },this);
	},
	//启用/禁用	
	enable : function(item){
		var selected = this.fieldGrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择一条或多条记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
		Ext.Ajax.request({url:this.baseAction + '&method=fieldEnable',method:'post',scope:this,
			params:{id:id.join(','),enable:item.mode},
			success:function(r,o){
				r = jsonReturn(r);
				this.setFieldToolbar(item.mode);
				this.fieldD.reload();
			}
		});
	},
	//设置工具条
	setFieldToolbar : function(falg){
		if(falg == '1'){
			this.fieldGrid.getTopToolbar().items.items[3].setText('禁用');
			this.fieldGrid.getTopToolbar().items.items[3].mode = 0;
			this.fieldGrid.contextMenu.items.items[3].setText('禁用');
			this.fieldGrid.contextMenu.items.items[3].mode = 0;
		}else{
			this.fieldGrid.getTopToolbar().items.items[3].setText('启用');
			this.fieldGrid.getTopToolbar().items.items[3].mode = 1;
			this.fieldGrid.contextMenu.items.items[3].setText('启用');
			this.fieldGrid.contextMenu.items.items[3].mode = 1;
		}
	},
	editSetting : function(item){
		var title;
		if(item.mode==1){
			this.settingRecord = this.settingGrid.getSelectionModel().getSelected();
			if(this.settingRecord){title ='修改 '+ this.settingRecord.get('name');}else{alert('请选择要编辑的变量');return ;}
		}else{title='新建变量';}
		if(!this.editSettingWin){
				this.settingformPanel = new Ext.form.FormPanel({labelWidth:60,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
					{fieldLabel:'变量名',name:'name',allowBlank:false,blankText:'变量名不能为空'},
					{fieldLabel:'变量类型',xtype:'radiogroup',items:[
						{boxLabel:'布尔型',name:'type',inputValue:1},
						{boxLabel:'数字',name:'type',inputValue:2},
						{boxLabel:'文本',name:'type',inputValue:3,checked:true},
						{boxLabel:'多行文本',name:'type',inputValue:4}
					]},
					{fieldLabel:'变量值',xtype:'radiogroup',items:[
						{boxLabel:'是',name:'value',inputValue:1,checked:true},
						{boxLabel:'否',name:'value',inputValue:0}
					]},
					{fieldLabel:'变量值',name:'value1',xtype:'numberfield'},
					{fieldLabel:'变量值',name:'value2'},
					{fieldLabel:'变量值',name:'value3',xtype:'textarea'},
					{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
					{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'}
				]});
				
	            this.editSettingWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:330,closeAction:'hide',plain: true,
	                items:this.settingformPanel,
	                buttons:[{text:'确定',handler:this.saveSetting,scope:this},{text:'取消',handler:function(){this.editSettingWin.hide()},scope:this}]
	            });
	            this.settingformPanel.form.on('actioncomplete',function(form,action){
	                if(action.result.success){this.editSettingWin.hide();this.settingD.reload();}
	            }, this);
		}
		this.editSettingWin.setTitle(title);
		this.editSettingWin.show();
		this.settingformPanel.form.items.items[3].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);

		if(item.mode==1){
			var data = this.settingRecord.data;
        	this.settingformPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.settingformPanel.form.reset();
			this.setDisabled();
			this.setVisible(3);
		}
	},
	
	saveSetting : function(){
		if(!this.settingformPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		var issystem = this.settingformPanel.form.items.items[1].value;
		var name = this.settingformPanel.form.items.items[2].value;
		var type = this.settingformPanel.form.items.items[3].getValue();
		var act = this.settingformPanel.form.items.items[0].getValue() == '' ? '&method=settingInsert' : '&method=settingUpdate';
		this.settingformPanel.form.submit({url:this.modulesAction+act,params:{issystem:issystem,name:name,type:type}});
	},
	
	saveSettingSort : function(){
		var records = this.settingD.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			this.settingGrid.getEl().mask('搜索设置排序数据保存中,请稍候');
			Ext.Ajax.request({url:this.modulesAction+'&method=updateSettingSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.settingGrid.getEl().unmask();},
				success:function(r,o){
					this.settingGrid.getEl().unmask();
					r=jsonReturn(r);
					if (r.success) {
						this.settingD.commitChanges();
					}
				}
			});
		}
	},
	
	//删除系统变量
	delSetting:function(){
        var records = this.settingGrid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的变量');
			return ;
		}
        if(flag){alert('模块系统变量不允许删除！');return;}
       	if(confirm('您确实要删除选定的记录吗？')){
			Ext.Ajax.request({
				url:this.modulesAction + '&method=settingDelete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.settingD.reload();}
				}
			});
        }
	},
	
	setDisabled : function(issystem){
		for(var i=1;i<4;i++){
			this.settingformPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	
	renderType:function(v){var d=['布尔型','数字','文本','多行文本'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red>是</font>':'<font color=green>否</font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'>是</font>":"<font color='red'>否</font>"):v},
	
	//设置显示变量类型
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 3) == i ? '' : 'none';
		}
	},
	
	setValue:function(type, value){
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].setValue((type + 3) == i ? value : '');
		}
	},

	//新建，编辑关键字
	editKeyword : function(item){
		if(item && item.mode == 1){
			var idx = this.keywordRecord ? this.keywordStore.indexOf(this.keywordRecord) : -1;
			if(idx > -1){
				this.keywordGrid.topToolbar.items.items[3].setDisabled(false);
				this.keywordGrid.stopEditing();
				this.keywordGrid.startEditing(idx, 1);
			}else{
				alert('请选择要编辑的关键字记录');
			}
		}else{
			this.keywordGrid.topToolbar.items.items[3].setDisabled(false);
			this.keywordGrid.stopEditing();
			this.keywordStore.insert(0, new this.plant({keywords:'',splitwords:'',frequency:0}));
			this.keywordGrid.startEditing(0, 1);
		}
	},
	
	//保存关键字
	saveKeyword : function(){
		var records = this.keywordStore.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push(records[i].data);
		}
		if(data.length > 0){
			this.mask(true,'搜索关键字数据保存中,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=commit',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.mask(false);},
				success:function(r,o){
					this.mask(false);
					r=jsonReturn(r);
					if (r.success) {
						this.keywordStore.commitChanges();
						this.keywordStore.reload();
					}
				}
			});
		}else{
			this.keywordStore.each(function(r){
				if(r.get('keywords').trim()=="")this.keywordStore.remove(r);
			},this);
		}
	},
	
	//删除关键字
	delKeyword : function(){
		var selected = this.keywordGrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的搜索关键字');return ;}
		var id=[];
		for(var i=0,len=selected.length;i<len;i++){
			if(!(selected[i].get('id')>0)){this.keywordStore.remove(selected[i]);continue;}
			id.push(selected[i].get('id'));
		}
		if(id.length>0){Ext.MessageBox.confirm('确定删除',"您确实要删除所选的搜索关键字数据吗？",function(optional){if(optional=='yes'){
			this.keywordGrid.getEl().mask('正在删除搜索关键字,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=delete',method:'post',scope:this,
			  params:{id:id.join(',')},
			  failure:function(r,o){this.keywordGrid.getEl().unmask();},
			  success:function(r,o){this.keywordGrid.getEl().unmask();this.keywordStore.reload()}
			})}
		},this)};
	},
	
	//新建、编辑搜索分类
	editCategory : function(item){
		var title;
		if(item.mode == 1){
			if(!this.categoryRecord || this.categoryStore.indexOf(this.categoryRecord) == -1){
				alert('请选择要编辑的搜索分类');
				return ;
			}
			title = '编辑搜索分类';
		}else{
			title = '新建搜索分类';
		}
		if(!this.categoryWin){
			this.model = new Ext.form.Hidden({name:'modelid'});
			this.modelSelector = new Ext.form.ComboBox({fieldLabel:'内容模型',name:'model',forceSelection:true,
				maxHeight:200,valueField:'modelid',displayField:'name',waitMsgTarget:true,typeAhead:true,triggerAction:'all',selectOnFocus:true,
				store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:'index.php?M=Model&A=ModelAction&method=combostore'}),reader: new Ext.data.JsonReader({root:'data',id:'modelid'}, ['modelid','name']),remoteSort:true})
	         });
			this.modelSelector.on('change',function(c,v,o){this.model.setValue(v);},this);
			
			this.channelMinor=new Ext.form.Hidden({name:'channelids'});
			this.channelMinorComb = new Ext.form.ComboBox({
				fieldLabel:'栏目',
				store:new Ext.data.SimpleStore({fields:[],data:[[]]}),
				editable:false,mode:'local',triggerAction:'all',maxHeight:200,hiddenName:'channelminorname',width:300,
				tpl:'<tpl for="."><div style="height:220px"><div id="channelMinorComb"></div></div></tpl>',
				selectedClass:'',onSelect:Ext.emptyFn,emptyText:"请选择栏目" });
			this.channelMinorComb.tree = new Ext.tree.TreePanel({
				border:false,autoScroll:true,useArrows:true,checkModel:'cascade',rootVisible:true,
				loader:new Ext.tree.TreeLoader({baseAttrs:{uiProvider:Ext.ux.TreeCheckNodeUI},dataUrl:'index.php?M=Channel&A=Index&method=alltree'}),
				root:new Ext.tree.AsyncTreeNode({id:'0',text:'栏目树',checked:false,expanded:true,ToExpend:true,uiProvider:Ext.ux.TreeCheckNodeUI})
			});
			this.channelMinorComb.on('expand',function(){this.channelMinorComb.tree.render('channelMinorComb');},this);
			this.channelMinorComb.on('collapse',this.setChannelMinor,this);
			this.channelMinorComb.tree.on('load',function(){if(item.mode == 1)this.selectNode(this.channelMinorComb.tree.root,eval('['+this.categoryRecord.data.channelids+']'));},this);
			
			this.formPanel = new Ext.FormPanel({border:false,autoScroll:true,bodyStyle:'padding:15px',defaults:{border:false},items:[
				{layout:'form',defaults:{xtype:'textfield',border:false,anchor:'95%'},items:[
					{xtype:'hidden',name:'id'},this.model,this.channelMinor,
					{fieldLabel:'分类名称',xtype:'textfield',name:'name',allowBlank:false,blankText:'分类名称不能为空'},
					this.modelSelector,
					this.channelMinorComb,
					{fieldLabel:'搜索页模板',xtype:'combo',hiddenName:'template',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
						valueField:'id',displayField:'name',emptyText:'选择搜索页模板模板',selectOnFocus:true,value:"search.html",
						store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.templateListAction + '&cate=search'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true})
					},
					{fieldLabel:'分类描述',xtype:'textarea',name:'description'},
					{fieldLabel:'每页显示记录数',xtype:'numberfield',name:'pagemaxnumber',anchor:'50%'},
					{fieldLabel:'最大显示记录数',xtype:'numberfield',name:'maxrecord',anchor:'50%'},
					{fieldLabel:'排序',xtype:'numberfield',name:'sort',anchor:'50%'}
				]}
			]});
			this.categoryWin = new Ext.Window({title:'',modal:false,layout:'fit',
				resizable:false,width:450,height:335,closeAction:'hide',plain:false,
				items:this.formPanel,
				buttons:[
					{text:'确定',handler:this.submit,scope:this},
					{text:'取消',handler:function(){this.categoryWin.hide();},scope:this}
				]
			});	
			this.formPanel.form.on('actioncomplete',function(form,action){
				alert(action.result.message);
				this.categoryWin.hide();
				if(action.result.success){
					this.categoryStore.reload();
				}
			}, this);
		}
		this.categoryWin.setTitle(title);
		this.categoryWin.show();
		if(item.mode == 1){
			this.formPanel.form.setValues(this.categoryRecord.data);
			if(this.channelMinorComb.tree && this.channelMinorComb.tree.root.childrenRendered){
				this.selectNode(this.channelMinorComb.tree.root, null,true);
			}
			this.channelids = eval('['+this.categoryRecord.data.channelids+']');
			this.selectNode(this.channelMinorComb.tree.root,this.channelids,false);
			this.channelMinor.setValue(this.categoryRecord.data.channelids);
			this.channelMinorComb.setValue(this.categoryRecord.data.channelname);
			this.modelSelector.setValue(this.categoryRecord.data.modelname);
		}else{
			if(this.channelMinorComb.tree && this.channelMinorComb.tree.root.childrenRendered){
				this.selectNode(this.channelMinorComb.tree.root, null,true);
			}
			this.formPanel.form.reset();
		}
	},
		
	//删除搜索分类
	delCategory : function(){
		var records = this.categoryGrid.getSelectionModel().getSelections();
		if(!records.length>0){alert('请选择要删除的分类');return ;}
		var id=[];
		for(var i=0,len=records.length;i<len;i++){id.push(records[i].get('id'));}
		Ext.MessageBox.confirm('确定删除','您确实要删除所选的搜索分类吗？',function(o){if(o=='yes'){
			this.categoryGrid.getEl().mask('正在删除搜索分类, 请稍候...');
			Ext.Ajax.request({
			  url:this.baseAction + '&method=deletecategory',
			  method:'post',
			  params:{id:id.join(',')},
			  failure:function(r,o){this.categoryGrid.getEl().unmask();},
			  success:function(r,o){this.categoryGrid.getEl().unmask();this.categoryStore.reload()},
			  scope:this
			})}
		},this);
	},
	
	saveSort : function(){
		var records = this.categoryStore.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({url:this.baseAction+'&method=updatesort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){alert("保存排序出错，请重试");},
				success:function(r,o){
					r=jsonReturn(r);
					if (r.success) {
						this.categoryStore.commitChanges();
					}
				}
			});
		}
	},
	
	selectNode :function(newNode,allNode,flag){
		if(!newNode.isExpanded()){
			newNode.expand();newNode.expandChildNodes();
		}else{
		    if(!flag){
		        var nodes = newNode.childNodes;
		        for(var i=0;i<nodes.length;i++){
				    for(var j=0;j<allNode.length;j++){
					    if(nodes[i].id==allNode[j]){
						    newNode.childNodes[i].ui.check(true);
						    allNode.splice(j,1);
					    }
						if(!newNode.childNodes[i].leaf) this.selectNode(newNode.childNodes[i],allNode,flag);
				    }
			    }
			}else{
			    for(var i=0;i<newNode.childNodes.length;i++) {
					newNode.childNodes[i].ui.check(false);
					if(!newNode.childNodes[i].leaf) 
					this.selectNode(newNode.childNodes[i],allNode,flag);}
			}
		}
		newNode.on("expand",function(node){
		    if(!flag){
			    var nodes = node.childNodes;
			    for(var i=0;i<nodes.length;i++){
				    for(var j=0;j<allNode.length;j++){
					    if(nodes[i].id==allNode[j]){
						    newNode.childNodes[i].ui.check(true);
						    allNode.splice(j,1);
					    }
						if(!newNode.childNodes[i].leaf) this.selectNode(newNode.childNodes[i],allNode,flag);
				    }
			    }
			}else{
			    for(var i=0;i<node.childNodes.length;i++) {node.childNodes[i].ui.check(false);if(!node.childNodes[i].leaf) this.selectNode(node.childNodes[i],allNode,flag);}
			}
		},this);
	},
	
	submit : function(){
		if(!this.formPanel.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return }
		if (this.formPanel.form.getValues().model == '') {
			this.formPanel.form.setValues({modelid:''});
		}
		var act =this.formPanel.form.getValues().id == '' ? 'insert' : 'update';
	    this.formPanel.form.submit({url:this.baseAction + '&method=' + act});
	},
	//选择栏目
	setChannelMinor:function(){
		var a=[],b=[];
		var nodes = this.channelMinorComb.tree.getChecked();
		for (var i=0;i<nodes.length;i++){
			if(nodes[i].id>0 && nodes[i].attributes['type']==0){
				a.push(nodes[i].id);
				b.push(nodes[i].text);
			}
		};
		this.channelMinor.setValue(a.join(','));
		this.channelMinorComb.setValue(b.join(','));
	},

	//设置是启用/禁用
	setting : function(item){
		var selected = this.categoryGrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要设置的搜索类型');return ;}
		var id=[];
		for(var i =0,len=selected.length;i<len;i++) id.push(selected[i].data.id);
		this.categoryGrid.getEl().mask('正在设置搜索类型,请稍候...');
		Ext.Ajax.request({url:this.baseAction+'&method=setting',method:'post',scope:this,
			params:{id:id.join(','),status:item.mode},
			failure:function(r,o){this.categoryGrid.getEl().unmask();},
		    success:function(r,o){this.categoryGrid.getEl().unmask();this.categoryStore.reload();}  
		});
	},
	//设置默认分类
	settingdefault : function(){
		var selected = this.categoryGrid.getSelectionModel().getSelected();
		if(selected){
			this.categoryGrid.getEl().mask('正在设置默认搜索类型,请稍候...');
			Ext.Ajax.request({url:this.baseAction+'&method=settingdefault',method:'post',scope:this,
				params:{id:selected.get('id')},
				failure:function(r,o){this.categoryGrid.getEl().unmask();},
			    success:function(r,o){this.categoryGrid.getEl().unmask();this.categoryStore.reload();}  
			});
		}else{
			alert('请选择要设置的搜索类型');
		}
	},
	
	mask:function(flag,msg){if(flag){this.keywordGrid.getEl().mask(msg)}else{this.keywordGrid.getEl().unmask()}},
	//更新内容分词
	update : function(){
		var f = this.splitPanel.layout.center.panel.form;	
		var wp = this.splitPanel.layout.west;
		if(wp){
			var checkedNodes = wp.panel.getChecked();
			var channelid = [];
			if(checkedNodes.length>0){
				for(var i=0;i<checkedNodes.length;i++){
					if(checkedNodes[i].id)channelid.push(checkedNodes[i].id);
				}
			}else{
				channelid = this.splitPanel.updateIds;
			}
			f.findField('channelid').setValue(channelid&&channelid.length ? channelid.join(',') : '');
		}
		f.el.dom.target = this.splitPanel.layout.south.el.dom.getElementsByTagName('iframe')[0].name;
		f.el.dom.action = "index.php?M=Modules&EM=search&A=SearchAction&method=updatesplitword";
		f.el.dom.submit();
	},


	//选择
	select:function(item){
		var G  = eval(item.grid);
		var D = G.getStore();
		var M=item&&item.mode?item.mode:1;
		switch(M){case 1:G.getSelectionModel().selectAll();break;case 2:for(var i=0;i<D.getCount();i++)G.getSelectionModel().isSelected(i)?G.getSelectionModel().deselectRow(i):G.getSelectionModel().selectRow(i,true);break;case 3:G.getSelectionModel().clearSelections();break;default:break}
	},
	renderDefault:function(v){return v==1 ? '<span style="color:green;">默认</span>' : '';},
	renderStatus:function(v){return v == 0 ?'<span style="color:red;">禁用</span>':'<span style="color:green;">启用</span>';}
};
EXCMS.onReady(EXCMS.Search.init,EXCMS.Search);