EXCMS.Resource.Browse={
	baseAction:'index.php?M=Resource&A=ResoureFileAction',
	nameArray : {t:'thumb(缩略图)',ss:'smallslide(小幻灯图)',ls:'largeslide(大幻灯图)',m:'medium(中等图)',l:'large(大图)',o:'original(原图)'},
	postfixArray : {thumb:'t', smallslide:'ss', largeslide:'ls', medium:'m', large:'l', original:'o'},
	imageType:['JPG','JPEG','PNG','GIF','BMP'],
	insertContextMenu :new Object, 
	pagesize : 40,
	resource : {},
	config : {},
	viewmode : {folderView:false, view:true},//folderView:浏览模式, false文件, true文件夹,view:视图模式,true缩略图, false详细信息
	dataSort : 'createddata', //默认日期排序,name,size,createddata
	tid:0, 
	nid:0, 
	fid:0,
	title : '插入文件',
	// 加载组件数据
	load:function(item){
		this.callback = item.callback; //回调方法
		this.channelid = item.channelid || 0; //指定栏目
		this.postfix = item.postfix || ''; //图片名称
		this.nodetype = item.type || 'other'; //资源类型
		this.nid = item.nid  || 0;					//资源节点ID
		this.assocw = item.assocw || 0;
		if(this.nodetype == 'image'){
			this.tid = 1;
			this.title ='插入图片';
		}else if(this.nodetype == 'file'){
			this.tid = 2;
			this.title ='插入文件';
		}else if(this.nodetype == 'video'){
			this.tid = 3;
			this.title ='插入视频';
		}
		try{
			this.resource_config = _EXCMS_content_config.resourceconfig;
		}catch(e){
			this.resource_config = {};
		}
		var channelselect = this.resource_config.defaultresource && this.resource_config.defaultresource[this.tid] && this.resource_config.defaultresource[this.tid].channelselect;
		if((this.resource_config.assocwchannel=='1' || channelselect) && !this.channelid){
			alert("资源选择需要先选定栏目");
			return ;
		}
		if(!this.node && this.nid){
			this.node ={id : this.nid};
		}
		if(this.resource_config.defaultresource && this.resource_config.defaultresource[this.tid]){
			if(!this.nid){
				this.nid = this.resource_config.defaultresource[this.tid].nid;
			}
			if(!this.node){
				this.node = {id:this.nid,text:this.resource_config.defaultresource[this.tid].name}
			}
		}
		if(!this.win){
			this.init();
		}else{
			//this.showNodeType();
			this.showNode();
			this.win.center();
			this.win.show();
		}
		if(this.cacheChannel != this.channelid || this.nodetype!= this.cacheNodetype || this.nid != this.cacheNid){
			this.cacheChannel  = this.channelid;
			this.cacheNodetype = this.nodetype;
			this.cacheNid = this.nid;
			this.loadTree();
		}
		this.setSelectionModel(item.single);
		//this.refresh();
	},
	// initial components
	init:function(){
		//this.tree = new Ext.tree.TreePanel({region:'west',bodyStyle:'padding:8px 0 8px 4px;',cls:'channel-tree browse-tree',loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=loadResourceConfig'}),border:false,split:true,width:164,maxSize:500,minSize:35,autoScroll:true,rootVisible:false,animate:false,useArrows:true,root:new Ext.tree.AsyncTreeNode({id:'0',text:'资源',leaf:0,expanded:true})});
		this.tree = new Ext.tree.TreePanel({region:'west',bodyStyle:'padding:8px 0 8px 4px;',cls:'channel-tree browse-tree',border:false,split:true,width:164,maxSize:300,minSize:35,autoScroll:true,rootVisible:false,animate:false,useArrows:true,root:new Ext.tree.TreeNode({id:'0',text:'',leaf:0,expanded:true})});
		this.tree.on('render',function(){this.renderTreeNode('type')},this);
        this.treemenu = new Ext.menu.Menu({items:[{text:'刷新',handler:function(){this.tree.getLoader().load(this.tree.root)},scope:this,tree:true}]});
		this.nodemenu = new Ext.menu.Menu({items:[
			{text:'打开',handler:this.browse,scope:this,tree:true},
			{text:'上传资源...',handler:this.upload,scope:this,tree:true},'-',
			{text:'属性',handler:this.properties,scope:this,tree:true}
		]});
        this.tree.on('click',function(n){
            if((this.node && this.node == n) || (this.node && this.node.nid && n.nid && n.nid == this.node.nid))return ;
            this.node = n;
            n.attributes['nid'] ? this.browse() : this.viewNode();
		},this);
		this.tree.on('contextmenu',function(n,e){n.attributes['nid']?this.nodemenu.showAt(e.getXY()):this.treemenu.showAt(e.getXY())},this);
        this.tree.getLoader().on('beforeload', function(treeLoader, node){
			this.tree.getLoader().baseParams.channelid = this.channelid;
			this.tree.getLoader().baseParams.tid = this.tid;
		}, this);
		this.local = new Ext.form.ComboBox({ctCls:'local',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode:'local',width:376,triggerAction:'all',tpl:'<tpl for="."><div style="height:220px"><div id="rsb-local"></div></div></tpl>',selectedClass:'',onSelect:Ext.emptyFn,value:'资源点'});
		this.local.tree = new Ext.tree.TreePanel({useArrows:true,border:false,cls:'channel-tree browse-tree',bodyStyle:'padding:1px;',rootVisible:false,autoScroll:true,root:new Ext.tree.TreeNode({id:'0',text:'',leaf:0,expanded:true})});
		this.local.tree.on('render',function(){this.renderTreeNode('local')},this);
		this.local.tree.on('click',function(n){
			if((this.node && this.node == n) || (this.node && this.node.nid && n.nid && n.nid == this.node.nid))return ;
            this.node = n;
            n.attributes['nid'] ? this.browse() : this.viewNode();
			this.tree.selectPath(n.getPath());
			this.local.collapse();
		},this);
		this.local.on('expand',function(c){if(c.tree.rendered){if(this.node)c.tree.selectPath(this.node.getPath())}else{c.tree.render('rsb-local')}},this);

		this.so = new Ext.form.TwinTriggerField({ctCls:'local',emptyText:'搜索 资源',width:200,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
        this.so.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		this.searchbar = new Ext.Toolbar({cls:'address',style:'background:#C6D6E8',items:[
			{ctCls:'back',disabled:true,title:'后退',handler:this.back,scope:this},
			{ctCls:'forward',disabled:true,title:'前进',handler:this.forward,scope:this},
			this.local,
			{ctCls:'refresh',tooltip:'刷新',handler:function(){this.D.reload()},scope:this},'->',
			this.so,''
		]});
		this.toolbar = new Ext.Toolbar({disabled:true,items:[
			{text:'上传',iconCls:'ico_upload',handler:this.upload,scope:this},
			{text:'下载',iconCls:'ico_download',handler:this.download,scope:this},
			{text:'上传队列',handler:function(){EXCMS.Resource.Upload.load({})}},
   			'-',
			{text:'新建文件夹',iconCls:'ico_newfolder',hidden:true,handler:this.newfolder,scope:this},
   			{text:'编辑',menu:{items:[
				{text:'重命名',handler:this.rename,scope:this},'-',
				{text:'删除',handler:this.del,scope:this}
   			]}},
			{text:'查看',menu:{items:[
  				{text:'缩略图',group:'view',checked:true,handler:this.setView,scope:this,mode:1},
  				{text:'详细信息',group:'view',checked:false,handler:this.setView,scope:this},'-',
				{text:'排序',menu:{items:[
					{text:'名称',group:'sort',checked:false,handler:this.sort,scope:this,mode:'name'},
					{text:'大小',group:'sort',checked:false,handler:this.sort,scope:this,mode:'size'},
					{text:'创建日期',group:'sort',checked:true,handler:this.sort,scope:this,mode:'createddata'}
				]}},
				{text:'模式',menu:{items:[
                    {text:'直接浏览文件',group:'mode',checked:true,handler:this.setFolderView,scope:this,folderView:false},
					{text:'显示文件夹结构',group:'mode',checked:false,handler:this.setFolderView,scope:this,folderView:true}
				]}},'-',
				{text:'设置我的浏览模式',handler:this.setting,scope:this},'-',
				{text:'刷新',handler:function(){this.D.reload()},scope:this}
			]}},'-',
   			{text:'选择',menu:{items:[
				 {text:'全选',handler:this.select,scope:this,mode:1},
				 {text:'反选',handler:this.select,scope:this,mode:2},
				 {text:'取消选择',handler:this.select,scope:this,mode:3}
			]}},'->',
			{text:'缩略图',iconCls:'ico_detail',menu:{items:[
				{text:'缩略图',group:'view1',checked:true,handler:this.setView,scope:this,mode:1},
				{text:'详细信息',group:'view1',checked:false,handler:this.setView,scope:this}
			]}},
			{ctCls:'preview',enableToggle:true,pressed:false,tooltip:'显示预览',toggleHandler:this.preview,scope:this}
   		]});
		this.D = new Ext.data.Store({remoteSort:false,
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=getResourceList'}),
			reader:new Ext.data.JsonReader({root:'data',totalProperty:'total', folders:'folders', files:'files', id:'id', fields:['id','name','isfolder','path','sourcesize','size','thumb','attributes','filetype','createddate',{name:'files',type:'int'},{name:'folders',type:'int'},'cls','description','shortname','src']})
		});
		this.D.pagesize = this.pagesize;
		this.contextmenu = new Ext.menu.Menu({items:[
			{text:'选定'},
			{text:'预览'},
			{text:'新建文件夹',iconCls:'ico_newfolder',hidden:true,handler:this.newfolder,scope:this},
			{text:'重命名',handler:this.rename,scope:this},
			{text:'删除',handler:this.del,scope:this},'-',
			{text:'属性',handler:this.properties,scope:this}
		]});
		var tpl = new Ext.XTemplate(
			'<tpl for=".">',
				'<div class="rv-wrap rv-file-{isfolder}" id="{id}">',
				'<tpl if="isfolder==1"><div class="rv-wrap-ct {cls}" title="{name} &#10;创建日期：{createddate} &#10;大小：{size} &#10;包含：{files} 个文件，{folders} 个文件夹"><div class="thumb"></div><span title="{name}">{shortname}</span></div></tpl>',
				'<tpl if="isfolder==2"><div class="rv-wrap-ct {cls}" title="{name} &#10;类型：{filetype} &#10;创建日期：{createddate} &#10;大小：{size}"><div class="thumb"><div><p><strong>图片加载中...</strong><img src="{src}" onload="imageOnLoad(this)" onerror="imageOnError(this)" style="display:none"></p></div></div><span title="{name}">{shortname}</span></div></tpl>',
				'<tpl if="isfolder==3"><div class="rv-wrap-ct rv-wrap-ct-file {filetype}" title="{name} &#10;类型：{filetype} &#10;创建日期：{createddate} &#10;大小：{size}"><div class="rv-wrap-ct-bd"><p class="title">{shortname}</p><p>{[values.filetype.toUpperCase()]} 文件，{size}</p><p>{createddate}</p></div></div></tpl>',
				'</div>',
			'</tpl>',
			'<div class="x-clear"></div>'
		);
		tpl.compile();
		this.dataview = new Ext.DataView({
			id:'rs-card-dataview',
			tpl:tpl,
			multiSelect:true,
			cls:'rs-view',
			overClass:'x-view-over',
			itemSelector:'div.rv-wrap',
			//autoHeight:false,
			autoWidth:true,
			emptyText :'<div style="padding:40px 0 0;text-align:center">没有文件或文件夹</div>',
			store:this.D,
			plugins:[new Ext.DataView.DragSelector()],
			listeners:{
				'selectionchange':{fn:function(){this.showAttributes()},scope:this,buffer:0},
				'dblclick':{fn:this.onDblClick,scope:this},
				'contextmenu':{fn:function(o,i,n,e){
					if(!o.isSelected(i))o.select(i);
					this.selectedRecord = i
					this.showContextMenu(e);
				},scope:this},
				'beforeselect':{fn:function(view){return view.store.getRange().length>0},scope:this}
			}
		});
		this.viewPanel = new Ext.Panel({cls:'img-chooser-view',region:'center',layout:'card',activeItem:0,border:false,items:this.dataview,autoScroll:true,bbar:new Ext.PagingToolbar({pageSize:this.pagesize,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 共：{2}',emptyMsg:'没有资源',beforePageText:'第',afterPageText:'页 共{0}页'})});
		this.previewPanel = new Ext.Panel({region:'east',width:160,border:false,split:true,cls:'details',bodyStyle:'background:#FCFCFC',maxSize:300,minSize:35,autoScroll:true,hidden:true});
		this.mainPanel = new Ext.Panel({layout:'border',border:true,items:[this.tree,this.viewPanel,this.previewPanel],tbar:this.toolbar});
		this.win = new Ext.Window({title:this.title,cls:'rsb-win',layout:'fit',width:755,height:480,minWidth:620,minHeight:420,
			modal:true,closeAction:'hide',border:true,
			items:this.mainPanel,
			buttons:[{text:'确定',handler:function(){this.doCallback()},scope:this},{text:'取消',handler:function(){this.win.hide()},scope:this}],
			keys:{key:27,handler:function(){this.win.hide()},scope:this},
			tbar:this.searchbar
		});
		this.win.on('resize',function(e,w){this.local.setWidth(w-304)},this);
		this.win.show();
		this.D.on('beforeload',function(s,o){
			var tid =  this.history.current.tid;
			var nid = this.history.current.nid;
			var folderView = this.viewmode.folderView ? 1 : 0;
			var fid = this.history.current.fid;
			var folders = files = -1;
			if(this.D.reader.jsonData && this.D.baseParams.folderView == folderView && this.D.baseParams.nid == nid && this.D.baseParams.fid == fid){
				folders = this.D.reader.jsonData.folders;
				files = this.D.reader.jsonData.files;
			}
			this.D.baseParams = {
				keywords : this.keywords,
				tid : tid,
				nid : nid,
				fid : fid,
				folderView : folderView,
				folders : folders,
				sort : this.sortType,
				files : files
			};
			this.mask('正在加载资源数据，请稍候...');
		},this);
		this.D.on('load',function(d,r,o){this.unmask();this.formatData()},this);
		this.D.on('loadexception',function(t,o,r,e){alert(r);this.unmask()},this);
        this.toolbar.items.items[10].setIconClass('ico_thumb');
        this.mainPanel.getEl().dom.oncontextmenu = function(){return false};
        this.local.getEl().dom.oncontextmenu = function(){return false};
	},
	// load resouce type tree data
	loadTree : function(){
		this.tree.el.mask('正在加载资源节点...');
		Ext.Ajax.request({
			url:this.baseAction+'&method=loadResourceConfig',method:'POST',scope:this,params:{channelid:this.channelid,tid:this.tid,nid:this.nid,assocw:this.assocw},
			failure:function(){this.tree.el.unmask();},
			success:function(r,o){
				this.tree.el.unmask();
				r = Ext.decode(r.responseText);
				if(r.success){
					if(r.myconfig){
						this.config = Ext.decode(r.myconfig.resourceconfig) || {view:1,mode:'false',sort:'date'};;
					}
					this.setConfigToobar();
					var viewmode = this.config.mode =='true' ? 1 : 0;
					this.toolbar.items.items[4].setVisible(viewmode);
					this.contextmenu.items.items[2].setVisible(viewmode);
					if(r.nodes){
						this.treeData = r.nodes;
						this.renderTreeNode('type');
						this.renderTreeNode('local');
					}
				}
			}
		});
	},
	// render tree node
	renderTreeNode : function(tree){
		if(!this.treeData) return ;
		tree = tree == 'local' ? this.local.tree : this.tree;
		if(tree.getRootNode().hasChildNodes()){
			 tree.getRootNode().eachChild(function(node){node.remove();});
		}
		if(!tree.rendered) return ;
		for(var i = 0, dlen = this.treeData.length; i < dlen; i++){
			this.treeData[i].expanded = true;
			var node = tree.root.appendChild(new Ext.tree.TreeNode(this.treeData[i]));
			if(node.attributes.children.length > 0){
				var cs = node.attributes.children;
				node.beginUpdate();
				for(var k = 0, len = cs.length; k < len; k++) node.appendChild(new Ext.tree.TreeNode(cs[k]));
				node.endUpdate();
			}
		}
		var n = tree.root.childNodes[0].findChild('default',1);
		if(n){
			n.select();
            this.node = n;
            n.attributes['nid'] ? this.browse() : this.viewNode();
			this.tree.selectPath(n.getPath());
			this.local.collapse();
		}else{
			n = tree.root.childNodes[0].firstChild;
			if(n && n.id){
				n.select();
				this.node = n;
	           	n.attributes['nid'] ? this.browse() : this.viewNode();
				this.tree.selectPath(n.getPath());
				this.local.collapse();
			}
		}
		//tree.root.collapseChildNodes();
		//this.showNodeType();
		this.showNode();
	},
	// refresh tree, only show allowed type node
	showNodeType : function(){
		if((!this.nodetype && this.tree.nodetype) || (this.nodetype && (!this.tree.nodetype || this.nodetype != this.tree.nodetype))){
			this.tree.nodetype = this.nodetype;
			var n = this.tree.root.childNodes;
			for(var i=0,len=n.length;i<len;i++){
				n[i].ui.getEl().style.display = !this.nodetype || this.nodetype == n[i].attributes.name ? 'block' : 'none';
			}
		}
		if(this.local.tree.rendered && (!this.nodetype && this.local.tree.nodetype) || (this.nodetype && (!this.local.tree.nodetype || this.nodetype != this.local.tree.nodetype))){
			this.local.tree.nodetype = this.nodetype;
			var n = this.local.tree.root.childNodes;
			for(var i=0,len=n.length;i<len;i++){
				if(n[i].getUI().getEl) n[i].getUI().getEl().style.display = !this.nodetype || this.nodetype == n[i].attributes.name ? 'block' : 'none';
			}
		}
	},
	showNode : function(){
		
	},
	// on west tree load
	renderLocalTree : function(){
		if(!this.local.tree.rendered) return;
	},
	// render grid
	renderGrid : function(){
		this.grid= new Ext.grid.GridPanel({id:'card-gridpanel',region:'center',enableColumnMove:false,collapsible:false,animCollapse:false,
			minColumnWidth:2,border:false,border:false,sm:new Ext.grid.RowSelectionModel(),loadMask:{msg:'数据加载中...'},
			store:this.D,
			columns:[
				{header:'文件名',width:180,sortable:true,dataIndex:'name',scope:this},
				{header:'创建日期',width:110,sortable:true,dataIndex:'createddate',scope:this},
				{header:'类型',width:60,sortable:true,dataIndex:'filetype',scope:this},
				{header:'大小',width:60,align:'right',sortable:true,dataIndex:'size'},
				{header:'文件夹路径',width:100, hidden: true,sortable:false,dataIndex:'path',scope:this},
				{header:'描述',width:120,sortable:false,dataIndex:'description',scope:this}
			]
		});
		this.grid.on('rowclick',function(g,r,e){this.selectedRecord = r;this.showAttributes()},this);
		this.grid.on('rowdblclick',function(g,r,e){this.onDblClick()},this);
		this.grid.on('rowcontextmenu',function(g,r,e){g.getSelectionModel().selectRow(r);this.showContextMenu(e)},this);
		this.viewPanel.add(this.grid);
		this.dataview.hide();
		this.viewPanel.doLayout();
		this.grid.show();
		this.toolbar.items.items[10].setIconClass('ico_detail');
		this.toolbar.items.items[10].setText('详细信息');
	},
	// search trigger event
	soOnTrigger1Click:function(){this.so.reset();this.keywords='';this.D.reload({params:{start:0,limit:this.pagesize}});},
	soOnTrigger2Click:function(){var key=this.so.getValue().trim();if(key!=''){this.keywords= key;this.D.reload({params:{start:0,limit:this.pagesize}});}},
	// browse resource node
	browse:function(item){
		this.loadData({tid:parseInt(this.node.parentNode.attributes.tid), nid:this.node.id, name:this.node.text, fid:0});
		this.setConfigToobar();
		this.setNodeToolbar(true);
		this.setView();
	},
	// load data
	loadData : function(item){
		this.local.setValue(item.name);
		if(this.history){
			if(this.history.current.tid != item.tid || this.history.current.nid != item.nid || this.history.current.fid != item.fid){
				this.history.back.push(this.history.current);
				this.history.current = {tid:item.tid, nid:item.nid, name:item.name, fid:item.fid};
				this.history.forward = [];
				this.setHistoryTitle();
			}
		}else{
			this.history = {back:[], forward:[], current:{tid:item.tid, nid:item.nid, name:item.name, fid:item.fid}, total:15};
		}
		this.D.load({params:{start:0, limit:this.pagesize}});
	},
	// format data
   	formatData :function(){
		var len = this.D.getCount();
		for(var i=0;i<len;i++){
			var r = this.D.getAt(i);
			//data.dateString = data.lastmod;
			if(r.data.isfolder == 1){
				r.set('shortname',r.data.name.ellipse(15));
				if(this.node.attributes.type == 'image'){
					r.set('cls', 'imagefolder');
				}else if(r.data.folders > 0){
					r.set('cls', 'havefolders');
				}else if(r.data.files > 0){
					r.set('cls', 'havefiles');
				}else{
					r.set('cls', 'folder');
				}
			}else if(this.node.attributes.type == 'image'){
				r.set('isfolder', 2);
				var sn = r.data.description ? r.data.description : r.data.name;
				r.set('shortname', sn.ellipse(15));
				r.set('shortname', r.data.description ? r.data.description : r.data.name);
				if(r.data.thumb.indexOf('t') < 0){
					var thumb = r.data.thumb.split(',');
					var idx = r.data.name.lastIndexOf('.');
					var filename = r.data.name.substr(0, idx) + '_' + thumb[0] + r.data.name.substr(idx);
				}else{
					var filename = r.data.name;
				}
				r.set('src', this.node.attributes.url + r.data.path + '/' + filename);
			}else{
				r.set('isfolder', 3);
				var sn = r.data.description ? r.data.description : r.data.name;
				r.set('shortname', sn.ellipse(32));
				if(r.data.thumb.indexOf('t') < 0){
					var thumb = r.data.thumb.split(',');
					var idx = r.data.name.lastIndexOf('.');
					var filename = r.data.name.substr(0, idx) + '_' + thumb[0] + r.data.name.substr(idx);
				}else{
					var filename = r.data.name;
				}
				r.set('src', this.node.attributes.url + r.data.path + '/' + filename);
			}
			if(r.data.size){
				r.set('sourcesize',r.data.size);
				r.set('size',formatSizes(r.data.size));
			}
		}
		this.D.commitChanges();
	},
	//set view mode
	setView:function(item){
		if(item) this.viewmode.view = item.mode ? true : false;
		var f = this.viewmode.view;
		if(!(f || this.grid)) this.renderGrid();
		this.viewPanel.layout.setActiveItem(f ? this.dataview : this.grid);
		this.toolbar.items.items[10].setIconClass(f ? 'ico_thumb' : 'ico_detail');
		this.toolbar.items.items[10].setText(f ? '缩略图' : '详细信息');
		this.toolbar.items.items[6].menu.items.items[f ? 0 : 1].setChecked(true);
		this.toolbar.items.items[10].menu.items.items[f ? 0 : 1].setChecked(true);
	},
	// set tree node bar
	setNodeToolbar : function(f){
		if(this.viewPanel.bottomToolbarView == f) return ;
		this.viewPanel.bottomToolbarView == f;
		this.toolbar.setDisabled(!f);
		var bt = this.viewPanel.getBottomToolbar();
		if(!bt.oHeight) bt.oHeight = bt.getEl().getHeight();
		var h = this.viewPanel.getEl().getHeight();
		this.viewPanel.body.setHeight(f ? h - bt.oHeight : h);
		if(this.nodetype=='image'){
			this.toolbar.items.items[2].hide();
		}else{
			this.toolbar.items.items[2].show();
		}
		bt.setVisible(f);
	},
	// set selection model
	setSelectionModel : function(s){
		this.single = s||false;
		this.record = null;
		if(this.viewmode.view){
			this.dataview.multiSelect = !s;
			this.dataview.singleSelect = s;
			this.dataview.clearSelections();
		}else{
			if(!this.grid) this.renderGrid();
			this.grid.getSelectionModel().singleSelect = s;
			this.grid.getSelectionModel().clearSelections();
		}
	},
	// get select records
	getSelectRecords : function(){return this.viewmode.view?this.dataview.getSelectedRecords():this.grid.getSelectionModel().getSelections()},
	mask : function(message){this.viewPanel.el.mask(message)},
	unmask : function(){this.viewPanel.el.unmask()},
	// before context menu show event
	showContextMenu : function(e){
		var record = this.getSelectRecords()[0].data;
		if(this.imageType.indexOf(record.filetype) >= 0){
			this.contextmenu.items.items[0].show();
			this.contextmenu.items.items[1].show();
			if(!record.renderThumbMenu){
				record.renderThumbMenu = true;
				var thumb = record.thumb.split(',');
				var len = thumb.length;
				if(len){
					record.imageMenu = new Ext.menu.Menu();
					record.previewMenu = new Ext.menu.Menu();
					for(var i=0;i<len;i++){
						var text = this.nameArray[thumb[i]] || thumb[i] ;
						record.imageMenu.add({text:text, handler:this.selectImage, scope:this, postfix:thumb[i]});
						record.previewMenu.add({text:text, handler:this.previewImage, scope:this, postfix:thumb[i]});
					}
				}
			}
			if(record.imageMenu){
				this.contextmenu.items.items[0].menu = record.imageMenu;
				this.contextmenu.items.items[1].menu = record.previewMenu;
			}else{
				this.contextmenu.items.items[0].menu = null;
				this.contextmenu.items.items[1].menu = null;
			}
		}else{
			this.contextmenu.items.items[0].hide();
			this.contextmenu.items.items[1].hide();
		}
		this.contextmenu.showAt(e.getXY());
	},
	// preview image
	previewImage : function(item){
		var postfix = item && item.postfix ? item.postfix : 'm';
		var record = this.D.getAt(this.selectedRecord);
		if(record){
			var src = this.node.attributes.url + record.data.path + '/' + record.data.name;
			if(this.postfixArray[postfix]) postfix = this.postfixArray[postfix];
			if(postfix && postfix != 't' && record.data.thumb.indexOf(postfix) >= 0){
				var idx = src.lastIndexOf('.');
				src = src.substr(0, idx) + '_' + postfix + src.substr(idx);
			}else if(record.data.thumb.indexOf(postfix) < 0){
				var thumb = record.data.thumb.split(',');
				if(thumb[0]!='t'){
					var idx = record.data.name.lastIndexOf('.');
					src = this.node.attributes.url + record.data.path + '/' + record.data.name.substr(0, idx) + '_' + thumb[0] + record.data.name.substr(idx);
				}
			}
			EXCMS.Previewer.image(src);
		}
	},
	// format image
	getPostfixSrc : function(src,thumb,postfix){
		if(this.postfixArray[postfix]) postfix = this.postfixArray[postfix];
		if(thumb.indexOf(postfix)== -1)	postfix = 't';
		if(postfix == 't') return src;
		var idx = src.lastIndexOf('.');
		return src.substr(0, idx) + '_' + postfix + src.substr(idx);
	},
	// insert image
	selectImage  : function(item){
		if(item && item.postfix){
			this.postfix = item.postfix;
		}
		this.doCallback();
	},
	// 双击行列表
	onDblClick : function(){
		var record = this.getSelectRecords();
		if(!record) return ;
		if(record[0].data.isfolder == 1) {
			this.loadData({tid:parseInt(this.node.parentNode.id), nid:this.node.id, name:record[0].data.name, fid:record[0].data.id});
		}else{
			this.doCallback();
		}
	},
	// 显示详细信息
	showAttributes : function(){
		var data = this.getSelectRecords();
        if(!data || data.length < 1) return ;
        data = data[0].data;
		if(this.attributesTemplate && this.attributesTemplate.dataid && this.attributesTemplate.dataid == data.id) return ;
		if(data.isfolder == 1){
			if(!this.folderTemplate){
				this.folderTemplate = new Ext.XTemplate(
					'<tpl for=".">',
						'<div class="rv-wrap"><div class="rv-wrap-ct {cls}"></div></div>',
						'<div class="details-info">',
						'<div>{name}</div>',
						'<div><em>文件夹</em></div>',
						'<div><em>包含:</em>{files} 个文件，{folders} 个文件夹</div>',
						//'<div><em>修改日期:</em>{dateString}</div>',
						'<div><em>创建时间:</em>{createddate}</div></div>',
					'</tpl>'
				);
				this.folderTemplate.compile();
			}
			this.attributesTemplate = this.folderTemplate;
		}else{
			if(!this.filesTemplate){
				this.filesTemplate = new Ext.XTemplate(
					'<tpl for=".">',
						'<div class="rv-wrap"><div class="rv-wrap-ct {cls}"><div class="thumb"><div><p><strong>图片加载中...</strong><img src="{src}" onload="imageOnLoad(this)" onerror="imageOnError(this)" style="display:none"></p></div></div></div></div>',
						'<div class="details-info">',
						'<div>{name}</div>',
						'<div><em>{filetype}</em></div>',
						'<div><em>大小:</em>{size}</div>',
						//'<div><em>修改日期:</em>{dateString}</div>',
						'<div><em>创建日期:</em>{createddate}</div>',
						'<div><em>描述:</em>{description}</div></div>',
					'</tpl>'
				);
				this.filesTemplate.compile();
			}
			this.attributesTemplate = this.filesTemplate;
		}
		this.attributesTemplate.dataid = data.id;
        this.attributesTemplate.overwrite(this.previewPanel.body, data);
	},
	// download resource
	download : function(){
		var selected = this.getSelectRecords();
		if(selected.length==0){alert('请选择要下载的文件！');return;}
		var src = this.baseAction+"&method=down&rid="+ selected[0].id +"&nid="+this.node.id;
		if(!this.getdownIframe)this.getdownIframe = Ext.getDom('getdownIframe');
		this.getdownIframe.src = src;
	},
	// create new folder
	newfolder : function(){
	    Ext.MessageBox.prompt('新建文件夹', '请输入文件夹名称：', function(btn,txt){
	    	if(btn=='ok'){
                if(txt == '') {alert("文件夹名称不能为空");return this.newfolder();}
	    		var reg= new RegExp(/^[\._\-0-9a-zA-Z]+$/);
	    		if(!reg.test(txt)){
	    			alert('不是合法文件夹名称');
	    			return this.newfolder();
	    		}
                this.mask('正在创建文件夹，请稍后...');
		        Ext.Ajax.request({
		        	url: this.baseAction+'&method=createFolder',
		        	method: 'POST',
		        	params:{folder:txt,nid:this.node.id,pid:this.history.current.fid},
	                success:function(r,o){
                        this.unmask();
	                    r = jsonReturn(r);
	                    alert(r.message);
						this.D.load({params:{start:0,limit:this.pagesize}});
	                },
	                scope:this
	            },this);
		    }
	    },this);
	},
	// delete resource
	del : function(){
		if(!confirm("确定要删除所选的资源吗?\n警告：如果资源在内容中使用，删除资源后可以导致资源无法获取!")) return;
		var records = this.getSelectRecords();
		var data = [];
		for(var i=0,len=records.length;i<len;i++){
			data.push({id:records[i].id,isfolder:records[i].data.isfolder});
		}
		this.mask();
		Ext.Ajax.request({
			url: this.baseAction+'&method=delete',method: 'POST',params:{nid:this.node.id,files:Ext.util.JSON.encode(data)},scope:this,
			success:function(r,o){this.unmask();r=jsonReturn(r);if(r.success){for(var i=0;i<records.length;i++)this.D.remove(records[i]);}else{alert(r.message)}},
			failure:function(r,o){this.unmask();alert(r)}
		},this);
	},
	// rename resource
	rename : function(item){
		var record = this.getSelectRecords();
		record = record[0];
		if(record.data.isfolder == 1){
			Ext.MessageBox.prompt('重命名文件夹', '请输入新文件夹名称：' ,function(btn,txt){if(btn=='ok'){
				txt = txt.trim();
				if(txt == '') return ;
				var reg= new RegExp(/^[\._\-0-9a-zA-Z]+$/);
	    		if(!reg.test(txt)){
					alert('非法的文件名，文件名只能由数字、字母、下划线、点组成');
					return this.rename();
				}
				if(txt == record.data.name) return ;
				this.mask('正在重命名资源文件，请稍后...');
				Ext.Ajax.request({
					url: this.baseAction+'&method=rename',
					method: 'POST',
					params:{nid:this.node.id, name:txt, id:record.id, isfolder:1},
					scope:this,
					success:function(r,o){
						this.unmask();
						r = jsonReturn(r);
						if(r.success){
							record.set('name', txt);
							if(record.data.isfolder != 1) record.set('descriptoin', description);
						}else{
							alert(r.message);
						}
					},
					failure:function(r,o){this.unmask();alert(r)}
				},this);
			}}, this, false, record.data.name);
		}else{
			if(!this.renameWin){
				this.renameForm = new Ext.FormPanel({url:this.baseAction+'&method=rename',border:false,bodyStyle:'padding:15px;overflow-x:hidden',labelWidth:48,defaults:{xtype:'textfield',anchor:'98%'},waitMsgTarget:true,items:[
					{xtype:'hidden',name:'id'},
					{fieldLabel:'文件名',name:'name',maxLength:40},
					{fieldLabel:'描述',name:'description',xtype:'textarea',height:52}
				]});
				this.renameWin = new Ext.Window({title:'重命名文件',layout:'fit',maximizable:false,minimizable:false,modal:true,
					resizable:false,width:400,height:180,bodyStyle:'background:#FFFFFF',
					closeAction:'hide',plain:false,autoScroll:true,items:this.renameForm,
					buttons:[{text:'确定',scope:this,handler:function(){
						var values = this.renameForm.form.getValues();
						var name = values.name.trim();
						var description = values.description.trim();
						var oldname = this.renameForm.form.record.data.name;
						if((name == '' || name == oldname) && description == this.renameForm.form.record.data.description){
							this.renameWin.hide();
							return ;
						}
						if(name != '' && name != oldname){
							var filetype = name.lastIndexOf('.');
							if((filetype < 0 || name.substr(filetype + 1) != this.renameForm.form.record.data.filetype) 
								&& !confirm("如果改变文件扩展名，可能会导致文件不可用。/确实要更改吗?")){
								var field_name = this.renameForm.form.findField('name');
								field_name.setValue(oldname);
								field_name.focus();
								return ;
							}
							if(filetype == 0){
								alert('必须键入文件名');
								this.renameForm.form.findField('name').focus();
								return ;
							}
						}
						this.renameForm.form.submit({waitMsg:'数据保存中...', params:{nid:this.node.id}});
					}},{text:'取消',handler:function(){this.renameWin.hide()},scope:this}]
				});
				this.renameWin.show();
				this.renameForm.form.on('actioncomplete',function(){
					var values = this.renameForm.form.getValues();
					this.renameForm.form.record.set('name', values.name);
					this.renameForm.form.record.set('description', values.description);
					var sn = values.description ? values.description : values.name;
					this.renameForm.form.record.set('shortname', sn.ellipse(14));
					this.renameWin.hide();
				},this);
			}
			this.renameWin.center();
			this.renameWin.show();
			var values = {id:record.id, name:record.data.name, description:record.data.description};
			this.renameForm.form.record = record;
			this.renameForm.form.setValues(values);
		}
	},
	// forward
	forward : function(){this.historyExecute('forward')},
	// back
	back : function(){this.historyExecute('back')},
	// back forward excued
	historyExecute:function(bof){
		var a,b,c;
		if(bof == 'back'){a = 'forward';b = 0;c = 1;}else{a = 'back';b = 1;c = 0;}
		this.history[a].push(this.history.current);
		var h = this.history.current = this.history[bof].pop();
		this.local.setValue(h.name);
		this.setHistoryTitle();
		this.tree.selectPath('/0/0' + h.tid + '/' + h.nid);
		this.D.load({params:{start:0, limit:this.pagesize}});
	},
	// set histor toolbar
	setHistoryTitle:function(i,t){
		var items = this.searchbar.items.items;
		var a = this.history.back.length;
		var b = this.history.forward.length;
		items[0].setDisabled(!a);
		items[1].setDisabled(!b);
		items[0].el.dom.title = a ? '后退到 ' + this.history.back[a - 1].name : '';
		items[1].el.dom.title = b ? '前进到 ' + this.history.forward[b - 1].name : '';
	},
 	// preview
 	preview:function(e,p){
		this.previewPanel.setVisible(p);
		if(p) this.showAttributes();
		this.mainPanel.ownerCt.doLayout();
	},
	// set view mode
	setFolderView : function(item){
		var f = item.folderView ? true : false;
		this.viewmode.folderView = f;
		this.toolbar.items.items[4].setVisible(f);
		this.contextmenu.items.items[2].setVisible(f);
		this.toolbar.items.items[6].menu.items.items[4].menu.items.items[f ? 1 : 0].setChecked(true);
		this.loadData({tid:parseInt(this.node.parentNode.id), nid:this.node.id, name:this.node.text, fid:0});
	},
	// select record
	select : function(item){
		var mode = item && item.mode ? item.mode :1;
		var len = this.D.getCount();
		if(!len) return ;
		if(this.viewmode.view){
			var dv = this.dataview;
			switch(mode){
				case 1 : for(var i=0;i<len;i++) dv.select(i,true); break;
				case 2 : for(var i=0;i<len;i++) dv.isSelected(i) ? dv.deselect(i) : dv.select(i,true);break;
				case 3 : dv.clearSelections();break;
			}
		}else{
			var sm = this.grid.getSelectionModel();
			switch(mode){
				case 1 : sm.selectAll();break;
				case 2 : for(var i=0;i<len;i++) sm.isSelected(i) ? sm.deselectRow(i) : sm.selectRow(i,true);break;
				case 3 : sm.clearSelections();break;
			}
		}
	},
	// setting my mode
	setting:function(){
		if(!this.settingDialog){
			this.settingForm = new Ext.form.FormPanel({border:false,bodyStyle:'padding:8px 12px',labelWidth:80,items:[
				{xtype: 'radiogroup',
                fieldLabel: '查看方式',
                itemCls: 'x-check-group-alt',
                columns: 1,
                items: [
                    {boxLabel: '缩略图', name: 'view', inputValue:1, checked: true},
                    {boxLabel: '详细信息', name: 'view', inputValue:0}
                ]},
                {xtype: 'radiogroup',
                fieldLabel: '排序方式',
                itemCls: 'x-check-group-alt',
                columns: 1,
                items: [
                    {boxLabel:'名称',name:'sort',inputValue:'name'},
					{boxLabel:'大小',name:'sort',inputValue:'size'},
					{boxLabel:'修改时间',name:'sort',inputValue:'date',checked:true}
                ]},
                {xtype: 'radiogroup',
                fieldLabel: '显示模式',
                itemCls: 'x-check-group-alt',
                columns: 1,
                items: [
                    {boxLabel:'文件',name:'mode',inputValue:false,checked:true},
					{boxLabel:'文件和文件夹',name:'mode',inputValue:true}
                ]}
			]});
            this.settingDialog = new Ext.Window({title:'设置我的浏览模式',width:320,height:270,layout:'fit',closeAction:'hide',plain:true,modal:true,items:this.settingForm,buttons:[
				{text:'确定',handler:this.settingCommit,scope:this},
				{text:'取消',handler:function(){this.settingDialog.hide();},scope: this}
			]});
            this.settingForm.form.on('actioncomplete',function(form,action){
                alert(action.result.message);
                if(action.result.success){
                      this.config = this.settingForm.form.getValues();
					  this.setConfigToobar();
                      this.sort({mode:this.config.sort});
                      this.settingDialog.hide();
                }
            }, this);
		}
		this.settingDialog.show();
        this.settingForm.form.setValues(this.config);
	},
	setConfigToobar : function(){
		this.setView({mode:this.config.view == '1' ? 1 : 0});
		this.sortType = this.config.sort;
		this.viewmode.folderView = this.config.mode =='true' ? 1 : 0;
		this.toolbar.items.items[6].menu.items.items[3].menu.items.items[this.config.sort=='name' ? 0 : this.config.sort=='size' ? 1 : 2].setChecked(true);
		this.toolbar.items.items[6].menu.items.items[4].menu.items.items[this.config.mode=='true' ? 1 : 0].setChecked(true);
	},
	settingCommit : function(){
        this.settingForm.form.submit({url:this.baseAction + '&method=setting',waitMsg:'正在保存数据，请稍后...'});
    },
    // sort
	sort :function(item){
        var v = item.mode;
        this.sortType = item.mode;
        this.D.reload({params:{start:0,limit:this.pagesize,sort:v}});
    },
	// call back
	doCallback :function(){
		var record = this.getSelectRecords();
		var data = new Array;
		if(record && record.length > 0){
			if(this.callback){
				var r, filname;
				var resourcetype = this.tree.getNodeById('0' + this.history.current.tid).attributes.name;
				if(this.postfix && this.postfixArray[this.postfix]) this.postfix = this.postfixArray[this.postfix];
				for(var i=0;i<record.length;i++){
					var fix = this.postfix;
					if(this.postfix && record[i].data.thumb.indexOf(this.postfix)==-1){
						if(this.postfix == 't' || this.postfix == 'thumb'){
							if(record[i].data.thumb.indexOf('ss')>=0) fix='ss'; else if(record[i].data.thumb.indexOf('ls')>=0) fix='ls'; else if(record[i].data.thumb.indexOf('m')>=0) fix='m'; else if(record[i].data.thumb.indexOf('l')>=0) fix='l'; else fix='o';
						}else{
							if(record[i].data.thumb.indexOf('m')>=0) fix='m'; else if(record[i].data.thumb.indexOf('l')>=0) fix='l'; else if(record[i].data.thumb.indexOf('o')>=0) fix='o'; else if(record[i].data.thumb.indexOf('ss')>=0) fix='ss'; else fix='ls';
						}
					}
					if(fix == 't' || fix == 'thumb') fix = '';
					r =  'resource:' + record[i].data.id + ':'+ fix + ':' + this.node.id  + ':' + record[i].data.path + '/' + record[i].data.name;
					var src = this.node.attributes.url + record[i].data.path + '/' + record[i].data.name;
					data.push({
						rid : record[i].data.id,
						tid : this.history.current.tid,
						nid : this.history.current.nid,
						filename : record[i].data.name,
						path : record[i].data.path,
						filesize : record[i].data.sourcesize,
						src : fix ? this.getPostfixSrc(src,record[i].data.thumb,fix) : src,
						description : record[i].data.description,
						resourcetype : resourcetype,
						resource:r,
						code : ''
					});
				}
				this.callback(this.single ? data[0] : data);
			}
		}else{
			alert('请先选中您要选择的文件');return;
		}
		this.win.hide();
    },
	// Change to node view mode
	viewNode:function(){
		this.setNodeToolbar(false);
		if(!this.nodeViewPanel){
			this.nodeViewPanel = new Ext.Panel({border:false,html:''});
			this.viewPanel.add(this.nodeViewPanel);
			this.viewPanel.doLayout();
			this.viewPanel.layout.setActiveItem(this.nodeViewPanel);
		}
		var html = '<div class="rn-view"><h2>' +  + '</h2>';
		var html = document.createElement('div');
		html.className = 'rn-view';
		var title = document.createElement('h2');
		title.innerHTML = this.node.text;
		this.local.setValue(this.node.text);
		html.appendChild(title);
		var box,contains;
		var tthis = this;
		var n = this.node.childNodes;
		for(var i=0,len=n.length;i<len;i++){
			var att = n[i].attributes;
			box = document.createElement('div');
			box.fullpath = n[i].getPath();
			box.className = 'box';
			contains = formatSizes(att.size) + '，' + att.files + ' 个文件，' + att.folders + ' 个文件夹';
			box.innerHTML = '<div class="'+this.node.attributes.name+'"><h3>'+att.text+'('+att.alias+')'+'</h3><p>'+contains+'</p></div>';
			html.appendChild(box);
			box.onmouseover = function(){setCls(this,'over')}
			box.onmouseout = function(){setCls(this,'over',true)}
			box.onclick = function(){
				if(this.parentNode.activeNode){setCls(this.parentNode.activeNode,'click',true)}
				this.parentNode.activeNode=this;
				setCls(this,'click');
			}
			box.ondblclick = function(){
				tthis.tree.selectPath(this.fullpath);
				tthis.node = tthis.tree.getSelectionModel().getSelectedNode();
				tthis.browse();
			}
			Ext.get(box).on('contextmenu',function(e){
				tthis.tree.selectPath(box.fullpath);
				tthis.node = tthis.tree.getSelectionModel().getSelectedNode();
				setCls(e.getTarget('div.box'),'click');
				this.nodemenu.showAt(e.getXY());
			},this);
			box.oncontextmenu = box.onselectstart = function(){return false}
		}
		this.nodeViewPanel.body.dom.innerHTML = '';
		this.nodeViewPanel.body.dom.appendChild(html);
		this.viewPanel.layout.setActiveItem(this.nodeViewPanel);
	},
	// Show upload panel to upload file
	upload:function(){
		if(!this.node || !this.node.attributes.nid){
			alert("对不起，当前不能上传，请先切换至资源点视图!\n点击或者展开右边的资源结点树，选择文件要上传到的目的资源点");
			return ;
		}
		var model = this.node.attributes.type == 'image' ? 'Resource.ImageSelector' : 'Resource.Upload';
		EXCMS.util.QuickCreate({model:model, action:'upload',config:this.node.attributes.config.image,nid:this.node.id, nodename:this.node.text, channelid:this.channelid, filetype: this.node.attributes.config.filetype, filesize: this.node.attributes.config.size, fid: this.history.current.fid,assocw:this.assocw,store:this.D});
	}
};