/* $Id: Config.js 397 2009-12-21 15:42:48Z zhangxuelin $ */
EXCMS.Resource.Config={
	baseAction : 'index.php?M=Resource&A=Action',
	thumb:new Array(),
	load:function(item){
		if(!item.tabPanel){alert('无法找到加载容器');return}
		if(!item.nid){alert('缺少资源点对象');return}
		if(!item.store){alert('缺少资源点数据');return}
		this.tabPanel = item.tabPanel;
		this.store = item.store;
		var panel_id = 'node-config-panel-' + item.nid;
		var panel = this.tabPanel.getComponent(panel_id);
		var name = item.store.getById(item.nid).get('name');
		var type = item.store.getById(item.nid).get('type');
		var title = '配置' + name;
		var tabTip  = '';
		if(title.length > 8){tabTip=title;title = title.substr(0,8) + '...'}
		if(!panel){
			var D = new Ext.data.Store({
	            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=nodestore'}),
	            reader: new Ext.data.JsonReader({
	                root:'data',totalProperty:'total',id:'nid',
	                fields: ['nid','name','alias','tid','type','isremote','domain','dbsave','status','files','folders','size',{name:'sort',type:'int'}]
	            }),
				remoteSort:false
	        });
	        var G = new Ext.grid.EditorGridPanel({title:'资源属性',cls:'excms-tabpanel-collapsible',height:120,collapsible:true,enableColumnMove:false,animCollapse:false,minColumnWidth:7,sm:new Ext.grid.RowSelectionModel(),
	            store:D,
	            columns:[
	                new Ext.grid.RowNumberer(),
	                {header:'ID',width:60,sortable:true,dataIndex:'nid'},
						{header:'名称',width:150,sortable:true,dataIndex:'name'},
						{header:'别名',width:100,sortable:true,dataIndex:'alias'},
	                {header:'排序',align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField()}
	            ],		
	            tbar:[
					{text:'增加',handler:this.browse,scope:this},
					{text:'编辑',handler:this.nodeEdit,edit:1,scope:this},
					{text:'删除',handler:this.del,scope:this}
	            ]
	        });
	        
			var style = 'display:block;margin:0 0 6px 0;text-indent:106px;color:#666;';
			panel = new Ext.form.FormPanel({id:panel_id,title:title,tabTip:tabTip,url:this.baseAction+'&method=config',
				border:false,bodyStyle:'padding:15px 0 15px 24px;overflow-x:hidden',labelWidth:100,
				defaults:{xtype:'textfield',anchor:'-24'},closable:true,autoScroll:true,
				waitMsgTarget:true,items:[
				{xtype:'hidden',name:'type',value:type},
				{xtype:'label',html:'<span style="display:block;float:left;width:106px">资源点：</span>'+name,style:style+'text-indent:0px;color:#000'},
				{fieldLabel:'上传文件类型',name:'filetype',xtype:'textfield',decimalPrecision:0},
				{xtype:'label',html:'允许上传的文件类型，多个类型请使用逗号隔开“,”，如：jpg,png,gif,bmp，为空时不限制上传文件类型',style:style},
				{fieldLabel:'上传文件大小',name:'size'},
				{xtype:'label',html:'限制上传文件大小的最大值，不限制时留空或者设为0，单位为KB',style:style},
				{fieldLabel:'调用代码',name:'code',xtype:'textarea',height:100},
				{xtype:'label',html:'可用标签：{filename}文件名，{description}描述',style:style}
			],tbar:[
				{text:'保存',handler:this.submit,scope:this},
				{text:'重置',handler:this.reset,scope:this},
				{text:'取消',handler:this.cancel,scope:this}
			]});
			panel.nid = item.nid;
			panel.grid = G;
			panel.type = type;
			var tp = this.renderTypeConfig(panel.type);
			if(tp){panel.add(tp)}
			panel.on('afterlayout', this.setValues, this);
			this.tabPanel.add(panel);
		}else{
			this.tabPanel.unhideTabStripItem(panel);
		}
		this.tabPanel.activate(panel);
	},
	setValues:function(fp){
		if(fp.isSetValue) return ;
		fp.isSetValue = true;
		var data = this.store.reader.jsonData.nodes[this.store.indexOfId(fp.nid)].config;
		fp.form.trackResetOnLoad = true;
		fp.form.setValues(data);
		fp.form.trackResetOnLoad = false;
		if(data && data.type && data[data.type]){
			fp.type = data.type;
			this.setTypeConfig(data.type, data[data.type]);
		}
	},
	// render resource type config
	renderTypeConfig:function(type){
		switch(type){
			case 'image' : 
				return new Ext.Panel({border:false,layout:'form',
					html:'<div class="st-thumb"><div class="label">图片设置：</div><div class="image-dataview-operate operatebtn st-thumb-btn"><a onclick="EXCMS.Resource.Config.editThumb();" href="javascript:void(0);" onmousedown="setCls(this,\'mousedown\')" onmouseup="setCls(this,\'mousedown\',true)" onmouseout="setCls(this,\'mousedown\',true)"><em>添加图片设置</em></a></div><div class="st-thumb-items"></div></div>',
					listeners:{'afterlayout':{fn:function(e){var p=this.getPanel();if(!p.thumbItems){p.thumbItems=e.body.child('div.st-thumb-items',true);}},scope:this}}
				});
				
		}
	},
	// set resource type config
	setTypeConfig:function(type, config){
		switch(type){
			case 'image' :
				EXCMS.util.QuickCreate({model:'Resource.image',action:'render', thumbItems:this.getPanel().thumbItems, config:config});
				break;
		}
	},
	// get resource type config
	getTypeConfig:function(type){
		switch(type){
			case 'image' : return this.getPanel().thumbItems.items ? this.getPanel().thumbItems.items : null; break;
		}
	},
	// add or edit a thumb config
	editThumb:function(o){
		var thumb = o ? o.parentNode : null;
		EXCMS.util.QuickCreate({model:'Resource.image', thumbItems:this.getPanel().thumbItems, thumb:thumb});
	},
	// submit config
	submit:function(){
		var p = this.getPanel();
		var config = p.form.getValues();
		var v = this.getTypeConfig(p.type);
		if(v){config[p.type] = v}
		p.getEl().mask('正在获取保存资源点配置,请稍侯...');
		Ext.Ajax.request({
			url:this.baseAction+'&method=commitNodeConfig',method:'post',params:{nid:p.nid, config:Ext.encode(config)},
			success:function(r,o){
				p.getEl().unmask();
				r=jsonReturn(r);
				alert(r.message);
				if(r.success){
					this.store.reader.jsonData.nodes[this.store.indexOfId(p.nid)].config = config;
					this.tabPanel.remove(this.getPanel())
				}
			},failure:function(){p.getEl().unmask();alert('请求服务器失败，请重试')},
			scope:this
		});
	},
	// reset config
	reset:function(){this.getPanel(true).reset()},
	// cancel config resource node
	cancel:function(){var p=this.getPanel();if(!p.form.isDirty()||confirm('配置信息已更改，确定不保存配置吗?')){this.tabPanel.remove(p)}},
	// get panel
	getPanel:function(f){return f?this.tabPanel.getActiveTab().form:this.tabPanel.getActiveTab()}
};