EXCMS.Resource.ResourceBind = {
	baseAction : 'index.php?M=Resource&A=ResourceBoundAction',
	render : function(){
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=loadBindResource'}),
            reader: new Ext.data.JsonReader({
                root:'data',id:'nid',
                fields:['nid','name','alias','_type','tid','default','binding']
            }),
			remoteSort:false
        });
        this.grid = new Ext.grid.GridPanel({enableColumnMove:false,collapsible:true,animCollapse:false,minColumnWidth:7,border:false,sm:new Ext.grid.RowSelectionModel(),
            store:this.D,loadMask:{msg:'正在加载数据,请稍后...'},
            columns:[
                new Ext.grid.RowNumberer(),
				{header:'名称',width:150,sortable:true,dataIndex:'name'},
				{header:'别名',width:80,sortable:true,dataIndex:'alias'},
                {header:'类型',width:60,sortable:true,dataIndex:'_type'},
				{header:'默认资源点?',width:80,align:'center',sortable:true,dataIndex:'default',renderer:this.renderDefault,scope:this},
				{header:'强制绑定?',dataIndex:'binding',width:80,renderer:this.renderBinding,scope:this}
            ],
            tbar:[
				{text:'添加',handler:this.addResource,scope:this},
				{text:'删除',handler:this.removeResource,scope:this},
				{text:'强制绑定',handler:this.setting,scope:this,mode:['binding',1]},
				{text:'设为默认',handler:this.setting,scope:this,mode:['default',1]},
                {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this},
                '->',
				{boxLabel:'是否继承项级栏目',xtype:'checkbox',name:'extchannel',check:true,listeners:{check:function(o,check){this.extchannel = check ? 1 : 0;},scope:this}}
            ]
        });
        this.grid.on('rowclick',function(g,r,e){
        	var record = this.D.getAt(r);
        	this.setToolbar(record.data.binding,record.data['default']);
        },this);
        this.grid.on('rowdblclick',this.submit,this); 
        this.D.on('load',function(s,r,o){this.modify = s.reader.jsonData.extchannel;this.grid.getTopToolbar().items.items[6].setValue(this.modify);},this);
        this.win=new Ext.Window({id:'dlg-cms-resource-binding',title:'',layout:'fit',maximizable:true,modal:false,
			resizable:false,width:550,height:350,closeAction:'hide',plain:false,
			items:this.grid,
			buttons:[
				{text:'确定',handler:this.submit,scope:this},
				{text:'取消',handler:this.cancel,scope:this}
			]
		});
	},
	//加载对话框
	load : function(item){
		this.itemid = item.config.itemid;
		this.type = item.config.type;
		this.config = item.config;
		this.callback = item.callback;
		if(!this.itemid){
			alert('请选择要绑定的项目');
			return ;
		}
		if(!this.win){this.render();}
		var title = '(' +this.config.name +') 绑定资源';
		this.win.setTitle(title);
		this.win.show();
		this.D.baseParams = {itemid:this.itemid,type:this.type};
		this.D.load();
		
		this.resourceData = {'add':[],'delete':[]}; 
		this.extchannel = false;
		
		this.setToolbar(0,0,this.type==2);
	},
	//添加资源
	addResource : function(){
		if(!this.resource_win){
	        var record = Ext.data.Record.create(['itemid','name',,'tid','alias','files','folders','size','_id','_parent','_is_leaf']);
	        this.resource_d = new Ext.ux.maximgb.treegrid.AdjacencyListStore({
	            autoLoad:true,
	            url:this.baseAction + '&method=resourceGrid',
	            reader: new Ext.data.JsonReader({id:'itemid',root:'data'},record)
	        });
	        this.resourcegrid = new Ext.ux.maximgb.treegrid.GridPanel({
	          store: this.resource_d,
	          master_column_id:'id',
	          columns: [
	         	{id:'id',header:'ID',width:80,sortable:true,dataIndex:'itemid'},
	          	{header:'名称',width:180,sortable:true,dataIndex:'name'},
				{header:'别名',width:100,sortable:true,dataIndex:'alias'},
				{header:'文件夹数',width:80,align:'center',sortable:true,dataIndex:'folders'},
				{header:'文件数',width:80,align:'center',sortable:true,dataIndex:'files'}
	          ],
	          stripeRows: true,
	          autoScroll:true,
			  border:false
	        });
	        this.resourcegrid.on('rowdblclick',function(o,r,e){
	        	var record = this.resource_d.getAt(r);
	        	if(record.data._is_leaf){
	        		this.selectResource();
	        	}else{
	        		if(record.ux_maximgb_treegrid_expanded){
	        			this.resource_d.collapseNode(record);
	        		}else{
	        			this.resource_d.expandNode(record);
	        		}
	        	}
	        },this); 
	        this.resource_win = new Ext.Window({id:'dlg-cms-resource-select',title:'资源选择器',layout:'fit',maximizable:true,modal:false,
				resizable:false,width:550,height:350,closeAction:'hide',plain:false,
				items:this.resourcegrid,
				buttons:[
					{text:'确定',handler:this.selectResource,scope:this},
					{text:'取消',handler:function(){this.resource_win.hide();},scope:this}
				]
			});
		}
		this.resource_win.show();
	},
	//选择资源
	selectResource : function(){
		var records = this.resourcegrid.getSelectionModel().getSelections();
		for(var i=0;i<records.length;i++){
			if (!this.D.getById(records[i].data.itemid) && records[i].data._parent!=null) {
				var node_record = this.resource_d.getById(records[i].data._parent);
				this.D.add(new Ext.data.Record({nid:records[i].data.itemid,name:records[i].data.name,tid:records[i].data.tid,alias:records[i].data.alias,_type:node_record.data.name,binding:0,'default':0},records[i].data.itemid));
				this.setResourceData(records[i].data.itemid, 'add');
			}
		}
		this.resourcegrid.getSelectionModel().clearSelections();
		this.resource_win.hide();
	},
	setResourceData:function(id, addOrDel){
        var len = this.resourceData[addOrDel].length;
        var flag = true;
        if (len > 0) {
            for (var k = 0; k < len; k++) {
                if (this.resourceData[addOrDel][k] == id) {
                    flag = false;
                    break;
                }
            }
        }
        if (flag) {
			var delOrAdd = addOrDel == 'add' ? 'delete' : 'add';
			var len = this.resourceData[delOrAdd].length;
	        if (len > 0) {
				var index = 0;
	            for (var k = 0; k < len; k++) {
	                if (this.resourceData[delOrAdd][k] == id) {
	                    flag = false;
						this.resourceData[delOrAdd].splice(index, 1);
	                    break;
	                }
					index++;
	            }
	        }
			if(flag){
				this.resourceData[addOrDel].push(id);	
			}
        }
	},
	//设置为默认
	setting : function(item){
		var records = this.grid.getSelectionModel().getSelections();
		if(records.length > 0){ 
			var count = this.D.getCount();
			for(var i=0;i<count;i++){
				var r = this.D.getAt(i);
				if(r.get('_type') == records[0].data._type){
					r.set(item.mode[0],0);
				}
			}
			records[0].set(item.mode[0],item.mode[1]);
			this.setToolbar(records[0].data.binding,records[0].data['default']);
		}else{
			alert('请选择要设置的资源');
		}
	},
	setToolbar : function(binding,defaultvalue,extchannel){
		this.grid.getTopToolbar().items.items[2].setText(binding==1 ? '取消绑定': '强制绑定');
    	this.grid.getTopToolbar().items.items[2].mode[1] = binding==1 ? 0 : 1;
		this.grid.getTopToolbar().items.items[3].setText(defaultvalue==1 ? '取消默认' : '设为默认');
		this.grid.getTopToolbar().items.items[3].mode[1] = defaultvalue==1 ? 0 : 1;
		if(extchannel){
			this.grid.getTopToolbar().items.items[6].show();
		}else{
			this.grid.getTopToolbar().items.items[6].hide();
		}
	},
	//移除资源
	removeResource : function(){
		var records = this.grid.getSelectionModel().getSelections();
		var length = records.length;
		for(var i=0;i<length;i++){
			this.setResourceData(records[i].data.nid, 'delete');
			this.D.remove(records[i]);
		}
	},
	//提交数据
	submit : function(){
		if(this.checkResource()){
			this.commit();
		}
		this.win.hide();
	},
	getData:function(){
		var data = [];
		for(var i=0;i<this.D.getCount();i++){
			data.push(this.D.data.items[i].data);
		}
		data = {'add':this.resourceData['add'].join(','), 'delete':this.resourceData['delete'].join(','),'data':data};
		return Ext.util.JSON.encode(data);
	},
	checkResource:function(){
		return this.resourceData['add'].length > 0 || this.resourceData['delete'].length > 0 || this.D.getModifiedRecords().length > 0 || this.extchannel != this.modify; 
	},
	commit:function(){
		Ext.Ajax.request({
			url: this.baseAction + '&method=commit',method:'post',params:{itemid:this.itemid,type:this.type,data:this.getData(),extchannel:this.extchannel},
			success:function(r,o){
				r=jsonReturn(r);
				if(r.success){
					this.reload = false;
				}
			},
			scope:this
		});
		this.D.commitChanges();
	},
	//取消
	cancel : function(){
		if(this.checkResource()){
			if(!confirm("项目绑定资源已经变更，您确定不保存栏目数据吗？")){
				return;
			}
			this.resourceData = {'add':[],'delete':[]};
			this.reload = true;
		}
		this.win.hide();
	},
	renderDefault:function(v){return v==1 ? '<span style="color:green;">默认</span>' : '';},
	renderBinding : function(v){return v==1 ? '<span style="color:green;">是</span>' : '';}
};