EXCMS.Resource.ImageSelector={
	baseAction:'index.php?M=Resource&A=Index',
	uploadAction:'index.php?M=Resource&A=ResoureFileAction',
	resourceType : 'image',
	images : 0,
	maxImages : 20,
	urlImages : new Array,
	uploadImages : new Array,
	//file_size_limit : 1024 * 4,
	single : true,
	selected : null,
	postfixArray : {thumb:'t', smallslide:'ss', largeslide:'ls', medium:'m', large:'l', original:'o'},
	imgNameInput : 0,
	tid:1,
    // load
    load:function(item){
		this.callback = item.callback;
		this.action = item.action || false;
		this.single = item.single || false;
		this.postfix = item.postfix || '';
		this.channelid = item.channelid || 0;
		this.nid = item.nid || 0;				//节点ID
		this.nodename = item.nodename || '';	//节点名称
		this.filetype = item.filetype || '';
		this.filesize = item.filesize || 0;
		this.fid = item.fid || 0;	//上传目录
		this.config = item.config || null;
		this.assocw = item.assocw || 0;  
		this.activeTab = {local:item.local, url:item.url};
		this.store = item.store || null;
		if(this.action != 'upload'){ // 从资源点上传
			this.resource_config = _EXCMS_content_config.resourceconfig;
			var channelselect = this.resource_config.defaultresource && this.resource_config.defaultresource[this.tid] && this.resource_config.defaultresource[this.tid].channelselect;
			if((this.resource_config.assocwchannel=='1' || channelselect) && !this.channelid){
				alert("资源选择需要先选定栏目");
				return ;
			}
			if(this.resource_config.defaultresource && this.resource_config.defaultresource[this.tid]){
				if(this.filetype==''){
					this.filetype = this.resource_config.defaultresource[this.tid].config.filetype;
				}
				if(parseInt(this.filesize) < 1){
					this.filesize = this.resource_config.defaultresource[this.tid].config.size;
				}
				if(!this.nid){
					this.nid = this.resource_config.defaultresource[this.tid].nid;
				}
				if(this.nodename==''){
					this.nodename = this.resource_config.defaultresource[this.tid].name;
				}
				if(!this.config){
					this.config = this.resource_config.defaultresource[this.tid].config.image;
				}
			}
		}
		this.filesize = parseInt(this.filesize) || 1024 * 4;	//上传文件大小
		this.filetype = this.filetype || new Array('jpg','jpeg','png','gif');
		if(!this.win) this.render();
		this.win.show();
		this.win.center();
		this.setResourceNode();
    },
    //设置文件类型
    setFileType : function(filetype){
    	if(filetype && typeof filetype == 'string'){		//上传文件类型
			filetype = filetype.split(',');
		}else if(typeof filetype == 'array'){
			
		}else{
			filetype = new Array('jpg','jpeg','png','gif');
		}
		var _types = [];
		for(var i=0,len=filetype.length;i<len;i++){
			filetype[i] = filetype[i].trim().toLowerCase();
			if(filetype[i]) _types.push('*.'+filetype[i]);
		}
		if(_types.length){
			filetype = _types.join(';');
		}else{
			filetype = '*.*';
		}
		if(this.swfupload){
			this.swfupload.setFileTypes(filetype,'All Files ('+filetype+')');
		}
    },
    //设置文件大小
    setFileSize : function(){
    	if(this.swfupload){
			this.swfupload.setFileSizeLimit(this.filesize);
		}
    },
	//render image selector
	render:function(){
		this.win =  new Ext.Window({title:'图片资源',maximizable:true,minimizable:false,modal:true,
			resizable:true,width:658,height:413,minWidth:656,minHeight:413,bodyStyle:'background:#FFFFFF',
			closeAction:'hide',plain:false,labelWidth:35,autoScroll:true,html:'',
			buttons:[{text:'确定',handler:this.ok,scope:this},{text:'取消',handler:function(){this.win.hide()},scope:this}],
			'listeners' : {'show':{fn:this.onshow,scope:this}}
		});
		this.win.on('render',function(c){
			var tthis = this;
			setCls(c.body.dom, 'ex-img-selector');
			this.tab = this.createElement({tag:'ul', cls:'ex-img-selector-tab', parent:c.body.dom});
			this.tab.li = [];
			this.tab.li[0] = this.createElement({tag:'li', cls:'active', html:'我的电脑', parent:this.tab});
			this.tab.li[0].index = 0;
			this.tab.li[1] = this.createElement({tag:'li', html:'网上图片', parent:this.tab});
			this.tab.li[1].index = 1;
			this.tab.li[2] = this.createElement({tag:'li', cls:'uploadsetting', html:'图片上传设置', parent:this.tab});
			this.tab.li[2].index = 2;
			this.tab.active = function(idx){
				this.li[0].className = idx == 0 ? 'active' : '';
				this.li[1].className = idx == 1 ? 'active' : '';
				this.li[2].className = idx == 2 ? 'uploadsetting active' : 'uploadsetting';
				this.div[0].style.display = idx == 0 ? 'block' : 'none';
				this.div[1].style.display = idx == 1 ? 'block' : 'none';
				this.div[2].style.display = idx == 2 ? 'block' : 'none';
				tthis.listCt.parentNode.style.display = idx != 2 ? 'block' : 'none';
			}
			this.tab.li[0].onclick = this.tab.li[1].onclick = function(){this.parentNode.active(this.index)}
			this.tab.li[2].onclick = function(){
				this.parentNode.active(this.index);
				if(!tthis.resourceNode) tthis.renderResourceCombo();
			}
			this.form = this.createElement({tag:'form', parent:c.body.dom});
			this.tab.div = [];
			this.tab.div[0] = this.createElement({tag:'div', cls:'ct', parent:this.form});
			this.createElement({tag:'p', cls:'t', html:'<span style="float:right"><input type="checkbox" id="image-user-oname" style="margin-right:2px;vertical-align:top" onclick="EXCMS.Resource.ImageSelector.setImageName(this)"><label for="image-user-oname" style="color:#03c;line-height:normal">使用原始文件名</label></span>提示：图片文件大小不能超过4M，支持jpg、jpeg、gif、png；', parent:this.tab.div[0]});
			this.uploadCt = this.createElement({tag:'div', cls:'uploadct', parent:this.tab.div[0]});
			p = this.createElement({tag:'p', cls:'swfuploact t', parent:this.tab.div[0]});
			this.createElement({tag:'span', id:'image-selector-swfupload-btn', parent:p});
			this.uploadAddButton = this.createElement({tag:'span', cls:'button', html:'添加...', style:'display:none;', parent:p});
			var upbutton = this.createElement({tag:'span', cls:'button', html:'上传', parent:p});
			this.uploadTipEl = this.createElement({tag:'label', parent:p});
			this.uploadTipEl.show = show;
			this.uploadTipEl.hide = hide;
			this.uploadTipEl.setHtml = function(s){this.innerHTML=s}
			
			this.tab.div[1] = this.createElement({tag:'div', cls:'ct', style:'display:none', parent:this.form});
			this.createElement({tag:'p', cls:'t', parent:this.tab.div[1], html:'请填写您要插入的网上图片的URL'});
			var p = this.createElement({tag:'p', cls:'clearfix', parent:this.tab.div[1]});
			this.createElement({tag:'label', html:'图片：', input:'ex-img-url', parent:p});
			var url = this.createElement({tag:'input', id:'ex-img-url', type:'text', cls:'txt urltxt', name:'url', value:'http://', parent:p});
			p = this.createElement({tag:'p', cls:'clearfix', parent:this.tab.div[1]});
			this.createElement({tag:'label', html:'描述：', input:'ex-img-url-desc', parent:p});
			var urldesc = this.createElement({tag:'textarea', name:'urldesc', id:'ex-img-url-desc', parent:p});
			p = this.createElement({tag:'p', cls:'t clearfix b', parent:this.tab.div[1]});
			var urlbutton = this.createElement({tag:'span', cls:'button', html:'添加', parent:p});
			var urlsave = this.saveinput = this.createElement({tag:'input', id:'ex-img-url-save', type:'checkbox', name:'save', parent:p});
			this.createElement({tag:'label', html:'将图片保存到资源库中', input:'ex-img-url-save', style:'padding-left:4px;line-height:normal', parent:p});	
			
			p = this.createElement({tag:'div', cls:'ex-img-selector-body', parent:c.body.dom});
			this.createElement({tag:'p', cls:'t', html:'可插入的图片(双击预览图片)', parent:p});
			this.listCt = this.createElement({tag:'ul', cls:'clearfix', parent:p});
			this.addImageCt(20);
			this.tab.div[2] = this.createElement({tag:'div', html:'',parent:this.form});
			
			upbutton.onmouseover = urlbutton.onmouseover = function(){setCls(this,'over')}
			upbutton.onmouseout = urlbutton.onmouseout = function(){setCls(this,'over',1);setCls(this,'click',1)}
			upbutton.onmouseup = urlbutton.onmouseup = function(){setCls(this,'click',1)}
			upbutton.onmousedown = urlbutton.onmousedown = function(){setCls(this,'click')}
			upbutton.onclick = function(){tthis.doUpload()}
			urlbutton.onclick = function(){tthis.addUrlImage()}
			this.upbutton = upbutton;
			url.onfocus = function(){if(this.value.trim()=='http://')this.value=''}
			url.blur = function(){if(this.value.trim()=='')this.value='http://'}
			this.form.url = url;
			this.form.urldesc = urldesc;
			this.form.urlsave = urlsave;
			this.initUploader();
		},this);
	},
	// on this win show
	onshow : function(){
		if(this.activeTab.url){
			this.tab.active(1);
		}else{
			this.tab.active(0);
		}
		this.unselectAll();
		this.form.reset();
		this.form.url.value = 'http://';
	},
	// initial swf upload
	initUploader:function(){
		var _this = this;
		this.swfupload = new SWFUpload({
			flash_url : EXCMS.Resource.Upload.flash_url,
			//flash9_url : EXCMS.Resource.Upload.flash9_url,
			upload_url: EXCMS.Resource.Upload.baseAction,
			use_query_string:false,
			post_params:{'session_id':EXCMS.config.session_id},
			file_post_name : 'EXCMSFILES',
			file_size_limit : 1024 * 4,
			file_types : '*.jpg;*.jpeg;*.png;*.gif',
			file_types_description : "All Files",
			file_upload_limit : 0,
			file_queue_limit : 0,
			swfupload_preload_handler : function(){_this.uploadTipEl.setHtml('<font color=red>正在加载 swfupload 上传组件，请稍候...</font>')},
			swfupload_loaded_handler : function(){
				_this.uploadAddButton.style.display = 'block';
				_this.uploadTipEl.setHtml('请点击“添加...”按钮选择要上传的图片，支持多选');
				_this.setFileType(_this.filetype);	//设置上传文件类型
				_this.setFileSize();	//设置上传文件大小
			},
			swfupload_load_failed_handler : function(m){alert('请升级浏览器Flash Player版本至9.0以上');},
			file_dialog_start_handler : function(){},
			file_queued_handler : function(f){_this.addUploadImage(f)},
			file_queue_error_handler : function(f,e,m){
				switch (e){
		            case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
		                if (m > 0) {
		                   errorMsg = "您只能上传" + message + "个文件!";
		                } else{
		                    errorMsg = "您不可继续上传文件!";
		                }
		                break;
		            case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
		                errorMsg = "您不可上传0字节的文件";
		                break;
		            case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
		                errorMsg = '上传的图片太大，请重新选择(不能超过'+formatSizes(_this.filesize*1024)+')';
		                break;
		            case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
		            case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
		            default:
		                errorMsg = m;
		                break;
		        }
		        alert(errorMsg);
			},
			file_dialog_complete_handler : function(ns,nq,t){},
			upload_start_handler : function(f){},
			upload_progress_handler : function(f,c,t){
				var p = ((c/t)*100).toFixed(2);
				var li = _this.uploadImages[f.id].li;
				li.p.innerHTML = li.percent.style.width = p + '%';
				if(p == 100) li.p.innerHTML = '处理中';
			},
			upload_error_handler : function(f,e,m){if(e!=-280)alert(m)},
			upload_success_handler : function(f,d,r){
				var v = Ext.decode(d);
				if(v.success == 1){
					v.fileid = f.id;
					_this.addImage(v);
					_this.swfupload.startUpload();
					if(_this.store) _this.store.load({params:{start:0,limit:_this.store.pagesize||25}})
				}else{
					if(v.success == 0){
						alert(v.message)
					}else if(v.message){
						alert(v.message)
					}else{
						alert('服务器异常，请重新上传');
					}
					var li = _this.uploadImages[f.id].li;
					li.delBtn.style.display = 'none';
					li.removeChild(li.upload);
					_this.images--;
					_this.swfupload.cancelUpload(f.id);
					delete(_this.uploadImages[f.id]);
				}
			},
			upload_complete_handler : function(f){},
			// Button Settings
			button_window_mode: SWFUpload.WINDOW_MODE.TRANSPARENT,
			button_placeholder_id : 'image-selector-swfupload-btn',
			button_width: 48,
			button_height: 23,
			custom_settings:{},
			debug: false
		});
	},
	// add a image contariner
	addImageCt : function(n){
		var tthis = this;
		for(var i=0;i<n;i++){
			var li = document.createElement('li');
			li.delBtn = document.createElement('a');
			li.delBtn.setAttribute('href', 'javascript:void(0)');
			li.delBtn.setAttribute('title', '删除');
			li.delBtn.onclick = function(){tthis.deleteImage(this)}
			li.appendChild(li.delBtn);
			li.div = document.createElement('div');
			li.div.className = 'ct'
			li.appendChild(li.div);
			li.ct = document.createElement('em');
			li.div.appendChild(li.ct);
			li.onmouseover = function(){if(this.haveImg)setCls(this,'over')}
			li.onmouseout = function(){if(this.haveImg)setCls(this,'over',1)}
			li.onclick = function(){if(!this.haveImg) return;this.selected?this.unselect():this.select()}
			li.ondblclick = function(){
				if(this.haveImg){
					var imageurl = li.isurl ? this.img.src : tthis.uploadImages[this.img.fileid].images.resource;
					EXCMS.Previewer.image(imageurl);
				}
			}
			li.select = function(){
				if(!this.haveImg || this.selected || (tthis.single && tthis.selected && tthis.selected == this)) return;
				if(tthis.single){
					if(tthis.selected) tthis.selected.unselect();
					tthis.selected = this;
				}
				if(!this.selected){
					this.selected = true;
					setCls(this, 'selected');
					this.setAttribute('title', '点击取消选择');
				}
			}
			li.unselect = function(){
				if(this.haveImg && this.selected){
					if(tthis.selected = this) tthis.selected = null;
					this.selected = false;
					setCls(this, 'selected', true);
					this.setAttribute('title', '点击选择');
				}
			}
			this.listCt.appendChild(li);
		}
		return li;
	},
	// unselect images
	unselectAll : function(){
		for(var i=0;i<this.images;i++) this.listCt.childNodes[i].unselect();
	},
	// add a local image
	addUploadImage : function(file){
		this.imgNameInput++;
		var div = this.createElement({tag:'div', cls:'aimg clearfix', parent:this.uploadCt});
		var p = this.createElement({tag:'div', cls:'clearfix', parent:div});
		if(this.userOriginalName){
			this.createElement({tag:'label', html:'名称：', input:'ex-img-name' + this.imgNameInput, parent:p});
			div.originalName = this.createElement({tag:'input', id:'ex-img-name' + this.imgNameInput, type:'text', cls:'txt nametxt', value:file.name, parent:p});
			var del = this.createElement({tag:'span', cls:'delimg', title:'删除', parent:p});
			del.style.marginTop = '7px';
			del.style.marginLeft = '-18px';
		}else{
			this.createElement({tag:'span', html:'图片：' + file.name, parent:p});
			var del = this.createElement({tag:'span', cls:'delimg', title:'删除', parent:p});
		}
		
		p = this.createElement({tag:'p', cls:'clearfix', parent:div});
		var id = 'ex-img-local-desc-' + file.id;
		this.createElement({tag:'label', html:'描述：', input:id, parent:p});
		div.description = this.createElement({tag:'textarea', id:id, parent:p});
		div.file = file;
		var tthis = this;
		del.onclick = function(){
			var p=this.parentNode.parentNode;
			tthis.swfupload.cancelUpload(p.file.id);
			p.parentNode.removeChild(p);
		}
		return div;
	},
	// do upload local image
	doUpload : function(){
		var images = this.uploadCt.childNodes;
		if(!images.length){alert('请先添加要上传的图片文件');return}
		var config = this.thumbItems && this.thumbItems.items ? Ext.encode(this.thumbItems.items) : '';
		var i = 0;
		while(images.length){
			var file = images[0].file;
			file.description = images[0].description.value.trim();
			this.swfupload.addFileParam(file.id, 'channelid', this.channelid);
			this.swfupload.addFileParam(file.id, 'nid', this.nid);
			this.swfupload.addFileParam(file.id, 'tid', this.tid);
			this.swfupload.addFileParam(file.id, 'fid', this.fid);
			this.swfupload.addFileParam(file.id, 'filetype', this.filetype);
			this.swfupload.addFileParam(file.id, 'filesize', this.filesize);
			if(images[0].originalName){
				file.originalName = images[0].originalName.value.trim();
				this.swfupload.addFileParam(file.id, 'originalname', file.originalName);
			}
			this.swfupload.addFileParam(file.id, 'description', file.description);
			this.swfupload.addFileParam(file.id, 'config', config);
			if(i === 0) this.swfupload.startUpload(file.id);
			var li = this.images == this.listCt.childNodes.length ? this.addImageCt(1) : this.listCt.childNodes[this.images];
			file.li = li;
			this.uploadImages[file.id] = file;
			li.delBtn.style.display = 'block';
			li.upload = document.createElement('div');
			li.upload.className = 'ex-img-selector-upload';
			li.upload.setAttribute('title', file.name + '('+ SWFUpload.speed.formatBytes(file.size) +  (i === 0 ? ', 正在上传)' : ', 等待上传)'));
			li.p = document.createElement('p');
			li.p.innerHTML = i === 0 ? '0%' : '等待';
			li.upload.appendChild(li.p);
			var div = document.createElement('div');
			li.percent = document.createElement('span');
			div.appendChild(li.percent);
			li.upload.appendChild(div);
			li.appendChild(li.upload);
			this.uploadCt.removeChild(images[0]);
			this.images++;
			i++;
		}
	},
	// add a url image
	addUrlImage : function(o){
		var url = this.form.url.value.trim();
		var isUrl = isImgUrl(url)
		if(isUrl > 0){
			if(isUrl == 1 && !confirm("图片URL: " + url + "\n可能不是正确的图片URL，确定添加此图片URL吗？")) return;
			this.form.url.value = 'http://';
			if(this.urlImages.length && this.urlImages.indexOf(url) >= 0){
				alert('网址图片已经添加');
				return ;
			}
			if(!this.validateFileType(url,this.filetype)){
				return ;
			}
			if(this.form.urlsave.checked){
				this.uploadUrlFile(url, this.form.urldesc.value.trim());
			}else{
				this.addImage(url, this.form.urldesc.value.trim());
			}
			this.form.urldesc.value = '';
		}else{
			alert("错误的URL: \n" + url);
		}
	},
	validateFileType : function(fileURL,right_type){
		if(typeof right_type == 'undefined') return true;
		var filetype = (typeof right_type == 'string') ? right_type.split(',') : right_type;
		var filename = fileURL.toLowerCase().trim();
		var ext = filename.substr(filename.lastIndexOf('.') + 1);
		if(filetype.indexOf(ext) < 0){
			alert("文件类型错误！\n当前支持的文件类型："+filetype.join(','));
			return false;
		}
		 return true;
	},
	// upload url files
	uploadUrlFile:function(url, description){
		var li = this.images == this.listCt.childNodes.length ? this.addImageCt(1) : this.listCt.childNodes[this.images];
		li.delBtn.style.display = 'block';
		li.upload = document.createElement('div');
		li.upload.className = 'ex-img-selector-upload';
		li.upload.setAttribute('title', '图片保存中');
		li.p = document.createElement('p');
		li.p.innerHTML = '保存中';
		li.upload.appendChild(li.p);
		var div = document.createElement('div');
		li.percent = document.createElement('span');
		div.appendChild(li.percent);
		li.upload.appendChild(div);
		li.appendChild(li.upload);
		this.images++;
		var config = this.thumbItems && this.thumbItems.items ? Ext.encode(this.thumbItems.items) : null;
		var tthis = this;
        Ext.Ajax.request({
            url:EXCMS.Resource.Upload.baseAction, method:'POST', scope:this, params:{action:'urlimage',fid:this.fid, nid:this.nid, channelid:this.channelid, config:config,filetype:this.filetype,filesize:this.filesize, description: description, file:url},
            failure:function(){alert('图片保存失败');},
            success:function(r,o){
                r=jsonReturn(r);
				if(r.success){
					r.fileid = 'url_' + this.images;
					r.li = li;
					r.description = description;
					tthis.uploadImages[r.fileid] = r;
					tthis.addImage(r);
					return ;
				}else if(r.message){
					alert(r.message);
				}else{
					alert('服务器异常，请重新上传');
				}
				li.delBtn.style.display = 'none';
				li.removeChild(li.upload);
				tthis.images--;
            }
        });
	},
	// add image into image list
	addImage : function(data, description){
		var li = typeof data == 'string' ? this.listCt.childNodes[this.images] : this.uploadImages[data.fileid].li;
		li.img = document.createElement('img');
		li.img.onload = function(){resizeImage(this,48,48);this.style.marginLeft='0px';}
		li.img.onerror = function(){this.parentNode.innerHTML='图片错误'}
		li.haveImg = true;
		li.ct.appendChild(li.img);
		li.setAttribute('title', '选择');
		if(typeof data == 'string'){
			this.images++;
			li.img.src = data;
			li.img.description = description ? description : '';
			li.isurl = true;
			li.delBtn.style.display = 'block';
			this.urlImages.push(data);
		}else{
			li.img.src = data.resource.src;
			li.img.fileid = data.fileid;
			li.img.description = description ? description : '';
			this.uploadImages[data.fileid].uploaded = true;
			this.uploadImages[data.fileid].images = data.resource;
			this.uploadImages[data.fileid].images.description = this.uploadImages[data.fileid].description;
			li.removeChild(li.upload);
		}
	},
	// delte image
	deleteImage : function(o){
		this.images--;
		var li = o.parentNode;
		if(li.isurl){
			this.urlImages.splice(this.urlImages.indexOf(li.img.src), 1);
		}else{
			this.swfupload.cancelUpload(li.fileid);
			delete(this.uploadImages[li.fileid]);
		}
		this.listCt.removeChild(li);
		this.addImageCt(1);
	},
	// on ok button click event
	ok : function(){
		if(this.action == 'upload'){
			this.win.hide();
		}else{
			var data = new Array;
			for(var i=0;i<this.images;i++){
				var li = this.listCt.childNodes[i];
				if (li.selected) {
					data.push(li.isurl ? {src:li.img.src, description:li.img.description} : this.uploadImages[li.img.fileid].images);
					if(!li.isurl && this.postfix){
						data[data.length-1].src = this.getPostfixSrc(data[data.length-1].src,data[data.length-1].thumb,this.postfix);
						if(data[data.length-1].resource){
							if(this.postfix && this.postfixArray[this.postfix]) this.postfix = this.postfixArray[this.postfix];
							if(this.postfix == 't' || this.postfix == 'thumb' ) this.postfix = '';
							if(this.postfix && data[data.length-1].thumb.indexOf(this.postfix)== -1)	this.postfix = '';
							data[data.length-1].resource = 'resource:' + data[data.length-1]['rid'] + ':' + this.postfix + ':' + data[data.length-1]['nid'] + ':' + data[data.length-1]['src'];
						}
					}
				}
			}
			if(data.length){
				if(this.single) data = data[0];
				if(this.callback && typeof this.callback == 'function') this.callback(data);
				this.win.hide();
			}else{
				alert('请先选择图片');
			}
		}
	},
	createElement : function(c){
		var el = document.createElement(c.tag);
		if(c.id) el.setAttribute('id', c.id);
		if(c.name) el.name = c.name;
		if(c.type) el.type = c.type;
		if(c.title) el.title = c.title;
		if(c.input) el.setAttribute('for', c.input);
		if(c.value) el.value = c.value;
		if(c.readonly) el.readOnly = true;
		if(c.cls) el.className = c.cls;
		if(c.html) el.innerHTML = c.html;
		if(c.parent) c.parent.appendChild(el);
		if(c.style) el.setAttribute('style', c.style);
		return el;
	},
	// render 
	renderResourceCombo : function(){	
		var el = this.createElement({tag:'div', cls:'combo-ct', parent:this.tab.div[2]});
		this.createElement({tag:'label', input:'ex-image-upload-resource-node', html:'将图片上传到：',parent:el});
		el = this.createElement({tag:'div', cls:'combo',parent:el});
		
		this.resourceNode = new Ext.form.ComboBox({renderTo:el,id:'ex-image-upload-resource-node',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode:'local',width:407,triggerAction:'all',tpl:'<tpl for="."><div style="height:160px"><div id="ex-img-resource-combox"></div></div></tpl>',selectedClass:'',onSelect:Ext.emptyFn,emptyText:'请选择资源点'});
		this.resourceNode.tree = new Ext.tree.TreePanel({useArrows:true,border:false,cls:'channel-tree browse-tree',bodyStyle:'padding:1px;',rootVisible:false,autoScroll:true,root:new Ext.tree.AsyncTreeNode({id:'01',text:'图片类型资源点',leaf:0,cls:'resouce-tree-type resouce-tree-image',expanded:true,dir:'0'})});
		
		this.resourceNode.tree.on('beforeclick',function(n){if(n.id == '01') return false},this);
		this.resourceNode.tree.on('click',function(n){
			if(n.attributes.istype == 1) return ;
			this.nid = n.id;
			if(n.attributes.config){
				n.thumbConfig = n.attributes.config;
				n.thumbConfig = n.thumbConfig.image && n.thumbConfig.image != {} ? n.thumbConfig.image : null;
			}else{
				n.thumbConfig = null;
			}
			this.imageSetting('render', n.thumbConfig);
			this.resourceNode.setValue(n.text);
			this.resourceNode.collapse();
		},this);
		this.resourceNode.on('expand',function(c){if(!c.tree.rendered)c.tree.render('ex-img-resource-combox');},this);
		this.resourceNode.tree.on('contextmenu',function(n,e){},this);
		this.resourceNode.on('collapse',function(c){if(this.localrefresh) {this.localrefresh = false;c.expand();}},this)
		this.resourceNode.on('focus',function(){this.loadTree();},this);
		this.resourceNode.trigger.on('click',function(){this.loadTree();},this);


		this.createElement({tag:'p', cls:'t', html:'不选择资源点，图片将上传至默认的资源点',style:'padding-left:88px', parent:this.tab.div[2]});
		el = this.createElement({tag:'div', cls:'combo-ct', parent:this.tab.div[2]});
		this.createElement({tag:'label', html:'图片缩放设置：', parent:el});
		var imgsetingbutton = this.createElement({tag:'span', cls:'button', html:'添加', parent:el});
		imgsetingbutton.onmouseover = function(){setCls(this,'over')}
		imgsetingbutton.onmouseout = function(){setCls(this,'over',1);setCls(this,'click',1)}
		imgsetingbutton.onmouseup = function(){setCls(this,'click',1)}
		imgsetingbutton.onmousedown = function(){setCls(this,'click')}
		this.thumbItems = this.createElement({tag:'div', cls:'combo-ct st-thumb-items', parent:this.tab.div[2]});
		var tthis = this;
		imgsetingbutton.onclick = function(){tthis.imageSetting()}
		this.setResourceNode();
	},
	// load resouce type tree data
	loadTree : function(){
		if(this.treechannel == this.channelid) return ;
		Ext.Ajax.request({
			url:this.uploadAction+'&method=loadResourceConfig',method:'POST',scope:this,params:{channelid:this.channelid,tid:this.tid,assocw:this.assocw},
			failure:function(){},
			success:function(r,o){
				r = Ext.decode(r.responseText);
				if(r.success){
					if(r.nodes){
						this.treechannel = this.channelid;
						this.treeData = r.nodes;
						this.renderTreeNode();
					}
				}
			}
		});
	},
	renderTreeNode : function(){
		if(!this.treeData) return ;
		if(this.resourceNode.tree.getRootNode().hasChildNodes()){
			 this.resourceNode.tree.getRootNode().eachChild(function(node){node.remove();});
		}
		tree = this.resourceNode.tree;
		if(!tree.rendered) return ;
		for(var i = 0, dlen = this.treeData.length; i < dlen; i++){
			this.treeData[i].expanded = true;
			var node = tree.root.appendChild(new Ext.tree.TreeNode(this.treeData[i]));
			if(node.attributes.children.length > 0){
				var cs = node.attributes.children;
				node.beginUpdate();
				for(var k = 0, len = cs.length; k < len; k++) node.appendChild(new Ext.tree.TreeNode(cs[k]));
				node.endUpdate();
			}
		}
	},
	setResourceDefault : function(){
		
	},
	// set resource node
	setResourceNode : function(){
		if(!this.resourceNode) return ;
		if(this.action=='upload'){
			this.resourceNode.setValue(this.nodename);
			//this.resourceNode.setDisabled(true);
			this.imageSetting('render', this.config);
		}else{
			this.resourceNode.setValue('');
			//this.resourceNode.setDisabled(false);
			this.thumbItems.innerHTML = '';
		}
	},
	// image setting config
	imageSetting : function(action, config){
		this.isRenderThumbConfig = true;
		if(action && !config){
			this.thumbItems.innerHTML = '';
			return;
		}
		EXCMS.util.QuickCreate({model:'Resource.image', action:action, thumbItems:this.thumbItems, config:config});
	},
	// 设置栏目
	selectChannelCallback : function(data){
		this.channelid = data.channelid;
	},
	// format image
	getPostfixSrc : function(src,thumb,postfix){
		if(this.postfixArray[postfix]) postfix = this.postfixArray[postfix];
		if(thumb.indexOf(postfix)== -1)	postfix = 't';
		if(postfix == 't') return src;
		var idx = src.lastIndexOf('.');
		return src.substr(0, idx) + '_' + postfix + src.substr(idx);
	},
	// set image name
	setImageName : function(e){
		this.userOriginalName = e.checked;
	}
};

function isImgUrl(s){
	var pic = new RegExp("((?:http|https)://(&(?=amp;)|[A-Za-z0-9\./=\?%_~@#:;\+\-])+(gif|jpg|jpeg|png)+)", "ig");
	var url = new RegExp("((?:http|https)://(&(?=amp;)|[A-Za-z0-9\./=\?%_~@&#:;\+\-])+)","ig");
	if(pic.test(s.trim())){return 2}else if(url.test(s.trim())){return 1}else{return 0}
}