EXCMS.System.Admin = {
	baseAction : 'index.php?M=System&A=Admin',
	acl_loaded:[],
	init:function(){
		Ext.QuickTips.init();
		this.currentNodeId = "0";
		this.view();
		for(var i=0;i<this.G.topToolbar.items.items.length;i++){
			if(this.G.topToolbar.items.items[i].acl&&!excmsacl[this.G.topToolbar.items.items[i].acl]){
				this.G.topToolbar.items.items[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
		for(var i=0;i<this.tree.topToolbar.items.items.length;i++){
			if(this.tree.topToolbar.items.items[i].acl&&!excmsacl[this.tree.topToolbar.items.items[i].acl]){
				this.tree.topToolbar.items.items[i].hide();
			}
		}
		for(var i=0;i<this.tree.contextmenu.items.items.length;i++){
			if(this.tree.contextmenu.items.items[i].acl&&!excmsacl[this.tree.contextmenu.items.items[i].acl]){
				this.tree.contextmenu.items.items[i].hide();
			}
		}
	},
	view:function(){
		this.D = new Ext.data.Store({
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
			reader:new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'adminid',
				fields:[{name:'adminid',type:'int'},{name:'groupid',type:'int'},'adminname','fullname','lastlogindate','lastloginip',{name:'status',type:'int'},'description']
            }),
			remoteSort:true
		});
		
		this.soField = new Ext.form.TwinTriggerField({emptyText:'管理员名,全名(模糊查询)',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		
		this.G = new Ext.grid.GridPanel({enableTabScroll:true,title:'管理员列表',
			enableColumnMove:true,animCollapse:false,autoExpandColumn:6,minColumnWidth:8,loadMask:true,
            store:this.D,columns:[
                new Ext.grid.RowNumberer(),
				{header:"管理员名",width:100,sortable:true,dataIndex:'adminname'},
				{header:"姓名",width:120,sortable:true,dataIndex:'fullname'},
				{header:"上次登录时间",width:150,sortable:true,dataIndex:'lastlogindate'},
				{header:"上次登录IP",width:150,sortable:true,dataIndex:'lastloginip'},
				{header:"状态",width:48,sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
				{header:"描述",width:200,sortable:true,dataIndex:'description'}
            ],
			tbar:new Ext.Toolbar({items:[
                {text:'新管理员',iconCls:'btnico btn_add',handler:this.edit,scope:this,mode:0,acl:'add'},
				{text:'编辑',iconCls:'btnico btn_edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
				{text:'删除',iconCls:'btnico btn_del',handler:this.adminDel,scope:this,acl:'delete'},'-',
				{text:'启用',handler:this.setStatus,scope:this,mode:1,acl:'status'},
				{text:'设置密码',handler:this.setPassword,scope:this,acl:'resetpwd'},
				//{text:'权限',handler:this.UserACL,scope:this},
				'-',
				{text:'显示全部',handler:function(){this.D.baseParams={key:"",pid:0},this.D.reload()},scope:this},
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this}
				,'->','搜索 ',this.soField
            ]}),bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
        this.tree = new Ext.tree.TreePanel({
			region:'west',title:'管理员组',collapsible:false,split:true,width:200,minSize:35,autoScroll:true,collapseMode:'mini',collapsible:true,
			rootVisible:false,lines:false,cls:'channel-tree group-tree',bodyStyle:'padding:6px',
			border:false,style:'border-right:1px solid #99BBE8;',
			loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=groupTree'}),
			root:new Ext.tree.AsyncTreeNode({id:'0',expanded:true}),
			tbar:[
				{text:'新建',handler:this.groupEdit,scope:this,mode:0,acl:'addgroup'},
				{text:'编辑',handler:this.groupEdit,scope:this,mode:1,acl:'editgroup'},
				{text:'删除',handler:this.groupdel,scope:this,acl:'deletegroup'},
				{text:'组权限',handler:this.groupACL,scope:this,acl:'groupacl'}
		]});
		this.tree.contextmenu = new Ext.menu.Menu({items:[
			{text:'新建',handler:this.groupEdit,scope:this,mode:0,acl:'addgroup'},
			{text:'编辑',handler:this.groupEdit,scope:this,mode:1,acl:'editgroup'},
			{text:'删除',handler:this.groupdel,scope:this,acl:'deletegroup'},'-',
			{text:'组权限',handler:this.groupACL,scope:this,acl:'groupacl'}
		]});
        this.tree.on('click',function(n,e){
        	this.D.baseParams = {pid:n.id,key:''};
        	this.currentNodeId=n.id;
        	this.currentNode=n;
			this.soField.reset();
        	this.D.reload();
        },this);       
        this.tree.on('contextmenu',function(n,e){
            n.select();
            this.tree.contextmenu.showAt(e.getXY());
            if (this.currentNodeId == n.id) return;
            this.currentNodeId = n.id;
            this.currentNode = n;
            this.D.baseParams.pid = this.currentNodeId;
            this.D.reload();
        },this);
		
        this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,{xtype:'tabpanel',region:'center',border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:this.G}]});
        this.D.load({params:{start:0,limit:25}});
		
		this.gridMenu = new Ext.menu.Menu({items:[
        	{text:'新建',icon:ico,iconCls:'ico add',handler:this.edit,scope:this,mode:0,acl:'add'},
			{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
			{text:'删除',icon:ico,iconCls:'ico del',handler:this.adminDel,scope:this,acl:'delete'},'-',
			{text:'启用',handler:this.setStatus,scope:this,mode:1,acl:'status'},
			{text:'设置密码',handler:this.setPassword,scope:this,acl:'resetpwd'},
			//{text:'权限',handler:this.UserACL,scope:this},
			'-',
			{text:'管理员内容统计',handler:this.adminContentStat,scope:this},
			{text:'管理员发布的内容',handler:this.adminContent,scope:this}
        ]});
		
	    this.G.on('rowdblclick',function(g,r,e){if(excmsacl&&excmsacl.edit==0)return;this.record=this.D.getAt(r);this.edit({mode:1})},this);
		this.G.on('rowclick',function(g,r,e){this.record=this.D.getAt(r);this.refrashMenu()},this);
        this.G.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!= -1?stm.selectRow(r,true):stm.selectRow(r);
			this.refrashMenu();
			this.gridMenu.showAt(e.getXY())
		},this);
		
		this.G.getEl().dom.oncontextmenu = function(){return false;}
        this.G.getEl().dom.onselectstart=function(){return false}
		this.tree.getEl().dom.oncontextmenu = function(){return false;}
        this.tree.getEl().dom.onselectstart=function(){return false}
	},
	refrashMenu:function(){
		this.G.topToolbar.items.items[4].setText(this.record.get('status')=='0'?'启用':'禁用');
		this.G.topToolbar.items.items[4].mode = this.record.get('status')=='0'?1:0;
		this.gridMenu.items.items[4].setText(this.record.get('status')=='0'?'启用':'禁用');
		this.gridMenu.items.items[4].mode = this.record.get('status')=='0'?1:0;
	},
	soOnTrigger1Click:function(){this.soField.reset();this.D.baseParams={key:'',pid:0};this.D.reload()},
	soOnTrigger2Click:function(){var key = this.soField.getValue('').trim();if(key!=''){this.D.baseParams={key:key,pid:0};this.D.reload()}},
	groupEdit:function(item){
		var mode = item && item.mode ? 1 :0 ;
		var title = mode ? '编辑组' :'新建组';
	    if(!this.groupEditor){
			var thumbTemplate = new Ext.XTemplate(
				'<tpl for=".">',
				'<div class="ag-wrap" id="{name}" title="{description}">',
				'<span class="node-indent"></span>',
				'<img src="Framework/resources/images/default/s.gif" class="node-icon" unselectable="on">',
				'<a hidefocus="on" class="node-anchor" href="javascript:;" tabindex="1"><span unselectable="on">{name}</span></a>',
				'</div>',
				'</tpl>', '<div class="x-clear"></div>'
			);
			this.store = new Ext.data.JsonStore( {fields : [ 'id', 'name'],
				listeners : {'load' : {fn : function() {this.view.select(0)},scope : this,single : true}}
			});
			this.dataview = new Ext.DataView({cls : 'ag-member',tpl : thumbTemplate,overClass : 'x-view-over',itemSelector : 'div.ag-wrap',
					store : this.store,autoScroll : true,multiSelect : true,
					plugins :new Ext.DataView.DragSelector(),
					listeners : {
						'contextmenu' : {fn : function(o, i, n, e) {if (!o.isSelected(i))o.select(i);this.dataview.selectedIndex = i;},scope : this},
						'beforeselect' : {fn : function(v) {return v.store.getRange().length > 0},scope : this}
					}
				});
			this.viewPanel = new Ext.Panel({border : false,layout:'card',autoScroll : true,width:314, height:130,activeItem:0,style:'border:1px solid #B5B8C8;',items:this.dataview});
            this.groupEditorForm = new Ext.form.FormPanel({bodyStyle:'padding:10px;',border:false, defaults:{xtype:'textfield',anchor:'-5'}, labelWidth:40,items:[
				{fieldLabel:'组名',name:'name',allowBlank:false,blankText:'管理员组名称不能为空'},
				{fieldLabel:'描述',name:'description',xtype:'textarea',height:40},
				{xtype:'panel',layout:'column',border:false,items:[
					{text :'成员：',xtype:'label',width:45},
					{xtype:'panel',border:false,buttonAlign:'left',buttons :[{text:'添加',handler:this.addMember,scope:this},{text:'删除',handler:this.delMember,scope:this}],items:this.viewPanel}
				]},
				{fieldLabel:'序号',xtype:'numberfield',name:'sort',value:50,anchor:'40%'},
				{xtype:'hidden',name:'groupid'}]
			});
            this.groupEditor = new Ext.Window({id:'dlg-system-group-editor',title:title,layout:'fit',minimizable:true,modal:false,resizable:false,
				width:400,height:350,closeAction:'hide',plain:true,items:this.groupEditorForm,
				buttons:[{text:'确定',handler:this.groupSave,scope:this,mode:0},{text:'取消',handler:function(){this.groupEditor.hide();},scope:this}]
            });
            
            this.groupEditorForm.form.on('actioncomplete',function(form,action){
				if(action.result.success){
					alert(action.result.message);
					this.tree.getLoader().load(this.tree.root);this.tree.root.expand();
                	this.groupEditor.hide();
                }
            },this);
	    }
        this.groupEditor.show(this);
        
        if(mode){
        	var node = this.tree.getNodeById(this.currentNodeId);
			Ext.Ajax.request({
                url:this.baseAction + '&method=getGroupMember',method:'POST',params:{groupid :this.currentNodeId},
				failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},
				success:function(r,options){
					r=jsonReturn(r);
					if(r.success){
						if (this.store)this.store.removeAll();
						if(r.data)
						for ( var i = 0; i < r.data.length; i++) {
							this.store.add(new Ext.data.Record({name : r.data[i].adminname+(r.data[i].fullname.length>0 ? "("+r.data[i].fullname+")":"")}, r.data[i].adminid));
						}
					}else{
						alert('获取组成员数据失败!');
					}
				},scope:this                                 
            });
        	this.groupEditorForm.form.items.items[0].setValue(node.text);
        	this.groupEditorForm.form.items.items[1].setValue(node.attributes['description']);
        	this.groupEditorForm.form.items.items[2].setValue(node.attributes['sort']);
        	this.groupEditorForm.form.items.items[3].setValue(node.id);
        }else{this.groupEditorForm.form.reset();if (this.store)this.store.removeAll();} 
	},
	groupSave:function(){
 		var formitems = this.groupEditorForm.form.items.items;
		if (!formitems[0].isValid()) {
			Ext.MessageBox.show({
				title :'错误',msg :"很抱歉，您无法创建没有名称的管理员组",buttons :Ext.MessageBox.OK,icon :'ext-mb-error'
			});
			formitems[0].focus();
			return;
		}
		var member = [];if(this.store) this.store.each(function(r) {member.push(r.id);});
		this.groupEditorForm.form.submit({url:this.baseAction + (this.groupEditorForm.form.getValues().groupid ? '&method=updategroup' : '&method=insertgroup'),params:{members:Ext.encode(member)}});
	},
	addMember:function(){
		EXCMS.util.script('Modules/System/AdminSelect.js',{object:'EXCMS.System.AdminSelect',callback:this.callback.createDelegate(this)});
	},
	callback:function(r){
		for ( var i = 0, len = r.length; i < len; i++) if (r[i].id) if (!this.store.getById(r[i].rid)) {this.store.add(new Ext.data.Record({name : r[i].data.adminname+(r[i].data.fullname.length>0 ? "("+r[i].data.fullname+")":"")}, r[i].id));}
	},
	delMember:function(){
		var r = this.dataview.getSelectedRecords();
		if (r.length == 0) {alert('请先选择要删除的成员');return;}
		for ( var i = 0; i < r.length; i++) this.store.remove(r[i]);
	},
	checkCell : function(n,e){
		var t = e.getTarget();
		if (t.tagName.toLowerCase() == 'div' && t.className && t.className.indexOf('x-grid3-cc') != -1) {
			var pos = t.parentNode.columnIndex-1;
			var acl = n.attributes['acl'].split('');
			acl[pos] = Math.abs(parseInt(acl[pos])-1);
			if (pos == 0 && acl[0] == 0){
				for(var i=1;i<acl.length;i++){
					if(acl[i]==1) acl[i]=0;
				}
			}else if (pos > 0 && acl[pos] == 1 && parseInt(acl[0])!=1) {
				acl[0]=1;
				n.attributes['acl'] = acl.join('');
				n.getUI().setACL(n.attributes['acl']);
			}else{
				n.attributes['acl'] = acl.join('');
				n.getUI().setCls(t,acl[pos]);
			}
		}
	},
	groupACL:function(){
		if(this.currentNodeId =='0'){Ext.MessageBox.alert('提示','请选择一个组！');return;}
        var title = this.currentNode.text + " 组权限设置";
		if(!this.groupACLwin){
			var tthis = this;
			this.lastid = this.currentNodeId;
			this.acl_action = new Ext.tree.TreePanel({
				region:'west',collapsible:false,split:true,width:110,minSize:110,autoScroll:true,collapseMode:'mini',collapsible:true,
				rootVisible:false,cls:'channel-tree setting-tree',bodyStyle:'padding:6px',border:false,style:'border-right:1px solid #99BBE8;',
				root:new Ext.tree.AsyncTreeNode({id:'root',expanded:true})
			});
			this.base_acl = new Ext.ux.tree.TreeGrid({region:'center',enableDD: true,border:false,checkModel: 'cascade', showIcon:false,checkTreeGrid:true,
				enableSort: false,columns:[
					{header: '菜单/操作权限',dataIndex: 'text', width: 230},
					{header: '类型',dataIndex: 'type', width: 40,tpl:new Ext.XTemplate('{type:this.formatType}', {formatType: function(v) {return v ? '<font color="red">权限</font>' : '<font color="green">菜单</font>'}})},
					{header: '描述',dataIndex: 'description',width: 190}
				],
		        dataUrl: this.baseAction+'&method=menutree',baseParams:{groupid:this.currentNodeId}
		    });
			this.base_acl.getLoader().on('load',function(o,n,r){this.base_acl.el.unmask();},this);
			this.channel_acl = new Ext.ux.tree.TreeGrid({enableDD: true,border:false,checkModel: 'childCascade', showIcon:false,checkTreeGrid:true,
				checkColumn: true,showIcon:true,enableSort: false,columns:[
					{header: '栏目名称',dataIndex: 'text', width:180},
					new Ext.tree.CheckboxColumn({header: '查看',dataIndex: 'acl',positionIndex:0,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '添加',dataIndex: 'acl',positionIndex:1,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '修改',dataIndex: 'acl',positionIndex:2,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '删除',dataIndex: 'acl',positionIndex:3,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '推荐',dataIndex: 'acl',positionIndex:4,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '移动',dataIndex: 'acl',positionIndex:5,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '发布',dataIndex: 'acl',positionIndex:6,align:'center', width: 40})
				],
		        dataUrl: this.baseAction+'&method=channeltree',baseParams:{nodata:1}
		    });
	        this.channel_acl.on('click',function(n,e){this.checkCell(n,e);tthis.channel_acl.aclChange = true;},this);
	        this.channel_acl.getLoader().on('load',function(o,n,r){this.channel_acl.el.unmask();},this);
			this.block_acl = new Ext.ux.tree.TreeGrid({cls:'block-tree',enableDD: true,border:false,checkModel: 'childCascade', showIcon:false,checkTreeGrid:true,
				checkColumn: true,showIcon:true,enableSort: false,columns:[
					{header: '碎片分类(页面)/碎片',dataIndex: 'text', width:260},
					new Ext.tree.CheckboxColumn({header: '查看',dataIndex: 'acl',positionIndex:0,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '修改',dataIndex: 'acl',positionIndex:1,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '删除',dataIndex: 'acl',positionIndex:2,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '发布',dataIndex: 'acl',positionIndex:4,align:'center', width: 40}),
					new Ext.tree.CheckboxColumn({header: '历史',dataIndex: 'acl',positionIndex:5,align:'center', width: 40})
				],
		        dataUrl: this.baseAction+'&method=blocktree',baseParams:{nodata:1}
		    });
			this.block_acl.on('click',function(n,e){this.checkCell(n,e);tthis.block_acl.aclChange = true;},this);
			this.block_acl.getLoader().on('load',function(o,n,r){this.block_acl.el.unmask();},this);
			this.ACLcenter = new Ext.Panel({region:'center',layout:'card',activeItem:0,border:false,items:[this.base_acl,this.channel_acl,this.block_acl]});
			this.groupACLwin = new Ext.Window({id:'dlg-system-groupACL-win',title:title,layout:'border',minimizable:true,modal:true,resizable:true,minHeight:400,minWidth:500, width:610,height:400,closeAction:'hide',plain: true,
                items: [this.acl_action,this.ACLcenter],
                buttons: [{text:'确定',handler: this.GACLSave,scope:this,mode:0},{text: '取消',handler: this.cancelAclSetttings,scope:this},{text:'应用',handler: this.GACLSave,scope:this,mode:1}]
            });
		}
		this.groupACLwin.show();
		this.groupACLwin.setTitle(title);
		if(this.acl_action.root.childNodes.length==0)
		this.acl_action.root.appendChild([
			new Ext.tree.TreeNode({id:'0',text:'基本权限',leaf:true}),
			new Ext.tree.TreeNode({id:'1',text:'栏目权限',leaf:true}),
			new Ext.tree.TreeNode({id:'2',text:'碎片权限',leaf:true})
		]);
		this.acl_action.getNodeById('0').select();
		this.ACLcenter.getLayout().setActiveItem(0);
		this.acl_loaded[0] = true;
		this.acl_action.on('click',function(n,e){
			this.ACLcenter.getLayout().setActiveItem(parseInt(n.id));
			if (this.refreshData) {
				this.refreshData = false;				
				this.acl_loaded['1'] = this.acl_loaded['2']=this.channel_acl.aclChange = this.block_acl.aclChange = false;
			}
			if(!this.acl_loaded[n.id]){
				if(n.id=='1'){
					var loader = this.channel_acl.getLoader();
					loader.baseParams = {groupid:this.currentNodeId};
					this.channel_acl.el.mask('正在加载栏目权限数据, 请稍侯...');
					loader.load(this.channel_acl.root);
					this.channel_acl.root.expand();
				}else{
					var loader = this.block_acl.getLoader();
					loader.baseParams = {groupid:this.currentNodeId};
					this.block_acl.el.mask('正在加载碎片权限数据, 请稍侯...');
					loader.load(this.block_acl.root);
					this.block_acl.root.expand();
				}
				this.acl_loaded[n.id] = true;
			}
		},this);
		if(this.lastid != this.currentNodeId){
			this.lastid = this.currentNodeId;
			this.refreshData = true;
			var loader = this.base_acl.getLoader();
			loader.baseParams = {groupid:this.currentNodeId};
			this.base_acl.el.mask('正在加载菜单权限数据, 请稍侯...');
			loader.load(this.base_acl.root);
			this.base_acl.root.expand();
			this.base_acl.aclChange = false;
		}
	},
	GACLSave:function(item){
		if(this.base_acl.aclChange || this.channel_acl.aclChange || this.block_acl.aclChange){
			var baseAcl=channelAcl=blockAcl=-1;
			if(this.base_acl.aclChange)	 {this.getACL(); baseAcl = Ext.encode(this.baseAclData);}
			if(this.channel_acl.aclChange)	{this.getChannelACL(); channelAcl = Ext.encode(this.channelAclData);}
			if(this.block_acl.aclChange)	 {this.getBlockACL(); blockAcl = Ext.encode(this.blockAclData);}
			this.groupACLwin.el.mask('正在保存权限数据, 请稍侯...');
			Ext.Ajax.request({
	            url:this.baseAction+'&method=saveACL',method:'POST',params:{groupid:this.currentNodeId,baseAcl:baseAcl,channelAcl:channelAcl,blockAcl:blockAcl},
	            failure:function(r,p){this.aclTG.el.unmask();},  
	            success:function(r,o){
	                this.groupACLwin.el.unmask();
					r=jsonReturn(r);
					if(r.success){
						this.base_acl.aclChange = this.channel_acl.aclChange = this.block_acl.aclChange = false;
						if(item.mode==0) this.groupACLwin.hide();
						EXCMS.msg('提示','权限设置成功');
					}else{
						alert(r.message);
					}
	            },
	            scope:this                                 
	        });
		}else{
			if(item.mode==0) this.groupACLwin.hide();
		}
	},
	cancelAclSetttings:function(){
		if(this.base_acl.aclChange || this.channel_acl.aclChange || this.block_acl.aclChange){
			Ext.MessageBox.show({
				title:'保存修改?',
				msg: '权限设置已更改，您要保存更改吗?',
				buttons: {yes:'是',no:'否',cancel:'取消'},
				fn: function(b,t){
					if(b=='yes') this.GACLSave({mode:0});else if(b=='no') {this.lastid=0;this.groupACLwin.hide();}
				},
				icon: Ext.MessageBox.QUESTION,
				scope:this
			});
		}else this.groupACLwin.hide();
	},
	//获取权限
	getACL:function(nodes){
		if (nodes) {
			for(var i=0;i<nodes.length;i++){
				if(nodes[i].checked) {
					var id = nodes[i].id.split('-');
					if(id[0]=='m'){
						this.baseAclData.push([id[1],0]);
					}else{
						this.baseAclData.push([nodes[i].menuid,id[1]]);
					}
				}
				if(nodes[i].children) this.getACL(nodes[i].children);
			}
		}else{
			this.baseAclData = [];
			nodes = this.base_acl.root.childNodes;
			for(var i=0;i<nodes.length;i++){
				if (nodes[i].attributes['checked']) {
					var id = nodes[i].id.split('-');
					if(id[0]=='m'){
						this.baseAclData.push([id[1],0]);
					}else{
						this.baseAclData.push([nodes[i].attributes['menuid'],id[1]]);
					}
				}
				if(nodes[i].attributes['children']) this.getACL(nodes[i].attributes['children']);
			}
		}
	},
	//获取栏目权限
	getChannelACL:function(nodes){
		if (nodes) {
			for(var i=0;i<nodes.length;i++){
				if(parseInt(nodes[i].acl)>0) this.channelAclData.push([nodes[i].id,nodes[i].acl]);
				if(nodes[i].children) this.getChannelACL(nodes[i].children);
			}
		}else{
			this.channelAclData = [];
			nodes = this.channel_acl.root.childNodes;
			for(var i=0;i<nodes.length;i++){
				if(parseInt(nodes[i].attributes['acl'])>0) this.channelAclData.push([nodes[i].id,nodes[i].attributes['acl']]);
				if(nodes[i].attributes['children']) this.getChannelACL(nodes[i].attributes['children']);
			}
		}
	},
	//获取栏目权限
	getBlockACL:function(nodes){
		if (nodes) {
			for(var i=0;i<nodes.length;i++){
				if(parseInt(nodes[i].acl)>0) this.blockAclData.push([nodes[i].id,nodes[i].acl]);
				if(nodes[i].children) this.getBlockACL(nodes[i].children);
			}
		}else{
			this.blockAclData = [];
			nodes = this.block_acl.root.childNodes;
			for(var i=0;i<nodes.length;i++){
				if(parseInt(nodes[i].attributes['acl'])>0) this.blockAclData.push([nodes[i].id,nodes[i].attributes['acl']]);
				if(nodes[i].attributes['children']) this.getBlockACL(nodes[i].attributes['children']);
			}
		}
	},
	groupdel:function(){
        if(this.currentNodeId !='0'){
            Ext.MessageBox.confirm('提示','您确实要删除选定的记录吗？',function(optional){
            if(optional=='yes'){
                Ext.Ajax.request({
                    url:this.baseAction + '&method=deletegroup',method:'POST',params:{groupid :this.currentNodeId},failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},success:function(r,options){r=jsonReturn(r);alert(r.message);if(r.success){this.tree.root.removeChild(this.tree.getNodeById(this.currentNodeId)); this.currentNodeId = '0';this.currentGroup = '';this.D.reload();}},scope:this                                 
                });
            }
            else return
        },this);
        }else {Ext.MessageBox.alert('提示','请选择一个管理员组！');return}
	},
	adminDel : function (){
		var selected = this.G.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的管理员');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
        Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的管理员吗？",function(optional){if(optional=='yes'){
		  Ext.Ajax.request({url:this.baseAction + '&method=delete',method:'post',scope:this,
			  params:{adminid:id.join(',')},
			  success:function(r,o){this.D.reload();}
		  })}
        },this);
	},
	edit :function(item){
		var title = '';
	    if(item.mode == 0) title = '新管理员';
	    else if(item.mode == 1){
            var selected = this.G.getSelectionModel().getSelections();
            if(selected.length !=1){Ext.MessageBox.alert('提示','请选择一条记录！');return;}
            title = selected[0].data.adminname + ' 属性';
            this.currentNodeId=selected[0].id
        }
		
	    if(!this.adminEditor){
    	    this.Gsm = new Ext.grid.CheckboxSelectionModel();
            this.GD = new Ext.data.Store({
                proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=admingroupStore'}),reader:new Ext.data.JsonReader({root:'data',id:'id',fields:['id','name','description','Status']}),remoteSort:true
            });
            this.groupGrid = new Ext.grid.GridPanel({
                store:this.GD,columns:[new Ext.grid.RowNumberer(),{header:"组名称",width:120,menuDisabled:true,sortable:false,dataIndex:'name'},{header:"描述",width:200,menuDisabled:true,sortable:false,dataIndex:'description'}],tbar:[{text:'添加',handler:this.selectG,scope:this},{text:'移除',handler:this.removeG,scope:this}],border:false,enableColumnMove:false,collapsible:true,animCollapse:false,autoExpandColumn:2,minColumnWidth:2,width:407,height:300
            });
			
			var labelStyle='padding-left:90px !important;';
            this.adminEditorForm = new Ext.form.FormPanel({border:false,url:this.baseAction+'&method=update',defaultType:'textfield',items:[
                 {xtype:'tabpanel',activeTab:0,border:false,height:330,width:408,items:[
                    {title:'常规',layout:'fit',border:false,items:[
                        {layout:'form',id:'admineditform',border:false,defaults:{anchor:'-12'},bodyStyle:'padding:12px',labelWidth:60,defaultType:'textfield',items:[
                            {fieldLabel:'管理员名',name:'adminname',allowBlank:false,blankText:"管理员名不能为空",vtype:'username',usernameMinLen:4,usernameMaxLen:20, vtypeText:'管理员名长度最短4字符(2个汉字)最长20字符(或10个汉字)'},
							{fieldLabel:'姓名',name:'fullname',allowBlank:false,blankText:"管理员姓名不能为空"},
							{fieldLabel:'描述',name:'description'},
							{fieldLabel:'密码',name:'password',inputType:'password',maxLength:25,allowBlank:false,blankText:'密码不能为空'},
							{fieldLabel:'确认密码',name:'rePassword',inputType:'password',maxLength:25,allowBlank:false,blankText:'确认密码不能为空'},
							{layout:'form',xtype:'panel',border:false,bodyStyle:'padding-left:65px;',items:[
								{xtype:'checkbox',hideLabel:true,boxLabel:'管理员不能更改密码',name:'Pwdedit'},{xtype:'checkbox',hideLabel:true,boxLabel:'密码永不过期',name:'Pwdoverdue'},{xtype:'checkbox',hideLabel:true,boxLabel:'帐户已禁用',name:'status'}							   
							]},{name:'adminid',xtype:'hidden'}
                        ]}                      
                    ]},{title:'隶属于',id:'flow',layout:'fit',items:this.groupGrid}
                 ]}
            ]});
            this.adminEditor = new Ext.Window({id:'dlg-system-admin-editor',layout:'fit',minimizable:true,modal:true,resizable:false,width:420,height:340,closeAction:'hide',plain:true,items:this.adminEditorForm,buttons:[{text:'确定',handler:this.adminSave,scope:this,mode:0},{text:'取消',handler:function(){this.adminEditor.hide();},scope:this}]
            });
            this.adminEditorForm.form.on('actioncomplete',function(form,action){
                if(action.result.success){
                	this.adminEditor.hide();this.D.reload();
					EXCMS.msg('提示',action.result.message);
                }
            },this);
        }
		
//        this.adminEditor.buttons[0].disabled=false;
//        this.adminEditor.buttons[0].mode = item.mode;
        this.adminEditor.setTitle(title);
        this.addGids = [];
        this.delGids = [];
        if(item.mode == 1){
            this.adminEditor.show(this);
            this.showPwd(false);
			selected[0].data.status=selected[0].data.status==1?0:1;
            this.adminEditorForm.form.setValues(selected[0].data);
            this.GD.baseParams = {adminid:selected[0].id};
            this.GD.reload();
        }else{
            this.adminEditor.show(this);
            this.showPwd(true);
            this.adminEditorForm.form.reset();
            this.GD.removeAll();
        }
	},
	showPwd :function(flag){
	    var pwd =  Ext.getDom("admineditform").firstChild.firstChild.childNodes[3];
	    var repwd =  Ext.getDom("admineditform").firstChild.firstChild.childNodes[4];
	    if(flag){pwd.style.display = '';repwd.style.display = '';this.adminEditorForm.form.items.items[3].allowBlank = false;this.adminEditorForm.form.items.items[4].allowBlank = false;}
	    else{pwd.style.display = 'none';repwd.style.display = 'none';this.adminEditorForm.form.items.items[3].allowBlank = true;this.adminEditorForm.form.items.items[4].allowBlank = true;}
	},
	adminSave :function(item){
	    if(!this.adminEditorForm.form.isValid()){ Ext.MessageBox.show({title:'提示',msg:"请选择或填写红线处的必填项！",buttons:Ext.MessageBox.OK});return ;}
	    this.adminEditorForm.form.jsonData = this.adminEditorForm.form.getValues();
	    if(item.mode == 0){
	        if(this.adminEditorForm.form.jsonData.password != this.adminEditorForm.form.jsonData.rePassword){
	            Ext.MessageBox.show({title:'错误',msg:"您输入的密码和确认密码不一致",buttons:Ext.MessageBox.OK,icon:'ext-mb-error'});return ;
	        }
	        delete this.adminEditorForm.form.jsonData.id;
	    }else{
	        delete this.adminEditorForm.form.jsonData.password;
	        delete this.adminEditorForm.form.jsonData.rePassword;
	    }
	    this.admingroupids = '';
		for(var i=0;i<this.GD.getCount();i++){
			this.admingroupids += ',' + this.GD.data.items[i].id;
		}
	    this.adminEditorForm.form.submit({params:{groupids:this.admingroupids}});
	},
	selectG :function(){
	    if(!this.groupSelecter){
	        this.selectGsm = new Ext.grid.CheckboxSelectionModel();
            this.selectGD = new Ext.data.Store({
                proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=groupStore'}),reader:new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'id',fields:['id','groupid','name','description']}),remoteSort:true    
            });
            this.selectGD.setDefaultSort('Sort','ASC');
            this.selectGD.baseParams = {pid:0};
            this.selectGD.load({params:{start:0,limit:10}});
            this.selectGroupGrid = new Ext.grid.GridPanel({
                store:this.selectGD,columns:[new Ext.grid.RowNumberer(),this.selectGsm,{header:"组名称",width:120,sortable:true,dataIndex:'name'},{header:"描述",width:200,sortable:true,dataIndex:'description'}],border:false,sm:this.selectGsm,enableColumnMove:false,collapsible:true,animCollapse:false,iconCls:'icon-grid',region:'center',autoExpandColumn:3,minColumnWidth:3,width:487,height:260,loadMask:true,bbar:new Ext.PagingToolbar({pageSize:10,store:this.selectGD,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据"})
            });
            this.groupSelecter = new Ext.Window({id:'dlg-system-group-selecter',title:"添加所属组",layout:'fit',minimizable:true,modal:true,resizable:false,width:500,height:332,closeAction:'hide',plain:true,items:this.selectGroupGrid,buttons:[{text:'确定',handler:this.addG,scope:this,mode:0},{text:'取消',handler:function(){this.groupSelecter.hide();},scope:this}]
            });
	    }else{
	        this.selectGD.reload();
	    }
	    this.groupSelecter.show(this);
	    
	},
	addG :function(){
		var selected = this.selectGroupGrid.getSelectionModel().getSelections();
	    for(var i=0;i<selected.length;i++){
	        if(!this.GD.getById(selected[i].id)) {this.GD.insert(this.GD.getCount(),selected[i]);}
	    }
	    this.selectGroupGrid.getSelectionModel().clearSelections();
	    this.groupSelecter.hide();
	},
	removeG :function(){
	    var selected = this.groupGrid.getSelectionModel().getSelections();
        if(selected.length > 0){
            for (var i = 0,len = selected.length; i < len; i++) {
                this.groupGrid.getStore().remove(selected[i]);
            }
        }else Ext.MessageBox.alert('提示','请至少选择一个组！');
	},
	setStatus :function(item){
	    var selected = this.G.getSelectionModel().getSelections();
	    if(selected.length == 0){Ext.MessageBox.alert('提示','请至少选择一条记录！');return;}
	    var uids = [],ids='';
        for (var i = 0,len = selected.length; i < len; i++) {uids.push(selected[i].id);ids += selected[i].id+",";}
	    Ext.Ajax.request({
            url:this.baseAction+'&method=status',method:'POST',params:{ids:ids,status:item.mode},failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},success:function(r,o){
                r=jsonReturn(r);
                if(r.success){
                    if(item.mode){
                        for(var i=0;i<uids.length;i++) this.D.getById(uids[i]).set('status',1);
					    this.G.topToolbar.items.items[4].setText('禁用');
					    this.G.topToolbar.items.items[4].mode = 0;
				    }else{
				        for(var i=0;i<uids.length;i++) this.D.getById(uids[i]).set('status',0);
					    this.G.topToolbar.items.items[4].setText('启用');
					    this.G.topToolbar.items.items[4].mode = 1;
				    }
				    this.D.commitChanges();
                }
            },scope:this                                 
        });
	},
	adminContentStat:function(){
		if(!this.record || !this.D.getById(this.record.id)){alert('请选择一个管理员');return}
	},
	adminContent :function(item){
		if(!this.record || !this.D.getById(this.record.id)){alert('请选择一个管理员');return}
		window.location.href = "index.php?M=Content&adminid="+this.record.id; 
	},
	setPassword :function(){
		if(!this.record || !this.D.getById(this.record.id)){
			alert('请选择要设置密码的管理员');
			return ;
		}
	    if(!this.pwdwin){
			this.pwdEditorForm = new Ext.FormPanel({
				labelWidth:60,baseCls:'x-plain',defaultType:'textfield',defaults:{anchor:'100%'},bodyStyle:'padding:20px 12px',border:false,url:this.baseAction + '&method=setpassword',
				items:[
					{name:'adminid',xtype:'hidden'},
					{fieldLabel:'新密码',name:'password',id:'password',inputType:'password',allowBlank:false,blankText:'密码不能为空',maxLength:20,minLength:4,minLengthText:'密码长度4-20位之间'},
					{fieldLabel:'确认密码',name:'repassword',inputType:'password',vtype:'password',initialPassField:'password',allowBlank:false,blankText:'确认密码不能为空'}
			]});
			
			this.pwdwin = new Ext.Window({id:'excms-win-setpasword',layout:'fit',modal:true,
				resizable:false,width:320,height:160,closeAction:'hide',plain:true,
				items:this.pwdEditorForm,
				buttons:[
					{text:'确定',handler:function(){if(!this.pwdEditorForm.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return}this.pwdEditorForm.form.submit()},scope:this},
					{text:'取消',handler:function(){this.pwdwin.hide()},scope:this}
				]
			});
			this.pwdwin.show();
			this.pwdEditorForm.form.on('actioncomplete',function(f,a){if(a.result.success){alert('密码已设置');this.pwdwin.hide()}},this);
	    }
	    this.pwdwin.setTitle('为 ' + this.record.data.adminname + ' 设置密码');
	    this.pwdwin.show();
	    this.pwdEditorForm.form.reset();
        this.pwdEditorForm.form.setValues({'adminid':this.record.data.adminid});
	},
	select:function(item){
		var G  = eval(item.grid);
		var D = G.getStore();
		var M=item&&item.mode?item.mode:1;
		switch(M){case 1:G.getSelectionModel().selectAll();break;case 2:for(var i=0;i<D.getCount();i++)G.getSelectionModel().isSelected(i)?G.getSelectionModel().deselectRow(i):G.getSelectionModel().selectRow(i,true);break;case 3:G.getSelectionModel().clearSelections();break;default:break}
	},
	renderStatus :function(v){return v == 0 ?'<span style="color:red;">禁用</span>':'<span style="color:green;">启用</span>';}
};
EXCMS.onReady(EXCMS.System.Admin.init,EXCMS.System.Admin);