EXCMS.System.Database = {
	baseAction : 'index.php?M=System&A=Database',
	init:function(){
		Ext.QuickTips.init();
		this.view();
		btn = this.G.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
		
	},
	
	active:function(o){
		//alert(o.attributes['mode'].value);
		switch(o.attributes['mode'].value){
			case 'backup':
				if(this.mainPanel.activate){this.mainPanel.activate(0);}
				else if(this.mainPanel.layout.setActiveItem){this.mainPanel.layout.setActiveItem(this.mainPanel.getComponent(1));}
				break;
			case 'restore':
				this.restoreTab();
				restore = this.restoreGrid.topToolbar.items.items;
				for(var i=0;i<restore.length;i++){
					if(restore[i].acl&&!excmsacl[restore[i].acl]){
						restore[i].hide();
					}
				}
				for(var i=0;i<this.restoreMenu.items.items.length;i++){
					if(this.restoreMenu.items.items[i].acl&&!excmsacl[this.restoreMenu.items.items[i].acl]){
						this.restoreMenu.items.items[i].hide();
					}
				}
				break;
			case 'sql':
				this.sqlWin();
				break;
			default:
				alert('UNKNOWN OPRATION!');
				break;
		}
	},
	
	view:function(){
		this.D = new Ext.data.Store({
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),
			reader:new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'Databaseid',
				fields:['tablename','rows','size','type']
            }),
			remoteSort:true
		});
		
		this.soField = new Ext.form.TwinTriggerField({emptyText:'表名称(模糊查询)',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		this.G = new Ext.grid.GridPanel({enableTabScroll:true,title:'数据备份',
			enableColumnMove:true,animCollapse:false,loadMask:true,
            store:this.D,sm:new Ext.grid.RowSelectionModel(),
			columns:[
                new Ext.grid.RowNumberer(),
				{header:"数据表名",width:300,sortable:true,dataIndex:'tablename'},
				{header:"记录条数",width:120,sortable:true,dataIndex:'rows'},
				{header:"使用空间",width:120,align:'right',sortable:true,dataIndex:'size'},
				{header:"表类型",width:120,sortable:true,dataIndex:'type'}
            ],
			tbar:new Ext.Toolbar({items:[
                {text:'备份',handler:this.backup,scope:this,acl:'backup'},
				{text:'优化',handler:this.optimize,scope:this,acl:'optimize'},
				{text:'修复',handler:this.repair,scope:this,acl:'repair'},
				{text:'结构',iconCls:'ico preview',handler:this.viewinfo,scope:this},'-',
				{text:'选择',menu:{items:[
   					 {text:'全选',handler:this.select,scope:this,mode:1},
   					 {text:'反选',handler:this.select,scope:this,mode:2},
   					 {text:'取消选择',handler:this.select,scope:this,mode:3}
   				]}},
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this}
				,'->','搜索 ',this.soField
            ]})
        });
                
        this.gridMenu = new Ext.menu.Menu({items:[
        	{text:'备份',handler:this.backup,scope:this,acl:'backup'},
			{text:'优化',handler:this.optimize,scope:this,acl:'optimize'},
			{text:'修复',handler:this.repair,scope:this,acl:'repair'},
			{text:'结构',icon:ico,iconCls:'ico preview',icon:ico,handler:this.viewinfo,scope:this}
        ]});
        this.D.load({params:{start:0,limit:25}});
        
        var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
 			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
 			items:{xtype:'panel',title:'数据库管理',contentEl:'system-action',collapsible:true,style:'margin-bottom:5px'}
 		});
		
        this.viewport = new Ext.Viewport({layout:'border',items:[actionPanel,{xtype:'tabpanel',region:'center',border:false,margins:'0 3 3 0',style:'border:1px solid #99BBE8;border-width:0px 1px 1px 1px',activeTab:0,enableTabScroll:true,items:this.G}]});
		this.mainPanel = this.viewport.getComponent(1);
		this.G.on('rowclick',function(g,r,e){this.record=this.D.getAt(r)},this);
		this.G.on('rowdblclick',function(g,r,e){this.viewinfo()},this);
        this.G.on('rowcontextmenu',function(g,r,e){
			this.record=this.D.getAt(r);
			var stm = g.getSelectionModel();
			stm.getSelections().indexOf(g.getStore().getAt(r))!= -1?stm.selectRow(r,true):stm.selectRow(r);
			this.gridMenu.showAt(e.getXY());
		},this);
		this.G.getEl().dom.oncontextmenu = function(){return false;}
        this.G.getEl().dom.onselectstart=function(){return false}
	},
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams={key:""};      
		this.D.reload();   
	},
	soOnTrigger2Click:function(){
	    var key = this.soField.getValue('').trim();
	    if(key != ''){
			this.D.baseParams = {key:key};         
	        this.D.reload();
	    }
	},
	//备份窗口
	backup : function(){
		var record = this.G.getSelectionModel().getSelections();
		if(!record){alert('请选择要备份的数据库表');return ;}
		this.tablenames = [];
        for(var i=0,len=record.length;i<len; i++){
        	this.tablenames.push(record[i].data.tablename);
        }
		if(!this.backupWin){
			this.formPanel = new Ext.form.FormPanel({labelWidth:100,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',url:this.baseAction+'&method=backup',items:[	
				{fieldLabel:'分卷文件大小KB',name:'volumesize',xtype:'numberfield',allowBlank:false,blankText:'分卷文件大小不能为空',maxValue : 3072, maxText : '文件大小应小于{0}',minValue : 10,minText : '文件大小应大于{0}',value:'2048'},
				{fieldLabel:'扩展插入方式',xtype:'radiogroup',cls:'iradiogroup',items:[
 					{boxLabel:'是',name:'extendedinsert',inputValue:1},
 					{boxLabel:'否',name:'extendedinsert',inputValue:0,checked:true}
 				]},
 				{fieldLabel:'建表语句格式',xtype:'radiogroup',cls:'iradiogroup',columns:2,items:[
 				   {boxLabel:'默认',name:'sqlformat',inputValue:0,checked:true},
 				   {boxLabel:'MySQL 3.23/4.0.x',name:'sqlformat',inputValue:1},
 				   {boxLabel:'MySQL 4.1.x/5.x',name:'sqlformat',inputValue:2}
 				]},
 				{fieldLabel:'强制字符集',xtype:'radiogroup',cls:'iradiogroup',columns:2,items:[
                    {boxLabel:'默认',name:'charset',inputValue:0,checked:true},
					{boxLabel:'LATIN1',name:'charset',inputValue:1},
					{boxLabel:'UTF-8',name:'charset',inputValue:2}
				]},
				{fieldLabel:'十六进制方式',xtype:'radiogroup',cls:'iradiogroup',items:[
					{boxLabel:'是',name:'ishex',inputValue:1},
					{boxLabel:'否',name:'ishex',inputValue:0,checked:true}
				]},
				{fieldLabel:'压缩备份文件',xtype:'radiogroup',cls:'iradiogroup',columns:2,items:[
                    {boxLabel:'不压缩',name:'compress',inputValue:0,checked:true},
					{boxLabel:'多分卷压缩成一个文件',name:'compress',inputValue:1},
					{boxLabel:'每个分卷压缩成单独文件',name:'compress',inputValue:2}
				]},
				{fieldLabel:'备份文件名',name:'filename',value:''}
			]});
			
            this.backupWin=new Ext.Window({layout:'fit',modal:true,resizable:false,width:470,height:360,closeAction:'hide',plain: true,title:'数据库备份',
                items:this.formPanel,
                buttons:[{text:'确定',handler:this.commitBackup,scope:this},{text:'取消',handler:function(){this.backupWin.hide()},scope:this}]
            });
            this.formPanel.form.on('actioncomplete',function(form,action){
				Ext.MessageBox.hide();
				alert(action.result.message); 
                if(action.result.success){this.backupWin.hide();}
            }, this);
		}
		this.backupWin.show();
	},
	//备份
	commitBackup : function(){
		if(!this.formPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.formPanel.form.submit({params:{tables:Ext.util.JSON.encode(this.tablenames)}});
		Ext.MessageBox.show({title:'数据库备份',msg: '正在备份数据...',buttons: {cancel:'取消备份'}, width:300,wait:true,waitConfig: {interval:200}});
	},
	//优化
	optimize : function(){
		var record = this.G.getSelectionModel().getSelections();
		if(!record){alert('请选择要优化的数据库表');return ;}
		var tablenames = [];
        for(var i=0,len=record.length;i<len; i++){
        	tablenames.push(record[i].data.tablename);
        }
		Ext.Ajax.request({method:'POST', url:this.baseAction+'&method=optimize',params:{tables:Ext.util.JSON.encode(tablenames)}, 
			success : function(r, a) {
				var r = jsonReturn(r);
				if(r.success){alert(r.message);} 
			},
			failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败，请重试!');},
			scope:this
		});
	},
	//修复
	repair : function(){
		var record = this.G.getSelectionModel().getSelections();
		if(!record){alert('请选择要修复的数据库表');return ;}
		var tablenames = [];
        for(var i=0,len=record.length;i<len; i++){
        	tablenames.push(record[i].data.tablename);
        }
		Ext.Ajax.request({method:'POST', url:this.baseAction+'&method=repair',params:{tables:Ext.util.JSON.encode(tablenames)}, 
			success : function(r, a) {
				var r = jsonReturn(r);
				if(r.success){alert(r.message);} 
			},
			failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败，请重试!');},
			scope:this
		});
	},
	//结构
	viewinfo : function(){
		var record = this.G.getSelectionModel().getSelections();
		if(!record){alert('请选择要修复的数据库表');return ;}
		else if(record.length>1){alert('每次只能查看一个表的结构');return ;}
		var tablenames = record[0].data.tablename;
		Ext.Ajax.request({method:'POST', url:this.baseAction+'&method=viewinfo',params:{tables:tablenames}, 
			success : function(r, a) {
				var r = jsonReturn(r);
				if(r.success){
					if(!this.viewinfo_win){
						this.viewinfo_win=new Ext.Window({id:'database-win-viewinfo',title:'表结构信息',modal:true,width:480,height:300, 
							maximizable:true,minimizable:true,closeAction:'hide',html:'',autoScroll:true,bodyStyle:'background:#FFFFFF;padding:6px 10px;',
							buttons:[{text:'关闭',handler:function(){this.viewinfo_win.hide()},scope:this}]
						})
					}
					this.viewinfo_win.show();
					this.viewinfo_win.body.dom.innerHTML=r.message;
				} 
			},
			failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败，请重试!');},
			scope:this
		});
	},
	//选择
	select:function(item){
		 var mode=item&&item.mode?item.mode:1;
		 var grid = item.second?this.restoreGrid:this.G;
		 var data = item.second?this.restoreD:this.D;
		 switch(item.mode){
			 case 1:grid.getSelectionModel().selectAll(); break;
			 case 2:for(var i=0;i< data.getCount();i++)grid.getSelectionModel().isSelected(i)?grid.getSelectionModel().deselectRow(i):grid.getSelectionModel().selectRow(i,true);break;
			 case 3:grid.getSelectionModel().clearSelections();break;
			 default:break;
		 }
	},
	//数据还原窗口
	restoreTab : function(){
		var params={};
		if(!this.restoreGrid){
			this.restoreD = new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=restore'}),
				reader : new Ext.data.JsonReader({root:'data',id:'id',totalProperty: 'total',fields: ['filename','dateline','size','type','volume','filedir']}),
				remoteSort : true
			});
			this.restoreGrid = new Ext.grid.GridPanel({
				store: this.restoreD,sm:new Ext.grid.RowSelectionModel(),
				columns : [new Ext.grid.RowNumberer(),
					{header: '文件名',width:260,align:'left',dataIndex: 'filename'},
					{header: '备份时间',width:150,align:'center',dataIndex: 'dateline'},
					{header: '文件大小',width:120,align:'right',dataIndex: 'size'},
					{header: '类型',width:80,align:'right',dataIndex: 'type'},
					{header: '卷号',width:100,align:'right',dataIndex: 'volume'}],
				tbar:[
					{text: '导入', handler: this.restore,scope:this,acl:'import'},
					{text: '解压缩', handler: this.unzip,scope:this,acl:'unzip'},
					'-',
					{text: '删除', handler: this.delbackup,scope:this,acl:'delbackup'},
					{text:'选择',menu:{items:[
	   					 {text:'全选',handler:this.select,scope:this,mode:1,second:1},
	   					 {text:'反选',handler:this.select,scope:this,mode:2,second:1},
	   					 {text:'取消选择',handler:this.select,scope:this,mode:3,second:1}
	   				]}},
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.restoreD.reload()},scope:this},
					'-',
					{text:'关闭',handler:function(){this.setRestoreTabVisible(false)},scope:this}],
				enableColumnMove:false,collapsible:true,animCollapse:false,iconCls:'icon-grid',region:'center',border:false,anchor:'100% 100%'
			});
			this.restorePanel = new Ext.Panel({title:'数据还原',layout:'border',closable:false,autoScroll:true,border:false,items:this.restoreGrid});
			this.mainPanel.add(this.restorePanel);
			if(this.mainPanel.activate){this.mainPanel.activate(this.restorePanel);}
			else if(this.mainPanel.layout.setActiveItem){this.mainPanel.layout.setActiveItem(this.mainPanel.getComponent(1));}
			this.restoreGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.restoreGrid.getEl().dom.onselectstart = function(){return false;}
			this.restoreMenu = new Ext.menu.Menu({items:[
                {text: '导入', handler: this.restore,scope:this,acl:'import'},
				{text: '解压缩', handler: this.unzip,scope:this,acl:'unzip'},
				{text: '删除', handler: this.delbackup,scope:this,acl:'delbackup'}
      		]});
			this.restoreGrid.on('rowcontextmenu',function(g,r,e){
				var stm = g.getSelectionModel();
				stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) : stm.selectRow(r);
				this.refrashMenu(g.getStore().getAt(r).get('type'));
				this.restoreMenu.showAt(e.getXY());
				},this);
			this.restoreGrid.on('rowclick', function(g,r,c,e){this.refrashMenu(g.getStore().getAt(r).get('type'))},this);
			this.restoreD.setDefaultSort('id','asc');
			this.restoreD.baseParams = {modelid:this.modelId};
			this.restoreD.load();
		}else{
			this.restoreD.reload();
			this.setRestoreTabVisible(true);
		}
	},
	//还原
	restore : function(){
		var selected = this.restoreGrid.getSelectionModel().getSelections();
		var url = this.baseAction+'&method=import';
        if(selected.length == 1){
			Ext.MessageBox.confirm('提示','确定要将备份文件'+selected[0].data.filename+'导入数据库？',function(optional){
				if(optional == "yes"){
			        Ext.Ajax.request({
			            url: url,
			            method: 'POST', 
			            params:{filename:selected[0].data.filedir},
			            failure:function(response,options){Ext.MessageBox.alert("警告","出现异常错误！请联系管理员！");},  
			            success:function(r,o){
			                r=jsonReturn(r);
							if(r.success){
								if(r.confirm == 1){this.ConfirmRestoreAll('分卷数据成功导入数据库，您需要自动导入本次其它的备份吗？',url,{filename : r.next});}
							}
			            },
			            scope:this                                 
			        });
				}else{
					return;
				}
			},this);	
		}else Ext.MessageBox.alert('提示','导入操作必须选中一个备份！');
	},
	//确认导入
	ConfirmRestoreAll : function(msg,url,params){
		Ext.MessageBox.confirm('提示',msg,function(optional){
			if(optional == "yes"){
				Ext.Ajax.request({method:'POST', url:url,params:params, 
					success : function(r, a) {
						var r = jsonReturn(r);
						alert(r.message);this.restoreD.reload();
					},
					failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败ImportAll，请重试!');},
					scope:this
				});
			}else{
				this.restoreD.reload();
				return;
			}
		},this);	
	},
	//解压
	unzip : function(){
		var selected = this.restoreGrid.getSelectionModel().getSelections();
		var url = this.baseAction+'&method=unzip';
		if(selected.length == 1){
			Ext.Ajax.request({
				url : url,
				params : {filename : selected[0].data.filedir},
				method : 'POST',
				success :function(r, a){
					var r = jsonReturn(r);
					if(r.success == 0){
						alert(r.message);
					}else{
						if(r.confirm == 1 && r.confirmType == 1){
							this.ConfirmUnzipAll(r.fileinfo+'备份文件解压缩完毕，您需要自动解压缩其它的分卷文件吗？',url,{filename : selected[0].data.filedir,flag : 1});
						}else if(r.confirm == 1 && r.confirmType == 2){
							this.ConfirmRestoreAll(r.fileinfo,this.baseAction+'&method=import',{filename : selected[0].data.filedir,flag : 1});
						}else{
							alert(r.fileinfo+'解压成功！');this.restoreD.reload();
						}
					}
				},
				failure :function(f, a) {Ext.MessageBox.buttonText.ok = '确定';Ext.MessageBox.alert('消息', '请求服务器失败!');},
				scope:this
			});
		}else Ext.MessageBox.alert('提示','解压操作必须选中一个备份！');
	},
	//确认解压
	ConfirmUnzipAll : function(msg,url,params){
		Ext.MessageBox.confirm('提示',msg,function(optional){
			if(optional == "yes"){
				Ext.Ajax.request({method:'POST', url:url,params:params, 
					success : function(r, a) {
						var r = jsonReturn(r);
						if(r.success){
							if(r.confirm == 1 && r.confirmType==2){
								this.ConfirmRestoreAll(r.fileinfo,this.baseAction+'&method=import',{filename : params.filename,flag : 1});
							}
						}else{
							Ext.MessageBox.alert('提示消息',r.message);
						} 
					},
					failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败UnzipAll，请重试!');},
					scope:this
				});
			}else{
				this.restoreD.reload();
				return;
			}
		},this);	
	},
	//删除备份
	delbackup : function(){
		var record = this.restoreGrid.getSelectionModel().getSelections();
		if(!record){alert('请选择要删除的备份文件');return ;}
		this.filedirs = [];
        for(var i=0,len=record.length;i<len; i++){
        	this.filedirs.push(record[i].data.filedir);
        }
		Ext.MessageBox.confirm('提示','你确定要删除选中的备份文件',function(optional){
			if(optional == "yes"){
				Ext.Ajax.request({method:'POST', url:this.baseAction+'&method=delbackup',params:{filedirs:Ext.util.JSON.encode(this.filedirs)}, 
					success : function(r, a) {
						var r = jsonReturn(r);
						if(r.success){alert(r.message);	this.restoreD.reload();} 
					},
					failure : function(form, action) { Ext.MessageBox.alert('消息', '请求服务器失败UnzipAll，请重试!');},
					scope:this
				});
			}
		},this);	
	},
	//刷新显示菜单
	refrashMenu : function(type){
		if(type=='ZIP'){
			this.restoreGrid.topToolbar.items.items[0].disable();
			this.restoreGrid.topToolbar.items.items[1].enable();
			this.restoreMenu.items.items[0].disable();
			this.restoreMenu.items.items[1].enable();
		}else{
			this.restoreGrid.topToolbar.items.items[0].enable();
			this.restoreGrid.topToolbar.items.items[1].disable();
			this.restoreMenu.items.items[0].enable();
			this.restoreMenu.items.items[1].disable();
		}
	},
	//显示/隐藏数据还原窗口
	setRestoreTabVisible : function(flag){
	    if(flag){
	        this.mainPanel.unhideTabStripItem(this.restorePanel);
	        this.restorePanel.setVisible(true);
	    }else{
	        this.mainPanel.activate(0);
	        this.mainPanel.hideTabStripItem(this.restorePanel);
	    }
	},
	//sql命令工具
	sqlWin : function(){
		alert('show sql win!');
	}
};
EXCMS.onReady(EXCMS.System.Database.init,EXCMS.System.Database);