/**
 * @author Lynn.chang
 * @createdtime 2008.08.28 12:13
 * System User manage
 */
document.oncontextmenu =function (){return false;}
EXCMS.DesktopManage={
	baseAction:'index.php?M=System&A=DesktopManage',
	init:function(){
	    Ext.QuickTips.init();
	    this.view();
		btn = this.grid.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl && !excmsacl[btn[i].acl]){
				if (btn[i].acl == 'edit') {
					//this.disableedit = true;
					this.grid.on('beforeedit',function(e){e.cancel = true;},this);
				}
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
		var tree = this.tree.topToolbar.items.items;
		for(var i=0;i<tree.length;i++){
			if(tree[i].acl && !excmsacl[tree[i].acl]){
				tree[i].hide();
			}
		}
		for(var i=0;i<this.treeMenu.items.items.length;i++){
			if(this.treeMenu.items.items[i].acl&&!excmsacl[this.treeMenu.items.items[i].acl]){
				this.treeMenu.items.items[i].hide();
			}
		}
	},
    view : function(){
    	this.plant = Ext.data.Record.create(['id','title','style','url','status','sort']);
		this.D = new Ext.data.Store({
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=store'}),reader:new Ext.data.JsonReader({
                root:'data',totalProperty:'total',id:'id'},this.plant)
		});
		
        this.toolbar = new Ext.Toolbar({items:[
                {text:'新建',iconCls:'btnico btn_add',handler:this.add,scope:this,mode:'insert',acl:'add'},
                {text:'编辑',iconCls:'btnico btn_edit',handler:this.edit,scope:this,mode:'update',acl:'edit'},
                {text:'删除',iconCls:'btnico btn_del',handler:this.del,scope:this,acl:'delete'},
                {text:'保存',iconCls:'btnico btn_save',handler:this.save,scope:this,acl:'save'},'-',
                {text:'设置',menu: {items:[
					{text:'启用',iconCls:'btnico btn_check',handler:this.setting,scope:this,mode:1},
					{text:'禁用',handler:this.setting,scope:this,mode:0}
				]},acl:'setting'},
                '-',    
                {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this}
            ]});
        this.gridMenu = new Ext.menu.Menu({items: [
        	{text:'新建',icon:ico,iconCls:'ico add',handler:this.add,scope:this,mode:'insert',acl:'add'},
            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.edit,scope:this,mode:'update',acl:'edit'},
            {text:'删除',icon:ico,iconCls:'ico del',handler:this.del,scope:this,acl:'delete'}
        ]});
        
        var sm = new Ext.grid.RowSelectionModel();
        this.grid = new Ext.grid.EditorGridPanel({title:'桌面信息列表',collapsible:true,animCollapse:false,region:'center',loadMask:true,border:false,sm:sm,
            store:this.D,
            columns:[
                new Ext.grid.RowNumberer(),
                {header:"标题",width:300,sortable:true,dataIndex:'title',editor:new Ext.form.TextField({allowBlank:false,blankText:'标题不能为空'})},
                {header:"样式",width:150,sortable:true,dataIndex:'style',editor:new Ext.form.TextField()},
                {header:"请求地址",width:350,sortable:true,dataIndex:'url',editor:new Ext.form.TextField()},
                {header:"状态",width:50,sortable:true,dataIndex:'status',renderer:this.renderStatus,scope:this},
                {header:"排序",width:50,sortable:true,dataIndex:'sort',editor:new Ext.form.NumberField({decimalPrecision:0})}
            ],
            tbar:this.toolbar,
            bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo: true,displayMsg: '当前显示{0} - {1} 共{2}条',emptyMsg: "暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
        });
		this.grid.on('rowclick', function(g,r,e){this.record=this.D.getAt(r);},this);
		this.grid.on('rowcontextmenu', function(g,r,e){
			var stm = g.getSelectionModel(); stm.getSelections().indexOf(g.getStore().getAt(r)) != -1?stm.selectRow(r,true):stm.selectRow(r);
			this.record=g.getStore().getAt(r);
			this.gridMenu.showAt(e.getXY());
		}, this);
		
	   this.tree = new Ext.tree.TreePanel({
        	id:'west',region:'west',margins:'0 0 3 5',collapsible:false,split:true,width:200,minSize:35,
        	title:'桌面菜单管理',autoScroll:true,rootVisible:true,lines:false,useArrows:true,
            loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),root:new Ext.tree.AsyncTreeNode({id:'0',text:'我的桌面',expanded:true}),
            tbar:[{text:'添加',handler:this.TreeEdit,mode:'insert',scope:this,acl:'treeadd'},{text:'编辑',handler:this.TreeEdit,mode:'update',scope:this,acl:'treeedit'},{text: '删除',handler: this.TreeDel.createDelegate(this),acl:'treedelete'}] 
        });
    	 this.treeMenu =new Ext.menu.Menu({
			items: [
			{text: '新建',iconCls:'btnico btn_add',handler:this.TreeEdit,mode:'insert',scope:this,acl:'treeadd'},
			{text: '编辑',icon:ico,iconCls:'ico edit',handler: this.TreeEdit,scope:this,acl:'treeedit'},
			{text: '删除',icon:ico,iconCls:'ico del',handler: this.TreeDel,scope:this,acl:'treedelete'}
			]
		});	
		this.tree.on('click',function(n){if(this.node== n)return;this.node = n;},this);
		this.tree.on('contextmenu', function(n,e){
    		n.select(); 
    		this.node = n;
    		this.treeMenu.showAt(e.getXY());
    	},this);
    	
    	
	  	this.tabPanel = new Ext.TabPanel({id:'tabPanel',xtype:'tabpanel',region:'center',margins:'0 3 3 0',activeTab:0,enableTabScroll:true,items:this.grid});
        this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});
        this.D.load({params:{start:0,limit:25}});
        this.mainPanel = this.viewport.getComponent(1);
       
	},
	//桌面树编辑 
	TreeEdit : function(item){
		var title;
		if(item.mode=='insert'){
			title = '新建桌面菜单';
			this.treeid ='';
		}else{
			if(this.node && this.node.id!=0){
				title = this.node.text;
				this.treeid = this.node.id;
			}else{
				alert("请选择要修改的记录");
				return ;
			}
		}
		if(!this.treewin){
			this.pname=new Ext.form.ComboBox({fieldLabel:'上级菜单',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,
				mode:'local',triggerAction:'all',maxHeight:200,hidename:'pname',
				tpl: "<tpl for='.'><div style='height:200px'><div id='parentMenu'></div></div></tpl>",
				selectedClass:'',onSelect:Ext.emptyFn,emptyText:'请选择上级菜单'
			});
	        this.pname.tree=new Ext.tree.TreePanel({useArrows:true,border:false,
				loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction + '&method=tree'}),
				root:new Ext.tree.AsyncTreeNode({id:'0',text:'我的桌面'})
			});
			this.pname.tree.on('click',function(n){
				this.pname.setValue(n.text);
				this.pid.setValue(n.id);
				this.path = n.getPath();
				n.expand();
				this.pname.collapse();
			},this);
			this.pname.on('expand',function(c){this.pname.tree.root.expand();c.tree.render('parentMenu');},this);
			this.pid=new Ext.form.Hidden({name:'pid'});
			
			this.treeformPanel = new Ext.FormPanel({border:false,autoScroll:true,bodyStyle:'padding:15px',defaults:{border:false},items:[
				{layout:'form',defaults:{xtype:'textfield',border:false,anchor:'95%'},items:[
					{xtype:'hidden',name:'id'},
					this.pname,this.pid,
					{fieldLabel:'菜单名称',xtype:'textfield',name:'title',allowBlank:false,blankText:'菜单名称不能为空'},
					{fieldLabel:'图片名',xtype:'textfield',name:'icon'},
					{fieldLabel:'链接地址',xtype:'textfield',name:'url'},
					{fieldLabel:'动作名称',xtype:'textfield',name:'handler'},
					{fieldLabel:'排序',xtype:'numberfield',name:'sort',anchor:'50%'}
				]}
			]});
			this.treewin = new Ext.Window({id:'excms-win-desktoptree-setting',title:'',modal:true,layout:'fit',
				resizable:false,width:400,height:270,closeAction:'hide',plain:false,
				items:this.treeformPanel,
				buttons:[
					{text:'确定',handler:this.treesubmit,scope:this},
					{text:'取消',handler:function(){this.treewin.hide();},scope:this}
				]
			});	
			this.treeformPanel.form.on('actioncomplete',function(form,action){
				alert(action.result.message);
				this.treewin.hide();
				if(action.result.success){
					var values = form.getValues();
					var id = action.result.id;
					var name = values.title
					var pid = this.pid.getValue();
					if(this.treeid){
						this.node = this.tree.getNodeById(id);
						this.leaf = 1;
						if(this.node){
							if(this.node.parentNode.id == pid){
								this.node.setText(name);
								return ;
							}else{
								this.leaf = this.node.leaf;
								this.node.parentNode.removeChild(this.node);
							}
						}
						if(this.leaf){
							this.newNode = new Ext.tree.TreeNode({id:id,text:name,leaf:this.leaf});
						}else{
			            	this.newNode = new Ext.tree.AsyncTreeNode({id:id,text:name,leaf:this.leaf});
						}
						this.renderNode(this.path,pid);
					}else{
						this.newNode = new Ext.tree.TreeNode({id:id,text:name,leaf:1});
  						this.renderNode(this.path,pid);
					}
				}
			}, this);
		}
		
		this.treewin.setTitle(title);
		this.treewin.show();
		if(item.mode!='insert'){
			this.loadTeeData();
		}else{
			this.treeformPanel.form.reset();
			if(this.node && this.node.id!=0){
				this.pname.setValue(this.node.text);
				this.pid.setValue(this.node.id);
			}
		}
	},
	//添加栏目节点
	renderNode : function(url,nodeId){
		this.newParentNode = this.tree.getNodeById(nodeId);
		if(this.newParentNode){
			if(this.newParentNode.isExpanded()){
				this.tree.getLoader().load(this.newParentNode);
			}
			this.newParentNode.expand();
		}else{
			this.tree.expandPath(url);
		}
    },
	//加载桌面树信息
	loadTeeData : function(){
		this.treeformPanel.el.mask("数据加载中...");
		 Ext.Ajax.request({
            url: this.baseAction+"&method=treeload",
            method: 'POST', 
            params:{id:this.treeid},
            failure:function(response,options){this.treeformPanel.el.unmask();alert("加载数据失败,请与管理员联系");},  
            success:function(r,o){
            	this.treeformPanel.el.unmask();
            	r=jsonReturn(r);
            	this.treeformPanel.form.setValues(r.data);
            	this.pname.setValue(r.data.pname ? r.data.pname : '我的桌面');
            },scope:this
        });
	},
	//桌面树提交
	treesubmit : function(){
		if(!this.treeformPanel.form.isValid()){alert('表单中有错误，请检查红线处的错误提示！');return }
		var act = this.treeid == '' ? 'treeinsert' : 'treeupdate';
	    this.treeformPanel.form.submit({url:this.baseAction + '&method=' + act,id:this.treeid});
	},
	//桌面树删除
	TreeDel : function(){
        if (this.node && this.node.id!=0) {
        	Ext.MessageBox.confirm('警告', '删除桌面树将同时删除桌面树下的子节点，且不可恢复;确实要删除选定的桌面树吗？', function(o){
            if (o == 'yes') {
            	this.tree.getEl().mask("正在删除桌面树,请稍候...");
                Ext.Ajax.request({
                    url: this.baseAction + '&method=treedelete',
                    method: 'post',
                    params: {id: this.node.id},
                    failure:function(){this.tree.getEl().unmask();},
                    success: function(response, options){
                    	this.tree.getEl().unmask();
                        r = jsonReturn(response);
                        if (r.success) {
                            alert(r.message);
                            this.tree.getRootNode().removeChild(this.tree.getNodeById(this.node.id));                            
                        }
                    },
                    scope: this
                });
            }
        }, this);
        }else{
        	alert('请选择要删除的记录');
        }
	},
	//新建桌面信息
	add:function(){
		var p = new this.plant({title:'',style:'',url:'',sort:0});
		this.grid.stopEditing();
		this.D.insert(0,p);
		this.grid.startEditing(0,1);
	},
	//桌面信息编辑
	edit : function(){
		var idx = this.record ? this.D.indexOf(this.record) : -1;
		if(idx>-1){
			this.grid.stopEditing();
			this.grid.startEditing(idx,1);
		}else{alert('请选择要修改的记录')}
	},
	//桌面信息保存
	save : function(){
		var records = this.D.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push(records[i].data);
		}
		if(data.length > 0){
			this.mask(true,'桌面信息数据保存中,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=commit',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){this.mask(false);},
				success:function(r,o){
					this.mask(false);
					r=jsonReturn(r);
					if (r.success) {
						this.D.commitChanges();
						this.D.reload();
					}
				}
			});
		}else{
			this.D.each(function(r){
				if(r.get('title').trim()=="")this.D.remove(r);
			},this);
		}
	},
	//删除桌面信息
	del : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
        Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的记录吗？",function(optional){if(optional=='yes'){
    	this.mask(true,'正在删除桌面信息列表,请稍候');
		  Ext.Ajax.request({url:this.baseAction + '&method=delete',method:'post',scope:this,
			  params:{id:id.join(',')},
			  failure:function(r,o){this.mask(false);},
			  success:function(r,o){this.mask(false);this.D.reload()}
		  })}
        },this);
	},
	//设置桌面信息
	setting : function(item){
		var selected = this.grid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要设置的桌面信息');return ;}
		var id=[];
		for(var i =0,len=selected.length;i<len;i++) id.push(selected[i].id);
		this.mask(true,'正在设置桌面信息列表,请稍候');
		Ext.Ajax.request({url:this.baseAction+'&method=setting',method:'post',scope:this,
			params:{id:id.join(','),status:item.mode},
			failure:function(r,o){this.mask(false);},
		    success:function(r,o){this.mask(false);this.D.reload()}  
		});
	},
	mask:function(flag,msg){if(flag){this.grid.getEl().mask(msg)}else{this.grid.getEl().unmask()}},
	renderStatus :function(v){return v == 0 ?'<span style="color:red;">禁用</span>':'<span style="color:green;">启用</span>';}
};
EXCMS.onReady(EXCMS.DesktopManage.init,EXCMS.DesktopManage);