EXCMS.System = {
	baseAction : 'index.php?M=System&A=Index',
	init : function(){
	    Ext.QuickTips.init();
		this.store = ['站点设置','核心设置','文件目录','安全与加密','模板主题','邮件设置','调试与日志','其它设置'];
	    this.gp = this.store[0];
	    this.moduleid = 'config';
		this.view();
		btn = this.grid.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl&&!excmsacl[btn[i].acl]){
				if (btn[i].acl == 'edit') {
					this.disableedit = true;
					this.grid.on('beforeedit',function(e){e.cancel = true;},this);
				}
				btn[i].hide();
			}
		}
		for(var i=0;i<this.gridMenu.items.items.length;i++){
			if(this.gridMenu.items.items[i].acl&&!excmsacl[this.gridMenu.items.items[i].acl]){
				this.gridMenu.items.items[i].hide();
			}
		}
	},

	view : function(){		
        this.D = new Ext.data.Store({
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
            reader: new Ext.data.JsonReader({
                root: 'data',totalProperty: 'total',id: 'id',
                fields:["id","name","moduleid","_moduleid","value","group","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'}]
            }),remoteSort:false
        });

		this.soField = new Ext.form.TwinTriggerField({emptyText:'请输入名称,值,描述关键字',width:200,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
		
		this.grid = new Ext.grid.EditorGridPanel({region:'center',title:'站点设置',store:this.D,
			border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',
			minColumnWidth:2,border:false,sm:new Ext.grid.RowSelectionModel(),autoExpandColumn:3,
            columns:[
				new Ext.grid.RowNumberer(),
				{header:"变量名",width:150,sortable:true,dataIndex:'name'},
				{header:"变量值",width:230,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
				{header:"描述",width:150,sortable:true,dataIndex:'description'},
				{header:"模块",width:70,sortable:true,dataIndex:'_moduleid'},
				{header:"分组",width:70,sortable:true,dataIndex:'group'},
				//{header:"数据类型",width:70,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
				//{header:"系统变量?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
				{header:"排序",width:56,align:'right',sortable:true,dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
			],
			tbar:[
				{text:'新建',handler:this.edit,scope:this,mode:0,acl:'add'},
				{text:'编辑',handler:this.edit,scope:this,mode:1,acl:'edit'},
				{text:'删除',handler:this.del,scope:this,acl:'delete'},'-',
				{text:'更新缓存',handler:this.update,scope:this},'-',
				{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this},
				'->','搜索变量 ',this.soField
			]
		});
		this.gridMenu = new Ext.menu.Menu({items:[
            {text:'新建',icon:ico,iconCls:'ico add',handler:this.edit,scope:this,mode:0,acl:'add'},
            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.edit,scope:this,mode:1,acl:'edit'},
            {text:'删除',icon:ico,iconCls:'ico del',handler:this.del,scope:this,acl:'delete'},
            '-',
            {text: '更新缓存',iconCls:'ico update',handler:this.update,scope:this}
        ]}); 
		
		this.grid.on('celldblclick',function(g,r,c,e){if(this.disableedit)return;if(c!=8){this.record=this.D.getAt(r);this.edit({mode:1});}},this);
		this.grid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.record=this.D.getAt(r);this.gridMenu.showAt(e.getXY())},this);
		this.grid.on('afteredit',this.updateSort,this);
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
			items:[
			       {xtype:'panel',title:'分组设置',contentEl:'system-action',collapsible:true,style:'margin-bottom:5px'},
			       {xtype:'panel',title:'模块设置',contentEl:'modules-action',collapsible:true,style:'margin-bottom:5px'}
			]
		});
	    new Ext.Viewport({layout:'border',items:[actionPanel,this.grid]});
		this.D.baseParams={group:this.gp};
        this.D.load();
		
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
		this.soField.on('specialkey',function(t,e){if(e.getKey()==13)this.soOnTrigger2Click()},this);
	},
	
	active:function(o,moduleid){
		var group = o.innerHTML;
		if(this.D.baseParams.group == group && this.D.baseParams.key==''){return ;}
		this.gp = group;
		this.ismodule = moduleid && true;
		this.moduleid = moduleid;
		this.grid.setTitle(group);
		this.D.baseParams = {group:group, moduleid:moduleid, key:''}
		this.D.reload();
		this.soField.reset();
	},
	
	soOnTrigger1Click:function(){if(this.soField.getValue().trim()==''&&this.D.baseParams.key==''){return}this.soField.reset();this.grid.setTitle(this.gp);this.D.baseParams.group=this.gp;this.D.baseParams.key='';this.D.reload();},
	soOnTrigger2Click:function(){var key=this.soField.getValue('').trim();if(key != ''){this.grid.setTitle('搜索系统变量');this.D.baseParams={group:'',moduleid:'',key:key};this.D.reload();}},	
	
	edit:function(item){
		var title;
		if(item.mode==1){
			this.record = this.grid.getSelectionModel().getSelected();
			if(this.record){title ='修改 '+ this.record.get('name');}else{alert('请选择要编辑的变量');return ;}
		}else{title='新建变量';}
		if(!this.editor){
				this.group = new Ext.form.ComboBox({fieldLabel:'变量分组',hiddenName:'group',value:'站点设置',
					editable:false,mode:'local',triggerAction:'all',selectOnFocus:true,store:this.store});
				
				this.formPanel = new Ext.form.FormPanel({labelWidth:70,autoScroll:false,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
					this.group,
					{fieldLabel:'变量名',name:'name',allowBlank:false,blankText:'变量名不能为空'},
					{fieldLabel:'变量类型',xtype:'radiogroup',items:[
						{boxLabel:'布尔型',name:'type',inputValue:1},
						{boxLabel:'数字',name:'type',inputValue:2},
						{boxLabel:'文本',name:'type',inputValue:3,checked:true},
						{boxLabel:'多行文本',name:'type',inputValue:4}
					]},
					{fieldLabel:'变量值',xtype:'radiogroup',items:[
						{boxLabel:'是',name:'value',inputValue:1,checked:true},
						{boxLabel:'否',name:'value',inputValue:0}
					]},
					{fieldLabel:'变量值',name:'value1',xtype:'numberfield'},
					{fieldLabel:'变量值',name:'value2'},
					{fieldLabel:'变量值',name:'value3',xtype:'textarea'},
					{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
					{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'},
					{name:'moduleid',xtype:'hidden'}
				]});
				
	            this.editor=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:330,closeAction:'hide',plain: true,
	                items:this.formPanel,
	                buttons:[{text:'确定',handler:this.save,scope:this},{text:'取消',handler:function(){this.editor.hide()},scope:this}]
	            });
	            this.formPanel.form.on('actioncomplete',function(form,action){
	                if(action.result.success){
	                	this.editor.hide();
	                	if(!this.ismodule){
	                		this.D.baseParams = {group:this.group.getValue(), moduleid:this.moduleid, key:''}
	                		this.grid.setTitle(this.group.getValue());
	                	};
	                	this.D.reload();
	                }
	            }, this);
		}
		this.editor.setTitle(title);
		this.editor.show();
		this.formPanel.form.items.items[4].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);

		if(item.mode==1){
			var data = this.record.data;
        	this.formPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.formPanel.form.reset();
			this.group.setValue(this.ismodule ? '' : this.D.baseParams.group);
			this.formPanel.form.items.items[11].setValue(this.moduleid);
			this.setDisabled();
			this.setVisible(3);
		}
	},
	setDisabled : function(issystem){
		for(var i=2;i<5;i++){
			this.formPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	//设置显示变量类型
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=5;i<9;i++){
			this.formPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 4) == i ? '' : 'none';
		}
	},
	setValue:function(type, value){
		for(var i=5;i<9;i++){
			this.formPanel.form.items.items[i].setValue((type + 4) == i ? value : '');
		}
	},
	//保存系统变量
	save:function(item){
		if(!this.formPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		var act = this.formPanel.form.items.items[0].getValue() == '' ? '&method=insert' : '&method=update';
		var params = this.formPanel.form.items.items[1].getValue() == '1' ? {group:this.group.getValue(), name:this.formPanel.form.items.items[3].value, type:this.formPanel.form.items.items[4].getValue()} : null;
		this.formPanel.form.submit({url:this.baseAction+act,params:params});
	},
	//删除系统变量
	del:function(){
        var records = this.grid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的变量');
			return ;
		}
        if(flag){alert('系统变量不允许删除！');return;}
       if(confirm('您确实要删除选定的记录吗？')){
			Ext.Ajax.request({
				url:this.baseAction + '&method=delete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.D.reload();}
				}
			});
        }
	},
	updateSort : function(){
		var records = this.D.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({url:this.baseAction+'&method=updateSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){alert("保存排序出错，请重试");},
				success:function(r,o){
					r=jsonReturn(r);
					if (r.success) {
						this.D.commitChanges();
					}
				}
			});
		}
	},
	//更新缓存
	update:function(){
        Ext.Ajax.request({url: this.baseAction + '&method=cache',scope:this,success:function(r,o){r=jsonReturn(r);if(r.success){EXCMS.msg('提示',r.message)}}});
	},
	
	renderType:function(v){var d=['布尔型','数字','文本','多行文本'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red>是</font>':'<font color=green>否</font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'>是</font>":"<font color='red'>否</font>"):Ext.util.Format.htmlEncode(v)}
};
EXCMS.onReady(EXCMS.System.init,EXCMS.System);