EXCMS.System.PPTBrowser = {
	baseAction:'index.php?M=System&A=publishingpoint',
	viewmode : {view:true},//view:视图模式,true缩略图, false详细信息
	load:function(item){
		this.selectType = item.selectType;
		this.pptselect = item.pptselect !== false;
		this.callback = item.callback;
		if(!this.win){
			this.init();
		}else{
			this.win.center();
			this.win.show();
		}
		this.setSelectionModel(item.single);
		this.fullpath = item.fullpath || false;
	},
	init:function(){
		this.tree = new Ext.tree.TreePanel({
        	region:'west',collapsible:false,split:false,width:120,bodyStyle:'background:#FCFCFC;padding:4px;',style:'border-right:1px solid #D6E5F5;',cls:'channel-tree ppt-tree one-tree',
        	autoScroll:true,rootVisible:false,animate:false,useArrows:true,border:false,
            root:new Ext.tree.AsyncTreeNode({id:'',text:'',expanded:true})
        });
		this.tree.on('click',function(n){
			this.node = n;
			this.removeAddsItems(1);
			this.loadData({name:n.text, nid:n.id, dir:''});
			this.setNodeToolbar(true, false);
		},this);
		var tthis = this;
		this.local = new Ext.form.TextField({ctCls:'local',editable:false,width:376,listeners:{scope:this,render:this.renderAddsbar}});

		this.searchbar = new Ext.Toolbar({cls:'address',style:'background:#C6D6E8',items:[
			{ctCls:'back',disabled:true,title:'后退',handler:this.back,scope:this},
			{ctCls:'forward',disabled:true,title:'前进',handler:this.forward,scope:this},
			this.local,
			{ctCls:'refresh',tooltip:'刷新',handler:this.refresh,scope:this},
			{iconCls:'btnico btn_up1',disabled:true,style:'padding-left:3px',handler:this.upDirectory,scope:this,tooltip:'向上'}
		]});
		this.toolbar = new Ext.Toolbar({items:[
			{text:'新建文件夹',iconCls:'ico_newfolder',disabled:true,handler:this.newfolder,scope:this,mode:0},
			{text:'新建文件',iconCls:'ico_newfile',disabled:true,handler:this.newfolder,scope:this,mode:1},'-',
			{text:'重命名',disabled:true,handler:this.rename,scope:this},
			{text:'删除',disabled:true,handler:this.del,scope:this},
			{text:'选择',disabled:true,menu:{items:[
				 {text:'全选',handler:this.select,scope:this,mode:1},
				 {text:'反选',handler:this.select,scope:this,mode:2},
				 {text:'取消选择',handler:this.select,scope:this,mode:3}
			]}},'->',
			{text:'缩略图',iconCls:'ico_detail',menu:{items:[
				{text:'缩略图',group:'view',checked:true,handler:this.setView,scope:this,mode:1},
				{text:'详细信息',group:'view',checked:false,handler:this.setView,scope:this}
			]}},
			{ctCls:'preview',enableToggle:true,pressed:false,tooltip:'显示预览',toggleHandler:this.preview,scope:this}
   		]});
		this.D = new Ext.data.Store({remoteSort:false,
			proxy :new Ext.data.HttpProxy({url:this.baseAction+'&method=getFileList'}),
			reader:new Ext.data.JsonReader({root:'data',fields:['name','leaf','url','size','filetype','create','cssname','cls','lastmod']}),
			listeners:{
				scope:this,
				beforeload:function(s,o){
					this.D.baseParams = {
						//keywords : this.keywords,
						selectType: this.selectType == 'FILE' ? 'ALL' : this.selectType
					};
					if(this.history){
						this.D.baseParams.nid = this.history.current.nid;
						this.D.baseParams.dir = this.history.current.dir;
					}
					this.mask('数据读取中…');
				},
				load:function(d,r,o){
					this.unmask();
					this.formatData();
				},
				loadexception:function(t,o,r,e){alert(r);this.unmask()}
			}
		});
		this.contextmenu = new Ext.menu.Menu({items:[
			{text:'选定',handler:this.onDblClick,scope:this},
			{text:'新建文件夹',iconCls:'ico_newfolder',handler:this.newfolder,scope:this,mode:0},
			{text:'新建文件',iconCls:'ico_newfolder',handler:this.newfolder,scope:this,mode:1},
			{text:'重命名',handler:this.rename,scope:this},
			{text:'删除',handler:this.del,scope:this},'-',
			{text:'刷新',handler:function(){this.D.reload();},scope:this}
		]});
		var tpl = new Ext.XTemplate(
			'<tpl for=".">',
				'<div class="rv-wrap rv-file-1" id="">',
				'<tpl if="leaf==true"><div class="rv-wrap-ct folder" title="{name} &#10;创建日期：{create} "><span title="{name}">{name}</span></div></tpl>',
				'<tpl if="leaf==false"><div class="rv-wrap-ct ppt-file" title="{name} &#10;类型：{filetype} &#10;创建日期：{create} &#10;大小：{size}"><span title="{name}">{name}</span></div></tpl>',
				'</div>',
			'</tpl>',
			'<div class="x-clear"></div>'
		);
		tpl.compile();
		this.DV = new Ext.DataView({
			tpl:tpl,
			multiSelect:true,
			cls:'rs-view ppt-view',
			overClass:'x-view-over',
			itemSelector:'div.rv-wrap',
			autoHeight:true,
			autoWidth:true,
			emptyText :'<div style="padding:40px 0 0;text-align:center">没有文件或文件夹</div>',
			store:this.D,
			plugins:[new Ext.DataView.DragSelector()],
			listeners:{
				'selectionchange':{fn:function(){this.setNodeToolbar(true,true);this.showAttributes()},scope:this,buffer:0},
				'dblclick':{fn:this.onDblClick,scope:this},
				'contextmenu':{fn:function(o,i,n,e){
					if(!o.isSelected(i))o.select(i);
					this.selectedRecord = i;
					this.showContextMenu(e);
				},scope:this},
				'beforeselect':{fn:function(view){return view.store.getRange().length>0},scope:this}
			}
		});
		this.viewPanel = new Ext.Panel({cls:'img-chooser-view',region:'center',layout:'card',activeItem:0,border:false,bodyStyle:'background:#FCFCFC',items:this.DV,autoScroll:true});
		this.previewPanel = new Ext.Panel({region:'east',width:160,border:false,split:true,cls:'details',bodyStyle:'background:#FCFCFC',maxSize:300,minSize:35,autoScroll:true,hidden:true});
		this.mainPanel = new Ext.Panel({layout:'border',border:true,items:[this.tree,this.viewPanel,this.previewPanel],tbar:this.toolbar});
		this.win = new Ext.Window({title:'站点浏览',cls:'rsb-win',layout:'fit',width:550,height:424,minWidth:550,minHeight:424,
			modal:true,closeAction:'hide',border:true,
			items:this.mainPanel,
			buttons:[{text:'确定',handler:function(){this.doCallback()},scope:this},{text:'取消',handler:function(){this.win.hide()},scope:this}],
			keys:{key:27,handler:function(){this.win.hide()},scope:this},
			tbar:this.searchbar
		});
		this.win.on('resize',function(e,w){this.local.adds.style.width=w-128+'px'},this);
		this.win.show();
        this.toolbar.items.items[7].setIconClass('ico_thumb');
        this.mainPanel.getEl().dom.oncontextmenu = function(){return false};
        this.D.load();
		this.tree.body.dom.menu = new Ext.menu.Menu({items:[{text:'刷新发布点',handler:this.refreshPPT,scope:this}]});
		this.tree.body.dom.oncontextmenu = function(e){
			e = window.event || e;
			this.menu.showAt([e.clientX, e.clientY]);
			return false;
		}
	},
	refreshPPT:function(){
		this.tree.body.mask('加载发布点…');
		Ext.Ajax.request({
			url: this.baseAction+'&method=getppt',scope:this,
			success:function(r,o){this.tree.body.unmask();
				r=jsonReturn(r);
				if(r.success){
					var nid = this.node ? this.node.id : false;
					this.renderNode(r.ppts);
					if(nid !== false) this.tree.getNodeById(nid).select();
					if(this.local.adds.firstChild.lastChild.menu){
						this.local.adds.firstChild.lastChild.menu.destroy();
						this.local.adds.firstChild.lastChild.menu = null;
					}
				}
			},
			failure:function(r,o){this.tree.body.unmask();alert(r)}
		},this);
	},
	renderNode:function(ppts){
		while(this.tree.root.lastChild) this.tree.root.removeChild(this.tree.root.lastChild);
		this.tree.root.appendChild(ppts);
		this.ppts = new Array;
		for(i=0,len=ppts.length;i<len;i++){
			this.ppts.push({icon:ico,iconCls:'ico_ppt', id:ppts[i].id, text:ppts[i].text, dir:ppts[i].dir, ppt:true, handler:this.loadTpl, scope:this});
		}
	},
	// render grid
	renderGrid : function(){
		this.G= new Ext.grid.GridPanel({region:'center',enableColumnMove:false,collapsible:false,animCollapse:false,
			minColumnWidth:2,border:false,border:false,sm:new Ext.grid.RowSelectionModel(),loadMask:{msg:'数据加载中…'},
			store:this.D,columns:[
				{header:'文件名',width:180,sortable:true,dataIndex:'name',scope:this},
				{header:'创建日期',width:120,sortable:true,dataIndex:'create',scope:this},
				{header:'类型',width:80,sortable:true,dataIndex:'filetype',scope:this},
				{header:'大小',width:60,align:'right',sortable:true,dataIndex:'size',scope:this},
				{header:'文件夹路径',width:100, hidden: true,sortable:false,dataIndex:'path',scope:this},
		]});
		this.G.on('rowclick',function(g,r,e){this.selectedRecord = r;this.setNodeToolbar(true,true);this.showAttributes()},this);
		this.G.on('rowdblclick',function(g,r,e){this.onDblClick()},this);
		this.G.on('rowcontextmenu',function(g,r,e){g.getSelectionModel().selectRow(r);this.showContextMenu(e)},this);
		this.viewPanel.add(this.G);
		this.DV.hide();
		this.viewPanel.doLayout();
		this.G.show();
		this.toolbar.items.items[11].setIconClass('ico_detail');
		this.toolbar.items.items[11].setText('详细信息');
	},
	refresh:function(){
		this.removeAddsItems(-1);
		this.D.reload();
	},
	upDirectory : function(){
		this.removeAddsItems(-2);
		var dir = this.history.current.dir;
		var index = dir.lastIndexOf('/');
		dir = dir.substring(0, index);
		var name;
		if(this.local.adds.childNodes.length == 3){
			name = this.node.text;
		}else{
			index = dir.lastIndexOf('/');
			if(index >= 0) name = dir.substring(index + 1);
			else name = dir;
		}
		this.loadData({nid:this.node.id, name:name, dir:dir});
	},
	// load data
	loadData : function(item){
		//if(this.history && this.history.current.nid == item.nid && this.history.current.dir == item.dir) return ;
		this.setHistory(item);
		this.D.load();
	},
	// format data
   	formatData :function(data){
		var i, len, r;
		if(this.D.reader.jsonData.ppts){
			this.renderNode(this.D.reader.jsonData.ppts);
			var f;
			if(this.D.reader.jsonData.root){
				var n = this.tree.getNodeById(this.D.reader.jsonData.root);
				if(n){
					n.select();
					this.node = n;
					this.setHistory({nid:n.id, name:n.text, dir:''});
					f = true;
				}
			}
			if(!f) this.setHistory({nid:'', name:'网站主目录', dir:''});
		}
		var items = new Array;
		for(i=0,len=this.D.getCount();i<len;i++){
			r = this.D.getAt(i);
			r.set('size',formatSizes(r.data.size));
			if(r.data.leaf) items.push({icon:'Themes/ico/filetype/folder.gif',text:r.data.name,dir:r.data.url,handler:this.loadTpl,scope:this});
		}
		this.renderAddsItem(this.history.current.name, this.history.current.dir, items.length ? '' : 'last', items);
		this.D.commitChanges();
	},
	setHistory:function(item){
		this.historyChange = true;
		if(this.history){
			if(this.history.current.nid == item.nid && this.history.current.dir == item.dir) return;
			this.history.back.push(this.history.current);
			this.history.current = item;
			this.history.forward = [];
			this.setHistoryTitle();
		}else{
			this.history = {back:[], forward:[], current:item, total:15};
		}
	},
	// forward
	forward : function(){this.historyExecute('forward')},
	// back
	back : function(){this.historyExecute('back')},
	// back forward excued
	historyExecute:function(bof){
		var a,b,c;
		if(bof == 'back'){a = 'forward';b = 0;c = 1;}else{a = 'back';b = 1;c = 0;}
		this.history[a].push(this.history.current);
		this.history.current = this.history[bof].pop();
		var node;
		if(this.history.current.nid) node = this.tree.getNodeById(this.history.current.nid);
		if (node) {
			node.select();
			this.node = node;
		}else if(this.node){
			this.node.unselect();
			this.node = null;
		} 
		this.setHistoryTitle();
		if(this.history.current.dir){
			this.removeAddsItems(this.history.current.dir.split('/').length);
			this.D.load();
		}
	},
	// set histor toolbar
	setHistoryTitle:function(i,t){
		var items = this.searchbar.items.items;
		var a = this.history && this.history.back.length;
		var b = this.history && this.history.forward.length;
		items[0].setDisabled(!a);
		items[1].setDisabled(!b);
		items[0].el.dom.title = a ? '后退到 ' + this.history.back[a - 1].name : '';
		items[1].el.dom.title = b ? '前进到 ' + this.history.forward[b - 1].name : '';
	},
	// set selection model
	setSelectionModel : function(s){
		this.single = s||false;
		this.record = null;
		if(this.viewmode.view){
			this.DV.multiSelect = !s;
			this.DV.singleSelect = s;
			this.DV.clearSelections();
		}else{
			if(!this.G) this.renderGrid();
			this.G.getSelectionModel().singleSelect = s;
			this.G.getSelectionModel().clearSelections();
		}
	},
	showContextMenu : function(e){
		var record = this.getSelectRecords()[0].data;
		this.contextmenu.showAt(e.getXY());
		var text = '';
		if(record.leaf)text = '打开';else	text = '选中';
		this.contextmenu.items.items[0].setText(text);
	},
	//set view mode
	setView:function(item){
		this.setNodeToolbar(true,false);
		if(item) this.viewmode.view = item.mode ? true : false;
		var f = this.viewmode.view;
		if (!(f || this.G)) {
			this.renderGrid();
		}
		this.setSelectionModel(this.single);
		this.viewPanel.layout.setActiveItem(f ? this.DV : this.G);
		this.toolbar.items.items[11].setIconClass(f ? 'ico_thumb' : 'ico_detail');
		this.toolbar.items.items[11].setText(f ? '缩略图' : '详细信息');
		this.toolbar.items.items[11].menu.items.items[f ? 0 : 1].setChecked(true);
	},
	// set bar
	setNodeToolbar : function(n,f){
		var r = this.getSelectRecords();
		if(n){
			this.toolbar.items.items[0].enable();
			this.toolbar.items.items[1].enable();
			this.toolbar.items.items[5].enable();
			this.toolbar.items.items[7].enable();
			//this.toolbar.items.items[9].enable();
		}else{
			this.toolbar.items.items[0].disable();
			this.toolbar.items.items[1].disable();
			this.toolbar.items.items[5].disable();
			this.toolbar.items.items[7].disable();
			//this.toolbar.items.items[9].disable();
		}
		if(f && r.length > 0){
			this.toolbar.items.items[3].enable();
			this.toolbar.items.items[4].enable();
		}else{
			this.toolbar.items.items[3].disable();
			this.toolbar.items.items[4].disable();
		}
	},
	// get select records
	getSelectRecords : function(){return this.viewmode.view?this.DV.getSelectedRecords():this.G.getSelectionModel().getSelections()},
	mask : function(message){this.viewPanel.el.mask(message)},
	unmask : function(){this.viewPanel.el.unmask()},
	// 双击行列表
	onDblClick : function(){
		var record = this.getSelectRecords();
		if(!record) return ;
		if(record[0].data.leaf) {
			this.willLength = 0;
			this.loadData({nid:this.node.id,name:record[0].data.name, dir:record[0].data.url});
		}else{
			this.doCallback();
		}
	},
	// 显示详细信息
	showAttributes : function(){
		var data = this.getSelectRecords();
        if(!data || data.length < 1) return ;
        data = data[0].data;
		if(this.attributesTemplate && this.attributesTemplate.dataid && this.attributesTemplate.dataid == data.id) return ;
		if(data.isfolder == 1){
			if(!this.folderTemplate){
				this.folderTemplate = new Ext.XTemplate(
					'<tpl for=".">',
						'<div class="rv-wrap"><div class="rv-wrap-ct {cls}"></div></div>',
						'<div class="details-info">',
						'<div>{name}</div>',
						'<div><em>文件夹</em></div>',
						'<div><em>包含:</em>{files} 个文件，{folders} 个文件夹</div>',
						'<div><em>创建时间:</em>{create}</div></div>',
					'</tpl>'
				);
				this.folderTemplate.compile();
			}
			this.attributesTemplate = this.folderTemplate;
		}else{
			if(!this.filesTemplate){
				this.filesTemplate = new Ext.XTemplate(
					'<tpl for=".">',
						'<div class="rv-wrap"><div class="rv-wrap-ct {cls}"><div class="thumb"><div><p><strong>图片加载中...</strong><img src="{src}" onload="imageOnLoad(this)" onerror="imageOnError(this)" style="display:none"></p></div></div></div></div>',
						'<div class="details-info">',
						'<div>{name}</div>',
						'<div><em>{filetype}</em></div>',
						'<div><em>大小:</em>{size}</div>',
						'<div><em>创建日期:</em>{create}</div>',
					'</tpl>'
				);
				this.filesTemplate.compile();
			}
			this.attributesTemplate = this.filesTemplate;
		}
		this.attributesTemplate.dataid = data.id;
        this.attributesTemplate.overwrite(this.previewPanel.body, data);
	},
	// create new folder
	newfolder : function(item){
		var title = '新建文件夹';
		var content = '请输入文件夹名称';
		var message = '不是合法文件夹名称';
		var mask = '正在创建文件夹，请稍后...';
		var url = this.baseAction+'&method=createFolder';
		if(item.mode){
			title = '新建文件';
			content = '请输入文件名称';
			message = '不是合法文件名称'
			mask = '正在创建文件，请稍后...';
			url = this.baseAction+'&method=createFile';
		}
	    Ext.MessageBox.prompt(title, content+'：', function(btn,txt){
	    	if(btn=='ok'){
                if(txt == '') {alert(content);return this.newfolder(item);}
	    		var reg= new RegExp(/^[\._\-0-9a-zA-Z]+$/);
	    		if(!reg.test(txt)){
	    			alert(message);
	    			return this.newfolder(item);
	    		}
                this.mask(mask);
		        Ext.Ajax.request({
		        	url: url,
		        	method: 'POST',
		        	params:{filename:txt,dir:this.history.current.dir,nid:this.node.id},
	                success:function(r,o){
                        this.unmask();
	                    r = jsonReturn(r);
						if(r.success){
							this.D.add(new Ext.data.Record({name:txt,cssname:'<span class="filetype-folder">'+txt+'</span>',filetype:'文件夹',lastmod:r.date,create:r.date,url:this.history.current.dir+txt,leaf:!item.mode}));
						}else{
							alert(r.message);
						}
						//this.D.load();
	                },
	                scope:this
	            },this);
		    }
	    },this);
	},
	// delete resource
	del : function(){
		var records = this.getSelectRecords();
		if(records.length > 0){
			if(!confirm("确定要删除所选的文件吗?\n警告：删除文件的同时将文件夹内容全部删除!")) return;
			var data = [];
			for(var i=0,len=records.length;i<len;i++){
				data.push({url:records[i].data.url,leaf:records[i].data.leaf});
			}
			this.mask('正在删除文件，请稍后...');
			Ext.Ajax.request({
				url: this.baseAction+'&method=deletefile',method: 'POST',params:{files:Ext.util.JSON.encode(data)},scope:this,
				success:function(r,o){this.unmask();r=jsonReturn(r);if(r.success){for(var i=0;i<records.length;i++)this.D.remove(records[i]);}else{alert(r.message)}},
				failure:function(r,o){this.unmask();alert(r)}
			},this);
		}else{
			alert('请选择被删除的文件');
		}
	},
	// rename resource
	rename : function(item){
		var record = this.getSelectRecords();
		if(record.length < 1){
			alert('请选择一个的文件');
			return ;			
		}
		record = record[0];
		Ext.MessageBox.prompt('重命名文件', '请输入新文件名称：' ,function(btn,txt){if(btn=='ok'){
			txt = txt.trim();
			if(txt == '') return ;
			var reg= new RegExp(/^[\._\-0-9a-zA-Z]+$/);
    		if(!reg.test(txt)){
				alert('非法的文件名，文件名只能由数字、字母、下划线、点组成');
				return this.rename();
			}
			if(txt == record.data.name) return ;
			this.mask('正在重命名文件，请稍后...');
			Ext.Ajax.request({
				url: this.baseAction+'&method=rename',
				method: 'POST',
				params:{nid:this.node.id, dir:this.history.current.dir, filename:record.data.name, newfilename:txt},
				scope:this,
				success:function(r,o){
					this.unmask();
					r = jsonReturn(r);
					if(r.success){
						record.set('name', txt);
					}else{
						alert(r.message);
					}
				},
				failure:function(r,o){this.unmask();alert(r)}
			},this);
		}}, this, false, record.data.name);
	},
 	// preview
 	preview:function(e,p){
		this.previewPanel.setVisible(p);
		if(p) this.showAttributes();
		this.mainPanel.ownerCt.doLayout();
	},
	// select record
	select : function(item){
		var mode = item && item.mode ? item.mode :1;
		var len = this.D.getCount();
		if(!len) return ;
		if(this.viewmode.view){
			var dv = this.DV;
			switch(mode){
				case 1 : for(var i=0;i<len;i++) dv.select(i,true); break;
				case 2 : for(var i=0;i<len;i++) dv.isSelected(i) ? dv.deselect(i) : dv.select(i,true);break;
				case 3 : dv.clearSelections();break;
			}
		}else{
			var sm = this.G.getSelectionModel();
			switch(mode){
				case 1 : sm.selectAll();break;
				case 2 : for(var i=0;i<len;i++) sm.isSelected(i) ? sm.deselectRow(i) : sm.selectRow(i,true);break;
				case 3 : sm.clearSelections();break;
			}
		}
	},
	// call back
	doCallback :function(){
		var record = this.getSelectRecords();
		var data = new Array;
		var path = '';
		if(this.pptselect){
			path = this.node ? '{PPT:' + this.node.text + '}/' : './';
		}else if(this.node){
			path = this.node.attributes['path'] ? this.node.attributes['path'] + '/' : './';
		}
		if(record && record.length > 0){
			if(!this.callback){alert('缺少回调方法');return;}
			if(this.fullpath){
				path += record[0].data.url;
				path = path.replace('//','/');
				this.callback(path);
			}else{
				for(var i=0,len=record.length;i<len;i++){
					if(!record[i].data.path) {record[i].data.path = path + record[i].data.url;path = path.replace('//','/');}
					if(this.selectType == 'FILE'){
						if(record[i].data.leaf){
							data.push(record[i].data);
						}else if(this.single){
							this.onDblClick();
							return ;
						}else{
							alert('文件选择错误：只能选择文件');
							return ;
						}
					}else if(this.selectType == 'ALL' || this.selectType == 'FOLDER'){
						data.push(record[i].data);
					}
				}
				this.callback(this.single ? data[0] : data);
			}
		}else if(this.fullpath){
			if(this.selectType == 'FILE'){
				alert('请先选中您要选择的文件');
				return;
			}else{
				path += this.history ? this.history.current.dir : '';
			}
			path = path.replace('//','/');
			if(path.substring(path.length - 1, path.length) == '/') path = path.substring(0, path.length - 1);
			if(!path) path = './';
			this.callback(path);
		}else{
			alert('请先选中您要选择的文件');
			return ;
		}
		this.win.hide();
    },
	// local navigator
	renderAddsbar:function(c){
		var p = c.el.dom.parentNode;
		c.adds = document.createElement('div');
		c.adds.className = 'adds-list';
		p.insertBefore(c.adds, c.el.dom);
		c.el.dom.style.display = 'none';
		this.renderAddsItem('','','first');
	},
	renderAddsItem:function(txt,dir,p,items){
		var a = document.createElement('a');
		a.href = 'javascript:;';
		a.item = {name:txt, dir:dir};
		var em = document.createElement('em');
		a.em = em;
		var b = document.createElement('b');
		a.b = b;
		em.a = a, em.b = b;
		a.appendChild(em);
		if(items && items.length) b.items = items;
		if(p == 'first'){
			a.className = 'first ico_ppt';
			em.onmouseover=function(){
				if(EXCMS.System.PPTBrowser.isMenuDown) EXCMS.System.PPTBrowser.showMenu(this.b);
			}
			b.onmouseover=function(){
				setCls(this.parentNode,'bover');
				if(EXCMS.System.PPTBrowser.isMenuDown) EXCMS.System.PPTBrowser.showMenu(this,1);
			}
			b.onmouseout=function(){setCls(this.parentNode,'bover',1)}
			b.onmousedown=function(){EXCMS.System.PPTBrowser.showMenu(this,1)}
		}else if(p == 'last'){
			a.className = 'last';
			em.innerHTML = txt;
			em.onmouseover=function(){
				setCls(this.a, EXCMS.System.PPTBrowser.isMenuDown ? 'lclick' : 'hover');
				if (EXCMS.System.PPTBrowser.isMenuDown && EXCMS.System.PPTBrowser.currentMenu) {
					EXCMS.System.PPTBrowser.currentMenu.hide();
					EXCMS.System.PPTBrowser.isMenuDown = true;
				}
			}
			em.onmouseout=function(){
				setCls(this.a,'hover',1);setCls(this.a,'bover',1);setCls(this.a,'lclick',1);
				EXCMS.System.PPTBrowser.menuTimer = window.setTimeout(function(){EXCMS.System.PPTBrowser.isMenuDown = false;}, 200);
			}
			em.onselectstart=function(){return false}
			em.onmousedown=function(){setCls(this.a,'lclick')}
			em.onmouseup=function(){setCls(this.a,'lclick',1)}
			em.onclick=function(){EXCMS.System.PPTBrowser.refresh()}
		}else{
			em.innerHTML = txt;
			em.onmouseover=function(){
				setCls(this.a,'hover');
				if(EXCMS.System.PPTBrowser.isMenuDown) EXCMS.System.PPTBrowser.showMenu(this.b);
			}
			em.onmouseout=function(){setCls(this.a,'hover',1);setCls(this.a,'bover',1);setCls(this.a,'aclick',1);}
			em.onselectstart=function(){return false}
			em.onmousedown=function(){setCls(this.a,'aclick')}
			em.onmouseup=function(){
				setCls(this.a,'aclick',1);
				EXCMS.System.PPTBrowser.removeAddsItems(this.a.item.dir.split('/').length);
				var item = this.a.item;
				item.nid = EXCMS.System.PPTBrowser.node.id;
				EXCMS.System.PPTBrowser.loadData(item);
			}
			b.onmouseover=function(){setCls(this.parentNode,'bover')}
			b.onmouseout=function(){setCls(this.parentNode,'bover',1)}
			b.onmousedown=function(){EXCMS.System.PPTBrowser.showMenu(this)}
		}
		this.removeAddsItems(10000, true);
		a.appendChild(b);
		this.local.adds.appendChild(a);
		if(this.searchbar.items.items[4]) this.searchbar.items.items[4].setDisabled(this.local.adds.childNodes.length < 3);
		return a;
	},
	willLength:0,
	removeAddsItems:function(length, f){
		if(length == 10000 && this.willLength == 0) return ;
		if(!f){
			this.willLength = length;
			return;
		}
		length = this.willLength;
		if(length == 0) return ;
		this.willLength = 0;
		var n;
		if(length < 0) length = this.local.adds.childNodes.length + length;
		while (this.local.adds.childNodes.length > length) {
			n = this.local.adds.lastChild;
			if(n.menu) n.menu.destroy();
			this.local.adds.removeChild(n);
		}
	},
	loadTpl:function(item){
		if(item.ppt){
			this.removeAddsItems(1);
			this.node = this.tree.getNodeById(item.id);
			this.node.select();
			this.history = null;
			this.setHistoryTitle();
			this.loadData({name:item.text, nid:item.id, dir:item.dir});
		}else{
			this.removeAddsItems(item.dir.split('/').length + 1);
			this.loadData({name:item.text, nid:this.node.id, dir:item.dir});
		}
	},
	showMenu:function(el, f){
		if(!el.menu){
			el.menu = new Ext.menu.Menu({items:f?this.ppts:el.items, maxHeight:220,listeners:{
				scope:this,
				show:function(m){
					setCls(m.showEl.dom.parentNode, 'bclick');
					this.isMenuDown = true;
					if(this.menuTimer) window.clearTimeout(this.menuTimer);
				},
				hide:function(m){this.isMenuDown=false;this.currentMenu=null;setCls(m.showEl.dom.parentNode, 'bclick', 1)}
			}});
			el.menu.showEl = Ext.get(el);
		}
		if(this.currentMenu) this.currentMenu.hide();
		this.currentMenu = el.menu;
		el.menu.showAt([el.menu.showEl.getX() - 16, el.menu.showEl.getY() + 21]);
	}
};