EXCMS.Block = {
	baseAction : 'index.php?M=block&A=Index',
	textNewEdit:['新建','编辑'],
	init:function(){
		Ext.QuickTips.init();
		this.newItems = [
			{text:'新建分类',handler:this.cateEdit,scope:this},
			{text:'新建页面',handler:this.cateEdit,scope:this,page:1},
			{text:'新建碎片',handler:this.blockEdit,scope:this}
		];
        this.tree = new Ext.tree.TreePanel({
			region:'west',title:'碎片分类',cls:'channel-tree block-tree',collapsible:false,split:true,width:200,minSize:35,autoScroll:true,collapseMode:'mini',collapsible:true,
			useArrows:true,lines:false,bodyStyle:'padding:6px',
			border:false,style:'border-right:1px solid #99BBE8;',
			loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),
			rootVisible:false,root:new Ext.tree.AsyncTreeNode({id:'0',expanded:true}),
			tbar:[
				{text:'新建',menu:{items:this.newItems},acl:'add'},
				{text:'修改',handler:this.cateEdit,scope:this,mode:3,acl:'edit'},
				{text:'删除',handler:this.cateDel,scope:this,mode:3,acl:'delete'}
			]
		});
		this.cateItems = [
			{text:'<b>查看</b>',handler:this.viewCate,scope:this},
			{text:'浏览',handler:this.browsePage,scope:this},
			{text:'生成',handler:this.publishCategory,scope:this,mode:0,acl:'publishcategory'},'-',
			{text:'新建',menu:{items:this.newItems},acl:'add'},
			{text:'修改',handler:this.cateEdit,scope:this,mode:1,acl:'edit'},
			{text:'删除',handler:this.cateDel,scope:this,acl:'delete'},'-',
			{text:'碎片列表',handler:this.renderBlockGrid,scope:this}
			//{text:'权限',handler:this.cateEdit,scope:this},
		];
		this.cmenu = new Ext.menu.Menu({items:this.cateItems,listeners:{
			'hide':{fn:function(){
				if(this.isTreeContext){
					if(this.cnode) this.cnode.unselect();
					if(this.node) this.node.select();
				}
				this.isTreeContext = false;
			},scope:this},
			'beforeshow':{fn:function(m){
				var t = this.isTreeContext ? this.cnode.attributes.type : this.record.data.type;
				m.items.items[1].setDisabled(t != 'page');
			},scope:this}
		}});
		this.tree.root.on('expand',function(n){this.groupStore = [];cn = n.childNodes;for(var i=0;i<cn.length;i++){this.groupStore.push([cn[i].id,cn[i].text]);}},this);
        this.tree.on('click',function(n,e){
        	this.node = n;
			var fp = this.tabPanel.getActiveTab();
			if(!fp.panelType){//n.attributes['cls'] == 'block-tree-page' && 
				//fp = this.tabPanel.getComponent('block-category' + n.id);
				//fp ? this.tabPanel.activate(fp) : this.viewCate({id:n.id, title:n.text, viewcate:true});
				this.viewCate({id:n.id, title:n.text, viewcate:true});
				return ; 
			}
			if(!fp.panelType) fp = this.renderBlockGrid(true);
			if(fp.cnode == n) return ;
			this.tabPanel.activate(fp);
			fp.setTitle(n.text + (fp.panelType == 'cate' ? '下属分类' : '碎片'));
			if(fp.panelType == 'cate') fp.topToolbar.items.items[9].show();
			fp.cnode = n;
			fp.store.baseParams = {categoryid:n.id,key:''};
			fp.store.reload();
        },this);       
        this.tree.on('contextmenu',function(n,e){
			this.isTreeContext = true;
            n.select();
			this.cnode = n;
            this.cmenu.showAt(e.getXY());
			  
        },this);
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border-left:1px solid #99BBE8;',activeTab:0,enableTabScroll:true,items:{title:'碎片使用向导',border:false,autoScroll:true,contentEl:'block-items'}});
        this.tabPanel.on('beforeremove',function(t,c){if(!c.closePanel){
			t.activate(0);
			t.hideTabStripItem(c);
			return false
		}},this);
		this.viewport = new Ext.Viewport({layout:'border',items:[this.tree,this.tabPanel]});
		this.tree.getEl().dom.oncontextmenu = function(){return false;}
        this.tree.getEl().dom.onselectstart=function(){return false}
		//
		btn = this.tree.topToolbar.items.items;
		for(var i=0;i<btn.length;i++){
			if(btn[i].acl &&! excmsacl[btn[i].acl]){
				btn[i].hide();
			}
		}
		for(var i=0;i<this.cmenu.items.items.length;i++){
			if(this.cmenu.items.items[i].acl&&!excmsacl[this.cmenu.items.items[i].acl]){
				this.cmenu.items.items[i].hide();
			}
		}
	},
	viewCate:function(c){
		if(c && c.viewcate){
		}else if(c && c.mode){
			if(!this.recordblock || !this.D.getById(this.recordblock.id)){
				EXCMS.msg('提示','请选择要你查看的碎片');
				return ;
			}
			c = {id:this.recordblock.data.categoryid, title:this.recordblock.data.category, blockid:this.recordblock.id};	
		}else if(this.isTreeContext){
			c = {id:this.cnode.id, title:this.cnode.text};	
		}else{
			if(!this.record || !this.CD.getById(this.record.id)){
				EXCMS.msg('提示','请选择要你查看的分类(页面)');
				return ;
			}
			c = {id:this.record.id, title:this.record.data.name};   
		}
		this.manage(c);
	},
	renderCateGrid:function(f){
		if(!this.CG){
			this.CD = new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=categorystore'}),
				reader: new Ext.data.JsonReader({
					root:'data',totalProperty:'total',id:'categoryid',
					fields: ['categoryid','name','pid','_pid','type','_type','frequency','publisheddate','sort']
				}),
				remoteSort:false
			});
			this.soCateField = new Ext.form.TwinTriggerField({emptyText:'',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
			this.soCateField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
			var tbarItems = this.cateItems;
			tbarItems.push({text:'全部分类',hidden:true,handler:function(b){b.hide();this.CG.cnode=null;this.CD.baseParams={};this.CG.setTitle(this.CG.initialConfig.title);this.CD.load()},scope:this},'-',{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.CD.reload()},scope:this},'->','搜索 ',this.soCateField);
			tbarItems[0].text = '查看';
			this.CG = new Ext.grid.EditorGridPanel({title:'全部分类',panelType:'cate',enableColumnMove:false,collapsible:true,animCollapse:false,border:false,sm:new Ext.grid.RowSelectionModel(),
				loadMask:{msg:'数据加载中...'},autoExpandColumn:1,autoExpandMin:200,autoExpandMax:500,closable:true,
				store:this.CD,
				columns:[
					new Ext.grid.RowNumberer(),
					{header:'分类(页面)名称',width:200,sortable:true,dataIndex:'name'},
					{header:'类型',width:60,sortable:true,dataIndex:'_type'},
					{header:'父分类(页面)',width:120,sortable:true,dataIndex:'_pid'},
					{header:'更新频率',width:80,sortable:true,dataIndex:'frequency'},
					{header:'生成时间',width:150,sortable:true,dataIndex:'publisheddate'},
					{header:"排序",width:48,align:'right',sortable:true,dataIndex:'sort',editor:new Ext.form.NumberField()}
				],
				tbar:tbarItems,
				bbar:new Ext.PagingToolbar({pageSize:25,store:this.CD,displayInfo:true,displayMsg:'当前显示{0} - {1} 共{2}条',emptyMsg:'暂时没有数据',beforePageText:'第',afterPageText:'页 共{0}页'})
			});
			this.tabPanel.add(this.CG);
			this.tabPanel.activate(this.CG);
			this.CG.on('rowclick',function(g,r,e){this.record=this.CD.getAt(r)},this);
			this.CG.on('celldblclick',function(g,r,c,e){if(g.getColumnModel().getDataIndex(c)!='sort'){this.record=this.CD.getAt(r);this.cateEdit({mode:1});}},this);
			this.CG.on('rowdblclick',function(g,r,e){this.record=this.CD.getAt(r)},this);
			this.CG.on('rowcontextmenu',function(g,r,e){
				this.record=this.CD.getAt(r)
				var stm = g.getSelectionModel();
				stm.getSelections().indexOf(g.getStore().getAt(r))!= -1?stm.selectRow(r,true):stm.selectRow(r);
				 this.cmenu.showAt(e.getXY());
			},this);
			this.CG.getEl().dom.oncontextmenu = function(){return false;}
		}
		this.tabPanel.unhideTabStripItem(this.CG);
		this.tabPanel.activate(this.CG);
		if(!f){
			this.CD.baseParams = {};
			this.CD.load({params:{start:0,limit:25}});
			this.CG.cnode = null;
			this.CG.setTitle(this.CG.initialConfig.title);
			this.CG.topToolbar.items.items[9].hide();
		}
	},
	renderBlockGrid:function(f){
		if(!this.G){
			this.D = new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({url:this.baseAction+'&method=blockpaging'}),
				reader: new Ext.data.JsonReader({
					root:'data',totalProperty:'total',id:'blockid',
					fields: ['blockid','name','category','categoryid','type','frequency','publisheddate','sort']
				}),
				remoteSort:false
			});
			this.soField = new Ext.form.TwinTriggerField({emptyText:'',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
			this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
			this.G = new Ext.grid.EditorGridPanel({title:'全部碎片',panelType:'block',enableColumnMove:false,collapsible:true,animCollapse:false,border:false,sm:new Ext.grid.RowSelectionModel(),
				loadMask:{msg:'数据加载中...'},autoExpandColumn:1,autoExpandMin:200,autoExpandMax:500,closable:true,
				store:this.D,
				columns:[
					{header:'碎片ID',width:48,sortable:true,dataIndex:'blockid'},
					{header:'碎片名称',width:200,sortable:true,dataIndex:'name',renderer:this.rendererBlockName,scope:this},
					{header:'所属分类(页面)',width:150,sortable:true,dataIndex:'category'},
					{header:'更新频率',width:80,sortable:true,dataIndex:'frequency'},
					{header:'生成时间',width:150,sortable:true,dataIndex:'publisheddate'},
					{header:"排序",width:48,align:'right',sortable:true,dataIndex:'sort',editor:new Ext.form.NumberField()}
				],tbar:[
					{text:'浏览',handler:this.blockBrowse,scope:this,mode:1},
					{text:'查看',handler:this.viewCate,scope:this,mode:1},
					{text:'生成',handler:this.publishBlock,scope:this},'-',
					{text:'新建',handler:this.blockEdit,scope:this},
					{text:'修改',handler:this.blockEdit,scope:this,mode:1},
					{text:'删除',handler:this.blockDel,scope:this},
					//{text:'权限',handler:this.browse,scope:this},
					'-',
//					{text:'历史记录',handler:this.browse,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload()},scope:this},'->','搜索 ',this.soField
				],
				bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示{0} - {1} 共{2}条',emptyMsg:'暂时没有数据',beforePageText:'第',afterPageText:'页 共{0}页'})
			});
			this.tabPanel.add(this.G);
			this.tabPanel.activate(this.G);
			this.G.on('rowclick',function(g,r,e){this.recordblock=this.D.getAt(r)},this);
			this.M = new Ext.menu.Menu({items:[
				{text:'浏览',handler:this.blockBrowse,scope:this,mode:1},
				{text:'查看',handler:this.viewCate,scope:this,mode:1},
				{text:'生成',handler:this.publishBlock,scope:this},
				'-',
				{text:'新建',handler:this.blockEdit,scope:this},
				{text:'修改',handler:this.blockEdit,scope:this,mode:1},
				{text:'删除',handler:this.blockDel,scope:this}
				//{text:'权限',handler:this.browse,scope:this},
//				'-',
//				{text:'历史记录',handler:this.browse,scope:this}
			]});
			this.G.on('rowcontextmenu',function(g,r,e){
				this.recordblock = this.D.getAt(r)
				var stm = g.getSelectionModel();
				stm.getSelections().indexOf(g.getStore().getAt(r))!=-1?stm.selectRow(r,true):stm.selectRow(r);
				this.M.showAt(e.getXY());
			},this);
			this.G.on('rowclick',function(g,r,e){this.recordblock=this.D.getAt(r)},this);
			this.G.on('celldblclick',function(g,r,c,e){if(g.getColumnModel().getDataIndex(c)!='sort'){this.recordblock=this.D.getAt(r);this.blockEdit({mode:1});}},this);
			this.G.getEl().dom.oncontextmenu = function(){return false;}
	        this.G.getEl().dom.onselectstart = function(){return false;}
		}
		this.tabPanel.unhideTabStripItem(this.G);
		this.tabPanel.activate(this.G);
		if (!f) {
			this.D.baseParams = {};
			this.D.load({params:{start:0,limit:25}});
			this.G.cnode = null;
			this.G.setTitle(this.G.initialConfig.title);
		}
		return this.G;
	},
	rendererBlockName:function(v,m,r){return  '<b class="block_ico block_' + r.data.type + '" style="float:left;height:14px;"></b>' + v},
	setVisible:function(e,v,f){e=f?e.el.dom:e.container.dom.parentNode;e.style.display=v?'none':''},
	mask:function(flag,msg){if(!this.CG)return;if(flag){this.CG.getEl().mask(msg)}else{this.CG.getEl().unmask()}},
	cateDel:function(item){
		var categoryid=[],len,i;
		if(item.mode == 3){
			if (this.node == undefined) {
				EXCMS.msg('提示','请选择要删除的结点');
				return;
			}
			categoryid.push(this.node.id);
		}else if(this.isTreeContext){
			categoryid.push(this.cnode.id);	
		}else{
			var selected = this.CG.getSelectionModel().getSelections();
			len = selected.length;
			if(!len){EXCMS.msg('提示','请选择要删除的行');return}
			for(i=0;i<len;i++) categoryid.push(selected[i].id);
		}
		len = categoryid.length;
		if(len && confirm("确定删除\n删除分类(页面)将删除其下的子分类(页面)和碎片且不可恢复\n您确实要删除所选的分类(页面)行吗？")){
			this.mask(true,'正在删除分类(页面),请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=deletecategory',method:'post',scope:this,
				params:{categoryid:categoryid.join(',')},
				failure:function(r,o){
					this.mask(false);
					alert('删除分类(页面)失败');
				},
				success:function(r,o){
					this.mask(false);
					EXCMS.msg('提示','删除分类(页面)成功');
					var r,n;
					for(i=0;i<len;i++){
						if(this.CD) if(r = this.CD.getById(categoryid[i])) this.CD.remove(r);
						if(n = this.tree.getNodeById(categoryid[i])) n.remove();
					}
				}
			});
		}
	},
	cateEdit:function(arg){
		if(!this.cateEditor){
			var width = 342;
			this.pid = new Ext.form.Hidden({name:'pid'});
			this.pcate = new Ext.form.ComboBox({fieldLabel:'上级分类',hiddenName:'pcate',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),editable:false,mode:'local',triggerAction:'all',tpl:'<tpl for="."><div style="height:180px"><div></div></div></tpl>',width:width});	
			this.pcate.on('expand',function(){if(!this.pcate.tree.rendered)this.pcate.tree.render(this.pcate.list.dom.getElementsByTagName('div')[2])},this);
			this.pcate.on('collapse',function(c){if(this.ptreeFresh){this.ptreeFresh=false;c.expand()}},this);
			this.pcate.tree = new Ext.tree.TreePanel({useArrows:true,cls:'channel-tree block-tree',bodyStyle:'padding:1px;',border:false,loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),rootVisible:false,root:new Ext.tree.AsyncTreeNode({id:'0',text:'碎片分类',expanded:true}),listeners:{'render':{fn:function(c){var t=c.el.dom.parentNode.parentNode.parentNode.parentNode;t.style.backgroundColor='#FFFFFF';new Ext.Resizable(t,{handles:'s',resizeChild:true})},scope:this}}});
			this.pcate.tree.contextmenu = new Ext.menu.Menu({items:[{text:'刷新分类树',icon:ico,iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this,mode:1}]}); 
			this.pcate.tree.on('contextmenu',function(n,e){
				this.selectedNode = n;this.ptreeFresh = true;
		    	this.pcate.tree.contextmenu.showAt(e.getXY()); 
				this.pcate.tree.contextmenu.items.items[0].mode = n.id == '0';
			},this);
			this.pcate.tree.on('click',function(n){
				this.pid.setValue(n.id);
				this.pcate.setValue(n.text);
				this.pcate.collapse();
			},this);
			this.cateFields = {
				name : new Ext.form.TextField({fieldLabel:'名称',name:'name',allowBlank:false,blankText:'碎片分类(页面）名称不能为空',maxLength:40,width:width}),
				template : new Ext.form.TriggerTextField({fieldLabel:'模板',name:'template',triggerText:'选择...',maxLength:40,width:width,onTriggerClick:this.TemplateBrowse.createDelegate(this)}),
				filename : new Ext.form.TriggerTextField({fieldLabel:'文件名',name:'url',triggerText:'选择...',maxLength:40,width:width,onTriggerClick:this.PPTBrowser.createDelegate(this)}),
				frequency: new Ext.form.NumberField({fieldLabel:'更新频率',name:'frequency',value:3600,maxLength:6,width:60,decimalPrecision:0,sideHtml:'秒 (0表示手动更新)'})
			}
			this.cateEditorForm = new Ext.FormPanel({border:false,labelWidth:60,defaults:{xtype:'textfield'},url:this.baseAction+'&method=commitcategory',bodyStyle:'padding:12px 15px 0;',items:[
				{name:'categoryid',xtype:'hidden'},{name:'type',value:'',xtype:'hidden'},this.pid,this.pcate,
				this.cateFields.name,
				this.cateFields.template,
				this.cateFields.filename,
				this.cateFields.frequency,
				{fieldLabel:'备注',name:'comment',xtype:'textarea',height:36	,width:Ext.isIE?width-3:width},
				{fieldLabel:'排序',name:'sort',xtype:'numberfield',value:100,maxLength:6,width:60,decimalPrecision:0}
			]});
			this.cateEditorForm.form.on('actionfailed',function(f,a){this.cateEditorForm.el.unmask()},this);
			this.cateEditorForm.form.on('actioncomplete',function(f,a){ 
				this.cateEditorForm.el.unmask();
				if(a.result && a.result.success){
					EXCMS.msg('提示','保存成功');
					this.cateEditor.hide();
					this.tree.root.reload();
				}
			}, this);
			this.cateEditor = new Ext.Window({layout:'fit',modal:false,resizable:false,width:460,height:288,closeAction:'hide',plain: true,
				items:this.cateEditorForm,
				buttons:[{text:'确定',handler:this.cateSave,scope:this},{text:'取消',handler:function(){this.cateEditor.hide()},scope:this}]
			});
			this.cateEditor.show();
		}
		
		this.cateEditor.setTitle(this.textNewEdit[arg && arg.mode ? 1 : 0] + '碎片分类(页面)');
		var pid, pcate;
		if(arg && arg.mode){
			var values, categoryid, pcate;
			if(this.isTreeContext){
				categoryid = this.cnode.id, pcate = this.cnode.parentNode.text;
			}else if(arg.mode == 3){
				if(!this.node){EXCMS.msg('提示','请选择要修改的分类(页面)结点');return}
				categoryid = this.node.id, pcate = this.node.parentNode.text;
			}else if(arg.mode == 4){
				var fp = this.tabPanel.getActiveTab();
				categoryid = fp.categoryid, pcate = fp.title;
			}else{
				if(!this.record || !this.CD.getById(this.record.id)){this.cateEditor.hide();EXCMS.msg('提示','请选择要修改的分类(页面)');return}
				categoryid = this.record.id;
				pcate = this.record.data._pid;
			}
			this.cmenu.hide();
			this.cateEditorForm.el.mask('数据获取中…');
			Ext.Ajax.request({
				url:this.baseAction+'&method=getcategory',method:'POST',params:{categoryid:categoryid}, 
				failure:function(){this.cateEditorForm.el.unmask()},scope:this,
				success:function(r,o){
					this.cateEditorForm.el.unmask();
					r = jsonReturn(r);
					if (r.success) {
						var v = r.data.type == 'page';
						this.setVisible(this.cateFields.template, v);
						this.setVisible(this.cateFields.filename, v);
						this.setVisible(this.cateFields.frequency, v);
						r.data.pcate = pcate;
						this.cateEditorForm.form.setValues(r.data);
					}
				}
			});
		}else{
			var v = arg && arg.page;
			this.setVisible(this.cateFields.template, v);
			this.setVisible(this.cateFields.filename, v);
			this.setVisible(this.cateFields.frequency, v);
			this.cateEditor.setHeight(v ? 300 : 218);
			if(arg && arg.sub){
				var fp = this.tabPanel.getActiveTab();
				pid = fp.categoryid, pcate = fp.title;
			}
			this.cateEditorForm.form.reset();
			this.cateEditorForm.form.setValues({type:v?'page':'cate'});
		}
		this.cateEditor.show();
		this.cateEditor.center();
		if(this.isTreeContext){
			pid = this.cnode.id, pcate = this.cnode.text;
		}else if(!pid && this.CG != undefined){
			var r = this.CG.getSelectionModel().getSelected();	
			if(r){
				pid = r.id, pcate = r.data.name;
			}
		}
		if(pid) this.pid.setValue(pid);
		if(pcate) this.pcate.setValue(pcate);
	},
	cateSave:function(){
		if(this.cateEditorForm == undefined)return;
		if(!this.cateEditorForm.form.isValid()){EXCMS.msg('提示','表单中有错误，请检查红线处的错误提示');return ;}
		this.cateEditorForm.el.mask('正在保存, 请稍侯...');
	    this.cateEditorForm.form.submit();
    },
	refreshTree:function(item){
		if(item.mode){if(this.pcate.tree.root.loaded)this.pcate.tree.getLoader().load(this.pcate.tree.root);this.pcate.tree.root.expand();}
		else {if(this.selectedNode.loaded)this.pcate.tree.getLoader()(this.selectedNode);this.selectedNode.expand();}
	},
	blockDel:function(A){
		var blockid = new Array, len, i;
		if(A && A.mode){
			var fp = this.tabPanel.getActiveTab();
			blockid.push(fp.optBlock.blockid);
			len = 1;
		}else{
			var selected = this.G.getSelectionModel().getSelections();
			len = selected.length
			if(!len){EXCMS.msg('提示','请选择要删除的碎片');return}
			for(i=0;i<len;i++) blockid.push(selected[i].id);
		}
		if(len && confirm("删除后不可恢复，您确实要删除所选的碎片吗？")){
			this.blockmask(true,'正在删除,请稍候');
			Ext.Ajax.request({url:this.baseAction+'&method=deleteblock',method:'post',scope:this,
				params:{blockid:blockid.join(',')},
				failure:function(r,o){this.blockmask(false)},
				success:function(r,o){
					this.blockmask(false);
					EXCMS.msg('提示','删除碎片成功');
					var r;
					for(i=0;i<len;i++){
						if (this.D) {
							r = this.D.getById(blockid[i]);
							if(r) this.D.remove(r);
						}
						if (A && A.mode) {
							fp.optBlock.parentNode.removeChild(fp.optBlock);
							if(fp.editBlock&&fp.editBlock.blockid == blockid[i]) this.viewPage();
						}
					}
				}
			});
		}
	},
	blockmask:function(flag,msg){if(!this.G)return;if(flag){this.G.getEl().mask(msg)}else{this.G.getEl().unmask()}}, 
	blockEdit:function(arg){ 
		if(!this.blockEditor){
			this.defaultCode = {
				auto : "{list channelid=0 row=10}\n<ul>\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{/loop}\n</ul>\n{/list}",
				manu : "{list listtype=block}\n<ul class=\"list\">\n{loop item=array fromname=loop}\n<li>\n{loop item=cnt from=$loop}\n<a href=\"{$cnt.url}\" target=\"_blank\" style=\"color:{$cnt.color};{if $cnt.bold}font-weight:bold;{/if}\">{$cnt.title}</a>{if $cnt.tailtitle}\n<span class=\"tail\">{if $cnt.tailurl}<a href=\"{$cnt.tailurl}\" target=\"_blank\" style=\"color:{$cnt.tailcolor};{if $cnt.tailbold}font-weight:bold;{/if}\">{$cnt.tailtitle}</a>{else}{$cnt.tailtitle}{/if}</span>{/if}\n{/loop}\n</li>\n{/loop}\n</ul>\n{/list}",
				json : "{list listtype=block}\n<ul>\n{loop item=cnt}\n<li><a href=\"{$cnt.url}\">{$cnt.title}</a></li>\n{/loop}\n</ul>\n{/list}"
			};
			this.categoryid = new Ext.form.Hidden({name:'categoryid'});
			this.pblock = new Ext.form.ComboBox({fieldLabel:'分类',width:448,hiddenName:'pblock',store:new Ext.data.SimpleStore({fields:[],data:[[]]}),allowBlank:false,blankText:'分类不能为空',emptyText:'请选择分类',editable:false,mode:'local',triggerAction:'all',tpl:'<tpl for="."><div style="height:180px"><div></div></div></tpl>'});	
			this.pblock.on('expand',function(){if(!this.pblock.tree.rendered)this.pblock.tree.render(this.pblock.list.dom.getElementsByTagName('div')[2])},this);
			this.pblock.on('collapse',function(c){if(this.ptreeFresh){this.ptreeFresh=false;c.expand()}},this);
			this.pblock.tree = new Ext.tree.TreePanel({useArrows:true,cls:'channel-tree block-tree',bodyStyle:'padding:1px;',border:false,loader:new Ext.tree.TreeLoader({dataUrl:this.baseAction+'&method=tree'}),rootVisible:false,root:new Ext.tree.AsyncTreeNode({id:'0',text:'碎片分类',expanded:true}),listeners:{'render':{fn:function(c){var t=c.el.dom.parentNode.parentNode.parentNode.parentNode;t.style.backgroundColor='#FFFFFF';new Ext.Resizable(t,{handles:'s',resizeChild:true})},scope:this}}});
			this.pblock.tree.contextmenu = new Ext.menu.Menu({items:[{text:'刷新分类树',icon:ico,iconCls:'btnico btn_fresh',handler:this.refreshTree,scope:this,mode:1}]}); 
			this.pblock.tree.on('contextmenu',function(n,e){
				this.selectedNode = n;this.ptreeFresh = true;
		    	this.pblock.tree.contextmenu.showAt(e.getXY());
				this.pblock.tree.contextmenu.items.items[0].mode = n.id == '0';
			},this);
			this.pblock.tree.on('click',function(n){
				this.categoryid.setValue(n.id);
				this.pblock.setValue(n.text);
				this.pblock.collapse();
			},this);
			this.blockFields = {
				name : new Ext.form.TextField({fieldLabel:'名称',name:'name',allowBlank:false,blankText:'碎片名称不能为空',maxLength:40,width:448}),
				type : new Ext.form.RadioGroup({fieldLabel:'类型',columns:5,width:360,items:[
					{boxLabel:'<b class="block_ico block_code"></b>代码',name:'type',inputValue:'html',listeners:{'check':function(o,c){if(c)this.setForm('html')},scope:this}},
					{boxLabel:'<b class="block_ico block_auto"></b>自动',name:'type',inputValue:'auto',checked:true,listeners:{'check':function(o,c){if(c)this.setForm('auto')},scope:this}},
					{boxLabel:'<b class="block_ico block_manu"></b>手动',name:'type',inputValue:'manu',listeners:{'check':function(o,c){if(c)this.setForm('manu')},scope:this}},
					{boxLabel:'<b class="block_ico block_json"></b>JSON',name:'type',inputValue:'json',listeners:{'check':function(o,c){if(c)this.setForm('json')},scope:this}},
					{boxLabel:'<b class="block_ico block_rss"></b>RSS',name:'type',inputValue:'rss',listeners:{'check':function(o,c){if(c)this.setForm('rss')},scope:this}}
				]}),
				frequency: new Ext.form.NumberField({fieldLabel:'更新频率',name:'frequency',value:3600,width:60,decimalPrecision:0,sideHtml:'秒 (0表示手动更新)'}),
				row : new Ext.form.NumberField({fieldLabel:'显示行数',name:'row',value:6,maxLength:1000,minLength:1,width:60,decimalPrecision:0,sideHtml:'行'})
			}
			if(Ext.isIE){
				this.blockFields.code = new Ext.form.TextArea({fieldLabel:'代码',name:'code',language:'html',anchor:'-21 -200',value:this.defaultCode.auto,style:'font-family:"consolas","monospace","宋体"'});
			}else{
				this.blockFields.code = new Ext.ux.CodePress({fieldLabel:'代码',name:'code',xtype:'codepress',language:'html',anchor:'-21 -184',value:this.defaultCode.auto});
			}
			this.blockEditorForm = new Ext.FormPanel({border:false,labelWidth:60,url:this.baseAction+'&method=commitblock',defaults:{xtype:'textfield'},bodyStyle:'padding:12px 0 0px 10px;',items:[
				{name:'blockid',xtype:'hidden'},this.categoryid,this.pblock,
				this.blockFields.name,
				this.blockFields.type,
				this.blockFields.code,
				//this.blockFields.row,
				this.blockFields.frequency,
				{fieldLabel:'备注',name:'comment',xtype:'textarea',height:36,width:448},
				{fieldLabel:'排序',name:'sort',xtype:'numberfield',value:100,maxLength:6,width:52,decimalPrecision:0}
			]});
			this.blockEditorForm.form.on('actionfailed',function(f,a){this.blockEditorForm.el.unmask();},this);
			this.blockEditorForm.form.on('actioncomplete',function(f,a){
				this.blockEditorForm.el.unmask();
				if(a.result && a.result.success){
					EXCMS.msg('提示','保存碎片成功');
					this.blockEditor.hide();
					if(this.blockEditorForm.editMode){
						this.blockEditorForm.editMode = null;
						this.updateBlockList();
					}else if(this.D){
						this.D.reload();
						var p = this.tabPanel.getActiveTab().panelType || '';
						if(p == 'page') this.D.reload();
					}
				}
				
			}, this);
			this.blockEditor = new Ext.Window({layout:'fit',modal:false,resizable:true,minWidth:560,minHeight:400,width:560,height:420,closeAction:'hide',plain:true,maximizable:true,
				items:this.blockEditorForm,
				buttons:[{text:'确定',handler:this.blockSave,scope:this},{text:'取消',handler:function(){this.blockEditor.hide()},scope:this}],
				listeners:{
					scope:this,
					resize:function(w){
						//if(!Ext.isIE)this.blockFields.code.resize();
					}
				}
			});
		}
		var categoryid, blockid, pblock;
		var fp = this.tabPanel.getActiveTab();
		if (arg && (arg.mode == 1 || arg.mode == 3)) {
			if(arg.mode == 3){
				blockid = fp.optBlock.blockid, pblock = fp.title;
			}else{
				if(this.recordblock && this.D.getById(this.recordblock.id)){
					blockid = this.recordblock.id, pblock = this.recordblock.data.category;
				}else{
					EXCMS.msg('提示','请选择要修改的碎片');
					return ;
				}
			}
			this.blockEditor.show();
			this.blockEditorForm.el.mask('数据获取中…');
			this.setVisible(this.blockFields.type, false);
			Ext.Ajax.request({
				url:this.baseAction+'&method=getblock',method:'POST',params:{blockid:blockid}, 
				failure:function(){this.blockEditorForm.el.unmask()},scope:this,
				success: function(r, o){
					this.blockEditorForm.el.unmask();
					r = jsonReturn(r);
					if (r.success) {
						r.data.pblock = pblock;
						this.blockEditorForm.form.setValues(r.data);
					}
				}
			});
		}else if(arg && arg.mode == 2){
			this.blockEditor.show();
			this.blockEditorForm.form.reset();
			categoryid = fp.categoryid, pblock = fp.title;
			this.setVisible(this.blockFields.type, true);
			this.blockEditorForm.editMode = 2;
		}else{
			this.blockEditor.show();
			this.setVisible(this.blockFields.type, true);
			if(!this.isTreeContext){
				if(fp.panelType == 'cate'){
					categoryid = fp.cnode ? fp.cnode.id : this.record ? this.record.id : '';
					pblock = fp.cnode ? fp.cnode.text : this.record ? this.record.data.name : '';
				}else if(fp.panelType == 'block'){
					categoryid = fp.cnode ? fp.cnode.id : '';
					pblock = fp.cnode ? fp.cnode.text : '';
				}
			}
			this.blockEditorForm.form.reset();
		}
		this.blockEditor.setTitle(this.textNewEdit[arg && arg.mode ? 1 : 0] + '碎片');
		this.blockEditor.center();
		if(this.isTreeContext){
			categoryid = this.cnode.id, pblock = this.cnode.text;
		}
		if(categoryid) this.categoryid.setValue(categoryid);
		if(pblock) this.pblock.setValue(pblock);
	},
	blockSave:function(){
		this.blockFields.code.getValue();
		if(!this.blockEditorForm.form.isValid()){EXCMS.msg('提示','表单中有错误，请检查红线处的错误提示');return ;}
		this.blockEditorForm.el.mask('正在保存, 请稍侯...');
	    this.blockEditorForm.form.submit();
    },
	setForm:function(v){
		switch(v){
			case 'auto':this.blockFields.code.setValue(this.defaultCode.auto);break;
			case 'json':
			case 'rss':
			case 'rpc':
			case 'manu':this.blockFields.code.setValue(this.defaultCode.manu);break;
			default:this.blockFields.code.setValue('');break;
		}
		//this.setVisible(this.blockFields.row, v!=0);
		this.setVisible(this.blockFields.frequency, v!='manu' && v!='html');
	},
	blockPub:function(){},
	
	// search trigger click
	soOnTrigger1Click:function(){this.soField.reset();this.D.baseParams={key:'',pid:0};this.D.reload()},
	soOnTrigger2Click:function(){var key = this.soField.getValue('').trim();if(key!=''){this.D.baseParams={key:key,pid:0};this.D.reload()}},
	setVisible:function(e,v,f){e=f?e.el.dom:e.container.dom.parentNode;e.style.display=v?'':'none'},
	PPTBrowser:function(){
		EXCMS.util.script('Modules/System/pptbrowser.js',{object:'EXCMS.System.PPTBrowser',callback:this.selectPPT.createDelegate(this),fullpath:true,single:true,selectType:'FILE'});
	},
	selectPPT : function(v){
		this.cateFields.filename.setValue(v);
	},
	TemplateBrowse : function(){ 
		EXCMS.util.script('Modules/Template/TemplateDialog.js',{object:'EXCMS.Template.TemplateDialog',callback:this.selectTemplate.createDelegate(this),single:true,selectType:'FILE'});
	},
	selectTemplate:function(data){
		this.cateFields.template.setValue(data.url);
	},
	
	// 分类(页面)查看
	manage:function(obj){
		var id = 'block-category' + obj.id, title = tabTip = obj.title, fp = this.tabPanel.getComponent(id);
		if(title && title.length > 8) title = title.substr(0,8) + '…';
		if(!fp){
			var center = new Ext.Panel({region:'center',border:false,autoScroll:true,bodyStyle:'padding:15px',html:''});
			var west = new Ext.Panel({region:'west',title:'碎片列表',width:180,border:false,collapsible:true,autoScroll:true,style:'border-right:1px solid #99BBE8;',listeners:{'render':{fn:this.initBlockClickEvent,scope:this}}});
			var fp = new Ext.FormPanel({title:title,id:id,categoryid:obj.id,tabTip:tabTip,closable:true,closePanel:true,border:false,layout:'border',items:[west,center],tbar:[
				{text:'浏览',handler:this.browsePage,scope:this,mode:1},
				{text:'查看',handler:this.viewPage,scope:this},
				{text:'生成',handler:this.publishCategory,scope:this,mode:1},
				'-',
				//{text:'编辑源码',handler:this.cateSave,scope:this},'-',
				//{text:'新建',handler:this.cateSave,scope:this,menu:{items:[
				{text:'新建',menu:{items:[
					{text:'添加碎片',handler:this.blockEdit,scope:this,mode:2},'-',
					{text:'添加分类',handler:this.cateEdit,scope:this},
					{text:'添加子分类',handler:this.cateEdit,scope:this,sub:true},'-',
					{text:'添加页面',handler:this.cateEdit,scope:this,page:true},
					{text:'添加子页面',handler:this.cateEdit,scope:this,page:true,sub:true}
				]}},
				{text:'修改',handler:this.cateEdit,scope:this,mode:4}
//				{text:'删除',handler:this.cateDel,scope:this}
			]});
			fp.center = center;
			fp.west = west;
			this.tabPanel.add(fp);
			this.tabPanel.activate(fp);
			if(obj.blockid) fp.loadBlock = obj.blockid;
			this.loadPage(obj.id);
		}else{
			this.tabPanel.activate(fp);
			if(obj.blockid) this.blockView(obj.blockid);
		}
	},
	initBlockClickEvent:function(c){
		var tthis = this;
		c.body.dom.onclick = function(e){
			e = window.event||e;var el=e.target||e.srcElement;
			if(el.tagName.toLowerCase() == 'a'){
				var bp = tthis.getBlockPanel();
				if (bp && bp.changed && !confirm("碎片数据尚未保存确定不保存吗?")){
					return;
				}
				EXCMS.Block.tabPanel.getActiveTab().optBlock = el;
				EXCMS.Block.blockView();
			}
		}
		c.body.dom.oncontextmenu=function(e){
			EXCMS.Block.onBlockListContextMenu(e);return false}
	},
	onBlockListContextMenu:function(e,el){
		if(!this.blContextMenu){
			this.blContextMenu = new Ext.menu.Menu({items:[
				{text:'<b>查看</b>',handler:this.blockView,scope:this,mode:1},
				{text:'浏览',handler:this.blockBrowse,scope:this},
				{text:'新建碎片',handler:this.blockEdit,scope:this,mode:2},
				{text:'修改属性',handler:this.blockEdit,scope:this,mode:3},
				{text:'删除',handler:this.blockDel,scope:this,mode:1},'-',
				{text:'刷新碎片列表',handler:this.updateBlockList,scope:this},'-',
				{text:'生成',handler:this.publishBlock,scope:this,mode:1}
//				{text:'权限',handler:this.blockAcl,scope:this},
//				{text:'历史记录',handler:this.blockHistory,scope:this}
			]});
			this.blContextMenu.cel = 'block';
		}
		e = window.event || e;
		var el = e.target||e.srcElement, cel = 'block';
		if(el.tagName.toLowerCase() == 'a'){
			this.tabPanel.getActiveTab().optBlock = el;
		}else cel = 'body';
		if(this.blContextMenu.cel != cel){
			cel = cel == 'body';
			for(var i=0,len=this.blContextMenu.items.items.length;i<len;i++)
			this.blContextMenu.items.items[i].setDisabled(i==2 || i==6 ? !cel : cel);
			this.blContextMenu.cel = cel;
		}
		this.blContextMenu.showAt([e.clientX, e.clientY]);
	},
	loadPage:function(id){
		var fp = this.tabPanel.getActiveTab();
		fp.body.mask('正在加载分类(页面)，请稍候…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=getpage',method:'POST',scope:this,params:{categoryid:id},
			failure:function(){fp.body.unmask()},
			success:function(r,o){
				fp.body.unmask();
				r = Ext.decode(r.responseText);
				if(r.success){
					this.renderBlockList(r.blocks);
					this.renderPage(r.category);
					this.renderHistory(r.history);
					if(fp.loadBlock) this.blockView(fp.loadBlock);
				}
			}
		});
	},
	renderBlockList : function(d,f){
		var p = this.tabPanel.getActiveTab().layout.west.panel.body;
		if(!p.blockCt){
			p.blockCt = document.createElement('div');
			p.appendChild(p.blockCt);
			p.blockCt.className = 'blocks-container';
		}
		if(f) p.blockCt.innerHTML = '';
		var a;
		for(var i=0,len=d.length;i<len;i++){
			a= document.createElement('a');
			a.id = 'block-list-' + d[i].blockid;
			a.className = 'block_' + d[i].type;
			a.href = 'javascript:;';
			a.blockid = d[i].blockid;
			a.innerHTML = d[i].name;
			p.blockCt.appendChild(a);
		}
	},
	updateBlockList:function(){
		var fp = this.tabPanel.getActiveTab();
		fp.layout.west.el.mask('加载碎片列表…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=getcategoryblocks',method:'POST',scope:this,params:{categoryid:fp.categoryid},
			failure:function(){fp.layout.west.el.unmask()},
			success:function(r,o){
				fp.layout.west.el.unmask();
				r = Ext.decode(r.responseText);
				if(r.success) this.renderBlockList(r.blocks, true);
			}
		});
	},
	renderPage:function(d){
		var p = this.tabPanel.getActiveTab().layout.center.panel.body;
		p.pageCt = p.createChild({tag:'div'},null,true);
		var tbar = document.createElement('div');
		p.pageCt.appendChild(tbar);
		tbar.className = 'block-tbar';
		tbar.innerHTML = '<h3>操作记录</h3><span class="day-current"></span>';
		p.currentDayEl = tbar.lastChild;
		// days list
		var t = Math.round(new Date().getTime()/1000), days = document.createElement('span'), a, dp, ad;
		var ds = Math.ceil((t - d.createddate) / 86400);
		if(ds > 7){dp=true;ds=7}else if(ds ==0) ds = 1;
		days.className = 'days';
		for(var i=0;i<ds;i++){
			a = document.createElement('a');
			a.href = 'javascript:;';
			ad =  new Date((t - i * 86400) * 1000);
			if(i==0){
				a.innerHTML = '今天';
				a.className = 'current';
			}else if(i==1){
				a.innerHTML = '昨天';
			}else if(i==2){
				a.innerHTML = '前天';
			}else{
				a.innerHTML = ad.format('m-d');
			}
			a.date = ad.format('Y-m-d');
			a.onclick = function(){EXCMS.Block.loadHistory(this)}
			days.appendChild(a);
		}
		if(dp){
			dp = document.createElement('a');
			dp.href = 'javascript:;';
			dp.className = 'calr';
			dp.innerHTML = '▼';
			dp.createddate = parseInt(d.createddate);
			dp.onclick = function(){EXCMS.Block.showDatePicker(this)}
			days.appendChild(dp);
		}
		tbar.appendChild(days);
		p.days = days;
		// history body
		p.historyBody = document.createElement('div');
		p.historyBody.className = 'block-logs-bd';
		p.pageCt.appendChild(p.historyBody);
		
		var b = document.createElement('div');
		b.className = 'block-tbar';
		b.innerHTML = '<h3>页面(分类)属性</h3>';
		p.pageCt.appendChild(b);
		// page table
		p.pageTable = document.createElement('div');
		p.pageCt.appendChild(p.pageTable);
		this.updatePageInfo(d);
	},
	updatePageInfo:function(d){
		var h = '<table class="block-info-table" cellspacing="0" cellpadding="0" border="0"><tbody><tr><th>名称：</th><td>'+d['name']+'</td></tr>';
		if(d.type == 'page'){
			h += '<tr><th>网址：</th><td><a target="_blank" href="'+d['url']+'">'+d['url']+'</a></td></tr>'+
			'<tr><th>页面大小：</th><td>'+d['pagesize']+'</td></tr>'+
			'<tr><th>模板：</th><td>'+d['template']+'</td></tr>'+
			'<tr><th>更新频率：</th><td>'+d['frequency']+'秒</td></tr>'+
			'<tr><th>上次更新：</th><td>'+new Date(d['publisheddate']*1000).format('Y-m-d H:i:s')+'</td></tr>'+
			'<tr><th>下次更新：</th><td>'+new Date(d['nextdate']*1000).format('Y-m-d H:i:s')+'</td></tr>';
		}
		h += '<tr><th>创建者：</th><td>'+d['createdby']+'</td></tr>'+
			'<tr><th>创建时间：</th><td>'+new Date(d['createddate']*1000).format('Y-m-d H:i:s')+'</td></tr>'+
			'<tr><th>备注：</th><td>'+d['comment']+'</td></tr>'+
			'</tbody></table>';
		this.tabPanel.getActiveTab().layout.center.panel.body.pageTable.innerHTML = h;
	},
	viewPage:function(){
		var p = this.tabPanel.getActiveTab().layout.center.panel.body;
		p.pageCt.style.display = '';
		if(p.blockEditor) p.blockEditor.dom.style.display = 'none';
	},
	loadHistory:function(el){
		var fp = this.tabPanel.getActiveTab();
		var p = fp.layout.center.panel.body;
		p.currentDayEl.innerHTML = el.date;
		setCls(p.days.current || p.days.firstChild, 'current', 1);
		var date;
		if(typeof el == 'string'){
			date = el;
			var ds = Math.floor((new Date().getTime() - new Date(date).getTime()) / 86400000);
			if(ds < 7) el = p.days.childNodes[ds];
		}
		if(typeof el == 'object'){
			setCls(el, 'current');
			el.parentNode.current = el;
			date = el.date;	
		}
		if(p.historyDate && p.historyDate == date) return;
		p.historyDate = date
		if(!p.historyBody.el) p.historyBody.el = Ext.get(p.historyBody);
		p.historyBody.el.mask('正在加载历史记录');
		Ext.Ajax.request({
			url:this.baseAction+'&method=getcategoryhistory',method:'POST',scope:this,params:{categoryid:fp.categoryid, date:date},
			failure:function(){p.historyBody.el.unmask()},
			success:function(r,o){
				p.historyBody.el.unmask();
				r = Ext.decode(r.responseText);
				this.renderHistory(r.success ? r.history : false);
			}
		});		
	},
	renderHistory:function(d){
		var i, len = d?d.length:0, h = '<table class="block-content-table block-log-table" cellspacing="0" cellpadding="0" border="0" style="margin-top:8px">';
		if(d.length){
			for(i=0,len;i<len;i++){
				h += '<tr><td class="log-dt">' + d[i].createddate + '</td><td class="log-msg"><a href="javascript:;">' + d[i].createdby + '</a>对碎片“<a href="javascript:;" onclick="EXCMS.Block.blockView(' + d[i].blockid + ')">' + d[i].name + '</a>”执行了“<font color=#FF6600>' + d[i].type + '”</font>操作' + '</td></tr>';
			}			
		}else{
			h += '<tr><td class="log-msg">没有任何操作记录</td></tr>';
		}
		this.tabPanel.getActiveTab().layout.center.panel.body.historyBody.innerHTML = h + '</table>';
	},
	showDatePicker:function(el){
		if(!this.datePicker){
			this.datePicker = new Ext.menu.DateMenu({minDate:new Date(el.createddate*1000),maxDate:new Date(),todayText:'今天',listeners:{scope:this,select:function(p,d){this.loadHistory(d.format('Y-m-d'))}}});
		}else if(!this.datePicker.showEl || this.datePicker.showEl != el){
			this.datePicker.picker.setMinDate(new Date(el.createddate*1000));
		}
		this.datePicker.showEl = el;
		this.datePicker.show(el);
	},
	blockView:function(blockid){
		var fp = this.tabPanel.getActiveTab();
		if(blockid && !blockid.mode){
			var b = fp.layout.west.panel.body.child('a#block-list-' + blockid, true);
			if(b){fp.optBlock=b;}else{return;}
		}
		var p = fp.layout.center.panel.body;
		if(!p.blockEditor) p.blockEditor = p.createChild({tag:'div'},null);
		p.pageCt.style.display = 'none';
		p.blockEditor.dom.style.display = '';
		setCls(fp.optBlock,'current');
		if(fp.editBlock){
			if(fp.editBlock.blockid == fp.optBlock.blockid) return;
			setCls(fp.editBlock,'current', 1);
		}
		p.blockEditor.load({url:this.baseAction+'&method=geteditblock',text:'正在加载碎片，请稍候…',scripts:true,params:{blockid:fp.optBlock.blockid},callback:function(){
			fp.editBlock = fp.optBlock;
			fp.blockPanel = fp.center.body.child('div.block-main-ct');
			fp.blockPanel.cPanel = 'preview';
		},scope:this});
	},
	getET:function(){return this.tabPanel.getActiveTab().ET},
	// block UI
	tools : '<div onclick="EXCMS.Block.fireOptEvent(event)"><em class="sel" title="选择内容"></em><em class="add" title="手工录入"></em><em class="insr" title="插入行"></em><em class="up" title="上移"></em><em class="down" title="下移"></em><em class="dele" title="删除" onclick=""></span></div>',
	onBlockEditContextMenu:function(e,o){
		//this.getET() = Ext.get(o);
		e = window.event || e;
		if(!this.contextMenu){
			this.contextMenu = new Ext.menu.Menu({items:[
				{text:'浏览',handler:this.conBrowse,scope:this},'-',
				{text:'编辑',handler:this.conEdit,scope:this},
				{text:'插入',handler:this.conInsert,scope:this},
				{text:'替换',handler:this.conReplace,scope:this},
				{text:'删除',handler:this.conDel,scope:this},'-',
				{text:'左移',handler:this.conMove,scope:this},
				{text:'右移',handler:this.conMove,scope:this,mode:1}
			]}); 
			this.contextRowMenu = new Ext.menu.Menu({items:[
				{text:'手工录入',handler:this.addCon,scope:this},
				{text:'选择内容',handler:this.selectCon,scope:this},'-',
				{text:'添加行',handler:this.addRow,scope:this},
				{text:'插入行',handler:this.addRow,scope:this,mode:'insert'},
				{text:'删除行',handler:this.delRow,scope:this},'-',
				{text:'上移置顶',handler:this.upRow,scope:this,top:true},
				{text:'上移行',handler:this.upRow,scope:this},
				{text:'下移行',handler:this.downRow,scope:this},
				{text:'下移置底',handler:this.downRow,scope:this,bottom:true}
			]}); 
		}
		var el = e.target||e.srcElement;
		var xy = [e.clientX, e.clientY];
		this.getET().eventEl = el;
		var tn = el.tagName.toLowerCase();
		if(tn == 'p' || tn == 'a' || tn == 'span'){
			var c = tn == 'a' && el.parentNode.tagName.toLowerCase() == 'span' ? el.parentNode : this.getCon();
			this.moveEl = c;
			var tf = el.className == 'block-tail';
			this.contextMenu.items.items[3].setDisabled(tf);
			this.contextMenu.items.items[7].setDisabled(tf || !c.previousSibling);
			this.contextMenu.items.items[8].setDisabled(tf || !c.nextSibling);
			this.contextMenu.showAt(xy);
		}else{
			var f = tn == 'th';
			this.contextRowMenu.showAt(xy);
			var a = [5,7,8,9,10];
			for(var i=0;i<3;i++) this.contextRowMenu.items.items[a[i]].setDisabled(f);
		}
		return false;
	},
	fireOptEvent:function(e){
		e = window.event || e;
		var el = e.target || e.srcElement;
		if(el.tagName.toLowerCase() == 'em'){
			this.getET().eventEl = el;
			switch(el.className){
				case 'sel' : this.selectCon(); break;
				case 'add' : this.editTr = this.getTr(); this.addCon(); break;
				case 'up' : this.upRow(); break;
				case 'insr' : this.addRow({mode:'insert'}); break;
				case 'down' : this.downRow(); break;
				case 'dele' : this.delRow(); break;
			}
		}
	},
	addRow:function(a,e){
		var bel;
		if(a && a.mode && a.mode == 'insert'){
			var rows = this.getET().dom.tBodies[0].rows;
			if(this.getET().eventEl.tagName.toLowerCase() == 'th'){
				if(rows.length) bel = rows[0];
			}else bel = this.getTr();
		}
		var tr = document.createElement('tr');
        bel ? this.getET().dom.tBodies[0].insertBefore(tr, bel) : this.getET().dom.tBodies[0].appendChild(tr);
		var td = document.createElement('td');
		td.className = 'block-num-td';
		tr.appendChild(td);
		td = document.createElement('td');
		tr.appendChild(td);
		td = document.createElement('td');
		td.className = 'block-tools';
		td.innerHTML = this.tools;
		tr.appendChild(td);
		tr.onmouseover = function(){setCls(this,'block-row-over')}
		tr.onmouseout = function(){setCls(this,'block-row-over',1)}
		this.refreshRowNum();
		return tr;
	},
	delRow:function(){
//		this.isedit = true;
//		return
		var tr = this.getTr();
		tr.parentNode.removeChild(tr);
		this.refreshRowNum();
	},
	upRow:function(item){
		var tr = this.getTr();
		if(tr.rowIndex == 1){
			alert('顶行无法继续上移');
			return ;
		}else if(item && item.top){
			this.getET().dom.tBodies[0].insertBefore(tr, this.getET().dom.tBodies[0].rows[0]);
		}else{
			this.getET().dom.tBodies[0].insertBefore(tr, this.getET().dom.tBodies[0].rows[tr.rowIndex-2]);
		}
		this.refreshRowNum();
	},
	downRow:function(A){
		var tr1, tr = this.getTr();
		if(tr.rowIndex == this.getET().dom.tBodies[0].rows.length){
			alert('底行无法继续下移');
			return ;
		}else if((A && A.bottom) || tr1 != this.getET().dom.tBodies[0].rows[tr.rowIndex + 1]){
			this.getET().dom.tBodies[0].appendChild(tr);
		}else{
			this.getET().dom.tBodies[0].insertBefore(tr, tr1);
		}
		this.refreshRowNum();
	},
	refreshRowNum:function(){
		this.getBlockPanel().changed = true;
		var rows = this.getET().dom.tBodies[0].rows;
		for(var i=0,len=rows.length;i<len;i++){
			rows[i].className = '';
			rows[i].firstChild.innerHTML = i+1;
		}
		//if(len) rows[len - 1].className = "block-last-row";
	},
	getTr:function(){
		var tr = this.getET().eventEl;
		while(tr.tagName.toLowerCase() != 'tr') tr = tr.parentNode;
		return tr;
	},
	getCon:function(){
		var con = this.getET().eventEl;
		var t = con.tagName.toLowerCase(), pt = con.parentNode.tagName.toLowerCase();
		if(t == 'a'){
			if(pt == 'p' && con.className != 'block-tail') con = con.parentNode;
		}else con = con.getElementsByTagName('a')[0];
		//while(con.tagName.toLowerCase() != 'p') con = con.parentNode;
		return con;
	},
	addCon:function(v){
		if(v && v.newrow){
			this.getET().newtr = true;
			v = null;
		}else this.getET().newtr = false;
		var ec = this.editingCon || this.insertCon || this.replaceCon;
		var s = ec && ec.tagName.toLowerCase() != 'p';
		EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.ManuCon',callback:this.callback.createDelegate(this),stitle:s,value:v,cancelCalback:this.cancelCalback.createDelegate(this)});
	},
	callback:function(v){
		if(this.editingCon){
			var t = this.editingCon.tagName.toLowerCase();
			if(t == 'p'){
				this.appendCon(v, this.editingCon);
			}else{
				this.setLink(this.editingCon, v);
			}
		}else if(this.insertCon){
			var e = this.insertCon, c;
			if(e.tagName.toLowerCase() == 'p'){
				c = this.appendCon(v);
			}else{
				c = this.appendRtitle(v);
				e = e.parentNode;
			}		
			e.parentNode.insertBefore(c, e);	
		}else if(this.replaceCon){
			this.replaceCon.tagName.toLowerCase() == 'p' ? this.appendCon(v, this.replaceCon) : this.setLink(this.replaceCon, v);
		}else{
			var td = this.editTr ? this.editTr.cells[1] : this.getConTd();
			td.appendChild(this.appendCon(v));
		}
		this.cancelCalback();
	},
	cancelCalback:function(){
		this.editingCon=this.insertCon =this.replaceCon=null;this.getET().newtr=false;
	},
	selectCon:function(f){
		if(this.contextRowMenu)this.contextRowMenu.hide();
		this.getET().newtr = f && f.newrow || false;
		EXCMS.util.script('Modules/Content/ContentSelect.js',{object:'EXCMS.Content.ContentSelect',callback:this.conCallBack.createDelegate(this)});
	},
	conCallBack:function(c){
		var td = this.getConTd();
		var tbd = this.getET().dom.tBodies[0];
		var flag = this.getET().newtr || this.getET().eventEl.tagName.toLowerCase() == 'th';
		var row = 0;
		if(flag && tbd.lastChild.cells[1].innerHTML == ''){
			while(tbd.lastChild && tbd.lastChild.cells[1].innerHTML == ''){
				tbd.removeChild(tbd.lastChild);
				row++;
			}
			td = this.addRow().cells[1];
		}
		for(var i=0,len=c.length;i<len;i++){
			p = this.appendCon({contentid:c[i].data.contentid, title:c[i].data.title, url:c[i].data.url, thumb:c[i].data.thumb||''});
			if(i > 0 && flag){
				this.addRow();
				tbd.lastChild.cells[1].appendChild(p);
			}else td.appendChild(p);
			row--;
		}
		while(row-- > 0) this.addRow();
		this.getET().newtr = false;
	},
	appendCon:function(v, p){
		p = p || document.createElement('p');
		p.innerHTML = '';
		p.value = v;
		var a = document.createElement('a');
		p.appendChild(a);
		this.setLink(a, {title:v.title, url:v.url, bold:v.bold||'', color:v.color||''});
		a.target = '_blank';
		if(v.tailtitle){
			var t = document.createElement('a');
			t.className = 'block-tail';
			this.setLink(t, {title:v.tailtitle, url:v.tailurl});
			p.appendChild(t);
		}
		if(v.rtitles){
			p.style.cssText += 'float:none;clear:both';
			a.className = 'block-related-title';
			var c = document.createElement('span');
			c.className = 'block-related-ct';
			p.appendChild(c);
			for(var i=0,len=v.rtitles.length;i<len;i++) c.appendChild(this.appendRtitle(v.rtitles[i]));
		}
		return p;
	},
	appendRtitle:function(v){
		var span = document.createElement('span');
		span = document.createElement('span');
		span.appendChild(document.createTextNode('['));
		var a = document.createElement('a');
		this.setLink(a, {title:v.title, url:v.url, bold:v.bold||'', color:v.color||''});
		span.appendChild(a);
		span.appendChild(document.createTextNode(']'));
		return span;
	},
	setLink:function(a,v){
		this.getBlockPanel().changed = true;
		a.value = v;
		a.innerHTML = v.title;
		a.href = v.url;
		a.target = '_blank';
		a.style.fontWeight = v.bold ? 'bold' : '';
		if(v.color) a.style.cssText += ';color:' + v.color + ' !important';
		else a.style.color = '';
	},
	getConTd:function(){
		var tr, tbd = this.getET().dom.tBodies[0], p;
		if(this.getET().newtr || this.getET().eventEl.tagName.toLowerCase() == 'th'){
			if(!tbd.rows.length || tbd.lastChild.cells[1].innerHTML != '') this.addRow();
			tr = tbd.lastChild;
		}else{
			tr = this.getTr();
		}
		return tr.cells[1];
	},
	getConData:function(){},
	conBrowse:function(){EXCMS.util.RequestUrl(this.getCon().value.url, null, 'POST')},
	conEdit:function(){
		this.editingCon = this.getCon();
		this.addCon(this.editingCon.tagName.toLowerCase() == 'p' ? this.getPData(this.editingCon) : this.editingCon.value);
	},
	conInsert:function(){
		this.insertCon = this.getCon();
		this.addCon();
	},
	conReplace:function(){
		this.replaceCon = this.getCon();
		this.addCon();
	},
	conDel:function(){
		this.getBlockPanel().changed = true;
		var c = this.getCon();
		var p = c.parentNode;
		if(p.tagName.toLowerCase() == 'span'){
			if(p.parentNode.childNodes.length > 1){
				p.parentNode.removeChild(p)
			}else{
				p.parentNode.parentNode.remove(p.parentNode);
				p.parentNode.parentNode.style = '';
			}
		}else{
			c.parentNode.removeChild(c);
		}
	},
	conMove:function(A){
		this.getBlockPanel().changed = true;
		this.contextMenu.hide();
		var c = this.moveEl;
		if(A && A.mode) c.nextSibling.nextSibling ? c.parentNode.insertBefore(c, c.nextSibling.nextSibling) : c.parentNode.appendChild(c);
		else c.parentNode.insertBefore(c, c.previousSibling);
	},
	getData:function(){
		var rows = this.getET().dom.tBodies[0].rows || null;
		var data = new Array(), data1;
		if(rows){
			var p;
			for(var i=0,len=rows.length;i<len;i++){
				if(rows[i].cells[1].innerHTML != ''){
					p = rows[i].cells[1].childNodes;
					data1 = new Array();
					for(var k=0,len1=p.length;k<len1;k++) data1.push(this.getPData(p[k]));
					data.push(data1);
				}
			}
		}
		return data;
	},
	getPData:function(p){
		var a = p.getElementsByTagName('a');
		var rtitles = new Array();
		for(var i=1,len=a.length;i<len;i++){
			if(i == 1 && a[1].className == 'block-tail'){
				p.value.tailtitle = a[i].value.title;
				p.value.tailurl = a[i].value.url;
				p.value.tailbold = a[i].value.bold||'';
				p.value.tailcolor = a[i].value.color||'';
			}else{
				rtitles.push(a[i].value);
			}
		}
		if(rtitles.length) p.value.rtitles = rtitles;
		return p.value;
	},
	getBlockPanel:function(p){
		var fp = this.tabPanel.getActiveTab();
		if(fp.blockPanel){
			if(fp.blockPanel && !fp.blockPanel.preview) this.getPanel();
			return p ? fp.blockPanel[p] : fp.blockPanel;
		}else{
			return false;
		}
	},
	showPanel:function(p){
		var bp = this.getBlockPanel();
		if(bp.cPanel == p) return ;
		bp[bp.cPanel].dom.style.display = 'none';
		bp[bp.cPanel].tab.className = '';
		bp.cPanel = p;
		bp[p].dom.style.display = '';
		bp[p].tab.className = 'current';
		if(p == 'data'){
			if (!bp.data.isLoaded) {
				var v = bp.data.child('textarea.block-data',true).value;
				this.renderBlockData(v ? Ext.decode(v) : '');
			}
		}else if(p == 'history'){
			if(!bp.history.isLoaded) this.loadBlockHistory();
		}else if(p == 'preview'){
			if (bp.preview.isCommitData) {
				this.refreshPriew();
				bp.preview.isCommitData = false;
			}
		}
	},
	getPanel:function(){
		var bp = this.tabPanel.getActiveTab().blockPanel;
		var tabs = this.tabPanel.getActiveTab().center.body.child('div.block-tabs', true).getElementsByTagName('span');
		bp.preview = bp.child('div.block-preview-ct');
		bp.preview.tab = tabs[0];
		bp.data = bp.child('div.block-data-ct');
		if (bp.data) {
			bp.data.tab = tabs[1];
			this.tabPanel.getActiveTab().ET = bp.data.child('table');
		}
		/*bp.edit = bp.child('div.block-edit-ct',true);
		if (bp.edit) {
			bp.edit.tab = tabs[1];
			this.renderEditPanel();
		}*/
		bp.history = bp.child('div.block-history-ct');
		bp.history.tab = tabs[bp.data ? 2 : 1];
	},
	renderEditPanel:function(){
		var a = bp.edit.child('textarea.block-code');
		bp.editor = new Ext.ux.CodePress({applyTo:a,anchor:'100%',height:200,hideLabel:true,name:'code',xtype:'codepress',language:'html',value:''});
	},
	timedPub:function(d){
		var bp = this.getBlockPanel();
		if(!bp.datePicker){
			bp.datePickerCt = bp.child('span.block-timed-input',true);
			if (bp.datePickerCt.innerHTML) {
				d = bp.datePickerCt.innerHTML;
				bp.datePickerCt.innerHTML = '';
			}
			bp.datePicker = new Ext.ux.form.DateTimeField({renderTo:bp.datePickerCt,hideLabel:true,name:'timedpub',width:150,minValue:new Date(),minText:'发布日期不能小于{minValue}'});
			bp.timebox = bp.child('input#block-timed-pub', true);
		}
		if (d) {
			if(d == 1){
				bp.timebox.checked = false;
			}else{
				bp.datePicker.setValue(new Date(d * 1000));
				bp.timebox.checked = true;
			}
		}else{this.getBlockPanel().changed = true;}
		bp.datePickerCt.style.display = bp.timebox.checked ? '' : 'none';
	},
	// 碎片动作
	loadBlockData:function(){
		var fp = this.tabPanel.getActiveTab();
		var bp = this.getBlockPanel();
		bp.mask('加载碎片数据…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=getblockdata',method:'POST',scope:this,params:{blockid:fp.editBlock.blockid},
			failure:function(){bp.unmask()},
			success:function(r,o){
				bp.unmask();
				r = Ext.decode(r.responseText);
				this.renderBlockData(r.data, r.publisheddate);
			}
		});
	},
	renderBlockData:function(d,t){
		var bp = this.getBlockPanel();
		bp.data.isLoaded = true;
		var b = this.getET().dom.tBodies[0];
		while(b.firstChild) b.removeChild(b.firstChild);
		if(d && d.length){
			var p, td;
			for(var i=0,len=d.length;i<len;i++){
				td = this.addRow().cells[1];
				for(var k=0,len1=d[i].length;k<len1;k++){
					p = this.appendCon(d[i][k]);
					td.appendChild(p);
				}
			}
		}else{
			this.addRow();
		}
		this.timedPub(t||1);
		bp.changed = false;
	},
	loadBlockHistory:function(){},
	view:function(){},
	save:function(flag){
		var data = this.getData();
		if(data.length == 0 && !confirm("空碎片数据警告!\n确定要将碎片数据置空吗?")) return;
		var bp = this.getBlockPanel();
		var publisheddate = bp.timebox && bp.timebox.checked ? (bp.datePicker.getValue() ? bp.datePicker.getValue().format('U') : '') : '';
		bp.mask('正在保存碎片数据，请稍候…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=updateblockdata',method:'POST',scope:this,
			params:{blockid:this.tabPanel.getActiveTab().editBlock.blockid, publisheddate:publisheddate, data:Ext.encode(data)},
			failure:function(){this.getBlockPanel().unmask()},
			success:function(r,o){
				this.getBlockPanel().unmask();
				r = Ext.decode(r.responseText);
				if(r.success){
						this.getBlockPanel().changed = false;
						EXCMS.msg('提示', '碎片数据保存成功');
				}
			}
		});
	},
	publishCategory : function(item){
		var categoryid,ids=[];
		if(item.mode){
			ids.push(this.tabPanel.getActiveTab().categoryid);
//			categoryid = this.tabPanel.getActiveTab().categoryid;
		}else{
			if(this.isTreeContext){
				ids.push(this.cnode.id);
//				categoryid = this.cnode.id;
			}else{
				var selected = this.CG.getSelectionModel().getSelections();
				if(!(selected.length>0)){EXCMS.msg('提示', '请选择要生成的分类(页面)');return;}
				if(selected.length){
					for(var i=0,len=selected.length;i<len;i++){
					if(!(selected[i].get('categoryid')>0)){this.CD.remove(selected[i]);continue;}
					ids.push(selected[i].get('categoryid'));
					}
				}
			}
		}
		this.tabPanel.getActiveTab().body.mask('正在生成，请稍候…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=publishcategory',method:'POST',scope:this,params:{categoryid:ids.join(',')},
			failure:function(){this.tabPanel.getActiveTab().body.unmask();},
			success:function(r,o){
				this.tabPanel.getActiveTab().body.unmask();
				if(item.mode) this.tabPanel.el.unmask(); else this.tree.el.unmask();
				r = Ext.decode(r.responseText);
				if(r.success) EXCMS.msg('提示','分类（页面）及碎片生成完成');
			}
		});
	},
	browsePage : function(item){
		var categoryid;
		if(item && item.mode){
			categoryid = this.tabPanel.getActiveTab().categoryid;	
		}else if(this.isTreeContext){
			categoryid = this.cnode.id
		}else{
			if(!this.record || !this.CD.getById(this.record.id)){
				EXCMS.msg('提示','请选择要浏览的页面');
				return ;
			}
			if(this.record.data.type != 'page'){
				EXCMS.msg('提示','碎片分类无法浏览');
				return ;
			}
			categoryid = this.record.id
		}
		EXCMS.util.RequestUrl(this.baseAction,{M:'block',A:'Index',method:'browsepage',categoryid:categoryid}, 'GET');
	},
	blockBrowse : function(item){
		var blockid;
		if(item && item.mode){
			if(!this.recordblock || !this.D.getById(this.recordblock.id)){
				EXCMS.msg('提示','请选择要浏览的碎片');
				return ;
			}
			blockid = this.recordblock.id;
		}else{
			blockid = this.tabPanel.getActiveTab().optBlock.blockid
		}
		EXCMS.util.RequestUrl(this.baseAction,{M:'block',A:'Index',method:'browseblock',blockid:blockid}, 'GET');
	},
	refreshPriew:function(){
		var p = this.getBlockPanel('preview');
		if(!p.body) p.body = p.child('div.block-preview');
		p.body.load({
			url: this.baseAction + '&method=preview',
			text: '正在加载碎片，请稍候…',
			scripts:true,
			params: {blockid: this.tabPanel.getActiveTab().editBlock.blockid}
		});
	},
	exit:function(){
		var p = this.tabPanel.getActiveTab().layout.center.panel.body;
		p.pageCt.style.display = '';
		if(p.blockEditor) p.blockEditor.dom.style.display = 'none';
	},
	history:function(){},
	publishBlock:function(item){
		var fp = this.tabPanel.getActiveTab(),ids=[],blockid;
		if(item.mode){
			ids.push(fp.optBlock.blockid);
		}else{
			var records = this.G.getSelectionModel().getSelections();
			if(!(records.length>0)){EXCMS.msg('提示','请选择要生成的碎片！');return ;}
			if(records.length){
				for(var i=0,len=records.length;i<len;i++){
					if(!(records[i].get('blockid')>0)){this.D.remove(records[i]);continue;}
					ids.push(records[i].get('blockid'));
				}
			}
		}
		fp.body.mask('正在生成碎片，请稍候…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=publishblock',method:'POST',scope:this,params:{blockid:ids.join(',')},
			failure:function(){fp.body.unmask(); EXCMS.msg('提示','碎片生成失败');},
			success:function(r,o){
				fp.body.unmask();
				r = Ext.decode(r.responseText);
				if (r.success) {
					if (item.mode) {
						var p = this.getBlockPanel('preview');
						if(p)this.refreshPriew();
						
					}
					EXCMS.msg('提示', '碎片生成成功');
				}
			}
		});
	},
	publish:function(item){
		var publisheddate = '', data = '', save = 0;
		var params = {blockid:this.tabPanel.getActiveTab().editBlock.blockid};
		if(item.mode == 1 || (!item.mode&&this.getBlockPanel().changed && confirm("碎片数据尚未保存\n保存并生成请点击“确定”按钮;\n生成先前碎片数据请点击“取消”按钮."))){
			data = this.getData();
			if(data.length == 0 && !confirm("空碎片数据警告!\n确定要将碎片数据置空吗?")) return;
			params.data = Ext.encode(data);
			var bp = this.getBlockPanel();
			params.publisheddate = bp.timebox && bp.timebox.checked ? (bp.datePicker.getValue() ? bp.datePicker.getValue().format('U') : '') : '';
			params.save = 1;
		}
		this.getBlockPanel().mask('正在生成碎片…');
		Ext.Ajax.request({
			url:this.baseAction+'&method=publishblock',method:'POST',scope:this,params:params,
			failure:function(){this.getBlockPanel().unmask()},
			success:function(r,o){
				var bp = this.getBlockPanel();
				bp.unmask();
				r = Ext.decode(r.responseText);
				if(r.success){
					if (r.save) {
						this.getBlockPanel().changed = false;
					}
					if (bp.cPanel == 'preview') {this.refreshPriew();}else {bp.preview.isCommitData = true;}
					EXCMS.msg('提示', r.save ? '碎片数据保存并生成成功' : '碎片生成成功');
				}
			}
		});
	}
};
EXCMS.onReady(EXCMS.Block.init,EXCMS.Block);
function initButton(A,C){setCls(A,C+'-hover');if(A.isInit)return;A.isInit=true;A.onmouseout=function(){setCls(this,C+'-hover',1);setCls(this,C+'-click',1)};A.onmousedown=function(){setCls(this,C+'-click')};A.onmouseup=function(){setCls(this,C+'-click',1)}}

function inittab(o,t,n,e,c){
	var tab = $(o);
	var ul = $(o + '-body');
	if(!tab || !ul)return;
	var tabs = tab.getElementsByTagName(t||'li');
	if(!tabs || tabs.length == 0)return;
	tab = tabs[0].parentNode;
	if(n && n.indexOf('.') > 0){
		var t = n.split('.');
		var els = ul.getElementsByTagName(t[0]);
		tab.uls = [];
		for(var i=0,len=els.length;i<len;i++){
			if(els[i].className.split(' ').indexOf(t[1]) >= 0) tab.uls.push(els[i]);
		}
	}else{
		tab.uls = ul.getElementsByTagName(n ? n : 'ul');
	}
	if(!tab.uls)return;
	var cls=c||'current';
	e = e ? e : 'onmouseover';
	tab.lis = tabs;
	for(var i=0;i<tabs.length;i++){
		tabs[i].i=i;
		if(i > 0 && tab.uls[i]) tab.uls[i].style.display = 'none';
		tabs[i][e] = function(){
			var u = this.parentNode;
			var idx = u.act ? u.act : 0;
			setCls(u.lis[idx], cls, true);
			if(u.uls[idx])u.uls[idx].style.display = 'none';
			u.act = this.i;
			setCls(this, cls);
			if(u.uls[this.i])u.uls[this.i].style.display = '';
		}
	}
}