Ext.namespace('Ext.ux');
Ext.ux.CodePress = Ext.extend(Ext.form.TextArea, {
	sourceEl : false,
	code : false,
	language : false,
	url : false,
	autoResize : false,
	initialized : false,
	initComponent : function(){
		Ext.ux.CodePress.superclass.initComponent.call(this);
		if(this.sourceEl) Ext.get(this.sourceEl).hide();
        this.addEvents({initialize:true,activate: true});
	},
	adjustSize : Ext.BoxComponent.prototype.adjustSize,
	onResize : function(D,B,A,C){
		Ext.ux.CodePress.superclass.onResize.call(this,D,B,A,C);
		this.resize();
	},
	resize : function(){
		//console.log('resizing: ' + this.ownerCt.body.dom.clientWidth + 'x' + this.ownerCt.body.dom.clientHeight);
		//var h = (this.height || this.ownerCt.body.dom.clientHeight) +'px';
		//var w = (this.width || this.ownerCt.body.dom.clientWidth) +'px';
		if(!this.iframe) return ;
		var w = parseInt(this.el.dom.style.width) - 30;
		var h = parseInt(this.el.dom.style.height);
		this.iframe.setStyle('height', h - 2 +'px');
		this.iframe.setStyle('width', w +'px');
		h -= Ext.isIE ? 0 : 2;
		this.lineNumber.setStyle('height', h +'px');
    },
	onRender : function(ct, position){
        Ext.ux.CodePress.superclass.onRender.call(this, ct, position);
		if(!Ext.ux.CodePress.path) this.getCodePath();
		//Taken from Ext.form.HtmlEditor
        this.el.dom.style.border = '0 none';
        this.el.dom.setAttribute('tabIndex', -1);
        this.el.addClass('x-hidden');
		
        if(Ext.isIE){ // fix IE 1px bogus margin
            this.el.applyStyles('margin-top:-1px;margin-bottom:-1px;')
        }
        this.wrap = this.el.wrap({
            //cls:'x-html-editor-wrap', cn:{cls:'x-html-editor-tb'}
        });
		
		// Create the iframe
		this.iframe = Ext.get(document.createElement('iframe'));
		this.iframe.dom.className = 'line-iframe';
        this.iframe.src = (Ext.SSL_SECURE_URL || 'javascript:false');
		this.textarea = this.el;
		this.iframe.dom.style.overflow = 'auto';
		this.iframe.dom.frameBorder = 0; // remove IE internal iframe border
        this.wrap.dom.appendChild(this.iframe.dom);
		this.lineNumber = Ext.get(document.createElement('div'));
		this.lineNumber.dom.className = 'line-number';
		this.lineNumber.line = document.createElement('span');
		this.lineNumber.appendChild(this.lineNumber.line);
		this.textarea.dom.parentNode.insertBefore(this.lineNumber.dom, this.iframe.dom);
		this.resize();
		this.edit();
	},
	afterRender : function(){Ext.ux.CodePress.superclass.afterRender.call(this)},
	focus : function(){},
	getCodePath : function() {
		s = document.getElementsByTagName('script');
		for(var i=0,n=s.length;i<n;i++) {
			if(s[i].src.match('Ext.ux.codepress.js')) {
				Ext.ux.CodePress.path = s[i].src.replace('Ext.ux.codepress.js','');
				break;
			}
		}
	},
	initialize : function() {
		this.doc = Ext.isIE ? this.iframe.dom.contentWindow.document : this.iframe.dom.contentDocument;
		this.win = this.iframe.dom.contentWindow;
		this.editor = this.win.CodePress;
		if(this.url){
			Ext.Ajax.request({
				url: this.url
				, method:'get'
				, success:function(response, options){
					var code = response.responseText;
					this.code = code;
					this.editor.setCode(this.code);
				}.createDelegate(this)
			});
		}else{
			this.editor.setCode(this.code || this.textarea.dom.value);
		}
		//this.setOptions();
		this.editor.syntaxHighlight('init');
		this.textarea.dom.style.display = 'none';
		var tthis = this;
		this.editor.scrollLineNum = function(){
			tthis.lineNumber.line.style.top = -tthis.doc.documentElement.scrollTop + 'px';
		}
		this.initialized = true;
		//if(this.autoResize === true) this.resize();
		this.fireEvent('initialize', this);
	},
	edit : function(obj,language) {
		if(obj) this.textarea.dom.value = document.getElementById(obj) ? document.getElementById(obj).value : obj;
		//if(!this.textarea.dom.disabled) return;
		this.language = language ? language : this.getLanguage();
		this.iframe.dom.src = Ext.ux.CodePress.path+'codepress.html?language='+this.language+'&ts='+(new Date).getTime();
		this.iframe.removeListener('load', this.initialize);
		this.iframe.on('load', this.initialize, this);
	},
	getLanguage : function() {
		if(this.language) return this.language;
		for (language in Ext.ux.CodePress.languages) 
			if(this.options.match('\\b'+language+'\\b')) 
				return Ext.ux.CodePress.languages[language] ? language : 'generic';
	},
	setOptions : function() {
		if(this.options.match('autocomplete-off')) this.toggleAutoComplete();
		if(this.options.match('readonly-on')) this.toggleReadOnly();
		if(this.options.match('linenumbers-off')) this.toggleLineNumbers();
	},
	getValue:function(){return this.getCode()},
	setValue:function(v){this.setCode(v)},
	getCode : function() {
		var v = this.editor ? this.editor.getCode() : this.textarea.dom.value;
		if(this.editor) this.textarea.dom.value = v;
		return v;
	},
	setCode : function(v) {
		this.textarea.dom.value = v;
		if(this.editor){
			this.editor.setCode(v);
			this.editor.syntaxHighlight();
		}
	},
	toggleAutoComplete : function() {
		this.editor.autocomplete = (this.editor.autocomplete) ? false : true;
	},
	toggleReadOnly : function() {
		this.textarea.dom.readOnly = (this.textarea.dom.readOnly) ? false : true;
		if(this.iframe.dom.style.display != 'none') // prevent exception on FF + iframe with display:none
			this.editor.readOnly(this.textarea.dom.readOnly ? true : false);
	},
	toggleLineNumbers : function() {
		var cn = this.doc.body.className;
		this.doc.body.className = (cn==''||cn=='show-line-numbers') ? 'hide-line-numbers' : 'show-line-numbers';
	},
	toggleEditor : function() {
		if(this.textarea.dom.disabled) {
			this.textarea.dom.value = this.getCode();
			this.textarea.dom.disabled = false;
			this.iframe.dom.style.display = 'none';
			this.textarea.dom.style.display = 'inline';
		}
		else {
			this.textarea.dom.disabled = true;
			this.setCode(this.textarea.dom.value);
			this.editor.syntaxHighlight('init');
			this.iframe.domstyle.display = 'inline';
			this.textarea.dom.style.display = 'none';
		}
	}
});
Ext.reg('codepress', Ext.ux.CodePress);


	
Ext.ux.CodePress.languages = {	
	csharp : 'C#', 
	css : 'CSS', 
	generic : 'Generic',
	html : 'HTML',
	java : 'Java', 
	javascript : 'JavaScript', 
	perl : 'Perl', 
	ruby : 'Ruby',	
	php : 'PHP', 
	text : 'Text', 
	sql : 'SQL',
	vbscript : 'VBScript'
}