<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Action.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hukuizhi
 * @version $Rev: 673 $
 */
/* $Id: Action.php 673 2010-01-29 03:14:31Z hukuizhi $ */
/**
 * EXCMS 广告管理动作程序
 */
if (!defined('EXCMS') || !defined('EXCMS_ADMIN'))
{
    exit('Access Denied');
}
$IS_AJAX_REQUEST = true;
switch ($method){
	case 'position' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$jsondata['Data'] = $ads->getAdsPositionList();
		$jsondata['success'] = 100;
		break;
	//增加/修改广告位
	case 'commit' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$data = array(
        	'name'		=> 	$_POST['name'],
        	'description' => trim($_POST['description']),
        	'price'     => (int)$_POST['price'],
        	'template'  => $_POST['template'],
        	'width'     => (int)$_POST['width'],
        	'height'    => (int)$_POST['height'],
        	'expire'    => trim($_POST['expire']),
        	'enable'    => $_POST['enable'] ?  1 : 0
        );
        $id = $_POST['id'];
        if($id > 0){
        	$jsondata['success'] = $ads->update($id,$data);
        }else{
        	$jsondata['success'] = $ads->insert($data);
        }
        $jsondata['message'] = '保存成功';
		break;
	//删除广告位
	case 'delete' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$jsondata['success'] = $ads->delete(trim($_POST["id"]));
		$jsondata['message'] = '删除广告位成功';
		break;
	//审批广告位
	case 'enable' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$jsondata['success']= $ads->enable($_POST['id'],$_POST['enable']);
		$jsondata['message'] = '审批广告位成功';
		break;
	//根据ID查询广告位信息
	case 'getById' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$jsondata["Data"] = $ads->getById($_POST["commentid"]);
		$jsondata['success'] = 100;
		break;
	//广告位列表
	case 'store' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$data = array(
			'limit' => $_POST['limit'],
			'start' => $_POST['start'],
			'sort' => $_POST['sort'],
			'dir' => $_POST['dir'],
			'keywords' => $_POST['keywords'],
		);
		$jsondata = $ads->getPaging($data);
		$jsondata["success"] = 100;
		break;
	//广告列表
	case 'adsstore' :
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$data = array(
			'limit' => $_POST['limit'],
			'start' => $_POST['start'],
			'sort' => $_POST['sort'],
			'dir' => $_POST['dir'],
			'keywords' => $_POST['keywords'],
		);
		$jsondata = $ads->getPaging($data);
		$jsondata["success"] = 100;
		break;
	//加载广告数据
	case 'loadAds' :
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$jsondata["data"] = $ads->getById($_POST['id']);
		$jsondata["data"] = array_merge($jsondata["data"],unserialize($jsondata["data"]['content']));
		if($jsondata["data"]['startdate'] > 0)	$jsondata["data"]['startdate'] = formatDate('Y-m-d H:i:s', $jsondata["data"]['startdate']);
		if($jsondata["data"]['enddate'] > 0)	$jsondata["data"]['enddate'] = formatDate('Y-m-d H:i:s', $jsondata["data"]['enddate']);
		$jsondata["success"] = 100;
		break;
	//增加/编辑广告
	case 'commitAds' :
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$type= array(
			'1'=>array('image' => $_POST['image'],'tip'=>$_POST['tip'],'href' => $_POST['href']),
			'2'=>array('flash' => $_POST['url']),
			'3'=>array('content' => $_POST['content']),
			'4'=>array('text' => $_POST['text'],'url' => $_POST['url'])
		);
		$data = array(
			'adid'		=> 	$_POST['adid'],
        	'name'		=> 	$_POST['name'],
        	'description' => trim($_POST['description']),
        	'type'     => (int)$_POST['type'],
        	'content'  => serialize($type[(int)$_POST['type']]),
        	'startdate' => $_POST['startdate'],
        	'enddate'    =>$_POST['enddate']
        );
        $id = $_POST['id'];
        if($id > 0){
        	$jsondata['success'] = $ads->update($id,$data);
        }else{
        	$jsondata['success'] = $ads->insert($data);
        }
        $jsondata['message'] = '保存成功';
		break;
	//删除广告
	case 'deleteAds' :
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$jsondata['success'] = $ads->delete(trim($_POST["id"]));
		$jsondata['message'] = '删除广告成功';
		break;
	//审核
	case 'checked' :
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$jsondata['success'] = $ads->checked($_POST['id'],$_POST['checked']==1 ? true : false);
		$jsondata['message'] = '设置成功';
		break;
	//预览
	case 'preview' :
		include_once ADS_LIB_PATH . 'AdsPosition.class.php';
		$ads = new AdsPosition();
		$position = $ads->getById($_GET['id']);
		include_once ADS_LIB_PATH . 'Ads.class.php';
		$ads = new Ads();
		$ads_array = $ads->getAdsList($_GET['id']);
		if(is_array($ads_array) && count($ads_array) > 0){
			if($position['template']!=''){
				ob_start();
				include(EXCMS::template($position['template']));
				$html = ob_get_contents();
				ob_clean();
			}else{
				include_once LIB_PATH . 'update/ContentFunction.class.php';
				$content = unserialize($ads_array['content']);
				switch ($ads_array['type']){
					case '1' :
						$html = '<a href="'.$content['href'].'"><img src="'.ContentFunction::getThumb($content['image']).'" border="0" width="'.$position['width'].'" height="'.$position['height'].'" alt="'.$content['alt'].'"/></a>';
						break;
					case '2' :
						$html = '<embed height="'.$position['height'].'" width="'.$position['width'].'"  allowscriptaccess="always" wmode="opaque" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" quality="high" src="'.ContentFunction::getThumb($content['flash']).'">';
						break;
					case '3' :
						$html = '<div style="width'.$position['width'].'px;height:'.$position['height'].'px;">'.$content['content'].'</div>';
						break;
					case '4' :
						$html = '<div width="'.$position['width'].'" height="'.$position['height'].'"><a href="'.$content['url'].'">'.$content['text'].'</a></div>';
						break;
				}
			}
		}else{
			$html = '<div style="width'.$position['width'].'px;height:'.$position['height'].'px;">'.$position['expire'].'</div>';
		}
		echo $html;
		exit();
		break;
	//加载设置
	case 'loadsettings':
		$module_array = loadModuleConfig($module_id);
		$jsondata['data']  = EXCMS::jsondecode($module_array['setting']);
		$jsondata['success'] = true;
		break;
}
unset($comment);
EXCMS::json_print($jsondata);
?>