EXCMS.Modules.Ads={
	baseAction : 'index.php?M=Modules&EM=ads&A=Action',
	modulesAction : 'index.php?M=Modules&A=Index&moduleid=ads',
	templateListAction : 'index.php?M=Common&A=TemplatesList',
	init:function(){
	    Ext.QuickTips.init();
	    this.title = _EXCMS_content_config.title;
	    this.render();
		this.grid.getEl().dom.oncontextmenu = function(){return false;}
        this.grid.getEl().dom.onselectstart = function(){return false;}
	},
	active:function(o){
		switch(o){
			case 'position' :
				this.tabPanel.activate(this.positionAdsPanel);
				break;
			case 'ads':
				this.adsManage();
				break;
			case 'help':
				this.helpTab();
				break;
			case 'setting':
				this.settingsTab();
				break;
		}
	},
	render:function(){
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
			items:{xtype:'panel',title:this.title+'菜单',contentEl:'ads-action',collapsible:true,style:'margin-bottom:5px'}
		});
		this.D = new Ext.data.Store({
            reader: new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'id',fields:['id','name','price','template','width','height','enable','description','phpurl']}),
            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=store'}),
            remoteSort:true
        });
		this.soField = new Ext.form.TwinTriggerField({emptyText:'内容,名称',width:240,trigger1Class:'x-form-clear-trigger',trigger2Class:'x-form-search-trigger',onTrigger1Click:this.soOnTrigger1Click.createDelegate(this),onTrigger2Click:this.soOnTrigger2Click.createDelegate(this)});
		this.soField.on('specialkey',function(f,e){if(e.getKey() == e.ENTER){this.soOnTrigger2Click();}},this);
	    this.grid = new Ext.grid.GridPanel({
			region:'center',store:this.D,enableColumnMove:false,collapsible:true,animCollapse:false,border:true,
			sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true,
	        columns: [
	        	{header:"ID",width:60,sortable:true,dataIndex:'id'},
	            {header:'名称',width:150,sortable:false,dataIndex:'name'},
	            {header:'价格',width:80,sortable:false,dataIndex:'price'},
				{header:'模板',width:120,sortable:false,dataIndex:'template'},
	            {header:'宽度',width:80,sortable:false,dataIndex:'width'},
	            {header:'高度',width:80,sortable:false,dataIndex:'height'},
	            {header:'是否启用',width:60,sortable:false,dataIndex:'enable',renderer:this.renderEnable,scope:this},
				{header:'介绍',width:220,sortable:false,dataIndex:'description'}
	        ],
            bbar:new Ext.PagingToolbar({pageSize:25,store:this.D,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
	    });
        
		this.gridMenu = new Ext.menu.Menu({items:[
 			{text:'预览',icon:ico,iconCls:'ico preview',handler:this.browse,scope:this},
 			{text:'添加',icon:ico,iconCls:'ico add',handler:this.addPosition,scope:this,mode:1},
 			{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editPosition,scope:this,mode:0},
            {text:'删除',icon:ico,iconCls:'ico delete',handler:this.delPosition,scope:this},
			{text:'启用',handler:this.enable,scope:this,mode:1}
        ]});
		
        this.grid.on('rowdblclick', function(g,r,e){this.editPosition({mode:0});},this);
		this.grid.on('rowclick', function(g,r,e){
			this.record = g.getStore().getAt(r);
			this.setPostionToolbar(this.record.data.enable);
		},this);
		this.grid.on('rowcontextmenu',function(g,r,e){
			var stm = g.getSelectionModel();
			this.record = g.getStore().getAt(r);
            stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) :stm.selectRow(r);
            this.setPostionToolbar(this.record.data.enable);
            this.gridMenu.showAt(e.getXY());
		},this);
		
		this.positionAdsPanel = new Ext.Panel({title:'广告位管理',layout:'border',border:false,
			tbar:[
				{text:'预览',iconCls:'btnico btn_preview',handler:this.browse,scope:this},
	            {text:'增加',iconCls:'btnico btn_add',handler:this.editPosition,scope:this,mode:1},
	            {text:'编辑',iconCls:'btnico btn_edit',handler:this.editPosition,scope:this,mode:0},
	            {text:'删除',iconCls:'btnico btn_del',handler:this.delPosition,scope:this},
	            {text:'启用',handler:this.enable,scope:this,mode:1},
	            {text:'调用',handler:this.callPosition,scope:this},
	            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.D.reload();},scope:this},
				'->','搜索 ',this.soField
			],
			items:this.grid
		});
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.positionAdsPanel});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
        new Ext.Viewport({layout:'border',items:[actionPanel,this.tabPanel]});
		var request={start:0,limit:25};
        this.D.load({params:request});
	},
	renderEnable:function(v){return v==1 ? '<span style="color:blue" >启用</span>' : '<span style="color:red;">禁用</span>';},
	
	//取消搜索
	soOnTrigger1Click:function(){
		this.soField.reset();
		this.D.baseParams = {contentid:0,checked:3,keywords:''};
		this.D.reload();
	},
	//搜索
	soOnTrigger2Click:function(){
	    var keywords = this.soField.getValue().trim();
	    if(keywords != ''){
	        this.D.baseParams.keywords = keywords;
	        this.D.reload();
	    }
	},
	//浏览原文
	browse : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(selected.length != 1){
			alert('请选择一个广告位！');return;
		}
		EXCMS.util.RequestUrl('index.php',{M:'Modules',EM:'ads',A:'Action',method:'preview',id:this.record.id});
	},
	//增加/编辑广告位
	editPosition : function(item){
		var title = '';
		if(item.mode){
			title = '增加广告位';
		}else{
			if(this.record) title = this.record.get('name'); else {alert('请选择广告位后再进行编辑！'); return ;}
		}
		if(!this.positionWin){
			this.template = new Ext.form.ComboBox({fieldLabel:'广告位模板',hiddenName:'template',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
				valueField:'id',displayField:'name',emptyText:'选择广告位模板',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.templateListAction + '&cate=ads&module=ads'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true})
			}),
			this.positionPanel = new Ext.form.FormPanel({labelWidth:80,autoScroll:false,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
				{name:'id',xtype:'hidden'},
				{fieldLabel:'广告位名称',name:'name',allowBlank:false,blankText:'广告位名称不能为空'},
				{fieldLabel:'广告位价格',name:'price',anchor:'50%'},
				{xtype:'label',text:'元/天',style:'position:absolute;margin:-22px 0 0 250px;'},
				this.template,
				{fieldLabel:'广告位宽度',name:'width',anchor:'30%',xtype:'numberfield'},
				{xtype:'label',text:'像素(px)',style:'position:absolute;margin:-22px 0 0 150px;'},
				{fieldLabel:'广告位高度',name:'height',anchor:'30%',xtype:'numberfield'},
				{xtype:'label',text:'像素(px)',style:'position:absolute;margin:-22px 0 0 150px;'},
				{xtype:'textarea',fieldLabel:'广告位描述',name:'description',height:60},
				{fieldLabel:'过期显示内容',xtype:'textarea',name:'expire',height:60},
				{fieldLabel:'是否启用',xtype:'checkbox',boxLabel:'是',name:'enable'}
			]});
			this.positionWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:370,closeAction:'hide',plain: true,
	            items:this.positionPanel,
	            buttons:[{text:'确定',handler:this.savePosition,scope:this},{text:'取消',handler:function(){this.positionWin.hide()},scope:this}]
	        });
	        this.positionPanel.form.on('actioncomplete',function(form,action){
				this.positionPanel.el.unmask();
				if(action.result.success){
					this.positionWin.hide();
					this.D.reload();
				}
			}, this);
		}
		this.positionWin.setTitle(title);
		this.positionWin.show();
		if(item.mode){
			this.positionPanel.form.reset();
		}else{
			this.positionPanel.form.setValues(this.record.data);
		}
	}	,
	//保存广告位
	savePosition  : function(){
		if(!this.positionPanel.form.isValid()){alert("表单中有错误，请检查红线处的错误提示");return ;}
		this.positionPanel.el.mask('正在保存, 请稍侯...');
	    this.positionPanel.form.submit({url:this.baseAction +'&method=commit'});
	},
	//删除广告位
	delPosition : function(){
		var selected = this.grid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
        Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的记录吗？",function(optional){if(optional=='yes'){
		  Ext.Ajax.request({url:this.baseAction + '&method=delete',method:'post',scope:this,
			  params:{id:id.join(',')},
			  success:function(r,o){r = jsonReturn(r);this.D.reload();}
		  })}
        },this);
	},
	//设置工具条
	setPostionToolbar : function(falg){
		if(falg == '1'){
			this.positionAdsPanel.getTopToolbar().items.items[4].setText('禁用');
			this.positionAdsPanel.getTopToolbar().items.items[4].mode = 0;
			this.gridMenu.items.items[4].setText('禁用');
			this.gridMenu.items.items[4].mode = 0;
		}else{
			this.positionAdsPanel.getTopToolbar().items.items[4].setText('启用');
			this.positionAdsPanel.getTopToolbar().items.items[4].mode = 1;
			this.gridMenu.items.items[4].setText('启用');
			this.gridMenu.items.items[4].mode = 1;
		}
	},
	//启用/禁用	
	enable : function(item){
		var selected = this.grid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择一条或多条记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
		Ext.Ajax.request({url:this.baseAction + '&method=enable',method:'post',scope:this,
			params:{id:id.join(','),enable:item.mode},
			success:function(r,o){
				r = jsonReturn(r);
				this.setPostionToolbar(item.mode);
				this.D.reload();
			}
		});
	},
	//调用
	callPosition : function(){
		if(this.record && this.record.id > 0){
			if(!this.callPanel){
				this.callPanel = new Ext.form.FormPanel({title:'广告位代码调用',labelWidth:80,border:false,defaults:{xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',closeAction:'hide',closable:true,items:[	
					{fieldLabel:'PHP动态调用',width:'450',name:'name'},
					{xtype:'button',text:'复制',style:'position:absolute;margin:-25px 0 0 550px;', listeners:{click:function(){
						this.copyToClipboard(this.callPanel.form.items.items[0].getValue());
					},scope:this}},
					{xtype:'button',text:'预览',style:'position:absolute;margin:-25px 0 0 600px;',listeners:{click:function(){
						EXCMS.util.RequestUrl('index.php',{M:'Modules',EM:'ads',A:'Action',method:'preview',id:this.record.id});
					},scope:this}},
					{xtype:'label',style:'position:absolute;margin:10 0 0 0px;color:red;',text:'说明：PHP动态调用方式一对服务器环境无特殊要求，可统计广告展示次数和自动判断广告是否过期，但是消耗服务器资源，访问速度慢，不支持Google等JS类代码广告；'}
				]});
				this.tabPanel.add(this.callPanel);
			}
			this.tabPanel.unhideTabStripItem(this.callPanel);
		    this.tabPanel.activate(this.callPanel);
		    var value = "<script language=\"javascript\" src=\""+this.record.data.phpurl+"\"></script>";
			this.callPanel.form.items.items[0].setValue(value);
		}else{
			alert('请您选择广告位!');
		}
	},
	// 剪切板复制
	copyToClipboard : function(txt) { 
		if(window.clipboardData) { 
			window.clipboardData.clearData(); 
			window.clipboardData.setData("Text",txt); 
		} else if(navigator.userAgent.indexOf("Opera")!= -1) { 
			window.location = txt; 
		} else if (window.netscape) { 
			try { 
				netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect"); 
			} catch (e) { 
				alert("您的firefox安全限制限制您进行剪贴板操作.\n请打开'about:config'将signed.applets.codebase_principal_support'设置为true'之后重试"); 
				return false; 
			} 
			var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard); 
			if (!clip)  return; 
			var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable); 
			if (!trans)  return; 
			trans.addDataFlavor('text/unicode'); 
			var str = new Object(); 
			var len = new Object(); 
			var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString); 
			var copytext = txt; 
			str.data = copytext; 
			trans.setTransferData("text/unicode",str,copytext.length*2); 
			var clipid = Components.interfaces.nsIClipboard; 
			if (!clip) 
			return false; 
			clip.setData(trans,null,clipid.kGlobalClipboard); 
		}
		alert('链接已经复制');
	},
	//广告管理
	adsManage : function(){
		if(!this.adsgrid){
			this.adsMenu = new Ext.menu.Menu({items:[
	 			{text:'浏览原文',icon:ico,iconCls:'ico preview',handler:this.browse,scope:this},
	 			{text:'增加',icon:ico,iconCls:'ico add',handler:this.editAds,scope:this,mode:1},
	 			{text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editAds,scope:this,mode:0},
	            {text:'删除',icon:ico,iconCls:'ico delete',handler:this.delAds,scope:this},'-',
	            {text:'审核',menu:{items:[
					{text:'通过',group:'checked',checked:true,handler:this.checked,scope:this,mode:1},
					{text:'不通过',group:'checked',checked:false,handler:this.checked,scope:this,mode:2}
	            ]}}
	            
	        ]});
			this.adsD = new Ext.data.Store({
	            reader: new Ext.data.JsonReader({root:'data',totalProperty:'total',id:'id',fields:['id','adname','name','type','startdate','enddate','checked','description']}),
	            proxy : new Ext.data.HttpProxy({url:this.baseAction + '&method=adsstore'}),
	            remoteSort:true
	        });
			this.adsgrid = new Ext.grid.GridPanel({
				region:'center',store:this.adsD,enableColumnMove:false,collapsible:true,animCollapse:false,border:true,title:'广告管理',	
				sm:new Ext.grid.RowSelectionModel(),border:false,loadMask:true,closeAction:'hide',closable:true,
				tbar:[
		            {text:'增加',iconCls:'btnico btn_add',handler:this.editAds,scope:this,mode:1},
		            {text:'编辑',iconCls:'btnico btn_edit',handler:this.editAds,scope:this,mode:0},
		            {text:'删除',iconCls:'btnico btn_del',handler:this.delAds,scope:this},'-',
		            {text:'审核',menu:{items:[
						{text:'通过',group:'checked',checked:true,handler:this.checked,scope:this,mode:1},
						{text:'不通过',group:'checked',checked:false,handler:this.checked,scope:this,mode:2}
		            ]}},
		            {text:'选择',menu:{items:[
						 {text:'全选',handler:this.recordsSelect,scope:this,mode:1},
						 {text:'反选',handler:this.recordsSelect,scope:this,mode:2},
						 {text:'取消选择',handler:this.recordsSelect,scope:this,mode:3}
					]}},
		            {text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.adsD.reload();},scope:this}
				],
		        columns: [
		        	{header:"ID",width:60,sortable:true,dataIndex:'id'},
		            {header:'名称',width:200,sortable:true,dataIndex:'name'},
		            {header:'广告位',width:120,sortable:true,dataIndex:'adname'},
					{header:'广告类型',width:120,sortable:true,dataIndex:'type',renderer:this.renderAdsType,scope:this},
		            {header:'开始时间',width:130,sortable:true,dataIndex:'startdate'},
		            {header:'结束时间',width:130,sortable:true,dataIndex:'enddate'},
		            {header:'审核',width:60,sortable:true,dataIndex:'checked',renderer:this.renderChecked,scope:this},
					{header:'介绍',width:220,sortable:true,dataIndex:'description'}
		        ],
	            bbar:new Ext.PagingToolbar({pageSize:25,store:this.adsD,displayInfo:true,displayMsg:'当前显示：{0} - {1} 总记录：{2}',emptyMsg:"暂时没有数据",beforePageText:"第",afterPageText:"页 共{0}页"})
		    });
		    this.adsgrid.on('rowdblclick', function(g,r,e){this.editAds({mode:0});},this);
			this.adsgrid.on('rowclick', function(g,r,e){this.ads_record = g.getStore().getAt(r);},this);
			this.adsgrid.on('rowcontextmenu',function(g,r,e){
				var stm = g.getSelectionModel();
				this.ads_record = g.getStore().getAt(r);
	            stm.getSelections().indexOf(g.getStore().getAt(r)) != -1 ? stm.selectRow(r, true) :stm.selectRow(r);
	            this.adsMenu.showAt(e.getXY());
			},this);
		    this.tabPanel.add(this.adsgrid);
		}
		
		this.tabPanel.unhideTabStripItem(this.adsgrid);
	    this.tabPanel.activate(this.adsgrid);
	    this.adsgrid.getEl().dom.oncontextmenu = function(){return false;}
		this.adsgrid.getEl().dom.onselectstart = function(){return false;}
        this.adsD.load();
	},
	renderAdsType:function(v){var d=['图片','FLASH','文本','文字链'];return v>0&&v<5?d[v-1]:d[2]},
	renderChecked:function(v){var r=['<span class="ccheck ccheck_w" title="待审核"></span>','<span class="ccheck" title="已审核"></span>','<span class="ccheck ccheck_u" title="审核未通过"></span>'];v = v >= 0 && v<= 2  ? v : -1; return r[v]},
	//设置显示变量类型
	setVisibleAds:function(type){
		type = type > 0 && type < 5 ? type : 1;
		var t1 = '5,6,7',t2='8',t3='9',t4='10,11';
		for(var i=5;i<12;i++){
			switch(parseInt(type)){
				case 1 :
					this.adsPanel.form.items.items[i].container.dom.parentNode.style.display = t1.indexOf(i) == -1 ? 'none' : '';
					break;
				case 2 :
					this.adsPanel.form.items.items[i].container.dom.parentNode.style.display = t2.indexOf(i) == -1 ? 'none' : '';
					break;
				case 3 :
					this.adsPanel.form.items.items[i].container.dom.parentNode.style.display = t3.indexOf(i) == -1 ? 'none' : '';
					break;
				case 4 :
					this.adsPanel.form.items.items[i].container.dom.parentNode.style.display = t4.indexOf(i) == -1 ? 'none' : '';
					break;
			}
		}
	},
	//增加/编辑广告
	editAds : function(item){
		var title = '';
		if(item.mode){
			title = '增加广告';
		}else{
			if(this.ads_record) title = this.ads_record.get('name'); else {alert('请选择广告后再进行编辑！'); return ;}
		}
		if(!this.adsWin){
			this.ads_position = new Ext.form.ComboBox({fieldLabel:'广告位',hiddenName:'adid',maxHeight:200,editable:false,waitMsgTarget:true,typeAhead:true,triggerAction:'all',
				valueField:'id',displayField:'name',emptyText:'选择广告位',allowBlank:false,blankText:'广告位不能为空',selectOnFocus:true,store:new Ext.data.Store({proxy:new Ext.data.HttpProxy({url:this.baseAction + '&method=position'}),reader:new Ext.data.JsonReader({root:'Data',id:'id'},['id','name']),remoteSort:true})
			}),
			this.adsPanel = new Ext.form.FormPanel({labelWidth:80,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
				{name:'id',xtype:'hidden'},
				this.ads_position,
				{fieldLabel:'广告名称',name:'name',allowBlank:false,blankText:'广告名称不能为空'},
				{fieldLabel:'广告描述',xtype:'textarea',name:'description',height:60},
				{fieldLabel:'广告类型',xtype:'radiogroup',items:[
					{boxLabel:'图片',name:'type',inputValue:1,checked:true},
					{boxLabel:'FLASH',name:'type',inputValue:2},
					{boxLabel:'文本',name:'type',inputValue:3},
					{boxLabel:'文字链',name:'type',inputValue:4}
				]},
				{fieldLabel:'图片',name:'image',xtype:'resourcefield',rtype:'image',nid:1},
				{fieldLabel:'图片提示',name:'tip'},
				{fieldLabel:'图片链接地址',name:'href'},
				{fieldLabel:'FLASH地址',name:'flash',xtype:'resourcefield',rtype:'file',nid:7},
				{fieldLabel:'广告内容',xtype:'textarea',name:'content',height:60},
				{fieldLabel:'链接内容',name:'text'},
				{fieldLabel:'链接地址',name:'url'},
				{fieldLabel:'开始日期',xtype:'datetimefield',anchor:'50%',name:'startdate'},
				{fieldLabel:'结束日期',xtype:'datetimefield',anchor:'50%',name:'enddate'}
			]});
			this.adsWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:550,height:370,closeAction:'hide',plain: true,
	            items:this.adsPanel,
	            buttons:[{text:'确定',handler:this.saveAds,scope:this},{text:'取消',handler:function(){this.adsWin.hide()},scope:this}]
	        });
	        this.adsPanel.form.on('actioncomplete',function(form,action){
				this.adsPanel.el.unmask();
				if(action.result.success){
					this.adsWin.hide();
					this.adsD.reload();
				}
			}, this);
		}
		this.adsWin.setTitle(title);
		this.adsWin.show();
		this.adsPanel.form.items.items[4].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisibleAds(s.inputValue)}},this);},this);
		if(item.mode){
			this.adsPanel.form.reset();
			this.setVisibleAds(1);
		}else{
			this.adsPanel.el.mask('正在加载数据');
			Ext.Ajax.request({url:this.baseAction + '&method=loadAds',method:'post',scope:this,
				params:{id:this.ads_record.id},
				success:function(r,o){
					this.adsPanel.el.unmask();
					r = jsonReturn(r);
					this.adsPanel.form.setValues(r.data);
					this.setVisibleAds(r.data.type);
				}
			});
		}
	},
	//保存广告
	saveAds  : function(){
		if(!this.adsPanel.form.isValid()){alert("表单中有错误，请检查红线处的错误提示");return ;}
		this.adsPanel.el.mask('正在保存, 请稍侯...');
	    this.adsPanel.form.submit({url:this.baseAction +'&method=commitAds'});
	},
	//删除广告
	delAds : function(){
		var selected = this.adsgrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择要删除的记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
        Ext.MessageBox.confirm('确定记录删除',"您确实要删除所选的记录吗？",function(optional){if(optional=='yes'){
		  Ext.Ajax.request({url:this.baseAction + '&method=deleteAds',method:'post',scope:this,
			  params:{id:id.join(',')},
			  success:function(r,o){r = jsonReturn(r);if(r.success)this.adsD.reload();}
		  })}
        },this);
	},
	//设置审核
	checked : function(item){
		var selected = this.adsgrid.getSelectionModel().getSelections();
		if(!(selected.length>0)){alert('请选择记录');return ;}
		var id=[];
		if(selected.length){for(var i=0,len=selected.length;i<len;i++)id.push(selected[i].id)}
		Ext.Ajax.request({url:this.baseAction + '&method=checked',method:'post',scope:this,
		  params:{id:id.join(','),checked:item.mode},
		  success:function(r,o){r = jsonReturn(r);if(r.success)this.adsD.reload();}
		});
	},
	//记录选择
	recordsSelect :function(item){
		 var mode = item && item.mode ? item.mode :1;
		 switch(item.mode){
			 case 1 :this.adsgrid.getSelectionModel().selectAll(); break;
			 case 2:for (var i = 0; i < this.D.getCount(); i++) this.adsgrid.getSelectionModel().isSelected(i) ? this.adsgrid.getSelectionModel().deselectRow(i) :this.adsgrid.getSelectionModel().selectRow(i, true);break;
			 case 3 :this.adsgrid.getSelectionModel().clearSelections(); break;
		 }
	},
	//广告设置
	settingsTab : function(){
		if(!this.settingGrid){
			this.settingD = new Ext.data.Store({proxy : new Ext.data.HttpProxy({url:this.modulesAction+'&method=settingStore'}),
	            reader: new Ext.data.JsonReader({root: 'data',totalProperty: 'total',id: 'id',
	                fields:["id","name","moduleid","_moduleid","value","group","description",{name:'type',type:'int'},"sort",{name:'issystem',type:'int'}]
	            }),remoteSort:false
	        });
			this.settingGrid = new Ext.grid.EditorGridPanel({title:'广告设置',store:this.settingD,closable:true,closeAction:'hide',
				minColumnWidth:2,autoExpandColumn:3,border:false,sm:new Ext.grid.RowSelectionModel(),
	            columns:[
					new Ext.grid.RowNumberer(),
					{header:"变量名",width:150,sortable:true,dataIndex:'name'},
					{header:"变量值",width:220,sortable:true,dataIndex:'value',renderer:this.renderValue,scope:this},
					{header:"描述",width:150,sortable:true,dataIndex:'description'},
					{header:"数据类型",width:80,sortable:true,dataIndex:'type',renderer:this.renderType,scope:this},
					{header:"系统变量?",width:70,align:'center',sortable:true,dataIndex:'issystem',renderer:this.renderIsSys,scope:this},
					{header:'排序',width:60,sortable:true,align:'right',dataIndex:'sort',editor: new Ext.form.NumberField({minValue:0,maxValue:10000})}
				],
				tbar:[
					{text:'新建',iconCls:'btnico btn_add',handler:this.editSetting,scope:this,mode:0},
					{text:'编辑',iconCls:'btnico btn_edit',handler:this.editSetting,scope:this,mode:1},
					{text:'删除',iconCls:'btnico btn_del',handler:this.delSetting,scope:this},'-',
					{text:'刷新',iconCls:'btnico btn_fresh',handler:function(){this.settingD.reload()},scope:this}
				]
			});
			
			this.settingGridMenu = new Ext.menu.Menu({items:[
	            {text:'新建',icon:ico,iconCls:'ico add',handler:this.editSetting,scope:this,mode:0},
	            {text:'编辑',icon:ico,iconCls:'ico edit',handler:this.editSetting,scope:this,mode:1},
	            {text:'删除',icon:ico,iconCls:'ico del',handler:this.delSetting,scope:this}
	        ]}); 
			
			this.settingGrid.on('celldblclick',function(g,r,c,e){if(c!=6){this.settingRecord=this.settingD.getAt(r);this.editSetting({mode:1});}},this);
			this.settingGrid.on('rowcontextmenu',function(g,r,e){var s=g.getSelectionModel();s.getSelections().indexOf(g.getStore().getAt(r))!= -1?s.selectRow(r,true):s.selectRow(r);this.settingRecord=this.settingD.getAt(r);this.settingGridMenu.showAt(e.getXY())},this);
			this.settingGrid.on('afteredit',this.saveSettingSort,this);
			this.tabPanel.add(this.settingGrid);
			this.tabPanel.activate(this.settingGrid);
			this.settingGrid.getEl().dom.oncontextmenu = function(){return false;}
			this.settingGrid.getEl().dom.onselectstart = function(){return false;}
	        this.settingD.load();
		}
		this.tabPanel.unhideTabStripItem(this.settingGrid);
		this.tabPanel.activate(this.settingGrid);
	},
	
	editSetting : function(item){
		var title;
		if(item.mode==1){
			this.settingRecord = this.settingGrid.getSelectionModel().getSelected();
			if(this.settingRecord){title ='修改 '+ this.settingRecord.get('name');}else{alert('请选择要编辑的变量');return ;}
		}else{title='新建变量';}
		if(!this.editSettingWin){
				this.settingformPanel = new Ext.form.FormPanel({labelWidth:60,autoScroll:true,border:false,defaults:{anchor:'-20',xtype:'textfield'},layout:'form',bodyStyle:'padding:10px 0px 0px 10px;',items:[	
					{name:'id',xtype:'hidden'},{name:'issystem',xtype:'hidden'},
					{fieldLabel:'变量名',name:'name',allowBlank:false,blankText:'变量名不能为空'},
					{fieldLabel:'变量类型',xtype:'radiogroup',items:[
						{boxLabel:'布尔型',name:'type',inputValue:1},
						{boxLabel:'数字',name:'type',inputValue:2},
						{boxLabel:'文本',name:'type',inputValue:3,checked:true},
						{boxLabel:'多行文本',name:'type',inputValue:4}
					]},
					{fieldLabel:'变量值',xtype:'radiogroup',items:[
						{boxLabel:'是',name:'value',inputValue:1,checked:true},
						{boxLabel:'否',name:'value',inputValue:0}
					]},
					{fieldLabel:'变量值',name:'value1',xtype:'numberfield'},
					{fieldLabel:'变量值',name:'value2'},
					{fieldLabel:'变量值',name:'value3',xtype:'textarea'},
					{xtype:'textarea',fieldLabel:'描述',name:'description',height:60},
					{xtype:'numberfield',fieldLabel:'排序',value:100,name:'sort',maxLength:6,anchor:'30%'}
				]});
				
	            this.editSettingWin=new Ext.Window({layout:'fit',modal:false,resizable:false,width:520,height:330,closeAction:'hide',plain: true,
	                items:this.settingformPanel,
	                buttons:[{text:'确定',handler:this.saveSetting,scope:this},{text:'取消',handler:function(){this.editSettingWin.hide()},scope:this}]
	            });
	            this.settingformPanel.form.on('actioncomplete',function(form,action){
	                if(action.result.success){this.editSettingWin.hide();this.settingD.reload();}
	            }, this);
		}
		this.editSettingWin.setTitle(title);
		this.editSettingWin.show();
		this.settingformPanel.form.items.items[3].items.each(function(f){f.on('check',function(s,c){if(c){this.setVisible(s.inputValue)}},this);},this);

		if(item.mode==1){
			var data = this.settingRecord.data;
        	this.settingformPanel.form.setValues(data);
			this.setValue(data.type, data.value);
			this.setDisabled(data.issystem);
			this.setVisible(data.type);
		}else{
            this.settingformPanel.form.reset();
			this.setDisabled();
			this.setVisible(3);
		}
	},
	
	saveSetting : function(){
		if(!this.settingformPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		var act = this.settingformPanel.form.items.items[0].getValue() == '' ? '&method=settingInsert' : '&method=settingUpdate';
		var type = this.settingformPanel.form.items.items[3].getValue();
		var name = this.settingformPanel.form.items.items[2].value;
		this.settingformPanel.form.submit({url:this.modulesAction+act,params: {type: type,name: name}});
	},
	
	saveSettingSort : function(){
		var records = this.settingD.getModifiedRecords();
		var data=[];
		for(var i=0;i<records.length;i++){
			data.push({id:records[i].data.id,sort:records[i].data.sort});
		}
		if(data.length > 0){
			Ext.Ajax.request({url:this.modulesAction+'&method=updateSettingSort',method:'post',scope:this,
				params:{data:Ext.util.JSON.encode(data)},
				failure:function(){alert("保存排序出错，请重试");},
				success:function(r,o){
					r=jsonReturn(r);
					if (r.success) {
						this.settingD.commitChanges();
					}
				}
			});
		}
	},
	
	//删除系统变量
	delSetting:function(){
        var records = this.settingGrid.getSelectionModel().getSelections();
        var flag = false
        if(records.length > 0){
			var ids=[]
            for(var i=0,len=records.length;i<len; i++){
            	if(records[i].data.issystem) {flag = true;break;}
            	ids.push(records[i].id);
            }
        }else{
			alert('请选择要删除的变量');
			return ;
		}
        if(flag){alert('模块系统变量不允许删除！');return;}
       	if(confirm('您确实要删除选定的记录吗？')){
			Ext.Ajax.request({
				url:this.modulesAction + '&method=settingDelete',method:'POST', params:{ids:ids.join(',')},scope:this,
				success:function(r,o){
					r=jsonReturn(r);
					if(r.success){this.settingD.reload();}
				}
			});
        }
	},
	
	setDisabled : function(issystem){
		for(var i=1;i<4;i++){
			this.settingformPanel.form.items.items[i].setDisabled(issystem=='1'?true:false);
		}
	},
	
	renderType:function(v){var d=['布尔型','数字','文本','多行文本'];return v>0&&v<5?d[v-1]:d[2]},
	renderIsSys:function(v){return v=='1'?'<font color=red>是</font>':'<font color=green>否</font>'},
	renderValue:function(v,m,r){return r.get('type')==1?(v==1?"<font color='green'>是</font>":"<font color='red'>否</font>"):v},
	
	//设置显示变量类型
	setVisible:function(type){
		type = type > 0 && type < 5 ? type : 3;
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].container.dom.parentNode.style.display = (type + 3) == i ? '' : 'none';
		}
	},
	setValue:function(type, value){
		for(var i=4;i<8;i++){
			this.settingformPanel.form.items.items[i].setValue((type + 3) == i ? value : '');
		}
	},
	//广告帮助
	helpTab : function(){
		if(!this.helpPanel){
			var html = '<iframe src="/ads/help/help.html" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>';
			this.helpPanel = new Ext.Panel({title:'帮助',border:false,autoScroll:true,closable:true,closeAction:'hide',html:html});
			this.tabPanel.add(this.helpPanel);
		}
		this.tabPanel.unhideTabStripItem(this.helpPanel);
		this.tabPanel.activate(this.helpPanel);
	},
	rendererCmt:function(v){
		v = v.replace(/<\/?\w+((\s+\w+(\s*=\s*(?:".*?"|\'.*?\'|[^\'">\s]+))?)+\s*|\s*)\/?>/g, '');
		v = v.replace("\n",'');
		v = v.replace("\r",'');
		if(v.length > 50){v = v.substr(0,50) + '...';}
		return v;
	}
};
EXCMS.onReady(EXCMS.Modules.Ads.init,EXCMS.Modules.Ads);