<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		Ads.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 * @version $Rev: 498 $
 */
/* $Id: Ads.class.php 498 2010-01-12 12:38:30Z zhanghaisong $ */
/**
 * EXCMS 广告
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 */
class Ads
{
    /**
     * 广告数据库表
     *
     * @access private
     * @var string
     */
    private $table = 'ads';
    /**
     * 构造函数
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * 兼容PHP4构造函数
     *
     */
    function Ads ()
    {
        $this->__construct();
    }
    /**
     * 获取指定ID广告内容
     *
     * @param integet $id 广告ID
     * @return array 广告数组
     */
    function getById ($id)
    {
        if (! ($id > 0)) {
            throw_exception('LACK_ADS_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * 添加广告
     *
     * @param array $data
     * @return integer 广告ID
     */
    function insert ($data)
    {
        if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
        if(!($data['adid'] > 0)){
        	throw_exception('LACK_ADSPOSITION_ID');
        }
        global $EXCMS_MODULE;
        $data = array(
        	'adid'  => $data['adid'],
        	'name' => $data['name'],
        	'description' => $data['description'],
        	'type'       => (int)$data['type'],
        	'content'    => $data['content'],
        	'startdate'  => $data['startdate'] ? strtotime(time($data['startdate'])) : '',
        	'enddate'     => $data['enddate'] ? strtotime(time($data['enddate'])) : '',
        	'checked'    => $EXCMS_MODULE['ads']['check'] ? 1 : 0
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->insert_id();
    }
    /**
     * 更新广告
     *
     * @param integer $id
     * @param array $data
     * @return boolean
     */
    public function update($id,$data){
    	if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
     	if(!($data['adid'] > 0)){
        	throw_exception('LACK_ADSPOSITION_ID');
        }
        $data = array(
        	'name' => $data['name'],
        	'adid'  => $data['adid'],
        	'description' => $data['description'],
        	'type'       => (int)$data['type'],
        	'content'    => $data['content'],
        	'startdate'  => $data['startdate'] ? strtotime($data['startdate']) : '',
        	'enddate'     => $data['enddate'] ? strtotime($data['enddate']) : ''
        );
        $set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(", ", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `id` = '{$id}' LIMIT 1";
		return $GLOBALS['db']->query($sql);
    }
    /**
     * 删除指定ID
     *
     * @param string|integer|array $id 广告ID
     * @return boolean
     */
    function delete ($id)
    {
        $id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADS_ID');
        }
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 审核通过
     *
     * @param integer $id
     * @param boolean $checked
     * @return boolean
     */
    public function checked($id,$checked=true){
    	$id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADS_ID');
        }
        $checked = $checked ? 1 : 2;
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `checked` = '{$checked}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 根据广告位ID获取广告
     *
     * @param integer $adid
     * @return array
     */
    public function getAdsList($adid){
    	if (!($adid > 0)) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $time = time();
        $sql = "SELECT * FROM {$this->table} WHERE `adid` = '{$adid}' AND `startdate` <= '{$time}' AND `enddate` >= '{$time}' ORDER BY id DESC LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * 获取广告列表
     *
     * @param array $paging 分页数组
     * <ul>
     * <li>integer $paging['limit'] 分页大小 default 0</li>
     * <li>integer $paging['start'] 分页起始大小 default 0</li>
     * <li>integer $paging['total'] 总数 default 0</li>
     * <li>integer $paging['sort'] 排序字段</li>
     * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
     * <li>integer $paging['keyword'] 搜索关键字</li>
     * </ul>
     * @return array Paging 数组
     * <ul> 
     * <li> $array['total'] 总数 </li>
     * <li> $array['data'] 分页数据 </li>
     * </ul>
     */
    function getPaging ($paging = array())
    {
        $keyword = trim($paging['keywords']);
        if (!empty($keyword)) {
            $where = " AND (`name` like '%{$keyword}%' OR `description` like '%{$keyword}%') ";
        } 
             	if (! isset($paging['total'])) {
	        $sql = "SELECT COUNT(*) as `total` FROM {$this->table} WHERE 1 {$where} ";
	        $GLOBALS['db']->query($sql);
	        $rs = $GLOBALS['db']->fetch();
	        $total = $rs['total'];
     	}else{
     		$total = (int)$paging['total'];
     	}
        $rs = array();
        if($total > 0){
        	$orderby = "ORDER BY `id` DESC";
	        $start = (int) $paging['start'];
	        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
	        $limit = "LIMIT {$start}, {$limit}";
	        $sql = "SELECT * FROM {$this->table} WHERE 1 {$where} {$orderby} {$limit}";
	        	        $GLOBALS['db']->query($sql);
	        $rs = $GLOBALS['db']->fetchAll();
	        if(is_array($rs) && count($rs)){
	        	include_once ADS_LIB_PATH . 'AdsPosition.class.php';
	        	$ads = new AdsPosition();
		        foreach ($rs as $key=>$value){
		        	if($value['adid'] > 0){
		        		$ads_array = $ads->getById($value['adid']);
		        		$rs[$key]['adname'] = $ads_array['name'];
		        		$rs[$key]['startdate'] = formatDate('Y-m-d H:i:s', $value['startdate']);
		        		$rs[$key]['enddate'] = formatDate('Y-m-d H:i:s', $value['enddate']);
		        	}
		        }
	        }
        }
        return array('total' => $total , 'data' => $rs);
    }
}
?>