<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		AdsPosition.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 * @version $Rev: 498 $
 */
/* $Id: AdsPosition.class.php 498 2010-01-12 12:38:30Z zhanghaisong $ */
/**
 * EXCMS 广告位
 * @category EXCMS
 * @package content
 * @author $Author: zhanghaisong $
 */
class AdsPosition
{
    /**
     * 广告位数据库表
     *
     * @access private
     * @var string
     */
    private $table = 'ads_position';
    /**
     * 构造函数
     *
     */
    function __construct ()
    {
        $this->table = TABLE_PREFIX . $this->table;
    }
    /**
     * 兼容PHP4构造函数
     *
     */
    function AdsPosition ()
    {
        $this->__construct();
    }
    /**
     * 获取指定ID广告内容
     *
     * @param integet $id 广告位ID
     * @return array 广告位数组
     */
    function getById ($id)
    {
        if (! ($id > 0)) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $sql = "SELECT * FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->fetch();
    }
    /**
     * 添加广告位
     *
     * @param array $data
     * @return integer 广告位ID
     */
    function insert ($data)
    {
        if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
        $data = array(
        	'name' => $data['name'],
        	'description' => $data['description'],
        	'price'       => (int)$data['price'],
        	'template'  => $data['template'],
        	'width'       => (int)$data['width'],
        	'height'    => (int)$data['height'],
        	'expire'    => $data['expire'],
        	'enable'     => $data['enable'] ?  1 : 0
        );
        $sql = "INSERT INTO `{$this->table}` (`" . implode("`, `", array_keys($data)) . "`) VALUES('" . implode("', '", array_values($data)) . "')";
                $GLOBALS['db']->query($sql);
        return $GLOBALS['db']->insert_id();
    }
    /**
     * 更新广告位
     *
     * @param integer $id
     * @param array $data
     * @return boolean
     */
    public function update($id,$data){
    	if (trim($data['name']) == '') {
            throw_exception('LACK_ADS_NAME');
        }
        $data = array(
        	'name' 			=> 	$data['name'],
        	'description' => $data['description'],
        	'price'       => (int)$data['price'],
        	'template'  => $data['template'],
        	'width'       => (int)$data['width'],
        	'height'    => (int)$data['height'],
        	'expire'    => $data['expire'],
        	'enable'     => $data['enable'] ?  1 : 0
        );
        $set = array();
		foreach($data as $k => $v){
			$set[] = "`{$k}` = '{$v}'";
		}
		$set = implode(", ", $set);
		$sql = "UPDATE `{$this->table}` SET {$set} WHERE `id` = '{$id}' LIMIT 1";
		return $GLOBALS['db']->query($sql);
    }
    /**
     * 删除指定ID
     *
     * @param string|integer|array $id 广告ID
     * @return boolean
     */
    function delete ($id)
    {
        $id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "DELETE FROM `{$this->table}` WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 启用/禁用广告位
     *
     * @param integer $id
     * @param boolean $enable
     * @return boolean
     */
    public function enable($id,$enable=true){
    	$id = EXCMS::convertToIntArray($id);
        if ($id === false) {
            throw_exception('LACK_ADSPOSITION_ID');
        }
        $enable = $enable ? 1 : 0;
        $num = count($id);
        $where = $num > 1 ? "`id` IN ('" . implode("', '", $id) . "') LIMIT {$num}" : "`id` = '" . $id[0] . "'";
        $sql = "UPDATE `{$this->table}` SET `enable` = '{$enable}' WHERE {$where}";
                return $GLOBALS['db']->query($sql);
    }
    /**
     * 获取广告位列表
     *
     * @param array $paging 分页数组
     * <ul>
     * <li>integer $paging['limit'] 分页大小 default 0</li>
     * <li>integer $paging['start'] 分页起始大小 default 0</li>
     * <li>integer $paging['total'] 总数 default 0</li>
     * <li>integer $paging['sort'] 排序字段</li>
     * <li>integer $paging['dir'] 排序方式 ASC or DESC, </li>
     * <li>integer $paging['keyword'] 搜索关键字</li>
     * </ul>
     * @return array Paging 数组
     * <ul> 
     * <li> $array['total'] 总数 </li>
     * <li> $array['data'] 分页数据 </li>
     * </ul>
     */
    function getPaging ($paging = array())
    {
        $keyword = trim($paging['keywords']);
        if (!empty($keyword)) {
            $where = " AND (`name` like '%{$keyword}%' OR `description` like '%{$keyword}%') ";
        } 
             	$sql = "SELECT COUNT(*) as `total` FROM {$this->table} WHERE 1 {$where} ";
        $GLOBALS['db']->query($sql);
        $rs = $GLOBALS['db']->fetch();
        $total = $rs['total'];
        $rs = array();
        if($total > 0){
        	$orderby = "ORDER BY `id` DESC";
	        $start = (int) $paging['start'];
	        $limit = $paging['limit'] > 0 ? ($paging['limit'] > 100 ? 100 : $paging['limit']) : 25;
	        $limit = "LIMIT {$start}, {$limit}";
	        $sql = "SELECT * FROM {$this->table} WHERE 1 {$where} {$orderby} {$limit}";
	        	        $GLOBALS['db']->query($sql);
	        $rs = $GLOBALS['db']->fetchAll();
	        foreach ($rs as $key=>$value){
	        	$rs[$key]['phpurl'] = full_url(EXCMS::url(array('name'=>'ads.php','id'=>$value['id'])));
	        }
        }
        return array('total' => $total , 'data' => $rs);
    }
    /**
     * 获取广告位
     *
     * @return array
     */
    public function getAdsPositionList(){
         	$sql = "SELECT id,name FROM {$this->table} WHERE `enable`='1' ";
        $GLOBALS['db']->query($sql);
        return  $GLOBALS['db']->fetchAll();
    }
}
?>