<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		content.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http:// www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http:// www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author hkz@putoyo.com
 * @version $Rev: 1526 $
 */
 
 /* $Id: content.php 1526 2010-05-25 15:00:28Z zhangxuelin $ */ 

// 加载EXCMS配置文件
require_once('../configuration/inc/common.inc.php');

// 获取内容ID
$contentid = trim($_GET['contentid']);

// 如启用内容ID编码时，解码 
if($EXCMS_CONFIG['code_contentid']){
    $contentid = EXCMS::id_decode($contentid);
}
// 检查内容ID是否是数字
if(!is_numeric($contentid) || !($contentid > 0)){
	exit();
}

// 是否跨域回调
if(isset($_GET['crossDomainCallback']) && $_GET['crossDomainCallback'] != ''){
	$crossDomainCallback = trim($_GET['crossDomainCallback']);
}

// defined response array
$rs = array();

// switch action
switch(trim($_GET['act'])){
	// 顶一下（需要安装顶踩模块）
	case 'digg' :
		// 加载模板配置
		loadModuleConfig('digg');
		// 加载顶踩类
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php';
		Digg::create()->diggUp($contentid);
		$rs = Digg::create()->getByContentid($contentid);
		$rs = array(
			'digg' => (int)$rs['digg'],
			'trample' => (int)$rs['trample'],
		);
		$total = $rs['trample'] + $rs['digg'];
		// 被顶百分比
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);
		// 被踩百分比
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		break;
		
	// 踩一脚（需要安装顶踩模块）
	case 'trample' :
		// 加载模板配置
		loadModuleConfig('digg');
		// 加载内容点击类
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php'; 
		Digg::create()->trampleDown($contentid);
		$rs = Digg::create()->getByContentid($contentid);
		$rs = array(
			'digg' => (int)$rs['digg'],
			'trample' => (int)$rs['trample'],
		);
		$total = $rs['digg'] + $rs['trample'];
		// 被顶百分比
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);
		// 被踩百分比
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		break;

	default :
		// 获取点击量（需要安装点击量模块）
		loadModuleConfig('click',true);
		// 加载内容点击类
		include_once LIB_MODULES_PATH . 'click/Click.class.php';
		$rs['click'] = Click::create()->clickUp($contentid);
		
		// 获取被顶，踩次数（需要安装顶踩模块）
		// 加载顶踩类
		include_once LIB_MODULES_PATH . 'digg/Digg.class.php';
		$digg = Digg::create()->getByContentid($contentid);
		// 被顶次数
		$rs['digg'] = (int)$digg['digg'];
		// 被踩次数
		$rs['trample'] = (int)$digg['trample'];
		$total = $rs['digg'] + $rs['trample'];
		// 被顶百分比
		$rs['diggpercent'] = round($total > 0 ? $rs['digg'] / $total * 100 : 0, 1);	
		// 被踩百分比
		$rs['tramplepercent'] = round($total > 0 ? $rs['trample'] / $total * 100 : 0, 1);
		
		// 获取评论数（需要安装评论模块）
		// 加载评论类
		include_once LIB_MODULES_PATH . 'comment/Comment.class.php';
		$comment = new Comment();
		$rs['comment'] = $comment->getCountByItemId($contentid);
		
		// get model
		if(isset($_GET['model']) && $_GET['model']){
			switch(strtolower($_GET['model'])){
				// 加载下载数
				case 'download' :
					include_once LIB_MODULES_PATH . 'download/Downloads.class.php';
					$rs['download'] = Downloads::create()->getTotalByContentId($contentid);
					break;
			}
		}
		break;
}

// response
$json  = EXCMS::jsonencode($rs);
echo $crossDomainCallback ? $crossDomainCallback . "({$json})" : $json;

// excms file's end