<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		download.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @author lele
 * @version $Rev: 146 $
 */
 
 /* $Id: index.php 146 2009-11-10 07:58:36Z zhangxuelin $ */ 
 
 /**
  * JS 方式提升内容下载数量
  * JS调用方式 <script language="/apps/download.php?contentid=内容ID"></script>
  */
  
//加载系统配置文件
require_once('../configuration/inc/common.inc.php');

//获取链接参数
$link = isset($_GET['link']) ? $_GET['link'] : false;

include_once LIB_PATH . 'content/ContentAddon.class.php';
$addon = new ContentAddon();

if($link){	//加密后ID
	$link = base64_decode(urldecode($link));
	$link_array = explode(',', $link); 	
	if(is_array($link_array) && count($link_array)>0){
		$url = $link_array[0];
		$contentid = $link_array[1];
	}
}else{	//实现地址
	$contentid = $_GET['contentid'] ? $_GET['contentid'] : $_GET['id'];
}
// 如启用内容ID编码时，解码 
if($EXCMS_CONFIG['code_contentid']){
	$contentid = EXCMS::id_decode($contentid);
}
$addon_array = $addon->getById($contentid,3);		//获取下载文件名称

if(!is_array($addon_array) || count($addon_array) < 1) EXCMS::showMessage('当前的内容不存在或已经被删除'); 

if($contentid >0){
	include_once LIB_MODULES_PATH . 'download/Downloads.class.php';
	Downloads::create()->downloadUp($contentid);	//更新下载数
}else{
	EXCMS::showMessage("内容ID不存在!");
}
if(!$link){
	include_once LIB_PATH . 'update/ContentFunction.class.php'; //根据别名加载数据库 
	$url = ContentFunction::getThumb($addon_array['downfilename']);
}
if($url!='' && preg_match("/^http:\/\/+/",$url)){	//如果是全地址跳转
	header("Location: {$url}");
}else if($url!=''){
	include_once LIB_PATH . 'util/Download.class.php';
	$down = new Download('',false);
	if(strpos($url,$EXCMS_CONFIG['excms_subdir'])== 0){
		$url = str_replace($EXCMS_CONFIG['excms_subdir'],'/',$url);
	}
	$path = urlFormat(SITE_PATH . '/' . $url);
	if(!$down->downloadFile($path, basename($url))){
		EXCMS::showMessage($down->getErrorMsg());
	}
}else{
	EXCMS::showMessage("下载地址为空!");
}
// excms file's end