<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		action.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package rating
 * @author hukuizhi
 * @version $Rev: 2292 $
 */
/* $Id: common.inc.php 2292 2010-08-21 03:31:06Z hukuizhi $ */
/**
 * EXCMS 评分模块初始化配置
 */
require_once (dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/configuration/inc/common.inc.php');
define('RATING_CONF', substr(dirname(__FILE__), 0, -4) . '/');
define('RATING_PATH', substr(RATING_CONF, 0, -15) . '/');	// 评分路径
define('RATING_INC_PATH', RATING_CONF . 'inc/');			// 模块配置信息
define('RATING_LIB_PATH', RATING_CONF . 'libs/');			// 模块处理类
define('RATING_LANG_PATH', RATING_CONF . 'lang/');		// 模块语言包
define('MODULE_ID','rating');

// 检查模块是否安装
$module_array = EXCMS::getModuleCache(MODULE_ID);
if(!is_array($module_array) || count($module_array) < 1){
	$install_path = RATING_PATH.'install/index.php';
	file_exists(realpath($install_path)) ? header('Location: install/index.php') :	throw_exception('无法找 评分 安装程序位置，请手工输入安装程序路径。<br /> 默认安装程序位置在 评分 安装目录下的 install 文件夹中。');
	exit;
}
//注册模块语言包
regeditLangPackage(MODULE_ID);

// load rating config
loadModuleConfig(MODULE_ID,true);

define('RATING_TEMPLATE_DIR', $EXCMS_MODULE['rating']['template_dir']); // 模板路径
// is ajax request
$ajax = $_POST['ajax'] ? $_POST['ajax'] : $_GET['ajax'];

// ajax 编码处理
if($ajax && CHARSET != JSON_CHARSET){
	$_POST = EXCMS::iconv_all(JSON_CHARSET, CHARSET, $_POST);
}
// excms file end