DROP TABLE IF EXISTS `excms_rating`;
CREATE TABLE `excms_rating` (
  `contentid` int(11) unsigned NOT NULL COMMENT '内容ID',
  `gid` int(11) unsigned NOT NULL COMMENT '评分组ID',
  `sumscore` float unsigned NOT NULL default '0' COMMENT '总分',
  `score` float unsigned NOT NULL default '0' COMMENT '得分',
  `voters` int(11) unsigned NOT NULL default '0' COMMENT '参与评分人数',
  `uservoters` int(11) unsigned NOT NULL default '0' COMMENT '参与评分用户人数',
  `lastrateddate` int(11) unsigned NOT NULL default '0' COMMENT '最后评分时间',
  PRIMARY KEY  (`contentid`,`gid`)
);
DROP TABLE IF EXISTS `excms_rating_group`;
CREATE TABLE `excms_rating_group` (
  `gid` int(11) unsigned NOT NULL auto_increment COMMENT '评分组ID',
  `name` char(50) NOT NULL COMMENT '评分组名称',
  `fullscore` tinyint(1) unsigned NOT NULL default '0' COMMENT '满分',
  `minscore` float NOT NULL default '0' COMMENT '最小评分',
  `defaultvalue` float unsigned NOT NULL default '0' COMMENT '默认值',
  `stars` tinyint(1) unsigned NOT NULL default '5' COMMENT '星星数',
  `tips` varchar(100) default NULL COMMENT '星星提示',
  `scoretext` varchar(100) default NULL COMMENT '得分文本',
  `disabled` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否禁用',
  `denyvote` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否禁止评分',
  `revote` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否允许重复评分',
  `loginvote` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否登录评分',
  `log` tinyint(1) unsigned NOT NULL default '0' COMMENT '是否记录日志',
  `description` varchar(100) default NULL COMMENT '描述',
  `sort` tinyint(1) unsigned NOT NULL default '50' COMMENT '排序',
  PRIMARY KEY  (`gid`)
);
INSERT INTO `excms_rating_group` VALUES (1,'默认评分组',10,5,'很差\n一般\n不错\n很好\n完美',1,0,'({score}分，共{voters}人评分)',0,0,0,0,0,'',50);

DROP TABLE IF EXISTS `excms_rating_log`;
CREATE TABLE `excms_rating_log` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `contentid` int(11) default NULL,
  `gid` int(11) default NULL,
  `uid` int(11) default NULL,
  `username` char(50) default NULL,
  `score` int(11) default NULL,
  `ip` char(15) default NULL,
  `rateddate` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `content` (`contentid`,`gid`),
  KEY `user` (`contentid`,`gid`,`uid`)
);

DELETE FROM `excms_url` WHERE `moduleid` = 'rating';
INSERT INTO `excms_url` (`moduleid`, `name`, `url`, `enablerewrite`, `rewrite`, `description`, `issystem`, `sort`) values('rating','action','apps/rating.php','0','/apps/action/rating','评分动作重写','1','50');
INSERT INTO `excms_url` (`moduleid`, `name`, `url`, `enablerewrite`, `rewrite`, `description`, `issystem`, `sort`) values('rating','js_lib','apps/rating/rating.js','0','/apps/rating/rating.js','评分组件JS类','1','50');
