/*
 * EXCMS Rating Component 1.0
 * Copyright(c) 2010, EXCMS.cn
 * services@excms.cn
 * 
 * http://www.excms.cn
 */

/**
 * @class Rating
 * 星星评分（级）类.<br><br>
 * 示例:
<pre><code>
var rating = new Rating({stars:5, fullScore:10, minScore:0.5});
</code></pre>
 * @constructor
 * @param {Array} config (Optional) An object, the properties of which provide values for the new Rating's fields.
 */
function $(o){if(document.getElementById&&document.getElementById(o)){return document.getElementById(o)}else if(document.all&&document.all(o)){return document.all(o)}else if(document.layers&&document.layers[o]){return document.layers[o]}else{return false}}

Rating = function(config){
	this.config = config || {};
	this.gid = this.config.gid;
	this.contentid = this.config.contentid;
	this.url = this.config.url;
	this.url ? this.load() : this.initComponent();
};
Rating.prototype = {
	/**
	 * 内容评分所使用的评分组ID
	 * 模板中手工配置
	 * @property gid
	 * @type {Number}
	 */
	/**
	 * 内容ID
	 * 内容模板中使用 $_PAGE_CONTENT.contentid, 其他模板中一般使用 $cnt.contentid
	 * @property contentid
	 * @type {String}
	 */
	/**
	 * 评分控件UI设置参数对象数组
	 * @property config
	 * @type {Object}
	 */	
	/**
	 * 评分组件容器
	 * @property renderTo
	 * @type {String/HTMLElement}
	 */
	renderTo : null,
	/**
	 * 评分组件 HTMLElement 对象
	 * @property renderTo
	 * @type {String/HTMLElement}
	 */
	el : null,
	/**
	 * 评分组件 HTMLElement 对象样式
	 * @property cls
	 * @type {String}
	 */
	
	cls : '',
	/**
	 * 得分文本显示容器 HTMLElement 对象
	 * @property scoreTextEl
	 * @type {String/HTMLElement}
	 */
	scoreTextEl : null,
	/**
	 * 满分
	 * @property fullScore
	 * @type {Number}
	 */
	fullScore : 10,
	/**
	 * 评分递增值（最小评分值）
	 * @property minScore 0 时平滑递增
	 * @type {Number}
	 */
	minScore : 0,
	/**
	 * 当前得分
	 * @property score
	 * @type {Number}
	 */
	score : 0,
	/**
	 * 总分
	 * @property sumScore
	 * @type {Number}
	 */
	sumScore : 0,
	/**
	 * 参与评分人数
	 * @property voters
	 * @type {Number}
	 */
	voters : 0,
	/**
	 * 用户参与评分人数
	 * @property userVoters
	 * @type {Number}
	 */
	userVoters : 0,
	/**
	 * 星星数
	 * @property stars
	 * @type {Number}
	 */
	stars : 5,
	/**
	 * 星星提示
	 * 鼠标移动到星星上的提示文本
	 * @property tips
	 * @type {Array/String}
	 */
	tips : [],
	/**
	 * 是否隐藏星星
	 * @property hideStar
	 * @type {Boolean}
	 */
	hideStar : false,
	/**
	 * 得分文本
	 * 用于显示当前得分及相关评分数据，如{voters}参与评分人数等。
	 * @property scoreText
	 * @type {String}
	 */
	scoreText : '({score}分)',
	/**
	 * 是否隐藏得分文本
	 * @property hideScoreText
	 * @type {Boolean}
	 */
	hideScoreText : false,
	/**
	 * 是否需要登录评分
	 * @property loginVote
	 * @type {Boolean}
	 */
	loginVote : false,
	/**
	 * 是否禁止评分
	 * @property denyVote
	 * @type {Boolean}
	 */
	denyVote : false,
	/**
	 * 是否允许重复评分
	 * @property reVote
	 * @type {Boolean}
	 */
	reVote : false,
	
	/**
	 * 加载评分组及内容评分数据
	 */ 
	load : function(){
		var tthis = this;
		ajax.request('post', this.url, {success:function(r){
			var v = ajax.jsondecode(r.responseText);
			if(v.success){
				var g;
				if(g = v.group){
					tthis.config.fullScore = g.fullscore || tthis.config.fullscore;
					tthis.config.score = g.defaultvalue || tthis.config.score;
					tthis.config.stars = g.stars || tthis.config.stars;
					tthis.config.tips = g.tips || tthis.config.tips;
					tthis.config.minScore = g.minscore || tthis.config.minScore;
					tthis.config.scoreText = tthis.config.scoreText || g.scoretext;
					tthis.config.denyVote = g.denyvote || tthis.config.denyVote;
					tthis.config.reVote = g.revote || tthis.config.reVote;
					tthis.config.loginVote = g.loginvote || tthis.config.loginVote;
				}
				if(g = v.content){
					tthis.config.score = g.score;
					tthis.config.sumScore = g.sumscore;
					tthis.config.voters = g.voters;
					tthis.config.userVoters = g.uservoters;
				}
				tthis.initComponent();
				if(typeof tthis.onload == 'function') tthis.onload(v);
			}else{
				alert(v.message ? v.message : '请求服务失败，请重试！');
			}
		}},{gid:this.gid, contentid:this.contentid, method:'getvalue'});
	},
	/**
	 * apply config
	 */
	apply : function (C, D, B) {
	    if (B) this.apply(C, B);
	    if (C && D && typeof D == 'object') {
	    	for (var A in D) C[A] = D[A];
	    }
	    return C;
	},
	/**
	 * 初始化评分组件
	 * @param {Object} config (Optional)
	 */ 
	initComponent : function(config){
		this.apply(this, this.config);
		if(this.tips && typeof this.tips == 'string'){
			this.tips = this.tips.split("\n");
		}
		if(this.el && typeof this.el == 'string'){
			this.el = $(this.el);
		}
		if(this.scoreTextEl && typeof this.scoreTextEl == 'string'){
			this.scoreTextEl = $(this.scoreTextEl);
		}
		if(!this.el && this.renderTo && typeof this.renderTo == 'string'){
			this.renderTo = $(this.renderTo);
		}
		if(!this.reVote && Cookies.processCookeiIds('rating', this.gid+'-'+this.contentid, 20, true)){
			this.denyVote = true;
		}
		this.render();
	},
	/**
	 * 渲染组件
	 */
	render : function(){
		if(!this.el){
			this.el = document.createElement('span');
			if(this.renderTo){
				this.isRender = true;
				this.renderTo.appendChild(this.el);
			}
		}else{
			this.isRender = true;
		}
		this.el.className += ' ratingbar ' + (this.cls || '');
		if(!this.hideStar){
			var a;
			this.el.stars = [];
			for(var i=0;i<this.stars;i++){
				a = document.createElement('a');
				a.className = 'rating-star';
				if(this.tips) a.title = this.tips[i] || '';
				this.el.appendChild(a);
				this.el.stars.push(a);
			}
			this.em = document.createElement('em');
			this.em.className = 'rating-em';
			this.el.appendChild(this.em);
			this.onrender();
		}
		this.renderEm();
	},
	onrender : function(){
		if(!this.el.parentNode) return ;
		this.denyVote ? this.disable() : this.renderEvent();
		this.starWidth = this.el.stars[0].offsetWidth;
		this.increWidth = this.minScore * this.stars * this.starWidth / this.fullScore;
		this.fullWidth = this.stars * this.starWidth;
		this.scorePerPix = this.fullScore / this.fullWidth;
		this.el.style.cssText = ';overflow:hidden;width:' + this.fullWidth + 'px';
		this.setWidth();
	},
	/**
	 * 渲染得分文本 Element
	 */
	renderEm : function(){
		if(!this.hideScoreText && !this.scoreTextEl && this.el.parentNode && this.el.parentNode.tagName){
			this.scoreTextEl = document.createElement('span');
			this.scoreTextEl.className = 'rating-score';
			var p = this.el.parentNode;
			p.lastChild == this.el ? p.appendChild(this.scoreTextEl) : p.insertBefore(this.scoreTextEl, this.el.nextSibling);
			this.setScoreText();
		}
	},
	/**
	 * append el to element
	 */
	applyTo : function(el){
		if(this.isRender) return ;
		if(typeof el == 'string') el = $(el);
		if(el){
			if(this.el){
				el.appendChild(this.el);
				this.onrender();
				this.renderEm();
			}else{
				this.renderTo = el;
			}
		}
	},
	/**
	 * 设置得分文本
	 */
	setScoreText : function(text, score){
		if(!this.hideScoreText && this.scoreTextEl){
			if(!text && this.scoreText){
				score = typeof score == 'undefined' ? this.score : score;
				text = this.scoreText.replace('{score}', score||0).replace('{sumscore}', this.sumScore||0).replace('{voters}', this.voters||0).replace('{uservoters}', this.userVoters||0);
			}
			this.scoreTextEl.innerHTML = text || '';
		}
	},
	/**
	 * 渲染鼠标事件
	 */
	renderEvent : function(){
		var tthis = this;
		this.el.onmousemove = function(e){
			e = window.event || e;
			var w = 0;
			if(this.getBoundingClientRect){
				w = this.getBoundingClientRect();
				w = e.clientX - w.left;
			}else{
				w = e.clientX - this.offsetLeft; 
				var p = this;
				while(p = p.offsetParent){
					w -= p.offsetLeft; 
				}
			}
			if(tthis.increWidth > 0){
				w = tthis.increWidth * Math.ceil(w / tthis.increWidth);
			}
			tthis.setWidth(w);
			tthis.currentScore = (w * tthis.scorePerPix).toFixed(1);
			tthis.setScoreText('', tthis.currentScore);
		}
		this.el.onmouseout = function(){
			tthis.setScoreText();
			tthis.setWidth();
		}
		this.el.onclick = function(){
			tthis.score = tthis.currentScore;
			tthis.setScoreText();
			tthis.commit();
		}
	},
	/**
	 * 设置高度评分宽度
	 */
	setWidth : function(width){
		if(this.hideStar) return ;
		width = typeof width == 'undefined' ? this.getWidth() : width;
		width = Math.round(width || 0);
		width = Math.max(0, Math.min(this.fullWidth, width));
		this.em.style.width = width + 'px';
	},
	/**
	 * 宽度计算
	 */
	getWidth : function(){
		return Math.round((this.score || 0) / this.scorePerPix);
	},
	/**
	 * 设置评分
	 */
	setScore : function(score){
		if(score > this.fullScore && score < 0){
			alert('评分值不能小于0分且不能大于'+this.fullScore+'分');
			return ;
		}
		this.score = score;
		this.setWidth();
		this.setScoreText();
	},
	/**
	 * 获取当前评分
	 */
	getScore : function(){
		return this.score;
	},
	/**
	 * 提交评分
	 */
	commit : function(){
		if(this.url){
			var tthis = this;
			if(this.loginVote && !Login.login){
				Account.login({callback:function(){tthis.commit()}});
				return ;
			}
			ajax.request('post', this.url, {success:function(r){
				var v = ajax.jsondecode(r.responseText);
				if(v.success == 1){
					tthis.sumScore = v.sumscore;
					tthis.voters = v.voters;
					tthis.userVoters = v.uservoters;
					tthis.setScore(v.score);
					if(!tthis.reVote) tthis.disable();
					Cookies.processCookeiIds('rating',tthis.gid+'-'+tthis.contentid,20);
				}else if(v.success == -1){
					Account.login({callback:function(){alert(1);tthis.commit()}});
				}else{
					alert(v.message ? v.message : '请求服务失败，请重试！');
				}
			}},{contentid:this.contentid, gid:this.gid, score:this.score, method:'commit'});
		}else if(!this.reVote){
			this.disable();
		}
	},
	/**
	 * 禁止评分
	 */
	disable : function(){
		if(this.el.disabled) return;
		this.el.disabled = true;
		this.el.onmousemove = this.el.onmouseout = this.el.onclick = function(){return false}
		for(var i=0,len=this.el.stars.length;i<len;i++)
			this.el.stars[i].style.cssText = ';cursor:default';
	}
};
