<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		index.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package rating
 * @author $Author: zhanghaisong $
 * @version $Rev: 2292 $
 */
/* $Id: index.php 2292 2010-08-21 03:31:06Z zhanghaisong $ */
/**
 * EXCMS 评分卸载程序
 * @category EXCMS
 * @package rating
 * @author $Author: zhanghaisong $
 */ 
if (! defined('EXCMS') || ! defined('EXCMS_ADMIN')) {
    exit('Access Denied');
}
//模块配置信息
$module_config = array(
	'module_id' => 'rating',
	'module_extend' => 'extention.inc.php',				//扩展动作文件
	'module_sql' => 'mysql.sql',						//sql存放文件
	'module_file' => '/',								//删除文件列表
);
$module_array = EXCMS::getModuleCache($module_config['module_id']);
if(!is_array($module_array) || count($module_array) < 1){
	$rs['success'] = true;
	$rs['message'] = "模块已被卸载";
	return ;
}

//删除模块配置信息
$success = $module->delete($module_config['module_id']);
if($success){		
	$file_dir = EXCMS_PATH.$module_array['path']."/uninstall/";
	//卸载数据库信息
	if($module_config['module_sql']!='' && file_exists($file_dir.$module_config['module_sql'])){	
		error_reporting(E_ALL || ~E_NOTICE);
	    $sql_path = $file_dir.$module_config['module_sql'];
		$sql = file_get_contents($sql_path);
		$database = $module->runquery($sql);
		if($database){
			include_once LIB_PATH . 'system/SystemConfig.class.php';
			$sys = new SystemConfig();
			$sys->updateCache($module_config['module_id']);
			include_once LIB_PATH . 'system/Url.class.php';
			$url = new Url();
			$url->updateCache();
			unset($sys,$url);
		}
	}
	//执行扩展动作
	if($module_config['module_extend']!='' && file_exists($file_dir.$module_config['module_extend'])){	
		require_once($file_dir.$module_config['module_extend']);
	}
	//删除文件目录
	include_once LIB_PATH . 'util/FileAction.class.php';
	$file = new FileAction();
	if( is_array($module_config['module_file']) && count($module_config['module_file'])>0 ) {
		foreach ($module_config['module_file'] as $value){
			if($value!=''){
				if(is_dir(EXCMS_PATH.$value)){
					$del_dir = $file->del_dir(EXCMS_PATH.$module_array['path'].'/'.$value,true);
				}else{
					$file->del_file(EXCMS_PATH.$module_array['path'].'/'.$value);
				}
			}
		}
	}else if($module_config['module_file']!=''){
		if(is_dir(EXCMS_PATH.$module_array['path'].'/'.$module_config['module_file'])){
			$del_dir = $file->del_dir(EXCMS_PATH.$module_array['path'].'/'.$module_config['module_file'],true);
		}else{
			$file->del_file(EXCMS_PATH.$module_array['path'].'/'.$module_config['module_file']);
		}
	}
	$rs['success'] = $success;
	$rs['message'] = "卸载模块成功";
}else{
	$rs['success'] = false;
	$rs['message'] = "卸载模块失败";
}
// excms file's end