EXCMS.namespace('EXCMS.UCenter');
EXCMS.UCenter = {
	baseAction : 'index.php?M=Modules&EM=ucenter&A=Action',
	init:function(){
	    Ext.QuickTips.init();
	    this.view();
	},
	view : function(){
		var actionPanel = new Ext.Panel({region:'west',split:true,collapsible:true,collapseMode:'mini',
			bodyStyle:'background:#DFE8F6;padding:3px 0 0 5px',width:200,minWidth:150,border:false,baseCls:'x-plain',
			items:{xtype:'panel',title:'UCenter管理',contentEl:'ucenter-action',collapsible:true,style:'margin-bottom:5px'}
		});
		var labelStyle = 'display:block;padding:0px 0px 6px 106px;color:#666;';
		this.formPanel = new Ext.form.FormPanel({border:false,autoScroll:false,labelWidth:100,defaults:{xtype:'textfield',width:200}, items:[
			{xtype:'label', style:'display:block;padding-bottom:6px', html:'<div style="padding:10px;border:1px solid #F0D47E;background:none repeat scroll 0 0 #FEFFDD;width:560">首次设置前请备份好'+config_file+'配置文件，以防止修改错误导致网站无法运行。</div>',width:580,hidden:true},
			{fieldLabel:'服务端地址',name:'apiurl',allowBlank:false,blankText:"请输入服务端地址"},
			{xtype:'label',text:'该值在您安装完 UCenter 后会被初始化，在您 UCenter 地址或者目录改变的情况下，修改此项，一般情况请不要改动。例如: http://www.site.com/uc_server (最后不要加"/")。',style:labelStyle,width:580},
			{fieldLabel:'创始人密码',name:'authkey',inputType:'password',allowBlank:false,blankText:"请输入创始人密码", listeners:{'render':{fn:function(){if(uc_installed>-1){this.el.dom.parentNode.parentNode.style.display="none";}}}}},
			{xtype:'label',text:'该值在您安装完 UCenter 后会被初始化一个登录密码,UCenter称之为“创始人密码”。',style:labelStyle,width:580,hidden:true},
			{fieldLabel:'服务端IP地址',name:'ip'},
			{xtype:'label',text:'正常情况下留空即可。如果由于域名解析问题导致与 UCenter 通信失败，请尝试设置 UCenter 所在服务器的 IP 地址。',style:labelStyle,width:580}
		]});
		this.baseForm = new Ext.form.FormPanel({border:false,autoScroll:false,labelWidth:100,defaults:{xtype:'textfield',width:200}, items:[
			{fieldLabel:'通信密钥',name:'authkey',vtype:'username',usernameMaxLen:64,usernameMinLen:0.1,usernameText:'通信密钥长度不符合要求',allowBlank:false,blankText:"请输入通信密钥",width:480},
			{xtype:'label',text:'只允许使用英文字母及数字，限 64 字节。应用端的通信密钥必须与此设置保持一致，否则该应用将无法与 UCenter 正常通信。',style:labelStyle,width:580},
			{fieldLabel:'连接方式',xtype:'radiogroup',columns:2,itemCls:'float-x-item',items:[
   				{boxLabel:'数据库方式(MySQL) ',name:'connect',inputValue:'mysql',checked:true,listeners:{'check':{fn:function(c,v){if(v)this.mysqlForm.show();},scope:this}}},
  				{boxLabel:'接口方式',name:'connect',inputValue:'interface',listeners:{'check':{fn:function(c,v){if(v)this.mysqlForm.hide();},scope:this}}}
  			]},
			{xtype:'label',text:'请根据您的服务器网络环境选择适当的连接方式。',style:labelStyle,width:580},
			{xtype:'hidden',name:'appid'},
			{xtype:'hidden',name:'dbcharset'}
		]});
		this.mysqlForm = new Ext.form.FormPanel({border:false,autoScroll:false,labelWidth:100,defaults:{xtype:'textfield',width:200}, items:[
			{fieldLabel:'数据库服务器',name:'dbhost',value:'localhost'},
			{xtype:'label',text:'默认:localhost, 如果 MySQL 端口不是默认的 3306，请填写如下形式：127.0.0.1:6033。',style:labelStyle,width:580},
			{fieldLabel:'数据库用户名',name:'dbuser',value:'root',allowBlank:false,blankText:"请输入数据库用户名"},
			{xtype:'label',text:'登录uc服务端的数据库用户名。',style:labelStyle,width:580},
			{fieldLabel:'数据库密码',name:'dbpassword', inputType:'password'},
			{xtype:'label',text:'登录uc服务端数据库使用的密码。',style:labelStyle,width:580},
			{fieldLabel:'数据库名',name:'dbname',value:'discuz',allowBlank:false,blankText:"请输入数据库名"},
			{xtype:'label',text:'登录uc服务端的数据库名称。',style:labelStyle,width:580},
			{fieldLabel:'数据库表前缀',name:'dbprefix',value:'uc_'},
			{xtype:'label',text:'uc服务端使用的数据库表前缀,一不般为 uc_。',style:labelStyle,width:580}
		]});
		this.configForm = new Ext.form.FormPanel({border:false,autoScroll:false,labelWidth:100,defaults:{xtype:'textfield',width:200}, items:[
			{fieldLabel:'正确的配置信息',xtype:'textarea',name:'config',width:480},
			{xtype:'label',text:'当 UCenter 配置信息丢失时可复制上面的代码到配置文件中。',style:labelStyle,width:580}
		]});
        this.formPanel.form.on('actioncomplete',function(form,action){
			//this.mainPanel.el.unmask();
			if (action.result.success) {
				if(uc_installed>-1){
					alert('UCenter配置信息保存成功');
				}else{
					this.formPanel.items.items[0].hide();
					this.formPanel.items.items[3].el.dom.parentNode.parentNode.style.display="none";
					this.formPanel.items.items[4].hide();
					this.baseForm.show();this.mysqlForm.show();this.configForm.show();
					uc_installed = 1;
					alert('链接UCenter服务器成功！');
				}
				var value = action.result.config;
				if(value){
					this.formPanel.form.setValues(value);
					this.baseForm.form.setValues(value);
					if(value.connect=='mysql'){
						this.mysqlForm.form.setValues(value);
					}
					this.configForm.form.setValues(value);
				}
			}
		}, this);
		this.mainPanel = new Ext.Panel({title:'UCenter配置信息',layout:'form',bodyStyle:'padding:15px',border:false,waitMsgTarget:true,autoScroll:true,closable:false,
			items:[this.formPanel,this.baseForm,this.mysqlForm,this.configForm],
			tbar:[{text:'保存',handler:this.saveSettings,scope:this},{text:'重置',handler:this.resetSettings,scope:this}]
		});
		this.tabPanel = new Ext.TabPanel({region:'center',border:false,style:'border:1px solid #99BBE8;border-width:0px 0px 0px 1px',activeTab:0,enableTabScroll:true,autoDestroy:false,items:this.mainPanel});
		this.tabPanel.on('beforeremove',function(t,c){t.activate(0);t.hideTabStripItem(c);return false;},this);
        new Ext.Viewport({layout:'border',items:[actionPanel,this.tabPanel]});
		if(uc_installed == -1){
			this.formPanel.items.items[0].show();
			this.formPanel.items.items[4].show();
			this.baseForm.hide();this.mysqlForm.hide();this.configForm.hide();
		}else{
			this.formPanel.form.setValues(config_settings);
			this.baseForm.form.setValues(config_settings);
			if(config_settings.connect=='mysql'){
				this.mysqlForm.form.setValues(config_settings);
			}
			this.configForm.form.setValues(config_settings);
		}
	},
	saveSettings : function(){
		if(uc_installed>-1){
			this.formPanel.items.items[3].allowBlank = true;
		}
		if(!this.formPanel.form.isValid()){alert('请检查红线处的错误提示！');return}
		this.values = {};
		if(!this.baseForm.hidden){
			if(!this.baseForm.form.isValid()){alert('请检查红线处的错误提示！');return}
			this.values = this.baseForm.form.getValues();
		}
		if(!this.mysqlForm.hidden){
			if(!this.mysqlForm.form.isValid()){alert('请检查红线处的错误提示！');return}
			var mysqlFormValues = this.mysqlForm.form.getValues();
			for(key in mysqlFormValues){
				this.values[key]= mysqlFormValues[key];
			}
		}
		//this.mainPanel.el.mask('正在保存, 请稍侯...');
		this.formPanel.form.submit({url:this.baseAction+'&method='+(uc_installed>-1 ? 'setting' : 'connect' ),params:this.values});
	},
	resetSettings : function(){
		
	},
	active : function(o){
		this.type = o;
		if(this.type == 'config'){
			this.tabPanel.activate(this.formPanel);
		}else{
			if(!this.helpPanel){
				var html = '<iframe src="/ucenter/help/help.html" frameborder="0" scrolling="auto" width="100%" height="100%"></iframe>';
				this.helpPanel = new Ext.Panel({title:'UCenter帮助',border:false,autoScroll:true,closable:true,closeAction:'hide',html:html});
				this.tabPanel.add(this.helpPanel);
			}
			this.tabPanel.unhideTabStripItem(this.helpPanel);
			this.tabPanel.activate(this.helpPanel);
		}
	}
};
EXCMS.onReady(EXCMS.UCenter.init,EXCMS.UCenter);