<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		common.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ucenter
 * @author hukuizhi
 * @version $Rev: 529 $
 */
 
 /* $Id: common.inc.php 529 2010-01-13 08:41:49Z hukuizhi $ */

/**
 * EXCMS UCeter初始化配置
 */
require_once (dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/configuration/inc/common.inc.php');

define("UCENTER_CONF", substr(dirname(__FILE__), 0, -4).'/'); 
define("UCENTER_PATH", substr(UCENTER_CONF, 0, -15).'/'); 	//UCeter路径
define("UCENTER_INC_PATH", UCENTER_CONF."inc/");			//模块配置信息
define("UCENTER_LIB_PATH", UCENTER_CONF."libs/");			//模块处理类
define("UCENTER_LANG_PATH", UCENTER_CONF."lang/"); 			//模块语言包
define("UCENTER_LOG_PATH", UCENTER_CONF."logs/");			//模块日志信息
define("UCENTER_TEMPLATE_DIR", $EXCMS_CONFIG['template_dir'] . $EXCMS_CONFIG['template_name']. '/ucenter/');	//模块模板路径
define("UCENTER_CLIENT",UCENTER_PATH."uc_client/");			//uc_client 位置
define('MODULE_ID','ucenter');
//检查UCeter模块是否安装
$module_array = EXCMS::getModuleCache(MODULE_ID);
if(!is_array($module_array) || count($module_array) < 1){
	$install_path = UCENTER_PATH.'install/index.php';
	file_exists(realpath($install_path)) ? header('Location: install/index.php') :	throw_exception('无法找到 UCenter 安装程序位置，请手工输入安装程序路径。<br /> 默认安装程序位置在 UCenter 安装目录下的 install 文件夹中。');
	exit;
}
//注册模块语言包
regeditLangPackage(MODULE_ID);

//检查uc_client是否安装
if(file_exists(UCENTER_CLIENT . 'client.php')){
	if(!defined('UC_API')) define('UC_API', '');
	include_once UCENTER_CLIENT . 'client.php';
}else{
	throw_exception('UCENTER_CLIENT_NOT_INSTALL');
}
//检查UCeter模块是否启用
loadModuleConfig("ucenter");

// excms file's end