<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		UCenter.class.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ucenter
 * @author hukuizhi
 * @version $Rev: 1839 $
 */
/* $Id: UCenter.class.php 1839 2010-06-29 11:09:57Z zhanghaisong $ */
/**
 * EXCMS UCnter 整合
 * @category EXCMS
 * @package ucenter
 * @author hukuizhi
 */
class UCenter{
	/**
	 * 配置文件
	 * @var string
	 */
	protected $config_file = "config.inc.php";
	/**
	 * 构造函数
	 */
	function __construct(){
		$this->config_file = EXCMS_CONF . '../sitedata/' . $this->config_file;
	}
	/**
	 * 兼容PHP4构造函数
	 */
	function UCenter(){
		$this->__construct();
	}
	/**
	 * UC 初始化链接
	 * @param string $apiurl uc server url
	 * @param string $password uc server password
	 * @param string $ip uc server ip
	 * @return array
	 */
	function connect($apiurl,$password,$ip){
		global $EXCMS_CONFIG;
		// uc server url
		$apiurl = preg_replace("/\/$/", '', trim($apiurl));
		if(empty($apiurl) || !preg_match("/^(http:\/\/)/i", $apiurl)){
			throw_exception("UC_APIURL_ERROR"); // 请填正确的服务端地址以http://开头!
		}
		// uc server ip
		if(!$ip){
			$temp = @parse_url($apiurl);
			$ip = gethostbyname($temp['host']);
			if(ip2long($ip) == -1 || ip2long($ip) === FALSE){
				$ip = '127.0.0.1';
			}
		}
		// uc server authkey
		if(empty($password)){
			throw_exception("UC_APIAUTHKEY_EMPTY"); // 请填写uc创始人密码!
		}
		
		$ucinfo = $this->getUCInfo($apiurl . '/index.php?m=app&a=ucinfo', 500, '', '', 1, $ip);
		list($status, $ucversion, $ucrelease, $uccharset, $ucdbcharset, $apptypes) = explode('|', $ucinfo);
		if($status != 'UC_STATUS_OK'){
			throw_exception("UC_APIURL_CONNECT_ERROR"); // uc服务端地址无效,请仔细检查您安装的uc服务端地址!
		}
		if(UC_CLIENT_VERSION > $ucversion){
			throw_exception("UC_API_VERSION_INCONFORMITY",array('current'=>UC_CLIENT_VERSION,'server'=>$ucversion)); // 'uc服务端版本不一致,您当前的uc客服端版本为:' . UC_CLIENT_VERSION . ',而服务端版本为:' . $ucversion . '!'
		}
		$ucdbcharset = strtoupper($ucdbcharset);
		if($ucdbcharset != CHARSET){
			throw_exception("UC_API_CHARSET_INCONFORMITY",array('current'=>CHARSET,'server'=>$ucdbcharset)); // uc服务端编码与DedeCMS编码不一致!要求您的uc服务端编码为:gbk编码.
		}
		
		$app_tagtemplates = 'apptagtemplates[template]=' . urlencode('<a href="{url}" target="_blank">{title}</a>') . '&' . 'apptagtemplates[fields][title]=' . urlencode('标题') . '&' . 'apptagtemplates[fields][writer]=' . urlencode('作者') . '&' . 'apptagtemplates[fields][pubdate]=' . urlencode('时间') . '&' . 'apptagtemplates[fields][url]=' . urlencode('地址');
		$postdata = 'm=app&a=add&ucfounder=&ucfounderpw=' . urlencode($password) . '&apptype=OTHER&appname=' . urlencode($EXCMS_CONFIG['sitename']) . '&appurl=' . urlencode($EXCMS_CONFIG['domain']) . '&appip=&appcharset=gbk&appdbcharset=' . CHARSET . '&' . $app_tagtemplates . '&release=' . UC_CLIENT_RELEASE;
		$ucconfig = $this->getUCInfo($apiurl . '/index.php', 500, $postdata, '', 1, $ip);
		if(strstr($ucconfig, '<?xml')){
			$temp = explode('<?xml', $ucconfig);
			$ucconfig = $temp[0];
			unset($temp);
		}
		if(empty($ucconfig)){
			throw_exception("UC_API_SETTINGS_ERROR"); // 请填写有效的配置信息!
		}
		if($ucconfig == '-1'){
			throw_exception("UC_API_PASSWORD_ERROR"); // 创始人密码错误!
		}
		$ucconfig = explode('|', $ucconfig);
		$ucconfig = array(
			'authkey'	=>$ucconfig[0],
			'appid'		=>$ucconfig[1],
			'dbhost'	=>$ucconfig[2],
			'dbname'	=>$ucconfig[3],
			'dbuser'	=>$ucconfig[4],
			'dbpassword'=>$ucconfig[5],
			'dbcharset'	=>$ucconfig[6],
			'dbprefix'	=>$ucconfig[7],
			'charset'	=>$ucconfig[8],
			'apiurl'	=>$apiurl,
			'ip'		=>$ip,
		);
		if(empty($ucconfig['authkey']) || empty($ucconfig['appid'])){
			throw_exception("UC_API_FETCH_ERROR"); // 数据获取失败!
		}
		$write_info = $this->writeConfig($ucconfig);
		if($write_info){
			$ucconfig['config'] = $write_info['config'];
		}
		return array('success' => $write_info['success'],'config'=>$ucconfig);
	}
	/**
	 * 获取UC配置信息
	 * @return -1 | 0 | array 
	 */
	public function getConfigs(){
		if(!defined('UC_APPID')){
			return -1;
		}else{
			$flag = false;
			$uc_app = uc_app_ls();
			foreach($uc_app as $v){
				if($v['appid'] == UC_APPID){
					$flag = true;
					break;
				}
			}
			if(!$flag){
				return 0;
			}
			list($dbname,$dbprefix) = explode('.',str_replace('`','',UC_DBTABLEPRE));
			$config = array('appid' => UC_APPID, 'authkey' => UC_KEY, 'apiurl' => UC_API, 'connect' => UC_CONNECT, 'dbhost' => UC_DBHOST, 'dbuser' => UC_DBUSER, 'dbpassword' => UC_DBPW, 'dbname' => $dbname, 'dbprefix' => $dbprefix, 'ip' => UC_IP);
			$config['config'] = $this->getConfigStr($config);
			return $config;
		}
	}
	/**
	 * 配置信息修改
	 * @param unknown_type $config
	 * @return array
	 */
	public function editConfigs($config){
		$fp = fopen($this->config_file, 'r');
		$content = fread($fp, filesize($this->config_file));
		$content = trim($content);
		$content = substr($content, -2) == '?>' ? substr($content, 0, -2) : $content;
		fclose($fp);
		if($config['connect'] == "mysql"){
			$uc_dblink = @mysql_connect($config['dbhost'], $config['dbuser'], $config['dbpassword'], 1);
			if(!$uc_dblink){
				throw_exception("UC_API_DBCONNECT_ERROR");//连接UCenter数据库失败!
			}else{
				mysql_close($uc_dblink);
			}
			$content = $this->saveConfig($content, 'UC_DBHOST', $config['dbhost']);
			$content = $this->saveConfig($content, 'UC_DBUSER', $config['dbuser']);
			$content = $this->saveConfig($content, 'UC_DBPW', $config['dbpassword']);
			$content = $this->saveConfig($content, 'UC_DBNAME', $config['dbname']);
			$content = $this->saveConfig($content, 'UC_DBTABLEPRE', $config['dbname'].'.'.$config['dbprefix']);
			$content = $this->saveConfig($content, 'UC_DBCHARSET', $config['dbcharset']);
		}
		$content = $this->saveConfig($content, 'UC_CONNECT', $config['connect']);
		$content = $this->saveConfig($content, 'UC_KEY', $config['authkey']);
		$content = $this->saveConfig($content, 'UC_API', $config['apiurl']);
		$content = $this->saveConfig($content, 'UC_IP', $config['ip']);
		$content = $this->saveConfig($content, 'UC_APPID', $config['appid']);
		if(@file_put_contents($this->config_file, $content)){
			$rs['success'] = true;
			$config['appid'] = $config['appid'];
			$config['config'] = $this->getConfigStr($config);
			$rs['config'] = $config;
			return $rs;
		}else{
			throw_exception("UC_API_CONFIG_DISWRITE");//系统配置文件不可写
		}
	}
	/**
	 * 保存UC配置变量
	 * @param string $content 配置文件信息
	 * @param string $varname 常量名称
	 * @param string $value 常量的值
	 * @return string
	 */
	function saveConfig($content,$varname,$value){
		$varname = strtoupper($varname);
		$preg = preg_quote($varname);
		$preg = "/define\('".$preg."',\s*'.*?'\);/i";
		if(preg_match($preg, $content)){
			$content = preg_replace($preg, "define('" . $varname . "', '" . $value . "');", $content);
		}else{
			$content .= "\r\ndefine('" . $varname . "', '" . $value . "');";
		}
		return $content;
	}
	/**
	 * 读取UC信息
	 * @param $config
	 * @return array
	 */
	function getUCInfo($apiurl, $limit = 0, $post = '', $cookie = '', $bysocket = FALSE, $ip = '', $timeout = 15, $block = TRUE){
		$return = '';
		$matches = parse_url($apiurl);
		$host = $matches['host'];
		$path = $matches['path'] ? $matches['path'] . ($matches['query'] ? '?' . $matches['query'] : '') : '/';
		$port = !empty($matches['port']) ? $matches['port'] : 80;
		if($post){
			$out = "POST $path HTTP/1.0\r\n";
			$out .= "Accept: */*\r\n";
			//$out .= "Referer: $boardurl\r\n";
			$out .= "Accept-Language: zh-cn\r\n";
			$out .= "Content-Type: application/x-www-form-urlencoded\r\n";
			$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
			$out .= "Host: $host\r\n";
			$out .= 'Content-Length: ' . strlen($post) . "\r\n";
			$out .= "Connection: Close\r\n";
			$out .= "Cache-Control: no-cache\r\n";
			$out .= "Cookie: $cookie\r\n\r\n";
			$out .= $post;
		}else{
			$out = "GET $path HTTP/1.0\r\n";
			$out .= "Accept: */*\r\n";
			//$out .= "Referer: $boardurl\r\n";
			$out .= "Accept-Language: zh-cn\r\n";
			$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
			$out .= "Host: $host\r\n";
			$out .= "Connection: Close\r\n";
			$out .= "Cookie: $cookie\r\n\r\n";
		}
		$fp = @fsockopen(($host ? $host : $ip), $port, $errno, $errstr, $timeout);
		if(!$fp){
			return '';
		}else{
			stream_set_blocking($fp, $block);
			stream_set_timeout($fp, $timeout);
			@fwrite($fp, $out);
			$status = stream_get_meta_data($fp);
			if(!$status['timed_out']){
				while(!feof($fp)){
					if(($header = @fgets($fp)) && ($header == "\r\n" || $header == "\n")){
						break;
					}
				}
				$stop = false;
				while(!feof($fp) && !$stop){
					$data = fread($fp, ($limit == 0 || $limit > 8192 ? 8192 : $limit));
					$return .= $data;
					if($limit){
						$limit -= strlen($data);
						$stop = $limit <= 0;
					}
				}
			}
			@fclose($fp);
			return $return;
		}
	}
	/**
	 * 初始连接ucenter时配置信息写入
	 * @param $config
	 * @return array
	 */
	function writeConfig($config){
		$rs = array('success' => false,'config'=>'');
		$content = file_get_contents($this->config_file);
		if($content){
			$content = trim($content);
			$content = substr($content, -2) == '?>' ? substr($content, 0, -2) : $content;
			$link = mysql_connect($config['dbhost'], $config['dbuser'], $config['dbpassword'], 1);
			$config['connnect'] = $link && mysql_select_db($config['dbname'], $link) ? 'mysql' : '';
			$content .= "\r\n\r\n// UCenter settings";
			$content = $this->saveConfig($content, 'UC_CONNECT', $config['connnect']);
			$content = $this->saveConfig($content, 'UC_DBHOST', $config['dbhost']);
			$content = $this->saveConfig($content, 'UC_DBUSER', $config['dbuser']);
			$content = $this->saveConfig($content, 'UC_DBPW', $config['dbpassword']);
			$content = $this->saveConfig($content, 'UC_DBNAME', $config['dbname']);
			$content = $this->saveConfig($content, 'UC_DBCHARSET', $config['dbcharset']);
			$content = $this->saveConfig($content, 'UC_DBTABLEPRE', $config['dbname'].'.'.$config['dbprefix']);
			$content = $this->saveConfig($content, 'UC_KEY', $config['authkey']);
			$content = $this->saveConfig($content, 'UC_API', $config['apiurl']);
			$content = $this->saveConfig($content, 'UC_CHARSET', $config['charset']);
			$content = $this->saveConfig($content, 'UC_IP', $config['ip']);
			$content = $this->saveConfig($content, 'UC_APPID', $config['appid']);
			$content .= "\r\n\r\n// excms file's end";
			$new_content = $this->getConfigStr($config);
			if(file_put_contents($this->config_file, $content)){
				$rs['success'] = true;
				$rs['config'] = $new_content;
			}
		}
		return $rs;
	}
	
	function getConfigStr($config){
		return "define('UC_CONNECT', '{$config['connnect']}');\n".
			"define('UC_DBHOST', '{$config['dbhost']}');\n".
			"define('UC_DBUSER', '{$config['dbuser']}');\n".
			"define('UC_DBPW', '{$config['dbpassword']}');\n".
			"define('UC_DBNAME', '{$config['dbname']}');\n".
			"define('UC_DBCHARSET', '".$config['dbname'].'.'.$config['dbprefix']."');\n".
			"define('UC_DBTABLEPRE', '{$config['dbprefix']}');\n".
			"define('UC_KEY', '{$config['authkey']}');\n".
			"define('UC_API', '{$config['apiurl']}');\n".
			"define('UC_CHARSET', '{$config['charset']}');\n".
			"define('UC_IP', '{$config['ip']}');\n".
			"define('UC_APPID', '{$config['appid']}');\n";
	}
}

// excms file's end