<?php

/**
 * Project:		EXCMS: the PHP content management system.
 * File:		index.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ucenter
 * @author $Author: zhanghaisong $
 * @version $Rev: 2292 $
 */
/* $Id: index.php 2292 2010-08-21 03:31:06Z zhanghaisong $ */

/**
 * EXCMS Ucenter模块安装程序
 */

require('../../../configuration/inc/common.inc.php');
$request_url='index.php?';

$step = (int)$_GET['step'];
$step = $step > 0 && $step < 6 ? $step : 1;
$step_params = array(
	1=>array('title'=>"欢迎",'preText'=>'不同意','nextText'=>'同意'),
	2=>array('title'=>"安装检查"),
	3=>array('title'=>"安装",'nextText'=>'安装'),
	4=>array('title'=>"完成",'nextText'=>'完成')
);
//文件或文件夹变量
$dirfile_params = array(
	'config' => array('type' => 'dir', 'path' => 'sitedata')
);
$module_config = include 'config.php';

if(!is_array($module_config) || !count($module_config)){
	exit("<title>EXCMS 警告</title><div style='font-size:12px;line-height:150%;'><font color='red' style='font-size:14px'>警告，缺失关键安装文件config.php。</font><br/>
		请确定模块install文件夹下config.php存在，再次运行本安装文件。</font>");
}
$module_array = EXCMS::getModuleCache($module_config['module_id']);
if(is_array($module_array) && count($module_array) > 0 && $step < 4 ){
	exit("<title>EXCMS 警告</title><div style='font-size:12px;line-height:150%;'><font color='red' style='font-size:14px'>警告，您已经安装过".$module_config['module_name']."。</font><br/>
		为了保证您网站的数据安全，请立即手动删除 install/index.php 文件。<br/>
		如果您想重新安装".$module_config['module_name']."，请先卸载".$module_config['module_name']."模块，再次运行本安装文件。</font>");
}

if($step > 1 && $step<5){
	$pre_button =  "<input type=\"button\" onmouseover=\"renderBtn(this)\" value=\"".(isset($step_params[$step]['preText']) ? $step_params[$step]['preText'] : '上一步')."\" onclick=\"window.location.href='".$request_url."step=".($step-1)."'\"; />";
}
$onclick ="window.location.href='".$request_url."step=".($step_params[$step]['nextStep']>0 ? $step_params[$step]['nextStep'] : ($step+1))."'";
//第一步
if($step ==1){
	if( $module_config['module_license']!='' && file_exists(dirname(__FILE__).'/'.$module_config['module_license'])){
		$license = file_get_contents(dirname(__FILE__).'/'. $module_config['module_license']);
		$license = str_replace(chr(13).chr(10),'<br>',$license);
	}
}elseif($step == 2){					//第二步
	if(is_array($module_array) && count($module_array)>0){
		$is_enable = false;
		$sp_module = '<font color=red><b>已安装</b></font>';
		$sp_module_version = $module_array['version'];
	}else{
		$is_enable = true;
		$sp_module = '<font color=red><b>未安装</b></font>';
		$sp_module_version = $module_config['module_version'];
	}
	$sp_excms = file_exists(EXCMS_PATH.'sitedata/config.inc.php') ? '<font color=red><b>已安装</b></font>' : '<font color=green><b>未安装</b></font>';	
	
	$rwable_true	= 'ico_enable';
	$rwable_false	= 'ico_disenable';
	
	foreach($dirfile_params as $d){ 
		$checkpurview .= "<tr><td>".$d['path']."</td>";
		
		$fulldir = EXCMS_PATH . $d['path'];
		$writeable = writeable($fulldir) ? $rwable_true : $rwable_false;
		$readable = is_readable($fulldir) ? $rwable_true : $rwable_false;
		
		$checkpurview .= "<td class=\"center\"><span class=\"$readable\"></span></td><td class=\"center\"><span class=\"$writeable\"></span></td></tr>";
	}
	$is_enable = $is_enable ? '' :'disabled';
	
}else if($step == 3){
	$onclick = "EXCMS.install.submit('step3form')";
}else if($step == 4){//系统配置
	$module_dir = dirname(__FILE__).'/';
	if($module_config['module_license']!='' && file_exists($module_dir.$module_config['module_license'])){
		$license = file_get_contents($module_dir. $module_config['module_license']);
	}
	$data = array(
		'moduleid' =>$module_config['module_id'],
    	'name' => $_POST['module_name'],
    	'path' => trim($module_config['module_path']),
    	'url' => $_POST['module_url'],
    	'issystem' => 0,
    	'version' => $module_config['module_version'],
        'author' => $module_config['module_author'],
        'site' => $module_config['module_site'],
        'email' => $module_config['module_email'],
        'description' => $module_config['module_description'],
        'license' => $license,
        'help' => $module_config['module_help'],
        'disabled' => 1,
        'isdisplaytop' => 1
    );
    include_once LIB_PATH . 'modules/Modules.class.php';
	$module = new Modules();
	$module->delete($module_config['module_id']);
	$install_success = $module->insert($data);	//添加模块信息
    if($install_success){
    	$msg[] = '安装模块成功';
    	$module_sql = $module_config['module_sql'];
    	if($module_sql!=''){	//添加数据库
	    	error_reporting(E_ALL || ~E_NOTICE);
	        $sql_path = $module_dir.$module_sql;
			$sql = file_get_contents($sql_path);
			$database = $module->runquery($sql);
			if($database){
				include_once LIB_PATH . 'system/SystemConfig.class.php';
				$sys = new SystemConfig();
				$sys->updateCache($module_config['module_id']);
				include_once LIB_PATH . 'system/Url.class.php';
				$url = new Url();
				$url->updateCache();
				unset($sys,$url);
			}
			$msg[] = $database ? '数据库表创建成功' : '数据库表创建失败';
    	}
    	$module_extend = $module_config['module_extend'];
    	if($module_extend!=''){	//执行扩展动作
    		require_once($module_dir.$module_extend);
    		$msg[] = '安装扩展动作成功';
    	}
    }else{
    	$msg[] =  "安装模块失败";
    }
	$onclick = "EXCMS.install.submit('step4form')";
}elseif($step==5){
	$delinstall = $_POST['delinstall'];
	if($delinstall){
		include_once LIB_PATH . 'util/FileAction.class.php';
		@unlink(EXCMS_PATH.$module_config['module_path'].'/install/index.php');
	}
}
if($step > 0 && $step<5){
	$next_button =  "<input type=\"button\" ".$is_enable." onmouseover=\"renderBtn(this)\" value=\"" . (isset($step_params[$step]['nextText']) ? $step_params[$step]['nextText'] : '下一步')."\" onclick=\"". $onclick . "\" />"; 
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title><?php echo $step_params[$step]['title'] . $module_config['module_name'];?></title>
<link rel="stylesheet" type="text/css" href="theme/install.css" />
<script language="javascript" src="install.js"></script>
</head>
<body>

<div class="header">
<div class="headerbody">
<div class="modulename"><?php echo $module_config['module_name'];?></div>
<div class="links"><a href="http://www.excms.cn" target="_blank">官方首页</a><a href="http://bbs.excms.cn" target="_blank">支持论坛</a></div>
</div>
<div class="nav">
<ul>
<?php 
foreach ($step_params as $k=>$v) {
	if($k < 1 ) continue;
	echo "<li class=\"" . ($k == $step ? "current" : '') . "\">{$v['title']}</li>";
}
?>
</ul>
</div>
</div>
<div class="body">
<div class="content">
<?php 
/**
 Install ************************************************************************************************ Step 1
*/
if($step == 1){?>
<div class="license">
<div class="stitle center"><?php echo $module_config['module_name'];?>模块用户许可协议</div>
<?php echo $license; ?>
</div>
<?php }
/**
 Install ************************************************************************************************ Step 2
*/
elseif ($step == 2){ 
?>
<div class="stitle">系统运行环境检测</div>
<div class="tip">系统环境要求必须满足下列所有条件，否则系统无法安装。</div>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="withbd">
	<tr>
		<th>需要运行的平台</th>
		<th>要求</th>
		<th>版本</th>
		<th>实际状态</th>
	</tr>
	<tr>
		<td><?php echo PRODUCT_NAME;?></td>
		<td>安装</td>
		<td>1.3 以上(含)</td>
		<td><?php echo $sp_excms.'(版本：'.PRODUCT_VERSION.')'; ?> </td>
	</tr>
	<tr>
		<td><?php echo $module_config['module_name'];?></td>
		<td>未安装</td>
		<td>1.0</td>
		<td><?php echo $sp_module.'(版本：'.$sp_module_version.')'; ?> </td>
	</tr>
</table>
<div class="stitle">目录权限检测</div>
<div class="tip">系统要求必须满足下列所有的目录权限全部可读写的需求才能使用，其它应用目录可安装后在管理后台检测。</div>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="withbd">
	<tr>
		<th>目录名</th>
		<th class="center">读取权限</th>
		<th class="center">写入权限</th>
	</tr>
<?php echo $checkpurview;?>
</table>
<?php
}
/**
 Install ************************************************************************************************ Step 3
*/
elseif ($step == 3){
?>
<form name="step3form" id="step3form" action="<?php echo $request_url; ?>step=4" method="post" act='submit'>
<div class="stitle"><?php echo $module_config['module_name'];?>配置信息</div>
<table width="100%" border="0" cellpadding="0" cellspacing="0" >
<tr><td width="80">模块ID：</td><td><? echo $module_config['module_id']; ?></td></tr>
<tr><td>名称：</td><td><input name="module_name" type="text" class="ipt" value="<? echo $module_config['module_name']; ?>" size="50" /></td></tr>
<tr><td>路径：</td><td><?php echo $module_config['module_path']; ?></td></tr>
<tr><td>访问地址：</td><td><input name="module_url" type="text" class="ipt" value="<?php echo $module_config['module_path']; ?>" size="50" /></td></tr>
<tr><td>版本：</td><td><?php echo $module_config['module_version']; ?></td></tr>
<tr><td>作者：</td><td><?php echo $module_config['module_author']; ?></td></tr>
<tr><td>官方网址：</td><td><?php echo $module_config['module_site'];?></td></tr>
<tr><td>Email：</td><td><?php echo $module_config['module_email'];?></td></tr>
<tr><td valign="top">模块简介：</td><td><?php echo $module_config['module_description']; ?></td></tr>
</table>
</form>
<?php 
}
/**
 Install ************************************************************************************************ Step 5,6,7
*/
elseif ($step == 4){
	 if(is_array($msg) && count($msg) > 0 ){
	  	echo "<div class='txt'>".implode('<br>', $msg)."</div>";
	}else{
		echo "<div class='txt'>$msg</div>";
	}
?>
<form name="step4form" id="step4form" action="<?php echo $request_url; ?>step=5" method="post" act='submit'>
<table border="0" cellpadding="0" cellspacing="0" width="200">
<tr>
<td width="100">删除安装文件：</td>
<td><label for="delinstall"><input type="radio" name="delinstall" id="delinstall" value="1" />是</label> <label for="notdelinstall"><input type="radio" name="delinstall" id="notdelinstall" value="0" checked />否</label></td>
</tr>
</table>
</form>
<?php } else{ 
	$pre_button = '<input type="button" onclick="location.href=\'' . $module_config['module_path'] . '\'" value="访问' . $module_config['module_name'] . '" />';
	$next_button = '<input type="button" onclick="location.href=\'../../../admin\'" value="后台管理" />';
?>
	<p class="success">恭喜您，您已经成功安装“<?php echo $module_config['module_name']; ?>”模块</p>
	<p class="center">您可以通过以下链接访问“<?php echo $module_config['module_name']; ?>”模块或进入后台，祝您使用EXCMS愉快! </p>
<?php }?>
</div>
<div class="buttons"><?php echo $pre_button . $next_button;?></div>
</div>

<div class="bom"><span>Powered by <a href="http://www.excms.cn" target="_blank">EXCMS</a></span></div>
</body>
</html>