<?php
/**
 * Project:		EXCMS: the PHP content management system.
 * File:		index.php
 *
 * A product of PUTOYO Inc.
 * 
 * EXCMS is a ten million data-level,high speed,human-based content management system.
 *
 * EX is Excellence & Express & Exceed & Expert.
 * 
 * For questions, help, comments, discussion, please join the
 * EXCMS mailing list. Send a blank e-mail to
 * join@excms.cn
 * or join the EXCMS forum
 * www.excms.cn/forum
 * 
 * @link http://www.excms.cn/
 * @copyright Copyright (c) 2010 PUTOYO Inc.
 * @license http://www.excms.cn/licenses/LICENSE-1.0
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 * @version $Rev: 1896 $
 */
/* $Id: index.php 1896 2010-07-18 02:02:46Z zhanghaisong $ */
/**
 * 问答用户中心
 * @category EXCMS
 * @package ask
 * @author $Author: zhanghaisong $
 */
//加载ASK系统配置文件，移动本程序时，请修改配置文件路径
require_once ('configuration/inc/common.inc.php');
$_PAGE['action'] = $_POST['action'] ? $_POST['action'] : $_GET['action'];
$action_allow = array('addquestion', 'addquestionsuccess', 'addanswer', 'noanswer', 'hidden', 'unhide', 'abandon', 'setting', 'question_action', 'append', 'vote', 'addvote', 'adopt', 'noanswer');
if($_PAGE['action'] == '' || !in_array($_PAGE['action'], $action_allow)){
	Header("HTTP/1.1 403.1 Unkonw Action");
	exit;
}

// check user logined
if(!EXCMS_SESSION_UID){
	if($ajax){
		EXCMS::json_print(EXCMS::jsonencode(array('success' => -1, 'message' => 'Login time out')));
	}else{
		$forward = $_PAGE['action'] == 'logout' ? '' : urlencode('http://' . $_SERVER['SERVER_NAME'] . ($_SERVER['SERVER_PORT'] == 80 ? '' : (':' . $_SERVER['SERVER_PORT'])) . $_SERVER['REQUEST_URI']);
		Header('location:' . EXCMS::url(array('name' => 'account.login', 'forward' => $forward)));
	}
	exit;
}

$return = array('success' => false, 'message' => '非法请求', 'url' => $_SERVER['Referer']);

switch($_PAGE['action']){
	// 隐藏回答
	case 'hidden' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateHidden($_POST['aid'], true);
		$return['message'] = $return['success'] ? '隐藏成功' : '隐藏失败';
		break;
	// 取消隐藏
	case 'unhide' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateHidden($_POST['aid'], false);
		$return['message'] = $return['success'] ? '取消隐藏成功' : '取消隐藏失败';
		break;
	// 放弃回答
	case 'abandon' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$return['success'] = $question->updateSolve(EXCMS_SESSION_UID, $_POST['qid'], false);
		$return['message'] = $return['success'] ? '已放弃回答' : '放弃回答失败';
		break;
	// 保存设置
	case 'setting' :
		$data = array('uid' => EXCMS_SESSION_UID, 'question' => $_POST['question'], 'maxrecord' => $_POST['maxrecord'], 'cid' => $_POST['cid'], 'keywords' => $_POST['keywords']);
		include_once ASK_LIB_PATH.'AskSetting.class.php';
		$setting = new AskSetting();
		$return['success'] = $setting->commit($data);
		$return['message'] = $return['success'] ? '设置成功' : Message::getMessage();
		break;
	// 补充问题
	case 'question_action' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		//补充
		if($_POST['append']){
			include_once ASK_LIB_PATH.'AskAppend.class.php'; //加载问题补充类,创建对像
			$aa = new AskAppend();
			$aa->insertSupplement(array('qid' => $_POST['qid'], 'content' => strip_tags($_POST['content'])));
			$return['success'] = $question->append($_POST['qid'], 1);
		}
		//悬赏
		if($_POST['raise_score']){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score_array = $score->getScoreByUid(EXCMS_SESSION_UID);
			if(count($score_array) > 0 && $_POST['score'] > $score_array['score']){
				$return['success'] = false;
				$return['message'] = "您当前的积分为" . $score_array['score'] . ",悬赏积分不够,请查看如何获取积分";
			}else{
				$return['success'] = $question->updateCent($_POST['qid'], $_POST['score']); //更新悬赏分
				$question->updateSolveddate($_POST['qid'], 3); //系统自动延长该问题的有效期 3天
				if($_POST['score'] > 20){
					$question->setting('createdate', $_POST['qid'], time());
				}
			}
		}
		//紧急
		if($_POST['urgent']){
			$return['success'] = $questions->updateUrgent($_POST['qid'], $_POST['urgent']);
		}
		//匿名
		if($_POST['anonymous']){
			$return['success'] = $question->updateAnonymous($_POST['qid'], $_POST['anonymous']);
		}
		$return['message'] = '设置成功';
		break;
	// 追问或补充回答
	case 'append' :
		$type = $_POST['type'] ? 1 : 0;
		include_once ASK_LIB_PATH.'AskAppend.class.php'; //加载问题补充类,创建对像
		$aa = new AskAppend();
		$aa->insertAppend(array('aid' => $_POST['aid'], 'type' => $type, 'content' => strip_tags($_POST['content'])));
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->append($_POST['aid'], 1);
		if($_POST['anonymous'] > 0){
			$return['success'] = $answer->updateAnonymous($_POST['aid'], $_POST['anonymous']);
		}
		$return['message'] = '更新成功';
		break;
	// 转入投票流程
	case 'vote' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; //加载问题类,创建问题AskQuestion对像
		$question = new AskQuestion();
		$question->updateStatus($_POST['qid'], 5); //转入投票流程
		$question->updateVoteDate($_POST['qid'], time()); //更新投票时间
		$question->updateVoteSolved($_POST['qid']); //更新解决时间
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$return['success'] = $answer->updateVote($_POST['aid'], true);
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// 添加投票
	case 'addvote' :
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		$answer->updateVotecount($_POST['aid']); //更新投票数
		include_once ASK_LIB_PATH.'AskVote.class.php';
		$vote = new AskVote();
		if(!$vote->isVote(EXCMS_SESSION_UID, $_POST['qid'])){ //检查是否已经投过票
			$data = array('qid' => (int)$_POST['qid'], 'aid' => (int)$_POST['aid'], 'uid' => (int)EXCMS_SESSION_UID);
			$vote->insert($data);
			$aidvote = $vote->groupStatVoteByQid($_POST['qid']); //根所回答ID统计分组统计投票数
			$votetotal = 0;
			if(is_array($aidvote) && count($aidvote) > 0){
				foreach($aidvote as $value){
					$votetotal += $value['total'];
					if($value['total'] >= 3) $aid = $value['aid'];
				}
			}
			$votedate = $question_array['votedate']; //投票时间
			$day = (time() - $votedate) / 86400;
			if($votetotal >= 4 && $aid > 0 && $day >= 1){ //当投票总数大于四票且票数最高的回答得票数多于 3 票,同时投票周期达到1天（24小时），则系统自动将票数最多的回答选为正确答案。
				include_once ASK_LIB_PATH.'Answer.class.php';
				$answer = new Answer();
				$answer->updateIsbast($aid, true); //采纳最佳答案
				unset($answer);
			}
			//投票成功增加积分
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			$score->scoreVote(EXCMS_SESSION_UID);
			$return['success'] = true;
			$return['message'] = '投票成功，感谢您的参与';
		}else{
			$return['message'] = '您已经参与过些问题的投票，不能重复投票';
		}
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// 采纳答案
	case 'adopt' :
		if(!$_POST['qid'] > 0){
			EXCMS::showMessage('提问ID不存在或提问已被删除');
		}
		if(!$_POST['aid'] > 0){
			EXCMS::showMessage('回答ID不存在或回答已被删除');
		}
		//加载回答类
		include_once ASK_LIB_PATH.'Answer.class.php';
		//创建回答Answer对像
		$answer = new Answer();
		//更新答案被采纳
		$return['success'] = $answer->updateIsbast($_POST['aid'], true);
		$return['message'] = '采纳答案成功';
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// 无满意答案
	case 'noanswer' :
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; //加载问题类,创建问题AskQuestion对像
		$question = new AskQuestion();
		$question_array = $question->getById($_POST['qid']);
		
		if($question_array['uid'] > 0){
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$score = new AskScore();
			if($question_array['status'] == 4){															//过期问题采纳答案还提问者10分积分
				$score->scoreExpiredDeal($question_array['uid']);
			}
			if($question_array['score'] > 0){
				$score->scoreCentQuestion($question_array['uid'], $question_array['score']); 			//更新无满意答案积分
			}
		}
		
		$question->updateSolveddate($_POST['qid'], 0, time()); 				//更新关闭时间
		$return['success'] = $question->updateStatus($_POST['qid'], 6);		//问题类型为无满意答案
		$return['message'] = '关闭问题';
		//跳转到当前问题页面
		$return['url'] = EXCMS::url(array('name' => 'ask.question', 'id' => $_POST['qid']));
		break;
	// 添加回答
	case 'addanswer' :
		// 检查验证码
		if($EXCMS_MODULE['ask']['answer_verifycode'] && !EXCMS::verifycode_check($_POST['verifycode'])){
			$return['message'] = '验证码不正确';
			EXCMS::json_print($return);
			exit;
		}
		$data = array(
			'qid' => $_POST['qid'],
			'cid' => $_POST['cid'],
			'anonymous' => 0,
			'content' => trim(strip_tags($_POST['content'])),
			'uid' => EXCMS_SESSION_UID,
			'ip' => $_SERVER['REMOTE_ADDR']
		);
		if(strlen($data['content']) < 8){
			$return['message'] = '请详细回答问题';
			EXCMS::json_print($return);
			exit;
		}
		if($data['qid'] < 1){
			$return['message'] = '提问不存在或已被删除';
			EXCMS::json_print($return);
			exit;
		}
		// 加载问题类, 创建问题AskQuestion对像
		include_once ASK_LIB_PATH . 'AskQuestion.class.php'; 
		$question = new AskQuestion();
		$question_array = $question->getById($data['qid']);
		if($question_array['uid'] == EXCMS_SESSION_UID){
			$return['message'] = '不能回答自己所提的问题';
			EXCMS::json_print($return);
			exit;
		}
		// 加载回答类，创建回答Answer对像
		include_once ASK_LIB_PATH.'Answer.class.php';
		$answer = new Answer();
		if($answer->isAnswerByQid($data['qid'], EXCMS_SESSION_UID) > 0){
			$return['message'] = '您已经回答过此问题了,不能重复回答';
			EXCMS::json_print($return);
			exit;
		}
		// 匿名回答
		if($EXCMS_MODULE['ask']['answer_anonymous_allow'] && $_POST['anonymous'] ==  1){
			$data['anonymous'] = 1;
		}
		$return['success'] = $answer->insert($data) ? 1 : 0;
		break;
		
	// 添加问题
	case 'addquestion' :
		// 验证码
		if($EXCMS_MODULE['ask']['question_verifycode'] && !EXCMS::verifycode_check($_POST['verifycode'])){
			$return['message'] = '验证码不正确';
			EXCMS::json_print($return);
			exit;
		}
		$data = array(
			'title' => trim($_POST['title']),
			'content' => trim(strip_tags($_POST['content'])),
			'cid' => (int)$_POST['category'],
			'score' => (int)$_POST['score'],
			'urgent' => $_POST['urgent'],
			'uid' => EXCMS_SESSION_UID,
			// 'directto' => $_POST['directto'],
			'anonymous' => $_POST['anonymous'],
			'ip' => $_SERVER['REMOTE_ADDR']
		);
		if(strlen($data['title']) < 8){
			$return['message'] = '请补充提问标题';
			EXCMS::json_print($return);
			exit;
		}
		if(!$data['cid'] > 0){
			$return['message'] = '请选择问题分类';
			EXCMS::json_print($return);
			exit;
		}
		if($data['score'] > 0 && $data['score'] > $_POST['totalscore']){
			// 加载问题类，创建问题AskQuestion对像
			include_once ASK_LIB_PATH.'AskScore.class.php';
			$askScore = new AskScore();
			$user_score = $askScore->getScoreByUid(EXCMS_SESSION_UID);
			if($data['score'] > $user_score['score']){
				$return['message'] = '您当前的积分为' . $user_score['score'] . '，不够悬赏积分';
				EXCMS::json_print($return);
				exit;
			}
			unset($askScore, $user_score);
		}
		// 匿名提问
		if($EXCMS_MODULE['ask']['question_anonymous_allow'] && $_POST['anonymous'] == 1){
			$data['anonymous'] = 1;
		}
		// 加载问题类，创建问题AskQuestion对像
		include_once ASK_LIB_PATH . 'AskQuestion.class.php';
		$question = new AskQuestion();
		$id = $question->insert($data);
		$return['success'] = 1;
		$return['url'] = EXCMS::url(array('name' => 'ask.action', 'action' => 'addquestionsuccess'));
		$return['url'] .= strpos($return['url'], '?') === false ? '?' : '&';
		$return['url'] .= "qid={$id}&c=0";
		break;
	// 显示提问成功消息
	case 'addquestionsuccess':
		$id = $_GET['qid'];
		if($id > 0){
			$_PAGE['question_check'] = $_GET['c'];
			$_PAGE['goto'] = $_PAGE['question_check'] == 1 ? EXCMS::url(array('name' => 'ask.myask')) : EXCMS::url(array('name' => 'ask.question', 'id' => $id));
			EXCMS::display('ask/message.html');
		}else{
			Header("HTTP/1.1 403.1 Unkonw Action");
		}
		exit;
		break;
}
EXCMS::json_print($return);

// excms file end